/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.database;

import com.unvired.sync.SyncEngine;
import com.unvired.sync.notifier.NotificationListener;

public class DBException
extends Exception {
    private static final long serialVersionUID = -207170571444136898L;
    private String className = null;
    private String methodName = null;
    private String message = null;

    public DBException(String className, String methodName, String message) {
        this.className = className;
        this.methodName = methodName;
        this.message = message;
        final NotificationListener notificationListener = SyncEngine.getInstance().getNotificationListener();
        if (notificationListener != null) {
            final DBException dbException = this;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    notificationListener.notifyException(dbException);
                }
            });
            t.start();
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        return this.message;
    }
}

