/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.database;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.database.SQLException;
import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.RuntimeEngine;
import com.unvired.database.DBException;
import com.unvired.database.DataStructureTableMapping;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.database.ITransactable;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.login.LoginParameters;
import com.unvired.model.AttachmentItem;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.FieldMeta;
import com.unvired.model.InfoMessage;
import com.unvired.model.JSAttachmentItem;
import com.unvired.model.JSDataStructure;
import com.unvired.model.OutObject;
import com.unvired.model.StructureMeta;
import com.unvired.sync.attachment.AttachmentQHelper;
import com.unvired.ui.ErrorMessageActivity;
import com.unvired.utils.DataStructureHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.ModelHelper;
import com.unvired.utils.NetworkUtil;
import com.unvired.utils.PathManager;
import com.unvired.utils.UnviredPreferences;
import com.unvired.utils.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sqlcipher.CrossProcessCursorWrapper;
import net.sqlcipher.Cursor;
import net.sqlcipher.DatabaseErrorHandler;
import net.sqlcipher.DefaultDatabaseErrorHandler;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteDatabaseHook;
import net.sqlcipher.database.SQLiteOpenHelper;
import net.sqlcipher.database.SQLiteStatement;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DataManagerImpl
implements IDataManager {
    private SQLiteDatabase database = null;
    private UnviredSQLiteOpenHelper sqliteOpenHelper = null;
    private String databaseName = null;
    private int version;
    private DataStructureTableMapping dataStructureTableMapping = null;
    private ApplicationManager applicationManager = null;
    private boolean isEmulator = false;

    public DataManagerImpl(String databaseName, int version) throws DBException {
        if (databaseName == null || databaseName.length() <= 0) {
            String error = "Database name invalid: " + databaseName;
            Logger.log(8, this.getClass().getName(), "DataManagerImpl", error);
            throw new DBException(Class.class.getName(), "Constructor", error);
        }
        this.databaseName = databaseName;
        this.version = version;
        RuntimeEngine.getInstance();
        this.dataStructureTableMapping = DataStructureTableMapping.getInstance();
        this.isEmulator = NetworkUtil.isEmulator();
        this.sqliteOpenHelper = new UnviredSQLiteOpenHelper(FrameworkHelper.applicationContext, databaseName, this.version);
    }

    @Override
    public void openOrCreate(String key) throws DBException {
        if (this.isEmulator) {
            key = "";
        }
        try (Cursor cursor = null;){
            SQLiteDatabase.loadLibs((Context)FrameworkHelper.applicationContext);
            this.database = this.sqliteOpenHelper.getWritableDatabase(key);
            this.execute("PRAGMA foreign_keys=ON;");
            cursor = this.database.rawQuery("PRAGMA quick_check", null);
            while (cursor.moveToNext()) {
                String s = cursor.getString(0);
                if ("ok".equalsIgnoreCase(s)) continue;
                throw new DBException(this.getClass().getName(), "execute", s);
            }
        }
    }

    @Override
    public boolean exists() throws DBException {
        File dbFile = FrameworkHelper.applicationContext.getDatabasePath(this.databaseName);
        try {
            return dbFile.exists();
        }
        catch (SecurityException securityException) {
            String error = "Security Exception for database: " + this.databaseName;
            Logger.e(error, securityException);
            throw new DBException(Class.class.getName(), "exists", error);
        }
    }

    @Override
    public void close() throws DBException {
        if (this.database != null) {
            this.database.close();
        }
    }

    @Override
    @Deprecated
    public void beginTransaction() throws DBException {
        Logger.log(9, this.getClass().getName(), "beginTransaction", "Transaction started.");
        this.database.beginTransaction();
    }

    @Override
    @Deprecated
    public void endTransaction() throws DBException {
        try {
            this.database.setTransactionSuccessful();
        }
        catch (Exception setTransactionSuccessfulException) {
            String error = "Exception for endTransaction: " + this.databaseName;
            Logger.e(error, setTransactionSuccessfulException);
            throw new DBException(Class.class.getName(), "endTransaction", error);
        }
        finally {
            this.database.endTransaction();
        }
        Logger.log(9, this.getClass().getName(), "commitTransaction", "Transaction committed.");
    }

    @Override
    public void dropDatabase() throws DBException {
        File dbFile = FrameworkHelper.applicationContext.getDatabasePath(this.databaseName);
        try {
            dbFile.delete();
        }
        catch (Exception databasePathException) {
            String error = "Exception caught while dropping database : " + this.databaseName;
            Logger.e(error, databasePathException);
            throw new DBException(Class.class.getName(), "dropDatabase", error);
        }
    }

    @Override
    public void dropTable(String tableName) throws DBException {
        String query = this.prepareDropTableQuery(tableName);
        Logger.log(9, Class.class.getName(), "dropTable", "Query: " + query);
        this.execute(query);
    }

    @Override
    public void dropIndex(String indexName) throws DBException {
        String query = this.prepareDropIndexQuery(indexName);
        Logger.log(9, this.getClass().getName(), "dropIndex", "Query: " + query);
        this.execute(query);
    }

    @Override
    public void createTable(String tableName, String[] columnNames, String[] columnTypes, String[] primaryKeys) throws DBException {
        this.createTable(tableName, columnNames, columnTypes, primaryKeys, null, null, null, null, null);
    }

    @Override
    public void createTable(String tableName, String[] columnNames, String[] columnTypes, String[] primaryKeys, String[] uniqueKeys) throws DBException {
        this.createTable(tableName, columnNames, columnTypes, primaryKeys, uniqueKeys, null, null, null, null);
    }

    @Override
    public void createTable(String tableName, String[] columnNames, String[] columnTypes, String[] primaryKeys, String[] uniqueKeys, boolean[] mandatoryFields, String[] foreignKeys, String foreignKeyTableName, String[] foreignKeyTableKeys) throws DBException {
        String query = this.prepareCreateQuery(tableName, columnNames, columnTypes, primaryKeys, uniqueKeys, mandatoryFields, foreignKeys, foreignKeyTableName, foreignKeyTableKeys);
        Logger.log(9, this.getClass().getName(), "createTable", "Query: " + query);
        this.execute(query);
    }

    @Override
    public void createIndex(String indexName, String structureName, String[] fieldNames) throws DBException {
        String query = this.prepareCreateIndexQuery(indexName, structureName, fieldNames);
        Logger.log(9, this.getClass().getName(), "createIndex", "Query: " + query);
        this.execute(query);
    }

    @Override
    public IDataStructure checkDuplicateGID(IDataStructure dataStructure) throws DBException {
        String tableName = dataStructure.getTableName();
        BusinessEntityMeta businessEntityMeta = ApplicationManager.getInstance().getBusinessEntityMeta(dataStructure.getBEName());
        if (!businessEntityMeta.getSAVE_BE()) {
            return null;
        }
        Object[] gidValues = dataStructure.getGids();
        String[] gidFieldNames = dataStructure.getGidFieldNames();
        if (gidFieldNames == null || gidFieldNames.length <= 0) {
            return null;
        }
        String gids = "";
        String whereClauseForDuplicate = "";
        for (int i = 0; i < gidFieldNames.length; ++i) {
            whereClauseForDuplicate = i == gidFieldNames.length - 1 ? whereClauseForDuplicate + " " + gidFieldNames[i] + " = " + "'" + gidValues[i].toString().replaceAll("'", "''") + "'" : whereClauseForDuplicate + " " + gidFieldNames[i] + " = " + "'" + gidValues[i].toString().replaceAll("'", "''") + "'" + " AND ";
            gids = gids + " - " + gidValues[i];
        }
        IDataStructure[] duplicateDataStructures = this.get(tableName, whereClauseForDuplicate);
        if (duplicateDataStructures != null && duplicateDataStructures.length > 0) {
            return duplicateDataStructures[0];
        }
        return null;
    }

    @Override
    public void insert(IDataStructure dataStructure) throws DBException {
        String tableName = dataStructure.getTableName();
        dataStructure.setTimeStamp(System.currentTimeMillis());
        Enumeration<String> keysForParameters = dataStructure.getFieldNames();
        Vector<String> fieldNames = new Vector<String>();
        while (keysForParameters.hasMoreElements()) {
            fieldNames.addElement(keysForParameters.nextElement());
        }
        int fieldCount = fieldNames.size();
        Object[] values = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = (String)fieldNames.get(i);
            values[i] = dataStructure.getField(fieldName);
        }
        String query = this.prepareInsertBindQuery(tableName, fieldNames);
        this.executeBindQuery(query, values);
    }

    @Override
    public void delete(IDataStructure dataStructure) throws DBException {
        String tableName = dataStructure.getTableName();
        String lid = dataStructure.getLid();
        String whereClause = "LID = '" + lid + "'";
        this.delete(tableName, whereClause);
    }

    @Override
    public void delete(String tableName) throws DBException {
        this.delete(tableName, null);
    }

    @Override
    public void delete(String tableName, String whereClause) throws DBException {
        String query = this.prepareDeleteQuery(tableName, whereClause);
        this.checkIfTableSupportsAttachmentsAndDelete(tableName, whereClause);
        this.execute(query);
    }

    @Override
    @Deprecated
    public void insertOrUpdateBasedOnGID(IDataStructure dataStructure) throws DBException {
        String tableName = dataStructure.getTableName();
        dataStructure.setTimeStamp(System.currentTimeMillis());
        Enumeration<String> keysForParameters = dataStructure.getFieldNames();
        Vector<String> fieldNames = new Vector<String>();
        while (keysForParameters.hasMoreElements()) {
            fieldNames.addElement(keysForParameters.nextElement());
        }
        int fieldCount = fieldNames.size();
        Object[] values = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = (String)fieldNames.get(i);
            values[i] = dataStructure.getField(fieldName);
        }
        String query = this.prepareReplaceBindQuery(tableName, fieldNames);
        this.executeBindQuery(query, values);
    }

    @Override
    public void update(IDataStructure dataStructure) throws DBException {
        if (!OutObject.TABLE_NAME.equals(dataStructure.getTableName())) {
            dataStructure.setTimeStamp(System.currentTimeMillis());
        }
        String tableName = dataStructure.getTableName();
        String lid = dataStructure.getLid();
        String whereClause = "LID = '" + lid + "'";
        Enumeration<String> keysForParameters = dataStructure.getFieldNames();
        Vector<String> fieldNames = new Vector<String>();
        while (keysForParameters.hasMoreElements()) {
            String fieldName = keysForParameters.nextElement();
            if ("LID".equalsIgnoreCase(fieldName)) continue;
            fieldNames.addElement(fieldName);
        }
        int fieldCount = fieldNames.size();
        String[] columnNames = new String[fieldCount];
        Object[] columnValues = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName;
            columnNames[i] = fieldName = (String)fieldNames.get(i);
            columnValues[i] = dataStructure.getField(fieldName);
        }
        this.update(tableName, columnNames, columnValues, whereClause);
    }

    @Override
    public void update(String tableName, String[] columnNames, Object[] columnValues, String whereClause) throws DBException {
        String query = this.prepareUpdateBindQuery(tableName, columnNames, whereClause);
        this.executeBindQuery(query, columnValues);
    }

    @Override
    public IDataStructure[] get(String tableName) throws DBException {
        return this.get(tableName, "");
    }

    @Override
    public IDataStructure[] get(String tableName, String whereClause) throws DBException {
        String query = this.prepareSelectQuery(tableName, whereClause, null, null);
        android.database.Cursor cursorToFormDataStructure = this.executeQuery(query);
        IDataStructure[] dataStructure = this.getDataStructuresFromCursor(tableName, cursorToFormDataStructure, null);
        return dataStructure;
    }

    @Override
    public IDataStructure[] get(String tableName, Class className) throws DBException {
        return this.get(tableName, null, null, className);
    }

    @Override
    public IDataStructure[] get(String tableName, String whereClause, Class className) throws DBException {
        return this.get(tableName, whereClause, null, className);
    }

    @Override
    public <T> List<T> getTypedDS(String tableName, String whereClause, String[] orderByFields, Class className) throws DBException {
        String query = this.prepareSelectQuery(tableName, whereClause, orderByFields, null);
        android.database.Cursor cursorToFormDataStructure = this.executeQuery(query);
        return this.getObjectsFromCursorTypedDS(tableName, cursorToFormDataStructure, className);
    }

    @SuppressLint(value={"NewApi"})
    private <T> List<T> getObjectsFromCursorTypedDS(String tableName, android.database.Cursor cursor, Class className) throws DBException {
        ArrayList tempDataStructures = new ArrayList();
        CrossProcessCursorWrapper sqliteCursor = (CrossProcessCursorWrapper)cursor;
        try {
            while (sqliteCursor.moveToNext()) {
                if (className == null) {
                    String tempClassName = this.dataStructureTableMapping.getClassName(tableName);
                    className = Class.forName(tempClassName);
                }
                Object tempDataStructure = className.newInstance();
                String[] columnNames = sqliteCursor.getColumnNames();
                Object[] columnValues = new Object[columnNames.length];
                block14: for (int i = 0; i < columnNames.length; ++i) {
                    int sqlType = sqliteCursor.getType(i);
                    switch (sqlType) {
                        case 0: {
                            continue block14;
                        }
                        case 4: {
                            columnValues[i] = sqliteCursor.getBlob(i);
                            continue block14;
                        }
                        case 1: {
                            columnValues[i] = sqliteCursor.getLong(i);
                            continue block14;
                        }
                        case 3: {
                            columnValues[i] = sqliteCursor.getString(i);
                            continue block14;
                        }
                        case 2: {
                            columnValues[i] = sqliteCursor.getDouble(i);
                            continue block14;
                        }
                    }
                }
                this.populateObjectTypedDS(tempDataStructure, columnNames, columnValues);
                tempDataStructures.add(tempDataStructure);
            }
        }
        catch (SQLException sqlException) {
            String error = "SQLException. Table name: " + tableName + "Exception: " + sqlException.getMessage();
            Logger.e(error, (Exception)((Object)sqlException));
            throw new DBException(Class.class.getName(), "getObjectsFromCursor", error);
        }
        catch (Exception exception) {
            String error = "Exception. Table name: " + tableName + "Exception: " + exception.getMessage();
            Logger.e(error, exception);
            throw new DBException(Class.class.getName(), "getObjectsFromCursor", error);
        }
        finally {
            cursor.close();
        }
        return tempDataStructures;
    }

    private <T> void populateObjectTypedDS(T dataStructure, String[] columnNames, Object[] columnValues) throws Exception {
        int noOfColumns = columnNames.length;
        for (int i = 0; i < noOfColumns; ++i) {
            try {
                IDataStructure ds = (IDataStructure)dataStructure;
                if (columnValues[i] instanceof byte[]) {
                    byte[] bytes = (byte[])columnValues[i];
                    byte[] uncompressed = this.uncompressBytes(bytes);
                    ds.setField(columnNames[i], uncompressed);
                    continue;
                }
                ds.setField(columnNames[i], columnValues[i]);
                continue;
            }
            catch (Exception e) {
                String error = "Error while populating object " + dataStructure.getClass().getName() + " Exception: " + e.getMessage();
                Logger.e(error, e);
            }
        }
    }

    private static Method getMethod(Class<? extends Object> class1, String methodName) {
        if (class1 != null) {
            Method[] methods;
            for (Method method : methods = class1.getMethods()) {
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method;
            }
        }
        return null;
    }

    @Override
    public IDataStructure[] get(String tableName, String[] orderByFields) throws DBException {
        return this.get(tableName, null, orderByFields, null, null);
    }

    @Override
    public IDataStructure[] get(String tableName, String[] orderByFields, IDataManager.ORDER_TYPE orderType) throws DBException {
        return this.get(tableName, null, orderByFields, null, orderType);
    }

    @Override
    public IDataStructure[] get(String tableName, String whereClause, String[] orderByFields) throws DBException {
        return this.get(tableName, whereClause, orderByFields, null, null);
    }

    @Override
    public IDataStructure[] get(String tableName, String whereClause, String[] orderByFields, IDataManager.ORDER_TYPE orderType) throws DBException {
        return this.get(tableName, whereClause, orderByFields, null, orderType);
    }

    @Override
    public IDataStructure[] get(String tableName, String[] orderByFields, Class className) throws DBException {
        return this.get(tableName, null, orderByFields, className);
    }

    @Override
    public IDataStructure[] get(String tableName, String whereClause, String[] orderByFields, Class className) throws DBException {
        String query = this.prepareSelectQuery(tableName, whereClause, orderByFields, null);
        android.database.Cursor cursorToFormDataStructure = this.executeQuery(query);
        IDataStructure[] dataStructures = this.getDataStructuresFromCursor(tableName, cursorToFormDataStructure, className);
        return dataStructures;
    }

    public IDataStructure[] get(String tableName, String whereClause, String[] orderByFields, Class className, IDataManager.ORDER_TYPE orderType) throws DBException {
        String query = this.prepareSelectQuery(tableName, whereClause, orderByFields, orderType);
        android.database.Cursor cursorToFormDataStructure = this.executeQuery(query);
        IDataStructure[] dataStructures = this.getDataStructuresFromCursor(tableName, cursorToFormDataStructure, className);
        return dataStructures;
    }

    @Override
    public IDataStructure getBasedOnGID(IDataStructure dataStructure) throws DBException {
        String tableName = dataStructure.getTableName();
        Object[] gidValues = dataStructure.getGids();
        String[] gidFieldNames = dataStructure.getGidFieldNames();
        if (gidFieldNames.length <= 0) {
            return null;
        }
        String gids = "";
        String whereClauseForDataStructureBasedOnGID = "";
        for (int i = 0; i < gidFieldNames.length; ++i) {
            whereClauseForDataStructureBasedOnGID = i == gidFieldNames.length - 1 ? whereClauseForDataStructureBasedOnGID + " " + gidFieldNames[i] + " = " + "'" + gidValues[i].toString().replaceAll("'", "''") + "'" : whereClauseForDataStructureBasedOnGID + " " + gidFieldNames[i] + " = " + "'" + gidValues[i].toString().replaceAll("'", "''") + "'" + " AND ";
            gids = gids + " - " + gidValues[i];
        }
        IDataStructure[] dataStructuresBasedOnGID = this.get(tableName, whereClauseForDataStructureBasedOnGID);
        if (dataStructuresBasedOnGID != null && dataStructuresBasedOnGID.length > 0) {
            return dataStructuresBasedOnGID[0];
        }
        return null;
    }

    @Override
    public IDataStructure[] getChildren(String tableName, IDataStructure headerDataStructure) throws DBException {
        String whereClause = "FID = '" + headerDataStructure.getLid() + "'";
        IDataStructure[] children = this.get(tableName, whereClause);
        return children;
    }

    @Override
    public IDataStructure[] getChildren(String tableName, String whereClause, String[] orderByFields, IDataStructure headerDataStructure) throws DBException {
        Logger.log(9, this.getClass().getName(), "getChildren", "Table name: " + tableName + ", whereclause: " + whereClause);
        whereClause = Strings.isNullOrEmpty((String)whereClause) ? "FID = '" + headerDataStructure.getLid() + "'" : whereClause + " AND " + "FID" + " = '" + headerDataStructure.getLid() + "'";
        IDataStructure[] children = this.get(tableName, whereClause, orderByFields);
        return children;
    }

    @Override
    public IDataStructure[] getChildren(String tableName, String[] orderByFields, IDataStructure headerDataStructure) throws DBException {
        String whereClause = "FID = '" + headerDataStructure.getLid() + "'";
        IDataStructure[] children = this.get(tableName, whereClause, orderByFields);
        return children;
    }

    @Override
    public Hashtable<String, IDataStructure[]> getAllChildren(IDataStructure headerDataStructure) throws DBException {
        Hashtable<String, IDataStructure[]> allChildren = new Hashtable<String, IDataStructure[]>();
        String[] childrenTableNames = headerDataStructure.getChildrenTableNames();
        IDataStructure[] children = null;
        for (int i = 0; i < childrenTableNames.length; ++i) {
            children = this.getChildren(childrenTableNames[i], headerDataStructure);
            if (children == null || children.length <= 0) continue;
            allChildren.put(childrenTableNames[i], children);
        }
        return allChildren;
    }

    @Override
    public int count(String tableName, String whereClause) throws DBException {
        String query = null;
        query = whereClause == null || whereClause.length() <= 0 ? "SELECT COUNT(*) FROM " + tableName : "SELECT COUNT(*) FROM " + tableName + " WHERE " + whereClause;
        try (android.database.Cursor cursor = this.executeQuery(query);){
            cursor.moveToFirst();
            int n = cursor.getInt(0);
            return n;
        }
    }

    @Override
    public Object max(String tableName, String fieldName, String whereClause) throws DBException {
        String query = null;
        query = Strings.isNullOrEmpty((String)whereClause) ? "SELECT MAX(" + fieldName + ") FROM " + tableName : "SELECT MAX(" + fieldName + ") FROM " + tableName + " WHERE " + whereClause;
        try (android.database.Cursor cursor = this.executeQuery(query);){
            cursor.moveToFirst();
            Integer n = cursor.getInt(0);
            return n;
        }
    }

    @Override
    public Object min(String tableName, String fieldName, String whereClause) throws DBException {
        String query = null;
        query = Strings.isNullOrEmpty((String)whereClause) ? "SELECT MIN(" + fieldName + ") FROM " + tableName : "SELECT MIN(" + fieldName + ") FROM " + tableName + " WHERE " + whereClause;
        try (android.database.Cursor cursor = this.executeQuery(query);){
            cursor.moveToFirst();
            Integer n = cursor.getInt(0);
            return n;
        }
    }

    @Override
    public Object total(String tableName, String fieldName, String whereClause) throws DBException {
        String query = null;
        query = Strings.isNullOrEmpty((String)whereClause) ? "SELECT TOTAL(" + fieldName + ") FROM " + tableName : "SELECT TOTAL(" + fieldName + ") FROM " + tableName + " WHERE " + whereClause;
        try (android.database.Cursor cursor = this.executeQuery(query);){
            cursor.moveToFirst();
            Integer n = cursor.getInt(0);
            return n;
        }
    }

    @Override
    public void execute(String sqlStatement) throws DBException {
        Logger.log(9, this.getClass().getName(), "execute", "Query: " + sqlStatement);
        try {
            this.database.execSQL(sqlStatement);
            System.out.println("\n" + sqlStatement);
        }
        catch (Exception sqlException) {
            String error = "Exception caught while executing SQLStatement: " + sqlStatement + " Exception: " + sqlException.getMessage();
            Logger.e(error, sqlException);
            throw new DBException(Class.class.getName(), "execute", error);
        }
    }

    @Override
    public void executeBindQuery(String query, Object[] columnValues) throws DBException {
        Logger.log(9, this.getClass().getName(), "executeBindQuery", "Query: " + query);
        try (SQLiteStatement statement = this.compileStatement(query);){
            for (int i = 0; i < columnValues.length; ++i) {
                if (columnValues[i] == null) {
                    statement.bindNull(i + 1);
                    continue;
                }
                if (columnValues[i] instanceof String) {
                    statement.bindString(i + 1, (String)columnValues[i]);
                    continue;
                }
                if (columnValues[i] instanceof Integer) {
                    statement.bindLong(i + 1, (long)((Integer)columnValues[i]).intValue());
                    continue;
                }
                if (columnValues[i] instanceof Long) {
                    statement.bindLong(i + 1, ((Long)columnValues[i]).longValue());
                    continue;
                }
                if (columnValues[i] instanceof Float) {
                    statement.bindDouble(i + 1, (double)((Float)columnValues[i]).floatValue());
                    continue;
                }
                if (columnValues[i] instanceof Double) {
                    statement.bindDouble(i + 1, ((Double)columnValues[i]).doubleValue());
                    continue;
                }
                if (!(columnValues[i] instanceof byte[])) continue;
                byte[] bytes = (byte[])columnValues[i];
                byte[] compressedBytes = this.compressBytes(bytes);
                statement.bindBlob(i + 1, compressedBytes);
            }
            statement.execute();
            statement.clearBindings();
        }
    }

    @Override
    public android.database.Cursor executeQuery(String sqlStatement) throws DBException {
        Logger.log(9, this.getClass().getName(), "executeQuery", "Query: " + sqlStatement);
        try {
            return this.database.rawQuery(sqlStatement, null);
        }
        catch (Exception sqlException) {
            String error = "Exception caught while executing SQLStatement: " + sqlStatement + " Exception: " + sqlException.getMessage();
            Logger.e(error, sqlException);
            throw new DBException(Class.class.getName(), "executeQuery", error);
        }
    }

    private SQLiteStatement compileStatement(String sqlStatement) throws DBException {
        try {
            return this.database.compileStatement(sqlStatement);
        }
        catch (Exception sqlException) {
            String error = "Exception caught while compiling SQLStatement: " + sqlStatement + " Exception: " + sqlException.getMessage();
            Logger.e(error, sqlException);
            throw new DBException(Class.class.getName(), "compileStatement", error);
        }
    }

    private String prepareCreateQuery(String tableName, String[] tableColumnNames, Object[] tableColumnTypes, String[] primaryKeys, String[] uniqueKeys, boolean[] mandatoryFields, String[] foreignKeys, String foreignKeyTableName, String[] foreignKeyTableKeys) {
        int i;
        String query = "";
        String primaryKey = "";
        String uniqueKey = "";
        String foreignKey = "";
        String foreignKeyTableKey = "";
        if (primaryKey != null) {
            for (i = 0; i < primaryKeys.length; ++i) {
                primaryKey = i == 0 ? primaryKey + primaryKeys[i] : primaryKey + ", " + primaryKeys[i];
            }
        }
        if (uniqueKeys != null) {
            for (i = 0; i < uniqueKeys.length; ++i) {
                uniqueKey = i == 0 ? uniqueKey + uniqueKeys[i] : uniqueKey + ", " + uniqueKeys[i];
            }
        }
        if (foreignKeyTableName != null) {
            for (i = 0; i < foreignKeys.length; ++i) {
                foreignKey = i == 0 ? foreignKey + foreignKeys[i] : foreignKey + ", " + foreignKeys[i];
            }
            for (i = 0; i < foreignKeyTableKeys.length; ++i) {
                foreignKeyTableKey = i == 0 ? foreignKeyTableKey + foreignKeyTableKeys[i] : foreignKeyTableKey + ", " + foreignKeyTableKeys[i];
            }
        }
        int noOfColumns = 0;
        if (tableColumnNames != null) {
            noOfColumns = tableColumnNames.length;
        }
        query = "CREATE TABLE '" + tableName + "' (";
        for (int i2 = 0; i2 < noOfColumns; ++i2) {
            boolean isMandatory;
            query = i2 == 0 ? query + "'" + tableColumnNames[i2] + "' " : query + ", '" + tableColumnNames[i2] + "' ";
            if (tableColumnTypes != null) {
                try {
                    query = query + tableColumnTypes[i2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    String error = "ArrayIndexOutOfBoundsException caught while preparing SQLStatement: " + query + " Exception: " + arrayIndexOutOfBoundsException.getMessage();
                    Logger.e(error, arrayIndexOutOfBoundsException);
                    new DBException(Class.class.getName(), "prepareCreateQuery : CreateTable", error);
                }
            }
            if (mandatoryFields == null || !(isMandatory = mandatoryFields[i2])) continue;
            query = query + " NOT NULL";
        }
        if (!Strings.isNullOrEmpty((String)primaryKey)) {
            query = query + ", PRIMARY KEY(" + primaryKey + ")";
        }
        if (!Strings.isNullOrEmpty((String)uniqueKey)) {
            query = query + ", UNIQUE(" + uniqueKey + ")";
        }
        if (!Strings.isNullOrEmpty((String)foreignKeyTableName)) {
            query = query + ", FOREIGN KEY(" + foreignKey + ") REFERENCES " + foreignKeyTableName + "(" + foreignKeyTableKey + ")" + "ON UPDATE CASCADE ON DELETE CASCADE";
        }
        query = query + ")";
        Logger.log(9, this.getClass().getName(), "prepareCreateQuery", query);
        return query;
    }

    private String prepareCreateIndexQuery(String indexName, String structureName, String[] fieldNames) {
        String query = "";
        query = "CREATE INDEX " + indexName + " ON " + structureName + "(";
        for (int i = 0; i < fieldNames.length; ++i) {
            query = i == 0 ? query + fieldNames[i] : query + ", " + fieldNames[i];
        }
        query = query + ")";
        return query;
    }

    private String prepareInsertBindQuery(String tableName, Vector<String> tableColumnNames) {
        String query = "";
        int noOfColumns = 0;
        if (tableColumnNames != null) {
            noOfColumns = tableColumnNames.size();
        }
        query = "INSERT INTO " + tableName + " (";
        for (int i = 0; i < noOfColumns; ++i) {
            String key = tableColumnNames.elementAt(i);
            query = query + key + ",";
        }
        int queryLength = query.length();
        char[] queryChar = query.toCharArray();
        queryChar[queryLength - 1] = 41;
        query = String.valueOf(queryChar);
        query = query + " VALUES (";
        String value = "";
        for (int i = 0; i < noOfColumns; ++i) {
            value = value.equalsIgnoreCase("") ? value + "?" : value + ", " + "?";
        }
        query = query + value + ")";
        Logger.log(9, this.getClass().getName(), "prepareInsertBindQuery", query);
        return query;
    }

    private String prepareDropTableQuery(String tableName) {
        String query = "DROP TABLE " + tableName;
        Logger.log(9, this.getClass().getName(), "prepareDropTableQuery", query);
        return query;
    }

    private String prepareDropIndexQuery(String indexName) {
        String query = "";
        query = query + "DROP INDEX " + indexName;
        return query;
    }

    private String prepareSelectQuery(String tableName, String whereClause, String[] orderByFields, IDataManager.ORDER_TYPE orderType) {
        String query = "SELECT * FROM " + tableName + " ";
        if (!Strings.isNullOrEmpty((String)whereClause)) {
            query = query + "WHERE " + whereClause;
        }
        if (orderByFields != null && orderByFields.length > 0) {
            query = query + " ORDER BY ";
            for (int i = 0; i < orderByFields.length; ++i) {
                query = i == orderByFields.length - 1 ? query + orderByFields[i] : query + orderByFields[i] + ", ";
            }
            query = orderType == null || orderType.equals((Object)IDataManager.ORDER_TYPE.ASC) ? query + " COLLATE NOCASE ASC " : query + " COLLATE NOCASE DESC ";
        }
        return query;
    }

    private String prepareDeleteQuery(String tableName, String whereClause) {
        String query = "DELETE FROM " + tableName + " ";
        if (!Strings.isNullOrEmpty((String)whereClause)) {
            query = query + "WHERE " + whereClause;
        }
        Logger.log(9, this.getClass().getName(), "prepareDeleteQuery", query);
        return query;
    }

    private String prepareUpdateBindQuery(String tableName, String[] tableColumnNames, String whereClause) {
        String query = "";
        int noOfColumns = 0;
        if (tableColumnNames != null) {
            noOfColumns = tableColumnNames.length;
        }
        query = "UPDATE " + tableName + " SET ";
        for (int i = 0; i < noOfColumns; ++i) {
            query = i == 0 ? query + tableColumnNames[i] + " = ? " : query + " , " + tableColumnNames[i] + " = ? ";
        }
        if (!Strings.isNullOrEmpty((String)whereClause)) {
            query = query + " WHERE " + whereClause;
        }
        Logger.log(9, this.getClass().getName(), "prepareUpdateBindQuery", query);
        return query;
    }

    private String prepareReplaceBindQuery(String tableName, Vector<String> tableColumnNames) {
        String query = "";
        int noOfColumns = 0;
        if (tableColumnNames != null) {
            noOfColumns = tableColumnNames.size();
        }
        query = "REPLACE INTO " + tableName + " (";
        for (int i = 0; i < noOfColumns; ++i) {
            String key = tableColumnNames.elementAt(i);
            query = query + key + ",";
        }
        int queryLength = query.length();
        char[] queryChar = query.toCharArray();
        queryChar[queryLength - 1] = 41;
        query = String.valueOf(queryChar);
        query = query + " VALUES (";
        String value = "";
        for (int i = 0; i < noOfColumns; ++i) {
            value = value.equalsIgnoreCase("") ? value + "?" : value + ", " + "?";
        }
        query = query + value + ")";
        Logger.log(9, this.getClass().getName(), "prepareReplaceBindQuery", query);
        return query;
    }

    private IDataStructure[] getDataStructuresFromCursor(String tableName, android.database.Cursor cursor, Class<IDataManager> className) throws DBException {
        int i;
        if (RuntimeEngine.getInstance().isHTML5Framework()) {
            return this.getDataStructuresFromCursor(tableName, cursor);
        }
        Vector<IDataStructure> tempDataStructures = new Vector<IDataStructure>();
        IDataStructure tempDataStructure = null;
        CrossProcessCursorWrapper sqliteCursor = (CrossProcessCursorWrapper)cursor;
        try {
            while (sqliteCursor.moveToNext()) {
                if (RuntimeEngine.getInstance().isHTML5Framework()) {
                    StructureMeta structureMeta;
                    if (this.applicationManager == null) {
                        this.applicationManager = ApplicationManager.getInstance();
                    }
                    if ((structureMeta = this.applicationManager.getStructureMeta(tableName)) == null) {
                        this.getDataStructuresFromCursor(tableName, cursor);
                    }
                    tempDataStructure = !structureMeta.getIsHeader() && tableName.toLowerCase().endsWith("_attachment") ? new AttachmentItem(tableName) : new JSDataStructure(tableName, structureMeta.getIsHeader());
                } else {
                    if (className == null) {
                        String tempClassName = this.dataStructureTableMapping.getClassName(tableName);
                        className = Class.forName(tempClassName);
                    }
                    tempDataStructure = (IDataStructure)Class.forName(className.getName()).newInstance();
                }
                String[] columnNames = sqliteCursor.getColumnNames();
                Object[] columnValues = new Object[columnNames.length];
                for (i = 0; i < columnNames.length; ++i) {
                    String sqlType = tempDataStructure.getFieldType(columnNames[i]);
                    if (sqlType == null || sqlType.length() <= 0) {
                        throw new DBException(this.getClass().getName(), "getDataStructuresFromCursor", "NO SQLTYPE FOUND : TABLE-NAME: " + tableName + ", COLUMN-NAME: " + columnNames[i]);
                    }
                    if (sqlType.equalsIgnoreCase("BLOB")) {
                        columnValues[i] = sqliteCursor.getBlob(i);
                        continue;
                    }
                    if (sqlType.equalsIgnoreCase("INTEGER")) {
                        columnValues[i] = sqliteCursor.getLong(i);
                        continue;
                    }
                    if (sqlType.equalsIgnoreCase("REAL")) {
                        columnValues[i] = sqliteCursor.getDouble(i);
                        continue;
                    }
                    if (sqlType.equalsIgnoreCase("TEXT")) {
                        columnValues[i] = sqliteCursor.getString(i);
                        continue;
                    }
                    throw new DBException(this.getClass().getName(), "getDataStructuresFromCursor", "INVALID SQLTYPE FOUND : TABLE-NAME: " + tableName + ", COLUMN-NAME: " + columnNames[i]);
                }
                this.populateDataStructure(tempDataStructure, columnNames, columnValues);
                tempDataStructures.addElement(tempDataStructure);
            }
        }
        catch (SQLException sqlException) {
            String error = "SQLException caught. Table name: " + tableName + " Exception: " + sqlException.getMessage();
            Logger.e(error, (Exception)((Object)sqlException));
            throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "SQLException caught while creating datastructure, " + sqlException.getMessage());
        }
        catch (Exception exception) {
            String error = "Exception caught. Table name: " + tableName + " Exception: " + exception.getMessage();
            Logger.e(error, exception);
            throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "Exception caught while creating datastructure, " + exception.getMessage());
        }
        finally {
            cursor.close();
        }
        int size = tempDataStructures.size();
        if (size == 0) {
            return null;
        }
        IDataStructure[] dataStructures = new IDataStructure[size];
        for (i = 0; i < size; ++i) {
            dataStructures[i] = (IDataStructure)tempDataStructures.elementAt(i);
        }
        return dataStructures;
    }

    private void populateDataStructure(IDataStructure dataStructure, String[] columnNames, Object[] columnValues) throws DBException {
        int noOfColumns = columnNames.length;
        for (int i = 0; i < noOfColumns; ++i) {
            if (columnValues[i] instanceof byte[]) {
                byte[] bytes = (byte[])columnValues[i];
                byte[] uncompressed = this.uncompressBytes(bytes);
                dataStructure.setField(columnNames[i], uncompressed);
                continue;
            }
            dataStructure.setField(columnNames[i], columnValues[i]);
        }
        dataStructure.setModifiedFlag(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] compressBytes(byte[] data) {
        String error;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipStream = null;
        try {
            gzipStream = new GZIPOutputStream(baos);
            gzipStream.write(data);
        }
        catch (IOException ioException) {
            error = "IOException caught while compressing bytes. Exception: " + ioException.getMessage();
            Logger.e(error, ioException);
            new DBException(Class.class.getName(), "compressBytes", error);
        }
        finally {
            try {
                gzipStream.close();
            }
            catch (IOException ioException) {
                error = "IOException caught while closing the GZIPOutputStream. Exception: " + ioException.getMessage();
                Logger.e(error, ioException);
                new DBException(Class.class.getName(), "compressBytes", error);
            }
        }
        return baos.toByteArray();
    }

    private byte[] uncompressBytes(byte[] data) throws DBException {
        GZIPInputStream gin = null;
        try {
            gin = new GZIPInputStream(new ByteArrayInputStream(data));
        }
        catch (IOException ioException) {
            String error = "IOException caught while uncompressing bytes. Exception: " + ioException.getMessage();
            Logger.e(error, ioException);
            throw new DBException(Class.class.getName(), "uncompressBytes", "IOException caught while creating GZIPInputStream object, " + ioException.getMessage());
        }
        return DataManagerImpl.getString(gin).getBytes();
    }

    public static String getString(InputStream inputStream) throws DBException {
        if (inputStream == null) {
            throw new DBException(Class.class.getName(), "getString", "InputStream found as null.");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException ioException) {
            String error = "IOException caught while reading data. Exception: " + ioException.getMessage();
            Logger.e(error, ioException);
            throw new DBException(FrameworkHelper.class.getName(), "getString", error);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ioException) {
                String error = "IOException caught while closing stream. Exception: " + ioException.getMessage();
                Logger.e(error, ioException);
                throw new DBException(FrameworkHelper.class.getName(), "getString", error);
            }
        }
        return sb.toString();
    }

    private void checkIfTableSupportsAttachmentsAndDelete(String tableName, String whereClause) throws DBException {
        this.applicationManager = ApplicationManager.getInstance();
        StructureMeta structureMeta = this.applicationManager.getStructureMeta(tableName);
        if (structureMeta != null) {
            IDataStructure[] headerDataStructures = this.get(tableName, whereClause);
            IDataStructure header = null;
            if (structureMeta.getIsHeader()) {
                if (headerDataStructures != null && headerDataStructures.length > 0) {
                    header = headerDataStructures[0];
                    String beName = header.getBEName();
                    try {
                        if (!this.applicationManager.isAttachmentSupported(beName)) {
                            return;
                        }
                    }
                    catch (ApplicationException e) {
                        String error = "ApplicationException while checking if BE : " + beName + " supports attachments" + e.getMessage();
                        Logger.e(error, e);
                        return;
                    }
                    for (int i = 0; i < headerDataStructures.length; ++i) {
                        header = headerDataStructures[i];
                        AttachmentItem[] items = this.getAttachments(header);
                        if (items == null) continue;
                        int j = 0;
                        while (j < items.length) {
                            AttachmentItem attachmentItem = items[j++];
                            try {
                                String uid = attachmentItem.getUid();
                                AttachmentQHelper.getInstance().deleteIfQueuedForDownload(uid);
                            }
                            catch (DBException e) {
                                String error = "DBException while deleting Attachment Item from the attachment q: " + e.getMessage();
                                Logger.e(error, e);
                            }
                            attachmentItem.delete();
                        }
                    }
                }
            } else if (headerDataStructures != null && headerDataStructures.length > 0 && headerDataStructures[0] instanceof AttachmentItem) {
                AttachmentItem attachmentItem = (AttachmentItem)headerDataStructures[0];
                attachmentItem.delete();
            }
        }
    }

    private AttachmentItem[] getAttachments(IDataStructure header) {
        IDataStructure[] dataStructures = null;
        try {
            IDataManager applicationDataManager = ApplicationManager.getInstance().getDataManager();
            String beName = header.getBEName();
            String attachmentStructName = beName + "_ATTACHMENT";
            dataStructures = applicationDataManager.getChildren(attachmentStructName, null, null, header);
            if (dataStructures == null) {
                String whereClause = "FID = '" + header.getLid() + "'";
                dataStructures = applicationDataManager.get(attachmentStructName, whereClause);
            }
        }
        catch (DBException e) {
            String error = "DBException caught while retrieving attachment items for header: " + header.getTableName() + e.getMessage();
            Logger.e(error, e);
        }
        if (dataStructures == null || dataStructures.length == 0) {
            Logger.log(9, this.getClass().getName(), "getAttachments", "dataStructures is null, while checking if the DataStructure in question supports attachments and if it has one");
            return null;
        }
        AttachmentItem[] items = new AttachmentItem[dataStructures.length];
        System.arraycopy(dataStructures, 0, items, 0, dataStructures.length);
        return items;
    }

    @Override
    public void rollbackToSavepoint(String savePointName) throws DBException {
        String query = "ROLLBACK TRANSACTION TO SAVEPOINT " + savePointName;
        Logger.log(9, Class.class.getName(), "rollbackToSavepoint", "Query: " + query);
        this.execute(query);
    }

    @Override
    public void releaseSavepoint(String savePointName) throws DBException {
        String query = "RELEASE SAVEPOINT " + savePointName;
        Logger.log(9, Class.class.getName(), "releaseSavepoint", "Query: " + query);
        this.execute(query);
    }

    @Override
    public void createSavepoint(String savePointName) throws DBException {
        String query = "SAVEPOINT " + savePointName;
        Logger.log(9, Class.class.getName(), "createSavepoint", "Query: " + query);
        this.execute(query);
    }

    private void createAndSaveInfoMessage(String message) {
        InfoMessage infoMessage = new InfoMessage();
        infoMessage.setCategory("FAILURE");
        infoMessage.setMessage("Message:" + message);
        try {
            FrameworkManager.getInstance().getDataManager().insert(infoMessage);
        }
        catch (DBException e) {
            Logger.e("DBException caught while inserting Info Message: ", e);
        }
    }

    private void removeUnviredPreferences(Context context) {
        UnviredPreferences unviredPreferences = new UnviredPreferences(context, "UNV_PREF_KEY", "dFS!?CMiPBuhi$^Ycz/=", true);
        unviredPreferences.removeValue("LOGIN_TYPE");
        unviredPreferences.removeValue("URL");
        unviredPreferences.removeValue("USER_ID");
        unviredPreferences.removeValue("PASSWORD");
        unviredPreferences.removeValue("PASSWORDMD5");
        unviredPreferences.removeValue("ADS_DOMAIN");
        unviredPreferences.removeValue("COMPANY");
        unviredPreferences.clear();
    }

    @Override
    public void printDBSize() {
        this.database.execSQL("VACUUM");
        String size = "DB  Max Size :" + this.database.getMaximumSize() + "  Cache Size :" + this.database.getMaxSqlCacheSize() + " Page Size: " + this.database.getPageSize();
        Logger.log(7, this.getClass().getName(), "printDBSize", size);
        File f = new File(PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.APP_DB_FILE));
        if (f.exists()) {
            Logger.log(7, this.getClass().getName(), "printDBSize", "APP DB Space :  *******" + f.length() + "*******  Total Space  :" + f.getTotalSpace() + " Free Space :" + f.getFreeSpace());
        }
    }

    @Deprecated
    public synchronized void executeTransaction(ITransactable callback) throws DBException {
        Logger.log(9, Class.class.getName(), "executeTransaction", "Execute transaction starts.");
        try {
            this.beginTransaction();
            boolean successful = callback.transaction(this);
            if (successful) {
                this.endTransaction();
            }
        }
        catch (Throwable throwable) {
            Logger.log(8, Class.class.getName(), "executeTransaction", "Throwable exception caught while executing transaction, " + throwable.getMessage());
            throw new DBException(Class.class.getName(), "executeTransaction", "Throwable exception caught while executing transaction, " + throwable.getMessage());
        }
        Logger.log(9, Class.class.getName(), "executeTransaction", "Transaction Successful done.");
    }

    @Override
    public void insertJSON(String tableName, JSONObject jsonObject) throws DBException {
        Hashtable<String, String> fieldNameValues = DataStructureHelper.getHashTableFromJson(jsonObject);
        fieldNameValues.put("TIME_STAMP", String.valueOf(System.currentTimeMillis()));
        fieldNameValues.put("OBJECT_STATUS", String.valueOf(IDataStructure.OBJECT_STATUS.ADD.ordinal()));
        fieldNameValues.put("SYNC_STATUS", String.valueOf(IDataStructure.SYNC_STATUS.NONE.ordinal()));
        try {
            if (Strings.isNullOrEmpty((String)jsonObject.optString("LID"))) {
                fieldNameValues.put("LID", UUID.randomUUID().toString().replaceAll("-", ""));
            }
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
        }
        Enumeration<String> keysForParameters = fieldNameValues.keys();
        Vector<String> fieldNames = new Vector<String>();
        while (keysForParameters.hasMoreElements()) {
            fieldNames.addElement(keysForParameters.nextElement());
        }
        int fieldCount = fieldNames.size();
        Object[] values = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = (String)fieldNames.get(i);
            values[i] = fieldNameValues.get(fieldName);
        }
        String query = this.prepareInsertBindQuery(tableName, fieldNames);
        this.executeBindQuery(query, values);
    }

    @Override
    public void insertOrUpdateBasedOnGIDJSON(String tableName, JSONObject jsonObject) throws DBException {
        Hashtable<String, String> fieldNameValues = DataStructureHelper.getHashTableFromJson(jsonObject);
        fieldNameValues.put("TIME_STAMP", String.valueOf(System.currentTimeMillis()));
        try {
            if (Strings.isNullOrEmpty((String)jsonObject.optString("OBJECT_STATUS"))) {
                fieldNameValues.put("OBJECT_STATUS", String.valueOf(IDataStructure.OBJECT_STATUS.ADD.ordinal()));
            }
            if (Strings.isNullOrEmpty((String)jsonObject.optString("SYNC_STATUS"))) {
                fieldNameValues.put("SYNC_STATUS", String.valueOf(IDataStructure.SYNC_STATUS.NONE.ordinal()));
            }
            if (Strings.isNullOrEmpty((String)jsonObject.optString("LID"))) {
                fieldNameValues.put("LID", UUID.randomUUID().toString().replaceAll("-", ""));
            }
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
        }
        Enumeration<String> keysForParameters = fieldNameValues.keys();
        Vector<String> fieldNames = new Vector<String>();
        while (keysForParameters.hasMoreElements()) {
            fieldNames.addElement(keysForParameters.nextElement());
        }
        int fieldCount = fieldNames.size();
        Object[] values = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = (String)fieldNames.get(i);
            values[i] = fieldNameValues.get(fieldName);
        }
        String query = this.prepareReplaceBindQuery(tableName, fieldNames);
        this.executeBindQuery(query, values);
    }

    @Override
    public void updateJSON(String tableName, JSONObject jsonObject, String whereClause) throws DBException {
        Hashtable<String, String> fieldNameValues = DataStructureHelper.getHashTableFromJson(jsonObject);
        fieldNameValues.put("TIME_STAMP", String.valueOf(System.currentTimeMillis()));
        Enumeration<String> keysForParameters = fieldNameValues.keys();
        Vector<String> fieldNames = new Vector<String>();
        while (keysForParameters.hasMoreElements()) {
            String fieldName = keysForParameters.nextElement();
            if ("LID".equalsIgnoreCase(fieldName)) continue;
            fieldNames.addElement(fieldName);
        }
        int fieldCount = fieldNames.size();
        String[] columnNames = new String[fieldCount];
        Object[] columnValues = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName;
            columnNames[i] = fieldName = (String)fieldNames.get(i);
            columnValues[i] = fieldNameValues.get(fieldName);
        }
        String query = this.prepareUpdateBindQuery(tableName, columnNames, whereClause);
        this.executeBindQuery(query, columnValues);
    }

    @Override
    public JSONArray getJSON(String tableName, String whereClause) throws DBException {
        String query = this.prepareSelectQuery(tableName, whereClause, null);
        android.database.Cursor cursorToFormDataStructure = this.executeQuery(query);
        return this.getJSONDataStructuresFromCursor(cursorToFormDataStructure);
    }

    @Override
    public JSONArray getChildren(String tableName, JSDataStructure headerDataStructure) throws DBException {
        String whereClause = "FID = '" + headerDataStructure.getLid() + "'";
        return this.getJSON(tableName, whereClause);
    }

    @Override
    public Hashtable<String, JSONArray> getAllChildren(JSDataStructure headerDataStructure) throws DBException {
        String[] childrenTableNames;
        Hashtable<String, JSONArray> allChildren = new Hashtable<String, JSONArray>();
        for (String childrenTableName : childrenTableNames = headerDataStructure.getChildrenTableNames()) {
            JSONArray children = this.getChildren(childrenTableName, headerDataStructure);
            if (children == null || children.length() <= 0) continue;
            allChildren.put(childrenTableName, children);
        }
        return allChildren;
    }

    private String prepareSelectQuery(String tableName, String whereClause, String[] orderByFields) {
        String query = "SELECT * FROM " + tableName + " ";
        if (!Strings.isNullOrEmpty((String)whereClause)) {
            query = query + "WHERE " + whereClause;
        }
        if (orderByFields != null && orderByFields.length > 0) {
            query = query + " ORDER BY ";
            for (int i = 0; i < orderByFields.length; ++i) {
                query = i == orderByFields.length - 1 ? query + orderByFields[i] : query + orderByFields[i] + ", ";
            }
            query = query + " COLLATE NOCASE ASC ";
        }
        return query;
    }

    private IDataStructure[] getDataStructuresFromCursor(String tableName, android.database.Cursor cursor) throws DBException {
        int i;
        Vector<IDataStructure> tempDataStructures = new Vector<IDataStructure>();
        CrossProcessCursorWrapper sqliteCursor = (CrossProcessCursorWrapper)cursor;
        try {
            while (sqliteCursor.moveToNext()) {
                IDataStructure tempDataStructure;
                if (FrameworkManager.getInstance().getDataManager() != this) {
                    StructureMeta structureMeta;
                    if (this.applicationManager == null) {
                        this.applicationManager = ApplicationManager.getInstance();
                    }
                    if ((structureMeta = this.applicationManager.getStructureMeta(tableName)) == null) {
                        throw new DBException(this.getClass().getName(), "getDataStructuresFromCursor", "Structure Meta for table not found: " + tableName);
                    }
                    tempDataStructure = !structureMeta.getIsHeader() && tableName.toLowerCase().endsWith("_attachment") ? new JSAttachmentItem(tableName) : new JSDataStructure(tableName, structureMeta.getIsHeader());
                } else {
                    String className = ModelHelper.getClassnameForTable(tableName);
                    tempDataStructure = (IDataStructure)Class.forName(className).newInstance();
                }
                String[] columnNames = sqliteCursor.getColumnNames();
                Object[] columnValues = new Object[columnNames.length];
                for (i = 0; i < columnNames.length; ++i) {
                    int sqlType = sqliteCursor.getType(i);
                    if (sqlType == 4) {
                        columnValues[i] = sqliteCursor.getBlob(i);
                        continue;
                    }
                    if (sqlType == 1) {
                        columnValues[i] = sqliteCursor.getLong(i);
                        continue;
                    }
                    if (sqlType == 2) {
                        columnValues[i] = sqliteCursor.getDouble(i);
                        continue;
                    }
                    if (sqlType != 3) continue;
                    try {
                        columnValues[i] = sqliteCursor.getString(i);
                        continue;
                    }
                    catch (Exception ex) {
                        columnValues[i] = sqliteCursor.getBlob(i);
                    }
                }
                this.populateDataStructure(tempDataStructure, columnNames, columnValues);
                tempDataStructures.addElement(tempDataStructure);
            }
        }
        catch (SQLException sqlException) {
            throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "SQLException caught while creating datastructure, " + sqlException.getMessage());
        }
        catch (Exception exception) {
            throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "Exception caught while creating datastructure, " + exception.getMessage());
        }
        finally {
            cursor.close();
        }
        int size = tempDataStructures.size();
        if (size == 0) {
            return null;
        }
        IDataStructure[] dataStructures = new IDataStructure[size];
        for (i = 0; i < size; ++i) {
            dataStructures[i] = (IDataStructure)tempDataStructures.elementAt(i);
        }
        return dataStructures;
    }

    @Override
    public JSONArray getJSONDataStructuresFromCursor(android.database.Cursor cursor) throws DBException {
        JSONArray tempDataStructures = new JSONArray();
        CrossProcessCursorWrapper sqliteCursor = (CrossProcessCursorWrapper)cursor;
        try {
            while (sqliteCursor.moveToNext()) {
                JSONObject tempDataStructure = new JSONObject();
                String[] columnNames = sqliteCursor.getColumnNames();
                Object[] columnValues = new Object[columnNames.length];
                for (int i = 0; i < columnNames.length; ++i) {
                    int sqlType = sqliteCursor.getType(i);
                    if (sqlType == 4) {
                        columnValues[i] = sqliteCursor.getBlob(i);
                        continue;
                    }
                    if (sqlType == 1) {
                        columnValues[i] = sqliteCursor.getLong(i);
                        continue;
                    }
                    if (sqlType == 2) {
                        columnValues[i] = sqliteCursor.getDouble(i);
                        continue;
                    }
                    if (sqlType != 3) continue;
                    try {
                        columnValues[i] = sqliteCursor.getString(i);
                        continue;
                    }
                    catch (Exception ex) {
                        columnValues[i] = sqliteCursor.getBlob(i);
                    }
                }
                this.populateJSONDataStructure(tempDataStructure, columnNames, columnValues);
                tempDataStructures.put((Object)tempDataStructure);
            }
        }
        catch (SQLException sqlException) {
            throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "SQLException caught while creating JSON Array of Structures from Cursor. " + sqlException.getMessage());
        }
        catch (Exception exception) {
            throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "Exception caught while creating JSON Array of Structures from Cursor " + exception.getMessage());
        }
        finally {
            cursor.close();
        }
        return tempDataStructures;
    }

    private String getFieldSqlType(String tableName, String fieldName) {
        if (this.applicationManager == null) {
            this.applicationManager = ApplicationManager.getInstance();
        }
        if ("TIME_STAMP".equalsIgnoreCase(fieldName)) {
            return "INTEGER";
        }
        if ("OBJECT_STATUS".equalsIgnoreCase(fieldName) || "SYNC_STATUS".equalsIgnoreCase(fieldName) || "HAS_CONFLICT".equalsIgnoreCase(fieldName)) {
            return "TEXT";
        }
        String sqlType = "TEXT";
        try {
            FieldMeta fieldMeta = this.applicationManager.getFieldMeta(tableName, fieldName);
            if (fieldMeta != null && ((sqlType = fieldMeta.getSqlType()) == null || sqlType.length() <= 0)) {
                Logger.log(8, this.getClass().getName(), "getFieldSqlType", "NO SQLTYPE FOUND : TABLE-NAME: " + tableName + ", COLUMN-NAME: " + fieldName + ". Defaulting to Type String");
            }
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getName(), "getFieldSqlType", "Error while checking for DataType for : TABLE-NAME: " + tableName + ", COLUMN-NAME: " + fieldName + ". Defaulting to Type String");
        }
        return sqlType;
    }

    private void populateJSONDataStructure(JSONObject dataStructure, String[] columnNames, Object[] columnValues) {
        int noOfColumns = columnNames.length;
        for (int i = 0; i < noOfColumns; ++i) {
            try {
                dataStructure.put(columnNames[i], columnValues[i]);
                continue;
            }
            catch (JSONException e) {
                Logger.log(8, this.getClass().getName(), "populateJSONDataStructure", "Error while creating JSON Object from Column Name/Value pairs." + e.getMessage());
            }
        }
    }

    public boolean executeDBOperationsWithSavePoint(ITransactable callback) throws DBException {
        String savePointName = Utils.getSavePointName();
        this.createSavepoint(savePointName);
        boolean isSuccess = false;
        try {
            isSuccess = callback.transaction(this);
        }
        catch (ApplicationException e) {
            Logger.log(8, this.getClass().getName(), "executeDBOperationsWithSavePoint", "ApplicationException while executing DB Operations with SavePoint" + e.getMessage());
        }
        if (isSuccess) {
            this.releaseSavepoint(savePointName);
        } else {
            this.rollbackToSavepoint(savePointName);
        }
        return isSuccess;
    }

    private void navigateToErrorMessageActivity() {
        this.removeUnviredPreferences(LoginParameters.getContext());
        Intent intent = new Intent(LoginParameters.getContext(), ErrorMessageActivity.class);
        LoginParameters.getContext().startActivity(intent);
    }

    private class UnviredSQLiteOpenHelper
    extends SQLiteOpenHelper {
        UnviredSQLiteOpenHelper(Context context, String name, int version) {
            super(context, name, null, version, new SQLiteDatabaseHook(){

                public void preKey(SQLiteDatabase database) {
                }

                public void postKey(SQLiteDatabase database) {
                    String ss = "PRAGMA cipher_migrate;";
                    Cursor cursor = database.rawQuery(ss, null);
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }, (DatabaseErrorHandler)new DefaultDatabaseErrorHandler());
        }

        public void onCreate(SQLiteDatabase arg0) {
        }

        public void onUpgrade(SQLiteDatabase arg0, int arg1, int arg2) {
        }
    }
}

