/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.database;

import com.unvired.database.DBException;
import com.unvired.logger.Logger;
import com.unvired.utils.PathManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class DatabaseHelper {
    public static void deleteDatabases(boolean isFrameworkDBResetRequired) throws DBException {
        PathManager pathManager = PathManager.getInstance();
        if (isFrameworkDBResetRequired) {
            pathManager.getActiveAccount().deleteAccount();
        } else {
            String appDBPath = pathManager.getDirectoryPathFor(PathManager.PATH_TYPE.APP_DB_FILE);
            File applicationDatabaseFile = new File(appDBPath);
            boolean applicationDatabaseFileDeleteSuccess = false;
            try {
                if (applicationDatabaseFile.exists()) {
                    applicationDatabaseFileDeleteSuccess = applicationDatabaseFile.delete();
                }
                if (applicationDatabaseFileDeleteSuccess) {
                    Logger.log(7, DatabaseHelper.class.getName(), "deleteDatabaseFiles", "Application database file delete success");
                } else {
                    Logger.log(8, DatabaseHelper.class.getName(), "deleteDatabaseFiles", "Application database file delete failure");
                }
            }
            catch (Exception e) {
                Logger.e("Exception caught while deleting framework database file.", e);
                throw new DBException(DatabaseHelper.class.getName(), "deleteDatabaseFiles", "Exception caught while deleting framework database file.");
            }
        }
    }

    public static boolean isBackupAppDBExists() {
        try {
            File file = new File(PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.APP_DB_FILE_BACKUP));
            return file.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean backupAppDB() {
        try {
            int length;
            String inFileName = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.APP_DB_FILE);
            File dbFile = new File(inFileName);
            FileInputStream fis = new FileInputStream(dbFile);
            String outFileName = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.APP_DB_FILE_BACKUP);
            FileOutputStream output = new FileOutputStream(outFileName);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) > 0) {
                ((OutputStream)output).write(buffer, 0, length);
            }
            output.flush();
            ((OutputStream)output).close();
            fis.close();
        }
        catch (Exception e) {
            return false;
        }
        Logger.i("App Db backup created");
        return true;
    }

    public static boolean deleteBackupAppDB() {
        try {
            File file = new File(PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.APP_DB_FILE_BACKUP));
            return file.delete();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBackupFWDBExists() {
        try {
            File file = new File(PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.FW_DB_FILE_BACKUP));
            return file.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean backupFWDB() {
        try {
            int length;
            String inFileName = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.FW_DB_FILE);
            File dbFile = new File(inFileName);
            FileInputStream fis = new FileInputStream(dbFile);
            String outFileName = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.FW_DB_FILE_BACKUP);
            FileOutputStream output = new FileOutputStream(outFileName);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) > 0) {
                ((OutputStream)output).write(buffer, 0, length);
            }
            output.flush();
            ((OutputStream)output).close();
            fis.close();
        }
        catch (Exception e) {
            return false;
        }
        Logger.i("FW DB Backup created");
        return true;
    }

    public static boolean deleteBackupFWDB() {
        try {
            File file = new File(PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.FW_DB_FILE_BACKUP));
            return file.delete();
        }
        catch (Exception e) {
            return false;
        }
    }
}

