/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.database;

import android.content.Context;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.RuntimeEngine;
import com.unvired.database.DBException;
import com.unvired.database.DataManagerImpl;
import com.unvired.database.DataStructureTableMapping;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.logger.Logger;
import com.unvired.model.ApplicationMeta;
import com.unvired.model.AttachmentItem;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.FieldMeta;
import com.unvired.model.JSDataStructure;
import com.unvired.model.StructureMeta;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.ModelHelper;
import com.unvired.utils.PathManager;
import com.unvired.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import net.sqlcipher.Cursor;
import net.sqlcipher.DatabaseErrorHandler;
import net.sqlcipher.DefaultDatabaseErrorHandler;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteDatabaseHook;
import net.sqlcipher.database.SQLiteOpenHelper;

public class DatabaseRestore {
    private DB_TYPE db_type = null;
    private String dbName = "";
    private SQLiteDatabase database = null;

    public DatabaseRestore(DB_TYPE type, int oldVersion, String key) throws DBException {
        this.db_type = type;
        this.init(oldVersion, key);
    }

    private void init(int oldVersion, String key) throws DBException {
        switch (this.db_type) {
            case FW_DB: {
                this.dbName = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.FW_DB_FILE_BACKUP);
                break;
            }
            case APP_DB: {
                this.dbName = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.APP_DB_FILE_BACKUP);
            }
        }
        if (!new File(this.dbName).exists()) {
            throw new DBException(Class.class.getName(), "init", "Backup database do not exist : " + this.dbName);
        }
        UnviredSQLiteOpenHelper sqLiteOpenHelper = new UnviredSQLiteOpenHelper(FrameworkHelper.getApplicationContext(), this.dbName, oldVersion);
        try (Cursor cursor = null;){
            SQLiteDatabase.loadLibs((Context)FrameworkHelper.getApplicationContext());
            this.database = sqLiteOpenHelper.getReadableDatabase(key);
            this.execute("PRAGMA foreign_keys=ON;");
            cursor = this.database.rawQuery("PRAGMA quick_check", null);
            while (cursor.moveToNext()) {
                String s = cursor.getString(0);
                if ("ok".equalsIgnoreCase(s)) continue;
                Logger.e("Exception caught while openOrCreate database : execute : " + s);
                throw new DBException(this.getClass().getName(), "execute", s);
            }
        }
    }

    public void restoreData() throws DBException {
        if (DB_TYPE.FW_DB == this.db_type) {
            this.restoreFWData();
        } else {
            this.restoreAppData();
        }
    }

    private void restoreFWData() throws DBException {
        Cursor cursor = null;
        String savePoint = Utils.getSavePointName();
        try {
            FrameworkManager.getInstance().getDataManager().createSavepoint(savePoint);
            List<String> tableNames = ModelHelper.getFrameworkTableNames();
            for (String tableName : tableNames) {
                if (StructureMeta.TABLE_NAME.equals(tableName) || FieldMeta.TABLE_NAME.equals(tableName) || BusinessEntityMeta.TABLE_NAME.equals(tableName) || ApplicationMeta.TABLE_NAME.equals(tableName) || "FRAMEWORK_ATTACHMENT".equals(tableName)) continue;
                String countQuery = "SELECT COUNT(*) FROM sqlite_master WHERE name='" + tableName + "'";
                cursor = this.database.rawQuery(countQuery, null);
                cursor.moveToFirst();
                if (cursor.getInt(0) == 0) {
                    cursor.close();
                    continue;
                }
                cursor.close();
                String query = "SELECT * FROM " + tableName;
                cursor = this.database.rawQuery(query, null);
                String[] columnNames = cursor.getColumnNames();
                this.restoreFWTable(tableName, columnNames, (android.database.Cursor)cursor);
                cursor.close();
            }
        }
        catch (DBException e) {
            FrameworkManager.getInstance().getDataManager().rollbackToSavepoint(savePoint);
            throw e;
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
            FrameworkManager.getInstance().getDataManager().releaseSavepoint(savePoint);
            if (this.database != null && this.database.isOpen()) {
                this.database.close();
            }
        }
    }

    private void restoreAppData() throws DBException {
        Cursor cursor = null;
        String savePoint = Utils.getSavePointName();
        try {
            String[] columnNames;
            String query;
            String countQuery;
            String tableName;
            BusinessEntityMeta businessEntityMeta;
            StructureMeta meta;
            IDataStructure[] structureMetas;
            ApplicationManager.getInstance().getDataManager().createSavepoint(savePoint);
            for (IDataStructure structure : structureMetas = FrameworkManager.getInstance().getDataManager().get(StructureMeta.TABLE_NAME, StructureMeta.class)) {
                meta = (StructureMeta)structure;
                businessEntityMeta = ApplicationManager.getInstance().getBusinessEntityMeta(meta.getBeName());
                if (!businessEntityMeta.getSAVE_BE() || !businessEntityMeta.isHeader()) continue;
                tableName = meta.getStructName();
                countQuery = "SELECT COUNT(*) FROM sqlite_master WHERE name='" + tableName + "'";
                cursor = this.database.rawQuery(countQuery, null);
                cursor.moveToFirst();
                if (cursor.getInt(0) == 0) {
                    cursor.close();
                    continue;
                }
                cursor.close();
                query = "SELECT * FROM " + tableName;
                cursor = this.database.rawQuery(query, null);
                columnNames = cursor.getColumnNames();
                this.restoreAppTable(tableName, columnNames, (android.database.Cursor)cursor);
                cursor.close();
            }
            for (IDataStructure structure : structureMetas) {
                meta = (StructureMeta)structure;
                businessEntityMeta = ApplicationManager.getInstance().getBusinessEntityMeta(meta.getBeName());
                if (!businessEntityMeta.getSAVE_BE() || businessEntityMeta.isHeader()) continue;
                tableName = meta.getStructName();
                countQuery = "SELECT COUNT(*) FROM sqlite_master WHERE name='" + tableName + "'";
                cursor = this.database.rawQuery(countQuery, null);
                cursor.moveToFirst();
                if (cursor.getInt(0) == 0) {
                    cursor.close();
                    continue;
                }
                cursor.close();
                query = "SELECT * FROM " + tableName;
                cursor = this.database.rawQuery(query, null);
                columnNames = cursor.getColumnNames();
                this.restoreAppTable(tableName, columnNames, (android.database.Cursor)cursor);
                cursor.close();
            }
        }
        catch (DBException e) {
            ApplicationManager.getInstance().getDataManager().rollbackToSavepoint(savePoint);
            throw e;
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
            ApplicationManager.getInstance().getDataManager().releaseSavepoint(savePoint);
            if (this.database != null && this.database.isOpen()) {
                this.database.close();
            }
        }
    }

    private void restoreFWTable(String tableName, String[] columnNames, android.database.Cursor cursor) throws DBException {
        while (cursor.moveToNext()) {
            Object[] columnValues = new Object[columnNames.length];
            block10: for (int i = 0; i < columnNames.length; ++i) {
                int index = cursor.getColumnIndex(columnNames[i]);
                int type = cursor.getType(index);
                switch (type) {
                    case 1: {
                        columnValues[i] = cursor.getLong(i);
                        continue block10;
                    }
                    case 2: {
                        columnValues[i] = cursor.getDouble(i);
                        continue block10;
                    }
                    case 4: {
                        columnValues[i] = cursor.getBlob(i);
                        continue block10;
                    }
                    default: {
                        columnValues[i] = cursor.getString(i);
                    }
                }
            }
            IDataManager iDataManager = FrameworkManager.getInstance().getDataManager();
            try {
                Class<?> className = Class.forName(ModelHelper.getClassnameForTable(tableName));
                IDataStructure tempDataStructure = (IDataStructure)Class.forName(className.getName()).newInstance();
                this.populateDataStructure(tempDataStructure, columnNames, columnValues);
                iDataManager.insertOrUpdateBasedOnGID(tempDataStructure);
            }
            catch (ClassNotFoundException e) {
                Logger.e(e.getMessage());
                throw new DBException(this.getClass().getName(), "restoreFWTable", "ClassNotFoundException : " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                Logger.e(e.getMessage());
                throw new DBException(this.getClass().getName(), "restoreFWTable", "IllegalAccessException : " + e.getMessage());
            }
            catch (InstantiationException e) {
                Logger.e(e.getMessage());
                throw new DBException(this.getClass().getName(), "restoreFWTable", "InstantiationException : " + e.getMessage());
            }
        }
    }

    private void restoreAppTable(String tableName, String[] columnNames, android.database.Cursor cursor) throws DBException {
        while (cursor.moveToNext()) {
            Object[] columnValues = new Object[columnNames.length];
            block6: for (int i = 0; i < columnNames.length; ++i) {
                int index = cursor.getColumnIndex(columnNames[i]);
                int type = cursor.getType(index);
                switch (type) {
                    case 1: {
                        columnValues[i] = cursor.getLong(i);
                        continue block6;
                    }
                    case 2: {
                        columnValues[i] = cursor.getDouble(i);
                        continue block6;
                    }
                    case 4: {
                        columnValues[i] = cursor.getBlob(i);
                        continue block6;
                    }
                    default: {
                        columnValues[i] = cursor.getString(i);
                    }
                }
            }
            IDataManager iDataManager = ApplicationManager.getInstance().getDataManager();
            IDataStructure tempDataStructure = this.getDataStructure(tableName);
            this.populateDataStructure(tempDataStructure, columnNames, columnValues);
            iDataManager.insertOrUpdateBasedOnGID(tempDataStructure);
        }
    }

    private IDataStructure getDataStructure(String tableName) throws DBException {
        if (RuntimeEngine.getInstance().isHTML5Framework()) {
            StructureMeta structureMeta = ApplicationManager.getInstance().getStructureMeta(tableName);
            if (tableName.toLowerCase().endsWith("_attachment")) {
                return new AttachmentItem(tableName);
            }
            return new JSDataStructure(tableName, structureMeta.getIsHeader());
        }
        String tempClassName = DataStructureTableMapping.getInstance().getClassName(tableName);
        try {
            Class<?> className = Class.forName(tempClassName);
            return (IDataStructure)Class.forName(className.getName()).newInstance();
        }
        catch (ClassNotFoundException e) {
            Logger.e(e.getMessage());
            throw new DBException(this.getClass().getName(), "restoreFWTable", "ClassNotFoundException : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            Logger.e(e.getMessage());
            throw new DBException(this.getClass().getName(), "restoreFWTable", "IllegalAccessException : " + e.getMessage());
        }
        catch (InstantiationException e) {
            Logger.e(e.getMessage());
            throw new DBException(this.getClass().getName(), "restoreFWTable", "InstantiationException : " + e.getMessage());
        }
    }

    private void populateDataStructure(IDataStructure dataStructure, String[] columnNames, Object[] columnValues) throws DBException {
        int noOfColumns = columnNames.length;
        for (int i = 0; i < noOfColumns; ++i) {
            if ("LID".equals(columnNames[i]) || "FID".equals(columnNames[i])) {
                dataStructure.setField(columnNames[i], String.valueOf(columnValues[i]));
                continue;
            }
            if ("SYNC_STATUS".equals(columnNames[i])) {
                if (IDataStructure.SYNC_STATUS.NONE.toString().equals(columnValues[i]) || String.valueOf(IDataStructure.SYNC_STATUS.NONE.ordinal()).equals(columnValues[i])) {
                    dataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                    continue;
                }
                if (IDataStructure.SYNC_STATUS.QUEUED.toString().equals(columnValues[i]) || String.valueOf(IDataStructure.SYNC_STATUS.QUEUED.ordinal()).equals(columnValues[i])) {
                    dataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.QUEUED);
                    continue;
                }
                if (IDataStructure.SYNC_STATUS.SENT.toString().equals(columnValues[i]) || String.valueOf(IDataStructure.SYNC_STATUS.SENT.ordinal()).equals(columnValues[i])) {
                    dataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.SENT);
                    continue;
                }
                if (!IDataStructure.SYNC_STATUS.ERROR.toString().equals(columnValues[i]) && !String.valueOf(IDataStructure.SYNC_STATUS.ERROR.ordinal()).equals(columnValues[i])) continue;
                dataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.ERROR);
                continue;
            }
            if ("OBJECT_STATUS".equals(columnNames[i])) {
                if (IDataStructure.OBJECT_STATUS.GLOBAL.toString().equals(columnValues[i]) || String.valueOf(IDataStructure.OBJECT_STATUS.GLOBAL.ordinal()).equals(columnValues[i])) {
                    dataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                    continue;
                }
                if (IDataStructure.OBJECT_STATUS.ADD.toString().equals(columnValues[i]) || String.valueOf(IDataStructure.OBJECT_STATUS.ADD.ordinal()).equals(columnValues[i])) {
                    dataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.ADD);
                    continue;
                }
                if (IDataStructure.OBJECT_STATUS.MODIFY.toString().equals(columnValues[i]) || String.valueOf(IDataStructure.OBJECT_STATUS.MODIFY.ordinal()).equals(columnValues[i])) {
                    dataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.MODIFY);
                    continue;
                }
                if (!IDataStructure.OBJECT_STATUS.DELETE.toString().equals(columnValues[i]) && !String.valueOf(IDataStructure.OBJECT_STATUS.DELETE.ordinal()).equals(columnValues[i])) continue;
                dataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.DELETE);
                continue;
            }
            if (columnValues[i] instanceof byte[]) {
                byte[] bytes = (byte[])columnValues[i];
                byte[] uncompressed = this.uncompressBytes(bytes);
                dataStructure.setField(columnNames[i], uncompressed);
                continue;
            }
            dataStructure.setField(columnNames[i], columnValues[i]);
        }
        dataStructure.setModifiedFlag(false);
    }

    private byte[] uncompressBytes(byte[] data) throws DBException {
        GZIPInputStream gin = null;
        try {
            gin = new GZIPInputStream(new ByteArrayInputStream(data));
        }
        catch (IOException ioException) {
            String error = "IOException caught while uncompressing bytes. Exception: " + ioException.getMessage();
            Logger.e(error, ioException);
            throw new DBException(Class.class.getName(), "uncompressBytes", "IOException caught while creating GZIPInputStream object, " + ioException.getMessage());
        }
        return DataManagerImpl.getString(gin).getBytes();
    }

    private void execute(String sqlStatement) throws DBException {
        if (Logger.getDefaultLogLevel() == 9) {
            Logger.d(sqlStatement);
        }
        try {
            this.database.execSQL(sqlStatement);
            System.out.println("\n" + sqlStatement);
        }
        catch (Exception sqlException) {
            String error = "Exception caught while executing SQLStatement: " + sqlStatement + " Exception: " + sqlException.getMessage();
            Logger.e(error, sqlException);
            throw new DBException(Class.class.getName(), "execute", error);
        }
    }

    private class UnviredSQLiteOpenHelper
    extends SQLiteOpenHelper {
        UnviredSQLiteOpenHelper(Context context, String name, int version) {
            super(context, name, null, version, new SQLiteDatabaseHook(){

                public void preKey(SQLiteDatabase database) {
                }

                public void postKey(SQLiteDatabase database) {
                    String ss = "PRAGMA cipher_migrate;";
                    database.rawQuery(ss, null);
                }
            }, (DatabaseErrorHandler)new DefaultDatabaseErrorHandler());
        }

        public void onCreate(SQLiteDatabase arg0) {
        }

        public void onUpgrade(SQLiteDatabase arg0, int arg1, int arg2) {
        }
    }

    public static enum DB_TYPE {
        FW_DB,
        APP_DB;

    }
}

