/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.database;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.RuntimeEngine;
import com.unvired.database.DBException;
import com.unvired.database.DataStructureTableMapping;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentItem;
import com.unvired.model.InfoMessage;
import com.unvired.model.JSDataStructure;
import com.unvired.model.StructureMeta;
import com.unvired.sync.attachment.Attachment;
import com.unvired.sync.attachment.AttachmentQHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.NetworkUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class GlassDataManagerImpl
implements IDataManager {
    private SQLiteDatabase database = null;
    private UnviredSQLiteOpenHelper sqliteOpenHelper = null;
    private String databaseName = null;
    private int version;
    private DataStructureTableMapping dataStructureTableMapping = null;
    private RuntimeEngine runtimeEngine = null;
    private ApplicationManager applicationManager = null;
    private boolean isEmulator = false;

    public GlassDataManagerImpl(String databaseName, int version) throws DBException {
        if (databaseName == null || databaseName.length() <= 0) {
            throw new DBException(Class.class.getName(), "Constructor", "Database name is invalid: " + databaseName);
        }
        this.databaseName = databaseName;
        this.version = version;
        this.dataStructureTableMapping = DataStructureTableMapping.getInstance();
        this.runtimeEngine = RuntimeEngine.getInstance();
        this.isEmulator = NetworkUtil.isEmulator();
        this.sqliteOpenHelper = new UnviredSQLiteOpenHelper(FrameworkHelper.applicationContext, databaseName, this.version);
    }

    @Override
    public void openOrCreate(String key) throws DBException {
        if (this.isEmulator) {
            key = "";
        }
        try {
            this.database = this.sqliteOpenHelper.getWritableDatabase();
            this.execute("PRAGMA foreign_keys=ON;");
        }
        catch (Exception e) {
            Logger.log(8, this.getClass().getName(), "openOrCreate", "Database open exception: " + e.getMessage());
            throw new DBException(this.getClass().getName(), "openOrCreate", e.getMessage());
        }
    }

    @Override
    public boolean exists() throws DBException {
        File dbFile = FrameworkHelper.applicationContext.getDatabasePath(this.databaseName);
        try {
            return dbFile.exists();
        }
        catch (SecurityException securityException) {
            throw new DBException(Class.class.getName(), "exists", "SecurityException caught while doing database file exist or not, " + securityException.getMessage());
        }
    }

    @Override
    public void close() throws DBException {
        if (this.database != null) {
            this.database.close();
        }
    }

    @Override
    public void beginTransaction() throws DBException {
        Logger.log(9, this.getClass().getName(), "beginTransaction", "Transaction started.");
        this.database.beginTransaction();
    }

    @Override
    public void endTransaction() throws DBException {
        try {
            this.database.setTransactionSuccessful();
        }
        catch (Exception setTransactionSuccessfulException) {
            throw new DBException(Class.class.getName(), "commitTransaction", "Exception caught while commiting the transaction, " + setTransactionSuccessfulException.getMessage());
        }
        finally {
            this.database.endTransaction();
        }
        Logger.log(9, this.getClass().getName(), "commitTransaction", "Transaction commited.");
    }

    @Override
    public void dropDatabase() throws DBException {
        File dbFile = FrameworkHelper.applicationContext.getDatabasePath(this.databaseName);
        try {
            dbFile.delete();
        }
        catch (Exception databasePathException) {
            throw new DBException(Class.class.getName(), "dropDatabase", "DatabasePathException - " + databasePathException.getMessage());
        }
    }

    @Override
    public void dropTable(String tableName) throws DBException {
        String query = this.prepareDropTableQuery(tableName);
        Logger.log(9, Class.class.getName(), "dropTable", "Query: " + query);
        this.execute(query);
    }

    @Override
    public void dropIndex(String indexName) throws DBException {
        String query = this.prepareDropIndexQuery(indexName);
        Logger.log(9, this.getClass().getName(), "dropIndex", "Query: " + query);
        this.execute(query);
    }

    @Override
    public void createTable(String tableName, String[] columnNames, String[] columnTypes, String[] primaryKeys) throws DBException {
        this.createTable(tableName, columnNames, columnTypes, primaryKeys, null, null, null, null, null);
    }

    @Override
    public void createTable(String tableName, String[] columnNames, String[] columnTypes, String[] primaryKeys, String[] uniqueKeys) throws DBException {
        this.createTable(tableName, columnNames, columnTypes, primaryKeys, uniqueKeys, null, null, null, null);
    }

    @Override
    public void createTable(String tableName, String[] columnNames, String[] columnTypes, String[] primaryKeys, String[] uniqueKeys, boolean[] mandatoryFields, String[] foreignKeys, String foreignKeyTableName, String[] foreignKeyTableKeys) throws DBException {
        String query = this.prepareCreateQuery(tableName, columnNames, columnTypes, primaryKeys, uniqueKeys, mandatoryFields, foreignKeys, foreignKeyTableName, foreignKeyTableKeys);
        Logger.log(9, this.getClass().getName(), "createTable", "Query: " + query);
        this.execute(query);
    }

    @Override
    public void createIndex(String indexName, String structureName, String[] fieldNames) throws DBException {
        String query = this.prepareCreateIndexQuery(indexName, structureName, fieldNames);
        Logger.log(9, this.getClass().getName(), "createIndex", "Query: " + query);
        this.execute(query);
    }

    @Override
    public IDataStructure checkDuplicateGID(IDataStructure dataStructure) throws DBException {
        String tableName = dataStructure.getTableName();
        Object[] gidValues = dataStructure.getGids();
        String[] gidFieldNames = dataStructure.getGidFieldNames();
        String gids = "";
        String whereClauseForDuplicate = "";
        for (int i = 0; i < gidFieldNames.length; ++i) {
            whereClauseForDuplicate = i == gidFieldNames.length - 1 ? whereClauseForDuplicate + " " + gidFieldNames[i] + " = " + "'" + gidValues[i] + "'" : whereClauseForDuplicate + " " + gidFieldNames[i] + " = " + "'" + gidValues[i] + "'" + " AND ";
            gids = gids + " - " + gidValues[i];
        }
        IDataStructure[] duplicateDataStructures = this.get(tableName, whereClauseForDuplicate);
        if (duplicateDataStructures != null && duplicateDataStructures.length > 0) {
            return duplicateDataStructures[0];
        }
        return null;
    }

    @Override
    public void insert(IDataStructure dataStructure) throws DBException {
        String tableName = dataStructure.getTableName();
        dataStructure.setTimeStamp(System.currentTimeMillis());
        Enumeration<String> keysForParameters = dataStructure.getFieldNames();
        Vector<String> fieldNames = new Vector<String>();
        while (keysForParameters.hasMoreElements()) {
            fieldNames.addElement(keysForParameters.nextElement());
        }
        int fieldCount = fieldNames.size();
        Object[] values = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = (String)fieldNames.get(i);
            values[i] = dataStructure.getField(fieldName);
        }
        String query = this.prepareInsertBindQuery(tableName, fieldNames);
        this.executeBindQuery(query, values);
    }

    @Override
    public void delete(IDataStructure dataStructure) throws DBException {
        String tableName = dataStructure.getTableName();
        String lid = dataStructure.getLid();
        String whereClause = "LID = '" + lid + "'";
        this.delete(tableName, whereClause);
    }

    @Override
    public void delete(String tableName) throws DBException {
        this.delete(tableName, null);
    }

    @Override
    public void delete(String tableName, String whereClause) throws DBException {
        String query = this.prepareDeleteQuery(tableName, whereClause);
        if (this.applicationManager == null) {
            this.applicationManager = ApplicationManager.getInstance();
        }
        this.checkIfTableSupportsAttachmentsAndDelete(tableName, whereClause);
        this.execute(query);
    }

    @Override
    public void insertOrUpdateBasedOnGID(IDataStructure dataStructure) throws DBException {
        String tableName = dataStructure.getTableName();
        dataStructure.setTimeStamp(System.currentTimeMillis());
        Enumeration<String> keysForParameters = dataStructure.getFieldNames();
        Vector<String> fieldNames = new Vector<String>();
        while (keysForParameters.hasMoreElements()) {
            fieldNames.addElement(keysForParameters.nextElement());
        }
        int fieldCount = fieldNames.size();
        Object[] values = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = (String)fieldNames.get(i);
            values[i] = dataStructure.getField(fieldName);
        }
        String query = this.prepareReplaceBindQuery(tableName, fieldNames);
        this.executeBindQuery(query, values);
    }

    @Override
    public void update(IDataStructure dataStructure) throws DBException {
        dataStructure.setTimeStamp(System.currentTimeMillis());
        String tableName = dataStructure.getTableName();
        String lid = dataStructure.getLid();
        String whereClause = "LID = '" + lid + "'";
        Enumeration<String> keysForParameters = dataStructure.getFieldNames();
        Vector<String> fieldNames = new Vector<String>();
        while (keysForParameters.hasMoreElements()) {
            String fieldName = keysForParameters.nextElement();
            if ("LID".equalsIgnoreCase(fieldName)) continue;
            fieldNames.addElement(fieldName);
        }
        int fieldCount = fieldNames.size();
        String[] columnNames = new String[fieldCount];
        Object[] columnValues = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName;
            columnNames[i] = fieldName = (String)fieldNames.get(i);
            columnValues[i] = dataStructure.getField(fieldName);
        }
        this.update(tableName, columnNames, columnValues, whereClause);
    }

    @Override
    public void update(String tableName, String[] columnNames, Object[] columnValues, String whereClause) throws DBException {
        String query = this.prepareUpdateBindQuery(tableName, columnNames, whereClause);
        this.executeBindQuery(query, columnValues);
    }

    @Override
    public IDataStructure[] get(String tableName) throws DBException {
        return this.get(tableName, "");
    }

    @Override
    public IDataStructure[] get(String tableName, String whereClause) throws DBException {
        String query = this.prepareSelectQuery(tableName, whereClause, null, null);
        Cursor cursorToFormDataStructure = this.executeQuery(query);
        IDataStructure[] dataStructure = this.getDataStructuresFromCursor(tableName, cursorToFormDataStructure, null);
        return dataStructure;
    }

    @Override
    public IDataStructure[] get(String tableName, Class className) throws DBException {
        return this.get(tableName, null, null, className);
    }

    @Override
    public IDataStructure[] get(String tableName, String whereClause, Class className) throws DBException {
        return this.get(tableName, whereClause, null, className);
    }

    @Override
    public IDataStructure[] get(String tableName, String whereClause, String[] orderByFields, Class className) throws DBException {
        String query = this.prepareSelectQuery(tableName, whereClause, orderByFields, null);
        Cursor cursorToFormDataStructure = this.executeQuery(query);
        IDataStructure[] dataStructures = this.getDataStructuresFromCursor(tableName, cursorToFormDataStructure, className);
        return dataStructures;
    }

    @Override
    public IDataStructure[] get(String tableName, String[] orderByFields) throws DBException {
        return this.get(tableName, null, orderByFields, null, null);
    }

    @Override
    public IDataStructure[] get(String tableName, String[] orderByFields, IDataManager.ORDER_TYPE orderType) throws DBException {
        return this.get(tableName, null, orderByFields, null, orderType);
    }

    @Override
    public IDataStructure[] get(String tableName, String whereClause, String[] orderByFields) throws DBException {
        return this.get(tableName, whereClause, orderByFields, null, null);
    }

    @Override
    public IDataStructure[] get(String tableName, String whereClause, String[] orderByFields, IDataManager.ORDER_TYPE orderType) throws DBException {
        return this.get(tableName, whereClause, orderByFields, null, orderType);
    }

    @Override
    public IDataStructure[] get(String tableName, String[] orderByFields, Class className) throws DBException {
        return this.get(tableName, null, orderByFields, className);
    }

    public IDataStructure[] get(String tableName, String whereClause, String[] orderByFields, Class className, IDataManager.ORDER_TYPE orderType) throws DBException {
        String query = this.prepareSelectQuery(tableName, whereClause, orderByFields, orderType);
        Cursor cursorToFormDataStructure = this.executeQuery(query);
        IDataStructure[] dataStructures = this.getDataStructuresFromCursor(tableName, cursorToFormDataStructure, className);
        return dataStructures;
    }

    @Override
    public IDataStructure getBasedOnGID(IDataStructure dataStructure) throws DBException {
        String tableName = dataStructure.getTableName();
        Object[] gidValues = dataStructure.getGids();
        String[] gidFieldNames = dataStructure.getGidFieldNames();
        String gids = "";
        String whereClauseForDataStructureBasedOnGID = "";
        for (int i = 0; i < gidFieldNames.length; ++i) {
            whereClauseForDataStructureBasedOnGID = i == gidFieldNames.length - 1 ? whereClauseForDataStructureBasedOnGID + " " + gidFieldNames[i] + " = " + "'" + gidValues[i] + "'" : whereClauseForDataStructureBasedOnGID + " " + gidFieldNames[i] + " = " + "'" + gidValues[i] + "'" + " AND ";
            gids = gids + " - " + gidValues[i];
        }
        IDataStructure[] dataStructuresBasedOnGID = this.get(tableName, whereClauseForDataStructureBasedOnGID);
        if (dataStructuresBasedOnGID != null && dataStructuresBasedOnGID.length > 0) {
            return dataStructuresBasedOnGID[0];
        }
        return null;
    }

    @Override
    public IDataStructure[] getChildren(String tableName, IDataStructure headerDataStructure) throws DBException {
        String whereClause = "FID = '" + headerDataStructure.getLid() + "'";
        IDataStructure[] children = this.get(tableName, whereClause);
        return children;
    }

    @Override
    public IDataStructure[] getChildren(String tableName, String whereClause, String[] orderByFields, IDataStructure headerDataStructure) throws DBException {
        whereClause = Strings.isNullOrEmpty((String)whereClause) ? "FID = '" + headerDataStructure.getLid() + "'" : whereClause + " AND " + "FID" + " = '" + headerDataStructure.getLid() + "'";
        IDataStructure[] children = this.get(tableName, whereClause, orderByFields);
        return children;
    }

    @Override
    public IDataStructure[] getChildren(String tableName, String[] orderByFields, IDataStructure headerDataStructure) throws DBException {
        String whereClause = "FID = '" + headerDataStructure.getLid() + "'";
        IDataStructure[] children = this.get(tableName, whereClause, orderByFields);
        return children;
    }

    @Override
    public Hashtable<String, IDataStructure[]> getAllChildren(IDataStructure headerDataStructure) throws DBException {
        Hashtable<String, IDataStructure[]> allChildren = new Hashtable<String, IDataStructure[]>();
        String[] childrenTableNames = headerDataStructure.getChildrenTableNames();
        IDataStructure[] children = null;
        for (int i = 0; i < childrenTableNames.length; ++i) {
            children = this.getChildren(childrenTableNames[i], headerDataStructure);
            if (children == null || children.length <= 0) continue;
            allChildren.put(childrenTableNames[i], children);
        }
        return allChildren;
    }

    @Override
    public int count(String tableName, String whereClause) throws DBException {
        String query = null;
        query = whereClause == null || whereClause.length() <= 0 ? "SELECT COUNT(*) FROM " + tableName : "SELECT COUNT(*) FROM " + tableName + " WHERE " + whereClause;
        try (Cursor cursor = this.executeQuery(query);){
            cursor.moveToFirst();
            int n = cursor.getInt(0);
            return n;
        }
    }

    @Override
    public Object max(String tableName, String fieldName, String whereClause) throws DBException {
        String query = null;
        query = Strings.isNullOrEmpty((String)whereClause) ? "SELECT MAX(" + fieldName + ") FROM " + tableName : "SELECT MAX(" + fieldName + ") FROM " + tableName + " WHERE " + whereClause;
        try (Cursor cursor = this.executeQuery(query);){
            cursor.moveToFirst();
            Integer n = cursor.getInt(0);
            return n;
        }
    }

    @Override
    public Object min(String tableName, String fieldName, String whereClause) throws DBException {
        String query = null;
        query = Strings.isNullOrEmpty((String)whereClause) ? "SELECT MIN(" + fieldName + ") FROM " + tableName : "SELECT MIN(" + fieldName + ") FROM " + tableName + " WHERE " + whereClause;
        try (Cursor cursor = this.executeQuery(query);){
            cursor.moveToFirst();
            Integer n = cursor.getInt(0);
            return n;
        }
    }

    @Override
    public Object total(String tableName, String fieldName, String whereClause) throws DBException {
        String query = null;
        query = Strings.isNullOrEmpty((String)whereClause) ? "SELECT TOTAL(" + fieldName + ") FROM " + tableName : "SELECT TOTAL(" + fieldName + ") FROM " + tableName + " WHERE " + whereClause;
        try (Cursor cursor = this.executeQuery(query);){
            cursor.moveToFirst();
            Integer n = cursor.getInt(0);
            return n;
        }
    }

    @Override
    public void execute(String query) throws DBException {
        Logger.log(9, this.getClass().getName(), "execute", "Query: " + query);
        try {
            this.database.execSQL(query);
        }
        catch (Exception sqlException) {
            throw new DBException(Class.class.getName(), "execute", "Exception caught while executing the query, QUERY: " + query + ", " + sqlException.getMessage());
        }
    }

    @Override
    public void executeBindQuery(String query, Object[] columnValues) throws DBException {
        Logger.log(9, this.getClass().getName(), "executeBindQuery", "Query: " + query);
        try (SQLiteStatement statement = this.compileStatement(query);){
            for (int i = 0; i < columnValues.length; ++i) {
                if (columnValues[i] == null) {
                    statement.bindNull(i + 1);
                    continue;
                }
                if (columnValues[i] instanceof String) {
                    statement.bindString(i + 1, (String)columnValues[i]);
                    continue;
                }
                if (columnValues[i] instanceof Integer) {
                    statement.bindLong(i + 1, (long)((Integer)columnValues[i]).intValue());
                    continue;
                }
                if (columnValues[i] instanceof Long) {
                    statement.bindLong(i + 1, ((Long)columnValues[i]).longValue());
                    continue;
                }
                if (columnValues[i] instanceof Float) {
                    statement.bindDouble(i + 1, (double)((Float)columnValues[i]).floatValue());
                    continue;
                }
                if (columnValues[i] instanceof Double) {
                    statement.bindDouble(i + 1, ((Double)columnValues[i]).doubleValue());
                    continue;
                }
                if (!(columnValues[i] instanceof byte[])) continue;
                byte[] bytes = (byte[])columnValues[i];
                byte[] compressedBytes = this.compressBytes(bytes);
                statement.bindBlob(i + 1, compressedBytes);
            }
            statement.execute();
            statement.clearBindings();
        }
    }

    @Override
    public Cursor executeQuery(String sqlStatement) throws DBException {
        Logger.log(9, this.getClass().getName(), "executeQuery", "Query: " + sqlStatement);
        try {
            return this.database.rawQuery(sqlStatement, null);
        }
        catch (Exception sqlException) {
            throw new DBException(Class.class.getName(), "executeQuery", "Exception caught while executing raw query, " + sqlException.getMessage());
        }
    }

    private SQLiteStatement compileStatement(String query) throws DBException {
        try {
            return this.database.compileStatement(query);
        }
        catch (Exception sqlException) {
            throw new DBException(Class.class.getName(), "compileStatement", "Exception caught while compiling statement, " + sqlException.getMessage());
        }
    }

    private String prepareCreateQuery(String tableName, String[] tableColumnNames, Object[] tableColumnTypes, String[] primaryKeys, String[] uniqueKeys, boolean[] mandatoryFields, String[] foreignKeys, String foreignKeyTableName, String[] foreignKeyTableKeys) {
        int i;
        String query = "";
        String primaryKey = "";
        String uniqueKey = "";
        String foreignKey = "";
        String foreignKeyTableKey = "";
        if (primaryKey != null) {
            for (i = 0; i < primaryKeys.length; ++i) {
                primaryKey = i == 0 ? primaryKey + primaryKeys[i] : primaryKey + ", " + primaryKeys[i];
            }
        }
        if (uniqueKeys != null) {
            for (i = 0; i < uniqueKeys.length; ++i) {
                uniqueKey = i == 0 ? uniqueKey + uniqueKeys[i] : uniqueKey + ", " + uniqueKeys[i];
            }
        }
        if (foreignKeyTableName != null) {
            for (i = 0; i < foreignKeys.length; ++i) {
                foreignKey = i == 0 ? foreignKey + foreignKeys[i] : foreignKey + ", " + foreignKeys[i];
            }
            for (i = 0; i < foreignKeyTableKeys.length; ++i) {
                foreignKeyTableKey = i == 0 ? foreignKeyTableKey + foreignKeyTableKeys[i] : foreignKeyTableKey + ", " + foreignKeyTableKeys[i];
            }
        }
        int noOfColumns = 0;
        if (tableColumnNames != null) {
            noOfColumns = tableColumnNames.length;
        }
        query = "CREATE TABLE '" + tableName + "' (";
        for (int i2 = 0; i2 < noOfColumns; ++i2) {
            boolean isMandatory;
            query = i2 == 0 ? query + "'" + tableColumnNames[i2] + "' " : query + ", '" + tableColumnNames[i2] + "' ";
            if (tableColumnTypes != null) {
                try {
                    query = query + tableColumnTypes[i2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    new DBException(Class.class.getName(), "prepareCreateQuery : CreateTable", "ArrayIndexOutOfBoundsException - " + arrayIndexOutOfBoundsException.getMessage());
                }
            }
            if (mandatoryFields == null || !(isMandatory = mandatoryFields[i2])) continue;
            query = query + " NOT NULL";
        }
        if (!Strings.isNullOrEmpty((String)primaryKey)) {
            query = query + ", PRIMARY KEY(" + primaryKey + ")";
        }
        if (!Strings.isNullOrEmpty((String)uniqueKey)) {
            query = query + ", UNIQUE(" + uniqueKey + ")";
        }
        if (!Strings.isNullOrEmpty((String)foreignKeyTableName)) {
            query = query + ", FOREIGN KEY(" + foreignKey + ") REFERENCES " + foreignKeyTableName + "(" + foreignKeyTableKey + ")" + "ON UPDATE CASCADE ON DELETE CASCADE";
        }
        query = query + ")";
        Logger.log(9, this.getClass().getName(), "prepareCreateQuery", query);
        return query;
    }

    private String prepareCreateIndexQuery(String indexName, String structureName, String[] fieldNames) {
        String query = "";
        query = "CREATE INDEX " + indexName + " ON " + structureName + "(";
        for (int i = 0; i < fieldNames.length; ++i) {
            query = i == 0 ? query + fieldNames[i] : query + ", " + fieldNames[i];
        }
        query = query + ")";
        return query;
    }

    private String prepareInsertBindQuery(String tableName, Vector<String> tableColumnNames) {
        String query = "";
        int noOfColumns = 0;
        if (tableColumnNames != null) {
            noOfColumns = tableColumnNames.size();
        }
        query = "INSERT INTO " + tableName + " (";
        for (int i = 0; i < noOfColumns; ++i) {
            String key = tableColumnNames.elementAt(i);
            query = query + key + ",";
        }
        int queryLength = query.length();
        char[] queryChar = query.toCharArray();
        queryChar[queryLength - 1] = 41;
        query = String.valueOf(queryChar);
        query = query + " VALUES (";
        String value = "";
        for (int i = 0; i < noOfColumns; ++i) {
            value = Strings.isNullOrEmpty((String)value) ? value + "?" : value + ", " + "?";
        }
        query = query + value + ")";
        Logger.log(9, this.getClass().getName(), "prepareInsertBindQuery", query);
        return query;
    }

    private String prepareDropTableQuery(String tableName) {
        String query = "DROP TABLE " + tableName;
        Logger.log(9, this.getClass().getName(), "prepareDropTableQuery", query);
        return query;
    }

    private String prepareDropIndexQuery(String indexName) {
        String query = "";
        query = query + "DROP INDEX " + indexName;
        return query;
    }

    private String prepareSelectQuery(String tableName, String whereClause, String[] orderByFields, IDataManager.ORDER_TYPE orderType) {
        String query = "SELECT * FROM " + tableName + " ";
        if (!Strings.isNullOrEmpty((String)whereClause)) {
            query = query + "WHERE " + whereClause;
        }
        if (orderByFields != null && orderByFields.length > 0) {
            query = query + " ORDER BY ";
            for (int i = 0; i < orderByFields.length; ++i) {
                query = i == orderByFields.length - 1 ? query + orderByFields[i] : query + orderByFields[i] + ", ";
            }
            query = orderType == null || orderType.equals((Object)IDataManager.ORDER_TYPE.ASC) ? query + " COLLATE NOCASE ASC " : query + " COLLATE NOCASE DESC ";
        }
        return query;
    }

    private String prepareDeleteQuery(String tableName, String whereClause) {
        String query = "DELETE FROM " + tableName + " ";
        if (!Strings.isNullOrEmpty((String)whereClause)) {
            query = query + "WHERE " + whereClause;
        }
        Logger.log(9, this.getClass().getName(), "prepareDeleteQuery", query);
        return query;
    }

    private String prepareUpdateBindQuery(String tableName, String[] tableColumnNames, String whereClause) {
        String query = "";
        int noOfColumns = 0;
        if (tableColumnNames != null) {
            noOfColumns = tableColumnNames.length;
        }
        query = "UPDATE " + tableName + " SET ";
        for (int i = 0; i < noOfColumns; ++i) {
            query = i == 0 ? query + tableColumnNames[i] + " = ? " : query + " , " + tableColumnNames[i] + " = ? ";
        }
        if (!Strings.isNullOrEmpty((String)whereClause)) {
            query = query + " WHERE " + whereClause;
        }
        Logger.log(9, this.getClass().getName(), "prepareUpdateBindQuery", query);
        return query;
    }

    private String prepareReplaceBindQuery(String tableName, Vector<String> tableColumnNames) {
        String query = "";
        int noOfColumns = 0;
        if (tableColumnNames != null) {
            noOfColumns = tableColumnNames.size();
        }
        query = "REPLACE INTO " + tableName + " (";
        for (int i = 0; i < noOfColumns; ++i) {
            String key = tableColumnNames.elementAt(i);
            query = query + key + ",";
        }
        int queryLength = query.length();
        char[] queryChar = query.toCharArray();
        queryChar[queryLength - 1] = 41;
        query = String.valueOf(queryChar);
        query = query + " VALUES (";
        String value = "";
        for (int i = 0; i < noOfColumns; ++i) {
            value = Strings.isNullOrEmpty((String)value) ? value + "?" : value + ", " + "?";
        }
        query = query + value + ")";
        Logger.log(9, this.getClass().getName(), "prepareReplaceBindQuery", query);
        return query;
    }

    @SuppressLint(value={"NewApi"})
    private IDataStructure[] getDataStructuresFromCursor(String tableName, Cursor cursor, Class<IDataManager> className) throws DBException {
        int i;
        Vector<IDataStructure> tempDataStructures = new Vector<IDataStructure>();
        IDataStructure tempDataStructure = null;
        SQLiteCursor sqliteCursor = (SQLiteCursor)cursor;
        try {
            while (sqliteCursor.moveToNext()) {
                if (className == null) {
                    String tempClassName = this.dataStructureTableMapping.getClassName(tableName);
                    className = Class.forName(tempClassName);
                }
                tempDataStructure = (IDataStructure)Class.forName(className.getName()).newInstance();
                String[] columnNames = sqliteCursor.getColumnNames();
                Object[] columnValues = new Object[columnNames.length];
                for (i = 0; i < columnNames.length; ++i) {
                    String sqlType = tempDataStructure.getFieldType(columnNames[i]);
                    if (sqlType == null || sqlType.length() <= 0) {
                        throw new DBException(this.getClass().getName(), "getDataStructuresFromCursor", "NO SQLTYPE FOUND : TABLE-NAME: " + tableName + ", COLUMN-NAME: " + columnNames[i]);
                    }
                    if (sqlType.equalsIgnoreCase("BLOB")) {
                        columnValues[i] = sqliteCursor.getBlob(i);
                        continue;
                    }
                    if (sqlType.equalsIgnoreCase("INTEGER")) {
                        columnValues[i] = sqliteCursor.getLong(i);
                        continue;
                    }
                    if (sqlType.equalsIgnoreCase("REAL")) {
                        columnValues[i] = sqliteCursor.getDouble(i);
                        continue;
                    }
                    if (sqlType.equalsIgnoreCase("TEXT")) {
                        columnValues[i] = sqliteCursor.getString(i);
                        continue;
                    }
                    throw new DBException(this.getClass().getName(), "getDataStructuresFromCursor", "INVALID SQLTYPE FOUND : TABLE-NAME: " + tableName + ", COLUMN-NAME: " + columnNames[i]);
                }
                this.populateDataStructure(tempDataStructure, columnNames, columnValues);
                tempDataStructures.addElement(tempDataStructure);
            }
        }
        catch (SQLException sqlException) {
            throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "SQLException caught while creating datastructure, " + sqlException.getMessage());
        }
        catch (Exception exception) {
            throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "Exception caught while creating datastructure, " + exception.getMessage());
        }
        finally {
            cursor.close();
        }
        int size = tempDataStructures.size();
        if (size == 0) {
            return null;
        }
        IDataStructure[] dataStructures = new IDataStructure[size];
        for (i = 0; i < size; ++i) {
            dataStructures[i] = (IDataStructure)tempDataStructures.elementAt(i);
        }
        return dataStructures;
    }

    private void populateDataStructure(IDataStructure dataStructure, String[] columnNames, Object[] columnValues) throws DBException {
        int noOfColumns = columnNames.length;
        for (int i = 0; i < noOfColumns; ++i) {
            if (columnValues[i] instanceof byte[]) {
                byte[] bytes = (byte[])columnValues[i];
                byte[] uncompressed = this.uncompressBytes(bytes);
                dataStructure.setField(columnNames[i], uncompressed);
                continue;
            }
            dataStructure.setField(columnNames[i], columnValues[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] compressBytes(byte[] data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipStream = null;
        try {
            gzipStream = new GZIPOutputStream(baos);
            gzipStream.write(data);
        }
        catch (IOException ioException) {
            new DBException(Class.class.getName(), "compressBlob", "IOException caught while compressing data, " + ioException.getMessage());
        }
        finally {
            try {
                gzipStream.close();
            }
            catch (IOException ioException) {
                new DBException(Class.class.getName(), "compressBlob", "IOException caught while closing the GZIPOutputStream , " + ioException.getMessage());
            }
        }
        return baos.toByteArray();
    }

    private byte[] uncompressBytes(byte[] data) throws DBException {
        GZIPInputStream gin = null;
        try {
            gin = new GZIPInputStream(new ByteArrayInputStream(data));
        }
        catch (IOException ioException) {
            throw new DBException(Class.class.getName(), "uncompressBytes", "IOException caught while creating GZIPInputStream object, " + ioException.getMessage());
        }
        return GlassDataManagerImpl.getString(gin).getBytes();
    }

    public static String getString(InputStream inputStream) throws DBException {
        if (inputStream == null) {
            throw new DBException(Class.class.getName(), "getString", "InputStream found as null.");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException ioException) {
            throw new DBException(FrameworkHelper.class.getName(), "getString", "IOException caught while reading input stream, " + ioException.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ioException) {
                throw new DBException(FrameworkHelper.class.getName(), "getString", "IOException caught while closing input stream, " + ioException.getMessage());
            }
        }
        return sb.toString();
    }

    private void checkIfTableSupportsAttachmentsAndDelete(String tableName, String whereClause) throws DBException {
        StructureMeta structureMeta;
        if (this.applicationManager == null) {
            this.applicationManager = ApplicationManager.getInstance();
        }
        if ((structureMeta = this.applicationManager.getStructureMeta(tableName)) != null) {
            AttachmentItem attachmentItem;
            IDataStructure[] headerDataStructures = this.get(tableName, whereClause);
            IDataStructure header = null;
            if (structureMeta.getIsHeader()) {
                if (headerDataStructures != null && headerDataStructures.length > 0) {
                    header = headerDataStructures[0];
                    String beName = header.getBEName();
                    try {
                        if (!this.applicationManager.isAttachmentSupported(beName)) {
                            return;
                        }
                    }
                    catch (ApplicationException e) {
                        Logger.log(8, this.getClass().getName(), "checkIsTableSupportsAttaqchmentsAnddelete", "ApplicationException while checking is bename " + beName + " supports attachments" + e.getMessage());
                        return;
                    }
                    for (int i = 0; i < headerDataStructures.length; ++i) {
                        header = headerDataStructures[i];
                        AttachmentItem[] items = this.getAttachments(header);
                        if (items == null) continue;
                        int j = 0;
                        while (j < items.length) {
                            AttachmentItem attachmentItem2 = items[j++];
                            try {
                                String uid = attachmentItem2.getUid();
                                AttachmentQHelper.getInstance().deleteIfQueuedForDownload(uid);
                            }
                            catch (DBException e) {
                                Logger.log(8, Attachment.class.getName(), "checkIsTableSupportsAttaqchmentsAnddelete", "DBException while deleting it from the attachment q: " + e.getMessage());
                            }
                            attachmentItem2.delete();
                        }
                    }
                }
            } else if (headerDataStructures != null && headerDataStructures.length > 0 && (attachmentItem = null) instanceof AttachmentItem) {
                attachmentItem = (AttachmentItem)headerDataStructures[0];
                attachmentItem.delete();
            }
        }
    }

    private AttachmentItem[] getAttachments(IDataStructure header) {
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        IDataStructure[] dataStructures = null;
        try {
            IDataManager applicationDataManager = applicationManager.getDataManager();
            String beName = header.getBEName();
            String attachmentStructName = beName + "_ATTACHMENT";
            dataStructures = applicationDataManager.getChildren(attachmentStructName, null, null, header);
            if (dataStructures == null) {
                String whereClause = "FID = '" + header.getLid() + "'";
                dataStructures = applicationDataManager.get(attachmentStructName, whereClause);
            }
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getName(), "getAttachments", "DBException while getting attachment items of a business header: " + e.getMessage());
        }
        if (dataStructures == null || dataStructures.length == 0) {
            Logger.log(9, this.getClass().getName(), "getAttachments", "dataStructures is null, while checking if the IdataStructure in question supports attachments and if it has one");
            return null;
        }
        AttachmentItem[] items = new AttachmentItem[dataStructures.length];
        System.arraycopy(dataStructures, 0, items, 0, dataStructures.length);
        return items;
    }

    @Override
    public void rollbackToSavepoint(String savePointName) throws DBException {
        String query = "ROLLBACK TRANSACTION TO SAVEPOINT " + savePointName;
        Logger.log(9, Class.class.getName(), "rollbackToSavepoint", "Query: " + query);
        this.execute(query);
    }

    @Override
    public void releaseSavepoint(String savePointName) throws DBException {
        String query = "RELEASE SAVEPOINT " + savePointName;
        Logger.log(9, Class.class.getName(), "releaseSavepoint", "Query: " + query);
        this.execute(query);
    }

    @Override
    public void createSavepoint(String savePointName) throws DBException {
        String query = "SAVEPOINT " + savePointName;
        Logger.log(9, Class.class.getName(), "createSavepoint", "Query: " + query);
        this.execute(query);
    }

    private void createAndSaveInfoMessage(String message) {
        InfoMessage infoMessage = new InfoMessage();
        infoMessage.setCategory("FAILURE");
        infoMessage.setMessage("Message:" + message);
        try {
            FrameworkManager.getInstance().getDataManager().insert(infoMessage);
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getName(), "createAndSaveInfoMessage", "DBException caught while inserting Info Message: " + e.getMessage());
        }
    }

    @Override
    public <T> List<T> getTypedDS(String tableName, String whereClause, String[] orderByFields, Class className) throws DBException {
        return null;
    }

    @Override
    public void printDBSize() {
    }

    @Override
    public void insertJSON(String tableName, JSONObject jsonObject) throws DBException {
    }

    @Override
    public JSONArray getJSON(String tableName, String whereClause) throws DBException {
        return null;
    }

    @Override
    public JSONArray getChildren(String tableName, JSDataStructure headerDataStructure) throws DBException {
        return null;
    }

    @Override
    public Hashtable<String, JSONArray> getAllChildren(JSDataStructure headerDataStructure) throws DBException {
        return null;
    }

    @Override
    public void updateJSON(String tableName, JSONObject jsonObject, String whereClause) throws DBException {
    }

    @Override
    public void insertOrUpdateBasedOnGIDJSON(String tableName, JSONObject jsonObject) throws DBException {
    }

    @Override
    public JSONArray getJSONDataStructuresFromCursor(Cursor cursor) throws DBException {
        return null;
    }

    private class UnviredSQLiteOpenHelper
    extends SQLiteOpenHelper {
        UnviredSQLiteOpenHelper(Context context, String name, int version) {
            super(context, name, null, version);
        }

        public void onCreate(SQLiteDatabase arg0) {
        }

        public void onUpgrade(SQLiteDatabase arg0, int arg1, int arg2) {
        }
    }
}

