/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.fcm;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.firebase.iid.FirebaseInstanceId;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.logger.Logger;
import com.unvired.login.LoginParameters;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.notifier.PushNotificationListener;

public class RegisterToFCM {
    private static PushNotificationListener pushNotificationListener = null;

    public static void sendRegistrationToServer() {
        try {
            RegisterToFCM.setAppActIdForPush(FrameworkSettingsManager.getInstance().getActId());
            String newToken = FirebaseInstanceId.getInstance().getToken();
            String storedToken = FrameworkManager.getInstance().getFrameworkSettingsManager().getPushToken();
            if (newToken.equals(storedToken)) {
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.d("New and Old token are same. Token: " + newToken);
                }
                return;
            }
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("New is different from Old token: " + newToken);
            }
            SyncEngine.getInstance().sendPushNotificationIdToServer(newToken);
        }
        catch (Exception e) {
            Logger.e("sendRegistrationToServer: Error caught while sending FCM token to server. " + e.getMessage());
        }
    }

    public static void unRegistrationFromServer() {
        try {
            FrameworkSettingsManager.getInstance().setPushToken("");
            RegisterToFCM.setAppActIdForPush("");
        }
        catch (Exception e) {
            Logger.e("unRegistrationFromServer: Error caught while clearing FCM token in device. " + e.getMessage());
        }
    }

    static String getAppActIdForPush(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("FCM", 0);
        return sharedPreferences.getString("ACT_ID", "");
    }

    private static void setAppActIdForPush(String actID) {
        if (Logger.getDefaultLogLevel() == 9) {
            Logger.d("Saving activation id in Shared Preferences. Act Id: " + actID);
        }
        SharedPreferences sharedPreferences = LoginParameters.getContext().getApplicationContext().getSharedPreferences("FCM", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("ACT_ID", actID);
        editor.apply();
    }

    public static void setPushNotificationListener(PushNotificationListener listener) {
        pushNotificationListener = listener;
    }

    public static PushNotificationListener getPushNotificationListener() {
        return pushNotificationListener;
    }
}

