/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.fcm;

import com.google.common.base.Strings;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.fcm.RegisterToFCM;
import com.unvired.logger.Logger;
import com.unvired.login.AuthenticationService;
import com.unvired.parser.NotificationXMLHandler;
import com.unvired.sync.attachment.AttachmentDownloader;
import com.unvired.sync.in.DataRetrieverService;
import com.unvired.sync.in.NotificationBO;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class UnviredFCMMessagingService
extends FirebaseMessagingService {
    public void onMessageReceived(RemoteMessage remoteMessage) {
        if (Logger.getDefaultLogLevel() == 9) {
            Logger.d("From: " + remoteMessage.getFrom());
        }
        String data = null;
        if (remoteMessage.getData().size() > 0) {
            data = (String)remoteMessage.getData().get("data");
        }
        if (data == null) {
            return;
        }
        final NotificationBO notification = this.getNotificationBO(data);
        try {
            String currentActIdForPush = RegisterToFCM.getAppActIdForPush(this.getApplicationContext());
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("Current Act Id for push: " + currentActIdForPush);
            }
            if (!currentActIdForPush.equals(notification.getActivationId())) {
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.d("Current Act Id for push and Act id from notification do not match");
                }
                return;
            }
        }
        catch (Exception e) {
            Logger.e("Push message received when user has logged out");
            return;
        }
        Logger.i("data: " + data + " Notification type: " + notification.getNotificationType());
        if ("SYSTEM".equals(notification.getNotificationType())) {
            if (AuthenticationService.isLoginSuccessful()) {
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.d("Call getMessages() in Background");
                }
                DataRetrieverService.getInstance().getMessagesInBackground();
                return;
            }
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("App not logged in. Cannot call getMessages() in background");
            }
        } else if ("ATTACHMENT".equals(notification.getNotificationType())) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("data: " + data + " notificationAttachmentId: " + notification.getAttachmentUID());
            }
            if (AuthenticationService.isLoginSuccessful()) {
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.d("Notify attachment downloader");
                }
                AttachmentDownloader.getInstance().notifyThread(notification.getAttachmentUID());
                return;
            }
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("App not logged in. Cannot notify attachment downloader");
            }
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                UnviredFCMMessagingService.this.onCallBack(notification);
                if (RegisterToFCM.getPushNotificationListener() != null) {
                    RegisterToFCM.getPushNotificationListener().notifyUserMessage(notification);
                }
            }
        });
        t.start();
    }

    public void onNewToken(String token) {
        try {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("New token received: " + token);
            }
            if (!Strings.isNullOrEmpty((String)FrameworkSettingsManager.getInstance().getActId())) {
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.d("Application activated. Sending token: " + token);
                }
                RegisterToFCM.sendRegistrationToServer();
            }
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
        }
    }

    private NotificationBO getNotificationBO(String data) {
        try {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("PushNotification Message Xml: " + data);
            }
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            NotificationXMLHandler notificationXMLHandler = new NotificationXMLHandler();
            xr.setContentHandler(notificationXMLHandler);
            InputSource inStream = new InputSource();
            inStream.setCharacterStream(new StringReader(data));
            xr.parse(inStream);
            return notificationXMLHandler.getNotificationsList().get(0);
        }
        catch (Exception exception) {
            Logger.e("Exception caught while parsing Notification XML, " + exception.getMessage());
            return null;
        }
    }

    @Deprecated
    public void onCallBack(NotificationBO notificationBO) {
    }
}

