/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.location;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.logger.Logger;
import com.unvired.message.UBDataFormatConstants;
import com.unvired.model.LocationTracking;
import com.unvired.model.OutObject;
import com.unvired.sync.SyncConstants;
import com.unvired.sync.out.Outbox;
import com.unvired.utils.FrameworkHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Locations
implements LocationListener {
    private int counter = 0;
    private Location location;
    private double latitude;
    private double longitude;
    private static final String ENABLED = "ENABLED";
    private static long MIN_TIME_BW_UPDATES = 5000L;
    private static final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 0L;
    private static Locations instance = null;
    private static Timer _startTimer;
    private static Timer _endTimer;
    int track;
    int upload;
    Date trackingStartTime;
    Date trackingEndTime;
    final Handler handler = new Handler(Looper.getMainLooper());
    public Runnable locationUpdater = new Runnable(){

        @Override
        public void run() {
            IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
            if (Locations.this.counter <= Locations.this.upload) {
                try {
                    Logger.log(9, this.getClass().getSimpleName(), "StartLocationTracking", "Current Tracking Time:" + Locations.this.counter + " Upload Time:" + Locations.this.upload);
                    Location location = Locations.this.getLocation();
                    if (location != null) {
                        LocationTracking locationTracking = new LocationTracking();
                        locationTracking.setObjectStatus(IDataStructure.OBJECT_STATUS.ADD);
                        locationTracking.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                        locationTracking.setLatitude(String.valueOf(location.getLatitude()));
                        locationTracking.setLongitude(String.valueOf(location.getLongitude()));
                        locationTracking.setTrackTimestamp(System.currentTimeMillis());
                        dataManager.insert(locationTracking);
                    } else {
                        Logger.log(8, this.getClass().getSimpleName(), "StartLocationTracking", "Error while Tracking Location. Location data is Null.");
                    }
                }
                catch (Exception ex) {
                    Logger.e("Exception caught while saving LocationTracking entry in database.", ex);
                }
                Locations.this.counter = Locations.this.counter + Locations.this.track;
            } else {
                Locations.this.counter = 0;
                try {
                    dataManager.execute("DELETE FROM " + OutObject.TABLE_NAME + " WHERE " + OutObject.MESSAGE_TYPE + " = '" + 1100 + "'");
                    Document locationXml = Locations.getLocationDocumentRoot();
                    OutObject outObject = new OutObject();
                    outObject.setSyncType(SyncConstants.SYNC_MODE.SYNC.toString());
                    outObject.setFunctionName("ADMIN_SERVICES");
                    outObject.setMessageType(String.valueOf(9000));
                    outObject.setMessageSubType(String.valueOf(1100));
                    outObject.setBEName("LOCATION_TRACKING");
                    String xml = FrameworkHelper.getString(locationXml);
                    outObject.setMessageXml(xml.getBytes());
                    Outbox.getInstance().add(outObject);
                    Logger.log(9, this.getClass().getSimpleName(), "StartLocationTracking", "Location Tracking data queued for uploaded to Server.");
                }
                catch (Exception e) {
                    Logger.e("Error while uploading Location Tracking data to Server.", e);
                }
            }
            Locations.this.handler.postDelayed((Runnable)this, (long)(1000 * Locations.this.track));
        }
    };

    public static Locations getInstance() {
        if (instance == null) {
            instance = new Locations();
        }
        return instance;
    }

    public static void destroy() {
        if (instance != null) {
            instance = null;
            _startTimer.cancel();
            _endTimer.cancel();
            Logger.log(7, Locations.class.getName(), "destroy", "Destroyed");
        } else {
            Logger.log(7, Locations.class.getName(), "destroy", "Destroy not required. Already null.");
        }
    }

    private void setTrackingStartStopTimer() {
        _startTimer = new Timer();
        _endTimer = new Timer();
        if (this.trackingStartTime != null) {
            _startTimer.schedule((TimerTask)new AlarmTask(), this.trackingStartTime);
        }
        if (this.trackingEndTime != null) {
            _endTimer.schedule((TimerTask)new AlarmTask(), this.trackingEndTime);
        }
    }

    public void RegisterForLocationTracking() {
        try {
            this.StartLocationTracking();
        }
        catch (Exception e) {
            Logger.e("Error occurred while Tracking Locations." + e);
        }
        try {
            this.setTrackingStartStopTimer();
        }
        catch (Exception e) {
            Logger.e("Error occurred while Setting Location Tracking Start/End Timer.", e);
        }
    }

    public void StartLocationTracking() {
        block8: {
            try {
                if (ENABLED.equals(FrameworkSettingsManager.getInstance().getLocationTracking())) {
                    String trackingDays = FrameworkSettingsManager.getInstance().getLocationTrackingDays();
                    Calendar c = Calendar.getInstance();
                    c.setTime(new Date());
                    int todayDay = c.get(7);
                    if (this.doTrackingToday(trackingDays, todayDay)) {
                        SimpleDateFormat sdf = new SimpleDateFormat("kk:mm");
                        Date trackingStart = sdf.parse(FrameworkSettingsManager.getInstance().getLocationTrackingStart());
                        Date trackingEnd = sdf.parse(FrameworkSettingsManager.getInstance().getLocationTrackingEnd());
                        this.trackingStartTime = new Date();
                        this.trackingStartTime.setHours(trackingStart.getHours());
                        this.trackingStartTime.setMinutes(trackingStart.getMinutes());
                        this.trackingStartTime.setSeconds(0);
                        this.trackingEndTime = new Date();
                        this.trackingEndTime.setHours(trackingEnd.getHours());
                        this.trackingEndTime.setMinutes(trackingEnd.getMinutes());
                        this.trackingEndTime.setSeconds(0);
                        Date currentTime = c.getTime();
                        currentTime.setSeconds(50);
                        if (currentTime.after(this.trackingStartTime) && currentTime.before(this.trackingEndTime)) {
                            this.track = Integer.parseInt(FrameworkSettingsManager.getInstance().getLocationTrackingInterval());
                            this.upload = Integer.parseInt(FrameworkSettingsManager.getInstance().getLocationUoloadInterval());
                            MIN_TIME_BW_UPDATES = 1000 * this.track;
                            if (this.track > 0 && this.upload > 0) {
                                Logger.log(9, this.getClass().getSimpleName(), "StartLocationTracking", "Location Tracking Service Started.Track Interval in Seconds :" + this.track + " Track Upload in Seconds :" + this.upload);
                                IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
                                try {
                                    dataManager.execute("DELETE FROM LOCATION_TRACKING WHERE SYNC_STATUS = '" + IDataStructure.SYNC_STATUS.QUEUED.ordinal() + "'");
                                }
                                catch (Exception e) {
                                    Logger.e("Error while clearing Location Table.", e);
                                }
                                this.handler.post(this.locationUpdater);
                                break block8;
                            }
                            Logger.log(9, Locations.class.getSimpleName(), "StartTimerOnMainThread", "Location Tracking intervals are invalid.");
                            break block8;
                        }
                        this.handler.removeCallbacks(this.locationUpdater);
                        Logger.log(7, Locations.class.getSimpleName(), "StartTimerOnMainThread", "Current time not withing Location Tracking start and end intervals");
                        break block8;
                    }
                    this.handler.removeCallbacks(this.locationUpdater);
                    Logger.log(7, Locations.class.getSimpleName(), "StartTimerOnMainThread", "Location Tracking is not set for today");
                    break block8;
                }
                Logger.log(9, Locations.class.getSimpleName(), "StartTimerOnMainThread", "Location Tracking is disabled for this application.");
            }
            catch (Exception ex) {
                Logger.e("Error while tracking location periodically.", ex);
            }
        }
    }

    private boolean doTrackingToday(String trackingDays, int today) {
        boolean flag;
        block3: {
            int[] monSunDays;
            block5: {
                int[] monSatDays;
                block4: {
                    int[] monFriDays = new int[]{2, 3, 4, 5, 6};
                    monSatDays = new int[]{2, 3, 4, 5, 6, 7};
                    monSunDays = new int[]{1, 2, 3, 4, 5, 6, 7};
                    flag = false;
                    if (!"MON-FRI".equalsIgnoreCase(trackingDays)) break block4;
                    for (int day : monFriDays) {
                        if (day != today) continue;
                        flag = true;
                        break block3;
                    }
                    break block3;
                }
                if (!"MON-SAT".equalsIgnoreCase(trackingDays)) break block5;
                for (int day : monSatDays) {
                    if (day != today) continue;
                    flag = true;
                    break block3;
                }
                break block3;
            }
            if (!"MON-SUN".equalsIgnoreCase(trackingDays)) break block3;
            for (int day : monSunDays) {
                if (day != today) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static Document getLocationDocumentRoot() throws DBException {
        String applicationId;
        String applicationName;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.log(8, FrameworkHelper.class.getName(), "getSenderDocumentRoot", "Exception while creating a dom document: " + e.getMessage());
        }
        Document domDocument = db.newDocument();
        Element root = domDocument.createElement("Root");
        root.setAttribute("type", String.valueOf(9000));
        root.setAttribute("requestType", String.valueOf((Object)SyncConstants.MESSAGE_REQUEST_TYPE.PUSH));
        domDocument.appendChild(root);
        try {
            FrameworkSettingsManager frameworkSettingsManager = FrameworkManager.getInstance().getFrameworkSettingsManager();
            if (frameworkSettingsManager.getCompanyAlias() != null && frameworkSettingsManager.getCompanyAlias().length() > 0) {
                Element companyAliasElement = domDocument.createElement("CompanyAlias");
                companyAliasElement.appendChild(domDocument.createTextNode(frameworkSettingsManager.getCompanyAlias()));
                root.appendChild(companyAliasElement);
            }
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while getting framework settings.", dbException);
        }
        String serverId = FrameworkSettingsManager.getInstance().getServerId();
        if (serverId != null && serverId.length() > 0) {
            Element conversationIdElement = domDocument.createElement("ServerId");
            conversationIdElement.appendChild(domDocument.createTextNode(serverId));
            root.appendChild(conversationIdElement);
        }
        if ((applicationName = ApplicationManager.getInstance().getApplicationName()) != null && applicationName.length() > 0) {
            Element conversationIdElement = domDocument.createElement("ApplicationName");
            conversationIdElement.appendChild(domDocument.createTextNode(applicationName));
            root.appendChild(conversationIdElement);
        }
        if ((applicationId = ApplicationManager.getInstance().getApplicationId()) != null && applicationId.length() > 0) {
            Element conversationIdElement = domDocument.createElement("ApplicationId");
            conversationIdElement.appendChild(domDocument.createTextNode(applicationId));
            root.appendChild(conversationIdElement);
        }
        Element data = domDocument.createElement("data");
        data.setAttribute("subtype", String.valueOf(1100));
        Element location = domDocument.createElement(UBDataFormatConstants.LOCATION_TAG);
        IDataStructure[] locationDataStructures = FrameworkManager.getInstance().getDataManager().get("LOCATION_TRACKING", "");
        if (locationDataStructures != null && locationDataStructures.length > 0) {
            for (IDataStructure dataStructure : locationDataStructures) {
                LocationTracking locationTracking = (LocationTracking)dataStructure;
                Element L = domDocument.createElement(UBDataFormatConstants.LOCATION_L_TAG);
                L.setAttribute(UBDataFormatConstants.LOCATION_ATTR_T_TAG, locationTracking.getTrackTimestamp().toString());
                L.setAttribute(UBDataFormatConstants.LOCATION_ATTR_O_TAG, locationTracking.getLongitude());
                L.setAttribute(UBDataFormatConstants.LOCATION_ATTR_A_TAG, locationTracking.getLatitude());
                location.appendChild(L);
            }
        }
        data.appendChild(location);
        root.appendChild(data);
        return domDocument;
    }

    public Location getLocation() {
        try {
            LocationManager locationManager = (LocationManager)FrameworkHelper.getApplicationContext().getSystemService("location");
            boolean isGPSEnabled = locationManager.isProviderEnabled("gps");
            boolean isNetworkEnabled = locationManager.isProviderEnabled("network");
            if (isGPSEnabled || isNetworkEnabled) {
                if (isNetworkEnabled) {
                    if (ContextCompat.checkSelfPermission((Context)FrameworkHelper.getApplicationContext(), (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ContextCompat.checkSelfPermission((Context)FrameworkHelper.getApplicationContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                        return null;
                    }
                    locationManager.requestLocationUpdates("network", MIN_TIME_BW_UPDATES, 0.0f, (LocationListener)this);
                    Log.d((String)"Network", (String)"Network");
                    if (locationManager != null) {
                        this.location = locationManager.getLastKnownLocation("network");
                        if (this.location != null) {
                            this.latitude = this.location.getLatitude();
                            this.longitude = this.location.getLongitude();
                        }
                    }
                }
                if (isGPSEnabled && this.location == null) {
                    locationManager.requestLocationUpdates("gps", MIN_TIME_BW_UPDATES, 0.0f, (LocationListener)this);
                    Log.d((String)"GPS Enabled", (String)"GPS Enabled");
                    if (locationManager != null) {
                        this.location = locationManager.getLastKnownLocation("gps");
                        if (this.location != null) {
                            this.latitude = this.location.getLatitude();
                            this.longitude = this.location.getLongitude();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.e("Exception caught while capturing device location.", e);
        }
        return this.location;
    }

    public void onLocationChanged(Location location) {
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onProviderDisabled(String provider) {
    }

    class AlarmTask
    extends TimerTask {
        AlarmTask() {
        }

        @Override
        public void run() {
            Logger.log(7, this.getClass().getSimpleName(), "StartLocationTracking", "Location Tracking timer Kicked in.");
            Locations.this.handler.removeCallbacks(Locations.this.locationUpdater);
            Locations.this.StartLocationTracking();
        }
    }
}

