/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.logger;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import android.util.Log;
import android.widget.Toast;
import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkVersion;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.login.LoginParameters;
import com.unvired.model.FrameworkAttachment;
import com.unvired.model.InObject;
import com.unvired.model.InfoMessage;
import com.unvired.model.OutObject;
import com.unvired.model.SentItemObject;
import com.unvired.sync.in.DataRetrieverService;
import com.unvired.sync.in.InboxHandler;
import com.unvired.sync.in.SystemMessageHandler;
import com.unvired.sync.out.DataSender;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.sync.response.AttachmentResponse;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.FileHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.PathManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class Logger {
    public static final int LEVEL_IMPORTANT = 7;
    public static final int LEVEL_ERROR = 8;
    public static final int LEVEL_DEBUG = 9;
    private static int DEFAULT_LEVEL = 8;
    private static final String LOG_FIELD_SEPARATOR = " | ";
    private static final String LOG_LINE_SEPARATOR = "\n";
    private static final int MAX_LOGGER_SIZE_IN_BYTES = 1024000;
    private static String logFilePathAndName = null;
    private static OutputStreamWriter myOutWriter;
    private static File logFile;

    private static void initFileStream() {
        try {
            FileOutputStream fOut = new FileOutputStream(logFile, true);
            myOutWriter = new OutputStreamWriter(fOut);
        }
        catch (Exception e) {
            Log.e((String)"log", (String)("Exception while initFileStream()" + e.getMessage()));
        }
    }

    public static int getDefaultLogLevel() {
        return DEFAULT_LEVEL;
    }

    public static void setLogLevel(int logLevel) {
        DEFAULT_LEVEL = logLevel;
    }

    @Deprecated
    public static void log(int logLevel, String sourceClass, String sourceMethod, String message) {
        if (logLevel == 9 && DEFAULT_LEVEL != 9) {
            return;
        }
        if (FrameworkHelper.applicationContext == null) {
            return;
        }
        if (message == null) {
            message = "";
        }
        int lineNo = -1;
        String data = message;
        try {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            if (stack != null && stack.length >= 4 && stack[4].getFileName() != null) {
                sourceClass = stack[4].getFileName();
                sourceMethod = stack[4].getMethodName();
                lineNo = stack[4].getLineNumber();
            }
            data = FrameworkHelper.getDateString(System.currentTimeMillis()) + LOG_FIELD_SEPARATOR + Logger.getStringFromLevel(logLevel) + LOG_FIELD_SEPARATOR + sourceClass + LOG_FIELD_SEPARATOR + lineNo + LOG_FIELD_SEPARATOR + sourceMethod + LOG_FIELD_SEPARATOR + message + LOG_LINE_SEPARATOR;
        }
        catch (Exception e) {
            data = data + " Stack trace threw exception";
        }
        if (logLevel == 7) {
            Log.v((String)(sourceClass + " " + sourceMethod), (String)data);
        } else if (logLevel == 8) {
            Log.e((String)(sourceClass + " " + sourceMethod), (String)data);
        } else if (logLevel == 9) {
            Log.w((String)(sourceClass + " " + sourceMethod), (String)data);
        }
        Logger.writeIntoFile(data);
    }

    public static void d(String message) {
        Logger.log(9, message);
    }

    public static void i(String message) {
        Logger.log(7, message);
    }

    public static void e(String message) {
        Logger.log(8, message);
    }

    public static void e(String message, Exception e) {
        Logger.log(8, message + LOG_LINE_SEPARATOR + FrameworkHelper.getExceptionMessage(e));
    }

    private static void log(int logLevel, String message) {
        if (DEFAULT_LEVEL != 9 && logLevel == 9) {
            return;
        }
        if (FrameworkHelper.applicationContext == null) {
            return;
        }
        if (message == null) {
            message = "";
        }
        String sourceClass = "unknown";
        String sourceMethod = "unknown";
        int lineNo = -1;
        String data = message;
        try {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            if (stack != null && stack.length >= 4 && stack[4].getFileName() != null) {
                sourceClass = stack[4].getFileName();
                sourceMethod = stack[4].getMethodName();
                lineNo = stack[4].getLineNumber();
            }
            data = FrameworkHelper.getDateString(System.currentTimeMillis()) + LOG_FIELD_SEPARATOR + Logger.getStringFromLevel(logLevel) + LOG_FIELD_SEPARATOR + sourceClass + LOG_FIELD_SEPARATOR + lineNo + LOG_FIELD_SEPARATOR + sourceMethod + LOG_FIELD_SEPARATOR + message + LOG_LINE_SEPARATOR;
        }
        catch (Exception e) {
            data = data + " Stack trace threw exception";
        }
        if (logLevel == 7) {
            Log.v((String)(sourceClass + " " + sourceMethod), (String)data);
        } else if (logLevel == 8) {
            Log.e((String)(sourceClass + " " + sourceMethod), (String)data);
        } else if (logLevel == 9) {
            Log.w((String)(sourceClass + " " + sourceMethod), (String)data);
        }
        Logger.writeIntoFile(data);
    }

    private static synchronized void initializePath() {
        if (Strings.isNullOrEmpty((String)logFilePathAndName)) {
            logFilePathAndName = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.LOG_FILE);
        }
        try {
            if (logFile == null) {
                logFile = new File(logFilePathAndName);
                Logger.initFileStream();
            }
            if (!logFile.exists()) {
                logFile.getParentFile().mkdirs();
                logFile.createNewFile();
                Logger.initFileStream();
            } else if (logFile.length() > 1024000L) {
                File backupLogFile = new File(Logger.getBackupLogFilePath());
                if (backupLogFile.exists()) {
                    backupLogFile.delete();
                    backupLogFile.createNewFile();
                }
                FileHelper.copyDirectory(logFile, backupLogFile);
                logFile.delete();
                logFile.createNewFile();
                Logger.initFileStream();
                Logger.printReleaseVersion();
            }
        }
        catch (Exception exception) {
            Log.e((String)"log", (String)("Log file exception: " + exception.getMessage()));
        }
    }

    public static void printReleaseVersion() {
        String frameworkReleaseVersion = FrameworkVersion.getFrameworkSVNText();
        String applicationVersion = FrameworkVersion.getApplicationVersion();
        String frameworkVersion = FrameworkVersion.getFrameworkVersion();
        Logger.i("UNVIRED KERNEL VERSION:" + frameworkVersion);
        Logger.i("APPLICATION VERSION:" + applicationVersion);
        Logger.i("UNVIRED KERNEL RELEASE INFO:" + frameworkReleaseVersion);
    }

    private static void writeIntoFile(final String data) {
        Logger.initializePath();
        Thread writeThread = new Thread(new Runnable(){

            @Override
            public synchronized void run() {
                try {
                    myOutWriter.append(data);
                    myOutWriter.flush();
                }
                catch (Exception e) {
                    Log.e((String)"log", (String)("Exception while writing to log file: " + e.getMessage()));
                }
            }
        });
        writeThread.setPriority(1);
        writeThread.start();
    }

    private static String readFromLogFile() {
        String data = "";
        try {
            String line;
            FileInputStream fIn = new FileInputStream(logFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(fIn));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) continue;
                sb.append(line);
                sb.append('\n');
            }
            data = sb.toString();
        }
        catch (Exception e) {
            Logger.log(8, Logger.class.getSimpleName(), "readFromLogFile", "Error occurred while reading Logs file content to StringBuilder." + e.getMessage());
        }
        return data;
    }

    public static String getLogs() {
        return Logger.readFromLogFile();
    }

    public static String getLogFilePath() {
        return logFilePathAndName;
    }

    public static void deleteLogs() {
        File myFile = new File(Logger.getBackupLogFilePath());
        myFile.delete();
        try {
            myOutWriter.close();
            logFile.delete();
            logFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Logger.initFileStream();
        Logger.writeIntoFile("LOG CLEARED ON  " + FrameworkHelper.getDateString(System.currentTimeMillis()));
    }

    private static String getStringFromLevel(int value) {
        switch (value) {
            case 7: {
                return "IMPORTANT";
            }
            case 8: {
                return "ERROR";
            }
            case 9: {
                return "DEBUG";
            }
            case 10: {
                return "INFO";
            }
            case 11: {
                return "WARNING";
            }
        }
        return null;
    }

    private static String getZippedTempLogPath(String srcPath, String zipPath) {
        if (new File(zipPath).exists()) {
            new File(zipPath).delete();
        }
        String[] filesToZip = new String[]{srcPath};
        if (new File(Logger.getBackupLogFilePath()).exists()) {
            filesToZip = new String[]{srcPath, Logger.getBackupLogFilePath()};
        }
        FileHelper.zip(filesToZip, zipPath);
        return zipPath;
    }

    public static void sendLogToServerInSync(ILogSenderCallback logSenderCallback) throws ApplicationException {
        try {
            new LogSenderThread(logSenderCallback).start();
        }
        catch (Exception e) {
            Logger.e("Exception caught while serving Log request from server.", e);
        }
    }

    public static void sendLogFileViaEmail(Activity activity, String mailTo, String subject, String message) {
        Uri path;
        UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
        mailTo = mailTo == null || mailTo.isEmpty() ? "" : mailTo;
        try {
            subject = subject == null || subject.isEmpty() ? "Logs from " + userSettingsManager.getUnviredUserId() + "-" + userSettingsManager.getCustomDeviceId() + " for " + ApplicationManager.getInstance().getApplicationName() : subject;
        }
        catch (DBException e) {
            Logger.e("Error while forming Email subject for Sending logs over Email.", e);
        }
        String tempLogPath = PathManager.getInstance().getAAccountsRootPath() + "LOGS.txt";
        File tempLogFile = new File(tempLogPath);
        if (tempLogFile.exists()) {
            tempLogFile.delete();
        }
        if (!tempLogFile.exists()) {
            try {
                if (!tempLogFile.createNewFile()) {
                    Logger.log(8, Logger.class.getName(), "sendLogFileViaEmail", "Error while creating temp log file.");
                    return;
                }
            }
            catch (IOException e) {
                Logger.e("IOException caught while creating temp log file", e);
                return;
            }
        }
        Logger.dumpFrameworkSnapshotToLog(tempLogFile);
        if (!FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").exists()) {
            FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").mkdirs();
        }
        String _zipFile = FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").getAbsolutePath() + "/unv_log.zip";
        File logFile = new File(Logger.getZippedTempLogPath(tempLogPath, _zipFile));
        new File(tempLogPath).delete();
        try {
            path = FileProvider.getUriForFile((Context)activity, (String)(activity.getApplication().getPackageName() + ".provider"), (File)logFile);
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
            path = Uri.fromFile((File)logFile);
        }
        Intent send = new Intent("android.intent.action.SEND", Uri.parse((String)("mailto:" + mailTo)));
        send.putExtra("android.intent.extra.SUBJECT", subject);
        send.putExtra("android.intent.extra.TEXT", message);
        send.setType("text/plain");
        send.putExtra("android.intent.extra.STREAM", (Parcelable)path);
        send.putExtra("android.intent.extra.EMAIL", new String[]{mailTo});
        activity.startActivity(Intent.createChooser((Intent)send, (CharSequence)"Send the file using:"));
    }

    private static void dumpFrameworkSnapshotToLog(File tempLogFile) {
        String addOnMessage = "\n\n========================= FRAMEWORK SNAPSHOT=====================================\n";
        addOnMessage = addOnMessage + "\n\n========================= MESSAGE COUNT=====================================\n";
        try {
            IDataManager fwDataManager = FrameworkManager.getInstance().getDataManager();
            IDataStructure[] dataStructures = fwDataManager.get(OutObject.TABLE_NAME, OutObject.class);
            if (dataStructures == null || dataStructures.length <= 0) {
                addOnMessage = addOnMessage + "OUTBOX COUNT 0 =====================================================\n";
            } else {
                addOnMessage = addOnMessage + "OUTBOX COUNT " + dataStructures.length + "=====================================================\n";
                addOnMessage = addOnMessage + "OUTBOX CONTENT ===================================================\n";
                for (IDataStructure outObjects : dataStructures) {
                    OutObject out = (OutObject)outObjects;
                    addOnMessage = addOnMessage + out.getBEName() + " " + out.getBELid() + " " + out.getFunctionName() + " " + out.getRequestType() + " " + out.getMessageType() + " " + out.getMessageSubType() + " " + out.getConversationId() + " " + out.getTimeStamp() + LOG_LINE_SEPARATOR;
                }
            }
            dataStructures = fwDataManager.get(SentItemObject.TABLE_NAME, SentItemObject.class);
            if (dataStructures == null || dataStructures.length <= 0) {
                addOnMessage = addOnMessage + "SENTITEM COUNT 0 =====================================================\n";
            } else {
                addOnMessage = addOnMessage + "SENTITEM COUNT " + dataStructures.length + "=====================================================\n";
                addOnMessage = addOnMessage + "SENTITEM CONTENT  =====================================================\n";
                for (IDataStructure sentItems : dataStructures) {
                    SentItemObject sent = (SentItemObject)sentItems;
                    addOnMessage = addOnMessage + sent.getBeName() + " " + sent.getBeHeaderLid() + " " + sent.getConversationId() + " " + sent.getTimeStamp() + LOG_LINE_SEPARATOR;
                }
            }
            dataStructures = fwDataManager.get(InObject.TABLE_NAME, InObject.class);
            if (dataStructures == null || dataStructures.length <= 0) {
                addOnMessage = addOnMessage + "INBOX COUNT 0 =====================================================\n";
            } else {
                addOnMessage = addOnMessage + "INBOX COUNT " + dataStructures.length + "=====================================================\n";
                addOnMessage = addOnMessage + "INBOX CONTENT  =====================================================\n";
                for (IDataStructure inObjects : dataStructures) {
                    InObject in = (InObject)inObjects;
                    addOnMessage = addOnMessage + in.getBEName() + " " + in.getRequestType() + " " + in.getServerId() + " " + in.getMessageType() + " " + in.getMessageSubType() + " " + in.getConversationId() + " " + in.getTimeStamp() + LOG_LINE_SEPARATOR;
                }
            }
            dataStructures = fwDataManager.get("INFO_MESSAGE", InfoMessage.class);
            if (dataStructures == null || dataStructures.length <= 0) {
                addOnMessage = addOnMessage + "INFOMESSAGES COUNT 0 =====================================================\n";
            } else {
                addOnMessage = addOnMessage + "INFOMESSAGES COUNT " + dataStructures.length + "=====================================================\n";
                addOnMessage = addOnMessage + "INFOMESSAGES CONTENT  =====================================================\n\n";
                for (IDataStructure infoMessage : dataStructures) {
                    InfoMessage info = (InfoMessage)infoMessage;
                    addOnMessage = addOnMessage + info.getBEName() + " " + info.getBeLid() + " " + info.getCategory() + " " + info.getType() + " " + info.getSubType() + " " + info.getMessage() + " " + info.getTimeStamp() + LOG_LINE_SEPARATOR;
                }
            }
            addOnMessage = addOnMessage + "\n===================THREAD STATUS==============================\n";
            addOnMessage = addOnMessage + "IS DATA SENDER RUNNING?============" + DataSender.getInstance().isAlive() + LOG_LINE_SEPARATOR;
            addOnMessage = addOnMessage + "IS DATA RETRIEVER RUNNING?============" + DataRetrieverService.getInstance().isAlive() + LOG_LINE_SEPARATOR;
            addOnMessage = addOnMessage + "IS INBOX HANDLER RUNNING?============" + InboxHandler.getInstance().isAlive() + LOG_LINE_SEPARATOR;
        }
        catch (Exception e) {
            Logger.e("Error while creating  framework snapshot add on messages for Log ", e);
        }
        try {
            FileHelper.copyDirectory(new File(logFilePathAndName), tempLogFile);
            if (!tempLogFile.exists()) {
                Logger.log(8, Logger.class.getName(), "dumpFrameworkSnapshotToLog", "Error while creating duplicate Log copy. ");
            } else {
                FileHelper.writeToFile(tempLogFile, addOnMessage, true);
            }
        }
        catch (IOException e) {
            Logger.e("IQException caught while writing framework snapshot add on messages to temp Log file.", e);
        }
        catch (Exception e) {
            Logger.e("Exception caught while writing framework snapshot add on messages to temp Log file.", e);
        }
        Logger.log(9, Logger.class.getName(), "dumpFrameworkSnapshotToLog", "Log content dumped to temp log file.");
    }

    public static void resetLogFilePath() {
        if (!Strings.isNullOrEmpty((String)logFilePathAndName)) {
            logFilePathAndName = null;
            logFile = null;
        }
        Logger.initializePath();
        Logger.initFileStream();
    }

    private static String getBackupLogFilePath() {
        return logFilePathAndName.replaceAll("LOG.txt", "LOG_BACKUP.txt");
    }

    public static interface ILogSenderCallback {
        public void finish();
    }

    static class LogSenderThread
    extends Thread {
        private ILogSenderCallback logSenderCallback;

        public LogSenderThread(ILogSenderCallback logSenderCallback) {
            this.logSenderCallback = logSenderCallback;
        }

        @Override
        public void run() {
            this.createAndUploadLogs();
            if (this.logSenderCallback != null) {
                this.logSenderCallback.finish();
            }
        }

        private synchronized void createAndUploadLogs() {
            MessageHelper messageHelper = MessageHelper.getInstance();
            try {
                String tempLogPath = PathManager.getInstance().getAAccountsRootPath() + "LOGS.txt";
                File tempLogFile = new File(tempLogPath);
                if (tempLogFile.exists()) {
                    tempLogFile.delete();
                }
                if (!tempLogFile.exists()) {
                    try {
                        if (!tempLogFile.createNewFile()) {
                            Logger.log(8, SystemMessageHandler.class.getName(), "sendLogToServerInSync", "Error while creating temp log file.");
                            return;
                        }
                    }
                    catch (IOException e) {
                        Logger.e("IOException caught while creating temp log file." + e.getMessage());
                        return;
                    }
                }
                FrameworkAttachment attachmentItem = new FrameworkAttachment();
                Logger.dumpFrameworkSnapshotToLog(tempLogFile);
                String _zipFile = PathManager.getInstance().getAAccountsRootPath() + "unv_log.zip";
                Logger.getZippedTempLogPath(tempLogPath, _zipFile);
                try {
                    Logger.log(7, Logger.class.getSimpleName(), "sendLogToServerInSync", "Uploaded Log File Size :" + new File(_zipFile).getTotalSpace() + " bytes");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String appName = ApplicationManager.getInstance().getApplicationName();
                attachmentItem.setFileName(appName + "_LOG");
                attachmentItem.setMimeType("application/zip");
                attachmentItem.setLocalPath(_zipFile);
                AttachmentResponse attachmentResponse = HTTPConnection.uploadAttachment(attachmentItem, false, false, "UPLOAD_LOG");
                try {
                    FileHelper.deleteFile(new File(_zipFile));
                    FileHelper.deleteFile(new File(tempLogPath));
                }
                catch (IOException e) {
                    Logger.log(8, Logger.class.getName(), "sendLogToServerInSync", "Error while deleting temp log file and zip file." + e.getMessage());
                }
                Looper.prepare();
                if ("SUCCESS".equalsIgnoreCase(attachmentResponse.getStatus())) {
                    Toast.makeText((Context)LoginParameters.getContext(), (CharSequence)messageHelper.getValue(messageHelper.SENDING_LOG_SUCCESS), (int)1).show();
                } else {
                    Toast.makeText((Context)LoginParameters.getContext(), (CharSequence)messageHelper.getValue(messageHelper.SENDING_LOG_FAILED), (int)1).show();
                }
                Looper.loop();
            }
            catch (Exception e) {
                Logger.e("Exception caught while sending Log file to server." + e.getMessage());
                Toast.makeText((Context)LoginParameters.getContext(), (CharSequence)messageHelper.getValue(messageHelper.SENDING_LOG_FAILED), (int)1).show();
            }
        }
    }
}

