/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.login;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.core.RuntimeEngine;
import com.unvired.core.SystemCredentialManager;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.exception.ApplicationException;
import com.unvired.fcm.RegisterToFCM;
import com.unvired.logger.Logger;
import com.unvired.login.AuthenticationResponse;
import com.unvired.login.DemoModeListener;
import com.unvired.login.IAuthenticationResponse;
import com.unvired.login.LoginListener;
import com.unvired.login.LoginParameters;
import com.unvired.login.MultipleFrontendUsersResponse;
import com.unvired.login.UnviredAccount;
import com.unvired.model.InfoMessage;
import com.unvired.model.MobileAppSettings;
import com.unvired.model.MobileUserSettings;
import com.unvired.model.SystemCredential;
import com.unvired.parser.ApplicationNameAndVersionParser;
import com.unvired.parser.ServerAuthenticationResponseParser;
import com.unvired.parser.ServerAuthenticationUIDParser;
import com.unvired.parser.UBXMLParser;
import com.unvired.security.Security;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.in.MD5Encryption;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.sync.out.ServerErrors;
import com.unvired.sync.response.HTTPResponse;
import com.unvired.sync.ssl.ModifiedX509TrustManager;
import com.unvired.ui.AccountsActivity;
import com.unvired.ui.DemoModeSelectionActivity;
import com.unvired.ui.LoginActivity;
import com.unvired.ui.LoginLocalActivity;
import com.unvired.ui.ServerErrorMessageActivity;
import com.unvired.ui.UIStyle;
import com.unvired.ui.VersionUpgradeActivity;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.DemoHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.PathManager;
import com.unvired.utils.TokenHelper;
import com.unvired.utils.UpdateManager;
import com.unvired.utils.uiutils.ProgressButton;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@SuppressLint(value={"InlinedApi"})
public class AuthenticationService {
    private static boolean loginSuccessful = false;
    public static boolean containsLocalKeyword = false;
    public static Activity loginActivity = null;
    public static ProgressButton progressButton = null;

    public static void login(Context context) throws ApplicationException, DBException {
        String metaDataXml = LoginParameters.getMetaData();
        FrameworkHelper.setApplicationContext(context);
        AuthenticationService.setApplicationNameAndVersion();
        if (!PathManager.getInstance().initializeApplicationStorage()) {
            return;
        }
        if (!Strings.isNullOrEmpty((String)LoginParameters.getUrl()) && !AuthenticationService.ping()) {
            return;
        }
        if (AuthenticationService.checkAndSetActiveAccount()) {
            return;
        }
        AuthenticationService.continueLoginWithSelectedAccount(context, LoginParameters.getAppName(), metaDataXml);
        Logger.printReleaseVersion();
    }

    private static void setApplicationNameAndVersion() throws ApplicationException {
        ApplicationNameAndVersionParser applicationNameAndVersionParser;
        try {
            applicationNameAndVersionParser = new ApplicationNameAndVersionParser(LoginParameters.getMetaData());
        }
        catch (Exception e) {
            String error = "Application name cannot be obtained from the meta data file. Please contact your administrator." + e.getMessage();
            throw new ApplicationException(AuthenticationService.class.getName(), "loginWithUnviredId", error);
        }
        String appName = applicationNameAndVersionParser.getApplicationName();
        if (appName == null || appName.length() == 0) {
            throw new ApplicationException(AuthenticationService.class.getName(), "loginWithUnviredId", "Invalid application name or no application name available");
        }
        LoginParameters.setAppName(appName);
        LoginParameters.setAppVersion(applicationNameAndVersionParser.getApplicationVersion());
    }

    public static void switchAccount(Context context, UnviredAccount unviredAccount) throws DBException, ApplicationException {
        AuthenticationService.logout();
        PathManager.getInstance().setActiveAccount(unviredAccount);
        AuthenticationService.continueLoginWithSelectedAccount(context, LoginParameters.getAppName(), LoginParameters.getMetaData());
    }

    public static IAuthenticationResponse authenticateAndActivate(Context context) {
        IAuthenticationResponse authenticationResponse;
        String errMessage;
        try {
            AuthenticationService.setApplicationNameAndVersion();
        }
        catch (Exception e) {
            AuthenticationResponse authenticationResponse2 = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, "Not able to read application name and version from metadata.");
            return authenticationResponse2;
        }
        if (LoginParameters.isMultiAccEnabled() && (errMessage = AuthenticationService.isAccountExist()) != null) {
            AuthenticationResponse authenticationResponse3 = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errMessage);
            return authenticationResponse3;
        }
        HTTPResponse httpResponse = HTTPConnection.authenticateAndActivate(context);
        int responseCode = httpResponse.getResponseCode();
        block4 : switch (responseCode) {
            case 200: {
                int messageSubType;
                int messageType;
                Hashtable<String, String> httpHeaderFields = httpResponse.getServerFields();
                String messageTypeString = httpHeaderFields.get("X-UNVIRED-MESSAGE-TYPE");
                String messageSubTypeString = httpHeaderFields.get("X-UNVIRED-MESSAGE-SUB-TYPE");
                try {
                    messageType = Integer.parseInt(messageTypeString);
                    messageSubType = Integer.parseInt(messageSubTypeString);
                }
                catch (NumberFormatException e) {
                    String errorMessage = "Incorrect response from the server. Cannot authenticate. Please try again. Technical message - Message Type: " + messageTypeString + "Message Sub Type: " + messageSubTypeString;
                    AuthenticationResponse authenticationResponse4 = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
                    return authenticationResponse4;
                }
                if (messageSubType == 700) {
                    byte[] responseBytes = httpResponse.getResponseBytes();
                    String message = new String(responseBytes);
                    IAuthenticationResponse authenticationResponse5 = message.isEmpty() || message.contains("null") ? new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.SUCCESS, "MESSAGE_SUBTYPE_GET_LOGIN_TOKEN") : AuthenticationService.getAllFrontEndIdsSentFromServer(responseBytes);
                    return authenticationResponse5;
                }
                if (messageType == 9000 && messageSubType == 810) {
                    IAuthenticationResponse authenticationResponse6 = AuthenticationService.getAllFrontEndIdsSentFromServer(httpResponse.getResponseBytes());
                    return authenticationResponse6;
                }
                authenticationResponse = AuthenticationService.handleActivationResponse(context, httpResponse, false);
                LoginParameters.LOGIN_TYPE loginType = LoginParameters.getCurrentLoginType();
                if (!loginType.equals((Object)LoginParameters.LOGIN_TYPE.SAP) && !loginType.equals((Object)LoginParameters.LOGIN_TYPE.ADS)) break;
                try {
                    SystemCredential[] systemCredentials = SystemCredentialManager.getClientCredentials();
                    if (systemCredentials == null || systemCredentials.length <= 0) break;
                    for (SystemCredential systemCredential : systemCredentials) {
                        if (systemCredential.getPortName() == null || !systemCredential.getPortName().equalsIgnoreCase(LoginParameters.getADSDomain())) continue;
                        systemCredential.setUserId(LoginParameters.getADSUserId());
                        systemCredential.setPassword(LoginParameters.getADSPassword());
                        systemCredential.setPortName(LoginParameters.getADSDomain());
                        SystemCredentialManager.saveOrUpdate(systemCredentials);
                        break block4;
                    }
                    break;
                }
                catch (Exception e) {
                    Logger.e("Exception caught while saving SystemCredential on successful authentication for ADS or SAP.", e);
                    break;
                }
            }
            case 526: {
                try {
                    HTTPConnection.trustOurHosts();
                }
                catch (Exception e) {
                    Logger.log(8, AuthenticationService.class.getSimpleName(), "authenticateAndActivate", "Error while checking for trusted certificate." + e.getMessage());
                }
                while (ModifiedX509TrustManager.isCertificateDialogOpen) {
                }
                if (ModifiedX509TrustManager.isCertificateAccepted()) {
                    return AuthenticationService.authenticateAndActivate(context);
                }
                authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, "Certificate not trusted. Please contact your administrator!");
                break;
            }
            default: {
                String errorMessage;
                boolean runningOnGlass = FrameworkHelper.isRunningOnGlass();
                if (!runningOnGlass) {
                    MessageHelper messageHelper = MessageHelper.getInstance();
                    errorMessage = context != null && context.getResources() != null ? messageHelper.getValue(messageHelper.AUTH_ERROR_INVALID_RESPONSE_FROM_SERVER) + " " + responseCode + ": " + httpResponse.getErrorMessage() : messageHelper.getValue(messageHelper.AUTH_ERROR_INVALID_RESPONSE_FROM_SERVER);
                } else {
                    errorMessage = httpResponse.getErrorMessage();
                }
                authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            }
        }
        return authenticationResponse;
    }

    public static IAuthenticationResponse register(Context context) {
        IAuthenticationResponse authenticationResponse;
        String errMessage;
        try {
            AuthenticationService.setApplicationNameAndVersion();
        }
        catch (Exception e) {
            AuthenticationResponse authenticationResponse2 = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, "Not able to read application name and version from metadata.");
            return authenticationResponse2;
        }
        if (LoginParameters.isMultiAccEnabled() && (errMessage = AuthenticationService.isAccountExist()) != null) {
            AuthenticationResponse authenticationResponse3 = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errMessage);
            return authenticationResponse3;
        }
        if (LoginParameters.getUrl() != null && LoginParameters.getUrl().toLowerCase().contains("https")) {
            try {
                HTTPConnection.trustOurHosts();
            }
            catch (Exception e) {
                Logger.log(8, AuthenticationService.class.getSimpleName(), "authenticateAndActivate", "Error while checking for trusted certificate." + e.getMessage());
            }
            if (!ModifiedX509TrustManager.isAlreadyTrusted) {
                while (ModifiedX509TrustManager.isCertificateDialogOpen) {
                }
                if (!ModifiedX509TrustManager.isCertificateAccepted()) {
                    AuthenticationResponse authenticationResponse4 = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, "Certificate not trusted. Please contact your administrator!");
                    return authenticationResponse4;
                }
            }
        }
        HTTPResponse httpResponse = HTTPConnection.register(context);
        int responseCode = httpResponse.getResponseCode();
        switch (responseCode) {
            case 200: {
                int messageSubType;
                int messageType;
                Hashtable<String, String> httpHeaderFields = httpResponse.getServerFields();
                String messageTypeString = httpHeaderFields.get("X-UNVIRED-MESSAGE-TYPE");
                String messageSubTypeString = httpHeaderFields.get("X-UNVIRED-MESSAGE-SUB-TYPE");
                try {
                    messageType = Integer.parseInt(messageTypeString);
                    messageSubType = Integer.parseInt(messageSubTypeString);
                }
                catch (NumberFormatException e) {
                    String errorMessage = "Incorrect response from the server. Cannot authenticate. Please try again. Technical message - Message Type: " + messageTypeString + "Message Sub Type: " + messageSubTypeString;
                    AuthenticationResponse authenticationResponse5 = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
                    return authenticationResponse5;
                }
                if (messageType == 9000 && messageSubType == 810) {
                    IAuthenticationResponse authenticationResponse6 = AuthenticationService.getAllFrontEndIdsSentFromServer(httpResponse.getResponseBytes());
                    return authenticationResponse6;
                }
                authenticationResponse = AuthenticationService.handleActivationResponse(context, httpResponse, true);
                break;
            }
            default: {
                String errorMessage;
                boolean runningOnGlass = FrameworkHelper.isRunningOnGlass();
                if (!runningOnGlass) {
                    MessageHelper messageHelper = MessageHelper.getInstance();
                    errorMessage = context != null && context.getResources() != null ? messageHelper.getValue(messageHelper.AUTH_ERROR_INVALID_RESPONSE_FROM_SERVER) + " " + responseCode + ": " + httpResponse.getErrorMessage() : messageHelper.getValue(messageHelper.AUTH_ERROR_INVALID_RESPONSE_FROM_SERVER);
                } else {
                    errorMessage = httpResponse.getErrorMessage();
                }
                authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            }
        }
        return authenticationResponse;
    }

    public static AuthenticationResponse authenticateLocal(Context context) {
        UserSettingsManager userSettingsManager;
        MessageHelper messageHelper = MessageHelper.getInstance();
        String appName = LoginParameters.getAppName();
        String metaDataXml = LoginParameters.getMetaData();
        String frameworkDatabaseKey = FrameworkHelper.getUniqueId();
        try {
            AuthenticationService.setApplicationNameAndVersion();
        }
        catch (Exception e) {
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, "Not able to read application name and version from metadata.");
            return authenticationResponse;
        }
        try {
            RuntimeEngine.getInstance().initialize(context, appName, metaDataXml, frameworkDatabaseKey);
        }
        catch (DBException e) {
            String errorMessage = messageHelper.getValue(messageHelper.INVALID_CREDENTIALS);
            Logger.e("DBException caught while initialize RuntimeEngine.", e);
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            return authenticationResponse;
        }
        catch (ApplicationException e) {
            String errorMessage = "Application exception:" + e.getMessage();
            Logger.e(errorMessage);
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            return authenticationResponse;
        }
        String storedUserId = null;
        String storedPassword = null;
        String storedPasswordMD5 = null;
        try {
            UserSettingsManager userSettingsManager2 = UserSettingsManager.getInstance();
            LoginParameters.LOGIN_TYPE loginType = userSettingsManager2.getLoginType();
            switch (loginType) {
                case UNVIRED_ID: {
                    storedUserId = userSettingsManager2.getUnviredUserId();
                    storedPassword = userSettingsManager2.getUnviredPassword();
                    storedPasswordMD5 = userSettingsManager2.getMD5Password();
                    break;
                }
                case EMAIL: {
                    storedUserId = userSettingsManager2.getEmail();
                    storedPassword = userSettingsManager2.getUnviredPassword();
                    storedPasswordMD5 = userSettingsManager2.getMD5Password();
                    break;
                }
                case SAP: 
                case ADS: {
                    storedUserId = userSettingsManager2.getADSUserId();
                    storedPassword = userSettingsManager2.getADSPassword();
                    break;
                }
            }
        }
        catch (DBException e) {
            String errorMessage = "DB Exception while trying to access user credentials: " + e.getMessage();
            Logger.e(errorMessage, e);
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            return authenticationResponse;
        }
        String userProvidedUserId = LoginParameters.getUnviredUserId();
        String userEnteredPassword = LoginParameters.getUnviredPassword();
        try {
            userSettingsManager = UserSettingsManager.getInstance();
            LoginParameters.LOGIN_TYPE loginType = userSettingsManager.getLoginType();
            if (loginType == LoginParameters.LOGIN_TYPE.ADS || loginType == LoginParameters.LOGIN_TYPE.SAP) {
                FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
                String aesSecurityKey = frameworkSettingsManager.getSecKey();
                aesSecurityKey = aesSecurityKey.substring(aesSecurityKey.lastIndexOf(58) + 1, aesSecurityKey.length());
                storedPassword = Security.decryptAES(aesSecurityKey.getBytes(), storedPassword.getBytes());
            }
        }
        catch (Exception e) {
            Logger.e("Exception caught while decrypting password using AES key.", e);
        }
        if (storedPassword == null && storedPasswordMD5 != null) {
            storedPassword = storedPasswordMD5;
            userEnteredPassword = MD5Encryption.generateKey(userEnteredPassword);
        }
        if (storedUserId.equalsIgnoreCase(userProvidedUserId) && storedPassword.equals(userEnteredPassword)) {
            try {
                userSettingsManager = UserSettingsManager.getInstance();
                switch (userSettingsManager.getLoginType()) {
                    case UNVIRED_ID: 
                    case EMAIL: {
                        storedPassword = userSettingsManager.getUnviredPassword();
                        storedPasswordMD5 = userSettingsManager.getMD5Password();
                        if (storedPassword != null || storedPasswordMD5 == null) break;
                        userSettingsManager.setUnviredPassword(LoginParameters.getUnviredPassword());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String successMessage = messageHelper.getValue(messageHelper.AUTHENTICATION_SUCCESSFUL);
            SyncEngine.getInstance().initialize();
            loginSuccessful = true;
            if (LoginParameters.isMultiAccEnabled()) {
                PathManager.getInstance().setLastLoginUnviredAccount(PathManager.getInstance().getActiveAccount());
            }
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.SUCCESS, successMessage);
            return authenticationResponse;
        }
        String errorMessage = messageHelper.getValue(messageHelper.INVALID_CREDENTIALS);
        AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
        return authenticationResponse;
    }

    public static AuthenticationResponse reAuthenticate(Context context, String userId, String password) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        String appName = LoginParameters.getAppName();
        String metaDataXml = LoginParameters.getMetaData();
        RuntimeEngine runtimeEngine = RuntimeEngine.getInstance();
        boolean frameworkInitialized = RuntimeEngine.isFrameworkInitialized();
        try {
            AuthenticationService.setApplicationNameAndVersion();
        }
        catch (Exception e) {
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, "Not able to read application name and version from metadata.");
            return authenticationResponse;
        }
        try {
            if (!frameworkInitialized) {
                String frameworkDatabaseKey = FrameworkHelper.getUniqueId();
                runtimeEngine.initialize(context, appName, metaDataXml, frameworkDatabaseKey);
            }
            UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
            LoginParameters.LOGIN_TYPE loginType = userSettingsManager.getLoginType();
            switch (loginType) {
                case UNVIRED_ID: 
                case EMAIL: {
                    LoginParameters.setUnviredIdCredentials(userId, password);
                    break;
                }
                case SAP: 
                case ADS: {
                    String adsDomain = userSettingsManager.getADSDomain();
                    LoginParameters.setADSCredentials(userId, password, adsDomain);
                    break;
                }
            }
        }
        catch (DBException e) {
            String errorMessage = messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID);
            Logger.e(e.getMessage());
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
        }
        catch (ApplicationException e) {
            String errorMessage = "Application exception: " + e.getMessage();
            Logger.e(e.getMessage());
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
        }
        HTTPResponse httpResponse = HTTPConnection.authenticate(context);
        int responseCode = httpResponse.getResponseCode();
        switch (responseCode) {
            case 200: {
                AuthenticationResponse authenticationResponse = AuthenticationService.handleAuthenticationResponse(httpResponse);
                if (IAuthenticationResponse.RESPONSE_STATUS.SUCCESS == authenticationResponse.getResponseStatus()) {
                    try {
                        AuthenticationService.updateLoginCredentials(httpResponse);
                    }
                    catch (DBException e) {
                        String errorMessage = "DB Exception. Cannot update new password in database after verifying with server: " + e.getMessage();
                        Logger.e(errorMessage, e);
                        return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
                    }
                    catch (ApplicationException e) {
                        String errorMessage = "Application Exception: " + e.getMessage();
                        Logger.e(errorMessage, e);
                        return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
                    }
                }
                return authenticationResponse;
            }
        }
        String errorMessage = messageHelper.getValue(messageHelper.AUTH_ERROR_INVALID_RESPONSE_FROM_SERVER) + " " + responseCode + ": " + httpResponse.getErrorMessage();
        return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
    }

    public static AuthenticationResponse authenticateBackendCredentials(SystemCredential systemCredential) {
        HTTPResponse serverResponse = null;
        String errorMessage = "";
        try {
            serverResponse = HTTPConnection.authenticateBackendCredentials(systemCredential);
        }
        catch (DBException e) {
            Logger.e("DBException : Exception caught while authenticating Backend Credentials ", e);
        }
        catch (ApplicationException e) {
            Logger.e("ApplicationException : Exception caught while authenticating Backend Credentials", e);
        }
        int responseCode = serverResponse.getResponseCode();
        if (responseCode == 200) {
            byte[] responseBytes = serverResponse.getResponseBytes();
            boolean isSuccess = true;
            try {
                UBXMLParser parser = new UBXMLParser(responseBytes, null);
                Vector<InfoMessage> infoMessages = parser.getInfoMessages();
                if (infoMessages != null && infoMessages.size() > 0) {
                    for (int i = 0; i < infoMessages.size(); ++i) {
                        InfoMessage infoMessage = infoMessages.elementAt(i);
                        errorMessage = errorMessage != null && !errorMessage.equalsIgnoreCase("") ? errorMessage + " " + infoMessage.getMessage() : infoMessage.getMessage();
                        if (infoMessage.getCategory() != null && infoMessage.getCategory().equals("FAILURE")) {
                            isSuccess = false;
                        }
                        FrameworkManager.getInstance().getDataManager().insertOrUpdateBasedOnGID(infoMessage);
                    }
                }
            }
            catch (DBException e) {
                Logger.e("DBException while iterating through info messages received from server.", e);
            }
            catch (ApplicationException e) {
                Logger.e("ApplicationException while parsing the data.", e);
            }
            if (isSuccess) {
                return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.SUCCESS, errorMessage);
            }
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
        }
        return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, serverResponse.getErrorMessage());
    }

    private static boolean checkAndSetActiveAccount() {
        if (PathManager.getInstance().getActiveAccount() != null) {
            return false;
        }
        List<UnviredAccount> allAccounts = PathManager.getInstance().getAllAccounts();
        if (allAccounts == null || allAccounts.size() == 0) {
            return false;
        }
        if (allAccounts.size() == 1) {
            PathManager.getInstance().setActiveAccount(allAccounts.get(0));
            return false;
        }
        if (LoginParameters.getLoginScreenType().equals((Object)LoginParameters.LOGIN_SCREEN_TYPE.CUSTOM)) {
            LoginListener loginListener = LoginParameters.getLoginListener();
            if (loginListener != null) {
                loginListener.invokeMultiAccountActivity(allAccounts);
            }
            return true;
        }
        Intent intent = new Intent(FrameworkHelper.getApplicationContext(), AccountsActivity.class);
        intent.setFlags(0x10000000);
        intent.putExtra("SWITCH_ACCOUNT", true);
        FrameworkHelper.getApplicationContext().startActivity(intent);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void continueLoginWithSelectedAccount(Context context, String appName, String metaDataXml) throws DBException, ApplicationException {
        LoginListener loginListener;
        boolean isVersionUpgraded;
        boolean demoModeRequired = LoginParameters.isDemoModeRequired();
        boolean dbAvailable = false;
        if (PathManager.getInstance().getActiveAccount() != null) {
            dbAvailable = PathManager.getInstance().isAppDatabaseFileExists();
        }
        boolean localPasswordRequired = true;
        if (dbAvailable) {
            localPasswordRequired = RuntimeEngine.getInstance().isLocalPasswordRequired(context, metaDataXml, appName);
        }
        if (!dbAvailable && demoModeRequired) {
            DemoModeSelectionActivity.setAppName(appName);
            SharedPreferences sharedPrefs = context.getSharedPreferences("VERSION_UPGRADE", 0);
            boolean fwUpgrade = sharedPrefs.getBoolean("FW_DB_UPGRADE", false);
            boolean appUpgrade = sharedPrefs.getBoolean("APP_DB_UPGRADE", false);
            if (!fwUpgrade && !appUpgrade) {
                AuthenticationService.invokeDemoModeSelectionActivity(context);
                return;
            }
            AuthenticationService.navigateToVersionUpgradeActivity(context);
            return;
        }
        SharedPreferences sharedPrefs = context.getSharedPreferences("VERSION_UPGRADE", 0);
        boolean fwUpgrade = sharedPrefs.getBoolean("FW_DB_UPGRADE", false);
        boolean appUpgrade = sharedPrefs.getBoolean("APP_DB_UPGRADE", false);
        boolean bl = isVersionUpgraded = fwUpgrade || appUpgrade;
        if (!dbAvailable || isVersionUpgraded) {
            LoginParameters.setLoginMode(LoginParameters.LOGIN_MODE.UNVIRED_ID_AUTH_ACTIVATE);
            LoginParameters.setAppName(appName);
            if (isVersionUpgraded) {
                AuthenticationService.navigateToVersionUpgradeActivity(context);
                return;
            }
            Logger.printReleaseVersion();
            AuthenticationService.invokeLoginActivity(context, false);
            return;
        }
        if (UpdateManager.isUpgrade()) {
            AuthenticationService.navigateToVersionUpgradeActivity(context);
            return;
        }
        if (localPasswordRequired && LoginParameters.getCurrentLoginType() != LoginParameters.LOGIN_TYPE.SAML2) {
            LoginParameters.setLoginMode(LoginParameters.LOGIN_MODE.UNVIRED_ID_LOCAL_AUTH);
            LoginParameters.setAppName(appName);
            AuthenticationService.invokeLoginActivity(context, true);
            return;
        }
        SyncEngine.getInstance().initialize();
        boolean demoMode = UserSettingsManager.getInstance().getDemoMode();
        if (demoMode) {
            DemoModeListener demoModeListener = LoginParameters.getDemoModeListener();
            if (demoModeListener != null) {
                demoModeListener.applicationStartedInDemoMode(context);
                return;
            }
            String error = "No demo mode listener registered";
            throw new ApplicationException(AuthenticationService.class.getName(), "loginWithUnviredId", error);
        }
        loginSuccessful = true;
        if (LoginParameters.isMultiAccEnabled()) {
            PathManager.getInstance().setLastLoginUnviredAccount(PathManager.getInstance().getActiveAccount());
        }
        if ((loginListener = LoginParameters.getLoginListener()) != null) {
            loginListener.loginSuccessful();
            return;
        }
        String error = "No login listener registered";
        throw new ApplicationException(AuthenticationService.class.getName(), "loginWithUnviredId", error);
    }

    private static String isAccountExist() {
        LoginParameters.LOGIN_TYPE loginType = LoginParameters.getCurrentLoginType();
        UnviredAccount account = loginType.equals((Object)LoginParameters.LOGIN_TYPE.ADS) || loginType.equals((Object)LoginParameters.LOGIN_TYPE.SAP) ? new UnviredAccount(LoginParameters.getADSUserId(), LoginParameters.getCompany(), LoginParameters.getUrl()) : new UnviredAccount(LoginParameters.getUnviredUserId(), LoginParameters.getCompany(), LoginParameters.getUrl());
        String accountPath = account.getAccountPath();
        try {
            String path = FrameworkHelper.getApplicationContext().getFilesDir().getAbsolutePath();
            path = path + "/ACCOUNTS/" + accountPath;
            path = path + "/" + "FRAMEWORK";
            File filePath = new File(path);
            if (filePath.exists()) {
                String message = "Account :" + account.getCompany() + "/" + account.getUserName() + " already exists!";
                Logger.log(8, AuthenticationService.class.getSimpleName(), "isAccountExist", message);
                return message;
            }
        }
        catch (Exception e) {
            Logger.e("Error while checking for account existence.", e);
        }
        return null;
    }

    public static void logout() {
        loginSuccessful = false;
        RegisterToFCM.unRegistrationFromServer();
        FrameworkHelper.shutdown();
        if (LoginParameters.isMultiAccEnabled()) {
            PathManager.getInstance().setLastLoginUnviredAccount(null);
        }
    }

    public static void setLoginSuccessful() {
        loginSuccessful = true;
        if (LoginParameters.isMultiAccEnabled()) {
            PathManager.getInstance().setLastLoginUnviredAccount(PathManager.getInstance().getActiveAccount());
        }
    }

    public static boolean isLoginSuccessful() {
        return loginSuccessful;
    }

    public static boolean isAuthenticated() throws ApplicationException, DBException {
        AuthenticationService.setApplicationNameAndVersion();
        return PathManager.getInstance().isAppDatabaseFileExists();
    }

    public static IAuthenticationResponse forgotPassword() {
        AuthenticationResponse authenticationResponse;
        HTTPResponse serverResponse = null;
        String message = "";
        try {
            serverResponse = HTTPConnection.forgotPassword();
        }
        catch (DBException e) {
            Logger.e("DBException : Exception caught while authenticating Backend Credentials", e);
        }
        catch (ApplicationException e) {
            Logger.e("ApplicationException : Exception caught while authenticating Backend Credentials", e);
        }
        int responseCode = serverResponse.getResponseCode();
        if (responseCode == 200) {
            byte[] responseBytes = serverResponse.getResponseBytes();
            try {
                UBXMLParser parser = new UBXMLParser(responseBytes, null);
                Vector<InfoMessage> infoMessages = parser.getInfoMessages();
                if (infoMessages != null && infoMessages.size() > 0) {
                    for (int i = 0; i < infoMessages.size(); ++i) {
                        InfoMessage infoMessage = infoMessages.elementAt(i);
                        message = message != null && !message.equalsIgnoreCase("") ? message + " " + infoMessage.getMessage() : infoMessage.getMessage();
                        FrameworkManager.getInstance().getDataManager().insertOrUpdateBasedOnGID(infoMessage);
                    }
                }
            }
            catch (DBException e) {
                Logger.e("DBException while iterating through info messages received from server", e);
            }
            catch (ApplicationException e) {
                Logger.e("ApplicationException while parsing the data.", e);
            }
            authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.SUCCESS, message);
        } else {
            authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, message);
        }
        return authenticationResponse;
    }

    public static IAuthenticationResponse resetPassword(String forgotToken, String newPassword) {
        AuthenticationResponse authenticationResponse;
        HTTPResponse serverResponse = null;
        String message = "";
        try {
            serverResponse = HTTPConnection.forgotPassword();
        }
        catch (DBException e) {
            Logger.e("DBException : Exception caught while authenticating Backend Credentials", e);
        }
        catch (ApplicationException e) {
            Logger.e("ApplicationException : Exception caught while authenticating Backend Credentials", e);
        }
        int responseCode = serverResponse.getResponseCode();
        if (responseCode == 200) {
            byte[] responseBytes = serverResponse.getResponseBytes();
            try {
                UBXMLParser parser = new UBXMLParser(responseBytes, null);
                Vector<InfoMessage> infoMessages = parser.getInfoMessages();
                if (infoMessages != null && infoMessages.size() > 0) {
                    for (int i = 0; i < infoMessages.size(); ++i) {
                        InfoMessage infoMessage = infoMessages.elementAt(i);
                        message = message != null && !message.equalsIgnoreCase("") ? message + " " + infoMessage.getMessage() : infoMessage.getMessage();
                        FrameworkManager.getInstance().getDataManager().insertOrUpdateBasedOnGID(infoMessage);
                    }
                }
            }
            catch (DBException e) {
                Logger.e("DBException while iterating through info messages received from server", e);
            }
            catch (ApplicationException e) {
                Logger.e("ApplicationException while parsing the data", e);
            }
            authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.SUCCESS, message);
        } else {
            authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, message);
        }
        return authenticationResponse;
    }

    private static IAuthenticationResponse handleActivationResponse(Context context, HTTPResponse httpResponse, boolean isRegisterCall) {
        ServerAuthenticationResponseParser serverAuthenticationResponseParser;
        int messageSubType;
        int messageType;
        Hashtable<String, String> serverFields = httpResponse.getServerFields();
        String serverId = serverFields.get("X-UNVIRED-SERVER-ID");
        String messageTypeString = serverFields.get("X-UNVIRED-MESSAGE-TYPE");
        String messageSubTypeString = serverFields.get("X-UNVIRED-MESSAGE-SUB-TYPE");
        String password = serverFields.get("X-UNVIRED-NEW-PASSWORD");
        if (messageTypeString == null || messageTypeString.equalsIgnoreCase("") || messageSubTypeString == null || messageSubTypeString.equalsIgnoreCase("")) {
            String errorMessage = "Incorrect response from the server. Cannot authenticate. Please try again. Technical message - Message Type: " + messageTypeString + "Message Sub Type: " + messageSubTypeString;
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            return authenticationResponse;
        }
        try {
            messageType = Integer.parseInt(messageTypeString);
            messageSubType = Integer.parseInt(messageSubTypeString);
        }
        catch (NumberFormatException e) {
            String errorMessage = "Incorrect response from the server. Cannot authenticate. Please try again. Technical message - Message Type: " + messageTypeString + "Message Sub Type: " + messageSubTypeString;
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            return authenticationResponse;
        }
        byte[] responseBytes = httpResponse.getResponseBytes();
        if (responseBytes == null) {
            String errorMessage = "Incorrect response from the server. Cannot authenticate. Please try again. Technical message - incoming response stream is null or empty.";
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            return authenticationResponse;
        }
        Logger.log(7, AuthenticationService.class.getName(), "handleActivationResponse", "Response from server not null. Processing started.");
        try {
            serverAuthenticationResponseParser = new ServerAuthenticationResponseParser(responseBytes, serverId, messageType, messageSubType);
        }
        catch (ApplicationException e) {
            String errorMessage = "Incorrect response from the server. Cannot authenticate. Please try again. Technical message: Cannot parse incoming response from server.";
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            return authenticationResponse;
        }
        if (messageType == 4000 && messageSubType == 200) {
            InfoMessage infoMessage = serverAuthenticationResponseParser.getInfoMessage();
            String errorMessage = infoMessage == null ? "Authentication failed without a valid error message from the server. Please try again or contact your system administrator" : infoMessage.getMessage();
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            return authenticationResponse;
        }
        if (messageType == 9000 && messageSubType == 800) {
            if (LoginParameters.getLoginScreenType().equals((Object)LoginParameters.LOGIN_SCREEN_TYPE.UNVIRED_STANDARD_SCREEN) && loginActivity != null && progressButton != null) {
                loginActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        progressButton.setBackground(UIStyle.getButtonBGDisabled());
                        progressButton.setEnabled(false);
                    }
                });
            }
            Hashtable<String, String> frameworkSettingsProperties = serverAuthenticationResponseParser.getFrameworkSettings();
            if (containsLocalKeyword) {
                String url = LoginParameters.getUrl();
                if (url.contains("?local")) {
                    String urlToBeReplaced = url.substring(url.lastIndexOf("?"));
                    url = url.replace(urlToBeReplaced, "");
                    containsLocalKeyword = false;
                }
                frameworkSettingsProperties.put("URL", url);
            } else {
                String allowOverride = frameworkSettingsProperties.get("OVERRIDE_UMP_URL");
                if ("YES".equalsIgnoreCase(allowOverride)) {
                    frameworkSettingsProperties.put("URL", LoginParameters.getUrl());
                }
            }
            if ((LoginParameters.getUnviredPassword() == null || LoginParameters.getUnviredPassword().isEmpty()) && TokenHelper.isTokenInfoAvailable()) {
                try {
                    String aesSecurityKey = frameworkSettingsProperties.get("SEC_KEY");
                    aesSecurityKey = aesSecurityKey.substring(aesSecurityKey.lastIndexOf(58) + 1, aesSecurityKey.length());
                    LoginParameters.setMD5Password(Security.decryptAES(aesSecurityKey.getBytes(), password.getBytes()));
                    TokenHelper.setData(null);
                }
                catch (ApplicationException e) {
                    e.printStackTrace();
                }
            }
            String applicationId = serverAuthenticationResponseParser.getApplicationId();
            if (frameworkSettingsProperties == null || frameworkSettingsProperties.size() == 0 || applicationId == null || applicationId.length() == 0) {
                String errorMessage = "Authentication response cannot be processed on the device. Please contact your administrator. Technical message: Framework Settings empty or application id not present.";
                AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
                return authenticationResponse;
            }
            IAuthenticationResponse activationResponse = isRegisterCall ? AuthenticationService.applicationAssignmentAndSendActivationResponseForRegisterToServer(applicationId, frameworkSettingsProperties, password) : AuthenticationService.applicationAssignmentAndSendActivationResponseToServer(applicationId, frameworkSettingsProperties, password);
            if (activationResponse.getResponseStatus() == IAuthenticationResponse.RESPONSE_STATUS.FAILURE) {
                if (activationResponse instanceof AuthenticationResponse) {
                    Logger.log(8, AuthenticationService.class.getSimpleName(), "handleActivationResponse", ((AuthenticationResponse)activationResponse).getMessage());
                }
                return activationResponse;
            }
            LoginParameters.LOGIN_TYPE loginType = LoginParameters.getCurrentLoginType();
            String url = frameworkSettingsProperties.get("URL");
            UnviredAccount account = loginType.equals((Object)LoginParameters.LOGIN_TYPE.ADS) || loginType.equals((Object)LoginParameters.LOGIN_TYPE.SAP) ? new UnviredAccount(LoginParameters.getADSUserId(), LoginParameters.getCompany(), url) : (loginType.equals((Object)LoginParameters.LOGIN_TYPE.EMAIL) && LoginParameters.getEmail() != null ? new UnviredAccount(LoginParameters.getEmail(), LoginParameters.getCompany(), url) : new UnviredAccount(LoginParameters.getUnviredUserId(), LoginParameters.getCompany(), url));
            if (!LoginParameters.isMultiAccEnabled()) {
                PathManager.getInstance().resetAccountRootDirectory();
            }
            PathManager.getInstance().setActiveAccount(account);
            Logger.log(7, AuthenticationService.class.getSimpleName(), "handleActivationResponse", "***********Creating Account on Auth & Activation success******** ");
            Logger.log(7, AuthenticationService.class.getSimpleName(), "handleActivationResponse", "***********Account Details ******** " + account.getAccountPath());
            String keyToEncryptDatabase = FrameworkHelper.getUniqueId();
            try {
                RuntimeEngine runtimeEngine = RuntimeEngine.getInstance();
                String applicationName = LoginParameters.getAppName();
                runtimeEngine.initializeFramework(context, applicationName, keyToEncryptDatabase);
                AuthenticationService.populateFrameworkSettings(frameworkSettingsProperties);
                AuthenticationService.updateUserSettings(frameworkSettingsProperties, serverFields);
                SystemCredential[] systemCredentials = serverAuthenticationResponseParser.getSystemCredential();
                SystemCredentialManager.saveOrUpdate(systemCredentials);
                AuthenticationService.SaveMobileAppAndUserSettings(serverAuthenticationResponseParser.getMobileAppSettings(), serverAuthenticationResponseParser.getMobileAppUserSettings());
                String metaDataXml = LoginParameters.getMetaData();
                runtimeEngine.initializeApplication(context, applicationName, metaDataXml);
                ApplicationManager applicationManager = ApplicationManager.getInstance();
                applicationManager.activateApplication(applicationId);
                if (LoginParameters.getUrl() != null && LoginParameters.getUrl().toLowerCase().contains("https") && ModifiedX509TrustManager.isCertificateAccepted()) {
                    SharedPreferences sharedPrefs = LoginParameters.getContext().getSharedPreferences("SSL_CERTIFICATE", 0);
                    SharedPreferences.Editor editor = sharedPrefs.edit();
                    editor.putString("SSL_CERTIFICATE", LoginParameters.getSSLCert());
                    editor.commit();
                }
                SyncEngine syncEngine = SyncEngine.getInstance();
                syncEngine.initialize();
            }
            catch (DBException e) {
                String errorMessage = "Authentication response cannot be processed on the device. Please contact your administrator. Technical message: DB Exception: " + e.getMessage();
                AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
                return authenticationResponse;
            }
            catch (ApplicationException e) {
                String errorMessage = "Authentication response processed on the device. But cannot sent activation response to server. Please contact your administrator. Technical message: Application Exception: " + e.getMessage();
                AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
                return authenticationResponse;
            }
            if (LoginParameters.isMultiAccEnabled()) {
                PathManager.getInstance().setLastLoginUnviredAccount(PathManager.getInstance().getActiveAccount());
            }
            MessageHelper messageHelper = MessageHelper.getInstance();
            String successMessage = messageHelper.getValue(messageHelper.AUTHENTICATION_SUCCESSFUL);
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.SUCCESS, successMessage);
            return authenticationResponse;
        }
        if (messageType == 4000 && messageSubType == 600) {
            InfoMessage infoMessage = serverAuthenticationResponseParser.getInfoMessage();
            if (infoMessage != null && infoMessage.getCategory().equals("FAILURE")) {
                AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, infoMessage.getMessage());
                return authenticationResponse;
            }
        } else {
            Logger.log(8, AuthenticationService.class.getName(), "handleActivationResponse", new String(responseBytes));
        }
        String errorMessage = "Cannot authenticate. Contact your administrator. Check the logs for more information.";
        AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
        return authenticationResponse;
    }

    private static void populateFrameworkSettings(Hashtable<String, String> frameworkSettingsProperties) throws DBException {
        FrameworkManager frameworkManager = FrameworkManager.getInstance();
        FrameworkSettingsManager frameworkSettingsManager = frameworkManager.getFrameworkSettingsManager();
        Enumeration<String> keys = frameworkSettingsProperties.keys();
        while (keys.hasMoreElements()) {
            String propertyName = keys.nextElement();
            String propertyValue = frameworkSettingsProperties.get(propertyName);
            if (!propertyName.equalsIgnoreCase("ONE_TIME_SECRET") && !propertyName.equalsIgnoreCase("SEC_KEY")) {
                Logger.log(7, AuthenticationService.class.getName(), "populateFrameworkSettings", propertyName + ": " + propertyValue);
            }
            frameworkSettingsManager.setField(propertyName, propertyValue);
        }
        if (!frameworkSettingsProperties.containsKey("LOCAL_PASSWORD")) {
            frameworkSettingsManager.setLocalPassword("YES");
        }
    }

    private static IAuthenticationResponse applicationAssignmentAndSendActivationResponseToServer(String applicationId, Hashtable<String, String> frameworkSettings, String password) {
        HTTPResponse httpResponse;
        byte[] xml;
        String applicationName = LoginParameters.getAppName();
        String activationId = frameworkSettings.get("ACT_ID");
        String serverId = frameworkSettings.get("ServerId");
        String companyAlias = LoginParameters.getCompany();
        Document activationDocument = AuthenticationService.getSenderDocumentRoot(9000, serverId, companyAlias, applicationName, applicationId);
        Element root = activationDocument.getDocumentElement();
        Element dataElement = activationDocument.createElement("data");
        dataElement.setAttribute("subtype", String.valueOf(800));
        root.appendChild(dataElement);
        Element activationIdElement = activationDocument.createElement("ACT_ID");
        activationIdElement.appendChild(activationDocument.createTextNode(activationId));
        dataElement.appendChild(activationIdElement);
        try {
            xml = FrameworkHelper.getBytes(activationDocument);
        }
        catch (ApplicationException e) {
            String error = "Cannot get bytes from activation document. Exception:" + e.getMessage();
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, error);
        }
        try {
            httpResponse = HTTPConnection.notifyApplicationActivation(xml, frameworkSettings, password);
        }
        catch (Exception e) {
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, "Cannot send activation response to server. Exception: " + e.getMessage());
        }
        int responseCode = httpResponse.getResponseCode();
        if (responseCode != 200) {
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, "Cannot send activation response to server. Please try again or contact your administrator.");
        }
        return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.SUCCESS, "Application activation sent to server.");
    }

    private static IAuthenticationResponse applicationAssignmentAndSendActivationResponseForRegisterToServer(String applicationId, Hashtable<String, String> frameworkSettings, String password) {
        int responseCode;
        byte[] xml;
        String applicationName = LoginParameters.getAppName();
        String activationId = frameworkSettings.get("ACT_ID");
        String serverId = frameworkSettings.get("ServerId");
        String companyAlias = LoginParameters.getCompany();
        Document activationDocument = AuthenticationService.getSenderDocumentRoot(9000, serverId, companyAlias, applicationName, applicationId);
        Element root = activationDocument.getDocumentElement();
        Element dataElement = activationDocument.createElement("data");
        dataElement.setAttribute("subtype", String.valueOf(800));
        root.appendChild(dataElement);
        Element activationIdElement = activationDocument.createElement("ACT_ID");
        activationIdElement.appendChild(activationDocument.createTextNode(activationId));
        dataElement.appendChild(activationIdElement);
        try {
            xml = FrameworkHelper.getBytes(activationDocument);
        }
        catch (ApplicationException e) {
            String error = "Cannot get bytes from activation document. Exception:" + e.getMessage();
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, error);
        }
        HTTPResponse httpResponse = null;
        ServerErrors.setIsWaitingEmailVerification(true);
        while (ServerErrors.isWaitingEmailVerification()) {
            try {
                httpResponse = HTTPConnection.notifyApplicationActivation(xml, frameworkSettings, password);
            }
            catch (Exception e) {
                return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, "Cannot send activation response to server. Exception: " + e.getMessage());
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Logger.log(8, AuthenticationService.class.getName(), "applicationAssignmentAndSendActivationResponseForRegisterToServer", "Error in Email verify waiting thread." + e.getMessage());
            }
        }
        if (ServerErrorMessageActivity.activity != null) {
            ServerErrorMessageActivity.activity.finish();
        }
        int n = responseCode = httpResponse != null ? httpResponse.getResponseCode() : 0;
        if (responseCode != 200) {
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, "Cannot send activation response to server. Please try again or contact your administrator.");
        }
        return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.SUCCESS, "Application activation sent to server.");
    }

    private static void SaveMobileAppAndUserSettings(Hashtable<String, String> mobileAppSettings, Vector<MobileUserSettings> mobileAppUserSettings) {
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        if (mobileAppSettings != null) {
            Enumeration<String> keys = mobileAppSettings.keys();
            while (keys.hasMoreElements()) {
                String propertyName = keys.nextElement();
                String propertyValue = mobileAppSettings.get(propertyName);
                MobileAppSettings mAppSettings = new MobileAppSettings();
                mAppSettings.setFieldName(propertyName);
                mAppSettings.setFieldValue(propertyValue);
                try {
                    frameworkDataManager.insert(mAppSettings);
                }
                catch (DBException e) {
                    Logger.log(7, AuthenticationService.class.getName(), "SaveMobileAppAndUserSettings", "Error while saving Mobile Application Settings." + e.getMessage());
                }
            }
        }
        if (mobileAppUserSettings != null) {
            for (int i = 0; i < mobileAppUserSettings.size(); ++i) {
                try {
                    frameworkDataManager.insert(mobileAppUserSettings.elementAt(i));
                    continue;
                }
                catch (DBException e) {
                    Logger.log(7, AuthenticationService.class.getName(), "SaveMobileAppAndUserSettings", "Error while saving Mobile Application User Settings." + e.getMessage());
                }
            }
        }
    }

    private static void updateUserSettings(Hashtable<String, String> frameworkSettingsProperties, Hashtable<String, String> serverFields) throws DBException, ApplicationException {
        String unviredUserId = frameworkSettingsProperties.get("UNVIREDID");
        String url = frameworkSettingsProperties.get("URL");
        String companyAlias = LoginParameters.getCompany();
        String deviceType = frameworkSettingsProperties.get("FID_TYPE");
        String customDeviceId = frameworkSettingsProperties.get("FEUSERID");
        String firstName = frameworkSettingsProperties.containsKey("FIRST_NAME") ? frameworkSettingsProperties.get("FIRST_NAME") : "";
        String lastName = frameworkSettingsProperties.containsKey("LAST_NAME") ? frameworkSettingsProperties.get("LAST_NAME") : "";
        String email = frameworkSettingsProperties.containsKey("EMAIL") ? frameworkSettingsProperties.get("EMAIL") : "";
        UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
        userSettingsManager.setServerUrl(url);
        userSettingsManager.setUnviredUserId(unviredUserId);
        userSettingsManager.setCompanyAlias(companyAlias);
        userSettingsManager.setDeviceType(deviceType);
        userSettingsManager.setCustomDeviceId(customDeviceId);
        userSettingsManager.setFirstName(firstName);
        userSettingsManager.setLastName(lastName);
        userSettingsManager.setEmail(email);
        LoginParameters.LOGIN_TYPE loginType = LoginParameters.getCurrentLoginType();
        userSettingsManager.setLoginType(loginType);
        String unviredPassword = null;
        switch (loginType) {
            case UNVIRED_ID: 
            case EMAIL: {
                unviredPassword = LoginParameters.getUnviredPassword();
                String md5Password = LoginParameters.getMD5Password();
                if (!Strings.isNullOrEmpty((String)unviredPassword)) break;
                if (Strings.isNullOrEmpty((String)md5Password)) {
                    try {
                        String aesSecurityKey = frameworkSettingsProperties.get("SEC_KEY");
                        aesSecurityKey = aesSecurityKey.substring(aesSecurityKey.lastIndexOf(58) + 1, aesSecurityKey.length());
                        String password = serverFields.get("X-UNVIRED-NEW-PASSWORD");
                        md5Password = Security.decryptAES(aesSecurityKey.getBytes(), password.getBytes());
                    }
                    catch (ApplicationException e) {
                        e.printStackTrace();
                    }
                }
                userSettingsManager.setMD5Password(md5Password);
                TokenHelper.setData(null);
                break;
            }
            case SAP: 
            case ADS: {
                String unviredPasswordBase64String = serverFields.get("X-UNVIRED-NEW-PASSWORD");
                String aesSecurityKey = frameworkSettingsProperties.get("SEC_KEY");
                aesSecurityKey = aesSecurityKey.substring(aesSecurityKey.lastIndexOf(":") + 1, aesSecurityKey.length());
                unviredPassword = Security.decryptAES(aesSecurityKey.getBytes(), unviredPasswordBase64String.getBytes());
                String adsUserId = LoginParameters.getADSUserId();
                String adsPassword = LoginParameters.getADSPassword();
                String adsDomain = LoginParameters.getADSDomain();
                if (adsPassword != null) {
                    adsPassword = new String(Security.encryptAES(aesSecurityKey.getBytes(), adsPassword.getBytes()));
                }
                userSettingsManager.setADSUserId(adsUserId);
                userSettingsManager.setADSPassword(adsPassword);
                userSettingsManager.setADSDomain(adsDomain);
            }
        }
        userSettingsManager.setUnviredPassword(unviredPassword);
    }

    private static IAuthenticationResponse getAllFrontEndIdsSentFromServer(byte[] responseBytes) {
        ServerAuthenticationUIDParser serverAuthenticationUIDParser;
        if (responseBytes == null) {
            String errorMessage = "Incorrect response from the server. Cannot authenticate. Please try again. Technical message - incoming response steam is null or empty.";
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            return authenticationResponse;
        }
        Logger.log(7, AuthenticationService.class.getName(), "handleServerResponseAndGetUids", "Response from server not null. Processing started.");
        try {
            serverAuthenticationUIDParser = new ServerAuthenticationUIDParser(new String(responseBytes));
        }
        catch (ApplicationException e) {
            String errorMessage = "Incorrect response from the server. Cannot authenticate. Please try again. Technical message - incoming response steam is null or empty.";
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            return authenticationResponse;
        }
        InfoMessage infoMessage = serverAuthenticationUIDParser.getInfoMessage();
        if (infoMessage != null) {
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, infoMessage.getMessage());
            return authenticationResponse;
        }
        Vector<String> frontendIds = serverAuthenticationUIDParser.getFrontendIds();
        if (frontendIds == null || frontendIds.size() == 0) {
            String errorMessage = "Authentication failed without a valid error message from the server. Please try again or contact your system administrator";
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            return authenticationResponse;
        }
        MultipleFrontendUsersResponse authenticationResponse = new MultipleFrontendUsersResponse(IAuthenticationResponse.RESPONSE_STATUS.SUCCESS, frontendIds);
        return authenticationResponse;
    }

    private static void invokeLoginActivity(Context context, boolean isAppActivated) {
        if (LoginParameters.getLoginScreenType().equals((Object)LoginParameters.LOGIN_SCREEN_TYPE.CUSTOM)) {
            LoginListener loginListener = LoginParameters.getLoginListener();
            if (loginListener != null) {
                loginListener.invokeAppLoginActivity(isAppActivated);
            }
            return;
        }
        if (LoginParameters.getLoginMode() == LoginParameters.LOGIN_MODE.UNVIRED_ID_LOCAL_AUTH) {
            Intent intent = new Intent(context, LoginLocalActivity.class);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        } else {
            Intent intent = new Intent(context, LoginActivity.class);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    private static void invokeDemoModeSelectionActivity(Context context) {
        Intent intent = new Intent(context, DemoModeSelectionActivity.class);
        intent.addFlags(0x40000000);
        intent.setFlags(0x4000000);
        intent.setFlags(0x10008000);
        context.startActivity(intent);
    }

    private static void navigateToVersionUpgradeActivity(Context context) {
        LoginParameters.setContext(context);
        Intent intent = new Intent(context, VersionUpgradeActivity.class);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    private static Document getSenderDocumentRoot(int messageType, String serverId, String companyAlias, String applicationName, String applicationId) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.log(8, FrameworkHelper.class.getName(), "getSenderDocumentRoot", "Exception while creating a dom document: " + e.getMessage());
        }
        Document domDocument = db.newDocument();
        Element root = domDocument.createElement("Root");
        root.setAttribute("type", String.valueOf(messageType));
        domDocument.appendChild(root);
        Element companyAliasElement = domDocument.createElement("CompanyAlias");
        companyAliasElement.appendChild(domDocument.createTextNode(companyAlias));
        root.appendChild(companyAliasElement);
        Element serverIdElement = domDocument.createElement("ServerId");
        serverIdElement.appendChild(domDocument.createTextNode(serverId));
        root.appendChild(serverIdElement);
        Element applicationNameElement = domDocument.createElement("ApplicationName");
        applicationNameElement.appendChild(domDocument.createTextNode(applicationName));
        root.appendChild(applicationNameElement);
        Element applicationIdElement = domDocument.createElement("ApplicationId");
        applicationIdElement.appendChild(domDocument.createTextNode(applicationId));
        root.appendChild(applicationIdElement);
        return domDocument;
    }

    private static void updateLoginCredentials(HTTPResponse httpResponse) throws DBException, ApplicationException {
        UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
        LoginParameters.LOGIN_TYPE loginType = userSettingsManager.getLoginType();
        switch (loginType) {
            case UNVIRED_ID: 
            case EMAIL: {
                String unviredPassword = LoginParameters.getUnviredPassword();
                userSettingsManager.setUnviredPassword(unviredPassword);
                if (unviredPassword != null && !unviredPassword.isEmpty()) break;
                try {
                    FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
                    String aesSecurityKey = frameworkSettingsManager.getSecKey();
                    aesSecurityKey = aesSecurityKey.substring(aesSecurityKey.lastIndexOf(58) + 1, aesSecurityKey.length());
                    String password = httpResponse.getServerFields().get("X-UNVIRED-NEW-PASSWORD");
                    password = Security.decryptAES(aesSecurityKey.getBytes(), password.getBytes());
                    userSettingsManager.setMD5Password(password);
                    TokenHelper.setData(null);
                }
                catch (ApplicationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case SAP: 
            case ADS: {
                String adsPassword = LoginParameters.getADSPassword();
                Hashtable<String, String> serverFields = httpResponse.getServerFields();
                String newUnviredPasswordFromServerEncrypted = serverFields.get("X-UNVIRED-NEW-PASSWORD");
                FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
                String aesSecurityKey = frameworkSettingsManager.getSecKey();
                aesSecurityKey = aesSecurityKey.substring(aesSecurityKey.lastIndexOf(":") + 1, aesSecurityKey.length());
                String newUnviredPasswordFromServer = Security.decryptAES(aesSecurityKey.getBytes(), newUnviredPasswordFromServerEncrypted.getBytes());
                if (newUnviredPasswordFromServer == null || newUnviredPasswordFromServer.length() == 0) {
                    throw new ApplicationException(AuthenticationService.class.getName(), "updateLoginCredentials", "New Unvired password from server invalid");
                }
                if (adsPassword != null && !adsPassword.isEmpty()) {
                    adsPassword = new String(Security.encryptAES(aesSecurityKey.getBytes(), adsPassword.getBytes()));
                }
                userSettingsManager.setADSPassword(adsPassword);
                userSettingsManager.setUnviredPassword(newUnviredPasswordFromServer);
                break;
            }
        }
    }

    private static AuthenticationResponse handleAuthenticationResponse(HTTPResponse httpResponse) {
        ServerAuthenticationResponseParser serverAuthenticationResponseParser;
        int messageSubType;
        int messageType;
        Hashtable<String, String> serverFields = httpResponse.getServerFields();
        String serverId = serverFields.get("X-UNVIRED-SERVER-ID");
        String messageTypeString = serverFields.get("X-UNVIRED-MESSAGE-TYPE");
        String messageSubTypeString = serverFields.get("X-UNVIRED-MESSAGE-SUB-TYPE");
        if (messageTypeString == null || messageTypeString.equalsIgnoreCase("") || messageSubTypeString == null || messageSubTypeString.equalsIgnoreCase("")) {
            String errorMessage = "Incorrect response from the server. Cannot authenticate. Please try again. Technical message - Message Type: " + messageTypeString + "Message Sub Type: " + messageSubTypeString;
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
        }
        try {
            messageType = Integer.parseInt(messageTypeString);
            messageSubType = Integer.parseInt(messageSubTypeString);
        }
        catch (NumberFormatException e) {
            String errorMessage = "Incorrect response from the server. Cannot authenticate. Please try again. Technical message - Message Type: " + messageTypeString + "Message Sub Type: " + messageSubTypeString;
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
        }
        byte[] responseBytes = httpResponse.getResponseBytes();
        if (responseBytes == null) {
            String errorMessage = "Incorrect response from the server. Cannot authenticate. Please try again. Technical message - incoming response stream is null or empty.";
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
        }
        Logger.log(7, AuthenticationService.class.getName(), "handleAuthenticationResponse", "Response from server not null. Processing started.");
        try {
            serverAuthenticationResponseParser = new ServerAuthenticationResponseParser(responseBytes, serverId, messageType, messageSubType);
        }
        catch (ApplicationException e) {
            String errorMessage = "Incorrect response from the server. Cannot authenticate. Please try again. Technical message: Cannot parse incoming response from server.";
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
        }
        if (messageType == 4000 && messageSubType == 100) {
            InfoMessage infoMessage = serverAuthenticationResponseParser.getInfoMessage();
            if (infoMessage == null) {
                String errorMessage = "Authentication failed without a valid error message from the server. Please try again or contact your system administrator";
                return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
            }
            String category = infoMessage.getCategory();
            String message = infoMessage.getMessage();
            if ("SUCCESS".equalsIgnoreCase(category)) {
                if (message == null || message.equalsIgnoreCase("")) {
                    MessageHelper messageHelper = MessageHelper.getInstance();
                    message = messageHelper.getValue(messageHelper.AUTHENTICATION_SUCCESSFUL);
                }
                return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.SUCCESS, message);
            }
            return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, message);
        }
        String errorMessage = "Cannot authenticate. Contact your administrator. Check the logs for more information.";
        return new AuthenticationResponse(IAuthenticationResponse.RESPONSE_STATUS.FAILURE, errorMessage);
    }

    public static void loginWithDemoData(Context context, String demoData) throws Exception {
        if (Strings.isNullOrEmpty((String)demoData)) {
            throw new Exception("Demo data cannot be Null");
        }
        FrameworkHelper.setApplicationContext(context);
        DemoHelper.initializeDemoMode(demoData);
    }

    private static boolean ping() {
        HTTPResponse httpResponse = HTTPConnection.ping();
        if (httpResponse.getResponseCode() == 526) {
            try {
                HTTPConnection.trustOurHosts();
            }
            catch (Exception e) {
                Logger.e("Error while checking for trusted certificate." + e.getMessage());
            }
            while (ModifiedX509TrustManager.isCertificateDialogOpen) {
            }
            if (ModifiedX509TrustManager.isCertificateAccepted()) {
                if (AuthenticationService.ping()) {
                    SharedPreferences sharedPrefs = LoginParameters.getContext().getSharedPreferences("SSL_CERTIFICATE", 0);
                    SharedPreferences.Editor editor = sharedPrefs.edit();
                    editor.putString("SSL_CERTIFICATE", LoginParameters.getSSLCert());
                    editor.apply();
                    return true;
                }
            } else {
                return ModifiedX509TrustManager.isAlreadyTrusted;
            }
        }
        return true;
    }
}

