/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.login;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.unvired.logger.Logger;
import com.unvired.utils.FileHelper;
import com.unvired.utils.PathManager;
import java.io.File;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;

public class UnviredAccount {
    private String userName;
    private String company;
    private String serverUrl;
    private String representation;
    private static final String PATH_SEPARATOR = "@@";

    public String getCompany() {
        return this.company;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public UnviredAccount() {
    }

    public UnviredAccount(String userName, String company, String serverUrl) {
        this.userName = userName;
        this.company = company;
        this.serverUrl = serverUrl;
        this.representation = null;
    }

    public String getAccountPath() {
        if (Strings.isNullOrEmpty((String)this.representation)) {
            Joiner joiner = Joiner.on((String)PATH_SEPARATOR).skipNulls();
            byte[] bytesEncoded = Base64.encodeBase64((byte[])this.serverUrl.getBytes());
            this.representation = joiner.join((Object)this.userName, (Object)this.company, new Object[]{new String(bytesEncoded)});
        }
        return this.representation;
    }

    public void getUnviredAccountFromRepresentation(String representation) {
        String[] parts = representation.split(PATH_SEPARATOR);
        this.userName = parts[0];
        this.company = parts[1];
        this.representation = representation;
        byte[] valueDecoded = Base64.decodeBase64((byte[])parts[2].getBytes());
        this.serverUrl = new String(valueDecoded);
    }

    public void deleteAccount() {
        String path = PathManager.getInstance().getAAccountsRootPath() + this.getAccountPath();
        String message = "Application database file for Account :" + this.company + "/" + this.userName;
        File accRootFile = new File(path);
        if (accRootFile.exists()) {
            try {
                FileHelper.deleteFile(accRootFile);
                Logger.log(7, UnviredAccount.class.getName(), "deleteAccount", message + " deletion success");
            }
            catch (IOException e) {
                Logger.e("IOException caught while deleting Account root directory :" + message, e);
            }
        }
        PathManager.getInstance().setLastLoginUnviredAccount(null);
    }

    public boolean equals(Object object) {
        if (object instanceof UnviredAccount) {
            return this.getAccountPath().equals(((UnviredAccount)object).getAccountPath());
        }
        return false;
    }

    public String toString() {
        return this.getAccountPath();
    }
}

