/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.message;

import com.unvired.ui.resources.MessageHelper;

public class MessageType {
    public static final int MESSAGE_TYPE_APPLICATION = 8000;
    public static final int MESSAGE_TYPE_SYSTEM = 9000;
    public static final int MESSAGE_TYPE_WIPE = 5000;
    public static final int MESSAGE_TYPE_AUTHENTICATION = 4000;
    public static final int MESSAGE_SUBTYPE_APPLICATION_DATA_IBXML = 600;
    public static final int MESSAGE_SUBTYPE_APPLICATION_DATA_NATIVE = 700;
    public static final int MESSAGE_SUBTYPE_APPLICATION_DATA_IBXML_EXTERNAL_PUSH_FROM_BACKEND = 800;
    public static final int MESSAGE_SUBTYPE_APPLICATION_DATA_NATIVE_EXTERNAL_PUSH_FROM_BACKEND = 900;
    public static final int MESSAGE_SUBTYPE_SYSTEM_PING = 100;
    public static final int MESSAGE_SUBTYPE_SYSTEM_LOG = 200;
    public static final int MESSAGE_SUBTYPE_SYSTEM_LOG_RESET = 210;
    public static final int MESSAGE_SUBTYPE_SYSTEM_LOG_SET_ERROR = 220;
    public static final int MESSAGE_SUBTYPE_SYSTEM_LOG_SET_DEBUG = 230;
    public static final int MESSAGE_SUBTYPE_SYSTEM_DATA_DUMP = 300;
    public static final int MESSAGE_SUBTYPE_SYSTEM_INITIAL_DATA = 400;
    public static final int MESSAGE_SUBTYPE_SYSTEM_APPLICATION_ASSIGN = 410;
    public static final int MESSAGE_SUBTYPE_SYSTEM_APPLICATION_UNASSIGN = 430;
    public static final int MESSAGE_SUBTYPE_SYSTEM_FRAMEWORK_SETTINGS = 500;
    public static final int MESSAGE_SUBTYPE_SYSTEM_RESET_DATA = 700;
    public static final int MESSAGE_SUBTYPE_SYSTEM_ACTIVATION = 800;
    public static final int MESSAGE_SUBTYPE_SYSTEM_MULTIPLE_FRONTEND_USERS = 810;
    public static final int MESSAGE_SUBTYPE_SYSTEM_ERROR = 900;
    public static final int MESSAGE_SUBTYPE_SYSTEM_INFO = 1000;
    public static final int MESSAGE_SUBTYPE_SYSTEM_INITIATE_PULL = 440;
    public static final int MESSAGE_SUBTYPE_SYSTEM_PULL_COMPLETE = 450;
    public static final int MESSAGE_SUBTYPE_SYSTEM_SEND_PUSH_NOTIFICATION_ID = 610;
    public static final int MESSAGE_SUBTYPE_AUTHENTICATION = 100;
    public static final int MESSAGE_SUBTYPE_AUTHENTICATION_AND_ACTIVATE = 200;
    public static final int MESSAGE_SUBTYPE_SAP_AUTHENTICATE = 300;
    public static final int MESSAGE_SUBTYPE_CHANGE_PASSWORD = 400;
    public static final int MESSAGE_SUBTYPE_FORGOT_PASSWORD = 500;
    public static final int MESSAGE_SUBTYPE_REGISTER_USER = 600;
    public static final int MESSAGE_SUBTYPE_GET_LOGIN_TOKEN = 700;
    public static final int MESSAGE_SUBTYPE_APPLICATION_USER_SETTNGS_UPDATE = 625;
    public static final int MESSAGE_SUBTYPE_LOCATION_INFORMATION = 1100;
    public static final int MESSAGE_SUBTYPE_CHECK_FOR_APP_UPGRADE = 1300;
    public static final int MESSAGE_SUBTYPE_TEST_PUSH = 110;
    private static final MessageHelper MESSAGE_HELPER = MessageHelper.getInstance();

    public static String getMessageTypeText(int messageType) {
        String messageTypeText = "";
        switch (messageType) {
            case 8000: {
                messageTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_TYPE_APPLICATION);
                break;
            }
            case 9000: {
                messageTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_TYPE_SYSTEM);
                break;
            }
            case 4000: {
                messageTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_TYPE_AUTHENTICATION);
                break;
            }
            case 5000: {
                messageTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_TYPE_WIPE);
                break;
            }
        }
        return messageTypeText;
    }

    public static String getMessageSubTypeText(int messageType, int messageSubType) {
        String messageSubTypeText = "";
        switch (messageType) {
            case 8000: {
                messageSubTypeText = MessageType.getApplicationMessageSubTypeText(messageSubType);
                break;
            }
            case 9000: {
                messageSubTypeText = MessageType.getSystemMessageSubTypeText(messageSubType);
                break;
            }
            case 4000: {
                messageSubTypeText = MessageType.getAuthenticationMessageSubTypeText(messageSubType);
                break;
            }
        }
        return messageSubTypeText;
    }

    private static String getApplicationMessageSubTypeText(int messageSubType) {
        String messageSubTypeText = "";
        switch (messageSubType) {
            case 600: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_APPLICATION_DATA_NATIVE);
                break;
            }
            case 700: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_APPLICATION_DATA_NATIVE);
                break;
            }
            case 800: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_APPLICATION_DATA_IBXML_EXTERNAL_PUSH_FROM_BACKEND);
                break;
            }
            case 900: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_APPLICATION_DATA_NATIVE_EXTERNAL_PUSH_FROM_BACKEND);
                break;
            }
        }
        return messageSubTypeText;
    }

    private static String getSystemMessageSubTypeText(int messageSubType) {
        String messageSubTypeText = "";
        switch (messageSubType) {
            case 100: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_PING);
                break;
            }
            case 200: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_LOG);
                break;
            }
            case 210: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_LOG_RESET);
                break;
            }
            case 220: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_LOG_SET_ERROR);
                break;
            }
            case 230: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_LOG_SET_DEBUG);
                break;
            }
            case 300: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_DATA_DUMP);
                break;
            }
            case 400: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_INITIAL_DATA);
                break;
            }
            case 410: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_APPLICATION_ASSIGN);
                break;
            }
            case 430: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_APPLICATION_UNASSIGN);
                break;
            }
            case 500: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_FRAMEWORK_SETTINGS);
                break;
            }
            case 700: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_RESET_DATA);
                break;
            }
            case 800: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_ACTIVATION);
                break;
            }
            case 810: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_MULTIPLE_FRONTEND_USERS);
                break;
            }
            case 900: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_ERROR);
                break;
            }
            case 1000: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_INFO);
                break;
            }
            case 440: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_INITIATE_PULL);
                break;
            }
            case 610: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SYSTEM_SEND_PUSH_NOTIFICATION_ID);
                break;
            }
        }
        return messageSubTypeText;
    }

    private static String getAuthenticationMessageSubTypeText(int messageSubType) {
        String messageSubTypeText = "";
        switch (messageSubType) {
            case 100: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_AUTHENTICATION);
                break;
            }
            case 200: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_AUTHENTICATION_AND_ACTIVATE);
                break;
            }
            case 300: {
                messageSubTypeText = MESSAGE_HELPER.getValue(MessageType.MESSAGE_HELPER.MESSAGE_SUBTYPE_SAP_AUTHENTICATE);
                break;
            }
        }
        return messageSubTypeText;
    }
}

