/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.message;

import com.unvired.core.ApplicationManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.FrameworkAttachment;
import com.unvired.model.StructureMeta;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.sync.response.AttachmentResponse;
import com.unvired.utils.FileHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.PathManager;
import com.unvired.utils.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UNVDataHelper {
    public static Element getDirectChild(Element parent, String name) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    public static void exportApplicationData() throws DBException {
        try {
            new Thread(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        String appName = ApplicationManager.getInstance().getApplicationName();
                        FrameworkAttachment attachmentItem = new FrameworkAttachment();
                        String path = UNVDataHelper.getApplicationDBPath();
                        attachmentItem.setLocalPath(path);
                        attachmentItem.setFileName(appName + "_DB");
                        attachmentItem.setMimeType("application/zip");
                        AttachmentResponse attachmentResponse = HTTPConnection.uploadAttachment(attachmentItem, false, false, "UPLOAD_DATA");
                        try {
                            FileHelper.deleteFile(new File(path));
                        }
                        catch (IOException e) {
                            Logger.e("IOException caught while deleting temp database copy file.", e);
                        }
                        if (!"SUCCESS".equalsIgnoreCase(attachmentResponse.getStatus())) return;
                    }
                    catch (DBException e) {
                        Logger.e("DBException caught while exporting database file.", e);
                        return;
                    }
                    catch (ApplicationException e) {
                        Logger.e("ApplicationException caught while exporting database file", e);
                    }
                }
            }.start();
        }
        catch (Exception e) {
            Logger.e("Exception caught while exporting database file", e);
        }
    }

    private static String getApplicationDBPath() {
        if (!FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").exists()) {
            FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").mkdirs();
        }
        String path = FileHelper.getUnencryptedDatabaseFile(PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.APP_DB_FILE));
        String _zipFile = "";
        try {
            if (path != null) {
                if (new File(_zipFile).exists()) {
                    new File(_zipFile).delete();
                }
                _zipFile = FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").getAbsolutePath() + "/" + ApplicationManager.getInstance().getApplicationName() + "_DB.zip";
                FileHelper.zip(new String[]{path}, _zipFile);
                try {
                    new File(path).delete();
                }
                catch (Exception e) {
                    Logger.e("Error while deleting temp file created for Data Export.", e);
                }
            }
        }
        catch (Exception e) {
            Logger.e("Error while Zipping Database file for Data Export.", e);
        }
        return _zipFile;
    }

    public static String generateMessageIBXML(IDataStructure dataStructure, DATA_TYPE dataType) {
        String xmlString;
        if (dataStructure == null) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "DataStructure found as null.");
            }
            return "";
        }
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        Document document = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.log(8, UNVDataHelper.class.getName(), "generateMessageIBXML", "Exception while building document, " + e.getMessage());
        }
        document = db.newDocument();
        String applicationName = applicationManager.getApplicationName();
        String tableName = dataStructure.getTableName();
        IDataManager applicationDataManager = null;
        try {
            applicationDataManager = applicationManager.getDataManager();
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while initializing DataManager.", dbException);
            return "";
        }
        if (applicationDataManager == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "Applicaiton data manager found as null.");
            return "";
        }
        if (applicationName == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "Application name from database found as null.");
            return "";
        }
        if (applicationName.length() <= 0) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "Application name from database found as empty.");
            return "";
        }
        if (tableName == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "Table name from data structure found as null.");
            return "";
        }
        if (tableName.length() <= 0) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "Table name from data structure found as empty.");
            return "";
        }
        StructureMeta structureMeta = null;
        try {
            structureMeta = applicationManager.getStructureMeta(tableName);
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while retrieving StructureMeta for " + tableName, dbException);
            return "";
        }
        Element root = document.createElement("Application");
        root.setAttribute("name", applicationName);
        document.appendChild(root);
        Element be = document.createElement("BE");
        be.setAttribute("n", structureMeta.getBeName());
        root.appendChild(be);
        Element header = (Element)UNVDataHelper.getFragmentIbXml(document, dataStructure, true);
        be.appendChild(header);
        String[] childrenTableNames = null;
        try {
            childrenTableNames = dataStructure.getChildrenTableNames();
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while retrieving children name of " + dataStructure.getTableName(), dbException);
            return "";
        }
        if (childrenTableNames != null) {
            int noOfChildrenTableNames = childrenTableNames.length;
            for (int i = 0; i < noOfChildrenTableNames; ++i) {
                IDataStructure[] childrenDataStructures = null;
                String whereClause = null;
                switch (dataType) {
                    case CHANGED: {
                        whereClause = "OBJECT_STATUS IN ('" + IDataStructure.OBJECT_STATUS.ADD.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.MODIFY.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.DELETE.ordinal() + "'" + ")" + " AND " + "SYNC_STATUS" + " IN (" + "'" + IDataStructure.SYNC_STATUS.NONE.ordinal() + "'" + "," + "'" + IDataStructure.SYNC_STATUS.ERROR.ordinal() + "'" + ")";
                        break;
                    }
                    case CHANGED_QUEUED: {
                        whereClause = "OBJECT_STATUS IN ('" + IDataStructure.OBJECT_STATUS.ADD.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.MODIFY.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.DELETE.ordinal() + "'" + ")" + " AND " + "SYNC_STATUS" + " IN (" + "'" + IDataStructure.SYNC_STATUS.NONE.ordinal() + "'" + "," + "'" + IDataStructure.SYNC_STATUS.ERROR.ordinal() + "'" + "," + "'" + IDataStructure.SYNC_STATUS.QUEUED.ordinal() + "'" + ")";
                        break;
                    }
                    case QUEUED: {
                        whereClause = "OBJECT_STATUS IN ('" + IDataStructure.OBJECT_STATUS.ADD.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.MODIFY.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.DELETE.ordinal() + "'" + ")" + " AND " + "SYNC_STATUS" + " IN (" + "'" + IDataStructure.SYNC_STATUS.QUEUED.ordinal() + "'" + ")";
                        break;
                    }
                    case ALL: {
                        whereClause = "";
                        break;
                    }
                }
                try {
                    childrenDataStructures = applicationDataManager.getChildren(childrenTableNames[i], whereClause, null, dataStructure);
                }
                catch (DBException dbException) {
                    Logger.e("DBException caught while retrieving children DataStructure of " + dataStructure.getTableName(), dbException);
                    return "";
                }
                if (childrenDataStructures == null) continue;
                int noOfChildrens = childrenDataStructures.length;
                for (int j = 0; j < noOfChildrens; ++j) {
                    Node itemNode = UNVDataHelper.getFragmentIbXml(document, childrenDataStructures[j], false);
                    be.appendChild(itemNode);
                }
            }
        }
        try {
            xmlString = FrameworkHelper.getString(document);
        }
        catch (ApplicationException applicationException) {
            Logger.e("ApplicationException caught while getting string from document", applicationException);
            return "";
        }
        return xmlString;
    }

    public static String generateMessageIBXML(IDataStructure header, IDataStructure[] items) {
        if (header == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "Header found as null.");
            return "";
        }
        if (items == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "Items found as null.");
            return "";
        }
        Document document = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.log(8, UNVDataHelper.class.getName(), "generateMessageIBXML", "Exception while building document, " + e.getMessage());
        }
        document = db.newDocument();
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        String applicationName = applicationManager.getApplicationName();
        String tableName = header.getTableName();
        IDataManager applicationDataManager = null;
        try {
            applicationDataManager = applicationManager.getDataManager();
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while initializing DataManager.", dbException);
            return "";
        }
        if (applicationDataManager == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "Application data manager found as null.");
            return "";
        }
        if (applicationName == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "Application name from database found as null.");
            return "";
        }
        if (applicationName.length() <= 0) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "Application name from database found as empty.");
            return "";
        }
        if (tableName == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "Table name from data structure found as null.");
            return "";
        }
        if (tableName.length() <= 0) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBXML", "Table name from data structure found as empty.");
            return "";
        }
        StructureMeta structureMeta = null;
        try {
            structureMeta = applicationManager.getStructureMeta(tableName);
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while retrieving StructureMeta for " + tableName, dbException);
            return "";
        }
        Element root = document.createElement("Application");
        root.setAttribute("name", applicationName);
        document.appendChild(root);
        Element be = document.createElement("BE");
        be.setAttribute("n", structureMeta.getBeName());
        root.appendChild(be);
        Element headerElement = (Element)UNVDataHelper.getFragmentIbXml(document, header, true);
        be.appendChild(headerElement);
        for (int i = 0; i < items.length; ++i) {
            Node itemNode = UNVDataHelper.getFragmentIbXml(document, items[i], false);
            be.appendChild(itemNode);
        }
        String xmlString = null;
        try {
            xmlString = FrameworkHelper.getString(document);
        }
        catch (ApplicationException applicationException) {
            Logger.e("ApplicationException caught while getting string from document", applicationException);
        }
        return xmlString;
    }

    private static Node getFragmentIbXml(Document document, IDataStructure dataStructure, boolean isHeader) {
        String tagName = isHeader ? "H" : "I";
        Element structureNode = document.createElement(tagName);
        structureNode.setAttribute("n", dataStructure.getTableName());
        Enumeration<String> fieldNamesEnumeration = dataStructure.getFieldNames();
        while (fieldNamesEnumeration.hasMoreElements()) {
            String fieldName = fieldNamesEnumeration.nextElement();
            Object fieldValue = dataStructure.getField(fieldName);
            if ("LID".equals(fieldName) || "FID".equals(fieldName) || "TIME_STAMP".equals(fieldName) || "OBJECT_STATUS".equals(fieldName) || "SYNC_STATUS".equals(fieldName) || "HAS_CONFLICT".equals(fieldName)) continue;
            Element fieldNode = document.createElement("F");
            fieldNode.setAttribute("n", fieldName);
            String fieldValueString = "";
            if (fieldValue != null) {
                String string = fieldValueString = fieldValue instanceof byte[] ? new String((byte[])fieldValue) : fieldValue.toString();
            }
            if (fieldValue != null) {
                fieldValueString = fieldValue instanceof Double ? BigDecimal.valueOf((Double)fieldValue).toPlainString() : fieldValue.toString();
            }
            fieldNode.appendChild(document.createTextNode(fieldValueString));
            structureNode.appendChild(fieldNode);
        }
        return structureNode;
    }

    public static String generateMessageIBJSON(IDataStructure headerDataStructure, DATA_TYPE dataType) {
        if (headerDataStructure == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBJSON", "DataStructure found as null.");
            return "";
        }
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        String applicationName = applicationManager.getApplicationName();
        String tableName = headerDataStructure.getTableName();
        IDataManager applicationDataManager = null;
        try {
            applicationDataManager = applicationManager.getDataManager();
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while initializing DataManager.", dbException);
            return "";
        }
        if (applicationDataManager == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBJSON", "Application data manager found as null.");
            return "";
        }
        if (applicationName == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBJSON", "Application name from database found as null.");
            return "";
        }
        if (applicationName.length() <= 0) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBJSON", "Application name from database found as empty.");
            return "";
        }
        if (tableName == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBJSON", "Table name from data structure found as null.");
            return "";
        }
        if (tableName.length() <= 0) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBJSON", "Table name from data structure found as empty.");
            return "";
        }
        JSONObject eachBusinessEntity = new JSONObject();
        JSONObject headerFieldObject = new JSONObject();
        Enumeration<String> en = headerDataStructure.getFieldNames();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            Object value = headerDataStructure.getField(key);
            String fieldValueString = "";
            if (value != null) {
                String string = fieldValueString = value instanceof byte[] ? new String((byte[])value) : value.toString();
            }
            if (value != null) {
                fieldValueString = value instanceof Double ? BigDecimal.valueOf((Double)value).toPlainString() : value.toString();
            }
            try {
                if (fieldValueString != "null") {
                    headerFieldObject.put(key, (Object)fieldValueString);
                    continue;
                }
                headerFieldObject.put(key, (Object)"");
            }
            catch (JSONException e) {
                Logger.e("JSONException caught while setting filed name/value of DataStructure: " + headerDataStructure.getTableName() + " Field:" + key + " Value:" + fieldValueString, (Exception)((Object)e));
            }
        }
        try {
            eachBusinessEntity.put(tableName, (Object)headerFieldObject);
        }
        catch (Exception e) {
            Logger.e("Error in putting JSON filesObject in JSON fieldsArray for Structure : " + tableName, e);
        }
        String[] childrenTableNames = null;
        try {
            childrenTableNames = headerDataStructure.getChildrenTableNames();
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while retrieving children tables name of Structure :" + tableName, dbException);
            return "";
        }
        if (childrenTableNames != null) {
            int noOfChildrenTableNames = childrenTableNames.length;
            for (int i = 0; i < noOfChildrenTableNames; ++i) {
                IDataStructure[] childrenDataStructures = null;
                String whereClause = null;
                switch (dataType) {
                    case CHANGED: {
                        whereClause = "OBJECT_STATUS IN ('" + IDataStructure.OBJECT_STATUS.ADD.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.MODIFY.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.DELETE.ordinal() + "'" + ")" + " AND " + "SYNC_STATUS" + " IN (" + "'" + IDataStructure.SYNC_STATUS.NONE.ordinal() + "'" + "," + "'" + IDataStructure.SYNC_STATUS.ERROR.ordinal() + "'" + ")";
                        break;
                    }
                    case CHANGED_QUEUED: {
                        whereClause = "OBJECT_STATUS IN ('" + IDataStructure.OBJECT_STATUS.ADD.ordinal() + "'" + "," + "'" + (Object)((Object)IDataStructure.OBJECT_STATUS.MODIFY) + "'" + "," + "'" + (Object)((Object)IDataStructure.OBJECT_STATUS.DELETE) + "'" + ")" + " AND " + "SYNC_STATUS" + " IN (" + "'" + IDataStructure.SYNC_STATUS.NONE.ordinal() + "'" + "," + "'" + IDataStructure.SYNC_STATUS.ERROR.ordinal() + "'" + "," + "'" + IDataStructure.SYNC_STATUS.QUEUED.ordinal() + "'" + ")";
                        break;
                    }
                    case QUEUED: {
                        whereClause = "OBJECT_STATUS IN ('" + IDataStructure.OBJECT_STATUS.ADD.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.MODIFY.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.DELETE.ordinal() + "'" + ")" + " AND " + "SYNC_STATUS" + " IN (" + "'" + IDataStructure.SYNC_STATUS.QUEUED.ordinal() + "'" + ")";
                        break;
                    }
                    case ALL: {
                        whereClause = "";
                        break;
                    }
                }
                try {
                    childrenDataStructures = applicationDataManager.getChildren(childrenTableNames[i], whereClause, null, headerDataStructure);
                }
                catch (DBException dbException) {
                    Logger.e("DBException caught while retrieving children DataStructures of Structure :" + tableName, dbException);
                    return "";
                }
                if (childrenDataStructures == null) continue;
                int noOfChildrens = childrenDataStructures.length;
                try {
                    if (noOfChildrens <= 0) continue;
                    eachBusinessEntity = UNVDataHelper.getFragmentIbJSON(childrenDataStructures, noOfChildrens, eachBusinessEntity);
                    continue;
                }
                catch (Exception ex) {
                    Logger.log(8, UNVDataHelper.class.getName(), "generateMessageIBJSON", ex.getMessage());
                }
            }
        }
        String requestJSON = "";
        JSONArray businessEntityArray = new JSONArray();
        businessEntityArray.put((Object)eachBusinessEntity);
        JSONObject businessEntityObject = new JSONObject();
        try {
            StructureMeta structureMeta = applicationManager.getStructureMeta(tableName);
            businessEntityObject.put(structureMeta.getBeName(), (Object)businessEntityArray);
        }
        catch (Exception e) {
            Logger.e("Exception caught while putting BusinessEntity in hash table:" + tableName, e);
        }
        requestJSON = businessEntityObject.toString();
        return requestJSON;
    }

    public static JSONObject generateMessageIBJSON(IDataStructure headerDataStructure, IDataStructure[] childrenDataStructures) {
        if (headerDataStructure == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBJSON", "DataStructure found as null.");
            return new JSONObject();
        }
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        String tableName = headerDataStructure.getTableName();
        if (tableName == null) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBJSON", "Table name from data structure found as null.");
            return new JSONObject();
        }
        if (tableName.length() <= 0) {
            Logger.log(9, UNVDataHelper.class.getName(), "generateMessageIBJSON", "Table name from data structure found as empty.");
            return new JSONObject();
        }
        JSONObject eachBusinessEntity = new JSONObject();
        try {
            StructureMeta structureMeta = applicationManager.getStructureMeta(tableName);
            eachBusinessEntity.put("n", (Object)structureMeta.getBeName());
        }
        catch (DBException dbException) {
            Logger.log(8, UNVDataHelper.class.getName(), "generateMessageIBJSON", dbException.getMessage());
            return new JSONObject();
        }
        catch (JSONException e) {
            Logger.log(8, UNVDataHelper.class.getName(), "generateMessageIBJSON", e.getMessage());
            return new JSONObject();
        }
        JSONObject headerFieldObject = new JSONObject();
        Enumeration<String> en = headerDataStructure.getFieldNames();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            Object value = headerDataStructure.getField(key);
            String fieldValueString = "";
            if (value != null) {
                String string = fieldValueString = value instanceof byte[] ? new String((byte[])value) : value.toString();
            }
            if (value != null) {
                fieldValueString = value instanceof Double ? BigDecimal.valueOf((Double)value).toPlainString() : value.toString();
            }
            try {
                if (fieldValueString != "null") {
                    headerFieldObject.put(key, (Object)fieldValueString);
                    continue;
                }
                headerFieldObject.put(key, (Object)"");
            }
            catch (JSONException e) {
                Logger.e("JSONException caught while setting filed name/value of DataStructure: " + headerDataStructure.getTableName() + " Field:" + key + " Value:" + fieldValueString, (Exception)((Object)e));
            }
        }
        try {
            eachBusinessEntity.put(tableName, (Object)headerFieldObject);
        }
        catch (JSONException e) {
            Logger.log(8, UNVDataHelper.class.getName(), "GetJSONFromDataStructure", "Error in putting JSON filesObject in JSON fieldsArray: " + e.getMessage());
        }
        int noOfChildren = childrenDataStructures.length;
        try {
            if (noOfChildren > 0) {
                eachBusinessEntity = UNVDataHelper.getFragmentIbJSON(childrenDataStructures, noOfChildren, eachBusinessEntity);
            } else {
                eachBusinessEntity.put("I", (Object)new JSONArray());
            }
        }
        catch (JSONException e) {
            Logger.log(8, UNVDataHelper.class.getName(), "generateMessageIBJSON", e.getMessage());
            return new JSONObject();
        }
        JSONArray businessEntityArray = new JSONArray();
        businessEntityArray.put((Object)eachBusinessEntity);
        JSONObject businessEntityObject = new JSONObject();
        try {
            StructureMeta structureMeta = applicationManager.getStructureMeta(tableName);
            businessEntityObject.put(structureMeta.getBeName(), (Object)businessEntityArray);
        }
        catch (Exception e) {
            Logger.log(8, UNVDataHelper.class.getName(), "generateMessageIBJSON", e.getMessage());
        }
        return businessEntityObject;
    }

    private static JSONObject getFragmentIbJSON(IDataStructure[] itemDataStructures, int count, JSONObject businessEntity) {
        JSONArray itemJSONArray = new JSONArray();
        for (int i = 0; i < count; ++i) {
            JSONObject jsonFieldObject = new JSONObject();
            IDataStructure itemDataStructure = itemDataStructures[i];
            Enumeration<String> en = itemDataStructures[i].getFieldNames();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                Object fieldValue = itemDataStructures[i].getField(key);
                String fieldValueString = "";
                if (fieldValue != null) {
                    String string = fieldValueString = fieldValue instanceof byte[] ? new String((byte[])fieldValue) : fieldValue.toString();
                }
                if (fieldValue != null) {
                    fieldValueString = fieldValue instanceof Double ? BigDecimal.valueOf((Double)fieldValue).toPlainString() : fieldValue.toString();
                }
                try {
                    jsonFieldObject.put(key, (Object)fieldValueString);
                }
                catch (JSONException e) {
                    Logger.log(8, UNVDataHelper.class.getName(), "GetJSONFromDataStructure", "Error in JSONObject value setting: " + e.getMessage());
                }
            }
            try {
                itemJSONArray.put((Object)jsonFieldObject);
                businessEntity.put(itemDataStructure.getTableName(), (Object)itemJSONArray);
                continue;
            }
            catch (JSONException e) {
                Logger.log(8, UNVDataHelper.class.getName(), "GetJSONFromDataStructure", "Error in putting JSON filesObject in JSON fielsArray: " + e.getMessage());
            }
        }
        return businessEntity;
    }

    public static String generateMessageIBXML(IDataStructure[] header, DATA_TYPE dataType) {
        if (header == null || header.length <= 0) {
            Logger.e("Headers not found.");
            return "";
        }
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        Document document = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.e("Exception while building document, " + e.getMessage());
        }
        document = db.newDocument();
        String applicationName = applicationManager.getApplicationName();
        String tableName = header.length > 0 ? header[0].getTableName() : "";
        IDataManager applicationDataManager = null;
        try {
            applicationDataManager = applicationManager.getDataManager();
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while initializing DataManager.", dbException);
            return "";
        }
        if (applicationDataManager == null) {
            Logger.e("Application data manager found as null.");
            return "";
        }
        if (applicationName == null) {
            Logger.e("Application name from database found as null.");
            return "";
        }
        if (applicationName.length() <= 0) {
            Logger.e("Application name from database found as empty.");
            return "";
        }
        if (tableName == null) {
            Logger.e("Table name from data structure found as null.");
            return "";
        }
        if (tableName.length() <= 0) {
            Logger.e("Table name from data structure found as empty.");
            return "";
        }
        StructureMeta structureMeta = null;
        try {
            structureMeta = applicationManager.getStructureMeta(tableName);
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while retrieving StructureMeta for " + tableName, dbException);
            return "";
        }
        Element root = document.createElement("Application");
        root.setAttribute("name", applicationName);
        document.appendChild(root);
        for (int j = 0; j < header.length; ++j) {
            IDataStructure headerData = header[j];
            Element be = document.createElement("BE");
            be.setAttribute("n", structureMeta.getBeName());
            root.appendChild(be);
            Element headerElement = (Element)UNVDataHelper.getFragmentIbXml(document, headerData, true);
            be.appendChild(headerElement);
            String[] childrenTableNames = null;
            try {
                childrenTableNames = headerData.getChildrenTableNames();
            }
            catch (DBException dbException) {
                Logger.e("DBException caught while retrieving children name of " + headerData.getTableName(), dbException);
                return "";
            }
            if (childrenTableNames == null) continue;
            int noOfChildrenTableNames = childrenTableNames.length;
            for (int i = 0; i < noOfChildrenTableNames; ++i) {
                IDataStructure[] childrenDataStructures = null;
                String whereClause = null;
                switch (dataType) {
                    case CHANGED: {
                        whereClause = "OBJECT_STATUS IN ('" + IDataStructure.OBJECT_STATUS.ADD.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.MODIFY.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.DELETE.ordinal() + "'" + ")" + " AND " + "SYNC_STATUS" + " IN (" + "'" + IDataStructure.SYNC_STATUS.NONE.ordinal() + "'" + "," + "'" + IDataStructure.SYNC_STATUS.ERROR.ordinal() + "'" + ")";
                        break;
                    }
                    case CHANGED_QUEUED: {
                        whereClause = "OBJECT_STATUS IN ('" + IDataStructure.OBJECT_STATUS.ADD.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.MODIFY.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.DELETE.ordinal() + "'" + ")" + " AND " + "SYNC_STATUS" + " IN (" + "'" + IDataStructure.SYNC_STATUS.NONE.ordinal() + "'" + "," + "'" + IDataStructure.SYNC_STATUS.ERROR.ordinal() + "'" + "," + "'" + IDataStructure.SYNC_STATUS.QUEUED.ordinal() + "'" + ")";
                        break;
                    }
                    case QUEUED: {
                        whereClause = "OBJECT_STATUS IN ('" + IDataStructure.OBJECT_STATUS.ADD.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.MODIFY.ordinal() + "'" + "," + "'" + IDataStructure.OBJECT_STATUS.DELETE.ordinal() + "'" + ")" + " AND " + "SYNC_STATUS" + " IN (" + "'" + IDataStructure.SYNC_STATUS.QUEUED.ordinal() + "'" + ")";
                        break;
                    }
                    case ALL: {
                        whereClause = "";
                        break;
                    }
                }
                try {
                    childrenDataStructures = applicationDataManager.getChildren(childrenTableNames[i], whereClause, null, headerData);
                }
                catch (DBException dbException) {
                    Logger.e("DBException caught while retrieving children DataStructure of " + headerData.getTableName(), dbException);
                    return "";
                }
                if (childrenDataStructures == null) continue;
                int noOfChildrens = childrenDataStructures.length;
                for (int k = 0; k < noOfChildrens; ++k) {
                    Node itemNode = UNVDataHelper.getFragmentIbXml(document, childrenDataStructures[k], false);
                    be.appendChild(itemNode);
                }
            }
        }
        try {
            return XMLUtils.documentToFragmentString(document);
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
            return "";
        }
    }

    public static enum DATA_TYPE {
        ALL,
        CHANGED,
        CHANGED_QUEUED,
        QUEUED;

    }
}

