/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.model;

import com.unvired.database.DBException;
import com.unvired.database.IDataStructure;
import com.unvired.logger.Logger;
import com.unvired.model.DataStructure;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.PathManager;
import java.io.File;

public class AttachmentItem
extends DataStructure {
    public static final String UID = "UID";
    public static final String MIME_TYPE = "MIME_TYPE";
    public static final String FILE_NAME = "FILE_NAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String URL = "URL";
    public static final String EXTERNAL_URL = "EXTERNAL_URL";
    public static final String URL_REQUIRES_AUTH = "URL_REQUIRES_AUTH";
    public static final String LOCAL_PATH = "LOCAL_PATH";
    public static final String NO_CACHE = "NO_CACHE";
    public static final String AUTO_DOWNLOAD = "AUTO_DOWNLOAD";
    public static final String ATTACHMENT_STATUS = "ATTACHMENT_STATUS";
    public static final String CUSTOM_FIELD_1 = "CUSTOM_FIELD_1";
    public static final String CUSTOM_FIELD_2 = "CUSTOM_FIELD_2";
    public static final String TAG1 = "TAG1";
    public static final String TAG2 = "TAG2";
    public static final String TAG3 = "TAG3";
    public static final String TAG4 = "TAG4";
    public static final String TAG5 = "TAG5";
    public static final String[] PRIMARY_KEYS = new String[]{"LID"};
    public static final String[] GID_FIELDS = new String[]{"UID"};
    public static final String[] FIELD_NAMES = new String[]{"LID", "FID", "TIME_STAMP", "OBJECT_STATUS", "SYNC_STATUS", "UID", "MIME_TYPE", "FILE_NAME", "DESCRIPTION", "URL", "EXTERNAL_URL", "URL_REQUIRES_AUTH", "LOCAL_PATH", "NO_CACHE", "AUTO_DOWNLOAD", "ATTACHMENT_STATUS", "CUSTOM_FIELD_1", "CUSTOM_FIELD_2", "TAG1", "TAG2", "TAG3", "TAG4", "TAG5"};
    public static final String[] FIELD_TYPES = new String[]{"TEXT", "TEXT", "INTEGER", "INTEGER", "INTEGER", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "INTEGER", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT"};
    public static final boolean[] MANDATORY_FIELDS = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public AttachmentItem(String tableName) throws DBException {
        super(tableName, false);
    }

    public AttachmentItem(String tableName, boolean isHeader, String[] fieldNames, String[] fieldTypes, String[] gidFieldNames) {
        super(tableName, isHeader, fieldNames, fieldTypes, gidFieldNames);
    }

    public String getUid() {
        return (String)this.getField(UID);
    }

    public void setUid(String uid) {
        this.setField(UID, uid);
    }

    public String getMimeType() {
        return (String)this.getField(MIME_TYPE);
    }

    public void setMimeType(String mimeType) {
        this.setField(MIME_TYPE, mimeType);
    }

    public String getDescription() {
        return (String)this.getField(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.setField(DESCRIPTION, description);
    }

    public String getUrl() {
        return (String)this.getField(URL);
    }

    public void setUrl(String url) {
        this.setField(URL, url);
    }

    public String getExternalUrl() {
        return (String)this.getField(EXTERNAL_URL);
    }

    public void setExternalUrl(String externalUrl) {
        this.setField(EXTERNAL_URL, externalUrl);
    }

    public String getUrlRequiresAuth() {
        return (String)this.getField(URL_REQUIRES_AUTH);
    }

    public void setUrlRequiresAuth(String urlRequiresAuth) {
        this.setField(URL_REQUIRES_AUTH, urlRequiresAuth);
    }

    public String getLocalPath() {
        String localPath = (String)this.getField(LOCAL_PATH);
        if (localPath == null && (localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.INBOX_FOLDER)) == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "getLocalPath", "Cannot get local path to save attachment files.");
            return null;
        }
        return localPath;
    }

    public void setLocalPath(String localPath) {
        File file;
        if (localPath != null && !(file = new File(localPath)).exists() && (localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.INBOX_FOLDER)) == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "setLocalPath", "Cannot get local path to save attachment files.");
            return;
        }
        this.setField(LOCAL_PATH, localPath);
    }

    public boolean isCacheRequired() {
        String noCache = (String)this.getField(NO_CACHE);
        return "true".equals(noCache);
    }

    public void setNoCache(String noCache) {
        this.setField(NO_CACHE, noCache);
    }

    public boolean isAutoDownloadRequired() {
        String autoDownload = (String)this.getField(AUTO_DOWNLOAD);
        return "true".equals(autoDownload);
    }

    public void setAutoDownload(String autoDownload) {
        this.setField(AUTO_DOWNLOAD, autoDownload);
    }

    public ATTACHMENT_ITEM_STATUS getAttachmentStatus() {
        Long status = (Long)this.getField(ATTACHMENT_STATUS);
        if (status == null) {
            return ATTACHMENT_ITEM_STATUS.DEFAULT;
        }
        if (0L <= status && status < (long)IDataStructure.OBJECT_STATUS.values().length) {
            return ATTACHMENT_ITEM_STATUS.values()[status.intValue()];
        }
        return ATTACHMENT_ITEM_STATUS.DEFAULT;
    }

    public void setAttachmentStatus(ATTACHMENT_ITEM_STATUS attachmentStatus) {
        if (attachmentStatus == null) {
            return;
        }
        this.setField(ATTACHMENT_STATUS, Integer.valueOf(attachmentStatus.ordinal()).longValue());
    }

    public String getCustomField1() {
        return (String)this.getField(CUSTOM_FIELD_1);
    }

    public void setCustomField1(String customField1) {
        this.setField(CUSTOM_FIELD_1, customField1);
    }

    public String getCustomField2() {
        return (String)this.getField(CUSTOM_FIELD_2);
    }

    public void setCustomField2(String customField2) {
        this.setField(CUSTOM_FIELD_2, customField2);
    }

    public String getFileName() {
        return (String)this.getField(FILE_NAME);
    }

    public void setFileName(String fileName) {
        this.setField(FILE_NAME, fileName);
    }

    public String getTag5() {
        return (String)this.getField(TAG5);
    }

    public void setTag5(String tag5) {
        this.setField(TAG5, tag5);
    }

    public String getTag4() {
        return (String)this.getField(TAG4);
    }

    public void setTag4(String tag4) {
        this.setField(TAG4, tag4);
    }

    public String getTag3() {
        return (String)this.getField(TAG3);
    }

    public void setTag3(String tag3) {
        this.setField(TAG3, tag3);
    }

    public String getTag2() {
        return (String)this.getField(TAG2);
    }

    public void setTag2(String tag2) {
        this.setField(TAG2, tag2);
    }

    public String getTag1() {
        return (String)this.getField(TAG1);
    }

    public void setTag1(String tag1) {
        this.setField(TAG1, tag1);
    }

    public void delete() {
        String localPath = this.getLocalPath();
        String fileName = this.getFileName();
        Logger.log(7, this.getClass().getName(), "delete", "Delete attachment item's file if any : " + localPath + fileName);
        File file = new File(localPath);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            file = new File(localPath, fileName);
        }
        if (file.exists()) {
            file.delete();
        }
    }

    public static enum ATTACHMENT_ITEM_STATUS {
        DEFAULT,
        QUEUED_FOR_DOWNLOAD,
        DOWNLOADED,
        ERROR_IN_DOWNLOAD,
        SAVED_FOR_UPLOAD,
        UPLOADED,
        ERROR_IN_UPLOAD,
        MARKED_FOR_DELETE;

    }
}

