/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.model;

import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.MissingFieldException;
import com.unvired.exception.MissingFieldTypeException;
import com.unvired.logger.Logger;
import com.unvired.model.FieldMeta;
import com.unvired.model.InfoMessage;
import com.unvired.model.StructureMeta;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.UUID;
import java.util.Vector;

public abstract class DataStructure
implements IDataStructure {
    private String beName = "";
    protected String tableName = "";
    private Hashtable<String, Object> fields = new Hashtable();
    private Hashtable<String, String> fieldTypes = new Hashtable();
    private String[] gidFieldNames;
    private boolean isHeader = false;
    private boolean isModified = false;
    private ApplicationManager applicationManager = ApplicationManager.getInstance();
    private IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();

    public DataStructure(String tableName, boolean isHeader) throws DBException {
        this.tableName = tableName;
        this.isHeader = isHeader;
        this.initialize();
        FieldMeta[] fieldMetas = this.applicationManager.getFieldsMeta(tableName);
        if (fieldMetas == null || fieldMetas.length == 0) {
            throw new DBException(this.getClass().getName(), "DataStructure", "No field metas found for table: " + tableName);
        }
        this.beName = fieldMetas[0].getBeName();
        for (FieldMeta fieldMeta : fieldMetas) {
            String dataName = fieldMeta.getFieldName();
            String dataType = fieldMeta.getSqlType();
            this.fieldTypes.put(dataName, dataType);
        }
        this.fieldTypes.put("LID", "TEXT");
        this.fieldTypes.put("FID", "TEXT");
        this.fieldTypes.put("TIME_STAMP", "INTEGER");
        this.fieldTypes.put("OBJECT_STATUS", "INTEGER");
        this.fieldTypes.put("SYNC_STATUS", "INTEGER");
        this.fieldTypes.put("HAS_CONFLICT", "TEXT");
        Vector<String> tempGids = new Vector<String>();
        for (FieldMeta fieldMeta : fieldMetas) {
            String fieldName = fieldMeta.getFieldName();
            this.createField(fieldName);
            if (!fieldMeta.isGid()) continue;
            tempGids.addElement(fieldName);
        }
        int size = tempGids.size();
        this.gidFieldNames = new String[size];
        for (int i = 0; i < size; ++i) {
            this.gidFieldNames[i] = (String)tempGids.elementAt(i);
        }
    }

    DataStructure(String tableName, boolean isHeader, String[] fieldNames, String[] fieldTypes, String[] gidFieldNames) {
        this.tableName = tableName;
        this.isHeader = isHeader;
        this.gidFieldNames = gidFieldNames;
        for (int i = 0; i < fieldNames.length; ++i) {
            this.createField(fieldNames[i]);
            this.fieldTypes.put(fieldNames[i], fieldTypes[i]);
        }
        this.setField("LID", this.generateLID());
    }

    private String generateLID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private void initialize() {
        this.createField("LID");
        this.createField("TIME_STAMP");
        this.createField("OBJECT_STATUS");
        this.createField("SYNC_STATUS");
        if (this.isHeader) {
            this.createField("HAS_CONFLICT");
        }
        this.setObjectStatus(IDataStructure.OBJECT_STATUS.ADD);
        this.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
        if (!this.isHeader) {
            this.createField("FID");
        }
        this.setField("LID", this.generateLID());
    }

    @Override
    public String getBEName() {
        return this.beName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public boolean isHeader() {
        return this.isHeader;
    }

    private void createField(String fieldName) {
        if (!this.fields.containsKey(fieldName)) {
            this.fields.put(fieldName, new NullObject());
        }
    }

    @Override
    public String getLid() {
        return (String)this.getField("LID");
    }

    @Override
    public void setLid(String lid) {
        this.setField("LID", lid);
    }

    @Override
    public String getFid() {
        return (String)this.getField("FID");
    }

    @Override
    public void setFid(String fid) {
        this.setField("FID", fid);
    }

    @Override
    public Long getTimeStamp() {
        return (Long)this.getField("TIME_STAMP");
    }

    @Override
    public void setTimeStamp(Long timeStamp) {
        this.setField("TIME_STAMP", timeStamp);
    }

    @Override
    public IDataStructure.OBJECT_STATUS getObjectStatus() {
        Long objectStatus = (Long)this.getField("OBJECT_STATUS");
        if (objectStatus == null) {
            return null;
        }
        if (0L <= objectStatus && objectStatus < (long)IDataStructure.OBJECT_STATUS.values().length) {
            return IDataStructure.OBJECT_STATUS.values()[objectStatus.intValue()];
        }
        return null;
    }

    @Override
    public void setObjectStatus(IDataStructure.OBJECT_STATUS objectStatus) {
        if (objectStatus == null) {
            return;
        }
        this.setField("OBJECT_STATUS", objectStatus.ordinal());
    }

    @Override
    public IDataStructure.SYNC_STATUS getSyncStatus() {
        Long syncStatus = (Long)this.getField("SYNC_STATUS");
        if (syncStatus == null) {
            return null;
        }
        if (0L <= syncStatus && syncStatus < (long)IDataStructure.SYNC_STATUS.values().length) {
            return IDataStructure.SYNC_STATUS.values()[syncStatus.intValue()];
        }
        return null;
    }

    @Override
    public void setSyncStatus(IDataStructure.SYNC_STATUS syncStatus) {
        if (syncStatus == null) {
            return;
        }
        this.setField("SYNC_STATUS", syncStatus.ordinal());
    }

    @Override
    public boolean getHasConflict() {
        Object hasConflict = this.getField("HAS_CONFLICT");
        return hasConflict != null && "X".equalsIgnoreCase(hasConflict.toString());
    }

    @Override
    public void setHasConflict(boolean hasConflict) {
        if (hasConflict) {
            this.setField("HAS_CONFLICT", "X");
        } else {
            this.setField("HAS_CONFLICT", "");
        }
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void setModifiedFlag(boolean modified) {
        this.isModified = modified;
    }

    @Override
    public boolean setField(String fieldName, Object value) {
        if (value == null) {
            value = new NullObject();
        } else if (value instanceof String) {
            value = (String)value;
        }
        switch (fieldName) {
            case "TIME_STAMP": 
            case "OBJECT_STATUS": 
            case "SYNC_STATUS": 
            case "ATTACHMENT_STATUS": {
                try {
                    if (value instanceof String) {
                        value = Long.parseLong(String.valueOf(value));
                        break;
                    }
                    if (!(value instanceof Integer)) break;
                    value = ((Integer)value).longValue();
                    break;
                }
                catch (NumberFormatException e) {
                    Logger.log(8, this.getClass().getName(), "setField", "Incorrect data type for field: " + fieldName + " Data Type: " + fieldName.getClass().getName() + " Value: " + value);
                    return false;
                }
            }
        }
        if (this.fields.containsKey(fieldName)) {
            Object oldValue = this.fields.get(fieldName);
            if (oldValue == null && !(value instanceof NullObject) || oldValue != null && value instanceof NullObject) {
                this.isModified = true;
            }
            if (oldValue != null && !(value instanceof NullObject) && !oldValue.toString().equals(value.toString())) {
                this.isModified = true;
            }
            this.fields.put(fieldName, value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setFieldBasedOnDataType(String fieldName, Object value) throws MissingFieldException, MissingFieldTypeException {
        if ("CHECKSUM".equalsIgnoreCase(fieldName) || "LID".equalsIgnoreCase(fieldName) || "FID".equalsIgnoreCase(fieldName) || "TIME_STAMP".equalsIgnoreCase(fieldName) || "OBJECT_STATUS".equalsIgnoreCase(fieldName) || "SYNC_STATUS".equalsIgnoreCase(fieldName)) {
            return false;
        }
        if (!this.fields.containsKey(fieldName)) {
            Logger.log(8, this.getClass().getName(), "setFieldBasedOnDataType", "Table " + this.tableName + " does not contain the field " + fieldName);
            return false;
        }
        if (this.fieldTypes == null) {
            String message = "No field types found for table: " + this.tableName;
            Logger.log(8, this.getClass().getName(), "setFieldBasedOnDataType", message);
            throw new MissingFieldTypeException(message);
        }
        String fieldType = this.fieldTypes.get(fieldName);
        if (fieldType == null) {
            Logger.log(8, this.getClass().getName(), "setFieldBasedOnDataType", "Table " + this.tableName + " FieldType not found for the field " + fieldName);
            throw new MissingFieldTypeException(this.tableName, fieldName);
        }
        if (value == null) {
            value = new NullObject();
            this.fields.put(fieldName, value);
            return true;
        }
        if (value instanceof String) {
            value = (String)value;
        }
        if ("TEXT".equalsIgnoreCase(fieldType)) {
            this.fields.put(fieldName, value);
            return true;
        }
        if (value instanceof String && Strings.isNullOrEmpty((String)((String)value))) {
            value = new NullObject();
            this.fields.put(fieldName, value);
            return true;
        }
        if ("INTEGER".equalsIgnoreCase(fieldType)) {
            try {
                long longValue = Long.parseLong(String.valueOf(value));
                this.fields.put(fieldName, longValue);
                return true;
            }
            catch (NumberFormatException e) {
                String message = "NumberFormatException - " + e.getMessage() + " Table name: " + this.tableName + " Field name: " + fieldName + "Field type: " + fieldType + " Field value: " + value;
                Logger.log(8, this.getClass().getName(), "setFieldBasedOnDataType", message);
                throw new NumberFormatException(message);
            }
        }
        if ("REAL".equalsIgnoreCase(fieldType)) {
            try {
                double doubleValue = Double.parseDouble(String.valueOf(value));
                this.fields.put(fieldName, doubleValue);
                return true;
            }
            catch (NumberFormatException e) {
                String message = "NumberFormatException - " + e.getMessage() + " Table name: " + this.tableName + " Field name: " + fieldName + "Field type: " + fieldType + " Field value: " + value;
                Logger.log(8, this.getClass().getName(), "setFieldBasedOnDataType", message);
                throw new NumberFormatException(message);
            }
        }
        if ("BLOB".equalsIgnoreCase(fieldType)) {
            try {
                byte[] bytesValue = String.valueOf(value).getBytes();
                this.fields.put(fieldName, bytesValue);
                return true;
            }
            catch (ClassCastException e) {
                String message = "ClassCastException - " + e.getMessage() + " Table name: " + this.tableName + " Field name: " + fieldName + "Field type: " + fieldType + " Field value: " + value;
                Logger.log(8, this.getClass().getName(), "setFieldBasedOnDataType", message);
                throw new ClassCastException(message);
            }
        }
        return false;
    }

    @Override
    public Object getField(String fieldName) {
        Object value = this.fields.get(fieldName);
        if (value instanceof NullObject) {
            return null;
        }
        if (value instanceof String) {
            value = (String)value;
        }
        return value;
    }

    @Override
    public Enumeration<String> getFieldNames() {
        return this.fields.keys();
    }

    @Override
    public String getFieldType(String fieldName) {
        return this.fieldTypes.get(fieldName);
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public String[] getGidFieldNames() {
        return this.gidFieldNames;
    }

    @Override
    public Object[] getGids() throws DBException {
        if (this.gidFieldNames == null) {
            throw new DBException(this.getClass().getName(), "getGids", "GID fields not found");
        }
        Object[] gidValues = new Object[this.gidFieldNames.length];
        for (int i = 0; i < this.gidFieldNames.length; ++i) {
            gidValues[i] = this.getField(this.gidFieldNames[i]);
        }
        return gidValues;
    }

    @Override
    public String[] getChildrenTableNames() throws DBException {
        if (!this.isHeader) {
            throw new DBException(this.getClass().getName(), "getChildrenTableNames", "Not a header structure. So cannot have children");
        }
        StructureMeta structureMeta = this.applicationManager.getStructureMeta(this.tableName);
        if (structureMeta == null) {
            throw new DBException(this.getClass().getName(), "getChildrenTableNames", "Structure meta not found for structure: " + this.tableName);
        }
        StructureMeta[] structureMetas = this.applicationManager.getStructureMetas(structureMeta.getBeName());
        if (structureMetas == null) {
            throw new DBException(this.getClass().getName(), "getChildrenTableNames", "Structure metas not found for BE: " + structureMeta.getBeName());
        }
        String[] childrenTableNames = new String[structureMetas.length - 1];
        int indexForChildrenTableNames = 0;
        for (StructureMeta meta : structureMetas) {
            if (meta.getIsHeader()) continue;
            childrenTableNames[indexForChildrenTableNames++] = meta.getStructName();
        }
        return childrenTableNames;
    }

    @Override
    public InfoMessage[] getInfoMessages() throws DBException {
        StructureMeta structureMeta = this.applicationManager.getStructureMeta(this.tableName);
        String beName = structureMeta.getBeName();
        String whereClause = "BE_NAME = '" + beName + "' AND " + "BE_LID" + " = '" + this.getLid() + "'";
        IDataStructure[] dataStructures = this.frameworkDataManager.get("INFO_MESSAGE", whereClause, InfoMessage.class);
        if (dataStructures != null && dataStructures.length > 0) {
            InfoMessage[] infoMessages = new InfoMessage[dataStructures.length];
            System.arraycopy(dataStructures, 0, infoMessages, 0, dataStructures.length);
            return infoMessages;
        }
        return null;
    }

    protected int getInt(Object object) {
        int value = 0;
        if (object instanceof Long) {
            Long longObject = (Long)object;
            long longValue = longObject;
            Integer integer = (int)longValue;
            value = integer;
        } else if (object instanceof Float) {
            Float floatObject = (Float)object;
            Integer integer = (int)floatObject.floatValue();
            value = integer;
        } else if (object instanceof Double) {
            Double doubleObject = (Double)object;
            Integer integer = (int)doubleObject.floatValue();
            value = integer;
        } else if (object instanceof Integer) {
            Integer integerObject = (Integer)object;
            value = integerObject;
        }
        return value;
    }

    protected long getLong(Object object) {
        long value = 0L;
        if (object instanceof Long) {
            Long longObject = (Long)object;
            value = longObject;
        } else if (object instanceof Float) {
            Float floatObject = (Float)object;
            Long longObject = (long)floatObject.floatValue();
            value = longObject;
        } else if (object instanceof Double) {
            Double doubleObject = (Double)object;
            Long longObject = (long)doubleObject.floatValue();
            value = longObject;
        } else if (object instanceof Integer) {
            Integer integer = (Integer)object;
            Long longObject = (long)integer;
            value = longObject;
        }
        return value;
    }

    protected float getFloat(Object object) {
        float value = 0.0f;
        if (object instanceof Float) {
            Float floatObject = (Float)object;
            value = floatObject.floatValue();
        } else if (object instanceof Double) {
            Double doubleObject = (Double)object;
            value = doubleObject.floatValue();
        } else if (object instanceof Integer) {
            Integer integer = (Integer)object;
            Float floatObject = Float.valueOf(integer.intValue());
            value = floatObject.longValue();
        }
        return value;
    }

    protected boolean getBoolean(String string) {
        return "true".equalsIgnoreCase(string);
    }

    private class NullObject {
        private NullObject() {
        }
    }
}

