/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.parser;

import com.unvired.core.FrameworkVersion;
import com.unvired.database.DataTypes;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.ApplicationMeta;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.FieldMeta;
import com.unvired.model.IndexMeta;
import com.unvired.model.StructureMeta;
import com.unvired.utils.FrameworkHelper;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationMetaDataParser {
    private String appName;
    private ApplicationMeta applicationMeta;
    private Vector<BusinessEntityMeta> businessEntityMetas = new Vector();
    private Vector<StructureMeta> structureMetas = new Vector();
    private Vector<FieldMeta> fieldMetas = new Vector();
    private Vector<IndexMeta> indexMetas = new Vector();
    private Vector<String> gidVector;

    public ApplicationMetaDataParser(String metaData) throws ApplicationException {
        if (metaData.startsWith("{") && metaData.endsWith("}")) {
            try {
                JSONObject jsonObject = new JSONObject(metaData);
                this.parseJson(jsonObject);
            }
            catch (Exception applicationException) {
                Logger.e("ApplicationException caught while parsing meta data Json.", applicationException);
                throw new ApplicationException(this.getClass().getName(), "Constructor", "ApplicationException caught while parsing meta data Json: " + applicationException.getMessage());
            }
        }
        try {
            Document document = FrameworkHelper.getDocumentRoot(new ByteArrayInputStream(metaData.getBytes()));
            this.parseXml(document);
        }
        catch (Exception applicationException) {
            Logger.e("ApplicationException caught while parsing meta data Xml.", applicationException);
            throw new ApplicationException(this.getClass().getName(), "Constructor", "ApplicationException caught while parsing meta data Xml: " + applicationException.getMessage());
        }
    }

    public ApplicationMeta getApplicationMeta() {
        return this.applicationMeta;
    }

    public Vector<BusinessEntityMeta> getBusinessEntityMetas() {
        return this.businessEntityMetas;
    }

    public Vector<StructureMeta> getStructureMetas() {
        return this.structureMetas;
    }

    public Vector<FieldMeta> getFieldMetas() {
        return this.fieldMetas;
    }

    public Vector<IndexMeta> getIndexMetas() {
        return this.indexMetas;
    }

    private void parseXml(Document document) {
        Element objRoot = document.getDocumentElement();
        this.appName = objRoot.getAttributes().getNamedItem("name").getNodeValue();
        String applicationDescription = objRoot.getAttributes().getNamedItem("description").getNodeValue();
        String applicationVersion = "";
        Node applicationVersionNode = objRoot.getAttributes().getNamedItem("version");
        if (applicationVersionNode != null) {
            applicationVersion = applicationVersionNode.getNodeValue();
        }
        Date date = new Date();
        this.applicationMeta = new ApplicationMeta();
        this.applicationMeta.setName(this.appName);
        this.applicationMeta.setDescription(applicationDescription);
        this.applicationMeta.setVersion(applicationVersion);
        this.applicationMeta.setFrameworkVersion(FrameworkVersion.getFrameworkVersion());
        this.applicationMeta.setInstallationDate(String.valueOf(date.getTime()));
        NodeList nodeList = objRoot.getChildNodes();
        Node node = null;
        int noOfNodeList = nodeList.getLength();
        for (int i = 0; i < noOfNodeList; ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"BusinessEntity".equalsIgnoreCase(node.getLocalName())) continue;
            this.parseBEMeta(node);
        }
    }

    private void parseBEMeta(Node nodeBE) {
        String beName = nodeBE.getAttributes().getNamedItem("name").getNodeValue();
        String beDesc = nodeBE.getAttributes().getNamedItem("description").getNodeValue();
        Node attachmentNode = nodeBE.getAttributes().getNamedItem("attachments");
        String attachments = "false";
        if (attachmentNode != null) {
            attachments = nodeBE.getAttributes().getNamedItem("attachments").getNodeValue();
        }
        Node onConflictNode = nodeBE.getAttributes().getNamedItem("onConflict");
        String onConflict = "SERVER_WINS";
        if (onConflictNode != null) {
            onConflict = nodeBE.getAttributes().getNamedItem("onConflict").getNodeValue();
        }
        Node saveBENode = nodeBE.getAttributes().getNamedItem("save");
        boolean saveBE = true;
        if (saveBENode != null) {
            String saveBEAttr = nodeBE.getAttributes().getNamedItem("save").getNodeValue();
            saveBE = !"false".equalsIgnoreCase(saveBEAttr);
        }
        BusinessEntityMeta businessEntityMeta = new BusinessEntityMeta();
        businessEntityMeta.setAppName(this.appName);
        businessEntityMeta.setBeName(beName);
        businessEntityMeta.setDescription(beDesc);
        boolean attachmentsRequired = "true".equals(attachments);
        businessEntityMeta.setAttachments(attachmentsRequired);
        businessEntityMeta.setConflictRule(onConflict);
        businessEntityMeta.setSAVE_BE(saveBE);
        this.businessEntityMetas.addElement(businessEntityMeta);
        NodeList nodeList = null;
        nodeList = nodeBE.getChildNodes();
        int noOfNodeList = nodeList.getLength();
        for (int i = 0; i < noOfNodeList; ++i) {
            Node nodeStructure = nodeList.item(i);
            if (nodeStructure.getNodeType() != 1) continue;
            String nodeName = nodeStructure.getLocalName();
            if ("header".equalsIgnoreCase(nodeName)) {
                this.parseStructureMeta(nodeStructure, businessEntityMeta, true);
                continue;
            }
            if ("item".equalsIgnoreCase(nodeName)) {
                this.parseStructureMeta(nodeStructure, businessEntityMeta, false);
                continue;
            }
            if (!"Index".equalsIgnoreCase(nodeName)) continue;
            this.parseIndexMeta(nodeStructure);
        }
    }

    private void parseStructureMeta(Node nodeStructure, BusinessEntityMeta businessEntity, boolean isHeader) {
        String structureName = nodeStructure.getAttributes().getNamedItem("name").getNodeValue();
        if (structureName != null && structureName.toLowerCase().endsWith("_attachment")) {
            return;
        }
        String structureDesc = nodeStructure.getAttributes().getNamedItem("description").getNodeValue();
        String className = nodeStructure.getAttributes().getNamedItem("className").getNodeValue();
        StructureMeta structure = new StructureMeta();
        structure.setAppName(this.appName);
        structure.setBeName(businessEntity.getBeName());
        structure.setStructName(structureName);
        structure.setDecription(structureDesc);
        structure.setClassName(className);
        structure.setIsHeader(isHeader);
        this.structureMetas.addElement(structure);
        this.gidVector = new Vector();
        this.parseFieldMeta(nodeStructure, structure);
        if (!businessEntity.getSAVE_BE()) {
            return;
        }
        int noOfGids = this.gidVector.size();
        String[] gids = new String[noOfGids];
        for (int i = 0; i < noOfGids; ++i) {
            gids[i] = this.gidVector.elementAt(i);
        }
        if (noOfGids > 0) {
            IndexMeta indexMeta = new IndexMeta();
            indexMeta.setIndexName(structureName + "_GID_INDEX");
            indexMeta.setStructureName(structureName);
            indexMeta.setFieldName(gids);
            this.indexMetas.addElement(indexMeta);
        }
    }

    private void parseFieldMeta(Node nodeStructure, StructureMeta item) {
        NodeList lstNodes = nodeStructure.getChildNodes();
        Node objNode = null;
        int noOfNodeList = lstNodes.getLength();
        for (int i = 0; i < noOfNodeList; ++i) {
            objNode = lstNodes.item(i);
            if (!"Field".equalsIgnoreCase(objNode.getLocalName())) continue;
            NamedNodeMap objAttributes = objNode.getAttributes();
            String name = objAttributes.getNamedItem("name").getNodeValue();
            String description = objAttributes.getNamedItem("description").getNodeValue();
            String fieldType = objAttributes.getNamedItem("sqlType").getNodeValue();
            String gidField = null;
            String mandatoryField = null;
            boolean isGid = false;
            boolean mandatory = false;
            if (objAttributes.getNamedItem("isGid") != null) {
                gidField = objAttributes.getNamedItem("isGid").getNodeValue();
            }
            if (objAttributes.getNamedItem("mandatory") != null) {
                mandatoryField = objAttributes.getNamedItem("mandatory").getNodeValue();
            }
            fieldType = DataTypes.checkDataType(fieldType) ? fieldType.toUpperCase() : "TEXT";
            isGid = "true".equalsIgnoreCase(gidField);
            mandatory = "true".equalsIgnoreCase(mandatoryField);
            FieldMeta fieldMeta = new FieldMeta();
            fieldMeta.setAppName(this.appName);
            fieldMeta.setBeName(item.getBeName());
            fieldMeta.setStructName(item.getStructName());
            fieldMeta.setFieldName(name);
            fieldMeta.setDescription(description);
            fieldMeta.setSqlType(fieldType);
            fieldMeta.setIsGid(isGid);
            fieldMeta.setMandatory(String.valueOf(mandatory));
            this.fieldMetas.addElement(fieldMeta);
            if (!isGid) continue;
            this.gidVector.addElement(name);
        }
    }

    private void parseIndexMeta(Node node) {
        IndexMeta indexMeta = new IndexMeta();
        String indexName = node.getAttributes().getNamedItem("name").getNodeValue();
        String structureName = node.getAttributes().getNamedItem("structureName").getNodeValue();
        String description = node.getAttributes().getNamedItem("description").getNodeValue();
        indexMeta.setIndexName(indexName);
        indexMeta.setStructureName(structureName);
        indexMeta.setDescription(description);
        NodeList listNodes = node.getChildNodes();
        Node objNode = null;
        int noOfNodeList = listNodes.getLength();
        Vector<String> fieldNameVector = new Vector<String>();
        for (int i = 0; i < noOfNodeList; ++i) {
            objNode = listNodes.item(i);
            if (!"Field".equalsIgnoreCase(objNode.getLocalName())) continue;
            fieldNameVector.addElement(this.parseIndexField(objNode));
        }
        int noOfFields = fieldNameVector.size();
        if (noOfFields == 0) {
            return;
        }
        String[] fieldNames = new String[noOfFields];
        for (int i = 0; i < noOfFields; ++i) {
            fieldNames[i] = (String)fieldNameVector.elementAt(i);
        }
        indexMeta.setFieldName(fieldNames);
        this.indexMetas.addElement(indexMeta);
    }

    private String parseIndexField(Node node) {
        return node.getAttributes().getNamedItem("name").getNodeValue();
    }

    private void parseJson(JSONObject jsonObject) throws Exception {
        this.appName = jsonObject.getString("name");
        String applicationDescription = jsonObject.getString("description");
        String applicationVersion = jsonObject.getString("version");
        this.applicationMeta = new ApplicationMeta();
        this.applicationMeta.setName(this.appName);
        this.applicationMeta.setDescription(applicationDescription);
        this.applicationMeta.setVersion(applicationVersion);
        this.applicationMeta.setFrameworkVersion(FrameworkVersion.getFrameworkVersion());
        this.applicationMeta.setInstallationDate(String.valueOf(new Date().getTime()));
        Iterator keys = jsonObject.keys();
        block10: while (keys.hasNext()) {
            String key;
            switch (key = (String)keys.next()) {
                case "name": 
                case "description": 
                case "version": {
                    continue block10;
                }
                case "Index": {
                    this.parseIndexMetaJson(jsonObject.getJSONArray(key));
                    continue block10;
                }
            }
            this.parseBEJson(key, jsonObject.getJSONObject(key));
        }
    }

    private void parseBEJson(String beName, JSONObject beJsonObject) throws Exception {
        BusinessEntityMeta businessEntityMeta = new BusinessEntityMeta();
        businessEntityMeta.setAppName(this.appName);
        businessEntityMeta.setBeName(beName);
        businessEntityMeta.setAttachments(false);
        businessEntityMeta.setConflictRule("SERVER_WINS");
        businessEntityMeta.setSAVE_BE(true);
        Iterator keys = beJsonObject.keys();
        block12: while (keys.hasNext()) {
            String key;
            switch (key = (String)keys.next()) {
                case "description": {
                    businessEntityMeta.setDescription(beJsonObject.getString(key));
                    continue block12;
                }
                case "attachments": {
                    businessEntityMeta.setAttachments(beJsonObject.getBoolean(key));
                    continue block12;
                }
                case "onConflict": {
                    businessEntityMeta.setConflictRule(beJsonObject.getString(key));
                    continue block12;
                }
                case "save": {
                    businessEntityMeta.setSAVE_BE(beJsonObject.getBoolean(key));
                    continue block12;
                }
            }
            this.parseStructureMetaJson(key, beJsonObject.getJSONObject(key), businessEntityMeta);
        }
        this.businessEntityMetas.addElement(businessEntityMeta);
    }

    private void parseStructureMetaJson(String structureName, JSONObject structureJsonObject, BusinessEntityMeta businessEntityMeta) throws Exception {
        if (structureJsonObject.optBoolean("attachment")) {
            return;
        }
        StructureMeta structure = new StructureMeta();
        structure.setAppName(this.appName);
        structure.setBeName(businessEntityMeta.getBeName());
        structure.setStructName(structureName);
        structure.setIsHeader(structureJsonObject.optBoolean("header"));
        Iterator keys = structureJsonObject.keys();
        block10: while (keys.hasNext()) {
            String key;
            switch (key = (String)keys.next()) {
                case "header": {
                    continue block10;
                }
                case "description": {
                    structure.setDecription(structureJsonObject.getString(key));
                    continue block10;
                }
                case "className": {
                    structure.setClassName(structureJsonObject.getString(key));
                    continue block10;
                }
            }
            this.gidVector = new Vector();
            this.parseFieldMetaJson(structureJsonObject.getJSONArray(key), structure);
        }
        this.structureMetas.addElement(structure);
        if (!businessEntityMeta.getSAVE_BE()) {
            return;
        }
        int noOfGids = this.gidVector.size();
        String[] gids = new String[noOfGids];
        for (int i = 0; i < noOfGids; ++i) {
            gids[i] = this.gidVector.elementAt(i);
        }
        if (noOfGids > 0) {
            IndexMeta indexMeta = new IndexMeta();
            indexMeta.setIndexName(structureName + "_GID_INDEX");
            indexMeta.setStructureName(structureName);
            indexMeta.setFieldName(gids);
            this.indexMetas.addElement(indexMeta);
        }
    }

    private void parseIndexMetaJson(JSONArray indexJsonArray) throws Exception {
        for (int i = 0; i < indexJsonArray.length(); ++i) {
            JSONObject indexJsonObject = indexJsonArray.getJSONObject(i);
            IndexMeta indexMeta = new IndexMeta();
            indexMeta.setIndexName(indexJsonObject.getString("name"));
            indexMeta.setStructureName(indexJsonObject.getString("tableName"));
            indexMeta.setDescription(indexJsonObject.optString("description"));
            JSONArray fieldsArray = indexJsonObject.getJSONArray("Fields");
            String[] fieldNames = new String[fieldsArray.length()];
            for (int j = 0; j < indexJsonArray.length(); ++j) {
                fieldNames[i] = fieldsArray.getString(i);
            }
            indexMeta.setFieldName(fieldNames);
            this.indexMetas.addElement(indexMeta);
        }
    }

    private void parseFieldMetaJson(JSONArray fieldJsonArray, StructureMeta structure) throws Exception {
        for (int i = 0; i < fieldJsonArray.length(); ++i) {
            JSONObject fieldJsonObject = fieldJsonArray.getJSONObject(i);
            FieldMeta fieldMeta = new FieldMeta();
            fieldMeta.setAppName(this.appName);
            fieldMeta.setBeName(structure.getBeName());
            fieldMeta.setStructName(structure.getStructName());
            fieldMeta.setFieldName(fieldJsonObject.getString("name"));
            fieldMeta.setDescription(fieldJsonObject.optString("description"));
            fieldMeta.setSqlType(fieldJsonObject.getString("sqlType"));
            fieldMeta.setIsGid(fieldJsonObject.optBoolean("isGid"));
            fieldMeta.setMandatory(String.valueOf(fieldJsonObject.optBoolean("mandatory")));
            this.fieldMetas.addElement(fieldMeta);
            if (!fieldMeta.isGid()) continue;
            this.gidVector.addElement(fieldMeta.getFieldName());
        }
    }
}

