/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.parser;

import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.json.JSONObject;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ApplicationNameAndVersionParser
extends DefaultHandler {
    private String appName;
    private String appDescription;
    private String appVersion = null;

    public ApplicationNameAndVersionParser(String metaData) throws ApplicationException {
        if (metaData == null) {
            throw new ApplicationException(this.getClass().getName(), "ApplicationNameParser", "Application meta data file is null");
        }
        if (metaData.startsWith("{") && metaData.endsWith("}")) {
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject(metaData);
                this.parseJson(jsonObject);
            }
            catch (Exception e) {
                throw new ApplicationException(this.getClass().getName(), "ApplicationNameParser", "Application meta data json file parsing failed");
            }
        } else {
            this.parseXml(metaData.getBytes());
        }
    }

    private void parseXml(byte[] responseBytes) throws ApplicationException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = null;
        try {
            saxParser = saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.log(8, this.getClass().getName(), "parseXml", "ParserConfigurationException caught while creating SAXParser object, " + parserConfigurationException.getMessage());
            throw new ApplicationException(this.getClass().getName(), "parseXml", "ParserConfigurationException caught while creating SAXParser object, " + parserConfigurationException.getMessage());
        }
        catch (SAXException saxException) {
            Logger.log(8, this.getClass().getName(), "parseXml", "SAXException caught while creating SAXPArser object, " + saxException.getMessage());
            throw new ApplicationException(this.getClass().getName(), "parseXml", "SAXException caught while creating SAXPArser object, " + saxException.getMessage());
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(responseBytes);
            saxParser.parse((InputStream)byteArrayInputStream, (DefaultHandler)this);
        }
        catch (SAXException saxException) {
            Logger.log(8, this.getClass().getName(), "parseXml", "SAXException caught while parsing the message, " + saxException.getMessage());
            throw new ApplicationException(this.getClass().getName(), "parseXml", "SAXException caught while parsing the message, " + saxException.getMessage());
        }
        catch (IOException ioException) {
            Logger.log(8, this.getClass().getName(), "parseXml", "IOException caught while parsing the message, " + ioException.getMessage());
            throw new ApplicationException(this.getClass().getName(), "parseXml", "IOException caught while parsing the message, " + ioException.getMessage());
        }
        catch (ClassCastException classCastException) {
            Logger.log(8, this.getClass().getName(), "parseXml", "ClassCastException caught while parsing the message, " + classCastException.getMessage());
            throw new ApplicationException(this.getClass().getName(), "parseXml", "ClassCastException caught while parsing the message, " + classCastException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            Logger.log(8, this.getClass().getName(), "parseXml", "NullPointerException caught while parsing the message, " + nullPointerException.getMessage());
            throw new ApplicationException(this.getClass().getName(), "parseXml", "NullPointerException caught while parsing the message, " + nullPointerException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            Logger.log(8, this.getClass().getName(), "parser", "NumberFormatException caught while parsing the message, " + numberFormatException.getMessage());
            throw new ApplicationException(this.getClass().getName(), "parser", "NumberFormatException caught while parsing the message, " + numberFormatException.getMessage());
        }
        catch (Exception exception) {
            Logger.log(8, this.getClass().getName(), "parseXml", "Exception caught while parsing the message, " + exception.getMessage());
            throw new ApplicationException(this.getClass().getName(), "parseXml", "Exception caught while parsing the message, " + exception.getMessage());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("Application".equalsIgnoreCase(localName) && attributes != null) {
            this.appName = attributes.getValue("name");
            this.appDescription = attributes.getValue("description");
            this.appVersion = attributes.getValue("version");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    private void parseJson(JSONObject jsonObject) throws Exception {
        this.appName = jsonObject.getString("name");
        this.appDescription = jsonObject.getString("description");
        this.appVersion = jsonObject.getString("version");
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getApplicationDescription() {
        return this.appDescription;
    }

    public String getApplicationVersion() {
        return this.appVersion;
    }
}

