/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.parser;

import com.google.common.base.Strings;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IncomingMessageParser
extends DefaultHandler {
    private String requestType;
    private int messageType;
    private int messageSubType;
    private String conversationId;
    private String serverId;
    private String applicationId;
    private String applicationName;
    private boolean dataNode;
    private boolean errorNode;
    private String wipeURL;
    private String tempValue;

    public IncomingMessageParser(InputStream inputStream) throws ApplicationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser sp = null;
        try {
            sp = spf.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.e("ParserConfigurationException caught while getting new instance of SAXParser", parserConfigurationException);
            throw new ApplicationException(this.getClass().getName(), "Constructor", "ParserConfigurationException caught while getting new instance of SAXParser, " + parserConfigurationException.getMessage());
        }
        catch (SAXException saxException) {
            Logger.e("SAXException caught while getting new instance of SAXParser", saxException);
            throw new ApplicationException(this.getClass().getName(), "Constructor", "SAXException caught while getting new instance of SAXParser, " + saxException.getMessage());
        }
        try {
            sp.parse(inputStream, (DefaultHandler)this);
        }
        catch (IOException ioException) {
            Logger.e("IOException caught while parsing data", ioException);
            throw new ApplicationException(this.getClass().getName(), "Constructor", "IOException caught while parsing data, " + ioException.getMessage());
        }
        catch (SAXException saxException) {
            Logger.e("SAXException caught while parsing data", saxException);
            throw new ApplicationException(this.getClass().getName(), "Constructor", "SAXException caught while parsing data, " + saxException.getMessage());
        }
        catch (Exception exception) {
            Logger.e("Exception caught while parsing data", exception);
            throw new ApplicationException(this.getClass().getName(), "Constructor", "Exception caught while parsing data, " + exception.getMessage());
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        String subType;
        this.tempValue = "";
        if ("Root".equalsIgnoreCase(localName)) {
            if (attributes != null) {
                this.requestType = attributes.getValue("requestType");
                String messageType = attributes.getValue("type");
                if (!Strings.isNullOrEmpty((String)messageType)) {
                    this.messageType = Integer.parseInt(messageType);
                }
            }
        } else if ("data".equalsIgnoreCase(qName) && attributes != null && !Strings.isNullOrEmpty((String)(subType = attributes.getValue("subtype")))) {
            this.messageSubType = Integer.parseInt(subType);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tempValue = new String(ch, start, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("ConversationId".equalsIgnoreCase(localName)) {
            this.conversationId = this.tempValue;
        } else if ("ServerId".equalsIgnoreCase(localName)) {
            this.serverId = this.tempValue;
        } else if ("ApplicationId".equalsIgnoreCase(localName)) {
            this.applicationId = this.tempValue;
        } else if ("ApplicationName".equalsIgnoreCase(localName)) {
            this.applicationName = this.tempValue;
        } else if ("data".equalsIgnoreCase(localName)) {
            this.dataNode = true;
        } else if ("URL".equalsIgnoreCase(localName)) {
            this.wipeURL = this.tempValue;
        }
    }

    public String getRequestType() {
        return this.requestType;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getMessageSubType() {
        return this.messageSubType;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public boolean getDataNode() {
        return this.dataNode;
    }

    public boolean getErrorNode() {
        return this.errorNode;
    }

    public String getWipeURL() {
        return this.wipeURL;
    }
}

