/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.parser;

import com.unvired.sync.in.NotificationBO;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NotificationXMLHandler
extends DefaultHandler {
    Boolean currentElement = false;
    String currentValue = "";
    NotificationBO notification = null;
    private ArrayList<NotificationBO> notificationsList = new ArrayList();

    public ArrayList<NotificationBO> getNotificationsList() {
        return this.notificationsList;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentElement = true;
        this.currentValue = "";
        if ("PushNotification".equals(localName) || "IndiencePushNotification".equals(localName) || "UnviredPushNotification".equalsIgnoreCase(localName)) {
            this.notification = new NotificationBO();
            this.notification.setNotificationType(attributes.getValue("type"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentElement = false;
        if ("NotificationMessage".equalsIgnoreCase(localName)) {
            this.notification.setAlert(this.currentValue);
        } else if ("Title".equalsIgnoreCase(localName)) {
            this.notification.setTitle(this.currentValue);
        } else if ("ActionButton".equalsIgnoreCase(localName)) {
            this.notification.setActionButton(this.currentValue);
        } else if ("Silent".equalsIgnoreCase(localName)) {
            boolean isSilent = false;
            try {
                isSilent = Boolean.parseBoolean(this.currentValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notification.setSilent(isSilent);
        } else if ("NotificationCount".equalsIgnoreCase(localName)) {
            int count = 0;
            try {
                count = Integer.parseInt(this.currentValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notification.setBadge(count);
        } else if ("Category".equalsIgnoreCase(localName)) {
            this.notification.setCategory(this.currentValue);
        } else if ("Sound".equalsIgnoreCase(localName)) {
            this.notification.setSound(this.currentValue);
        } else if ("AttachmentID".equalsIgnoreCase(localName)) {
            this.notification.setAttachmentUID(this.currentValue);
        } else if ("NotificationContext".equalsIgnoreCase(localName)) {
            this.notification.setNotificationContext(this.currentValue);
        } else if ("id".equalsIgnoreCase(localName)) {
            this.notification.setActivationId(this.currentValue);
        } else if ("PushNotification".equalsIgnoreCase(localName) || "PushNotification".equalsIgnoreCase(localName)) {
            this.notificationsList.add(this.notification);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement.booleanValue()) {
            this.currentValue = this.currentValue + new String(ch, start, length);
        }
    }
}

