/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.parser;

import android.util.Log;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.InfoMessage;
import com.unvired.model.MobileUserSettings;
import com.unvired.model.SystemCredential;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServerAuthenticationResponseParser
extends DefaultHandler {
    private StringBuffer tempValue = new StringBuffer();
    private InfoMessage infoMessage;
    private boolean infoMessageTagStarted;
    private int messageType;
    private int messageSubType;
    private String serverId;
    private String applicationId;
    private Vector<SystemCredential> systemCredentialsVector = new Vector();
    private SystemCredential systemCredential = null;
    private boolean isSystemCredential;
    private boolean isFrameworkSettingsDataTag;
    private Hashtable<String, String> frameworkSettingsProperties;
    private Hashtable<String, String> appSettingsProperties;
    private Vector<MobileUserSettings> appUserSettingsProperties;
    private boolean isAppSettingsTag;
    private boolean isAppUserSettingsTag;
    private String tempSettingName;
    private MobileUserSettings tempMobileUserSettings;

    public ServerAuthenticationResponseParser(byte[] responseBytes, String serverId, int messageType, int messageSubType) throws ApplicationException {
        if (responseBytes == null) {
            Logger.log(8, this.getClass().getName(), "Constructor", "InputStream found as null.");
        }
        this.serverId = serverId;
        this.messageType = messageType;
        this.messageSubType = messageSubType;
        this.parse(responseBytes);
    }

    private void parse(byte[] responseBytes) throws ApplicationException {
        String s = new String(responseBytes);
        Log.v((String)"Response", (String)s);
        if (this.messageType == 9000 && this.messageSubType == 800) {
            this.frameworkSettingsProperties = new Hashtable();
            if (this.serverId != null) {
                this.frameworkSettingsProperties.put("ServerId", this.serverId);
            }
        } else if (this.messageType == 4000 && (this.messageSubType == 200 || this.messageSubType == 100 || this.messageSubType == 600)) {
            this.infoMessage = new InfoMessage();
        }
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = null;
        try {
            saxParser = saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.e("ParserConfigurationException caught while creating SAXParser object", parserConfigurationException);
            throw new ApplicationException(this.getClass().getName(), "parse", "ParserConfigurationException caught while creating SAXParser object, " + parserConfigurationException.getMessage());
        }
        catch (SAXException saxException) {
            Logger.e("SAXException caught while creating SAXParser object", saxException);
            throw new ApplicationException(this.getClass().getName(), "parse", "SAXException caught while creating SAXPArser object, " + saxException.getMessage());
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(responseBytes);
            saxParser.parse((InputStream)byteArrayInputStream, (DefaultHandler)this);
        }
        catch (SAXException saxException) {
            Logger.e("SAXException caught while parsing the message, ", saxException);
            throw new ApplicationException(this.getClass().getName(), "parse", "SAXException caught while parsing the message, " + saxException.getMessage());
        }
        catch (IOException ioException) {
            Logger.e("IOException caught while parsing the message, ", ioException);
            throw new ApplicationException(this.getClass().getName(), "parse", "IOException caught while parsing the message, " + ioException.getMessage());
        }
        catch (ClassCastException classCastException) {
            Logger.e("ClassCastException caught while parsing the message, ", classCastException);
        }
        catch (NullPointerException nullPointerException) {
            Logger.e("NullPointerException caught while parsing the message, ", nullPointerException);
            throw new ApplicationException(this.getClass().getName(), "parse", "NullPointerException caught while parsing the message, " + nullPointerException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            Logger.e("NumberFormatException caught while parsing the message, ", numberFormatException);
            throw new ApplicationException(this.getClass().getName(), "parser", "NumberFormatException caught while parsing the message, " + numberFormatException.getMessage());
        }
        catch (Exception exception) {
            Logger.e("Exception caught while parsing the message, ", exception);
            throw new ApplicationException(this.getClass().getName(), "parse", "Exception caught while parsing the message, " + exception.getMessage());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tempValue = new StringBuffer();
        if (this.messageType == 4000 && (this.messageSubType == 200 || this.messageSubType == 100 || this.messageSubType == 600)) {
            if ("InfoMessage".equalsIgnoreCase(localName)) {
                this.infoMessageTagStarted = true;
            }
        } else if (this.messageType == 9000 && this.messageSubType == 800) {
            if ("SYSTEM".equalsIgnoreCase(localName)) {
                this.systemCredential = new SystemCredential();
                this.isSystemCredential = true;
            } else if ("SYSTEMS".equalsIgnoreCase(localName)) {
                this.isSystemCredential = true;
            } else if ("data".equalsIgnoreCase(localName)) {
                String subType = attributes.getValue("subtype");
                if (String.valueOf(800).equalsIgnoreCase(subType)) {
                    this.isFrameworkSettingsDataTag = true;
                }
            } else if ("APPLICATION_SETTINGS".equalsIgnoreCase(localName)) {
                this.appSettingsProperties = new Hashtable();
                this.isAppSettingsTag = true;
            } else if ("APPLICATION_USER_SETTINGS".equalsIgnoreCase(localName)) {
                this.appUserSettingsProperties = new Vector();
                this.isAppUserSettingsTag = true;
            } else if ("SETTING".equalsIgnoreCase(localName)) {
                String keyName;
                if (this.isAppSettingsTag) {
                    String keyName2 = attributes.getValue("keyname");
                    if (keyName2 != null && keyName2.length() > 0) {
                        this.tempSettingName = keyName2;
                    }
                } else if (this.isAppUserSettingsTag && (keyName = attributes.getValue("keyname")) != null && keyName.length() > 0) {
                    this.tempMobileUserSettings = new MobileUserSettings();
                    this.tempMobileUserSettings.setFieldName(keyName);
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (ch != null) {
            this.tempValue.append(ch, start, length);
        } else {
            this.tempValue = new StringBuffer();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.messageType == 9000 && this.messageSubType == 800) {
            if ("ApplicationId".equalsIgnoreCase(localName)) {
                this.applicationId = this.tempValue.toString();
            } else if (this.isSystemCredential) {
                if ("SYSTEM".equalsIgnoreCase(localName)) {
                    this.systemCredentialsVector.addElement(this.systemCredential);
                } else if ("PORT_DESCR".equalsIgnoreCase(localName)) {
                    this.systemCredential.setPortDesc(this.tempValue.toString());
                } else if ("PORT_NAME".equalsIgnoreCase(localName)) {
                    this.systemCredential.setPortName(this.tempValue.toString());
                } else if ("PORT_TYPE".equalsIgnoreCase(localName)) {
                    this.systemCredential.setPortType(this.tempValue.toString());
                } else if ("SYSTEM_DESCR".equalsIgnoreCase(localName)) {
                    this.systemCredential.setSystemDesc(this.tempValue.toString());
                } else if ("SYSTEMS".equalsIgnoreCase(localName)) {
                    this.isSystemCredential = false;
                }
            } else if ("data".equalsIgnoreCase(localName)) {
                this.isFrameworkSettingsDataTag = false;
            } else if (this.isFrameworkSettingsDataTag) {
                this.frameworkSettingsProperties.put(localName, this.tempValue.toString());
            } else if (this.isAppSettingsTag) {
                if ("VALUE".equalsIgnoreCase(localName)) {
                    if (this.tempSettingName != null && this.tempSettingName.length() > 0) {
                        this.appSettingsProperties.put(this.tempSettingName, this.tempValue.toString());
                        this.tempSettingName = "";
                    }
                } else if ("APPLICATION_SETTINGS".equalsIgnoreCase(localName)) {
                    this.isAppSettingsTag = false;
                }
            } else if (this.isAppUserSettingsTag) {
                if ("DESCRIPTION".equalsIgnoreCase(localName)) {
                    this.tempMobileUserSettings.setFieldDescription(this.tempValue.toString());
                } else if ("DEFAULT".equalsIgnoreCase(localName)) {
                    this.tempMobileUserSettings.setDefault(this.tempValue.toString());
                } else if ("CURRENT".equalsIgnoreCase(localName)) {
                    this.tempMobileUserSettings.setCurrent(this.tempValue.toString());
                } else if ("MANDATORY".equalsIgnoreCase(localName)) {
                    if ("YES".equalsIgnoreCase(this.tempValue.toString())) {
                        this.tempMobileUserSettings.setMandatory(true);
                    } else {
                        this.tempMobileUserSettings.setMandatory(false);
                    }
                } else if ("SECURE".equalsIgnoreCase(localName)) {
                    if ("YES".equalsIgnoreCase(this.tempValue.toString())) {
                        this.tempMobileUserSettings.setSecure(true);
                    } else {
                        this.tempMobileUserSettings.setSecure(false);
                    }
                } else if ("SETTING".equalsIgnoreCase(localName)) {
                    this.appUserSettingsProperties.add(this.tempMobileUserSettings);
                    this.tempMobileUserSettings = null;
                } else if ("APPLICATION_USER_SETTINGS".equalsIgnoreCase(localName)) {
                    this.isAppUserSettingsTag = false;
                    this.tempMobileUserSettings = null;
                }
            }
        } else if (this.messageType == 4000 && (this.messageSubType == 200 || this.messageSubType == 100 || this.messageSubType == 600)) {
            if ("InfoMessage".equalsIgnoreCase(localName)) {
                this.infoMessageTagStarted = false;
            }
            if (this.infoMessageTagStarted) {
                if ("type".equalsIgnoreCase(localName)) {
                    this.infoMessage.setType(this.tempValue.toString());
                } else if ("subtype".equalsIgnoreCase(localName)) {
                    this.infoMessage.setSubType(this.tempValue.toString());
                } else if ("category".equalsIgnoreCase(localName)) {
                    this.infoMessage.setCategory(this.tempValue.toString());
                } else if ("message".equalsIgnoreCase(localName)) {
                    this.infoMessage.setMessage(this.tempValue.toString());
                }
            }
        }
    }

    public SystemCredential[] getSystemCredential() {
        SystemCredential[] systemCredentials = new SystemCredential[this.systemCredentialsVector.size()];
        for (int i = 0; i < systemCredentials.length; ++i) {
            systemCredentials[i] = this.systemCredentialsVector.elementAt(i);
        }
        return systemCredentials;
    }

    public Hashtable<String, String> getFrameworkSettings() {
        return this.frameworkSettingsProperties;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public InfoMessage getInfoMessage() {
        return this.infoMessage;
    }

    public Hashtable<String, String> getMobileAppSettings() {
        return this.appSettingsProperties;
    }

    public Vector<MobileUserSettings> getMobileAppUserSettings() {
        return this.appUserSettingsProperties;
    }
}

