/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.parser;

import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.ApplicationMeta;
import com.unvired.model.InfoMessage;
import com.unvired.utils.FrameworkHelper;
import java.io.ByteArrayInputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerAuthenticationUIDParser {
    private Document document;
    private ApplicationMeta applicationMeta;
    private Vector<String> frontendIds;
    private InfoMessage infoMessage;

    public ServerAuthenticationUIDParser(String metaDataXml) throws ApplicationException {
        try {
            this.document = FrameworkHelper.getDocumentRoot(new ByteArrayInputStream(metaDataXml.getBytes()));
        }
        catch (Exception applicationException) {
            Logger.e("ApplicationException caught while parsing meta data: ", applicationException);
            throw new ApplicationException(this.getClass().getName(), "Constructor", "ApplicationException caught while parsing meta data: " + applicationException.getMessage());
        }
        this.frontendIds = new Vector();
        this.parse();
    }

    public ApplicationMeta getApplicationMeta() {
        return this.applicationMeta;
    }

    private void parse() {
        NodeList frontendNodeList;
        Element objRoot = this.document.getDocumentElement();
        NodeList infoMessages = objRoot.getElementsByTagName("InfoMessage");
        if (infoMessages != null && infoMessages.getLength() > 0) {
            for (int i = 0; i < infoMessages.getLength(); ++i) {
                Node node = infoMessages.item(i);
                this.infoMessage = this.getInfoMessageFromNode(node);
            }
        }
        if ((frontendNodeList = objRoot.getElementsByTagName("FRONTEND")) != null) {
            int noOfFrontends = frontendNodeList.getLength();
            String currentFrontendDescription = null;
            for (int i = 0; i < noOfFrontends; ++i) {
                Node frontendNode = frontendNodeList.item(i);
                NodeList frontendChildNodes = frontendNode.getChildNodes();
                if (frontendChildNodes == null) continue;
                int noOfChildNodes = frontendChildNodes.getLength();
                for (int j = 0; j < noOfChildNodes; ++j) {
                    NodeList uidNodeList;
                    Node itemNode = frontendChildNodes.item(j);
                    if (itemNode == null) continue;
                    String nodeName = itemNode.getNodeName();
                    if ("FID_DESCRIPTION".equalsIgnoreCase(nodeName)) {
                        currentFrontendDescription = itemNode.getFirstChild().getTextContent();
                        continue;
                    }
                    if (!"UIDS".equalsIgnoreCase(nodeName) || (uidNodeList = itemNode.getChildNodes()) == null) continue;
                    int noOfUIDs = uidNodeList.getLength();
                    for (int k = 0; k < noOfUIDs; ++k) {
                        Node uidNode = uidNodeList.item(k);
                        String uidNodeName = uidNode.getNodeName();
                        if (!"UID".equalsIgnoreCase(uidNodeName)) continue;
                        String uid = uidNode.getFirstChild().getTextContent();
                        this.frontendIds.addElement(currentFrontendDescription + ": " + uid);
                    }
                }
            }
        }
    }

    private InfoMessage getInfoMessageFromNode(Node node) {
        InfoMessage info = new InfoMessage();
        String message = null;
        NodeList messageNodeList = ((Element)node).getElementsByTagName("message");
        if (messageNodeList != null && messageNodeList.getLength() > 0) {
            for (int i = 0; i < messageNodeList.getLength(); ++i) {
                Node messageNode = messageNodeList.item(i);
                message = messageNode.getFirstChild().getTextContent();
            }
        } else {
            message = "";
        }
        info.setMessage(message);
        return info;
    }

    public Vector<String> getFrontendIds() {
        return this.frontendIds;
    }

    public InfoMessage getInfoMessage() {
        return this.infoMessage;
    }
}

