/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.RuntimeEngine;
import com.unvired.database.DBException;
import com.unvired.database.DataStructureTableMapping;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentItem;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.InfoMessage;
import com.unvired.model.JSAttachmentItem;
import com.unvired.model.JSDataStructure;
import com.unvired.model.StructureMeta;
import com.unvired.sync.SyncConstants;
import com.unvired.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class UBJSONParser {
    private Vector<String> metaData = new Vector();
    private Hashtable<String, Hashtable<IDataStructure, Vector<IDataStructure>>> besHashTable = new Hashtable();
    private Hashtable<IDataStructure, Vector<IDataStructure>> currentBE = null;
    private Vector<InfoMessage> infoMessages = new Vector();
    private IDataManager applicationDataManager;
    private SyncConstants.MESSAGE_REQUEST_TYPE requestType;
    protected Hashtable<String, IDataStructure> beHeaderMap;
    protected Hashtable<String, IDataStructure> beItemMap;
    private Vector<IDataStructure> currentItems = null;
    SyncConstants.BE_ACTION_TYPE currentBEAction;
    private DataStructureTableMapping dataStructureTableMapping;

    public UBJSONParser(byte[] data, SyncConstants.MESSAGE_REQUEST_TYPE reqType) throws ApplicationException, DBException {
        if (reqType != null) {
            this.requestType = reqType;
        }
        if (data != null) {
            this.applicationDataManager = ApplicationManager.getInstance().getDataManager();
            this.dataStructureTableMapping = DataStructureTableMapping.getInstance();
            FrameworkManager.getInstance().getDataManager();
            this.parseDocument(data);
        }
    }

    private void parseDocument(byte[] data) throws ApplicationException, DBException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonFactory jFactory = mapper.getFactory();
            JsonParser jParser = jFactory.createParser(data);
            while (jParser.nextToken() != null) {
                String fieldName = jParser.getCurrentName();
                if (fieldName == null) continue;
                if ("Meta".equals(fieldName)) {
                    jParser.nextToken();
                    JsonNode metaDataNode = (JsonNode)jParser.readValueAsTree();
                    if (metaDataNode != null) {
                        JsonNode beMeta = metaDataNode.get("BEName");
                        Iterator elements = beMeta.elements();
                        while (elements.hasNext()) {
                            JsonNode node = (JsonNode)elements.next();
                            this.metaData.add(node.asText());
                        }
                    }
                    if (SyncConstants.MESSAGE_REQUEST_TYPE.PULL != this.requestType || metaDataNode == null) continue;
                    String deletionRequiredFlag = metaDataNode.get("d").asText();
                    this.beHeaderMap = new Hashtable();
                    this.beItemMap = new Hashtable();
                    ArrayList<String> beHeaderNames = new ArrayList<String>();
                    if ("true".equalsIgnoreCase(deletionRequiredFlag)) {
                        for (String beName : this.metaData) {
                            try {
                                StructureMeta structureMeta;
                                String conflictRule = "SERVER_WINS";
                                BusinessEntityMeta businessEntityMeta = ApplicationManager.getInstance().getBusinessEntityMeta(beName);
                                if (businessEntityMeta != null && !"SERVER_WINS".equals(businessEntityMeta.getConflictRule())) {
                                    conflictRule = businessEntityMeta.getConflictRule();
                                }
                                if ((structureMeta = ApplicationManager.getInstance().getHeaderStructureMeta(beName)) == null) continue;
                                String beHeaderName = structureMeta.getStructName();
                                beHeaderNames.add(beHeaderName);
                                Logger.i("Deleting concerned records of Business Entity : " + beHeaderName);
                                this.deleteBE(beHeaderName, conflictRule);
                                Logger.i("Deletion completed. Business Entity : " + beHeaderName);
                            }
                            catch (DBException e) {
                                Logger.log(8, this.getClass().getName(), "parseDocument", "DBException caught while deleting be which are not part of pull message, or Adding to cache. " + e.getMessage());
                            }
                            catch (Exception e) {
                                Logger.log(8, this.getClass().getName(), "parseDocument", "Exception caught while deleting be which are not part of pull message, or Adding to cache." + e.getMessage());
                            }
                        }
                    }
                    for (String beHeaderName : beHeaderNames) {
                        try {
                            Logger.i("Get Records for Business Entity Header : " + beHeaderName);
                            IDataStructure[] iDataStructures = this.applicationDataManager.get(beHeaderName);
                            if (iDataStructures == null) continue;
                            for (IDataStructure dataStructure : iDataStructures) {
                                this.beHeaderMap.put(this.getGID(dataStructure), dataStructure);
                                Logger.i("Get All Items for header: " + beHeaderName);
                                Hashtable<String, IDataStructure[]> allChildren = this.applicationDataManager.getAllChildren(dataStructure);
                                if (allChildren == null || allChildren.isEmpty()) continue;
                                Collection<IDataStructure[]> allChildrenStructures = allChildren.values();
                                for (IDataStructure[] structures : allChildrenStructures) {
                                    if (structures == null || structures.length == 0) continue;
                                    for (IDataStructure child : structures) {
                                        this.beItemMap.put(this.getGID(child), child);
                                    }
                                }
                            }
                        }
                        catch (DBException e) {
                            Logger.log(8, this.getClass().getName(), "parseDocument", "DBException caught while deleting be which are not part of pull message, or Adding to cache. " + e.getMessage());
                        }
                        catch (Exception e) {
                            Logger.log(8, this.getClass().getName(), "parseDocument", "Exception caught while deleting be which are not part of pull message, or Adding to cache." + e.getMessage());
                        }
                    }
                    continue;
                }
                if ("InfoMessage".equals(fieldName)) {
                    jParser.nextToken();
                    JsonNode infoMessageNodes = (JsonNode)jParser.readValueAsTree();
                    Iterator infoMessageNodesElements = infoMessageNodes.elements();
                    InfoMessage infoMessage = null;
                    while (infoMessageNodesElements.hasNext()) {
                        JsonNode infoMsgNode = (JsonNode)infoMessageNodesElements.next();
                        infoMessage = new InfoMessage();
                        if (infoMsgNode.has("type")) {
                            infoMessage.setType(infoMsgNode.get("type").asText());
                        }
                        if (infoMsgNode.has("subtype")) {
                            infoMessage.setSubType(infoMsgNode.get("subtype").asText());
                        }
                        if (infoMsgNode.has("message")) {
                            infoMessage.setMessage(infoMsgNode.get("message").asText());
                        }
                        if (infoMsgNode.has("category")) {
                            infoMessage.setCategory(infoMsgNode.get("category").asText());
                        }
                        this.infoMessages.add(infoMessage);
                    }
                    continue;
                }
                if (jParser.nextToken() == JsonToken.END_ARRAY) continue;
                JsonNode businessEntity = (JsonNode)jParser.readValueAsTree();
                this.ParseSelectedBusinessEntity(businessEntity, fieldName);
            }
        }
        catch (JsonProcessingException e) {
            Logger.log(8, this.getClass().getName(), "parseDocument", "JsonProcessingException caught while creating JSONNode object, " + e.getMessage());
            throw new ApplicationException(this.getClass().getName(), "parseDocument", "JsonProcessingException caught while creating JSONNode object, " + e.getMessage());
        }
        catch (IOException e) {
            Logger.log(8, this.getClass().getName(), "parseDocument", "IOException caught while creating JSONNode object, " + e.getMessage());
            throw new ApplicationException(this.getClass().getName(), "parseDocument", "IOException caught while creating JSONNode object, " + e.getMessage());
        }
        catch (Exception exception) {
            Logger.log(8, this.getClass().getName(), "parseDocument", "Exception: " + exception.toString());
            throw new ApplicationException(this.getClass().getName(), "parseDocument", "IOException caught while creating JSONNode object, " + exception.getMessage());
        }
    }

    private void ParseSelectedBusinessEntity(JsonNode bes, String beName) {
        this.currentBE = new Hashtable();
        IDataStructure headerDataStructure = null;
        for (int i = 0; i < bes.size(); ++i) {
            try {
                this.currentItems = new Vector();
                JsonNode be = bes.get(i);
                Iterator nodeIterator = be.fields();
                while (nodeIterator.hasNext()) {
                    JsonNode items;
                    Map.Entry entry = (Map.Entry)nodeIterator.next();
                    String key = (String)entry.getKey();
                    if (((JsonNode)entry.getValue()).isObject()) {
                        String headerName = key;
                        JsonNode header = be.get(key);
                        String headerClass = this.dataStructureTableMapping.getClassName(headerName);
                        if (headerClass != null) {
                            headerDataStructure = RuntimeEngine.getInstance().isHTML5Framework() ? new JSDataStructure(headerName, true) : (IDataStructure)Class.forName(headerClass).newInstance();
                        } else {
                            if (Logger.getDefaultLogLevel() != 9) continue;
                            Logger.log(9, this.getClass().getName(), "startElement", "Header not found. Ignoring: " + headerName);
                            continue;
                        }
                        Iterator fieldsNodeIterator = header.fields();
                        while (fieldsNodeIterator.hasNext()) {
                            Map.Entry fieldEntry = (Map.Entry)fieldsNodeIterator.next();
                            if (fieldEntry == null || fieldEntry.getKey() == null || fieldEntry.getValue() == null) continue;
                            headerDataStructure.setFieldBasedOnDataType((String)fieldEntry.getKey(), ((JsonNode)fieldEntry.getValue()).asText());
                        }
                        IDataStructure headerInDatabase = SyncConstants.MESSAGE_REQUEST_TYPE.PULL == this.requestType ? this.beHeaderMap.get(this.getGID(headerDataStructure)) : this.applicationDataManager.checkDuplicateGID(headerDataStructure);
                        String currentBEActionString = be.get("a").asText();
                        if (currentBEActionString != null && currentBEActionString.length() > 0) {
                            try {
                                this.currentBEAction = SyncConstants.BE_ACTION_TYPE.valueOf(currentBEActionString);
                            }
                            catch (IllegalArgumentException e) {
                                this.currentBEAction = SyncConstants.BE_ACTION_TYPE.A;
                            }
                        }
                        if (headerInDatabase != null && this.currentBEAction == SyncConstants.BE_ACTION_TYPE.D) {
                            this.applicationDataManager.delete(headerInDatabase);
                            return;
                        }
                        if (headerInDatabase == null) continue;
                        headerDataStructure.setLid(headerInDatabase.getLid());
                        continue;
                    }
                    if (!((JsonNode)entry.getValue()).isArray() || (items = be.get(key)) == null) continue;
                    Iterator itemElements = items.elements();
                    while (itemElements.hasNext()) {
                        JsonNode item = (JsonNode)itemElements.next();
                        IDataStructure itemDataStructure = this.getItemDataStructureFromJson(item, key);
                        IDataStructure itemInDatabase = SyncConstants.MESSAGE_REQUEST_TYPE.PULL == this.requestType ? this.beItemMap.get(this.getGID(itemDataStructure)) : this.applicationDataManager.checkDuplicateGID(itemDataStructure);
                        if (itemInDatabase != null) {
                            itemDataStructure.setLid(itemInDatabase.getLid());
                        }
                        itemDataStructure.setFid(headerDataStructure.getLid());
                        this.currentItems.add(itemDataStructure);
                    }
                }
            }
            catch (Exception e) {
                Logger.log(8, this.getClass().getSimpleName(), "ParseSelectedBusinessEntity", "Error while parsing BusinessEntity from JsonNode." + beName + ".Message: " + e.getMessage());
                continue;
            }
            if (headerDataStructure == null) continue;
            this.currentBE.put(headerDataStructure, this.currentItems);
        }
        this.besHashTable.put(beName, this.currentBE);
    }

    private IDataStructure getItemDataStructureFromJson(JsonNode item, String itemName) {
        IDataStructure itemDataStructure = null;
        try {
            String headerClass = this.dataStructureTableMapping.getClassName(itemName);
            if (headerClass != null) {
                itemDataStructure = RuntimeEngine.getInstance().isHTML5Framework() ? (itemName.toLowerCase().endsWith("_attachment") ? new JSAttachmentItem(itemName) : new JSDataStructure(itemName, false)) : (itemName.toLowerCase().endsWith("_attachment") ? new AttachmentItem(itemName) : (IDataStructure)Class.forName(headerClass).newInstance());
            } else {
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.log(9, this.getClass().getName(), "startElement", "Header not found. Ignoring: " + itemName);
                }
                return null;
            }
            Iterator nodeIterator = item.fields();
            while (nodeIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)nodeIterator.next();
                if (entry.getKey() == null || entry.getValue() == null) continue;
                itemDataStructure.setFieldBasedOnDataType((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
        }
        catch (Exception e) {
            Logger.e("Error while creating item DataStructure from JsonNode : " + itemName + "." + e.getMessage());
        }
        return itemDataStructure;
    }

    private void deleteBEsIfNoIncomingBEFromServer(String beName) {
        try {
            StructureMeta headerStructureMeta = ApplicationManager.getInstance().getHeaderStructureMeta(beName);
            if (headerStructureMeta == null) {
                return;
            }
            String statusInCondition = "OBJECT_STATUS IN ('" + IDataStructure.OBJECT_STATUS.GLOBAL.ordinal() + "'" + ")";
            this.applicationDataManager.delete(headerStructureMeta.getTableName(), statusInCondition);
        }
        catch (Exception ex) {
            Logger.log(8, this.getClass().getName(), "deleteBEsIfNoIncomingBEFromServer", "Unable to delete BE.Message : " + ex.getMessage());
        }
    }

    public Vector<String> getMetaData() {
        return this.metaData;
    }

    public Hashtable<String, Hashtable<IDataStructure, Vector<IDataStructure>>> getData() {
        return this.besHashTable;
    }

    public Vector<InfoMessage> getInfoMessages() {
        return this.infoMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteBE(String beHeaderName, String conflictRule) throws DBException {
        String query = null;
        query = "SERVER_WINS".equals(conflictRule) ? "DELETE FROM " + beHeaderName : "DELETE FROM " + beHeaderName + " WHERE OBJECT_STATUS = '" + IDataStructure.OBJECT_STATUS.GLOBAL.ordinal() + "'";
        String savePointName = Utils.getSavePointName();
        this.applicationDataManager.createSavepoint(savePointName);
        try {
            this.applicationDataManager.execute(query);
        }
        catch (Exception e) {
            String error = "Exception while processing sent item. Deletion BEName: " + beHeaderName + " Exception: " + e.getMessage();
            Logger.e(error, e);
            this.applicationDataManager.rollbackToSavepoint(savePointName);
        }
        finally {
            this.applicationDataManager.releaseSavepoint(savePointName);
        }
    }

    private String getGID(IDataStructure dataStructure) {
        String gid = dataStructure.getBEName();
        Object[] gidFields = new Object[]{};
        try {
            gidFields = dataStructure.getGids();
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        for (Object gField : gidFields) {
            gid = gid + String.valueOf(gField) + "~";
        }
        return gid;
    }
}

