/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.parser;

import com.unvired.core.ApplicationManager;
import com.unvired.core.RuntimeEngine;
import com.unvired.database.DBException;
import com.unvired.database.DataStructureTableMapping;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.exception.MissingFieldException;
import com.unvired.exception.MissingFieldTypeException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentItem;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.InfoMessage;
import com.unvired.model.JSAttachmentItem;
import com.unvired.model.JSDataStructure;
import com.unvired.model.StructureMeta;
import com.unvired.sync.SyncConstants;
import com.unvired.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UBXMLParser
extends DefaultHandler {
    private StringBuffer tempValue = new StringBuffer();
    private Vector<String> metaData = new Vector();
    private Hashtable<String, Hashtable<IDataStructure, Vector<IDataStructure>>> bes = new Hashtable();
    private Hashtable<IDataStructure, Vector<IDataStructure>> currentBE = null;
    private IDataStructure currentHeader = null;
    private IDataStructure currentItem = null;
    private String currentBEName;
    private String currentHeaderName;
    private String currentItemName;
    private String currentFieldName;
    private boolean headerInProcess = true;
    private Vector<InfoMessage> infoMessages = new Vector();
    private InfoMessage currentInfoMessage;
    private boolean infoMessageTagStarted = false;
    private IDataManager applicationDataManager;
    private SyncConstants.MESSAGE_REQUEST_TYPE requestType;
    private boolean metaDataDeleteFlag = false;
    protected Hashtable<String, IDataStructure> beHeaderMap;
    protected Hashtable<String, IDataStructure> beItemMap;
    private ApplicationManager applicationManager = ApplicationManager.getInstance();

    public UBXMLParser(byte[] data, SyncConstants.MESSAGE_REQUEST_TYPE reqType) throws ApplicationException, DBException {
        if (reqType != null) {
            this.requestType = reqType;
        }
        if (data != null) {
            this.parseDocument(data);
        }
    }

    private void parseDocument(byte[] data) throws ApplicationException, DBException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            this.applicationDataManager = ApplicationManager.getInstance().getDataManager();
            SAXParser sp = spf.newSAXParser();
            sp.parse((InputStream)new ByteArrayInputStream(data), (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            String error = "Parser Configuration Exception while parsing UBXML: " + e.getMessage();
            Logger.e(error, e);
            throw new ApplicationException(this.getClass().getName(), "parseDocument", error);
        }
        catch (SAXException e) {
            String error = "SAX Exception while parsing UBXML: " + e.getMessage();
            Logger.e(error, e);
            throw new ApplicationException(this.getClass().getName(), "parseDocument", error);
        }
        catch (IOException e) {
            String error = "IO Exception while parsing UBXML: " + e.getMessage();
            Logger.e(error, e);
            throw new ApplicationException(this.getClass().getName(), "parseDocument", error);
        }
        catch (DBException e) {
            String error = "DB Exception while parsing UBXML: " + e.getMessage();
            Logger.e(error, e);
            throw new DBException(this.getClass().getName(), "parseDocument", error);
        }
        catch (Exception e) {
            String error = "Exception while parsing UBXML: " + e.getMessage();
            Logger.log(8, this.getClass().getName(), "parseDocument", error);
            throw new ApplicationException(this.getClass().getName(), "parseDocument", error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tempValue = new StringBuffer();
        if ("Root".equalsIgnoreCase(localName)) {
            String requestTypeString;
            if (attributes == null || (requestTypeString = attributes.getValue("requestType")) == null) return;
            this.requestType = SyncConstants.MESSAGE_REQUEST_TYPE.valueOf(requestTypeString);
            return;
        } else if ("Meta".equalsIgnoreCase(localName)) {
            String deletionRequiredFlag;
            if (SyncConstants.MESSAGE_REQUEST_TYPE.PULL != this.requestType) return;
            this.beHeaderMap = new Hashtable();
            this.beItemMap = new Hashtable();
            if (attributes == null || !"true".equalsIgnoreCase(deletionRequiredFlag = attributes.getValue("d"))) return;
            this.metaDataDeleteFlag = true;
            return;
        } else if ("BE".equalsIgnoreCase(localName)) {
            this.currentBEName = attributes.getValue("n");
            if (this.currentBEName == null) return;
            this.currentBE = this.bes.get(this.currentBEName);
            if (this.currentBE == null) {
                this.currentBE = new Hashtable();
                this.bes.put(this.currentBEName, this.currentBE);
            }
            this.currentHeader = null;
            this.currentItem = null;
            this.currentHeaderName = null;
            this.currentItemName = null;
            this.currentFieldName = null;
            return;
        } else if ("H".equalsIgnoreCase(localName)) {
            this.currentHeaderName = attributes.getValue("n");
            String headerClass = DataStructureTableMapping.getInstance().getClassName(this.currentHeaderName);
            this.headerInProcess = true;
            try {
                if (headerClass != null) {
                    this.currentHeader = RuntimeEngine.getInstance().isHTML5Framework() ? new JSDataStructure(this.currentHeaderName, true) : (IDataStructure)Class.forName(headerClass).newInstance();
                    this.currentBE.put(this.currentHeader, new Vector());
                    return;
                }
                if (Logger.getDefaultLogLevel() != 9) return;
                Logger.log(9, this.getClass().getName(), "startElement", "Header not found. Ignoring: " + this.currentHeaderName);
                return;
            }
            catch (InstantiationException e) {
                String error = "Instantiation exception. Class: " + headerClass + " " + e.getMessage();
                Logger.e(error, e);
                throw new SAXException(error);
            }
            catch (IllegalAccessException e) {
                String error = "Illegal Access exception. Class: " + headerClass + " " + e.getMessage();
                Logger.e(error, e);
                throw new SAXException(error);
            }
            catch (ClassNotFoundException e) {
                String error = "Class Not Found exception. Class: " + headerClass + " " + e.getMessage();
                Logger.e(error, e);
                throw new SAXException(error);
            }
            catch (Exception e) {
                String error = "Exception. Class: " + headerClass + " " + e.getMessage();
                Logger.e(error, e);
                throw new SAXException(error);
            }
        } else if ("I".equalsIgnoreCase(localName)) {
            this.currentItemName = attributes.getValue("n");
            String itemClass = DataStructureTableMapping.getInstance().getClassName(this.currentItemName);
            this.headerInProcess = false;
            try {
                if (itemClass != null) {
                    this.currentItem = RuntimeEngine.getInstance().isHTML5Framework() ? (this.currentItemName.toLowerCase().endsWith("_attachment") ? new JSAttachmentItem(this.currentItemName) : new JSDataStructure(this.currentItemName, false)) : (this.currentItemName.toLowerCase().endsWith("_attachment") ? new AttachmentItem(this.currentItemName) : (IDataStructure)Class.forName(itemClass).newInstance());
                    Vector<IDataStructure> itemVector = this.currentBE.get(this.currentHeader);
                    itemVector.addElement(this.currentItem);
                    return;
                }
                if (Logger.getDefaultLogLevel() != 9) return;
                Logger.log(9, this.getClass().getName(), "startElement", "Item not found. Ignoring: " + this.currentItemName);
                return;
            }
            catch (InstantiationException e) {
                String error = "Instantiation exception. Class: " + itemClass + " " + e.getMessage();
                Logger.e(error, e);
                throw new SAXException(error);
            }
            catch (IllegalAccessException e) {
                String error = "Illegal Access exception. Class: " + itemClass + " " + e.getMessage();
                Logger.e(error, e);
                throw new SAXException(error);
            }
            catch (ClassNotFoundException e) {
                String error = "Class Not Found exception. Class: " + itemClass + " " + e.getMessage();
                Logger.e(error, e);
                throw new SAXException(error);
            }
            catch (Exception e) {
                String error = "Exception. Class: " + itemClass + " " + e.getMessage();
                Logger.e(error, e);
                throw new SAXException(error);
            }
        } else if ("F".equalsIgnoreCase(localName)) {
            this.currentFieldName = attributes.getValue("n");
            return;
        } else {
            if (!"InfoMessage".equalsIgnoreCase(localName)) return;
            this.infoMessageTagStarted = true;
            this.currentInfoMessage = new InfoMessage();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (ch != null) {
            this.tempValue.append(ch, start, length);
        } else {
            this.tempValue = new StringBuffer();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("BEName".equalsIgnoreCase(localName)) {
            this.metaData.addElement(this.tempValue.toString());
            this.currentBEName = this.tempValue.toString();
            if (SyncConstants.MESSAGE_REQUEST_TYPE.PULL != this.requestType) return;
            try {
                StructureMeta headerStructureMeta = this.applicationManager.getHeaderStructureMeta(this.currentBEName);
                if (headerStructureMeta == null) return;
                String beHeaderName = headerStructureMeta.getStructName();
                if (this.metaDataDeleteFlag) {
                    String conflictRule = "SERVER_WINS";
                    BusinessEntityMeta businessEntityMeta = ApplicationManager.getInstance().getBusinessEntityMeta(this.currentBEName);
                    if (businessEntityMeta != null && !"SERVER_WINS".equals(businessEntityMeta.getConflictRule())) {
                        conflictRule = businessEntityMeta.getConflictRule();
                    }
                    Logger.i("Deleting concerned records of Business Entity : " + beHeaderName);
                    this.deleteBE(beHeaderName, conflictRule);
                    Logger.i("Deletion completed. Business Entity : " + beHeaderName);
                }
                Logger.i("Get Records for Business Entity Header : " + beHeaderName);
                IDataStructure[] iDataStructures = this.applicationDataManager.get(headerStructureMeta.getStructName());
                if (iDataStructures == null) return;
                for (IDataStructure dataStructure : iDataStructures) {
                    this.beHeaderMap.put(this.getGID(dataStructure), dataStructure);
                    Logger.i("Get All Items for header: " + beHeaderName);
                    Hashtable<String, IDataStructure[]> allChildren = this.applicationDataManager.getAllChildren(dataStructure);
                    if (allChildren == null || allChildren.isEmpty()) continue;
                    Collection<IDataStructure[]> allChildrenStructures = allChildren.values();
                    for (IDataStructure[] structures : allChildrenStructures) {
                        if (structures == null || structures.length == 0) continue;
                        for (IDataStructure child : structures) {
                            this.beItemMap.put(this.getGID(child), child);
                        }
                    }
                }
                return;
            }
            catch (DBException e) {
                String error = "Database exception while getting header structure meta for BE:" + this.currentBEName + ". Exception: " + e.getMessage();
                throw new SAXException(new Exception(error));
            }
            catch (Exception exception) {
                Logger.log(8, this.getClass().getName(), "endElement", "ApplicationException caught while deleteing be which are not part of pull message, " + exception.getMessage());
                return;
            }
        }
        if ("BE".equalsIgnoreCase(localName)) return;
        if ("H".equalsIgnoreCase(localName)) {
            try {
                if (this.currentHeader != null) {
                    IDataStructure headerInDatabase = null;
                    headerInDatabase = SyncConstants.MESSAGE_REQUEST_TYPE.PULL == this.requestType ? this.beHeaderMap.get(this.getGID(this.currentHeader)) : this.applicationDataManager.checkDuplicateGID(this.currentHeader);
                    if (headerInDatabase == null) return;
                    this.currentHeader.setLid(headerInDatabase.getLid());
                    return;
                }
                if (Logger.getDefaultLogLevel() != 9) return;
                Logger.log(9, this.getClass().getName(), "endElement", "Header object is null. So ignoring end header tag.");
                return;
            }
            catch (DBException e) {
                String error = "DBException while checking the data in the database: " + e.getMessage();
                Logger.e(error, e);
                throw new SAXException(error);
            }
        }
        if ("I".equalsIgnoreCase(localName)) {
            try {
                if (this.currentItem != null) {
                    IDataStructure itemInDatabase = null;
                    itemInDatabase = SyncConstants.MESSAGE_REQUEST_TYPE.PULL == this.requestType ? this.beItemMap.get(this.getGID(this.currentItem)) : this.applicationDataManager.checkDuplicateGID(this.currentItem);
                    if (itemInDatabase != null) {
                        this.currentItem.setLid(itemInDatabase.getLid());
                    }
                } else if (Logger.getDefaultLogLevel() == 9) {
                    Logger.log(9, this.getClass().getName(), "endElement", "Item object is null. So ignoring end item tag.");
                }
            }
            catch (DBException e) {
                String error = "DBException while checking the data in the database: " + e.getMessage();
                Logger.e(error, e);
                throw new SAXException(error);
            }
            if (this.currentItem == null) return;
            this.currentItem.setFid(this.currentHeader.getLid());
            this.currentItem = null;
            this.currentItemName = null;
            return;
        }
        if ("F".equalsIgnoreCase(localName)) {
            if (this.currentFieldName != null) {
                if (this.headerInProcess) {
                    if (this.currentHeader != null) {
                        try {
                            this.setFieldBasedOnDataType(this.currentHeader, this.currentHeaderName, this.currentFieldName, this.tempValue.toString());
                        }
                        catch (ApplicationException e) {
                            String error = "ApplicationException exception. Class:  " + e.getMessage();
                            Logger.e(error, e);
                            throw new SAXException(error);
                        }
                    } else if (Logger.getDefaultLogLevel() == 9) {
                        Logger.log(9, this.getClass().getName(), "endElement", "Header object is null. So ignoring field: " + this.currentFieldName);
                    }
                } else if (this.currentItem != null) {
                    try {
                        this.setFieldBasedOnDataType(this.currentItem, this.currentItemName, this.currentFieldName, this.tempValue.toString());
                    }
                    catch (ApplicationException e) {
                        String error = "ApplicationException exception. Class:  " + e.getMessage();
                        Logger.e(error, e);
                        throw new SAXException(error);
                    }
                } else if (Logger.getDefaultLogLevel() == 9) {
                    Logger.log(9, this.getClass().getName(), "endElement", "Item object is null. So ignoring field: " + this.currentFieldName);
                }
            }
            this.currentFieldName = null;
            return;
        } else {
            if ("Root".equalsIgnoreCase(localName)) return;
            if ("InfoMessage".equalsIgnoreCase(localName)) {
                this.infoMessages.addElement(this.currentInfoMessage);
                this.infoMessageTagStarted = false;
                this.currentInfoMessage = null;
                return;
            } else {
                if (!this.infoMessageTagStarted) return;
                if ("type".equalsIgnoreCase(localName)) {
                    this.currentInfoMessage.setType(this.tempValue.toString());
                    return;
                } else if ("subtype".equalsIgnoreCase(localName)) {
                    this.currentInfoMessage.setSubType(this.tempValue.toString());
                    return;
                } else if ("category".equalsIgnoreCase(localName)) {
                    this.currentInfoMessage.setCategory(this.tempValue.toString());
                    return;
                } else {
                    if (!"message".equalsIgnoreCase(localName)) return;
                    this.currentInfoMessage.setMessage(this.tempValue.toString());
                }
            }
        }
    }

    private void setFieldBasedOnDataType(IDataStructure dataStructure, String structureName, String fieldName, String fieldValue) throws ApplicationException {
        try {
            dataStructure.setFieldBasedOnDataType(fieldName, fieldValue);
        }
        catch (MissingFieldException e) {
            Logger.e("MissingFieldException exception. Class: " + structureName + " Field :" + fieldName + " Value: " + fieldName, e);
            throw new ApplicationException(this.getClass().getName(), "setFieldBasedOnDataType", "MissingFieldException exception. Class:  " + e.getMessage());
        }
        catch (MissingFieldTypeException e) {
            Logger.e("MissingFieldTypeException exception. Class: " + structureName + " Field :" + fieldName + " Value: " + fieldName, e);
            throw new ApplicationException(this.getClass().getName(), "setFieldBasedOnDataType", "MissingFieldTypeException exception. Class:  " + e.getMessage());
        }
    }

    public Vector<String> getMetaData() {
        return this.metaData;
    }

    public Hashtable<String, Hashtable<IDataStructure, Vector<IDataStructure>>> getData() {
        return this.bes;
    }

    public Vector<InfoMessage> getInfoMessages() {
        return this.infoMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteBE(String beHeaderName, String conflictRule) throws DBException {
        String query = null;
        query = "SERVER_WINS".equals(conflictRule) ? "DELETE FROM " + beHeaderName : "DELETE FROM " + beHeaderName + " WHERE OBJECT_STATUS = '" + IDataStructure.OBJECT_STATUS.GLOBAL.ordinal() + "'";
        String savePointName = Utils.getSavePointName();
        this.applicationDataManager.createSavepoint(savePointName);
        try {
            this.applicationDataManager.execute(query);
        }
        catch (Exception e) {
            String error = "Exception while processing sent item. Deletion BEName: " + beHeaderName + " Exception: " + e.getMessage();
            Logger.e(error, e);
            this.applicationDataManager.rollbackToSavepoint(savePointName);
        }
        finally {
            this.applicationDataManager.releaseSavepoint(savePointName);
        }
    }

    private String getGID(IDataStructure dataStructure) {
        String gid = dataStructure.getBEName();
        Object[] gidFields = new Object[]{};
        try {
            gidFields = dataStructure.getGids();
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        for (Object gField : gidFields) {
            gid = gid + String.valueOf(gField) + "~";
        }
        return gid;
    }
}

