/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.security;

import com.unvired.exception.ApplicationException;
import com.unvired.security.Base32;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class PasscodeGenerator {
    private static final int PASS_CODE_LENGTH = 6;
    static final int INTERVAL = 30;
    private static final int ADJACENT_INTERVALS = 5;
    private static final int PIN_MODULO = (int)Math.pow(10.0, 6.0);
    private final Signer signer;
    private final int codeLength;
    private final int intervalPeriod;
    private IntervalClock clock = new IntervalClock(){

        @Override
        public long getCurrentInterval() {
            long currentTimeSeconds = System.currentTimeMillis() / 1000L;
            return currentTimeSeconds / (long)this.getIntervalPeriod();
        }

        @Override
        public int getIntervalPeriod() {
            return PasscodeGenerator.this.intervalPeriod;
        }
    };

    public PasscodeGenerator(Mac mac) {
        this(mac, 6, 30);
    }

    public PasscodeGenerator(final Mac mac, int passCodeLength, int interval) {
        this(new Signer(){

            @Override
            public byte[] sign(byte[] data) {
                return mac.doFinal(data);
            }
        }, passCodeLength, interval);
    }

    public PasscodeGenerator(Signer signer, int passCodeLength, int interval) {
        this.signer = signer;
        this.codeLength = passCodeLength;
        this.intervalPeriod = interval;
    }

    private String padOutput(int value) {
        String result = Integer.toString(value);
        for (int i = result.length(); i < this.codeLength; ++i) {
            result = "0" + result;
        }
        return result;
    }

    public String generateTimeoutCode() throws GeneralSecurityException {
        return this.generateResponseCode(this.clock.getCurrentInterval());
    }

    public String generateResponseCode(long challenge) throws GeneralSecurityException {
        byte[] value = ByteBuffer.allocate(8).putLong(challenge).array();
        return this.generateResponseCode(value);
    }

    public String generateResponseCode(byte[] challenge) throws GeneralSecurityException {
        byte[] hash = this.signer.sign(challenge);
        int offset = hash[hash.length - 1] & 0xF;
        int truncatedHash = this.hashToInt(hash, offset) & Integer.MAX_VALUE;
        int pinValue = truncatedHash % PIN_MODULO;
        return this.padOutput(pinValue);
    }

    private int hashToInt(byte[] bytes, int start) {
        int val;
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes, start, bytes.length - start));
        try {
            val = input.readInt();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return val;
    }

    public boolean verifyResponseCode(long challenge, String response) throws GeneralSecurityException {
        String expectedResponse = this.generateResponseCode(challenge);
        return expectedResponse.equals(response);
    }

    public boolean verifyTimeoutCode(String timeoutCode) throws GeneralSecurityException {
        return this.verifyTimeoutCode(timeoutCode, 5, 5);
    }

    public boolean verifyTimeoutCode(String timeoutCode, int pastIntervals, int futureIntervals) throws GeneralSecurityException {
        int i;
        long currentInterval = this.clock.getCurrentInterval();
        String expectedResponse = this.generateResponseCode(currentInterval);
        if (expectedResponse.equals(timeoutCode)) {
            return true;
        }
        for (i = 1; i <= pastIntervals; ++i) {
            String pastResponse = this.generateResponseCode(currentInterval - (long)i);
            if (!pastResponse.equals(timeoutCode)) continue;
            return true;
        }
        for (i = 1; i <= futureIntervals; ++i) {
            String futureResponse = this.generateResponseCode(currentInterval + (long)i);
            if (!futureResponse.equals(timeoutCode)) continue;
            return true;
        }
        return false;
    }

    public static String[] computePin(String secret, String feUserId) throws ApplicationException {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (secret == null || secret.length() == 0) {
            String format = formatter.format(cal.getTime());
            return new String[]{format};
        }
        try {
            byte[] keyBytes = Base32.decode(secret);
            Mac mac = Mac.getInstance("HMACSHA1");
            mac.init(new SecretKeySpec(keyBytes, ""));
            PasscodeGenerator pcg = new PasscodeGenerator(mac);
            String format = formatter.format(cal.getTime());
            feUserId = feUserId + "~" + format;
            return new String[]{pcg.generateResponseCode(feUserId.getBytes()), format};
        }
        catch (GeneralSecurityException e) {
            throw new ApplicationException(PasscodeGenerator.class.getName(), "computePin", "GeneralSecurityException caught while computing pin, " + e.getMessage());
        }
        catch (Base32.DecodingException e) {
            throw new ApplicationException(PasscodeGenerator.class.getName(), "computePin", "DecodingException caught while computing pin, " + e.getMessage());
        }
    }

    public static boolean authenticate(String secretKey, String feUserId, String code) {
        for (int i = -5; i <= 5; ++i) {
            try {
                byte[] keyBytes = Base32.decode(secretKey);
                Mac mac = Mac.getInstance("HMACSHA1");
                mac.init(new SecretKeySpec(keyBytes, ""));
                PasscodeGenerator pcg = new PasscodeGenerator(mac);
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                if (i > 0) {
                    cal.add(12, i);
                } else {
                    cal.add(12, i);
                }
                String format = formatter.format(cal.getTime());
                String newCounter = feUserId + "~" + format;
                String passcode = null;
                passcode = feUserId == null ? pcg.generateTimeoutCode() : pcg.generateResponseCode(newCounter.getBytes());
                if (passcode == null || !passcode.equalsIgnoreCase(code)) continue;
                return true;
            }
            catch (GeneralSecurityException e) {
                return false;
            }
            catch (Base32.DecodingException e) {
                return false;
            }
        }
        return false;
    }

    public static String getTime() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.format(cal.getTime());
    }

    static interface IntervalClock {
        public int getIntervalPeriod();

        public long getCurrentInterval();
    }

    static interface Signer {
        public byte[] sign(byte[] var1) throws GeneralSecurityException;
    }
}

