/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.security;

import android.util.Base64;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class Security {
    private static String encodedPublicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDAkE55K5oE/gRCDc4+1rdHaMyRnqAl1/yOVHS5IFMCHTgnBOoLtVN2y41Fd5GdJgXunEs/rbcalC3Udt0lSe4rurqXqJYcjGb7LbWv+HX1iVksTQlCLcuUHzU1p9sW17FufN6NDrYLL7tdnxaKGkXyxhm/IxHsPWZex5VpY0xoEwIDAQAB";
    private static PublicKey publicKey = null;

    public static final String encryptAES(byte[] key, byte[] input) throws ApplicationException {
        if (key == null || key.length <= 0) {
            return "";
        }
        if (input == null || input.length <= 0) {
            return "";
        }
        key = Base64.decode((String)new String(key), (int)0);
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, keySpec);
            byte[] bytes = cipher.doFinal(input);
            String encString = new String(Base64.encode((byte[])bytes, (int)0));
            return encString;
        }
        catch (Exception e) {
            String error = "Exception caught while encrypting: " + e.getMessage();
            Logger.e(error, e);
            throw new ApplicationException(Security.class.getName(), "encryptAES", error);
        }
    }

    public static String decryptAES(byte[] key, byte[] input) throws ApplicationException {
        if (key == null || key.length <= 0) {
            return "";
        }
        if (input == null || input.length <= 0) {
            return "";
        }
        key = Base64.decode((String)new String(key), (int)0);
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            cipher.init(2, keySpec);
            byte[] bytes = cipher.doFinal(Base64.decode((String)new String(input), (int)0));
            return new String(bytes);
        }
        catch (Exception e) {
            String error = "Exception caught while decrypting: " + e.getMessage();
            Logger.e(error, e);
            throw new ApplicationException(Security.class.getName(), "decryptAES", error);
        }
    }

    public static String encryptUsingUnviredPublicKey(String input) throws ApplicationException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING");
            cipher.init(1, publicKey);
            byte[] bs = cipher.doFinal(input.getBytes());
            return new String(Base64.encode((byte[])bs, (int)0));
        }
        catch (Exception e) {
            String error = "Exception caught while encrypting: " + e.getMessage();
            Logger.e(error, e);
            throw new ApplicationException(Security.class.getName(), "encryptUsingUnviredPublicKey", error);
        }
    }

    public static final String encryptAESWithPadding(byte[] input) throws ApplicationException {
        String aesSecurityKey = "";
        try {
            FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
            aesSecurityKey = frameworkSettingsManager.getSecKey();
            aesSecurityKey = aesSecurityKey.substring(aesSecurityKey.lastIndexOf(":") + 1, aesSecurityKey.length());
        }
        catch (DBException e) {
            Logger.e("DBException caught while retrieving AES key from FrameworkSettings table." + e.getMessage());
        }
        byte[] key = Base64.decode((String)new String(aesSecurityKey.getBytes()), (int)0);
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES/ECB/PKCS5Padding");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, keySpec);
            byte[] bytes = cipher.doFinal(input);
            String encString = new String(Base64.encode((byte[])bytes, (int)0));
            return encString;
        }
        catch (Exception e) {
            String error = "Exception caught while encrypting: " + e.getMessage();
            Logger.e(error, e);
            throw new ApplicationException(Security.class.getName(), "encryptAES", error);
        }
    }

    static {
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.decode((String)encodedPublicKey, (int)0));
            publicKey = keyFactory.generatePublic(publicKeySpec);
        }
        catch (Exception e) {
            Logger.log(8, Security.class.getName(), "static block", "Exception: " + e.getMessage());
        }
    }
}

