/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync;

import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.location.Locations;
import com.unvired.logger.Logger;
import com.unvired.login.LoginParameters;
import com.unvired.message.UNVDataHelper;
import com.unvired.model.AttachmentItem;
import com.unvired.model.AttachmentOutObject;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.MobileAppSettings;
import com.unvired.model.MobileUserSettings;
import com.unvired.model.OutObject;
import com.unvired.model.SentItemObject;
import com.unvired.model.StructureMeta;
import com.unvired.sync.CustomDataHandler;
import com.unvired.sync.SyncConstants;
import com.unvired.sync.attachment.AttachmentDownloader;
import com.unvired.sync.in.DataRequestFunctionCallHandler;
import com.unvired.sync.in.DataRetrieverService;
import com.unvired.sync.in.IConflictHandler;
import com.unvired.sync.in.Inbox;
import com.unvired.sync.in.InboxHandler;
import com.unvired.sync.in.SyncDataHandler;
import com.unvired.sync.notifier.NotificationListener;
import com.unvired.sync.notifier.SynchronizationStateListener;
import com.unvired.sync.out.AttachmentOutbox;
import com.unvired.sync.out.AttachmentSender;
import com.unvired.sync.out.DataSender;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.sync.out.ISyncAppCallback;
import com.unvired.sync.out.ISyncFrameworkCallback;
import com.unvired.sync.out.Outbox;
import com.unvired.sync.out.SentItems;
import com.unvired.sync.response.HTTPResponse;
import com.unvired.sync.response.SyncBEResponse;
import com.unvired.utils.FileHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.NetworkChangeReceiver;
import com.unvired.utils.PathManager;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import okhttp3.Call;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SyncEngine {
    private static SyncEngine syncEngine = null;
    private ApplicationManager applicationManager = ApplicationManager.getInstance();
    private NetworkChangeReceiver networkChangeReceiver;
    private Outbox outbox = null;
    private AttachmentOutbox attachmentOutbox = null;
    private CustomDataHandler customDataHandler = null;
    private IConflictHandler syncConflictHandler = null;
    private NotificationListener notificationListener = null;
    private SynchronizationStateListener synchronizationStateListener = null;
    private DataRequestFunctionCallHandler dataRequestFunctionCallHandler;
    private boolean applicationInDemoMode = false;
    private static final String GSF_PACKAGE = "com.google.android.gsf";
    private IDataManager frameworkDataManager = null;

    public boolean getIsInDemoMode() {
        return this.applicationInDemoMode;
    }

    private SyncEngine() {
    }

    public static SyncEngine getInstance() {
        if (syncEngine == null) {
            syncEngine = new SyncEngine();
        }
        return syncEngine;
    }

    public static void destroy() {
        if (syncEngine != null) {
            SyncEngine.syncEngine.applicationManager = null;
            SyncEngine.syncEngine.attachmentOutbox = null;
            SyncEngine.syncEngine.customDataHandler = null;
            SyncEngine.syncEngine.frameworkDataManager = null;
            SyncEngine.syncEngine.notificationListener = null;
            SyncEngine.syncEngine.outbox = null;
            SyncEngine.syncEngine.syncConflictHandler = null;
            if (SyncEngine.syncEngine.networkChangeReceiver != null) {
                try {
                    FrameworkHelper.applicationContext.unregisterReceiver((BroadcastReceiver)SyncEngine.syncEngine.networkChangeReceiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            syncEngine = null;
            Logger.log(7, SyncEngine.class.getName(), "destroy", "Destroyed");
        } else {
            Logger.log(7, SyncEngine.class.getName(), "destroy", "Destroy not required. Already null.");
        }
    }

    public void initialize() {
        try {
            this.applicationInDemoMode = UserSettingsManager.getInstance().getDemoMode();
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getName(), "initialize", "Login mode initialization failed. Exception: " + e.getMessage());
            return;
        }
        if (this.applicationInDemoMode) {
            return;
        }
        try {
            this.networkChangeReceiver = new NetworkChangeReceiver();
            if (FrameworkHelper.applicationContext == null) {
                FrameworkHelper.applicationContext = LoginParameters.getContext();
            }
            if (FrameworkHelper.applicationContext != null) {
                FrameworkHelper.applicationContext.getApplicationContext().registerReceiver((BroadcastReceiver)this.networkChangeReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
            } else {
                Logger.e("Application context in FrameworkHelper is null. Ignoring NetworkChange event registration.");
            }
        }
        catch (Exception e) {
            Logger.e("Exception caught while registering for NetworkChange event registration." + e.getMessage());
        }
        String url = null;
        try {
            url = FrameworkSettingsManager.getInstance().getUrl();
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        if (url != null && url.toLowerCase().contains("https")) {
            SharedPreferences sharedPrefs = LoginParameters.getContext().getSharedPreferences("SSL_CERTIFICATE", 0);
            LoginParameters.setSSLCert(sharedPrefs.getString("SSL_CERTIFICATE", ""));
        }
        this.outbox = Outbox.getInstance();
        this.outbox.unlockAllOutObject();
        DataSender.getInstance().start();
        DataRetrieverService.getInstance().getMessagesInBackground();
        InboxHandler.getInstance().start();
        AttachmentDownloader.getInstance().start();
        AttachmentSender.getInstance().start();
        SentItems.getInstance().startAutoSyncTimerForGetMessage();
        this.attachmentOutbox = AttachmentOutbox.getInstance();
        Locations.getInstance().RegisterForLocationTracking();
        this.sanityCheckForInBoxAndOutBoxMessageFile();
    }

    public NetworkChangeReceiver getNetworkChangeReceiver() {
        return this.networkChangeReceiver;
    }

    public void registerCustomDataHandler(CustomDataHandler customDataHandler) {
        this.customDataHandler = customDataHandler;
    }

    public CustomDataHandler getCustomDataHandler() {
        return this.customDataHandler;
    }

    public void registerSyncConflictHandler(IConflictHandler syncConflictHandler) {
        this.syncConflictHandler = syncConflictHandler;
    }

    public IConflictHandler getSyncConflictHandler() {
        return this.syncConflictHandler;
    }

    public void registerNotificationListener(NotificationListener notificationListener) {
        this.notificationListener = notificationListener;
    }

    public NotificationListener getNotificationListener() {
        return this.notificationListener;
    }

    public void registerSynchronizationStateListener(SynchronizationStateListener synchronizationStateListener) {
        this.synchronizationStateListener = synchronizationStateListener;
    }

    public SynchronizationStateListener getSynchronizationStateListener() {
        return this.synchronizationStateListener;
    }

    public void receiveData() {
        if (this.applicationInDemoMode) {
            return;
        }
        DataRetrieverService.getInstance().getMessagesInBackground();
    }

    public void resubmitInAsyncMode(SyncConstants.MESSAGE_REQUEST_TYPE requestType, IDataStructure dataStructure, String customData, String processAgentFunctionName, String beName, String beLid, boolean byPassAttachment) throws ApplicationException {
        if (this.applicationInDemoMode) {
            return;
        }
        if (dataStructure == null) {
            throw new ApplicationException(this.getClass().getName(), "resendToServer", "DataStructure cannot be null");
        }
        this.deleteFromSentItemsAndOutbox(dataStructure.getLid());
        try {
            this.submitInAsyncMode(requestType, dataStructure, customData, processAgentFunctionName, beName, beLid, byPassAttachment);
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getName(), "resendDataInAsyncMode", "Resend data in Async failed, DBException: " + e.getMessage());
        }
    }

    public void resendDataInAsyncMode(OutObject outObject) throws ApplicationException, DBException {
        if (this.applicationInDemoMode) {
            return;
        }
        if (outObject == null) {
            throw new ApplicationException(this.getClass().getName(), "resendDataInAsyncMode", "OutObject is null. So cannot resend");
        }
        this.deleteFromSentItemsAndOutbox(outObject.getBELid());
        this.sendToServerAsync(outObject);
    }

    public void sendToServerAsync(OutObject outObject) throws ApplicationException, DBException {
        boolean isInSentItems;
        if (this.applicationInDemoMode) {
            return;
        }
        String beLid = outObject.getBELid();
        boolean isInOutbox = this.isInOutbox(beLid);
        if (isInOutbox) {
            outObject = this.checkIfBEIsAlreadyQueued(beLid);
            if (outObject.getOutObjectStatus() == OutObject.OUT_OBJECT_STATUS.LOCKED_FOR_SENDING) {
                throw new ApplicationException(this.getClass().getName(), "sendToServerAsync", "Cannot modify. OutObject is locked for sending");
            }
            if (!outObject.getFunctionName().equalsIgnoreCase(outObject.getFunctionName())) {
                throw new ApplicationException(this.getClass().getName(), "sendToServerAsync", "Cannot modify. OutObject is already queued for" + outObject.getFunctionName());
            }
            outObject.setOutObjectStatus(OutObject.OUT_OBJECT_STATUS.LOCKED_FOR_MODIFY);
            if (this.frameworkDataManager == null) {
                this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
            }
            try {
                this.frameworkDataManager.update(outObject);
            }
            catch (DBException e) {
                Logger.e("Update Failed, DBException: " + e.getMessage());
            }
            IDataStructure dataStructure = this.getDataStructureForBELid(outObject);
            String dataFormat = FrameworkSettingsManager.getInstance().getDataFormat();
            String dataStringForChangedBE = "";
            UNVDataHelper.DATA_TYPE data_type = UNVDataHelper.DATA_TYPE.CHANGED_QUEUED;
            if (SyncConstants.MESSAGE_REQUEST_TYPE.QUERY.toString().equals(outObject.getRequestType())) {
                data_type = UNVDataHelper.DATA_TYPE.ALL;
            }
            dataStringForChangedBE = "XML".equalsIgnoreCase(dataFormat) ? UNVDataHelper.generateMessageIBXML(dataStructure, data_type) : UNVDataHelper.generateMessageIBJSON(dataStructure, data_type);
            try {
                outObject.setMessageXml(dataStringForChangedBE.getBytes());
                outObject.setOutObjectStatus(OutObject.OUT_OBJECT_STATUS.NONE);
                this.frameworkDataManager.update(outObject);
            }
            catch (DBException e) {
                Logger.e("Update Failed, DBException: " + e.getMessage());
            }
        }
        if (isInSentItems = this.isInSentItems(beLid)) {
            String error = "Object already present in sent items. Cannot queue the same object twice. BE Name: " + outObject.getBEName() + " Process Agent Name: " + outObject.getFunctionName() + " BE Name: " + outObject.getBEName() + " BE Lid: " + outObject.getBELid() + " Data: " + outObject.getMessageXml();
            throw new ApplicationException(this.getClass().getName(), "sendToServerAsync", error);
        }
        try {
            this.outbox.add(outObject);
        }
        catch (Exception e) {
            String error = "Exception while adding data structure to outbox. BE Name: " + outObject.getBEName() + " Process Agent Name: " + outObject.getFunctionName() + " Exception: " + e.getMessage() + " Data: " + outObject.getMessageXml();
            throw new ApplicationException(this.getClass().getName(), "sendToServerAsync", error);
        }
    }

    private OutObject checkIfBEIsAlreadyQueued(String beLid) {
        IDataStructure[] dataStructures = null;
        OutObject outObject = null;
        String whereClause = OutObject.BE_HEADER_LID + " = '" + beLid + "'";
        this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        try {
            dataStructures = this.frameworkDataManager.get(OutObject.TABLE_NAME, whereClause, OutObject.class);
        }
        catch (DBException e) {
            Logger.e("No such outobject present in database, BE LID: " + beLid);
        }
        if (dataStructures != null) {
            outObject = (OutObject)dataStructures[0];
        }
        return outObject;
    }

    private IDataStructure getDataStructureForBELid(OutObject outObject) {
        IDataStructure[] dataStructures;
        try {
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            IDataManager dataManager = applicationManager.getDataManager();
            StructureMeta structureMeta = applicationManager.getHeaderStructureMeta(outObject.getBEName());
            String structureName = structureMeta.getStructName();
            String whereClause = "LID='" + outObject.getBELid() + "'";
            dataStructures = dataManager.get(structureName, whereClause);
        }
        catch (DBException dbe) {
            Logger.e("DBException caught while getting business entity from database, BE-NAME: " + outObject.getBEName() + ", BE-LID: " + outObject.getBELid() + ", " + dbe.getMessage(), dbe);
            return null;
        }
        return dataStructures[0];
    }

    public void sendAttachmentToServerAsync(AttachmentOutObject attachmentOutObject) throws ApplicationException {
        boolean isInSentItems;
        if (this.applicationInDemoMode) {
            return;
        }
        String beLid = attachmentOutObject.getBEHeaderLid();
        boolean isInAttachmentOutbox = this.isInAttachmentOutbox(beLid);
        if (isInAttachmentOutbox) {
            AttachmentOutObject attachmentOutObjectQueued = this.checkIfBEWithAttachmentIsAlreadyQueued(beLid);
            if (attachmentOutObjectQueued.getAttachmentOutObjectStatus() == AttachmentOutObject.ATTACHMENT_OUT_OBJECT_STATUS.LOCKED_FOR_SENDING) {
                throw new ApplicationException(this.getClass().getName(), "sendAttachmentToServerAsync", "Cannot modify. AttachmentOutObject is locked for sending");
            }
            if (!attachmentOutObjectQueued.getFunctionName().equalsIgnoreCase(attachmentOutObject.getFunctionName())) {
                throw new ApplicationException(this.getClass().getName(), "sendAttachmentToServerAsync", "Cannot modify. AttachmentOutObject is already queued for" + attachmentOutObjectQueued.getFunctionName());
            }
            attachmentOutObject.setAttachmentOutObjectStatus(AttachmentOutObject.ATTACHMENT_OUT_OBJECT_STATUS.LOCKED_FOR_MODIFY);
            if (this.frameworkDataManager == null) {
                this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
            }
            try {
                this.frameworkDataManager.update(attachmentOutObject);
            }
            catch (DBException e) {
                Logger.e("Update Failed, DBException: " + e.getMessage());
            }
            try {
                attachmentOutObject.setAttachmentOutObjectStatus(AttachmentOutObject.ATTACHMENT_OUT_OBJECT_STATUS.NONE);
                this.frameworkDataManager.update(attachmentOutObject);
            }
            catch (DBException e) {
                Logger.e("Update Failed, DBException: " + e.getMessage());
            }
        }
        if (isInSentItems = this.isInSentItems(beLid)) {
            String error = "Object already present in sent items. Cannot queue the same object twice. BE Name: " + attachmentOutObject.getBEName() + " Process Agent Name: " + attachmentOutObject.getFunctionName() + " BE Name: " + attachmentOutObject.getBEName() + " BE Lid: " + attachmentOutObject.getBEHeaderLid();
            throw new ApplicationException(this.getClass().getName(), "sendToServerAsync", error);
        }
        try {
            this.attachmentOutbox.add(attachmentOutObject);
        }
        catch (Exception e) {
            String error = "Exception while adding data structure to outbox. BE Name: " + attachmentOutObject.getBEName() + " Process Agent Name: " + attachmentOutObject.getFunctionName() + " Exception: " + e.getMessage();
            throw new ApplicationException(this.getClass().getName(), "sendAttachmentToServerAsync", error);
        }
    }

    private AttachmentOutObject checkIfBEWithAttachmentIsAlreadyQueued(String beLid) {
        IDataStructure[] dataStructures = null;
        AttachmentOutObject attachmentOutObject = null;
        String whereClause = AttachmentOutObject.BE_HEADER_LID + " = '" + beLid + "'";
        this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        try {
            dataStructures = this.frameworkDataManager.get(AttachmentOutObject.TABLE_NAME, whereClause, AttachmentOutObject.class);
        }
        catch (DBException e) {
            Logger.e("No such attachmentOutObject present in database, BE LID: " + beLid);
        }
        if (dataStructures != null) {
            attachmentOutObject = (AttachmentOutObject)dataStructures[0];
        }
        return attachmentOutObject;
    }

    private void sendToServerAsync(int messageType, int messageSubType, SyncConstants.MESSAGE_REQUEST_TYPE requestType, String data, String processAgentFunctionName, String beName, String lid, boolean byPassAttachment) throws ApplicationException {
        if (Strings.isNullOrEmpty((String)processAgentFunctionName)) {
            throw new ApplicationException(this.getClass().getName(), "sendToServerAsync", "Process agent function name is mandatory");
        }
        try {
            boolean attachmentItemsExist;
            OutObject outObject = new OutObject();
            outObject.setSyncType(SyncConstants.SYNC_MODE.ASYNC.toString());
            outObject.setFunctionName(processAgentFunctionName);
            outObject.setMessageType(String.valueOf(messageType));
            outObject.setMessageSubType(String.valueOf(messageSubType));
            outObject.setRequestType(requestType.toString());
            outObject.setBEName(beName);
            outObject.setBELid(lid);
            outObject.setMessageXml(data.getBytes());
            outObject.setByPassAttachment(String.valueOf(byPassAttachment));
            if (!byPassAttachment && ApplicationManager.getInstance().isAttachmentSupported(beName) && (attachmentItemsExist = this.doPendingAttachmentsExist(lid, beName))) {
                AttachmentOutObject attachmentOutObject = new AttachmentOutObject();
                attachmentOutObject.setBEName(beName);
                attachmentOutObject.setBEHeaderLid(lid);
                attachmentOutObject.setFunctionName(processAgentFunctionName);
                this.sendAttachmentToServerAsync(attachmentOutObject);
            }
            this.sendToServerAsync(outObject);
        }
        catch (DBException e) {
            Logger.e("DBException caught while sending data in async " + e.getMessage(), e);
        }
    }

    private boolean doPendingAttachmentsExist(String beLid, String beName) throws ApplicationException {
        if (beName == null) {
            throw new ApplicationException(this.getClass().getName(), "add", "BE cannot be null");
        }
        if (beLid == null) {
            throw new ApplicationException(this.getClass().getName(), "add", "BE LID cannot be null");
        }
        try {
            IDataManager applicationDataManager = this.applicationManager.getDataManager();
            StructureMeta structureMeta = this.applicationManager.getHeaderStructureMeta(beName);
            if (structureMeta == null) {
                Logger.log(8, this.getClass().getName(), "doPendingAttachmentsExist", "Invalid BE. Cannot upload attachments. BE Name: " + beName);
                return false;
            }
            String whereClause = "LID = '" + beLid + "'";
            IDataStructure[] headers = applicationDataManager.get(structureMeta.getStructName(), whereClause);
            if (headers == null || headers.length == 0) {
                Logger.log(8, this.getClass().getName(), "doPendingAttachmentsExist", "Header not found. Cannot check for attachments.");
                return false;
            }
            IDataStructure header = headers[0];
            AttachmentItem[] items = this.getAttachments(header);
            if (items != null && items.length > 0) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.log(8, this.getClass().getName(), "doPendingAttachmentsExist", "Exception :" + e.getMessage());
            return false;
        }
        return false;
    }

    private AttachmentItem[] getAttachments(IDataStructure header) {
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        IDataStructure[] dataStructures = null;
        try {
            IDataManager applicationDataManager = applicationManager.getDataManager();
            String beName = header.getBEName();
            String whereClause = "ATTACHMENT_STATUS = '" + AttachmentItem.ATTACHMENT_ITEM_STATUS.SAVED_FOR_UPLOAD.ordinal() + "'";
            String attachmentStructName = beName + "_ATTACHMENT";
            dataStructures = applicationDataManager.getChildren(attachmentStructName, whereClause, null, header);
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getName(), "getAttachments", "DBException while getting attachment items of a business header: " + e.getMessage());
        }
        if (dataStructures == null || dataStructures.length == 0) {
            Logger.i("dataStructures is null, while checking if the IdataStructure in question supports attachments and if it has one");
            return null;
        }
        AttachmentItem[] items = new AttachmentItem[dataStructures.length];
        System.arraycopy(dataStructures, 0, items, 0, dataStructures.length);
        return items;
    }

    public void submitInSyncMode(SyncConstants.MESSAGE_REQUEST_TYPE requestType, IDataStructure dataStructure, String customData, String processAgentFunctionName, boolean autoSave, ISyncAppCallback appCallback) throws ApplicationException, DBException {
        if (this.applicationInDemoMode) {
            this.getDemoMessage(appCallback, dataStructure);
            return;
        }
        switch (requestType) {
            case PULL: 
            case QUERY: {
                if (dataStructure != null) {
                    SyncDataHandler.sendDataPullQueryInSyncMode(requestType, dataStructure, processAgentFunctionName, autoSave, appCallback);
                    break;
                }
                SyncDataHandler.sendDataPullQueryInSyncMode(requestType, customData, processAgentFunctionName, autoSave, appCallback);
                break;
            }
            case RQST: {
                if (dataStructure != null) {
                    SyncDataHandler.sendDataInSyncMode(dataStructure, processAgentFunctionName, autoSave, appCallback);
                    break;
                }
                SyncDataHandler.sendDataInSyncMode(customData, processAgentFunctionName, autoSave, appCallback);
            }
        }
    }

    public void submitInAsyncMode(SyncConstants.MESSAGE_REQUEST_TYPE requestType, IDataStructure dataStructure, String customData, String processAgentFunctionName, String beName, String beLid, boolean byPassAttachment) throws ApplicationException, DBException {
        if (this.applicationInDemoMode) {
            return;
        }
        if (customData == null) {
            customData = "";
        }
        switch (requestType) {
            case PULL: 
            case QUERY: {
                if (dataStructure != null) {
                    String dataFormat = FrameworkSettingsManager.getInstance().getDataFormat();
                    String dataString = "";
                    dataString = "XML".equalsIgnoreCase(dataFormat) ? UNVDataHelper.generateMessageIBXML(dataStructure, UNVDataHelper.DATA_TYPE.ALL) : UNVDataHelper.generateMessageIBJSON(dataStructure, UNVDataHelper.DATA_TYPE.ALL);
                    if (beName == null) {
                        throw new ApplicationException(this.getClass().getName(), "submitInAsyncModeRequestType:" + (Object)((Object)requestType), "BE Name cannot be null");
                    }
                    this.sendToServerAsync(8000, 600, requestType, dataString, processAgentFunctionName, beName, dataStructure.getLid(), byPassAttachment);
                    break;
                }
                if (!Strings.isNullOrEmpty((String)customData)) {
                    this.sendToServerAsync(8000, 700, requestType, customData, processAgentFunctionName, null, null, byPassAttachment);
                    break;
                }
                this.sendToServerAsync(8000, 600, requestType, customData, processAgentFunctionName, null, null, byPassAttachment);
                break;
            }
            case RQST: {
                BusinessEntityMeta businessEntityMeta;
                if (beName == null) {
                    throw new ApplicationException(this.getClass().getName(), "submitInAsyncModeRequestType:" + (Object)((Object)requestType), "BE Name cannot be null");
                }
                try {
                    businessEntityMeta = this.applicationManager.getBusinessEntityMeta(beName);
                }
                catch (DBException e) {
                    e.printStackTrace();
                    throw new ApplicationException(this.getClass().getName(), "submitInAsyncMode", e.getMessage());
                }
                if (businessEntityMeta == null) {
                    throw new ApplicationException(this.getClass().getName(), "submitInAsyncMode", "Invalid BE: " + beName);
                }
                if (beLid == null) {
                    throw new ApplicationException(this.getClass().getName(), "submitInAsyncMode", "BE LID cannot be null. Be Name: " + beName);
                }
                if (dataStructure != null) {
                    String dataFormat = FrameworkSettingsManager.getInstance().getDataFormat();
                    String dataString = "";
                    dataString = "XML".equalsIgnoreCase(dataFormat) ? UNVDataHelper.generateMessageIBXML(dataStructure, UNVDataHelper.DATA_TYPE.CHANGED) : UNVDataHelper.generateMessageIBJSON(dataStructure, UNVDataHelper.DATA_TYPE.CHANGED);
                    if (dataString == null || dataString.isEmpty()) {
                        throw new ApplicationException(this.getClass().getName(), "submitInAsyncMode", "Data cannot be retrieved for the datastructure: " + dataStructure.getBEName() + " LID: " + dataStructure.getLid());
                    }
                    this.sendToServerAsync(8000, 600, requestType, dataString, processAgentFunctionName, beName, dataStructure.getLid(), byPassAttachment);
                    break;
                }
                if (!Strings.isNullOrEmpty((String)customData)) {
                    this.sendToServerAsync(8000, 700, requestType, customData, processAgentFunctionName, beName, beLid, byPassAttachment);
                    break;
                }
                this.sendToServerAsync(8000, 600, requestType, customData, processAgentFunctionName, beName, beLid, byPassAttachment);
                break;
            }
        }
    }

    public void sendToServerSync(OutObject outObject) throws ApplicationException, DBException {
        this.sendToServerAsync(outObject);
    }

    private String getBEName(String tableName) throws ApplicationException {
        StructureMeta stuctureMeta = null;
        try {
            stuctureMeta = this.applicationManager.getStructureMeta(tableName);
        }
        catch (DBException e) {
            String error = "Exception while getting structure meta from database. Table Name: " + tableName + " Exception: " + e.getMessage();
            throw new ApplicationException(this.getClass().getName(), "getBEName", error);
        }
        if (stuctureMeta == null) {
            throw new ApplicationException(this.getClass().getName(), "getBEName", "Structure meta not found for table: " + tableName);
        }
        String beName = stuctureMeta.getBeName();
        return beName;
    }

    private void deleteFromSentItemsAndOutbox(String beLid) throws ApplicationException {
        if (beLid == null) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("BE Lid is null");
            }
            return;
        }
        boolean outboxPresent = false;
        try {
            outboxPresent = this.outbox.isInQueue(beLid);
        }
        catch (DBException dbException) {
            throw new ApplicationException(this.getClass().getName(), "deleteFromSentItemsAndOutbox", "DB Exception while fetching object from outbox: " + dbException.getMessage());
        }
        if (outboxPresent) {
            try {
                this.outbox.remove(beLid);
            }
            catch (DBException dbException) {
                throw new ApplicationException(this.getClass().getName(), "deleteFromSentItemsAndOutbox", "DBException while removing object from outbox: " + dbException.getMessage());
            }
        }
        SentItems sentItems = SentItems.getInstance();
        SentItemObject sentItemObject = null;
        try {
            sentItemObject = sentItems.getByBeLid(beLid);
        }
        catch (DBException dbException) {
            throw new ApplicationException(this.getClass().getName(), "deleteFromSentItemsAndOutbox", "DBException while fetching object from sent items: " + dbException.getMessage());
        }
        if (sentItemObject != null) {
            try {
                sentItems.remove(sentItemObject.getConversationId());
            }
            catch (DBException dbException) {
                throw new ApplicationException(this.getClass().getName(), "deleteFromSentItemsAndOutbox", "DBException while removing object from sent items: " + dbException.getMessage());
            }
        }
    }

    public boolean isInOutbox(String beLid) throws ApplicationException {
        try {
            return this.outbox.isInQueue(beLid);
        }
        catch (DBException dbException) {
            throw new ApplicationException(this.getClass().getName(), "isInOutbox", "DB Exception while fetching object from outbox: " + dbException.getMessage());
        }
    }

    private boolean isInAttachmentOutbox(String beLid) throws ApplicationException {
        boolean attachmentOutboxPresent = false;
        try {
            attachmentOutboxPresent = this.attachmentOutbox.isInQueue(beLid);
        }
        catch (DBException dbException) {
            throw new ApplicationException(this.getClass().getName(), "isInAttachmentOutbox", "DB Exception while fetching attachmentObject from AttachmentOutbox: " + dbException.getMessage());
        }
        return attachmentOutboxPresent;
    }

    public boolean isInSentItems(String beLid) throws ApplicationException {
        try {
            return SentItems.getInstance().containsBeLid(beLid);
        }
        catch (DBException dbException) {
            throw new ApplicationException(this.getClass().getName(), "isInSentItems", "DBException while fetching object from sent items: " + dbException.getMessage());
        }
    }

    public void sendDataRequestForAllFunctions() throws ApplicationException, DBException {
        Document initialDataRequestDocument = FrameworkHelper.getSenderDocumentRoot(9000, null, null, this.applicationManager.getApplicationName(), this.applicationManager.getApplicationId());
        Element root = initialDataRequestDocument.getDocumentElement();
        Element initialDataRequestDataElement = initialDataRequestDocument.createElement("data");
        initialDataRequestDataElement.setAttribute("subtype", String.valueOf(400));
        root.appendChild(initialDataRequestDataElement);
        String xml = FrameworkHelper.getString(initialDataRequestDocument);
        OutObject outObject = new OutObject();
        outObject.setFunctionName("ADMIN_SERVICES");
        outObject.setMessageType(String.valueOf(9000));
        outObject.setMessageSubType(String.valueOf(400));
        outObject.setMessageXml(xml.getBytes());
        outObject.setSyncType(SyncConstants.SYNC_MODE.SYNC.toString());
        SyncEngine.getInstance().sendToServerSync(outObject);
    }

    public void registerDataRequestFunctionCallHandler(DataRequestFunctionCallHandler dataRequestFunctionCallHandler) {
        this.dataRequestFunctionCallHandler = dataRequestFunctionCallHandler;
    }

    public void sendDataRequests(final Vector<String> functions) throws ApplicationException, DBException {
        if (this.dataRequestFunctionCallHandler != null) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    SyncEngine.this.dataRequestFunctionCallHandler.callFunctions(functions);
                }
            });
            t.start();
            return;
        }
        for (String function : functions) {
            SyncEngine.getInstance().sendDataRequest(function, "");
        }
    }

    public void sendDataRequest(String functionName, String inputData) throws ApplicationException, DBException {
        Element inputElement;
        if (functionName == null || functionName.length() <= 0) {
            throw new ApplicationException(this.getClass().getName(), "postInitialDataRequest", "Invalid Function Name Found.");
        }
        Document initialDataRequestDocument = FrameworkHelper.getSenderDocumentRoot(9000, null, null, this.applicationManager.getApplicationName(), this.applicationManager.getApplicationId());
        Element root = initialDataRequestDocument.getDocumentElement();
        Element initialDataRequestDataElement = initialDataRequestDocument.createElement("data");
        initialDataRequestDataElement.setAttribute("subtype", String.valueOf(400));
        root.appendChild(initialDataRequestDataElement);
        Element namespaceElement = initialDataRequestDocument.createElement("Namespace");
        initialDataRequestDataElement.appendChild(namespaceElement);
        String namespace = FrameworkSettingsManager.getInstance().getNamespace();
        namespaceElement.appendChild(initialDataRequestDocument.createTextNode(namespace));
        Element functionsElement = initialDataRequestDocument.createElement("Functions");
        initialDataRequestDataElement.appendChild(functionsElement);
        Element functionElement = initialDataRequestDocument.createElement("Function");
        functionElement.setAttribute("n", functionName);
        functionsElement.appendChild(functionElement);
        if (inputData != null && inputData.length() > 0) {
            inputElement = initialDataRequestDocument.createElement("input");
            inputElement.appendChild(initialDataRequestDocument.createTextNode(inputData));
            functionElement.appendChild(inputElement);
        } else {
            inputElement = initialDataRequestDocument.createElement("input");
            inputElement.appendChild(initialDataRequestDocument.createTextNode(""));
            functionElement.appendChild(inputElement);
        }
        String xml = FrameworkHelper.getString(initialDataRequestDocument);
        OutObject outObject = new OutObject();
        outObject.setFunctionName("ADMIN_SERVICES");
        outObject.setMessageType(String.valueOf(9000));
        outObject.setMessageSubType(String.valueOf(400));
        outObject.setMessageXml(xml.getBytes());
        outObject.setSyncType(SyncConstants.SYNC_MODE.SYNC.toString());
        SyncEngine.getInstance().sendToServerSync(outObject);
    }

    public void sendPushNotificationIdToServer(String pushNotificationId) throws ApplicationException, DBException {
        if (Strings.isNullOrEmpty((String)pushNotificationId)) {
            throw new ApplicationException(this.getClass().getName(), "sendPushNotificationIdToServer", "Invalid Push Notification Id");
        }
        Document initialDataRequestDocument = FrameworkHelper.getSenderDocumentRoot(9000, null, null, this.applicationManager.getApplicationName(), this.applicationManager.getApplicationId());
        Element root = initialDataRequestDocument.getDocumentElement();
        Element initialDataRequestDataElement = initialDataRequestDocument.createElement("data");
        initialDataRequestDataElement.setAttribute("subtype", String.valueOf(610));
        root.appendChild(initialDataRequestDataElement);
        Element pushIdElement = initialDataRequestDocument.createElement("PushId");
        pushIdElement.appendChild(initialDataRequestDocument.createTextNode(pushNotificationId));
        initialDataRequestDataElement.appendChild(pushIdElement);
        String xml = FrameworkHelper.getString(initialDataRequestDocument);
        OutObject outObject = new OutObject();
        outObject.setFunctionName("ADMIN_SERVICES");
        outObject.setMessageType(String.valueOf(9000));
        outObject.setMessageSubType(String.valueOf(610));
        outObject.setMessageXml(xml.getBytes());
        outObject.setSyncType(SyncConstants.SYNC_MODE.SYNC.toString());
        outObject.setField(OutObject.COMPANY_NAMESPACE, pushNotificationId);
        SyncEngine.getInstance().sendToServerSync(outObject);
    }

    private void getDemoMessage(ISyncAppCallback callback, IDataStructure dataStructure) {
        if (callback != null) {
            Hashtable<String, Hashtable<IDataStructure, Vector<IDataStructure>>> dataBEs = new Hashtable<String, Hashtable<IDataStructure, Vector<IDataStructure>>>();
            if (dataStructure != null) {
                Hashtable headerAndItems = new Hashtable();
                Vector<IDataStructure> itemVector = new Vector<IDataStructure>();
                dataBEs.put(dataStructure.getBEName(), headerAndItems);
                try {
                    String[] childrenTableNames = dataStructure.getChildrenTableNames();
                    if (childrenTableNames != null && childrenTableNames.length > 0) {
                        for (String tableName : childrenTableNames) {
                            IDataStructure[] items = ApplicationManager.getInstance().getDataManager().getChildren(tableName, dataStructure);
                            if (items == null || items.length <= 0) continue;
                            for (IDataStructure item : items) {
                                itemVector.add(item);
                            }
                        }
                    }
                }
                catch (DBException e) {
                    e.printStackTrace();
                }
                headerAndItems.put(dataStructure, itemVector);
            }
            SyncBEResponse syncBEResponse = new SyncBEResponse(200, null, dataBEs, null);
            callback.onResponse(syncBEResponse);
        }
    }

    public Hashtable<String, String> getMobileApplicationSettings() {
        if (this.frameworkDataManager == null) {
            this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        }
        try {
            Hashtable<String, String> mobileAppSettingsHash = new Hashtable<String, String>();
            IDataStructure[] mobileAppSettingStructures = this.frameworkDataManager.get("MOBILE_APP_SETTINGS");
            for (int i = 0; i < mobileAppSettingStructures.length; ++i) {
                MobileAppSettings mobileAppSettings = (MobileAppSettings)mobileAppSettingStructures[i];
                mobileAppSettingsHash.put(mobileAppSettings.getFieldName(), mobileAppSettings.getFieldValue());
            }
            return mobileAppSettingsHash;
        }
        catch (DBException e) {
            Logger.log(7, SyncEngine.class.getName(), "getMobileApplicationSettings", "Error while gettings Mobile Application Settings." + e.getMessage());
            return null;
        }
    }

    public IDataStructure[] getMobileUserSettings() {
        if (this.frameworkDataManager == null) {
            this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        }
        try {
            IDataStructure[] mobileUserSettings = this.frameworkDataManager.get("MOBILE_USER_SETTINGS");
            return mobileUserSettings;
        }
        catch (DBException e) {
            Logger.log(7, SyncEngine.class.getName(), "getMobileUserSettings", "Error while gettings Mobile Application Settings." + e.getMessage());
            return null;
        }
    }

    public void setMobileUserSettings(IDataStructure[] userSettingsDataStructures) {
        if (this.frameworkDataManager == null) {
            this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        }
        try {
            for (int i = 0; i < userSettingsDataStructures.length; ++i) {
                this.frameworkDataManager.insertOrUpdateBasedOnGID(userSettingsDataStructures[i]);
            }
            String nameSpace = null;
            try {
                nameSpace = FrameworkSettingsManager.getInstance().getNamespace();
            }
            catch (DBException e) {
                Logger.log(8, this.getClass().getName(), "addToOutbox", "DBException: " + e.getMessage());
            }
            String serverId = FrameworkSettingsManager.getInstance().getServerId();
            Document mobileUserSettingDocument = FrameworkHelper.getSenderDocumentRoot(9000, null, serverId, this.applicationManager.getApplicationName(), this.applicationManager.getApplicationId());
            Element root = mobileUserSettingDocument.getDocumentElement();
            Element mobileUserSettingDocumentDataElement = mobileUserSettingDocument.createElement("data");
            mobileUserSettingDocumentDataElement.setAttribute("subtype", String.valueOf(625));
            root.appendChild(mobileUserSettingDocumentDataElement);
            Element appUserSettingsElement = mobileUserSettingDocument.createElement("APPLICATION_USER_SETTINGS");
            for (int i = 0; i < userSettingsDataStructures.length; ++i) {
                MobileUserSettings mobileUserSettings = (MobileUserSettings)userSettingsDataStructures[i];
                Element settingsElement = mobileUserSettingDocument.createElement("SETTING");
                settingsElement.setAttribute("keyname", mobileUserSettings.getFieldName());
                Element valueElement = mobileUserSettingDocument.createElement("VALUE");
                valueElement.setTextContent(mobileUserSettings.getCurrent());
                settingsElement.appendChild(valueElement);
                appUserSettingsElement.appendChild(settingsElement);
            }
            mobileUserSettingDocumentDataElement.appendChild(appUserSettingsElement);
            String xml = FrameworkHelper.getString(mobileUserSettingDocument);
            OutObject outObject = new OutObject();
            outObject.setFunctionName("ADMIN_SERVICES");
            outObject.setMessageType(String.valueOf(9000));
            outObject.setMessageSubType(String.valueOf(625));
            outObject.setMessageXml(xml.getBytes());
            outObject.setSyncType(SyncConstants.SYNC_MODE.SYNC.toString());
            outObject.setConversationId("");
            try {
                SyncEngine.getInstance().sendToServerAsync(outObject);
            }
            catch (Exception exception) {
                Logger.log(8, this.getClass().getName(), "setMobileUserSettings", "Exception while adding object to outbox " + exception.getMessage());
            }
        }
        catch (DBException e) {
            Logger.log(7, SyncEngine.class.getName(), "setMobileUserSettings", "Error while updating Mobile User Settings." + e.getMessage());
        }
        catch (ApplicationException e) {
            Logger.log(8, this.getClass().getName(), "setMobileUserSettings", "Exception while adding object to outbox " + e.getMessage());
        }
    }

    public void cancelHttpConnection(ISyncAppCallback appCallback) {
        Hashtable<ISyncAppCallback, ISyncFrameworkCallback> appFrameworkCallbackMap = HTTPConnection.appFrameworkCallbackMap;
        Hashtable<ISyncFrameworkCallback, Call> okHttpConnectionCallbackMap = HTTPConnection.okHttpConnectionCallbackMap;
        if (appCallback == null || appFrameworkCallbackMap == null || appFrameworkCallbackMap.isEmpty() || okHttpConnectionCallbackMap == null || okHttpConnectionCallbackMap.isEmpty()) {
            return;
        }
        ISyncFrameworkCallback frameworkCallback = appFrameworkCallbackMap.get(appCallback);
        if (frameworkCallback == null) {
            HTTPResponse httpResponse = new HTTPResponse(0, null, "Callback not registered for any HttpConnection.");
            appCallback.onResponse(httpResponse);
            return;
        }
        Call callInMap = okHttpConnectionCallbackMap.get(frameworkCallback);
        if (callInMap == null) {
            HTTPResponse httpResponse = new HTTPResponse(0, null, "Callback not registered for any HttpConnection.");
            appCallback.onResponse(httpResponse);
            return;
        }
        try {
            callInMap.cancel();
            okHttpConnectionCallbackMap.remove(frameworkCallback);
            appFrameworkCallbackMap.remove(appCallback);
        }
        catch (Exception ex) {
            Logger.log(8, this.getClass().getName(), "cancelHttpConnection", "Exception while cancelling Http connection and removing entry from OkHttpConnTable Map. " + ex.getMessage());
        }
    }

    private void sanityCheckForInBoxAndOutBoxMessageFile() {
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.OUTBOX_FOLDER);
        if (localPath == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "sanityCheckForInBoxAndOutBoxMessageFile", "Cannot get local path for Inbox, Outbox file deletion.");
            return;
        }
        try {
            int outBoxCount = Outbox.getInstance().count();
            if (outBoxCount <= 0) {
                FileHelper.deleteFolderContent(localPath);
            }
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getSimpleName(), "SanityCheckForInBoxAndOutBoxMessageFile", "Error while deleting OutBox message folder." + e.getMessage());
        }
        try {
            localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.INBOX_FOLDER);
            int inBoxCount = Inbox.getInstance().count();
            if (inBoxCount <= 0) {
                FileHelper.deleteFolderContent(localPath);
            }
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getSimpleName(), "SanityCheckForInBoxAndOutBoxMessageFile", "Error while deleting InBox message folder." + e.getMessage());
        }
    }

    public void queuePushNotificationTestMessage() {
        try {
            String applicationId;
            String applicationName;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                Logger.log(8, FrameworkHelper.class.getName(), "getSenderDocumentRoot", "Exception while creating a dom document: " + e.getMessage());
            }
            Document domDocument = db.newDocument();
            Element root = domDocument.createElement("Root");
            root.setAttribute("type", String.valueOf(9000));
            domDocument.appendChild(root);
            FrameworkSettingsManager frameworkSettingsManager = null;
            try {
                frameworkSettingsManager = FrameworkManager.getInstance().getFrameworkSettingsManager();
                if (frameworkSettingsManager.getCompanyAlias() != null && frameworkSettingsManager.getCompanyAlias().length() > 0) {
                    Element companyAliasElement = domDocument.createElement("CompanyAlias");
                    companyAliasElement.appendChild(domDocument.createTextNode(frameworkSettingsManager.getCompanyAlias()));
                    root.appendChild(companyAliasElement);
                }
            }
            catch (DBException dbException) {
                Logger.log(8, FrameworkHelper.class.getName(), "", "DBException caught while getting framework settings, " + dbException.getMessage());
            }
            String serverId = FrameworkSettingsManager.getInstance().getServerId();
            if (serverId != null && serverId.length() > 0) {
                Element conversationIdElement = domDocument.createElement("ServerId");
                conversationIdElement.appendChild(domDocument.createTextNode(serverId));
                root.appendChild(conversationIdElement);
            }
            if ((applicationName = ApplicationManager.getInstance().getApplicationName()) != null && applicationName.length() > 0) {
                Element conversationIdElement = domDocument.createElement("ApplicationName");
                conversationIdElement.appendChild(domDocument.createTextNode(applicationName));
                root.appendChild(conversationIdElement);
            }
            if ((applicationId = ApplicationManager.getInstance().getApplicationId()) != null && applicationId.length() > 0) {
                Element conversationIdElement = domDocument.createElement("ApplicationId");
                conversationIdElement.appendChild(domDocument.createTextNode(applicationId));
                root.appendChild(conversationIdElement);
            }
            Element data = domDocument.createElement("data");
            data.setAttribute("subtype", String.valueOf(110));
            Element nameSpace = domDocument.createElement("Namespace");
            Text value = domDocument.createTextNode(UserSettingsManager.getInstance().getCompanyAlias());
            nameSpace.appendChild(value);
            data.appendChild(nameSpace);
            root.appendChild(data);
            String xml = FrameworkHelper.getString(domDocument);
            OutObject outObject = new OutObject();
            outObject.setSyncType(SyncConstants.SYNC_MODE.SYNC.toString());
            outObject.setFunctionName("ADMIN_SERVICES");
            outObject.setMessageType(String.valueOf(9000));
            outObject.setMessageSubType(String.valueOf(110));
            outObject.setMessageXml(xml.getBytes());
            Outbox.getInstance().add(outObject);
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
    }
}

