/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.attachment;

import android.os.AsyncTask;
import com.unvired.core.ApplicationManager;
import com.unvired.core.RuntimeEngine;
import com.unvired.database.DBException;
import com.unvired.database.DataStructureTableMapping;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentItem;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.JSAttachmentItem;
import com.unvired.model.JSDataStructure;
import com.unvired.model.StructureMeta;
import com.unvired.sync.attachment.AttachmentDownloader;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.PathManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class Attachment {
    public static void queueForDownload(AttachmentItem attachment, String priority) {
        AttachmentDownloader.getInstance().queueAttachment(attachment, priority);
    }

    public static void deleteAttachment(AttachmentItem attachment) throws ApplicationException {
        if (attachment == null) {
            throw new ApplicationException("Attachment", "deleteAttachment", "attachment item provided for deletion is null.");
        }
        if (attachment.getAttachmentStatus() != AttachmentItem.ATTACHMENT_ITEM_STATUS.SAVED_FOR_UPLOAD) {
            Logger.log(7, "Attachment", "deleteAttachment", "marking for deletion and then deleting the file");
            attachment.setAttachmentStatus(AttachmentItem.ATTACHMENT_ITEM_STATUS.MARKED_FOR_DELETE);
            try {
                attachment.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                attachment.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                ApplicationManager.getInstance().getDataManager().insertOrUpdateBasedOnGID(attachment);
            }
            catch (DBException e) {
                Logger.log(8, "Attachment", "deleteAttachment", "DBException while trying to update the attachment item to the status marked for download: " + e.getMessage());
            }
        } else if (attachment.getAttachmentStatus() == AttachmentItem.ATTACHMENT_ITEM_STATUS.SAVED_FOR_UPLOAD) {
            Logger.log(7, "Attachment", "deleteAttachment", "Deleting the item locally");
            try {
                ApplicationManager.getInstance().getDataManager().delete(attachment);
            }
            catch (DBException e) {
                Logger.log(8, "Attachment", "deleteAttachment", "DBException while trying to deleting the attachment item with the status as local: " + e.getMessage());
            }
        }
    }

    public static boolean isAttachmentTable(String tableName) throws DBException {
        String tempClassName = DataStructureTableMapping.getInstance().getClassName(tableName);
        Class<?> className = null;
        if (tempClassName != null) {
            try {
                className = Class.forName(tempClassName);
                IDataStructure tempDataStructure = RuntimeEngine.getInstance().isHTML5Framework() ? (tableName.toLowerCase().endsWith("_attachment") ? new JSAttachmentItem(tableName) : new JSDataStructure(tableName, false)) : (tableName.toLowerCase().endsWith("_attachment") ? new AttachmentItem(tableName) : (IDataStructure)Class.forName(className.getName()).newInstance());
                return tempDataStructure instanceof AttachmentItem;
            }
            catch (IllegalAccessException e) {
                Logger.log(8, "Attachment", "isAttachmentTable", "IllegalAccessException: " + e.getMessage());
                throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "IllegalAccessException caught while deleting attachment item , " + e.getMessage());
            }
            catch (InstantiationException e) {
                Logger.log(8, "Attachment", "isAttachmentTable", "InstantiationException: " + e.getMessage());
                throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "InstantiationException caught while deleting attachment item , " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                Logger.log(8, "Attachment", "isAttachmentTable", "ClassNotFoundException: " + e.getMessage());
                throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "ClassNotFoundException caught while deleting attachment item , " + e.getMessage());
            }
        }
        return false;
    }

    public static void delete(String tableName, String whereClause) throws DBException {
        AttachmentItem attachmentItem = null;
        IDataStructure[] attachmentItems = ApplicationManager.getInstance().getDataManager().get(tableName, whereClause);
        if (attachmentItems != null && attachmentItems.length > 0) {
            for (int i = 0; i < attachmentItems.length; ++i) {
                attachmentItem = (AttachmentItem)attachmentItems[i];
                attachmentItem.delete();
            }
        }
    }

    public static void cleanUpUnUsedFiles() {
        Attachment attachment = new Attachment();
        attachment.getClass();
        CleanUpUnusedFiles loadData = attachment.new CleanUpUnusedFiles();
        loadData.execute(new Void[0]);
    }

    private static void cleanUpAttachments() {
        try {
            Vector<String> files = Attachment.getAllFilesOnDisk();
            BusinessEntityMeta[] metas = ApplicationManager.getInstance().getBusinessEntitiesMeta();
            if (metas != null && metas.length > 0) {
                for (int i = 0; i < metas.length; ++i) {
                    BusinessEntityMeta businessEntityMeta = metas[i];
                    boolean attachmentSupported = businessEntityMeta.isAttachmentSupported();
                    if (!attachmentSupported) continue;
                    String beName = businessEntityMeta.getBeName();
                    StructureMeta structureMeta = ApplicationManager.getInstance().getHeaderStructureMeta(beName);
                    String structName = structureMeta.getStructName();
                    String tempClassName = DataStructureTableMapping.getInstance().getClassName(structName);
                    Class<?> className = null;
                    IDataStructure tempDataStructure = null;
                    if (tempClassName == null) continue;
                    try {
                        className = Class.forName(tempClassName);
                        tempDataStructure = RuntimeEngine.getInstance().isHTML5Framework() ? (structName.toLowerCase().endsWith("_attachment") ? new JSAttachmentItem(structName) : new JSDataStructure(structName, false)) : (structName.toLowerCase().endsWith("_attachment") ? new AttachmentItem(structName) : (IDataStructure)Class.forName(className.getName()).newInstance());
                    }
                    catch (Exception e) {
                        Logger.log(8, "Attachment", "cleanUpAttachments", "Excepton while creating an instance of a class type using Class.forName(className.getName()).newInstance(): " + className);
                        return;
                    }
                    if (tempDataStructure == null) continue;
                    String[] tableNames = tempDataStructure.getChildrenTableNames();
                    for (int j = 0; j < tableNames.length; ++j) {
                        IDataStructure[] dataStructures;
                        String tableName = tableNames[j];
                        if (!tableName.endsWith("_ATTACHMENT") || (dataStructures = ApplicationManager.getInstance().getDataManager().get(tableName)) == null || dataStructures.length <= 0) continue;
                        for (int k = 0; k < dataStructures.length; ++k) {
                            AttachmentItem attachmentItem = (AttachmentItem)dataStructures[k];
                            String fileName = attachmentItem.getFileName();
                            if (!files.contains(fileName)) continue;
                            files.remove(fileName);
                        }
                    }
                }
            }
            Attachment.deleteFiles(files);
        }
        catch (DBException e) {
            Logger.log(8, "Attachment", "cleanUpAttachments", "DBException: " + e.getMessage());
        }
    }

    private static Vector<String> getAllFilesOnDisk() {
        File[] listOfFiles;
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.ATTACHMENT_FOLDER);
        if (localPath == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "getAllFilesOnDisk", "Cannot get local path to get all attachment files");
            return null;
        }
        Vector<String> files = new Vector<String>();
        File file = new File(localPath);
        if (file.exists() && (listOfFiles = file.listFiles()) != null) {
            String fileName = null;
            for (int i = 0; i < listOfFiles.length; ++i) {
                File fileItem = listOfFiles[i];
                if (fileItem.isDirectory()) continue;
                fileName = fileItem.getName();
                files.add(fileName);
            }
        }
        return files;
    }

    public static void deleteFiles(Vector<String> files) {
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.ATTACHMENT_FOLDER);
        if (localPath == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "deleteFiles", "Cannot get local path to delete attachment folder");
            return;
        }
        File file = new File(localPath);
        if (file.exists()) {
            for (int i = 0; i < files.size(); ++i) {
                String fileName = files.elementAt(i);
                file = new File(localPath, fileName);
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    public static void deleteFilesAndFolder() {
        Vector<String> filesOnDisk = Attachment.getAllFilesOnDisk();
        Attachment.deleteFiles(filesOnDisk);
        Attachment.deleteAttachmentFolder();
    }

    private static void deleteAttachmentFolder() {
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.ATTACHMENT_FOLDER);
        if (localPath == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "deleteAttachmentFolder", "Cannot get local path to delete attachment folder");
            return;
        }
        File file = new File(localPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public static boolean copyAllFilesToLocalPath(AttachmentItem[] items) {
        boolean allFIlesCopied = true;
        for (int i = 0; i < items.length; ++i) {
            AttachmentItem attachmentItem = items[i];
            allFIlesCopied = Attachment.copyToApplicationLocalPath(attachmentItem);
        }
        return allFIlesCopied;
    }

    public static boolean copyToApplicationLocalPath(AttachmentItem attachment) {
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.ATTACHMENT_FOLDER);
        if (localPath == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "copyToApplicationLocalPath", "Cannot get local path to save for attachment file. BE Name: " + attachment.getBEName() + "Lid : " + attachment.getLid());
            return false;
        }
        String path = attachment.getLocalPath();
        String fileName = attachment.getFileName();
        File inboxDir = new File(localPath);
        if (!inboxDir.exists()) {
            inboxDir.mkdirs();
        }
        File sourceFile = new File(path);
        File destFile = new File(localPath, fileName);
        if (sourceFile.getAbsolutePath().equals(destFile.getAbsolutePath()) && destFile.length() > 0L) {
            return true;
        }
        File directory = destFile.getParentFile();
        if (directory != null && !directory.exists() && !directory.mkdirs()) {
            Logger.log(8, "Attachment", "copyToApplicationLocalPath", "Cannot create dir " + directory.getAbsolutePath());
            return false;
        }
        try {
            FileInputStream fIn = new FileInputStream(sourceFile);
            FileOutputStream fOut = new FileOutputStream(destFile);
            int length = 0;
            byte[] bytes = new byte[1024];
            while ((length = ((InputStream)fIn).read(bytes)) > 0) {
                ((OutputStream)fOut).write(bytes, 0, length);
            }
        }
        catch (FileNotFoundException e) {
            Logger.log(8, "Attachment", "copyToApplicationLocalPath", "File not found exception while opening files for copy purpose: " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            Logger.log(8, "Attachment", "copyToApplicationLocalPath", "IO Exception exception while dealing with file input n out put streams, for copy purpose: " + e.getMessage());
            return false;
        }
        attachment.setLocalPath(destFile.getPath());
        try {
            ApplicationManager.getInstance().getDataManager().insertOrUpdateBasedOnGID(attachment);
        }
        catch (DBException e) {
            Logger.log(8, "Attachment", "copyToApplicationLocalPath", "DB Exception exception while updating attachment item's local path to the application's local path after copying the file: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static void checkAttachmentAndQueueAutoDownload(IDataStructure itemDataStructure) {
        if (itemDataStructure instanceof AttachmentItem) {
            AttachmentItem attachmentItem = (AttachmentItem)itemDataStructure;
            attachmentItem.setAttachmentStatus(AttachmentItem.ATTACHMENT_ITEM_STATUS.DEFAULT);
            if (attachmentItem.isAutoDownloadRequired() && !Attachment.checkIfFileExists(attachmentItem.getFileName())) {
                Attachment.queueForDownload((AttachmentItem)itemDataStructure, "2");
            }
        }
    }

    private static boolean checkIfFileExists(String fileName) {
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.ATTACHMENT_FOLDER);
        if (localPath == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "checkIfFileExists", "Cannot get local path to check for attachment file. File Name :" + fileName);
            return false;
        }
        File file = new File(localPath);
        return file.exists() && (file = new File(localPath, fileName)).exists();
    }

    public static String renameFile(String fileName, String fileNameToBeSavedAs) {
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.ATTACHMENT_FOLDER);
        if (localPath == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "renameFile", "Cannot get local path to rename attachment files");
            return fileName;
        }
        File file = new File(localPath, fileName);
        File newFile = new File(localPath, fileNameToBeSavedAs);
        if (file.exists()) {
            file.renameTo(newFile);
        }
        return newFile.getPath();
    }

    public static String setFileNameWithUid(AttachmentItem attachmentItem) {
        String attachmentFileName = attachmentItem.getFileName();
        String uid = attachmentItem.getUid();
        String fileName = null;
        String fileExtension = null;
        String fileNameToBeSavedAs = null;
        if (attachmentFileName == null) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, "Attachment", "setFileNameWithUid", "File name is empty. Saving the file only with the UID");
            }
            attachmentFileName = "";
            fileName = uid;
            fileExtension = "";
        } else if (attachmentFileName.lastIndexOf(".") == -1) {
            fileName = attachmentFileName;
            fileExtension = "";
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, "Attachment", "setFileNameWithUid", "File name has no extension in it's name. Saving the file without ext name");
            }
        } else {
            fileName = attachmentFileName.substring(0, attachmentFileName.lastIndexOf("."));
            fileExtension = attachmentFileName.substring(attachmentFileName.lastIndexOf(".") + 1);
        }
        fileNameToBeSavedAs = !fileName.startsWith(uid) ? uid + "_" + fileName + "." + fileExtension : fileName + "." + fileExtension;
        return fileNameToBeSavedAs;
    }

    private class CleanUpUnusedFiles
    extends AsyncTask<Void, Void, Void> {
        private CleanUpUnusedFiles() {
        }

        protected Void doInBackground(Void ... params) {
            try {
                Attachment.cleanUpAttachments();
            }
            catch (Exception e) {
                Logger.log(8, ((Object)((Object)this)).getClass().getName(), "doInBackground", "Exception caught while cleaning up un used files from the sd card, " + e.getMessage());
            }
            return null;
        }

        protected void onPostExecute(Void voids) {
        }
    }
}

