/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.attachment;

import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentItem;
import com.unvired.model.AttachmentQObject;
import com.unvired.model.InfoMessage;
import com.unvired.model.StructureMeta;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.attachment.AttachmentQHelper;
import com.unvired.sync.connection.URLService;
import com.unvired.sync.notifier.NotificationListener;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.sync.response.FileResponse;
import com.unvired.sync.response.HTTPResponse;
import com.unvired.sync.response.ISyncResponse;
import com.unvired.utils.NetworkUtil;
import java.io.IOException;
import java.util.Vector;

public class AttachmentDownloader {
    private static AttachmentDownloader attachmentDownloader = null;
    private boolean stop = false;
    private AttachmentQHelper attachmentQ = AttachmentQHelper.getInstance();
    private AttachmentDownloadThread attachmentDownloadThread;
    private NotificationListener notificationListener;
    private int numberOfTries = 0;

    private AttachmentDownloader() {
    }

    public static AttachmentDownloader getInstance() {
        if (attachmentDownloader == null) {
            attachmentDownloader = new AttachmentDownloader();
        }
        return attachmentDownloader;
    }

    public void start() {
        if (this.attachmentDownloadThread == null) {
            this.stop = false;
            this.attachmentDownloadThread = new AttachmentDownloadThread();
            this.attachmentDownloadThread.setPriority(1);
            this.attachmentDownloadThread.start();
        } else {
            this.notifyObjectThread();
        }
    }

    public void notifyThread(String guid) {
        if (this.attachmentDownloadThread == null) {
            this.stop = false;
            this.attachmentDownloadThread = new AttachmentDownloadThread();
            this.attachmentDownloadThread.setPriority(1);
            this.attachmentDownloadThread.start();
        } else if (this.attachmentDownloadThread.isAlive()) {
            this.notifyObjectThread();
        }
    }

    public boolean isAlive() {
        return this.attachmentDownloadThread != null;
    }

    public void queueAttachment(AttachmentItem attachmentItem, String priority) {
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        try {
            if (applicationManager.isInDemoMode()) {
                return;
            }
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        String beName = attachmentItem.getBEName();
        String beAttachmentStructName = attachmentItem.getTableName();
        StructureMeta headerStructureMeta = null;
        try {
            headerStructureMeta = applicationManager.getHeaderStructureMeta(beName);
        }
        catch (DBException e1) {
            Logger.log(8, this.getClass().getName(), "queueAttachment", "DBException while getting structureMeta : " + e1.getMessage());
            return;
        }
        String beHeaderName = headerStructureMeta.getStructName();
        String uid = attachmentItem.getUid();
        long timestamp = System.currentTimeMillis();
        AttachmentQObject attachmentItemQ = new AttachmentQObject();
        attachmentItemQ.setBEAttachmentStructName(beAttachmentStructName);
        attachmentItemQ.setBEHeaderName(beHeaderName);
        attachmentItemQ.setBEName(beName);
        attachmentItemQ.setUID(String.valueOf(uid));
        attachmentItemQ.setPRIORITY(priority);
        attachmentItemQ.setTimestamp(timestamp);
        try {
            AttachmentQHelper.getInstance().add(attachmentItemQ);
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getName(), "queueAttachment", "DBException : " + e.getMessage());
        }
        catch (ApplicationException e) {
            Logger.log(8, this.getClass().getName(), "queueAttachment", "Application Exception: " + e.getMessage());
        }
        attachmentItem.setAttachmentStatus(AttachmentItem.ATTACHMENT_ITEM_STATUS.QUEUED_FOR_DOWNLOAD);
        try {
            attachmentItem.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
            attachmentItem.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
            ApplicationManager.getInstance().getDataManager().insertOrUpdateBasedOnGID(attachmentItem);
        }
        catch (DBException e) {
            Logger.log(8, "", "", "DBException while updating the attachment item status to queued for download: " + e.getMessage());
        }
        this.start();
    }

    public void stop() {
        try {
            this.stop = true;
            if (NetworkUtil.isEmulator()) {
                Logger.log(7, this.getClass().getName(), "stop", "Data Sender STOP instruction");
            }
            if (this.attachmentDownloadThread == null) {
                return;
            }
            this.attachmentDownloadThread.interrupt();
            this.attachmentDownloadThread.join();
        }
        catch (InterruptedException e) {
            Logger.log(8, this.getClass().getName(), "stop", "Data Sender Interrupted: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            Logger.log(8, this.getClass().getName(), "stop", "Data Sender Exception: " + e.getMessage());
        }
        catch (Throwable e) {
            Logger.log(8, this.getClass().getName(), "stop", "Data Sender Exception: " + e.getMessage());
        }
        finally {
            this.attachmentDownloadThread = null;
            attachmentDownloader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObjectThread() {
        AttachmentDownloader attachmentDownloader = this;
        synchronized (attachmentDownloader) {
            this.notify();
        }
    }

    class AttachmentDownloadThread
    extends Thread {
        AttachmentDownloadThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Logger.log(7, this.getClass().getName(), "run", "Attachment downloader Start - " + this.getName());
            try {
                block9: while (true) {
                    Vector<AttachmentItem> items = null;
                    try {
                        items = AttachmentDownloader.this.attachmentQ.getAllItems();
                    }
                    catch (DBException dbException) {
                        Logger.log(8, this.getClass().getName(), "run", "DBException caught while getting next AttachmentQ from database, " + dbException.getMessage());
                        AttachmentDownloader.this.attachmentDownloadThread = null;
                        return;
                    }
                    if (AttachmentDownloader.this.stop || items == null || items.size() == 0) {
                        if (NetworkUtil.isEmulator()) {
                            if (AttachmentDownloader.this.stop) {
                                if (Logger.getDefaultLogLevel() == 9) {
                                    Logger.log(9, "Class: " + this.getClass().getName(), "Method: run", "Message: Data Sender STOPPED - " + this.getName());
                                }
                            } else if (Logger.getDefaultLogLevel() == 9) {
                                Logger.log(9, "Class: " + this.getClass().getName(), "Method: run", "Message: Data Sender STOPPED as no out objects " + this.getName());
                            }
                        }
                        AttachmentDownloader.this.attachmentDownloadThread = null;
                        return;
                    }
                    if (NetworkUtil.isEmulator() || items == null || items.size() <= 0) continue;
                    if (NetworkUtil.hasCoverage(true)) {
                        AttachmentItem item = null;
                        int i = 0;
                        while (true) {
                            if (i >= items.size()) continue block9;
                            item = items.elementAt(i);
                            this.processAttachmentQ(item);
                            ++i;
                        }
                    }
                    AttachmentDownloadThread attachmentDownloadThread = this;
                    synchronized (attachmentDownloadThread) {
                        try {
                            AttachmentDownloadThread.sleep(240000L);
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.log(8, this.getClass().getName(), "run", "InterruptedException caught while going to wait condition because no connectivity is there, " + interruptedException.getMessage());
                            return;
                        }
                    }
                }
            }
            catch (ApplicationException e) {
                Logger.log(8, this.getClass().getName(), "run", "ApplicationException caught while processing server request, " + e.getMessage());
                return;
            }
            catch (DBException e) {
                Logger.log(8, this.getClass().getName(), "run", "DBException caught while processing server request, " + e.getMessage());
                return;
            }
        }

        private synchronized void processAttachmentQ(AttachmentItem attachmentItem) throws ApplicationException, DBException {
            if (attachmentItem == null) {
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.log(9, this.getClass().getName(), "processOutbox", "No AttachmentQ to send");
                }
            } else {
                this.submitRequest(attachmentItem);
            }
        }

        private synchronized void submitRequest(AttachmentItem attachmentItem) throws ApplicationException, DBException {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "submitRequest", "AttachmentQ to send: submitRequest started");
            }
            FileResponse fileResponse = null;
            FileResponse.FILE_RESPONSE_STATUS fileStatus = null;
            fileResponse = this.downloadAttachment(attachmentItem);
            fileStatus = fileResponse.getFileStatus();
            if (fileResponse.getResponseStatus() == ISyncResponse.RESPONSE_STATUS.SUCCESS) {
                switch (fileStatus) {
                    case ERROR: {
                        this.handleErrorMessage(fileResponse, attachmentItem);
                        return;
                    }
                    case WAIT: {
                        try {
                            if (Logger.getDefaultLogLevel() == 9) {
                                Logger.log(9, this.getClass().getName(), "submitRequest", "File is in WAIT Status");
                            }
                            Thread.sleep(120000L);
                        }
                        catch (InterruptedException e) {
                            Logger.log(8, this.getClass().getName(), "submitRequest", "Attachment Downloader interrupted.. Exception: " + e.getMessage());
                        }
                        break;
                    }
                    case SUCCESS: {
                        AttachmentQHelper.getInstance().remove(attachmentItem);
                        this.handleAttachmentDownloadSuccess(fileResponse, attachmentItem);
                        return;
                    }
                }
            } else {
                this.handleOthers(fileResponse, attachmentItem);
            }
        }

        private void handleOthers(final HTTPResponse httpResponse, final AttachmentItem attachmentItem) {
            AttachmentDownloader.this.numberOfTries++;
            if (AttachmentDownloader.this.numberOfTries >= 3) {
                AttachmentDownloader.this.numberOfTries = 0;
                try {
                    attachmentItem.setAttachmentStatus(AttachmentItem.ATTACHMENT_ITEM_STATUS.ERROR_IN_DOWNLOAD);
                    attachmentItem.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                    attachmentItem.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                    ApplicationManager.getInstance().getDataManager().insertOrUpdateBasedOnGID(attachmentItem);
                    AttachmentDownloader.this.attachmentQ.remove(attachmentItem);
                }
                catch (DBException dbException) {
                    Logger.log(8, this.getClass().getName(), " handleAttachmentDownloadError ", " DBException caught while deleting AttachmentQ from database, AttachmentQ LID: " + attachmentItem.getLid() + " " + dbException.getMessage());
                }
                this.createInfoMessage(attachmentItem, httpResponse.getErrorMessage() + " Max attempts to download exceeded. Deleting AttachmentQObject. Please download again.");
                AttachmentDownloader.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.d("Attachment download failed");
                }
                if (AttachmentDownloader.this.notificationListener != null) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            AttachmentDownloader.this.notificationListener.notifyAttachmentDownloadFailure(attachmentItem, httpResponse.getErrorMessage() + " Max attempts to download exceeded. Deleting AttachmentQObject. Please download again.");
                        }
                    });
                    t.start();
                }
                return;
            }
            int responseCode = httpResponse.getResponseCode();
            String errorMessage = httpResponse.getErrorMessage();
            Logger.log(8, this.getClass().getName(), "submitRequest", "HTTP response error. Response code: " + responseCode + " Response message: " + errorMessage);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                Logger.log(8, this.getClass().getName(), "submitRequest", "Attachment Downloader interrupted.. Exception: " + e.getMessage());
                return;
            }
        }

        private FileResponse downloadAttachment(AttachmentItem attachmentItem) {
            FileResponse fileResponse = null;
            String connectionUrl = attachmentItem.getUrl();
            String externalURL = attachmentItem.getExternalUrl();
            String guid = attachmentItem.getUid();
            boolean requiredUNIPostParameters = true;
            if ("X".equalsIgnoreCase(externalURL)) {
                requiredUNIPostParameters = false;
            } else {
                requiredUNIPostParameters = true;
                try {
                    connectionUrl = URLService.getAttachmentMessageURL();
                }
                catch (ApplicationException e) {
                    Logger.log(8, "AttachmentDownloader", "downloadAttachment", "Application Exception while getting attachment based url: " + e.getMessage());
                    return null;
                }
                catch (DBException e) {
                    Logger.log(8, "AttachmentDownloader", "downloadAttachment", "Database Exception while getting attachment based url: " + e.getMessage());
                    return null;
                }
            }
            fileResponse = HTTPConnection.downloadAttachment(attachmentItem, connectionUrl, guid, requiredUNIPostParameters);
            return fileResponse;
        }

        private void handleErrorMessage(FileResponse fileResponse, final AttachmentItem attachmentItem) throws DBException {
            String errorMessage = fileResponse.getErrorMessage();
            try {
                attachmentItem.setAttachmentStatus(AttachmentItem.ATTACHMENT_ITEM_STATUS.ERROR_IN_DOWNLOAD);
                attachmentItem.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                attachmentItem.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                ApplicationManager.getInstance().getDataManager().insertOrUpdateBasedOnGID(attachmentItem);
                AttachmentDownloader.this.attachmentQ.remove(attachmentItem);
            }
            catch (DBException dbException) {
                Logger.log(8, "", "", "DBException caught while deleting AttachmentQ from database, AttachmentQ LID: " + attachmentItem.getLid() + ", " + dbException.getMessage());
                throw new DBException(this.getClass().getName(), "submitRequest", "DBException caught while deleting AttachmentQ from database, AttachmentQ LID: " + attachmentItem.getLid() + ", " + dbException.getMessage());
            }
            this.createInfoMessage(attachmentItem, errorMessage);
            AttachmentDownloader.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("Attachment download failed");
            }
            final String errorMsg = errorMessage;
            if (AttachmentDownloader.this.notificationListener != null) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AttachmentDownloader.this.notificationListener.notifyAttachmentDownloadFailure(attachmentItem, errorMsg);
                    }
                });
                t.start();
            }
        }

        private boolean handleAttachmentDownloadSuccess(FileResponse fileResponse, final AttachmentItem attachmentItem) throws ApplicationException, DBException {
            if (fileResponse.getResponseStatus() == ISyncResponse.RESPONSE_STATUS.SUCCESS) {
                try {
                    this.saveFile(attachmentItem);
                }
                catch (Exception e) {
                    try {
                        attachmentItem.setAttachmentStatus(AttachmentItem.ATTACHMENT_ITEM_STATUS.ERROR_IN_DOWNLOAD);
                        attachmentItem.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                        attachmentItem.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                        ApplicationManager.getInstance().getDataManager().insertOrUpdateBasedOnGID(attachmentItem);
                        AttachmentDownloader.this.attachmentQ.remove(attachmentItem);
                    }
                    catch (DBException dbException) {
                        Logger.log(8, "", "", "DBException caught while deleting AttachmentQ from database, AttachmentQ LID: " + attachmentItem.getLid() + ", " + dbException.getMessage());
                        throw new DBException(this.getClass().getName(), "submitRequest", "DBException caught while deleting AttachmentQ from database, AttachmentQ LID: " + attachmentItem.getLid() + ", " + dbException.getMessage());
                    }
                    AttachmentDownloader.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                    if (Logger.getDefaultLogLevel() == 9) {
                        Logger.d("Attachment download failed");
                    }
                    final String errorMsg = e.getMessage();
                    if (AttachmentDownloader.this.notificationListener != null) {
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                AttachmentDownloader.this.notificationListener.notifyAttachmentDownloadFailure(attachmentItem, errorMsg);
                            }
                        });
                        t.start();
                    }
                    return false;
                }
            }
            try {
                AttachmentDownloader.this.attachmentQ.remove(attachmentItem);
            }
            catch (DBException dbException) {
                Logger.log(8, this.getClass().getName(), "handleAttachmentDownloadSuccess", "DBException caught while deleting AttachmentQ from database, AttachmentQ LID: " + attachmentItem.getLid() + ", " + dbException.getMessage());
                throw new ApplicationException(this.getClass().getName(), "handleAttachmentDownloadSuccess", "DBException caught while deleting AttachmentQ from database, AttachmentQ LID: " + attachmentItem.getLid() + ", " + dbException.getMessage());
            }
            AttachmentDownloader.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("Attachment download success");
            }
            if (AttachmentDownloader.this.notificationListener != null) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AttachmentDownloader.this.notificationListener.notifyAttachmentDownloadSuccess(attachmentItem);
                    }
                });
                t.start();
            }
            return true;
        }

        private void createInfoMessage(AttachmentItem attachmentItem, String message) {
            InfoMessage infoMessage = new InfoMessage();
            infoMessage.setBeLid(attachmentItem.getFid());
            infoMessage.setBeName(attachmentItem.getBEName());
            infoMessage.setCategory("FAILURE");
            infoMessage.setMessage(message);
            try {
                FrameworkManager.getInstance().getDataManager().insert(infoMessage);
            }
            catch (DBException e) {
                Logger.log(8, this.getClass().getName(), "createInfoMessage", "DBException caught while inserting Info Message: " + e.getMessage());
            }
        }

        private void saveFile(AttachmentItem attachmentItem) throws DBException, IOException {
            attachmentItem.setAttachmentStatus(AttachmentItem.ATTACHMENT_ITEM_STATUS.DOWNLOADED);
            attachmentItem.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
            attachmentItem.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
            ApplicationManager.getInstance().getDataManager().insertOrUpdateBasedOnGID(attachmentItem);
            Logger.log(7, "AttachmentDownloader", "saveFile", "File saved and attachment item status updated: " + attachmentItem.getLocalPath());
        }
    }
}

