/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.attachment;

import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentItem;
import com.unvired.model.AttachmentQObject;
import com.unvired.utils.Utils;
import java.util.Vector;

public class AttachmentQHelper {
    private static AttachmentQHelper attachmentQHelper = null;
    private IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
    private IDataManager applicationDataManager = null;

    private AttachmentQHelper() {
    }

    public static AttachmentQHelper getInstance() {
        if (attachmentQHelper == null) {
            attachmentQHelper = new AttachmentQHelper();
        }
        return attachmentQHelper;
    }

    public static void destroy() {
        if (attachmentQHelper != null) {
            AttachmentQHelper.attachmentQHelper.applicationDataManager = null;
            AttachmentQHelper.attachmentQHelper.frameworkDataManager = null;
            attachmentQHelper = null;
            Logger.log(7, AttachmentQHelper.class.getName(), "destroy", "Destroyed");
        } else {
            Logger.log(7, AttachmentQHelper.class.getName(), "destroy", "Destroy not required. Already null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AttachmentQObject attachmentObject) throws DBException, ApplicationException {
        if (attachmentObject == null) {
            Logger.log(8, this.getClass().getName(), "add", "ATTACHMENT_Q cannot be null.");
            return;
        }
        AttachmentQObject attachmentQObject = attachmentObject;
        String savePointName = Utils.getSavePointName();
        this.frameworkDataManager.createSavepoint(savePointName);
        try {
            String whereClause = "UID = '" + attachmentQObject.getUID() + "'";
            int count = this.frameworkDataManager.count(AttachmentQObject.TABLE_NAME, whereClause);
            if (count == 0) {
                this.frameworkDataManager.insert(attachmentQObject);
            }
        }
        catch (Exception e) {
            this.frameworkDataManager.rollbackToSavepoint(savePointName);
        }
        finally {
            this.frameworkDataManager.releaseSavepoint(savePointName);
        }
    }

    public void remove(AttachmentItem attachmentItem) throws DBException {
        if (attachmentItem == null) {
            Logger.log(8, this.getClass().getName(), "remove", "ATTACHMENT_Q cannot be null.");
            return;
        }
        String uid = attachmentItem.getUid();
        this.remove(uid);
    }

    public void remove(String uid) throws DBException {
        if (uid == null) {
            Logger.log(8, this.getClass().getName(), "remove", "uid cannot be null");
        }
        String whereClause = AttachmentQObject.UID + " = '" + uid + "'";
        this.frameworkDataManager.delete(AttachmentQObject.TABLE_NAME, whereClause);
    }

    public void resetAll() throws DBException {
        this.frameworkDataManager.delete(AttachmentQObject.TABLE_NAME);
    }

    public AttachmentItem getNext() throws DBException {
        String[] orderBy = new String[]{AttachmentQObject.PRIORITY, "TIME_STAMP"};
        IDataStructure[] dataStructures = this.frameworkDataManager.get(AttachmentQObject.TABLE_NAME, orderBy, AttachmentQObject.class);
        if (dataStructures == null || dataStructures.length == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "getNext", "No attachmentobjects in database");
            }
            return null;
        }
        AttachmentQObject attachmentObject = (AttachmentQObject)dataStructures[0];
        String attachmentTableName = attachmentObject.getBEAttachmentStructName();
        String uid = attachmentObject.getUID();
        String whereClause = "UID = '" + uid + "'";
        try {
            if (this.applicationDataManager == null) {
                this.applicationDataManager = ApplicationManager.getInstance().getDataManager();
            }
        }
        catch (DBException e) {
            Logger.log(8, "AttachmentQHelper", "getNext", "DBException while getting application data manager: " + e.getMessage());
        }
        dataStructures = this.applicationDataManager.get(attachmentTableName, whereClause);
        if (dataStructures == null || dataStructures.length == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "getNext", "No attachmentobjects in database");
            }
            return null;
        }
        AttachmentItem attachmentItem = (AttachmentItem)dataStructures[0];
        return attachmentItem;
    }

    public void deleteIfQueuedForDownload(String uid) throws DBException {
        String whereClause;
        int count;
        if (uid == null || uid.length() <= 0) {
            return;
        }
        if (Logger.getDefaultLogLevel() == 9) {
            Logger.log(9, this.getClass().getName(), "contains", "UID: " + uid);
        }
        if ((count = this.frameworkDataManager.count(AttachmentQObject.TABLE_NAME, whereClause = AttachmentQObject.UID + " = '" + uid + "'")) != 0) {
            IDataStructure[] attachmentQObjects = this.frameworkDataManager.get(AttachmentQObject.TABLE_NAME, whereClause);
            if (attachmentQObjects != null && attachmentQObjects.length != 0) {
                this.frameworkDataManager.delete(attachmentQObjects[0]);
            }
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "contains", "AttachmentQObject present in database, UID: " + uid);
            }
            return;
        }
        if (Logger.getDefaultLogLevel() == 9) {
            Logger.log(9, this.getClass().getName(), "contains", "AttachmentQObject is not present in database, UID: " + uid);
        }
    }

    public Vector<AttachmentItem> getAllItems() throws DBException {
        Vector<AttachmentItem> items = null;
        String[] orderBy = new String[]{AttachmentQObject.PRIORITY, "TIME_STAMP"};
        IDataStructure[] dataStructures = null;
        if (this.frameworkDataManager != null) {
            dataStructures = this.frameworkDataManager.get(AttachmentQObject.TABLE_NAME, orderBy, AttachmentQObject.class);
        }
        if (dataStructures == null || dataStructures.length == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "getNext", "No attachmentobjects in database");
            }
            return null;
        }
        IDataStructure[] attachmentItems = null;
        AttachmentQObject attachmentObject = null;
        AttachmentItem attachmentItem = null;
        String attachmentTableName = null;
        String uid = null;
        String whereClause = null;
        items = new Vector<AttachmentItem>();
        int i = 0;
        while (i < dataStructures.length) {
            attachmentObject = (AttachmentQObject)dataStructures[i++];
            attachmentTableName = attachmentObject.getBEAttachmentStructName();
            uid = attachmentObject.getUID();
            whereClause = "UID = '" + uid + "'";
            try {
                if (this.applicationDataManager == null) {
                    this.applicationDataManager = ApplicationManager.getInstance().getDataManager();
                }
            }
            catch (DBException e) {
                Logger.log(8, "AttachmentQHelper", "getAllItems", "DBException while getting application data manager: " + e.getMessage());
            }
            attachmentItems = this.applicationDataManager.get(attachmentTableName, whereClause);
            if (attachmentItems == null || attachmentItems.length == 0) {
                if (Logger.getDefaultLogLevel() != 9) continue;
                Logger.log(9, this.getClass().getName(), "getNext", "No attachmentitem in database related to UID: " + uid);
                continue;
            }
            attachmentItem = (AttachmentItem)attachmentItems[0];
            items.add(attachmentItem);
        }
        return items;
    }
}

