/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.in;

import android.database.Cursor;
import android.database.SQLException;
import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.DataStructureTableMapping;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentItem;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.FieldMeta;
import com.unvired.model.InObject;
import com.unvired.model.InfoMessage;
import com.unvired.model.JSAttachmentItem;
import com.unvired.model.ReconcileObject;
import com.unvired.model.SentItemObject;
import com.unvired.model.StructureMeta;
import com.unvired.sync.SyncConstants;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.attachment.Attachment;
import com.unvired.sync.in.ConflictBE;
import com.unvired.sync.in.ConflictHandler;
import com.unvired.sync.in.IConflictHandler;
import com.unvired.sync.in.Inbox;
import com.unvired.sync.in.PullPushQueryBEReconciler;
import com.unvired.sync.in.RequestResponseBEReconciler;
import com.unvired.sync.notifier.DataNotification;
import com.unvired.sync.notifier.NotificationListener;
import com.unvired.sync.out.SentItems;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.Utils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import net.sqlcipher.CrossProcessCursorWrapper;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AsyncDataHandler
extends DefaultHandler {
    protected String conversationId = null;
    private String serverId = null;
    private String applicationId = null;
    private String applicationName = null;
    protected int messageType;
    private int messageSubType;
    protected SyncConstants.MESSAGE_REQUEST_TYPE requestType;
    protected StringBuffer tempValue = new StringBuffer();
    protected SyncConstants.BE_ACTION_TYPE currentBEAction;
    protected IDataStructure currentHeader = null;
    protected IDataStructure currentItem = null;
    protected Vector<IDataStructure> currentItems = null;
    protected String currentBEName;
    protected String currentHeaderName;
    protected String currentItemName;
    protected String currentFieldName;
    protected boolean headerInProcess = true;
    protected Hashtable<String, ReconcileObject> beHeaderMap = new Hashtable();
    protected Hashtable<String, ReconcileObject> beItemMap = new Hashtable();
    protected InfoMessage currentInfoMessage;
    protected boolean infoMessageTagStarted = false;
    protected Vector<DataNotification> dataNotifications;
    protected Vector<InfoMessage> infoMessageNotifications;
    protected boolean metaDataDeleteFlag = false;
    protected Vector<ConflictBE> conflictBEs;
    private String conflictRule;
    protected DataStructureTableMapping dataStructureTableMapping = null;
    protected ApplicationManager applicationManager;
    protected IDataManager applicationDataManager = null;
    protected IDataManager frameworkDataManager = null;
    protected NotificationListener notificationListener;
    protected IConflictHandler applicationConflictHandler;
    protected boolean stopParsing = false;
    private boolean requestedBEPresent = false;

    public AsyncDataHandler(InObject inObject) throws ApplicationException {
        String rqstSavePointName = Utils.getSavePointName();
        try {
            String timeStamp;
            block16: {
                this.dataStructureTableMapping = DataStructureTableMapping.getInstance();
                this.requestType = SyncConstants.MESSAGE_REQUEST_TYPE.valueOf(inObject.getRequestType());
                this.messageType = Integer.parseInt(inObject.getMessageType());
                this.messageSubType = Integer.parseInt(inObject.getMessageSubType());
                this.conversationId = inObject.getConversationId();
                this.serverId = inObject.getServerId();
                this.applicationId = inObject.getAppId();
                this.applicationName = inObject.getAppName();
                Logger.i("AsyncDataHandler: Start handling inObject for Conversation Id: " + this.conversationId);
                this.applicationManager = ApplicationManager.getInstance();
                SyncEngine syncEngine = SyncEngine.getInstance();
                this.notificationListener = syncEngine.getNotificationListener();
                this.applicationConflictHandler = syncEngine.getSyncConflictHandler();
                this.conflictBEs = new Vector();
                this.initialization();
                timeStamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.d("**************************** Response parsing started for call : " + timeStamp);
                }
                if (this.requestType == SyncConstants.MESSAGE_REQUEST_TYPE.RQST) {
                    try {
                        this.requestedBEPresent = false;
                        this.applicationDataManager.createSavepoint(rqstSavePointName);
                    }
                    catch (DBException e) {
                        e.printStackTrace();
                    }
                }
                this.parseDocument();
                if (this.requestType == SyncConstants.MESSAGE_REQUEST_TYPE.RQST) {
                    try {
                        if (this.requestedBEPresent) {
                            this.applicationDataManager.releaseSavepoint(rqstSavePointName);
                            SentItemObject sentItemObject = SentItems.getInstance().getByConvId(this.conversationId);
                            if (null != sentItemObject) {
                                Logger.i("AsyncDataHandler: handleRequestResponse. Deleting sentItemObject: BE Name-BE Lid-Sent Item Lid" + this.currentHeaderName + "-" + sentItemObject.getBeHeaderLid() + "-" + sentItemObject.getLid());
                                FrameworkManager.getInstance().getDataManager().delete(sentItemObject);
                            } else {
                                Logger.i("AsyncDataHandler: handleRequestResponse. SentItemObject: IS NULL or Already deleted in parse document: Comversation id: " + this.conversationId + " Item Lid" + this.currentHeaderName + "-");
                            }
                            break block16;
                        }
                        if (this.stopParsing) {
                            this.applicationDataManager.releaseSavepoint(rqstSavePointName);
                            SentItemObject sentItemObject = SentItems.getInstance().getByConvId(this.conversationId);
                            if (null != sentItemObject) {
                                Logger.i("AsyncDataHandler: handleRequestResponse. Deleting sentItemObject: BE Name-BE Lid-Sent Item Lid" + this.currentHeaderName + "-" + sentItemObject.getBeHeaderLid() + "-" + sentItemObject.getLid());
                                FrameworkManager.getInstance().getDataManager().delete(sentItemObject);
                            } else {
                                Logger.i("AsyncDataHandler: handleRequestResponse. SentItemObject: IS NULL or Already deleted in parse document: Comversation id: " + this.conversationId + " Item Lid" + this.currentHeaderName + "-");
                            }
                            break block16;
                        }
                        this.applicationDataManager.rollbackToSavepoint(rqstSavePointName);
                        this.applicationDataManager.releaseSavepoint(rqstSavePointName);
                        String error = "Sent items BE do not match with any Incoming BEs. Ignoring data. Conversation Id: " + this.conversationId;
                        throw new ApplicationException(this.getClass().getName(), "handleRequestResponse", error);
                    }
                    catch (DBException e) {
                        Logger.e(e.getMessage());
                    }
                }
            }
            timeStamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("**************************** Response parsing finished for call : " + timeStamp);
            }
        }
        catch (ApplicationException e) {
            Logger.e("Exception while handling system message. Exception: " + e.getMessage() + " Conversation Id: " + this.conversationId, e);
            this.deleteProcessedMessageFromInbox();
            throw e;
        }
    }

    public abstract void parseDocument() throws ApplicationException;

    private void initialization() throws ApplicationException {
        String error = null;
        if (this.messageType != 8000) {
            error = "Invalid message type. Message Type: " + this.messageType;
        } else if (this.messageSubType != 600 && this.messageSubType != 800) {
            error = "Invalid message sub type. Native messages have to be processed by the application. Framework cannot process. ConversationId: " + this.conversationId;
        } else if (this.conversationId == null || this.conversationId.length() <= 0) {
            error = "Conversation Id from server found as empty.";
        } else if (this.serverId == null || this.serverId.length() <= 0) {
            error = "Server Id from server found as empty. Conversation Id: " + this.conversationId;
        }
        if (error != null) {
            Logger.log(7, this.getClass().getName(), "initialization", error);
            throw new ApplicationException(this.getClass().getName(), "initialization", error);
        }
        Logger.log(7, this.getClass().getName(), "initialization", "CONVERSATION ID: " + this.conversationId + " SERVER ID: " + this.serverId + " MSG TYPE: " + this.messageType + " MSG SUB TYPE: " + this.messageSubType + " REQUEST TYPE: " + (Object)((Object)this.requestType));
        this.dataStructureTableMapping = DataStructureTableMapping.getInstance();
        try {
            this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
            this.applicationDataManager = this.applicationManager.getDataManager();
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while getting application data manager, ", dbException);
            throw new ApplicationException(this.getClass().getName(), "initialization", "DBException caught while getting application data manager, " + dbException.getMessage());
        }
    }

    protected void updateStatusFromConversationId() throws ApplicationException, DBException {
        IDataStructure headerDataStructure = null;
        if (SyncConstants.MESSAGE_REQUEST_TYPE.RQST == this.requestType) {
            SentItemObject sentItemObject = SentItems.getInstance().getByConvId(this.conversationId);
            String beLid = sentItemObject.getBeHeaderLid();
            String beName = sentItemObject.getBeName();
            Logger.i("AsyncDataHandler: updateStatusFromConversationId Conversation Id: " + this.conversationId + " BE LID-Name: " + beLid + "-" + beName);
            try {
                StructureMeta structureMeta = this.applicationManager.getHeaderStructureMeta(beName);
                String headerName = structureMeta.getStructName();
                if (beLid != null && headerName != null && headerName.length() > 0) {
                    String whereClause = "LID='" + beLid + "'";
                    IDataStructure[] dataStructures = null;
                    dataStructures = this.applicationDataManager.get(headerName, whereClause);
                    if (dataStructures != null && dataStructures.length > 0) {
                        headerDataStructure = dataStructures[0];
                    }
                }
                if (headerDataStructure == null) {
                    Logger.i("AsyncDataHandler: updateStatusFromConversationId Header data structure not found for conversation id: " + this.conversationId);
                    return;
                }
                headerDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                this.applicationDataManager.update(headerDataStructure);
                String[] childrenTableNames = headerDataStructure.getChildrenTableNames();
                if (childrenTableNames != null && childrenTableNames.length > 0) {
                    for (int i = 0; i < childrenTableNames.length; ++i) {
                        IDataStructure[] items = this.applicationDataManager.getChildren(childrenTableNames[i], headerDataStructure);
                        if (items == null || items.length <= 0) continue;
                        for (int j = 0; j < items.length; ++j) {
                            if (items[j].getSyncStatus() != IDataStructure.SYNC_STATUS.SENT) continue;
                            items[j].setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                            this.applicationDataManager.update(items[j]);
                        }
                    }
                }
            }
            catch (DBException e) {
                String error = "DBException caught while getting data from database, BE-NAME: " + beName + ", BE-LID: " + beLid + ", " + e.getMessage();
                Logger.e(error, e);
                throw new ApplicationException(this.getClass().getName(), "endElement", error);
            }
        }
    }

    protected void saveAllInfoMessages() throws ApplicationException, DBException {
        Long beLid = new Long(0L);
        String beName = "";
        Object infoMessageRelatedHeaderDataStructure = null;
        if (SyncConstants.MESSAGE_REQUEST_TYPE.RQST == this.requestType) {
            int size = this.infoMessageNotifications.size();
            for (int k = 0; k < size; ++k) {
                this.currentInfoMessage = this.infoMessageNotifications.elementAt(k);
                this.saveInfoMessages();
            }
        }
    }

    protected void saveInfoMessages() throws ApplicationException, DBException {
        String beLid = "";
        String beName = "";
        IDataStructure infoMessageRelatedHeaderDataStructure = null;
        if (SyncConstants.MESSAGE_REQUEST_TYPE.RQST == this.requestType) {
            SentItemObject sentItemObject = SentItems.getInstance().getByConvId(this.conversationId);
            if (sentItemObject == null) {
                Logger.i("AsyncDataHandler: saveInfoMessages sentItemObject not found for conversation id: " + this.conversationId);
            } else {
                beLid = sentItemObject.getBeHeaderLid();
                beName = sentItemObject.getBeName();
                this.currentInfoMessage.setBeLid(beLid);
                this.currentInfoMessage.setBeName(beName);
                Logger.i("AsyncDataHandler: saveInfoMessages Conversation Id: " + this.conversationId + " BE LID-Name: " + beLid + "-" + beName);
            }
            if (beName != null && beName.length() > 0) {
                try {
                    StructureMeta structureMeta = this.applicationManager.getHeaderStructureMeta(beName);
                    String headerName = structureMeta.getStructName();
                    Logger.i("AsyncXMLDataHandler: saveInfoMessages 6: " + headerName);
                    if (beLid != null && headerName != null && headerName.length() > 0) {
                        String whereClause = "LID='" + beLid + "'";
                        IDataStructure[] dataStructures = null;
                        dataStructures = this.applicationDataManager.get(headerName, whereClause);
                        if (dataStructures != null && dataStructures.length > 0 && (infoMessageRelatedHeaderDataStructure = dataStructures[0]) != null) {
                            if ("FAILURE".equals(this.currentInfoMessage.getCategory()) || "FAILURE_N_PROCESS".equals(this.currentInfoMessage.getCategory())) {
                                infoMessageRelatedHeaderDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.ERROR);
                            } else {
                                infoMessageRelatedHeaderDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                            }
                            this.applicationDataManager.update(infoMessageRelatedHeaderDataStructure);
                            String[] childrenTableNames = infoMessageRelatedHeaderDataStructure.getChildrenTableNames();
                            if (childrenTableNames != null && childrenTableNames.length > 0) {
                                for (int i = 0; i < childrenTableNames.length; ++i) {
                                    IDataStructure[] items = this.applicationDataManager.getChildren(childrenTableNames[i], infoMessageRelatedHeaderDataStructure);
                                    if (items == null || items.length <= 0) continue;
                                    for (int j = 0; j < items.length; ++j) {
                                        if (items[j].getSyncStatus() != IDataStructure.SYNC_STATUS.SENT) continue;
                                        items[j].setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                                        this.applicationDataManager.update(items[j]);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (DBException e) {
                    String error = "DBException caught while getting data from database, BE-NAME: " + beName + ", BE-LID: " + beLid + ", " + e.getMessage();
                    Logger.e(error, e);
                    throw new ApplicationException(this.getClass().getName(), "endElement", error);
                }
            }
        }
        try {
            FrameworkHelper.cleanUpInfoMessages();
            this.frameworkDataManager.insert(this.currentInfoMessage);
        }
        catch (Exception e) {
            Logger.log(8, this.getClass().getName(), "saveAllInfoMessages", "Exception caught while saving Info Messages." + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePullPushQuery() throws DBException {
        String savePointName;
        ReconcileObject reconcileObject;
        if (this.currentBEName != null) {
            BusinessEntityMeta businessEntityMeta = ApplicationManager.getInstance().getBusinessEntityMeta(this.currentBEName);
            if (businessEntityMeta == null) {
                Logger.e("handlePullPushQuery(): No BusinessEntityMeta found for BE :" + this.currentBEName + ". Ignoring this BE.");
            } else {
                this.conflictRule = businessEntityMeta.getConflictRule();
            }
        }
        if ((reconcileObject = this.beHeaderMap.get(this.getGID(this.currentHeader))) != null) {
            savePointName = Utils.getSavePointName();
            this.applicationDataManager.createSavepoint(savePointName);
            try {
                if (this.currentBEAction == SyncConstants.BE_ACTION_TYPE.D) {
                    Logger.i("AsyncDataHandler: handlePullPushQuery. Received delete request for BE. deleting BE: " + this.currentHeaderName);
                    this.applicationDataManager.delete(this.currentHeaderName, "LID = '" + reconcileObject.getLid() + "'");
                } else {
                    PullPushQueryBEReconciler pullPushQueryBEReconcile = new PullPushQueryBEReconciler(this.conflictRule);
                    ConflictBE conflictBE = pullPushQueryBEReconcile.reconcile(this.applicationDataManager, reconcileObject, this.currentHeader, this.currentItems);
                    if (conflictBE != null) {
                        this.conflictBEs.add(conflictBE);
                    }
                }
            }
            catch (Exception e) {
                String error = "Exception while processing inbox object. Conversation Id: " + this.conversationId + " Exception: " + e.getMessage();
                Logger.e(error, e);
                this.applicationDataManager.rollbackToSavepoint(savePointName);
            }
            finally {
                this.applicationDataManager.releaseSavepoint(savePointName);
            }
            this.currentHeader.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
        } else if (this.currentBEAction == SyncConstants.BE_ACTION_TYPE.D) {
            Logger.i("Received delete request for BE. Dose not exist BE: " + this.currentHeaderName);
        } else {
            savePointName = Utils.getSavePointName();
            this.applicationDataManager.createSavepoint(savePointName);
            try {
                this.currentHeader.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                this.currentHeader.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                this.applicationDataManager.insert(this.currentHeader);
                int size = this.currentItems.size();
                IDataStructure itemDataStructure = null;
                for (int i = 0; i < size; ++i) {
                    itemDataStructure = this.currentItems.elementAt(i);
                    itemDataStructure.setFid(this.currentHeader.getLid());
                    itemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                    itemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                    this.applicationDataManager.insert(itemDataStructure);
                    if (!(itemDataStructure instanceof AttachmentItem) && !(itemDataStructure instanceof JSAttachmentItem)) continue;
                    Attachment.checkAttachmentAndQueueAutoDownload(itemDataStructure);
                }
            }
            catch (Exception e) {
                String error = "Exception while processing inbox object.  Conversation Id: " + this.conversationId + " Exception: " + e.getMessage();
                Logger.e(error, e);
                this.applicationDataManager.rollbackToSavepoint(savePointName);
            }
            finally {
                this.applicationDataManager.releaseSavepoint(savePointName);
            }
        }
        DataNotification dataNotification = new DataNotification(this.currentBEName, SyncConstants.BE_ACTION_TYPE.M, this.currentHeader.getLid());
        this.dataNotifications.add(dataNotification);
    }

    protected void checkAttachmentAndQueueAutoDownload(IDataStructure itemDataStructure) {
        if (itemDataStructure instanceof AttachmentItem) {
            AttachmentItem attachmentItem = (AttachmentItem)itemDataStructure;
            attachmentItem.setAttachmentStatus(AttachmentItem.ATTACHMENT_ITEM_STATUS.DEFAULT);
            if (attachmentItem.isAutoDownloadRequired()) {
                Attachment.queueForDownload((AttachmentItem)itemDataStructure, "2");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequestResponse() throws DBException, ApplicationException {
        SentItemObject sentItemObject = SentItems.getInstance().getByConvId(this.conversationId);
        if (sentItemObject == null) {
            String error = "Sent item object is null for conversation id: " + this.conversationId;
            Logger.e(error);
            this.createInfoMessageAndDeleteInBoxItem(error);
            return;
        }
        String sentItemBEName = sentItemObject.getBeName();
        String sentItemBEHeaderLid = sentItemObject.getBeHeaderLid();
        if (!this.currentBEName.equalsIgnoreCase(sentItemBEName)) {
            Logger.d("Incoming BE is different from sentItem BE");
            StructureMeta headerStructureMeta = this.applicationManager.getHeaderStructureMeta(this.currentBEName);
            if (headerStructureMeta != null) {
                Logger.d("Caching BE: " + headerStructureMeta.getStructName());
                this.cacheBE(headerStructureMeta.getStructName(), true);
            }
            Logger.d("Handling BE as Pull/Push/Query");
            this.handlePullPushQuery();
            return;
        }
        this.requestedBEPresent = true;
        String whereClauseToGetHeaderExistsInDB = "LID = '" + sentItemBEHeaderLid + "'";
        IDataManager dataManager = this.applicationManager.getDataManager();
        IDataStructure[] headers = dataManager.get(this.currentHeaderName, whereClauseToGetHeaderExistsInDB);
        Logger.d("Sent item BE Header Lid: " + sentItemBEHeaderLid);
        if (headers != null && headers.length > 0) {
            Logger.d("Headers for BE Lid: " + sentItemBEHeaderLid + " present. Length: " + headers.length);
            IDataStructure headerDataStructureInDB = headers[0];
            String savePointName = Utils.getSavePointName();
            this.applicationDataManager.createSavepoint(savePointName);
            try {
                if (this.currentBEAction == SyncConstants.BE_ACTION_TYPE.D) {
                    Logger.i("AsyncDataHandler: handleRequestResponse. Received delete request for BE. deleting BE: " + this.currentHeaderName + "-" + headerDataStructureInDB);
                    this.applicationDataManager.delete(headerDataStructureInDB);
                } else if (this.currentHeader.getBEName().equals(sentItemBEName)) {
                    if (this.currentHeader.getHasConflict()) {
                        ConflictHandler conflictHandler = new ConflictHandler();
                        conflictHandler.handleConflict(headerDataStructureInDB, this.currentHeader, this.currentItems);
                    } else {
                        RequestResponseBEReconciler requestResponseBEReconcile = new RequestResponseBEReconciler(this.conflictRule);
                        ConflictBE conflictBE = requestResponseBEReconcile.reconcile(dataManager, headerDataStructureInDB, this.currentHeader, this.currentItems, false);
                        if (conflictBE != null) {
                            this.conflictBEs.add(conflictBE);
                        }
                    }
                } else {
                    PullPushQueryBEReconciler pullPushQueryBEReconcile = new PullPushQueryBEReconciler(this.conflictRule);
                    ReconcileObject reconcileObject = new ReconcileObject();
                    reconcileObject.setLid(headerDataStructureInDB.getLid());
                    reconcileObject.setObjectStatus(headerDataStructureInDB.getObjectStatus());
                    reconcileObject.setSyncStatus(headerDataStructureInDB.getSyncStatus());
                    ConflictBE conflictBE = pullPushQueryBEReconcile.reconcile(dataManager, reconcileObject, this.currentHeader, this.currentItems);
                    if (conflictBE != null) {
                        this.conflictBEs.add(conflictBE);
                    }
                }
            }
            catch (Exception e) {
                String error = "Exception while processing inbox object. BE: " + sentItemBEName + " LID: " + sentItemBEHeaderLid + " Conversation Id: " + this.conversationId + " Exception: " + e.getMessage();
                Logger.e(error, e);
                this.applicationDataManager.rollbackToSavepoint(savePointName);
            }
            finally {
                this.applicationDataManager.releaseSavepoint(savePointName);
            }
            this.currentHeader.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
        } else {
            Logger.d("Headers for BE Lid: " + sentItemBEHeaderLid + " not present. Inserting");
            String savePointName = Utils.getSavePointName();
            this.applicationDataManager.createSavepoint(savePointName);
            try {
                this.currentHeader.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                this.currentHeader.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                dataManager.insert(this.currentHeader);
                int size = this.currentItems.size();
                IDataStructure itemDataStructure = null;
                for (int i = 0; i < size; ++i) {
                    itemDataStructure = this.currentItems.elementAt(i);
                    itemDataStructure.setFid(this.currentHeader.getLid());
                    itemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                    itemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                    dataManager.insert(itemDataStructure);
                    if (!(itemDataStructure instanceof AttachmentItem)) continue;
                    Attachment.checkAttachmentAndQueueAutoDownload(itemDataStructure);
                }
            }
            catch (Exception e) {
                String error = "Exception while processing inbox object. BE: " + sentItemBEName + " LID: " + sentItemBEHeaderLid + " Conversation Id: " + this.conversationId + " Exception: " + e.getMessage();
                Logger.e(error, e);
                this.applicationDataManager.rollbackToSavepoint(savePointName);
            }
            finally {
                this.applicationDataManager.releaseSavepoint(savePointName);
            }
        }
        DataNotification dataNotification = new DataNotification(this.currentBEName, SyncConstants.BE_ACTION_TYPE.M, sentItemBEHeaderLid);
        this.dataNotifications.add(dataNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteBE(String beHeaderName, String conflictRule) throws DBException {
        String query = null;
        query = "SERVER_WINS".equals(conflictRule) ? "DELETE FROM " + beHeaderName : "DELETE FROM " + beHeaderName + " WHERE OBJECT_STATUS = '" + IDataStructure.OBJECT_STATUS.GLOBAL.ordinal() + "'";
        String savePointName = Utils.getSavePointName();
        this.applicationDataManager.createSavepoint(savePointName);
        try {
            this.applicationDataManager.execute(query);
        }
        catch (Exception e) {
            String error = "Exception while processing sent item. Deletion BEName: " + beHeaderName + " Conversation id: " + this.conversationId + " Exception: " + e.getMessage();
            Logger.e(error, e);
            this.applicationDataManager.rollbackToSavepoint(savePointName);
        }
        finally {
            this.applicationDataManager.releaseSavepoint(savePointName);
        }
    }

    protected void deleteProcessedMessageFromInbox() {
        Logger.i("AsyncDataHandler: deleteProcessedMessageFromInbox Conversation Id: " + this.conversationId);
        try {
            Inbox.getInstance().remove(this.conversationId);
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while deleting outobject from database, CONVERSATION-ID: " + this.conversationId, dbException);
        }
    }

    protected void deleteRelatedConversationIdFromSentItems() {
        Logger.i("AsyncDataHandler: deleteRelatedConversationIdFromSentItems Conversation Id: " + this.conversationId);
        try {
            SentItems.getInstance().remove(this.conversationId);
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while deleting sent item object based on conversation id, CONVERSATION-ID: " + this.conversationId, dbException);
        }
    }

    protected void createInfoMessageAndDeleteInBoxItem(String message) {
        try {
            this.currentInfoMessage = new InfoMessage();
            this.currentInfoMessage.setCategory("FAILURE");
            this.currentInfoMessage.setMessage(message);
            this.saveInfoMessages();
        }
        catch (ApplicationException e) {
            Logger.e("ApplicationException caught while saving InfoMessage", e);
        }
        catch (DBException e) {
            Logger.e("DBException caught while saving InfoMessage", e);
        }
        this.deleteProcessedMessageFromInbox();
        this.deleteRelatedConversationIdFromSentItems();
    }

    protected String getGID(IDataStructure dataStructure) {
        String gid = dataStructure.getBEName();
        Object[] gidFields = new Object[]{};
        try {
            gidFields = dataStructure.getGids();
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        for (Object gField : gidFields) {
            gid = gid + String.valueOf(gField) + "~";
        }
        return gid;
    }

    protected void cacheBE(String headerTableName, boolean isHeader) throws DBException {
        FieldMeta[] fieldMetas;
        ArrayList<String> gidFields = new ArrayList<String>();
        for (FieldMeta fieldMeta : fieldMetas = this.applicationManager.getFieldsMeta(headerTableName)) {
            if (!fieldMeta.isGid()) continue;
            gidFields.add(fieldMeta.getFieldName());
        }
        String query = "SELECT OBJECT_STATUS, SYNC_STATUS, LID, ";
        for (int i = 0; i < gidFields.size(); ++i) {
            query = i == gidFields.size() - 1 ? query + (String)gidFields.get(i) : query + (String)gidFields.get(i) + ", ";
        }
        query = query + " FROM " + headerTableName;
        Logger.i("Get Records for Table : " + headerTableName);
        Cursor cursor = this.applicationDataManager.executeQuery(query);
        this.cacheReconcileObjectFromCursor(headerTableName, cursor, isHeader);
        if (isHeader) {
            String[] childrenTableNames;
            for (String childTableName : childrenTableNames = this.getChildrenTableNames(headerTableName)) {
                this.cacheBE(childTableName, false);
            }
        }
    }

    private void cacheReconcileObjectFromCursor(String tableName, Cursor cursor, boolean isHeader) throws DBException {
        CrossProcessCursorWrapper sqliteCursor = (CrossProcessCursorWrapper)cursor;
        try {
            while (sqliteCursor.moveToNext()) {
                String[] columnNames = sqliteCursor.getColumnNames();
                Object[] columnValues = new Object[columnNames.length];
                block24: for (int i = 0; i < columnNames.length; ++i) {
                    int sqlType = sqliteCursor.getType(i);
                    switch (sqlType) {
                        case 0: {
                            columnValues[i] = sqliteCursor.getString(i);
                            continue block24;
                        }
                        case 1: {
                            columnValues[i] = sqliteCursor.getLong(i);
                            continue block24;
                        }
                        case 2: {
                            columnValues[i] = sqliteCursor.getDouble(i);
                            continue block24;
                        }
                        case 3: {
                            columnValues[i] = sqliteCursor.getString(i);
                            continue block24;
                        }
                        case 4: {
                            columnValues[i] = sqliteCursor.getBlob(i);
                        }
                    }
                }
                ReconcileObject reconcileObject = new ReconcileObject();
                String gid = this.currentBEName;
                block25: for (int i = 0; i < columnNames.length; ++i) {
                    switch (columnNames[i]) {
                        case "LID": {
                            reconcileObject.setLid(String.valueOf(columnValues[i]));
                            continue block25;
                        }
                        case "OBJECT_STATUS": {
                            String objectStatusValue = String.valueOf(columnValues[i]);
                            if (Strings.isNullOrEmpty((String)objectStatusValue) || "null".equalsIgnoreCase(objectStatusValue)) {
                                reconcileObject.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                                continue block25;
                            }
                            reconcileObject.setObjectStatus(IDataStructure.OBJECT_STATUS.values()[(int)Long.parseLong(objectStatusValue)]);
                            continue block25;
                        }
                        case "SYNC_STATUS": {
                            String syncStatusValue = String.valueOf(columnValues[i]);
                            if (Strings.isNullOrEmpty((String)syncStatusValue) || "null".equalsIgnoreCase(syncStatusValue)) {
                                reconcileObject.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                                continue block25;
                            }
                            reconcileObject.setSyncStatus(IDataStructure.SYNC_STATUS.values()[(int)Long.parseLong(syncStatusValue)]);
                            continue block25;
                        }
                        default: {
                            gid = gid + String.valueOf(columnValues[i]) + "~";
                        }
                    }
                }
                if (isHeader) {
                    this.beHeaderMap.put(gid, reconcileObject);
                    continue;
                }
                this.beItemMap.put(gid, reconcileObject);
            }
        }
        catch (SQLException sqlException) {
            String error = "SQLException caught. Table name: " + tableName + " Exception: " + sqlException.getMessage();
            Logger.e(error, (Exception)((Object)sqlException));
            throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "SQLException caught while creating datastructure, " + sqlException.getMessage());
        }
        catch (Exception exception) {
            String error = "Exception caught. Table name: " + tableName + " Exception: " + exception.getMessage();
            Logger.e(error, exception);
            throw new DBException(Class.class.getName(), "getDataStructuresFromCursor", "Exception caught while creating datastructure, " + exception.getMessage());
        }
        finally {
            cursor.close();
        }
    }

    private String[] getChildrenTableNames(String tableName) throws DBException {
        StructureMeta structureMeta = this.applicationManager.getStructureMeta(tableName);
        if (structureMeta == null) {
            throw new DBException(this.getClass().getName(), "getChildrenTableNames", "Structure meta not found for structure: " + tableName);
        }
        StructureMeta[] structureMetas = this.applicationManager.getStructureMetas(structureMeta.getBeName());
        if (structureMetas == null) {
            throw new DBException(this.getClass().getName(), "getChildrenTableNames", "Structure metas not found for BE: " + structureMeta.getBeName());
        }
        String[] childrenTableNames = new String[structureMetas.length - 1];
        int indexForChildrenTableNames = 0;
        for (StructureMeta meta : structureMetas) {
            if (meta.getIsHeader()) continue;
            childrenTableNames[indexForChildrenTableNames++] = meta.getStructName();
        }
        return childrenTableNames;
    }
}

