/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.in;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.RuntimeEngine;
import com.unvired.database.DBException;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentItem;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.InObject;
import com.unvired.model.InfoMessage;
import com.unvired.model.JSAttachmentItem;
import com.unvired.model.JSDataStructure;
import com.unvired.model.ReconcileObject;
import com.unvired.model.StructureMeta;
import com.unvired.sync.SyncConstants;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.in.AsyncDataHandler;
import com.unvired.utils.FrameworkHelper;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class AsyncJSONDataHandler
extends AsyncDataHandler {
    private Vector<String> metaData = null;

    public AsyncJSONDataHandler(InObject inObject) throws ApplicationException {
        super(inObject);
    }

    @Override
    public void parseDocument() throws ApplicationException {
        Thread t;
        Logger.i("AsyncJSONDataHandler: parseDocument Conversation Id: " + this.conversationId);
        File messageFile = null;
        try {
            messageFile = FrameworkHelper.readInboxFile(this.conversationId);
            if (messageFile == null || !messageFile.exists()) {
                Logger.log(8, this.getClass().getName(), "parseDocument", "File not found in Inbox directory for corresponding Conversation Id: " + this.conversationId);
                String message = "File not found for Conversation Id:" + this.conversationId + "in Inbox directory while parsing incoming data.";
                this.createInfoMessageAndDeleteInBoxItem(message);
                return;
            }
            this.dataNotifications = new Vector();
            this.infoMessageNotifications = new Vector();
            ObjectMapper mapper = new ObjectMapper();
            JsonFactory jFactory = mapper.getFactory();
            JsonParser jParser = jFactory.createParser(messageFile);
            if (this.beHeaderMap == null) {
                this.beHeaderMap = new Hashtable();
            } else {
                this.beHeaderMap.clear();
            }
            if (this.beItemMap == null) {
                this.beItemMap = new Hashtable();
            } else {
                this.beItemMap.clear();
            }
            while (jParser.nextToken() != null) {
                String fieldName = jParser.getCurrentName();
                if (fieldName == null) continue;
                if ("InfoMessage".equals(fieldName)) {
                    jParser.nextToken();
                    JsonNode infoMessageNodes = (JsonNode)jParser.readValueAsTree();
                    Iterator infoMessageNodesElements = infoMessageNodes.elements();
                    while (infoMessageNodesElements.hasNext()) {
                        JsonNode infoMsgNode = (JsonNode)infoMessageNodesElements.next();
                        this.currentInfoMessage = new InfoMessage();
                        if (infoMsgNode.has("type")) {
                            this.currentInfoMessage.setType(infoMsgNode.get("type").asText());
                        }
                        if (infoMsgNode.has("subtype")) {
                            this.currentInfoMessage.setSubType(infoMsgNode.get("subtype").asText());
                        }
                        if (infoMsgNode.has("message")) {
                            this.currentInfoMessage.setMessage(infoMsgNode.get("message").asText());
                        }
                        if (infoMsgNode.has("category")) {
                            String category = infoMsgNode.get("category").asText();
                            this.currentInfoMessage.setCategory(category);
                            this.stopParsing = "FAILURE".equalsIgnoreCase(category);
                            if ("FAILURE".equalsIgnoreCase(category)) {
                                Logger.i("parseDocument : FAILURE Infomessage received. BE processing will be ignored if there any.");
                            } else if ("FAILURE_N_PROCESS".equalsIgnoreCase(category)) {
                                Logger.i("parseDocument : FAILURE_N_PROCESS Infomessage received. BE will be set to ERROR and also data will be processed if there any.");
                            }
                        }
                        this.infoMessageNotifications.add(this.currentInfoMessage);
                    }
                    continue;
                }
                if ("Meta".equals(fieldName)) {
                    jParser.nextToken();
                    JsonNode metaDataNode = (JsonNode)jParser.readValueAsTree();
                    if (metaDataNode != null) {
                        JsonNode beMeta = metaDataNode.get("BEName");
                        this.metaData = new Vector();
                        Iterator<String> elements = beMeta.elements();
                        while (elements.hasNext()) {
                            JsonNode node = (JsonNode)elements.next();
                            this.metaData.add(node.asText());
                        }
                    }
                    if (SyncConstants.MESSAGE_REQUEST_TYPE.PULL != this.requestType && SyncConstants.MESSAGE_REQUEST_TYPE.PUSH != this.requestType && SyncConstants.MESSAGE_REQUEST_TYPE.QUERY != this.requestType || metaDataNode == null) continue;
                    String deletionRequiredFlag = metaDataNode.get("d").asText();
                    this.metaDataDeleteFlag = "true".equalsIgnoreCase(deletionRequiredFlag);
                    for (String beName : this.metaData) {
                        try {
                            StructureMeta structureMeta;
                            this.currentBEName = beName;
                            String conflictRule = "SERVER_WINS";
                            BusinessEntityMeta businessEntityMeta = ApplicationManager.getInstance().getBusinessEntityMeta(beName);
                            if (businessEntityMeta != null && !"SERVER_WINS".equals(businessEntityMeta.getConflictRule())) {
                                conflictRule = businessEntityMeta.getConflictRule();
                            }
                            if ((structureMeta = this.applicationManager.getHeaderStructureMeta(beName)) == null) continue;
                            String beHeaderName = structureMeta.getStructName();
                            if (this.metaDataDeleteFlag) {
                                Logger.i("Deleting concerned records of Business Entity : " + beHeaderName);
                                this.deleteBE(beHeaderName, conflictRule);
                                Logger.i("Deletion completed. Business Entity : " + beHeaderName);
                            }
                            this.cacheBE(beHeaderName, true);
                            this.currentBEName = null;
                        }
                        catch (DBException e) {
                            Logger.log(8, this.getClass().getName(), "parseDocument", "DBException caught while deleting be which are not part of pull message, or Adding to cache. " + e.getMessage());
                        }
                        catch (Exception e) {
                            Logger.log(8, this.getClass().getName(), "parseDocument", "Exception caught while deleting be which are not part of pull message, or Adding to cache." + e.getMessage());
                        }
                    }
                    continue;
                }
                if (this.stopParsing || jParser.nextToken() == JsonToken.END_ARRAY) continue;
                JsonNode businessEntity = (JsonNode)jParser.readValueAsTree();
                for (JsonNode be : businessEntity) {
                    this.ParseSelectedBusinessEntity(be, fieldName);
                }
            }
        }
        catch (JsonParseException e) {
            Logger.log(8, this.getClass().getName(), "parseDocument", "JSONException caught while creating JSON object, " + e.getMessage());
            this.deleteProcessedMessageFromInbox();
            this.deleteRelatedConversationIdFromSentItems();
        }
        catch (IOException e) {
            Logger.log(8, this.getClass().getName(), "parseDocument", "SAXException caught while creating SAXPArser object, " + e.getMessage());
            this.deleteProcessedMessageFromInbox();
            this.deleteRelatedConversationIdFromSentItems();
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
            this.deleteProcessedMessageFromInbox();
            this.deleteRelatedConversationIdFromSentItems();
        }
        try {
            this.saveAllInfoMessages();
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getName(), "parseDocument", "Exception while Saving info messages. Exception: " + e.getMessage());
        }
        this.deleteProcessedMessageFromInbox();
        if (SyncConstants.MESSAGE_REQUEST_TYPE.RQST == this.requestType) {
            this.deleteRelatedConversationIdFromSentItems();
        }
        if (this.notificationListener == null) {
            this.notificationListener = SyncEngine.getInstance().getNotificationListener();
        }
        if (this.dataNotifications != null && this.dataNotifications.size() > 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("Data Changed");
            }
            if (this.notificationListener != null) {
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AsyncJSONDataHandler.this.notificationListener.notifyDataChange(AsyncJSONDataHandler.this.dataNotifications);
                    }
                });
                t.start();
            }
        }
        if (this.infoMessageNotifications != null && this.infoMessageNotifications.size() > 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("Server messages");
            }
            if (this.notificationListener != null) {
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AsyncJSONDataHandler.this.notificationListener.notifyServerMessages(AsyncJSONDataHandler.this.infoMessageNotifications);
                    }
                });
                t.start();
            }
        }
        if (this.applicationConflictHandler != null && this.conflictBEs.size() > 0) {
            t = new Thread(new Runnable(){

                @Override
                public void run() {
                    AsyncJSONDataHandler.this.applicationConflictHandler.handleConflict(AsyncJSONDataHandler.this.conflictBEs);
                }
            });
            t.start();
        }
        if (messageFile.exists() && !messageFile.delete()) {
            Logger.log(8, this.getClass().getSimpleName(), "parseDocument", "Error while deleting message file for Conversation id " + this.conversationId);
        }
    }

    private void ParseSelectedBusinessEntity(JsonNode be, String beName) {
        String error;
        Iterator nodeIterator = be.fields();
        this.currentItems = new Vector();
        if (!(SyncConstants.MESSAGE_REQUEST_TYPE.PUSH != this.requestType && SyncConstants.MESSAGE_REQUEST_TYPE.QUERY != this.requestType || !Strings.isNullOrEmpty((String)this.currentBEName) && beName.equals(this.currentBEName))) {
            try {
                this.currentBEName = beName;
                StructureMeta headerStructureMeta = this.applicationManager.getHeaderStructureMeta(this.currentBEName);
                if (headerStructureMeta != null) {
                    this.cacheBE(headerStructureMeta.getStructName(), true);
                }
            }
            catch (DBException e) {
                Logger.e("DBException caught while Adding BE to cache. " + e.getMessage());
            }
            catch (Exception e) {
                Logger.e("Exception caught while deleting be which are not part of pull message, or Adding to cache." + e.getMessage());
            }
        } else {
            this.currentBEName = beName;
        }
        try {
            while (nodeIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)nodeIterator.next();
                String headerName = (String)entry.getKey();
                if (((JsonNode)entry.getValue()).isObject()) {
                    JsonNode header;
                    block38: {
                        header = be.get(headerName);
                        this.currentHeaderName = headerName;
                        String headerClass = this.dataStructureTableMapping.getClassName(headerName);
                        if (headerClass != null) {
                            try {
                                if (RuntimeEngine.getInstance().isHTML5Framework()) {
                                    this.currentHeader = new JSDataStructure(headerName, true);
                                    break block38;
                                }
                                this.currentHeader = (IDataStructure)Class.forName(headerClass).newInstance();
                            }
                            catch (Exception e) {
                                Logger.log(9, this.getClass().getName(), "ParseSelectedBusinessEntity", "Error while creating Header DataStructure from JsonNode : " + headerName + "." + e.getMessage());
                            }
                        } else {
                            Logger.log(9, this.getClass().getName(), "startElement", "Header not found. Ignoring: " + headerName);
                            continue;
                        }
                    }
                    Iterator fieldsNodeIterator = header.fields();
                    while (fieldsNodeIterator.hasNext()) {
                        Map.Entry fieldEntry = (Map.Entry)fieldsNodeIterator.next();
                        if (fieldEntry == null || fieldEntry.getKey() == null || fieldEntry.getValue() == null) continue;
                        this.currentHeader.setFieldBasedOnDataType((String)fieldEntry.getKey(), ((JsonNode)fieldEntry.getValue()).asText());
                    }
                    IDataStructure headerInDatabase = null;
                    try {
                        if (SyncConstants.MESSAGE_REQUEST_TYPE.PULL != this.requestType && SyncConstants.MESSAGE_REQUEST_TYPE.PUSH != this.requestType && SyncConstants.MESSAGE_REQUEST_TYPE.QUERY != this.requestType) {
                            headerInDatabase = this.applicationDataManager.checkDuplicateGID(this.currentHeader);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String currentBEActionString = be.get("a").asText();
                    if (currentBEActionString != null && currentBEActionString.length() > 0) {
                        try {
                            this.currentBEAction = SyncConstants.BE_ACTION_TYPE.valueOf(currentBEActionString);
                        }
                        catch (IllegalArgumentException e) {
                            this.currentBEAction = SyncConstants.BE_ACTION_TYPE.A;
                        }
                    }
                    if ((SyncConstants.MESSAGE_REQUEST_TYPE.PULL == this.requestType || SyncConstants.MESSAGE_REQUEST_TYPE.PUSH == this.requestType || SyncConstants.MESSAGE_REQUEST_TYPE.QUERY == this.requestType) && this.currentBEAction == SyncConstants.BE_ACTION_TYPE.D) {
                        try {
                            if (headerInDatabase != null) {
                                this.applicationDataManager.delete(headerInDatabase);
                            } else {
                                ReconcileObject object = (ReconcileObject)this.beHeaderMap.get(this.getGID(this.currentHeader));
                                if (object != null) {
                                    this.applicationDataManager.delete(this.currentHeader.getTableName(), "LID = '" + object.getLid() + "'");
                                }
                            }
                        }
                        catch (DBException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    if (headerInDatabase == null) continue;
                    this.currentHeader.setLid(headerInDatabase.getLid());
                    continue;
                }
                if (!((JsonNode)entry.getValue()).isArray()) continue;
                this.beItemMap = new Hashtable();
                JsonNode items = be.get(headerName);
                if (items == null) continue;
                Iterator itemElements = items.elements();
                while (itemElements.hasNext()) {
                    JsonNode item = (JsonNode)itemElements.next();
                    IDataStructure itemDataStructure = this.getItemDataStructureFromJson(item, headerName);
                    if (itemDataStructure == null) continue;
                    IDataStructure itemInDatabase = null;
                    if (SyncConstants.MESSAGE_REQUEST_TYPE.PULL != this.requestType && SyncConstants.MESSAGE_REQUEST_TYPE.PUSH != this.requestType && SyncConstants.MESSAGE_REQUEST_TYPE.QUERY != this.requestType) {
                        itemInDatabase = this.applicationDataManager.checkDuplicateGID(itemDataStructure);
                    }
                    if (itemInDatabase != null) {
                        itemDataStructure.setLid(itemInDatabase.getLid());
                    }
                    itemDataStructure.setFid(this.currentHeader.getLid());
                    this.currentItems.add(itemDataStructure);
                }
            }
        }
        catch (Exception ex) {
            Logger.log(8, this.getClass().getSimpleName(), "ParseSelectedBusinessEntity", "Error while parsing BusinessEntity " + beName + "." + ex.getMessage());
            return;
        }
        try {
            switch (this.requestType) {
                case RQST: {
                    this.handleRequestResponse();
                    break;
                }
                default: {
                    this.handlePullPushQuery();
                    break;
                }
            }
        }
        catch (DBException e) {
            error = "Database exception while handling request type" + (Object)((Object)this.requestType) + ". Exception: " + e.getMessage();
            Logger.log(8, this.getClass().getName(), "endElement", error);
        }
        catch (ApplicationException e) {
            error = "Application exception while handling request type" + (Object)((Object)this.requestType) + ". Exception: " + e.getMessage();
            Logger.log(8, this.getClass().getName(), "endElement", error);
        }
    }

    private IDataStructure getItemDataStructureFromJson(JsonNode item, String itemName) {
        IDataStructure itemDataStructure = null;
        try {
            this.currentItemName = itemName;
            String headerClass = this.dataStructureTableMapping.getClassName(itemName);
            if (headerClass != null) {
                itemDataStructure = RuntimeEngine.getInstance().isHTML5Framework() ? (itemName.toLowerCase().endsWith("_attachment") ? new JSAttachmentItem(itemName) : new JSDataStructure(itemName, false)) : (itemName.toLowerCase().endsWith("_attachment") ? new AttachmentItem(itemName) : (IDataStructure)Class.forName(headerClass).newInstance());
            } else {
                Logger.log(9, this.getClass().getName(), "getItemDataStructureFromJson", "Header not found. Ignoring: " + itemName);
                return null;
            }
            Iterator nodeIterator = item.fields();
            while (nodeIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)nodeIterator.next();
                if (entry.getKey() == null || entry.getValue() == null) continue;
                itemDataStructure.setFieldBasedOnDataType((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
        }
        catch (Exception e) {
            Logger.log(9, this.getClass().getName(), "getItemDataStructureFromJson", "Error while creating item DataStructure from JsonNode : " + itemName + "." + e.getMessage());
        }
        return itemDataStructure;
    }
}

