/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.in;

import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.RuntimeEngine;
import com.unvired.database.DBException;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.exception.MissingFieldException;
import com.unvired.exception.MissingFieldTypeException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentItem;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.InObject;
import com.unvired.model.InfoMessage;
import com.unvired.model.JSAttachmentItem;
import com.unvired.model.JSDataStructure;
import com.unvired.model.StructureMeta;
import com.unvired.sync.SyncConstants;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.in.AsyncDataHandler;
import com.unvired.utils.FileHelper;
import com.unvired.utils.FrameworkHelper;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AsyncXMLDataHandler
extends AsyncDataHandler {
    private int processedBECount = 0;
    private int totalBECount = 0;

    public AsyncXMLDataHandler(InObject inObject) throws ApplicationException {
        super(inObject);
    }

    @Override
    public void parseDocument() throws ApplicationException {
        SAXParser saxParser;
        Logger.i("AsyncXMLDataHandler: parseDocument Conversation Id: " + this.conversationId);
        this.processedBECount = 0;
        this.totalBECount = 0;
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            saxParser = saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.e("ParserConfigurationException caught while creating SAXParser object", parserConfigurationException);
            throw new ApplicationException(this.getClass().getName(), "parseDocument", "ParserConfigurationException caught while creating SAXParser object, " + parserConfigurationException.getMessage());
        }
        catch (SAXException saxException) {
            Logger.e("SAXException caught while creating SAXParser object, ", saxException);
            throw new ApplicationException(this.getClass().getName(), "parseDocument", "SAXException caught while creating SAXParser object, " + saxException.getMessage());
        }
        File messageFile = null;
        try {
            messageFile = FrameworkHelper.readInboxFile(this.conversationId);
            if (messageFile == null || !messageFile.exists()) {
                Logger.log(8, this.getClass().getName(), "parseDocument", "File not found in Inbox directory for corresponding Conversation Id: " + this.conversationId);
                String message = "File not found for Conversation Id:" + this.conversationId + "in Inbox directory while parsing incoming data.";
                this.createInfoMessageAndDeleteInBoxItem(message);
                return;
            }
            Logger.log(7, this.getClass().getName(), "parseDocument", "************ InBox message parsing STARTED ************* \n Conversation Id: " + this.conversationId + " Initial BE count: " + this.processedBECount);
            saxParser.parse(messageFile, (DefaultHandler)this);
            Logger.i("AsyncXMLDataHandler: parseDocument message file deleted for Conversation Id: " + this.conversationId);
        }
        catch (Exception exception) {
            if (exception.getMessage() == null) {
                String fileContentWithStatus = FileHelper.getFileContentWithStatus(messageFile);
                Logger.e("Exception caught while parsing message file. File Status with Content" + fileContentWithStatus, exception);
            }
            String exceptionMessage = FrameworkHelper.getExceptionMessage(exception);
            String errorText = "Exception while parsing incoming message: " + exceptionMessage + " Conversation Id: " + this.conversationId + " Message Type: " + this.messageType;
            Logger.e(errorText, exception);
            try {
                this.currentInfoMessage = new InfoMessage();
                this.currentInfoMessage.setCategory("FAILURE");
                errorText = "Exception while parsing incoming message: " + exception.getMessage() + " Conversation Id: " + this.conversationId + " Message Type: " + this.messageType;
                this.currentInfoMessage.setMessage(errorText);
                this.saveInfoMessages();
            }
            catch (Exception e) {
                Logger.e("Error while saving infomessage. Conversation Id: " + this.conversationId + " Message Type: " + this.messageType, e);
            }
            this.deleteProcessedMessageFromInbox();
            this.deleteRelatedConversationIdFromSentItems();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tempValue = new StringBuffer();
        if ("Root".equalsIgnoreCase(localName)) {
            Logger.i("************* InBox message parsing STARTED **************** \n Conversation Id: " + this.conversationId + "Total BE Count : " + this.totalBECount + " Final BE count: " + this.processedBECount);
            this.dataNotifications = new Vector<E>();
            this.infoMessageNotifications = new Vector<E>();
        } else if ("Meta".equalsIgnoreCase(localName)) {
            if (SyncConstants.MESSAGE_REQUEST_TYPE.PULL == this.requestType) {
                if (this.beHeaderMap == null) {
                    this.beHeaderMap = new Hashtable<K, V>();
                } else {
                    this.beHeaderMap.clear();
                }
                if (this.beItemMap == null) {
                    this.beItemMap = new Hashtable<K, V>();
                } else {
                    this.beItemMap.clear();
                }
                if (attributes != null) {
                    deletionRequiredFlag = attributes.getValue("d");
                    this.metaDataDeleteFlag = "true".equalsIgnoreCase(deletionRequiredFlag);
                }
            }
            if (SyncConstants.MESSAGE_REQUEST_TYPE.QUERY == this.requestType && attributes != null && Strings.isNullOrEmpty((String)(businessEntityTag = attributes.getValue("BE")))) {
                try {
                    this.updateStatusFromConversationId();
                }
                catch (ApplicationException e) {
                    Logger.e("ApplicationException caught while updating BE status for ConversationId:" + this.conversationId, e);
                }
                catch (DBException e) {
                    Logger.e("DBException caught while updating BE status for ConversationId:" + this.conversationId, e);
                }
            }
        } else if ("BE".equalsIgnoreCase(localName)) {
            newBEName = attributes.getValue("n");
            if (!(SyncConstants.MESSAGE_REQUEST_TYPE.PUSH != this.requestType && SyncConstants.MESSAGE_REQUEST_TYPE.QUERY != this.requestType || !Strings.isNullOrEmpty((String)this.currentBEName) && newBEName.equals(this.currentBEName))) {
                try {
                    this.currentBEName = newBEName;
                    headerStructureMeta = this.applicationManager.getHeaderStructureMeta(this.currentBEName);
                    if (headerStructureMeta == null) ** GOTO lbl46
                    this.cacheBE(headerStructureMeta.getStructName(), true);
                }
                catch (DBException e) {
                    error = "Database exception while getting header structure meta for BE:" + this.currentBEName + ". Exception: " + e.getMessage();
                    throw new SAXException(new Exception(error));
                }
                catch (Exception exception) {
                    Logger.log(8, this.getClass().getName(), "endElement", "ApplicationException caught while deleteing be which are not part of pull message, " + exception.getMessage());
                }
            } else {
                this.currentBEName = newBEName;
            }
lbl46:
            // 4 sources

            currentBEActionString = attributes.getValue("a");
            if (currentBEActionString != null && currentBEActionString.length() > 0) {
                try {
                    this.currentBEAction = SyncConstants.BE_ACTION_TYPE.valueOf(currentBEActionString);
                }
                catch (NumberFormatException e) {
                    this.currentBEAction = SyncConstants.BE_ACTION_TYPE.A;
                }
            }
            this.currentItems = new Vector<E>();
        } else if ("H".equalsIgnoreCase(localName)) {
            this.initializeBEHeaderNode(attributes);
        } else if ("I".equalsIgnoreCase(localName)) {
            this.initializeBEItemNode(attributes);
        } else if ("F".equalsIgnoreCase(localName)) {
            this.currentFieldName = attributes.getValue("n");
        } else if ("InfoMessage".equalsIgnoreCase(localName)) {
            this.infoMessageTagStarted = true;
            this.currentInfoMessage = new InfoMessage();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (ch != null) {
            this.tempValue.append(ch, start, length);
        } else {
            this.tempValue = new StringBuffer();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.infoMessageTagStarted) {
            if (this.tempValue == null || this.tempValue.length() <= 0) {
                Logger.log(8, this.getClass().getName(), "endElement", "Ignoring InfoMessage fields as value is null or field is removed in UMP. Field :" + localName + " Value: " + this.tempValue);
                return;
            }
            if ("type".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setType(this.tempValue.toString());
            } else if ("subtype".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setSubType(this.tempValue.toString());
            } else if ("category".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setCategory(this.tempValue.toString());
                this.stopParsing = "FAILURE".equalsIgnoreCase(this.tempValue.toString());
                if ("FAILURE".equalsIgnoreCase(this.tempValue.toString())) {
                    Logger.i("parseDocument : FAILURE Infomessage received. BE processing will be ignored if there any.");
                } else if ("FAILURE_N_PROCESS".equalsIgnoreCase(this.tempValue.toString())) {
                    Logger.i("parseDocument : FAILURE_N_PROCESS Infomessage received. BE will be set to ERROR and also data will be processed if there any.");
                }
            } else if ("message".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setMessage(this.tempValue.toString());
            } else if ("belid".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setBeLid(this.tempValue.toString());
            } else if ("bename".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setBeName(this.tempValue.toString());
            } else if ("messagedetails".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setMessageBlob(this.tempValue.toString().getBytes());
            }
        }
        if ("InfoMessage".equalsIgnoreCase(localName)) {
            this.infoMessageNotifications.addElement(this.currentInfoMessage);
            this.infoMessageTagStarted = false;
            this.currentInfoMessage = null;
        }
        if ("BEName".equalsIgnoreCase(localName)) {
            this.currentBEName = this.tempValue.toString();
            if (SyncConstants.MESSAGE_REQUEST_TYPE.PULL == this.requestType) {
                try {
                    StructureMeta headerStructureMeta = this.applicationManager.getHeaderStructureMeta(this.currentBEName);
                    if (headerStructureMeta != null) {
                        String beHeaderName = headerStructureMeta.getStructName();
                        if (this.metaDataDeleteFlag) {
                            String conflictRule = "SERVER_WINS";
                            BusinessEntityMeta businessEntityMeta = ApplicationManager.getInstance().getBusinessEntityMeta(this.currentBEName);
                            if (businessEntityMeta != null && !"SERVER_WINS".equals(businessEntityMeta.getConflictRule())) {
                                conflictRule = businessEntityMeta.getConflictRule();
                            }
                            Logger.i("Deleting concerned records of Business Entity : " + beHeaderName);
                            this.deleteBE(beHeaderName, conflictRule);
                            Logger.i("Deletion completed. Business Entity : " + beHeaderName);
                        }
                        this.cacheBE(beHeaderName, true);
                    }
                }
                catch (DBException e) {
                    String error = "Database exception while getting header structure meta for BE:" + this.currentBEName + ". Exception: " + e.getMessage();
                    throw new SAXException(new Exception(error));
                }
                catch (Exception exception) {
                    Logger.log(8, this.getClass().getName(), "endElement", "ApplicationException caught while deleteing be which are not part of pull message, " + exception.getMessage());
                }
            }
            this.currentBEName = null;
        } else if ("BE".equalsIgnoreCase(localName) && !this.stopParsing) {
            ++this.totalBECount;
            try {
                switch (this.requestType) {
                    case RQST: {
                        this.handleRequestResponse();
                        break;
                    }
                    default: {
                        if (this.currentHeader != null) {
                            this.handlePullPushQuery();
                            break;
                        }
                        if (Logger.getDefaultLogLevel() != 9) break;
                        Logger.log(9, this.getClass().getName(), "endElement", "Header / item not found.");
                    }
                }
                ++this.processedBECount;
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.log(9, this.getClass().getName(), "endElement", "BE processing in PROGRESS. " + this.currentBEName + " Conversation Id: " + this.conversationId + " Final BE count: " + this.processedBECount);
                }
            }
            catch (DBException e) {
                String error = "Database exception while handling request type " + (Object)((Object)this.requestType) + ". Exception: " + e.getMessage();
                Logger.e(error, e);
            }
            catch (ApplicationException e) {
                String error = "Application exception while handling request type " + (Object)((Object)this.requestType) + ". Exception: " + e.getMessage();
                Logger.e(error, e);
            }
            this.currentHeader = null;
            this.currentItems = null;
        } else if ("H".equalsIgnoreCase(localName)) {
            try {
                if (this.currentHeader != null) {
                    IDataStructure headerInDatabase = null;
                    if (SyncConstants.MESSAGE_REQUEST_TYPE.PULL != this.requestType && SyncConstants.MESSAGE_REQUEST_TYPE.PUSH != this.requestType && SyncConstants.MESSAGE_REQUEST_TYPE.QUERY != this.requestType) {
                        headerInDatabase = this.applicationDataManager.checkDuplicateGID(this.currentHeader);
                    }
                    if (headerInDatabase != null) {
                        this.currentHeader.setLid(headerInDatabase.getLid());
                    }
                } else if (Logger.getDefaultLogLevel() == 9) {
                    Logger.log(9, this.getClass().getName(), "endElement", "Header object is null. So ignoring end header tag.");
                }
            }
            catch (DBException e) {
                String error = "DBException while checking the data in the database: " + e.getMessage();
                Logger.e(error, e);
                throw new SAXException(error);
            }
            this.currentFieldName = null;
        } else if ("I".equalsIgnoreCase(localName)) {
            try {
                if (this.currentItem != null) {
                    IDataStructure itemInDatabase = null;
                    if (SyncConstants.MESSAGE_REQUEST_TYPE.PULL != this.requestType) {
                        itemInDatabase = this.applicationDataManager.checkDuplicateGID(this.currentItem);
                    }
                    if (itemInDatabase != null) {
                        this.currentItem.setLid(itemInDatabase.getLid());
                    }
                } else if (Logger.getDefaultLogLevel() == 9) {
                    Logger.log(9, this.getClass().getName(), "endElement", "Item object is null. So ignoring end item tag.");
                }
            }
            catch (DBException e) {
                String error = "DBException while checking the data in the database: " + e.getMessage();
                Logger.e(error, e);
                throw new SAXException(error);
            }
            if (this.currentItem != null) {
                this.currentItem.setFid(this.currentHeader.getLid());
                this.currentItem = null;
                this.currentItemName = null;
            }
        } else if ("F".equalsIgnoreCase(localName)) {
            if (this.currentFieldName != null) {
                try {
                    if (this.headerInProcess) {
                        if (this.currentHeader != null) {
                            this.currentHeader.setFieldBasedOnDataType(this.currentFieldName, this.tempValue.toString());
                        } else if (Logger.getDefaultLogLevel() == 9) {
                            Logger.log(9, this.getClass().getName(), "endElement", "Header not found. Ignoring field: " + this.currentFieldName);
                        }
                    } else if (this.currentItem != null) {
                        this.currentItem.setFieldBasedOnDataType(this.currentFieldName, this.tempValue.toString());
                    } else if (Logger.getDefaultLogLevel() == 9) {
                        Logger.log(9, this.getClass().getName(), "endElement", "Item not found. Ignoring field: " + this.currentFieldName);
                    }
                }
                catch (MissingFieldException e) {
                    String error = "Missing field exception while handling request type" + (Object)((Object)this.requestType) + ". Exception: " + e.getMessage();
                    Logger.e(error, e);
                }
                catch (MissingFieldTypeException e) {
                    String error = "Missing field type exception while handling request type" + (Object)((Object)this.requestType) + ". Exception: " + e.getMessage();
                    Logger.e(error, e);
                }
            }
            this.currentFieldName = null;
        } else if ("Root".equalsIgnoreCase(localName)) {
            Thread t;
            try {
                this.saveAllInfoMessages();
                this.deleteProcessedMessageFromInbox();
                if (SyncConstants.MESSAGE_REQUEST_TYPE.RQST == this.requestType) {
                    this.deleteRelatedConversationIdFromSentItems();
                }
            }
            catch (Exception exception) {
                Logger.e("handleSystemMessage() has thrown a exception: ", exception);
                this.deleteProcessedMessageFromInbox();
            }
            if (this.notificationListener == null) {
                this.notificationListener = SyncEngine.getInstance().getNotificationListener();
            }
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("Data Changed");
            }
            this.notificationListener.notifyDataChange(this.dataNotifications);
            if (this.infoMessageNotifications != null && this.infoMessageNotifications.size() > 0) {
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.d("Server messages");
                }
                if (this.notificationListener != null) {
                    t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            AsyncXMLDataHandler.this.notificationListener.notifyServerMessages(AsyncXMLDataHandler.this.infoMessageNotifications);
                        }
                    });
                    t.start();
                }
            }
            if (this.applicationConflictHandler != null && this.conflictBEs.size() > 0) {
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AsyncXMLDataHandler.this.applicationConflictHandler.handleConflict(AsyncXMLDataHandler.this.conflictBEs);
                    }
                });
                t.start();
            }
            Logger.i("************* InBox message parsing COMPLETED **************** \n Conversation Id: " + this.conversationId + "Total BE Count : " + this.totalBECount + " Final BE count: " + this.processedBECount);
        }
    }

    protected void initializeBEHeaderNode(Attributes attributes) throws SAXException {
        this.currentHeaderName = attributes.getValue("n");
        String headerClass = this.dataStructureTableMapping.getClassName(this.currentHeaderName);
        this.headerInProcess = true;
        try {
            if (headerClass != null) {
                this.currentHeader = RuntimeEngine.getInstance().isHTML5Framework() ? new JSDataStructure(this.currentHeaderName, true) : (IDataStructure)Class.forName(headerClass).newInstance();
            } else if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "initializeBEHeaderNode", "Header class not found. Ignoring header: " + this.currentHeaderName);
            }
        }
        catch (InstantiationException e) {
            String error = "Instantiation exception. Class: " + headerClass + " " + e.getMessage();
            Logger.e(error, e);
            throw new SAXException(error);
        }
        catch (IllegalAccessException e) {
            String error = "Illegal Access exception. Class: " + headerClass + " " + e.getMessage();
            Logger.e(error, e);
            throw new SAXException(error);
        }
        catch (ClassNotFoundException e) {
            String error = "Class Not Found exception. Class: " + headerClass + " " + e.getMessage();
            Logger.e(error, e);
            throw new SAXException(error);
        }
        catch (Exception e) {
            String error = "Exception. Class: " + headerClass + " " + e.getMessage();
            Logger.e(error, e);
            throw new SAXException(error);
        }
    }

    protected void initializeBEItemNode(Attributes attributes) throws SAXException {
        this.currentFieldName = null;
        this.currentItemName = attributes.getValue("n");
        String itemClass = this.dataStructureTableMapping.getClassName(this.currentItemName);
        this.headerInProcess = false;
        try {
            if (itemClass != null) {
                this.currentItem = RuntimeEngine.getInstance().isHTML5Framework() ? (this.currentItemName.toLowerCase().endsWith("_attachment") ? new JSAttachmentItem(this.currentItemName) : new JSDataStructure(this.currentItemName, false)) : (this.currentItemName.toLowerCase().endsWith("_attachment") ? new AttachmentItem(this.currentItemName) : (IDataStructure)Class.forName(itemClass).newInstance());
                this.currentItems.addElement(this.currentItem);
            } else if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "initializeBEItemNode", "Item class not found. Ignoring item: " + this.currentItemName);
            }
        }
        catch (InstantiationException e) {
            String error = "Instantiation exception. Class: " + itemClass + " " + e.getMessage();
            Logger.e(error, e);
            throw new SAXException(error);
        }
        catch (IllegalAccessException e) {
            String error = "Illegal Access exception. Class: " + itemClass + " " + e.getMessage();
            Logger.e(error, e);
            throw new SAXException(error);
        }
        catch (ClassNotFoundException e) {
            String error = "Class Not Found exception. Class: " + itemClass + " " + e.getMessage();
            Logger.e(error, e);
            throw new SAXException(error);
        }
        catch (Exception e) {
            String error = "Exception. Class: " + itemClass + " " + e.getMessage();
            Logger.e(error, e);
            throw new SAXException(error);
        }
    }
}

