/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.in;

import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.logger.Logger;
import com.unvired.message.UNVDataHelper;
import com.unvired.model.ConflictBEObject;
import com.unvired.utils.Utils;
import java.util.Vector;

public class ConflictHandler {
    private IDataManager fwDataManager = null;
    private IDataManager appDataManager = null;

    public ConflictHandler() {
        try {
            this.fwDataManager = FrameworkManager.getInstance().getDataManager();
            this.appDataManager = ApplicationManager.getInstance().getDataManager();
        }
        catch (Exception e) {
            Logger.log(8, this.getClass().getSimpleName(), "ConflictHandler", "Error while instantiating FW/App Data Managers." + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConflict(IDataStructure headerDataStructure, IDataStructure incomingHeaderDataStructure, Vector<IDataStructure> incomingItemDataStructures) throws DBException {
        try {
            String dataFormat = FrameworkSettingsManager.getInstance().getDataFormat();
            String conflictedData = "";
            conflictedData = "XML".equalsIgnoreCase(dataFormat) ? UNVDataHelper.generateMessageIBXML(headerDataStructure, UNVDataHelper.DATA_TYPE.CHANGED) : UNVDataHelper.generateMessageIBJSON(headerDataStructure, UNVDataHelper.DATA_TYPE.CHANGED);
            ConflictBEObject conflictBEObject = new ConflictBEObject();
            conflictBEObject.setBeName(headerDataStructure.getBEName());
            conflictBEObject.setConflictedBeLid(headerDataStructure.getLid());
            conflictBEObject.setConflictedData(conflictedData.getBytes());
            this.fwDataManager.insert(conflictBEObject);
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getSimpleName(), "handleConflict", "Error while saving conflicted be data. BE Name: " + headerDataStructure.getBEName() + ". BE Lid:" + headerDataStructure.getLid() + "." + e.getMessage());
        }
        String savePointName = Utils.getSavePointName();
        this.appDataManager.createSavepoint(savePointName);
        try {
            this.appDataManager.delete(headerDataStructure);
            incomingHeaderDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
            incomingHeaderDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
            incomingHeaderDataStructure.setLid(headerDataStructure.getLid());
            this.appDataManager.insert(incomingHeaderDataStructure);
            int size = incomingItemDataStructures.size();
            IDataStructure itemDataStructure = null;
            for (int i = 0; i < size; ++i) {
                itemDataStructure = incomingItemDataStructures.elementAt(i);
                itemDataStructure.setFid(incomingHeaderDataStructure.getLid());
                itemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                itemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                this.appDataManager.insert(itemDataStructure);
            }
        }
        catch (Exception e) {
            Logger.log(8, this.getClass().getSimpleName(), "handleConflict", "Error while saving conflicted be data. BE Name: " + headerDataStructure.getBEName() + ". BE Lid:" + headerDataStructure.getLid() + "." + e.getMessage());
            this.appDataManager.rollbackToSavepoint(savePointName);
        }
        finally {
            this.appDataManager.releaseSavepoint(savePointName);
        }
    }
}

