/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.in;

import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.logger.Logger;
import com.unvired.login.AuthenticationService;
import com.unvired.login.LoginParameters;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.in.InboxHandler;
import com.unvired.sync.in.IncomingDataHandler;
import com.unvired.sync.notifier.NotificationListener;
import com.unvired.sync.out.DataSender;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.sync.ssl.ModifiedX509TrustManager;
import com.unvired.utils.NetworkChangeReceiver;
import com.unvired.utils.NetworkStateListener;
import com.unvired.utils.NetworkUtil;
import com.unvired.utils.ProgressMonitor;

public class DataRetrieverService {
    private static DataRetrieverService dataRetriever;
    private DataRetrieverThread dataRetrieverThread;
    private NotificationListener notificationListener;
    private NetworkChangeReceiver networkChangeReceiver = SyncEngine.getInstance().getNetworkChangeReceiver();

    private DataRetrieverService() {
    }

    public static DataRetrieverService getInstance() {
        if (dataRetriever == null) {
            dataRetriever = new DataRetrieverService();
        }
        return dataRetriever;
    }

    public void stop() {
        if (this.dataRetrieverThread != null && this.dataRetrieverThread.isAlive()) {
            this.dataRetrieverThread.interrupt();
            try {
                this.dataRetrieverThread.join();
            }
            catch (InterruptedException e) {
                Logger.e("InterruptedException caught while stopping DataRetriever thread.", e);
            }
            finally {
                this.dataRetrieverThread = null;
                dataRetriever = null;
            }
        }
    }

    public boolean isAlive() {
        return this.dataRetrieverThread != null && this.dataRetrieverThread.isAlive();
    }

    public void getMessagesInBackground() {
        boolean applicationInDemoMode = false;
        try {
            applicationInDemoMode = UserSettingsManager.getInstance().getDemoMode();
        }
        catch (DBException e) {
            Logger.e("Login mode initialization failed.", e);
            return;
        }
        if (applicationInDemoMode) {
            return;
        }
        if (this.dataRetrieverThread == null || !this.dataRetrieverThread.isAlive()) {
            this.dataRetrieverThread = null;
            this.dataRetrieverThread = new DataRetrieverThread();
            this.dataRetrieverThread.start();
        } else if (this.dataRetrieverThread != null && this.dataRetrieverThread.isAlive()) {
            Logger.log(7, this.getClass().getName(), "getMessagesInBackground", "DataRetrieverThread is alive");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private synchronized void getMessagesInLoopFromServer() {
        block36: {
            block18: while (true) {
                if (!NetworkUtil.hasCoverage()) {
                    var1_1 = this;
                    synchronized (var1_1) {
                        block35: {
                            try {
                                networkStateListener = new NetworkStateListener(0);
                                if (this.networkChangeReceiver == null) break block35;
                                this.networkChangeReceiver.addNetworkStateListener(networkStateListener);
                                var3_4 = networkStateListener;
                                synchronized (var3_4) {
                                    networkStateListener.wait();
                                }
                                this.networkChangeReceiver.removeNetworkStateListener(networkStateListener);
                            }
                            catch (InterruptedException interruptedException) {
                                Logger.e("InterruptedException caught while going to wait condition because of no connectivity.", interruptedException);
                                break block36;
                            }
                        }
                        if (!NetworkUtil.hasCoverage()) {
                            continue;
                        }
                    }
                }
                httpResponse = HTTPConnection.getMessage();
                Logger.i("DataRetrieverService getMessagesInLoopFromServer Response Code-error: " + httpResponse.getResponseCode() + "-" + httpResponse.getErrorMessage());
                switch (httpResponse.getResponseCode()) {
                    case 200: {
                        serverHTTPFields = httpResponse.getServerFields();
                        Logger.i("DataRetrieverService getMessagesInLoopFromServer Server HTTP Fields: " + serverHTTPFields);
                        if (serverHTTPFields == null) {
                            Logger.log(8, this.getClass().getName(), "getMessagesInLoopFromServer", "HTTP Connection response 200 but http header fields missing.");
                            ProgressMonitor.displayProgressBar = true;
                            return;
                        }
                        numberOfMessagesValue = serverHTTPFields.get("X-UNVIRED-NUMBER-OF-PENDING-MESSAGES");
                        numberOfMessages = 0;
                        try {
                            numberOfMessages = Integer.parseInt(numberOfMessagesValue);
                        }
                        catch (NumberFormatException e) {
                            Logger.log(8, this.getClass().getName(), "getMessagesInLoopFromServer", "Incorrect number of messages parameter from the server. Stopping loop to get messages. Number of messages: " + numberOfMessagesValue);
                            ProgressMonitor.displayProgressBar = true;
                            return;
                        }
                        if (!ProgressMonitor.displayProgressBar) {
                            ProgressMonitor.displayProgressBar = true;
                            ProgressMonitor.progressMax = numberOfMessages + 1;
                        }
                        if (numberOfMessages == -1) {
                            Logger.log(7, this.getClass().getName(), "getMessagesInLoopFromServer", "No messages in the server");
                            return;
                        }
                        ++ProgressMonitor.progressStatus;
                        synchronizationStateListener = SyncEngine.getInstance().getSynchronizationStateListener();
                        if (synchronizationStateListener != null) {
                            synchronizationStateListener.receiving(ProgressMonitor.progressStatus + "/" + ProgressMonitor.progressMax);
                        }
                        if ((responseBytes = httpResponse.getResponseBytes()) == null) {
                            Logger.log(8, this.getClass().getName(), "getMessagesInLoopFromServer", "HTTP Connection response 200 but data is null. Cannot process further. Aborting.");
                            ProgressMonitor.displayProgressBar = true;
                            return;
                        }
                        IncomingDataHandler.handleData(serverHTTPFields, responseBytes);
                        conversationId = serverHTTPFields.get("X-UNVIRED-CONVERSATION-ID");
                        Logger.log(7, this.getClass().getName(), "getMessagesInLoopFromServer", "Message received for Conversation id: " + conversationId + " Message Count: " + numberOfMessages);
                        if (conversationId != null) {
                            Logger.i("DataRetrieverService getMessagesInLoopFromServer Notifying Message for conversation id: " + conversationId);
                            response = HTTPConnection.notifyMessage(conversationId);
                            Logger.i("DataRetrieverService getMessagesInLoopFromServer Notifying Message for conversation id: " + response.getResponseCode() + ", " + response.getErrorMessage());
                        }
                        if (numberOfMessages > 0) continue block18;
                        InboxHandler.getInstance().start();
                        return;
                    }
                    case 526: {
                        try {
                            DataSender.getInstance().stop();
                            HTTPConnection.trustOurHosts();
                        }
                        catch (Exception e) {
                            Logger.log(8, AuthenticationService.class.getSimpleName(), "getMessagesInLoopFromServer", "Error while checking for trusted certificate." + e.getMessage());
                        }
                        while (ModifiedX509TrustManager.isCertificateDialogOpen) {
                        }
                        if (ModifiedX509TrustManager.isCertificateAccepted()) {
                            try {
                                sharedPrefs = LoginParameters.getContext().getSharedPreferences("SSL_CERTIFICATE", 0);
                                editor = sharedPrefs.edit();
                                editor.putString("SSL_CERTIFICATE", LoginParameters.getSSLCert());
                                editor.commit();
                            }
                            catch (Exception ex) {
                                Logger.log(8, AuthenticationService.class.getSimpleName(), "getMessagesInLoopFromServer", "Error caught while inserting SSL certificate into FrameworkSettings." + ex.getMessage());
                            }
                            continue block18;
                        }
                        if (!ModifiedX509TrustManager.isCertificateAccepted() && !ModifiedX509TrustManager.isAlreadyTrusted) ** break;
                        continue block18;
                        if (this.notificationListener == null) {
                            this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                        }
                        if (Logger.getDefaultLogLevel() == 9) {
                            Logger.d("Data Retriever Abort");
                        }
                        if (this.notificationListener != null) {
                            t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    DataRetrieverService.this.notificationListener.notifyDataRetreiverAbort();
                                }
                            });
                            t.start();
                        }
                        return;
                    }
                }
                break;
            }
            ProgressMonitor.displayProgressBar = true;
            if (this.notificationListener == null) {
                this.notificationListener = SyncEngine.getInstance().getNotificationListener();
            }
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("Data Retriever Abort");
            }
            if (this.notificationListener != null) {
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DataRetrieverService.this.notificationListener.notifyDataRetreiverAbort();
                    }
                });
                t.start();
            }
            Logger.log(8, this.getClass().getName(), "getMessagesInLoopFromServer", "Incorrect response from server for getmessage. Response code: " + httpResponse.getResponseCode() + " Error Message: " + httpResponse.getErrorMessage());
            return;
        }
    }

    private class DataRetrieverThread
    extends Thread {
        private DataRetrieverThread() {
        }

        @Override
        public void run() {
            if (DataSender.getInstance().isAlive()) {
                Logger.i("DataRetrieverThread run: Data Sender Running. So Exiting Data Retriever.");
                return;
            }
            DataRetrieverService.this.getMessagesInLoopFromServer();
            if (DataRetrieverService.this.notificationListener == null) {
                DataRetrieverService.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
            }
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("Data Retriever Completed");
            }
            if (DataRetrieverService.this.notificationListener != null) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DataRetrieverService.this.notificationListener.notifyDataReceiveCompletion();
                    }
                });
                t.start();
            }
            DataRetrieverService.this.dataRetrieverThread = null;
        }
    }
}

