/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.in;

import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.InObject;
import com.unvired.utils.FrameworkHelper;

public class Inbox {
    private static Inbox inbox = null;
    private IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();

    private Inbox() {
    }

    public static Inbox getInstance() {
        if (inbox == null) {
            inbox = new Inbox();
        }
        if (Inbox.inbox.frameworkDataManager == null) {
            Inbox.inbox.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        }
        return inbox;
    }

    public static void destroy() {
        if (inbox != null) {
            Inbox.inbox.frameworkDataManager = null;
            inbox = null;
            Logger.log(7, Inbox.class.getName(), "destroy", "Destroyed");
        } else {
            Logger.log(7, Inbox.class.getName(), "destroy", "Destroy not required. Already null.");
        }
    }

    public void add(InObject inObject) throws DBException, ApplicationException {
        if (inObject == null) {
            Logger.log(8, this.getClass().getName(), "add", "InObject cannot be null.");
            return;
        }
        String conversationId = inObject.getConversationId();
        if (conversationId == null || conversationId.length() <= 0) {
            throw new ApplicationException(this.getClass().getName(), "add", "Conversation Id cannot be empty. Conv Id: " + conversationId);
        }
        String messageType = inObject.getMessageType();
        byte[] message = inObject.getXml();
        if (Logger.getDefaultLogLevel() == 9) {
            Logger.log(9, this.getClass().getName(), "add", "Conversation Id: " + conversationId);
            Logger.log(9, this.getClass().getName(), "add", "Message Type: " + messageType);
            Logger.log(9, this.getClass().getName(), "add", "Message:" + message);
        }
        int presentOrNot = 0;
        String whereClause = InObject.CONVERSATION_ID + " = '" + conversationId + "'";
        if (this.frameworkDataManager != null) {
            presentOrNot = this.frameworkDataManager.count(InObject.TABLE_NAME, whereClause);
        }
        if (presentOrNot != 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "add", "Duplicate message from server. Conversation Id: " + conversationId);
                Logger.log(9, this.getClass().getName(), "add", "Message:" + message);
            }
            throw new DBException(this.getClass().getName(), "add", "Duplicate conversation id from server");
        }
        if (this.frameworkDataManager != null) {
            InObject inObj = inObject;
            this.frameworkDataManager.insert(inObj);
            Logger.log(9, this.getClass().getName(), "add", "InObject inserted successfully in database, conversation id: " + conversationId + " , LID: " + inObject.getLid());
        }
    }

    public void remove(String conversationId) throws DBException {
        if (conversationId == null || conversationId.length() <= 0) {
            Logger.log(8, this.getClass().getName(), "add", "Conversation Id cannot be empty. Conv Id: " + conversationId);
            return;
        }
        if (Logger.getDefaultLogLevel() == 9) {
            Logger.log(9, this.getClass().getName(), "remove", "Conversation Id: " + conversationId);
        }
        String whereClause = InObject.CONVERSATION_ID + " = '" + conversationId + "'";
        if (this.frameworkDataManager != null) {
            this.frameworkDataManager.delete(InObject.TABLE_NAME, whereClause);
            FrameworkHelper.deleteInboxFile(conversationId);
            Logger.log(9, this.getClass().getName(), "remove", "InObject removed successfully from database, conversation id: " + conversationId);
        }
    }

    public void resetAll() throws DBException {
        if (this.frameworkDataManager != null) {
            this.frameworkDataManager.delete(InObject.TABLE_NAME);
            Logger.log(9, this.getClass().getName(), "resetAll", "Deleted all inobject from database.");
        }
    }

    public boolean contains(String conversationId) throws DBException {
        if (conversationId == null || conversationId.length() <= 0) {
            return false;
        }
        Logger.log(9, this.getClass().getName(), "contains", "Conversation Id: " + conversationId);
        String whereClause = InObject.TABLE_NAME + " = '" + conversationId + "'";
        int count = 0;
        if (this.frameworkDataManager != null) {
            count = this.frameworkDataManager.count(InObject.TABLE_NAME, whereClause);
        }
        if (count != 0) {
            Logger.log(9, this.getClass().getName(), "contains", "InObject present in database, conversationId: " + conversationId);
            return true;
        }
        Logger.log(9, this.getClass().getName(), "contains", "InObject is not present in database, conversationId: " + conversationId);
        return false;
    }

    public InObject getNext() throws DBException {
        String[] orderBy = new String[]{"TIME_STAMP"};
        IDataStructure[] dataStructures = null;
        if (this.frameworkDataManager != null) {
            dataStructures = this.frameworkDataManager.get(InObject.TABLE_NAME, orderBy, InObject.class);
        }
        if (dataStructures == null || dataStructures.length == 0) {
            Logger.log(9, this.getClass().getName(), "getNext", "No inobjects in database");
            return null;
        }
        InObject inObject = (InObject)dataStructures[0];
        return inObject;
    }

    public InObject[] getInObjects() throws DBException {
        InObject[] inObjects;
        IDataStructure[] dataStructures = null;
        if (this.frameworkDataManager != null) {
            dataStructures = this.frameworkDataManager.get(InObject.TABLE_NAME, InObject.class);
        }
        if ((inObjects = this.inObjectArrayCopy(dataStructures)) == null || inObjects.length == 0) {
            Logger.log(9, this.getClass().getName(), "getAllInObjects", "No such outobject present in database.");
            return null;
        }
        return inObjects;
    }

    public boolean hasAnyInObject() throws DBException {
        int presentOrNot = 0;
        if (this.frameworkDataManager != null) {
            presentOrNot = this.frameworkDataManager.count(InObject.TABLE_NAME, null);
        }
        if (presentOrNot != 0) {
            Logger.log(9, this.getClass().getName(), "hasAnyInObject", "InObjects present in database");
            return true;
        }
        Logger.log(9, this.getClass().getName(), "hasAnyInObject", "No inObjects is not present in database");
        return false;
    }

    public int count() throws DBException {
        if (this.frameworkDataManager != null) {
            return this.frameworkDataManager.count(InObject.TABLE_NAME, "");
        }
        return 0;
    }

    private InObject[] inObjectArrayCopy(IDataStructure[] dataStructures) throws DBException {
        if (dataStructures == null || dataStructures.length == 0) {
            return null;
        }
        InObject[] inObjects = new InObject[dataStructures.length];
        try {
            System.arraycopy(dataStructures, 0, inObjects, 0, dataStructures.length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.e("inObjectArrayCopy", indexOutOfBoundsException);
            throw new DBException(this.getClass().getName(), "inObjectArrayCopy", indexOutOfBoundsException.getMessage());
        }
        catch (ArrayStoreException arrayStoreException) {
            Logger.e("inObjectArrayCopy", arrayStoreException);
            throw new DBException(this.getClass().getName(), "inObjectArrayCopy", arrayStoreException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            Logger.e("inObjectArrayCopy", nullPointerException);
            throw new DBException(this.getClass().getName(), "inObjectArrayCopy", nullPointerException.getMessage());
        }
        return inObjects;
    }
}

