/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.in;

import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.logger.Logger;
import com.unvired.model.InObject;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.in.AsyncJSONDataHandler;
import com.unvired.sync.in.AsyncXMLDataHandler;
import com.unvired.sync.in.Inbox;
import com.unvired.sync.in.SystemMessageHandler;
import com.unvired.sync.notifier.SynchronizationStateListener;
import com.unvired.sync.out.DataSender;
import com.unvired.sync.out.SentItems;
import com.unvired.utils.Utils;

public class InboxHandler {
    private static InboxHandler inboxHandler;
    private InboxHandlerThread inboxHandlerThread = new InboxHandlerThread();

    private InboxHandler() {
        this.inboxHandlerThread.setPriority(1);
        this.inboxHandlerThread.start();
    }

    public static InboxHandler getInstance() {
        if (inboxHandler == null) {
            inboxHandler = new InboxHandler();
        }
        return inboxHandler;
    }

    public void start() {
        if (this.inboxHandlerThread == null) {
            this.inboxHandlerThread = new InboxHandlerThread();
            this.inboxHandlerThread.setPriority(1);
            this.inboxHandlerThread.start();
        }
    }

    public void stop() {
        if (this.inboxHandlerThread == null) {
            return;
        }
        this.inboxHandlerThread.stopThread();
        try {
            this.inboxHandlerThread.interrupt();
        }
        catch (Exception e) {
            Logger.e("Exception caught while stopping InboxHandler Thread.", e);
        }
        finally {
            this.inboxHandlerThread = null;
            inboxHandler = null;
        }
    }

    public static void destroy() {
        if (inboxHandler != null) {
            InboxHandler.inboxHandler.inboxHandlerThread = null;
            inboxHandler = null;
            Logger.log(7, Inbox.class.getName(), "destroy", "Destroyed");
        } else {
            Logger.log(7, Inbox.class.getName(), "destroy", "Destroy not required. Already null.");
        }
    }

    public boolean isAlive() {
        return this.inboxHandlerThread != null;
    }

    class InboxHandlerThread
    extends Thread {
        private boolean stop = false;

        InboxHandlerThread() {
        }

        public void stopThread() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logger.log(9, this.getClass().getName(), "run", "InboxHandler Start - " + this.getName());
            try {
                InObject inObject = null;
                boolean inObjectProcessed = false;
                while (!this.stop) {
                    inObject = null;
                    String savePointName = Utils.getSavePointName();
                    try {
                        SynchronizationStateListener synchronizationStateListener;
                        inObject = Inbox.getInstance().getNext();
                        ApplicationManager.getInstance().getDataManager().createSavepoint(savePointName);
                        if (inObject == null) {
                            Logger.i("No inObject to proceed");
                            synchronizationStateListener = SyncEngine.getInstance().getSynchronizationStateListener();
                            if (synchronizationStateListener != null) {
                                synchronizationStateListener.idle();
                            }
                            DataSender.getInstance().unblock();
                            if (inObjectProcessed) {
                                inObjectProcessed = false;
                                Logger.d("Incoming data processing finished");
                                SyncEngine.getInstance().getNotificationListener().notifyIncomingDataProcessingFinished();
                            }
                            InboxHandler.this.inboxHandlerThread = null;
                            return;
                        }
                        inObjectProcessed = true;
                        Logger.d("Inbox Handler handling: " + inObject.getConversationId());
                        synchronizationStateListener = SyncEngine.getInstance().getSynchronizationStateListener();
                        if (synchronizationStateListener != null) {
                            synchronizationStateListener.processing(Inbox.getInstance().count());
                        }
                        DataSender.getInstance().block();
                        this.handleInObject(inObject);
                    }
                    catch (DBException dbException) {
                        ApplicationManager.getInstance().getDataManager().rollbackToSavepoint(savePointName);
                        Logger.e("DBException caught in InboxHandler", dbException);
                        this.stop = true;
                    }
                    catch (InterruptedException e) {
                        ApplicationManager.getInstance().getDataManager().rollbackToSavepoint(savePointName);
                        Logger.e("Inbox Handler interrupted : ", e);
                        Logger.log(7, this.getClass().getName(), "run", "InboxHandler Stop after interruption - " + this.getName());
                        this.stop = true;
                    }
                    catch (Throwable e) {
                        ApplicationManager.getInstance().getDataManager().rollbackToSavepoint(savePointName);
                        Logger.log(8, this.getClass().getName(), "run", "Exception while processing incoming message: " + e.getMessage());
                        if (inObject == null) continue;
                        try {
                            Inbox.getInstance().remove(inObject.getConversationId());
                            SentItems.getInstance().remove(inObject.getConversationId());
                        }
                        catch (DBException dbException) {
                            Logger.log(8, this.getClass().getName(), "run", dbException.getMessage());
                        }
                    }
                    finally {
                        ApplicationManager.getInstance().getDataManager().releaseSavepoint(savePointName);
                        DataSender.getInstance().unblock();
                    }
                }
                DataSender.getInstance().unblock();
                Logger.log(9, this.getClass().getName(), "run", "InboxHandler Stop - " + this.getName());
                InboxHandler.this.inboxHandlerThread = null;
            }
            catch (Exception e) {
                Logger.e(e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleInObject(InObject inObject) throws Exception {
            InObject inObject2 = inObject;
            synchronized (inObject2) {
                String messageTypeString = inObject.getMessageType();
                int messageType = Integer.parseInt(messageTypeString);
                switch (messageType) {
                    case 9000: {
                        new SystemMessageHandler(inObject);
                        break;
                    }
                    case 8000: {
                        String dataFormat = FrameworkSettingsManager.getInstance().getDataFormat();
                        if ("XML".equalsIgnoreCase(dataFormat)) {
                            new AsyncXMLDataHandler(inObject);
                            break;
                        }
                        new AsyncJSONDataHandler(inObject);
                        break;
                    }
                    default: {
                        String conversationId = inObject.getConversationId();
                        String error = "Incorrect message type for the incoming data. Deleting the inObject. Message Type: " + messageTypeString + " Conversation Id: " + conversationId;
                        Logger.log(8, this.getClass().getName(), "handleInObject", error);
                        Inbox.getInstance().remove(conversationId);
                    }
                }
            }
        }
    }
}

