/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.in;

import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.DatabaseHelper;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.InObject;
import com.unvired.parser.IncomingMessageParser;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.in.Inbox;
import com.unvired.sync.notifier.NotificationListener;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.utils.FrameworkHelper;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;

public class IncomingDataHandler {
    public static void handleData(Hashtable serverHTTPFields, final byte[] bytes) {
        FrameworkSettingsManager frameworkSettingsManager;
        int messageSubTypeInt;
        int messageTypeInt;
        Logger.i("IncomingDataHandler handleData serverHTTPFields:" + serverHTTPFields);
        if (bytes == null) {
            Logger.log(8, IncomingDataHandler.class.getName(), "handleData", "Incoming bytes null. Cannot handle message");
            return;
        }
        final String conversationId = (String)serverHTTPFields.get("X-UNVIRED-CONVERSATION-ID");
        String serverID = (String)serverHTTPFields.get("X-UNVIRED-SERVER-ID");
        String messageType = (String)serverHTTPFields.get("X-UNVIRED-MESSAGE-TYPE");
        String messageSubType = (String)serverHTTPFields.get("X-UNVIRED-MESSAGE-SUB-TYPE");
        String applicationId = (String)serverHTTPFields.get("X-UNVIRED-APPLICATION-ID");
        String applicationName = (String)serverHTTPFields.get("X-UNVIRED-APPLICATION-NAME");
        String requestType = (String)serverHTTPFields.get("REQUEST_TYPE");
        Logger.log(7, IncomingDataHandler.class.getName(), "handleData", "******** Http Headers ********  \n CONVERSATION ID: " + conversationId + " SERVER ID: " + serverID + " MSG TYPE: " + messageType + " MSG SUB TYPE: " + messageSubType + " REQUEST TYPE: " + requestType);
        if (Strings.isNullOrEmpty((String)serverID)) {
            Logger.log(8, IncomingDataHandler.class.getName(), "handleData", "Ignoring message as the server id is null or empty.");
            return;
        }
        if (conversationId == null) {
            Logger.log(8, IncomingDataHandler.class.getName(), "handleData", "Incompatible data received. Conversation Id Null. Message Type: " + messageType);
            return;
        }
        try {
            messageTypeInt = Integer.parseInt(messageType);
            messageSubTypeInt = Integer.parseInt(messageSubType);
        }
        catch (NumberFormatException e) {
            Logger.log(8, IncomingDataHandler.class.getName(), "handleData", "Incorrect message type or sub type from server. Message Type: " + messageType + " Message Sub Type: " + messageSubType);
            return;
        }
        try {
            frameworkSettingsManager = FrameworkSettingsManager.getInstance();
        }
        catch (DBException dbException) {
            Logger.log(8, IncomingDataHandler.class.getName(), "handleData", "DBException caught while getting framework settings from database, " + dbException.getMessage());
            return;
        }
        if (frameworkSettingsManager == null) {
            Logger.log(8, IncomingDataHandler.class.getName(), "handleData", "No settings available for framework.");
            return;
        }
        try {
            if (frameworkSettingsManager.isActive() && !serverID.equals(frameworkSettingsManager.getServerId())) {
                Logger.log(8, IncomingDataHandler.class.getName(), "handleData", "Ignoring message as the server id did not match");
                return;
            }
        }
        catch (DBException dbe) {
            Logger.log(8, IncomingDataHandler.class.getName(), "handleData", "DBException caught while checking for application active or not, " + dbe.getMessage());
            return;
        }
        if (messageTypeInt == 5000) {
            Logger.log(7, IncomingDataHandler.class.getName(), "handleData", "WIPING DEVICE! Conversation Id: " + conversationId);
            IncomingDataHandler.wipe(bytes);
        }
        if (messageTypeInt == 8000 && (messageSubTypeInt == 700 || messageSubTypeInt == 900)) {
            if (SyncEngine.getInstance().getCustomDataHandler() != null) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Logger.log(7, IncomingDataHandler.class.getName(), "handleData", "Providing custom message to app for handling. Conversation Id: " + conversationId);
                            SyncEngine.getInstance().getCustomDataHandler().handleData(bytes);
                        }
                        catch (Exception e) {
                            Logger.log(8, IncomingDataHandler.class.getName(), "handleData", "Exception in custom data handler thread: " + e.getMessage());
                        }
                    }
                });
                t.start();
                return;
            }
            Logger.log(8, IncomingDataHandler.class.getName(), "handleData", "Ignoring custom/native message as custom handler is not set. Conversation Id: " + conversationId);
            return;
        }
        Logger.log(7, IncomingDataHandler.class.getName(), "handleData", "Incoming Data Adding data to Inbox - Conversation Id:" + conversationId);
        InObject inObject = new InObject();
        inObject.setConversationId(conversationId);
        inObject.setServerId(serverID);
        inObject.setMessageType(String.valueOf(messageType));
        inObject.setMessageSubType(String.valueOf(messageSubType));
        inObject.setAppId(applicationId);
        inObject.setAppName(applicationName);
        inObject.setRequestType(requestType);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        FrameworkHelper.copyIncomingDataToInboxFolder(inputStream, conversationId);
        try {
            Inbox.getInstance().add(inObject);
        }
        catch (DBException dbException) {
            Logger.e("DB Exception while saving inobject in database, ", dbException);
            return;
        }
        catch (ApplicationException e) {
            Logger.e("Application Exception while saving inobject in database,", e);
            return;
        }
    }

    private static void wipe(byte[] bytes) {
        IncomingMessageParser messageParser;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        try {
            messageParser = new IncomingMessageParser(byteArrayInputStream);
        }
        catch (Exception e) {
            Logger.log(8, IncomingDataHandler.class.getName(), "wipe", "Ignoring message due to an exception while processing incoming XML: " + e.getMessage());
            return;
        }
        String wipeURL = messageParser.getWipeURL();
        IncomingDataHandler.wipe(wipeURL);
    }

    private static void wipe(String wipeURL) {
        if (wipeURL == null) {
            Logger.log(7, IncomingDataHandler.class.getName(), "wipe", "Cannot inform IUB after wipe. URL null. ");
            return;
        }
        Logger.log(7, IncomingDataHandler.class.getName(), "wipe", "Informing IUB after wipe. URL: " + wipeURL);
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        FrameworkManager frameworkManager = FrameworkManager.getInstance();
        try {
            FrameworkHelper.stopThreads();
            applicationManager.closeDB();
            frameworkManager.closeDB();
            applicationManager.dropDatabase();
            frameworkManager.dropDatabase();
        }
        catch (DBException dbException) {
            Logger.log(8, IncomingDataHandler.class.getName(), "wipe", dbException.getMessage());
            try {
                DatabaseHelper.deleteDatabases(true);
            }
            catch (Exception exception) {
                Logger.log(8, IncomingDataHandler.class.getName(), "wipe", exception.getMessage());
            }
        }
        try {
            HTTPConnection.sendWipeConfirmation(wipeURL);
        }
        catch (Exception e) {
            Logger.log(8, IncomingDataHandler.class.getCanonicalName(), "wipe", "Error while notifying Wipe confirmation." + e.getMessage());
        }
        FrameworkHelper.shutdown();
        final NotificationListener notificationListener = SyncEngine.getInstance().getNotificationListener();
        if (Logger.getDefaultLogLevel() == 9) {
            Logger.d("Application Reset");
        }
        if (notificationListener != null) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    notificationListener.notifyApplicationReset();
                }
            });
            t.start();
        }
    }
}

