/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.in;

import com.google.common.base.Strings;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentItem;
import com.unvired.model.ReconcileObject;
import com.unvired.sync.attachment.Attachment;
import com.unvired.sync.in.ConflictBE;
import java.util.Hashtable;
import java.util.Vector;

public class PullPushQueryBEReconciler {
    private IDataManager dataManager;
    private ReconcileObject reconcileObject;
    private IDataStructure currentIncomingHeader = null;
    private Hashtable<String, Vector<String>> incomingItemsCollection = new Hashtable();
    private Hashtable<String, Vector<String>> incomingAttachmentItemsCollection = new Hashtable();
    private ConflictBE conflictBE = null;
    private String conflictRule = null;

    public PullPushQueryBEReconciler(String conflictRule) {
        this.conflictRule = Strings.isNullOrEmpty((String)conflictRule) ? "SERVER_WINS" : conflictRule;
    }

    public ConflictBE reconcile(IDataManager dataManager, ReconcileObject reconcileObject, IDataStructure currentIncomingHeader, Vector<IDataStructure> currentIncomingItems) throws DBException, ApplicationException {
        this.dataManager = dataManager;
        this.reconcileObject = reconcileObject;
        this.currentIncomingHeader = currentIncomingHeader;
        switch (reconcileObject.getObjectStatus()) {
            case GLOBAL: {
                this.actionHeaderForGlobal();
                break;
            }
            case ADD: {
                this.actionHeaderForAdd();
                break;
            }
            case MODIFY: {
                this.actionHeaderForModify();
                break;
            }
            case DELETE: {
                this.actionHeaderForDelete();
                break;
            }
        }
        int currentIncomingItemsSize = currentIncomingItems.size();
        IDataStructure incomingItemDataStructure = null;
        IDataStructure itemDataStructureInDB = null;
        for (int i = 0; i < currentIncomingItemsSize; ++i) {
            incomingItemDataStructure = currentIncomingItems.elementAt(i);
            itemDataStructureInDB = dataManager.getBasedOnGID(incomingItemDataStructure);
            if (incomingItemDataStructure instanceof AttachmentItem) {
                this.handleAttachmentItems(itemDataStructureInDB, incomingItemDataStructure);
                continue;
            }
            this.handleItems(itemDataStructureInDB, incomingItemDataStructure);
        }
        this.handleDeletionOfItemsInDBWithoutIncomingItems();
        this.handleDeletionOfAttachmentItemsInDBWithoutIncomingItems();
        return this.conflictBE;
    }

    private void handleDeletionOfItemsInDBWithoutIncomingItems() throws DBException, ApplicationException {
        String[] childrenTableNames = this.currentIncomingHeader.getChildrenTableNames();
        if (childrenTableNames != null && childrenTableNames.length > 0) {
            for (int i = 0; i < childrenTableNames.length; ++i) {
                if (childrenTableNames[i].contains("_ATTACHMENT")) continue;
                Vector<String> incomingItemLids = this.incomingItemsCollection.get(childrenTableNames[i]);
                IDataStructure[] itemsInDBWithoutIncomingItems = null;
                String whereClauseForExcludingIncomingItems = null;
                if (incomingItemLids != null && incomingItemLids.size() > 0) {
                    whereClauseForExcludingIncomingItems = "LID NOT IN (";
                    int incomingItemLidsSize = incomingItemLids.size();
                    String lid = null;
                    for (int j = 0; j < incomingItemLidsSize; ++j) {
                        lid = incomingItemLids.elementAt(j);
                        whereClauseForExcludingIncomingItems = whereClauseForExcludingIncomingItems + "'" + lid + "'";
                        if (j >= incomingItemLidsSize - 1) continue;
                        whereClauseForExcludingIncomingItems = whereClauseForExcludingIncomingItems + ",";
                    }
                    whereClauseForExcludingIncomingItems = whereClauseForExcludingIncomingItems + ")";
                    itemsInDBWithoutIncomingItems = this.dataManager.get(childrenTableNames[i], whereClauseForExcludingIncomingItems = whereClauseForExcludingIncomingItems + " AND " + "FID" + " = '" + this.reconcileObject.getLid() + "'");
                    if (itemsInDBWithoutIncomingItems == null || itemsInDBWithoutIncomingItems.length <= 0) continue;
                    this.actionOnItemsInDBWithoutIncomingItems(itemsInDBWithoutIncomingItems);
                    continue;
                }
                itemsInDBWithoutIncomingItems = this.dataManager.get(childrenTableNames[i], "FID= '" + this.reconcileObject.getLid() + "'");
                if (itemsInDBWithoutIncomingItems == null || itemsInDBWithoutIncomingItems.length <= 0) continue;
                this.actionOnItemsInDBWithoutIncomingItems(itemsInDBWithoutIncomingItems);
            }
        }
    }

    private void handleDeletionOfAttachmentItemsInDBWithoutIncomingItems() throws DBException, ApplicationException {
        String[] childrenTableNames = this.currentIncomingHeader.getChildrenTableNames();
        if (childrenTableNames != null && childrenTableNames.length > 0) {
            for (int i = 0; i < childrenTableNames.length; ++i) {
                if (!childrenTableNames[i].contains("_ATTACHMENT")) continue;
                Vector<String> incomingAttachmentItemLids = this.incomingAttachmentItemsCollection.get(childrenTableNames[i]);
                IDataStructure[] attachmentItemsInDBWithoutIncomingItems = null;
                String whereClauseForExcludingIncomingAttachmentItems = null;
                if (incomingAttachmentItemLids != null && incomingAttachmentItemLids.size() > 0) {
                    whereClauseForExcludingIncomingAttachmentItems = "LID NOT IN (";
                    int incomingItemLidsSize = incomingAttachmentItemLids.size();
                    String lid = null;
                    for (int j = 0; j < incomingItemLidsSize; ++j) {
                        lid = incomingAttachmentItemLids.elementAt(j);
                        whereClauseForExcludingIncomingAttachmentItems = whereClauseForExcludingIncomingAttachmentItems + "'" + lid + "'";
                        if (j >= incomingItemLidsSize - 1) continue;
                        whereClauseForExcludingIncomingAttachmentItems = whereClauseForExcludingIncomingAttachmentItems + ",";
                    }
                    whereClauseForExcludingIncomingAttachmentItems = whereClauseForExcludingIncomingAttachmentItems + ")";
                    attachmentItemsInDBWithoutIncomingItems = this.dataManager.get(childrenTableNames[i], whereClauseForExcludingIncomingAttachmentItems = whereClauseForExcludingIncomingAttachmentItems + " AND " + "FID" + " = '" + this.reconcileObject.getLid() + "'");
                    if (attachmentItemsInDBWithoutIncomingItems == null || attachmentItemsInDBWithoutIncomingItems.length <= 0) continue;
                    this.actionOnAttachmentItemsInDBWithoutIncomingItems(attachmentItemsInDBWithoutIncomingItems);
                    continue;
                }
                attachmentItemsInDBWithoutIncomingItems = this.dataManager.get(childrenTableNames[i], "FID= '" + this.reconcileObject.getLid() + "'");
                if (attachmentItemsInDBWithoutIncomingItems == null || attachmentItemsInDBWithoutIncomingItems.length <= 0) continue;
                this.actionOnAttachmentItemsInDBWithoutIncomingItems(attachmentItemsInDBWithoutIncomingItems);
            }
        }
    }

    private void handleItems(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) throws DBException, ApplicationException {
        if (itemDataStructureInDB == null) {
            incomingItemDataStructure.setFid(this.reconcileObject.getLid());
            incomingItemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
            incomingItemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
            try {
                this.dataManager.insert(incomingItemDataStructure);
            }
            catch (DBException e) {
                throw (DBException)this.getException(e.getMessage(), "handleItems", incomingItemDataStructure, true);
            }
        } else {
            switch (itemDataStructureInDB.getObjectStatus()) {
                case GLOBAL: {
                    this.actionOnIncomingItemForGlobal(itemDataStructureInDB, incomingItemDataStructure);
                    break;
                }
                case ADD: {
                    this.actionOnIncomingItemForAdd(itemDataStructureInDB, incomingItemDataStructure);
                    break;
                }
                case MODIFY: {
                    this.actionOnIncomingItemForModify(itemDataStructureInDB, incomingItemDataStructure);
                    break;
                }
                case DELETE: {
                    this.actionOnIncomingItemForDelete(itemDataStructureInDB, incomingItemDataStructure);
                    break;
                }
            }
        }
        this.addItemToCollection(incomingItemDataStructure);
    }

    private void handleAttachmentItems(IDataStructure attachmentItemDataStructureInDB, IDataStructure incomingAttachmentItemDataStructure) throws DBException, ApplicationException {
        if (attachmentItemDataStructureInDB == null) {
            incomingAttachmentItemDataStructure.setFid(this.reconcileObject.getLid());
            incomingAttachmentItemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
            incomingAttachmentItemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
            try {
                AttachmentItem attachmentItem = (AttachmentItem)incomingAttachmentItemDataStructure;
                attachmentItem.setFileName(Attachment.setFileNameWithUid(attachmentItem));
                this.dataManager.insert(attachmentItem);
            }
            catch (DBException e) {
                throw (DBException)this.getException(e.getMessage(), "handleAttachmentItems", incomingAttachmentItemDataStructure, true);
            }
        } else {
            switch (attachmentItemDataStructureInDB.getObjectStatus()) {
                case GLOBAL: {
                    this.actionOnIncomingAttachmentItemForGlobal(attachmentItemDataStructureInDB, incomingAttachmentItemDataStructure);
                    break;
                }
                case ADD: {
                    this.actionOnIncomingAttachmentItemForAdd(attachmentItemDataStructureInDB);
                    break;
                }
                case MODIFY: {
                    this.actionOnIncomingAttachmentItemForModify(attachmentItemDataStructureInDB);
                    break;
                }
                case DELETE: {
                    this.actionOnIncomingAttachmentItemForDelete(attachmentItemDataStructureInDB);
                    break;
                }
            }
        }
        this.addAttachmentItemToCollection(incomingAttachmentItemDataStructure);
        Attachment.checkAttachmentAndQueueAutoDownload(incomingAttachmentItemDataStructure);
    }

    private void actionOnIncomingAttachmentItemForGlobal(IDataStructure attachmentItemDataStructureInDB, IDataStructure incomingAttachmentItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingAttachmentItemForGlobal", attachmentItemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: {
                this.setAttachmentItemFieldsAndStatuses(attachmentItemDataStructureInDB, incomingAttachmentItemDataStructure);
                try {
                    this.dataManager.update(incomingAttachmentItemDataStructure);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnIncomingAttachmentItemForGlobal", incomingAttachmentItemDataStructure, true);
                }
            }
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Invalid case. Items in this status should have OBJECT_STATUS as ADD, MODIFY or DELETE.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnIncomingAttachmentItemForGlobal", attachmentItemDataStructureInDB, false);
            }
        }
    }

    private void setAttachmentItemFieldsAndStatuses(IDataStructure attachmentItemDataStructureInDB, IDataStructure incomingAttachmentItemDataStructure) {
        incomingAttachmentItemDataStructure.setLid(attachmentItemDataStructureInDB.getLid());
        incomingAttachmentItemDataStructure.setFid(this.currentIncomingHeader.getLid());
        incomingAttachmentItemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
        incomingAttachmentItemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
        AttachmentItem attachmentItem = (AttachmentItem)incomingAttachmentItemDataStructure;
        attachmentItem.setFileName(Attachment.setFileNameWithUid((AttachmentItem)attachmentItemDataStructureInDB));
        attachmentItem.setLocalPath(((AttachmentItem)attachmentItemDataStructureInDB).getLocalPath());
    }

    private void actionOnIncomingAttachmentItemForAdd(IDataStructure attachmentItemDataStructureInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingAttachmentItemForAdd", attachmentItemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Do not touch. Has to be handled by the Attachment upload queue separately. For ERROR application has to resolve.";
                String message = this.getLoggerMessage(errorMsg, attachmentItemDataStructureInDB);
                Logger.log(9, this.getClass().getName(), "actionOnIncomingAttachmentItemForAdd", message);
                break;
            }
        }
    }

    private void actionOnIncomingAttachmentItemForModify(IDataStructure attachmentItemDataStructureInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingAttachmentItemForModify", attachmentItemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Do not touch. Device wins generally. Application and request-response has to handle";
                String message = this.getLoggerMessage(errorMsg, attachmentItemDataStructureInDB);
                Logger.log(9, this.getClass().getName(), "actionOnIncomingAttachmentItemForModify", message);
                break;
            }
        }
    }

    private void actionOnIncomingAttachmentItemForDelete(IDataStructure attachmentItemDataStructureInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingAttachmentItemForDelete", attachmentItemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Do not touch. Device wins generally. Application and request-response has to handle";
                String message = this.getLoggerMessage(errorMsg, attachmentItemDataStructureInDB);
                Logger.log(9, this.getClass().getName(), "actionOnIncomingAttachmentItemForDelete", message);
                break;
            }
        }
    }

    private void addItemToCollection(IDataStructure itemDataStructure) {
        if (itemDataStructure == null) {
            return;
        }
        String itemName = itemDataStructure.getTableName();
        Vector<String> items = this.incomingItemsCollection.get(itemName);
        if (items == null) {
            items = new Vector();
            this.incomingItemsCollection.put(itemName, items);
        }
        items.addElement(itemDataStructure.getLid());
    }

    private void addAttachmentItemToCollection(IDataStructure itemDataStructure) {
        if (itemDataStructure == null) {
            return;
        }
        String attachmentItemName = itemDataStructure.getTableName();
        Vector<String> attachmentItems = this.incomingAttachmentItemsCollection.get(attachmentItemName);
        if (attachmentItems == null) {
            attachmentItems = new Vector();
            this.incomingAttachmentItemsCollection.put(attachmentItemName, attachmentItems);
        }
        attachmentItems.addElement(itemDataStructure.getLid());
    }

    private void actionOnItemsInDBWithoutIncomingItems(IDataStructure[] itemsInDBWithoutIncomingItems) throws DBException, ApplicationException {
        IDataStructure itemInDB = null;
        block6: for (int i = 0; i < itemsInDBWithoutIncomingItems.length; ++i) {
            itemInDB = itemsInDBWithoutIncomingItems[i];
            switch (itemInDB.getObjectStatus()) {
                case GLOBAL: {
                    this.actionOnDBItemWithoutIncomingItemForGlobal(itemInDB);
                    continue block6;
                }
                case ADD: {
                    this.actionOnDBItemWithoutIncomingItemForAdd(itemInDB);
                    continue block6;
                }
                case MODIFY: {
                    this.actionOnDBItemWithoutIncomingItemForModify(itemInDB);
                    continue block6;
                }
                case DELETE: {
                    this.actionOnDBItemWithoutIncomingItemForDelete(itemInDB);
                    continue block6;
                }
            }
        }
    }

    private void actionOnAttachmentItemsInDBWithoutIncomingItems(IDataStructure[] attachmentItemsInDBWithoutIncomingItems) throws DBException, ApplicationException {
        IDataStructure attachmentItemInDB = null;
        block6: for (int i = 0; i < attachmentItemsInDBWithoutIncomingItems.length; ++i) {
            attachmentItemInDB = attachmentItemsInDBWithoutIncomingItems[i];
            if (!(attachmentItemInDB instanceof AttachmentItem)) continue;
            switch (attachmentItemInDB.getObjectStatus()) {
                case GLOBAL: {
                    this.actionOnDBAttachmentItemWithoutIncomingItemForGlobal(attachmentItemInDB);
                    continue block6;
                }
                case ADD: {
                    this.actionOnDBAttachmentItemWithoutIncomingItemForAdd(attachmentItemInDB);
                    continue block6;
                }
                case MODIFY: {
                    this.actionOnDBAttachmentItemWithoutIncomingItemForModify(attachmentItemInDB);
                    continue block6;
                }
                case DELETE: {
                    this.actionOnDBAttachmentItemWithoutIncomingItemForDelete(attachmentItemInDB);
                    continue block6;
                }
            }
        }
    }

    private void actionOnDBAttachmentItemWithoutIncomingItemForGlobal(IDataStructure attachmentItemInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBAttachmentItemWithoutIncomingItemForGlobal", attachmentItemInDB, false);
        }
        switch (syncStatus) {
            case NONE: {
                try {
                    this.dataManager.delete(attachmentItemInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBAttachmentItemWithoutIncomingItemForGlobal", attachmentItemInDB, true);
                }
            }
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Invalid case. Items in this status should have OBJECT_STATUS as ADD, MODIFY or DELETE.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnDBAttachmentItemWithoutIncomingItemForGlobal", attachmentItemInDB, false);
            }
        }
    }

    private void actionOnDBAttachmentItemWithoutIncomingItemForAdd(IDataStructure attachmentItemInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBAttachmentItemWithoutIncomingItemForAdd", attachmentItemInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Do not touch. Has to be handled by the Attachment upload queue separately. For ERROR application has to resolve.";
                String message = this.getLoggerMessage(errorMsg, attachmentItemInDB);
                Logger.log(9, this.getClass().getName(), "actionOnDBAttachmentItemWithoutIncomingItemForAdd", message);
                break;
            }
        }
    }

    private void actionOnDBAttachmentItemWithoutIncomingItemForModify(IDataStructure attachmentItemInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBAttachmentItemWithoutIncomingItemForModify", attachmentItemInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                try {
                    this.dataManager.delete(attachmentItemInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBAttachmentItemWithoutIncomingItemForModify", attachmentItemInDB, true);
                }
            }
        }
    }

    private void actionOnDBAttachmentItemWithoutIncomingItemForDelete(IDataStructure attachmentItemInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBAttachmentItemWithoutIncomingItemForDelete", attachmentItemInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                try {
                    this.dataManager.delete(attachmentItemInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBAttachmentItemWithoutIncomingItemForDelete", attachmentItemInDB, true);
                }
            }
        }
    }

    private void actionOnDBItemWithoutIncomingItemForGlobal(IDataStructure itemDataStructureInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBItemWithoutIncomingItemForGlobal", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: {
                try {
                    this.dataManager.delete(itemDataStructureInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBItemWithoutIncomingItemForGlobal", itemDataStructureInDB, true);
                }
            }
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Invalid case. Item in Object Status GLOBAL can only be in Sync Status NONE.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnDBItemWithoutIncomingItemForGlobal", itemDataStructureInDB, false);
            }
        }
    }

    private void actionOnDBItemWithoutIncomingItemForAdd(IDataStructure itemDataStructureInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBItemWithoutIncomingItemForAdd", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Do not touch. Has to be handled by request-response. For ERROR application has to decide.";
                String message = this.getLoggerMessage(errorMsg, itemDataStructureInDB);
                Logger.log(9, this.getClass().getName(), "actionOnDBItemWithoutIncomingItemForAdd", message);
                break;
            }
        }
    }

    private void actionOnDBItemWithoutIncomingItemForModify(IDataStructure itemDataStructureInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBItemWithoutIncomingItemForModify", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                try {
                    this.dataManager.delete(itemDataStructureInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBItemWithoutIncomingItemForModify", itemDataStructureInDB, true);
                }
            }
        }
    }

    private void actionOnDBItemWithoutIncomingItemForDelete(IDataStructure itemDataStructureInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBItemWithoutIncomingItemForDelete", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                try {
                    this.dataManager.delete(itemDataStructureInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBItemWithoutIncomingItemForDelete", itemDataStructureInDB, true);
                }
            }
        }
    }

    private void actionHeaderForGlobal() throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = this.reconcileObject.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionHeaderForGlobal");
        }
        switch (syncStatus) {
            case NONE: {
                this.setHeaderFieldsAndStatuses();
                try {
                    this.dataManager.update(this.currentIncomingHeader);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionHeaderForGlobal", this.currentIncomingHeader, true);
                }
            }
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Invalid case. Header in Object Status GLOBAL can only be in Sync Status NONE.";
                throw (ApplicationException)this.getException(errorMsg, "actionHeaderForGlobal");
            }
        }
    }

    private void setHeaderFieldsAndStatuses() {
        this.currentIncomingHeader.setLid(this.reconcileObject.getLid());
        this.currentIncomingHeader.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
        this.currentIncomingHeader.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
    }

    private void actionHeaderForAdd() throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = this.reconcileObject.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionHeaderForAdd");
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Invalid case. Cannot relate device Add to server BE.";
                throw (ApplicationException)this.getException(errorMsg, "actionHeaderForAdd");
            }
        }
    }

    private void actionHeaderForModify() throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = this.reconcileObject.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionHeaderForModify");
        }
        switch (syncStatus) {
            case SENT: {
                String errorMsg = "Do not touch. Has to be handled by request-response";
                String message = this.getLoggerMessage(errorMsg);
                Logger.log(9, this.getClass().getName(), "actionHeaderForModify", message);
                break;
            }
            case NONE: 
            case QUEUED: 
            case ERROR: {
                this.handleHeaderConflict();
                break;
            }
        }
    }

    private void handleHeaderConflict() throws DBException {
        if (Strings.isNullOrEmpty((String)this.conflictRule)) {
            return;
        }
        switch (this.conflictRule) {
            case "SERVER_WINS": {
                this.setHeaderFieldsAndStatuses();
                try {
                    this.dataManager.update(this.currentIncomingHeader);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "handleHeaderConflict", this.currentIncomingHeader, true);
                }
            }
            case "APP_HANDLED": {
                IDataStructure[] structures;
                if (this.conflictBE == null && (structures = this.dataManager.get(this.currentIncomingHeader.getTableName(), "LID = '" + this.reconcileObject.getLid() + "'")) != null && structures.length > 0) {
                    this.conflictBE = new ConflictBE(structures[0], this.currentIncomingHeader);
                }
                this.conflictBE.setHeaderInConflict();
                break;
            }
        }
    }

    private void handleItemConflict(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) throws DBException {
        if (Strings.isNullOrEmpty((String)this.conflictRule)) {
            return;
        }
        switch (this.conflictRule) {
            case "SERVER_WINS": {
                this.setItemFieldsAndStatuses(itemDataStructureInDB, incomingItemDataStructure);
                try {
                    this.dataManager.update(incomingItemDataStructure);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "handleItemConflict", this.currentIncomingHeader, true);
                }
            }
            case "APP_HANDLED": {
                IDataStructure[] structures;
                if (this.conflictBE == null && (structures = this.dataManager.get(this.currentIncomingHeader.getTableName(), "LID = '" + this.reconcileObject.getLid() + "'")) != null && structures.length > 0) {
                    this.conflictBE = new ConflictBE(structures[0], this.currentIncomingHeader);
                }
                this.conflictBE.setItemInConflict(itemDataStructureInDB, incomingItemDataStructure);
                break;
            }
        }
    }

    private void actionHeaderForDelete() throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = this.reconcileObject.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionHeaderForDelete");
        }
        switch (syncStatus) {
            case SENT: {
                String errorMsg = "Do not touch. Has to be handled by request-response";
                String message = this.getLoggerMessage(errorMsg);
                Logger.log(9, this.getClass().getName(), "actionHeaderForDelete", message);
                break;
            }
            case NONE: 
            case QUEUED: 
            case ERROR: {
                this.handleHeaderConflict();
                break;
            }
        }
    }

    private void actionOnIncomingItemForGlobal(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingItemForGlobal", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: {
                this.setItemFieldsAndStatuses(itemDataStructureInDB, incomingItemDataStructure);
                try {
                    this.dataManager.update(incomingItemDataStructure);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnIncomingItemForGlobal", incomingItemDataStructure, true);
                }
            }
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Invalid case. Items in Object Status GLOBAL can only be in Sync Status NONE.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnIncomingItemForGlobal", itemDataStructureInDB, false);
            }
        }
    }

    private void setItemFieldsAndStatuses(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) {
        incomingItemDataStructure.setLid(itemDataStructureInDB.getLid());
        incomingItemDataStructure.setFid(this.currentIncomingHeader.getLid());
        incomingItemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
        incomingItemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
    }

    private void actionOnIncomingItemForAdd(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingItemForAdd", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Do not touch. Has to be handled by request-response";
                String message = this.getLoggerMessage(errorMsg, itemDataStructureInDB);
                Logger.log(9, this.getClass().getName(), "actionOnIncomingItemForAdd", message);
                break;
            }
        }
    }

    private void actionOnIncomingItemForModify(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingItemForModify", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case ERROR: {
                this.handleItemConflict(itemDataStructureInDB, incomingItemDataStructure);
                break;
            }
            case SENT: {
                String errorMsg = "Do not touch. Has to be handled by request-response";
                String message = this.getLoggerMessage(errorMsg, itemDataStructureInDB);
                Logger.log(9, this.getClass().getName(), "actionOnIncomingItemForModify", message);
                break;
            }
        }
    }

    private void actionOnIncomingItemForDelete(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingItemForDelete", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case ERROR: {
                this.handleItemConflict(itemDataStructureInDB, incomingItemDataStructure);
                break;
            }
            case SENT: {
                String errorMsg = "Do not touch. Has to be handled by request-response";
                String message = this.getLoggerMessage(errorMsg, itemDataStructureInDB);
                Logger.log(9, this.getClass().getName(), "actionOnIncomingItemForDelete", message);
                break;
            }
        }
    }

    private Exception getException(String message, String methodName, IDataStructure dataStructure, boolean dbException) throws DBException {
        String beName = dataStructure.getBEName();
        String itemName = dataStructure.getTableName();
        String[] gidFieldNames = dataStructure.getGidFieldNames();
        Object[] gidFieldValues = dataStructure.getGids();
        String concatenatedGIDFieldNames = "";
        String concatenetedGIDFieldValues = "";
        for (int i = 0; i < gidFieldNames.length; ++i) {
            if (gidFieldNames.length > 1) {
                concatenatedGIDFieldNames = concatenatedGIDFieldNames + "-" + gidFieldNames[i];
                concatenetedGIDFieldValues = concatenetedGIDFieldValues + "-" + gidFieldValues[i];
                continue;
            }
            concatenatedGIDFieldNames = gidFieldNames[i];
            concatenetedGIDFieldValues = concatenetedGIDFieldValues + gidFieldValues[i];
        }
        message = this.getLoggerMessage(message, dataStructure);
        Exception exception = null;
        if (dbException) {
            Logger.log(8, this.getClass().getName(), methodName, message);
            exception = new DBException(this.getClass().getName(), methodName, message);
        } else {
            Logger.log(9, this.getClass().getName(), methodName, message);
            exception = new ApplicationException(this.getClass().getName(), methodName, message);
        }
        return exception;
    }

    private Exception getException(String message, String methodName) throws DBException {
        message = this.getLoggerMessage(message);
        ApplicationException exception = null;
        Logger.log(9, this.getClass().getName(), methodName, message);
        exception = new ApplicationException(this.getClass().getName(), methodName, message);
        return exception;
    }

    private String getLoggerMessage(String message, IDataStructure dataStructure) throws DBException {
        String beName = dataStructure.getBEName();
        String itemName = dataStructure.getTableName();
        String[] gidFieldNames = dataStructure.getGidFieldNames();
        Object[] gidFieldValues = dataStructure.getGids();
        String concatenatedGIDFieldNames = "";
        String concatenetedGIDFieldValues = "";
        for (int i = 0; i < gidFieldNames.length; ++i) {
            if (gidFieldNames.length > 1) {
                concatenatedGIDFieldNames = concatenatedGIDFieldNames + "-" + gidFieldNames[i];
                concatenetedGIDFieldValues = concatenetedGIDFieldValues + "-" + gidFieldValues[i];
                continue;
            }
            concatenatedGIDFieldNames = gidFieldNames[i];
            concatenetedGIDFieldValues = concatenetedGIDFieldValues + gidFieldValues[i];
        }
        message = message + ": " + "BE Name: " + beName + ", Item Name: " + itemName + ", GID Field Names: " + concatenatedGIDFieldNames + ", GID Field Values: " + concatenetedGIDFieldValues + ", Object Status: " + (Object)((Object)dataStructure.getObjectStatus()) + ", Sync Status: " + (Object)((Object)dataStructure.getSyncStatus());
        return message;
    }

    private String getLoggerMessage(String message) throws DBException {
        return message + ":  LID : " + this.reconcileObject.getLid() + ", Object Status: " + (Object)((Object)this.reconcileObject.getObjectStatus()) + ", Sync Status: " + (Object)((Object)this.reconcileObject.getSyncStatus());
    }
}

