/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.in;

import com.google.common.base.Strings;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentItem;
import com.unvired.sync.attachment.Attachment;
import com.unvired.sync.in.ConflictBE;
import java.util.Hashtable;
import java.util.Vector;

public class RequestResponseBEReconciler {
    private IDataManager dataManager;
    private IDataStructure currentDBHeader;
    private IDataStructure currentIncomingHeader = null;
    private Hashtable<String, Vector<String>> incomingItemsCollection = new Hashtable();
    private Hashtable<String, Vector<String>> incomingAttachmentItemsCollection = new Hashtable();
    private ConflictBE conflictBE = null;
    private String conflictRule = null;
    private boolean syncMode;

    public RequestResponseBEReconciler(String conflictRule) {
        this.conflictRule = Strings.isNullOrEmpty((String)conflictRule) ? "SERVER_WINS" : conflictRule;
    }

    public ConflictBE reconcile(IDataManager dataManager, IDataStructure currentDBHeader, IDataStructure currentIncomingHeader, Vector<IDataStructure> currentIncomingItems, boolean syncMode) throws DBException, ApplicationException {
        this.dataManager = dataManager;
        this.currentDBHeader = currentDBHeader;
        this.currentIncomingHeader = currentIncomingHeader;
        this.syncMode = syncMode;
        switch (currentDBHeader.getObjectStatus()) {
            case GLOBAL: {
                this.actionHeaderForGlobal();
                break;
            }
            case ADD: {
                this.actionHeaderForAdd();
                break;
            }
            case MODIFY: {
                this.actionHeaderForModify();
                break;
            }
            case DELETE: {
                this.actionHeaderForDelete();
                break;
            }
        }
        int currentIncomingItemsSize = currentIncomingItems.size();
        IDataStructure incomingItemDataStructure = null;
        IDataStructure itemDataStructureInDB = null;
        for (int i = 0; i < currentIncomingItemsSize; ++i) {
            incomingItemDataStructure = currentIncomingItems.elementAt(i);
            itemDataStructureInDB = dataManager.getBasedOnGID(incomingItemDataStructure);
            if (incomingItemDataStructure instanceof AttachmentItem) {
                this.handleAttachmentItems(itemDataStructureInDB, incomingItemDataStructure);
                continue;
            }
            this.handleItems(itemDataStructureInDB, incomingItemDataStructure);
        }
        this.handleDeletionOfItemsInDBWithoutIncomingItems();
        this.handleDeletionOfAttachmentItemsInDBWithoutIncomingItems();
        return this.conflictBE;
    }

    private void handleDeletionOfItemsInDBWithoutIncomingItems() throws DBException, ApplicationException {
        String[] childrenTableNames = this.currentDBHeader.getChildrenTableNames();
        if (childrenTableNames != null && childrenTableNames.length > 0) {
            for (int i = 0; i < childrenTableNames.length; ++i) {
                if (childrenTableNames[i].contains("_ATTACHMENT")) continue;
                Vector<String> incomingItemLids = this.incomingItemsCollection.get(childrenTableNames[i]);
                IDataStructure[] itemsInDBWithoutIncomingItems = null;
                String whereClauseForExcludingIncomingItems = null;
                if (incomingItemLids != null && incomingItemLids.size() > 0) {
                    whereClauseForExcludingIncomingItems = "LID NOT IN (";
                    int incomingItemLidsSize = incomingItemLids.size();
                    String lid = null;
                    for (int j = 0; j < incomingItemLidsSize; ++j) {
                        lid = incomingItemLids.elementAt(j);
                        whereClauseForExcludingIncomingItems = whereClauseForExcludingIncomingItems + "'" + lid + "'";
                        if (j >= incomingItemLidsSize - 1) continue;
                        whereClauseForExcludingIncomingItems = whereClauseForExcludingIncomingItems + ",";
                    }
                    whereClauseForExcludingIncomingItems = whereClauseForExcludingIncomingItems + ")";
                    itemsInDBWithoutIncomingItems = this.dataManager.get(childrenTableNames[i], whereClauseForExcludingIncomingItems = whereClauseForExcludingIncomingItems + " AND " + "FID" + " = '" + this.currentDBHeader.getLid() + "'");
                    if (itemsInDBWithoutIncomingItems == null || itemsInDBWithoutIncomingItems.length <= 0) continue;
                    this.actionOnItemsInDBWithoutIncomingItems(itemsInDBWithoutIncomingItems);
                    continue;
                }
                itemsInDBWithoutIncomingItems = this.dataManager.get(childrenTableNames[i], "FID= '" + this.currentDBHeader.getLid() + "'");
                if (itemsInDBWithoutIncomingItems == null || itemsInDBWithoutIncomingItems.length <= 0) continue;
                this.actionOnItemsInDBWithoutIncomingItems(itemsInDBWithoutIncomingItems);
            }
        }
    }

    private void handleDeletionOfAttachmentItemsInDBWithoutIncomingItems() throws DBException, ApplicationException {
        String[] childrenTableNames = this.currentDBHeader.getChildrenTableNames();
        if (childrenTableNames != null && childrenTableNames.length > 0) {
            for (int i = 0; i < childrenTableNames.length; ++i) {
                if (!childrenTableNames[i].contains("_ATTACHMENT")) continue;
                Vector<String> incomingAttachmentItemLids = this.incomingAttachmentItemsCollection.get(childrenTableNames[i]);
                IDataStructure[] attachmentItemsInDBWithoutIncomingItems = null;
                String whereClauseForExcludingIncomingAttachmentItems = null;
                if (incomingAttachmentItemLids != null && incomingAttachmentItemLids.size() > 0) {
                    whereClauseForExcludingIncomingAttachmentItems = "LID NOT IN (";
                    int incomingItemLidsSize = incomingAttachmentItemLids.size();
                    String lid = null;
                    for (int j = 0; j < incomingItemLidsSize; ++j) {
                        lid = incomingAttachmentItemLids.elementAt(j);
                        whereClauseForExcludingIncomingAttachmentItems = whereClauseForExcludingIncomingAttachmentItems + "'" + lid + "'";
                        if (j >= incomingItemLidsSize - 1) continue;
                        whereClauseForExcludingIncomingAttachmentItems = whereClauseForExcludingIncomingAttachmentItems + ",";
                    }
                    whereClauseForExcludingIncomingAttachmentItems = whereClauseForExcludingIncomingAttachmentItems + ")";
                    attachmentItemsInDBWithoutIncomingItems = this.dataManager.get(childrenTableNames[i], whereClauseForExcludingIncomingAttachmentItems = whereClauseForExcludingIncomingAttachmentItems + " AND " + "FID" + " = '" + this.currentDBHeader.getLid() + "'");
                    if (attachmentItemsInDBWithoutIncomingItems == null || attachmentItemsInDBWithoutIncomingItems.length <= 0) continue;
                    this.actionOnAttachmentItemsInDBWithoutIncomingItems(attachmentItemsInDBWithoutIncomingItems);
                    continue;
                }
                attachmentItemsInDBWithoutIncomingItems = this.dataManager.get(childrenTableNames[i], "FID= '" + this.currentDBHeader.getLid() + "'");
                if (attachmentItemsInDBWithoutIncomingItems == null || attachmentItemsInDBWithoutIncomingItems.length <= 0) continue;
                this.actionOnAttachmentItemsInDBWithoutIncomingItems(attachmentItemsInDBWithoutIncomingItems);
            }
        }
    }

    private void handleItems(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) throws DBException, ApplicationException {
        if (itemDataStructureInDB == null) {
            incomingItemDataStructure.setFid(this.currentIncomingHeader.getLid());
            incomingItemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
            incomingItemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
            try {
                this.dataManager.insert(incomingItemDataStructure);
            }
            catch (DBException e) {
                throw (DBException)this.getException(e.getMessage(), "handleItems", incomingItemDataStructure, true);
            }
        } else {
            switch (itemDataStructureInDB.getObjectStatus()) {
                case GLOBAL: {
                    this.actionOnIncomingItemForGlobal(itemDataStructureInDB, incomingItemDataStructure);
                    break;
                }
                case ADD: {
                    this.actionOnIncomingItemForAdd(itemDataStructureInDB, incomingItemDataStructure);
                    break;
                }
                case MODIFY: {
                    this.actionOnIncomingItemForModify(itemDataStructureInDB, incomingItemDataStructure);
                    break;
                }
                case DELETE: {
                    this.actionOnIncomingItemForDelete(itemDataStructureInDB, incomingItemDataStructure);
                    break;
                }
            }
        }
        this.addItemToCollection(incomingItemDataStructure);
    }

    private void handleAttachmentItems(IDataStructure attachmentItemDataStructureInDB, IDataStructure incomingAttachmentItemDataStructure) throws DBException, ApplicationException {
        if (attachmentItemDataStructureInDB == null) {
            incomingAttachmentItemDataStructure.setFid(this.currentDBHeader.getLid());
            incomingAttachmentItemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
            incomingAttachmentItemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
            try {
                AttachmentItem attachmentItem = (AttachmentItem)incomingAttachmentItemDataStructure;
                attachmentItem.setFileName(Attachment.setFileNameWithUid(attachmentItem));
                this.dataManager.insert(attachmentItem);
            }
            catch (DBException e) {
                throw (DBException)this.getException(e.getMessage(), "handleAttachmentItems", incomingAttachmentItemDataStructure, true);
            }
        } else {
            switch (attachmentItemDataStructureInDB.getObjectStatus()) {
                case GLOBAL: {
                    this.actionOnIncomingAttachmentItemForGlobal(attachmentItemDataStructureInDB, incomingAttachmentItemDataStructure);
                    break;
                }
                case ADD: {
                    this.actionOnIncomingAttachmentItemForAdd(attachmentItemDataStructureInDB, incomingAttachmentItemDataStructure);
                    break;
                }
                case MODIFY: {
                    this.actionOnIncomingAttachmentItemForModify(attachmentItemDataStructureInDB, incomingAttachmentItemDataStructure);
                    break;
                }
                case DELETE: {
                    this.actionOnIncomingAttachmentItemForDelete(attachmentItemDataStructureInDB, incomingAttachmentItemDataStructure);
                    break;
                }
            }
        }
        this.addAttachmentItemToCollection(incomingAttachmentItemDataStructure);
        Attachment.checkAttachmentAndQueueAutoDownload(incomingAttachmentItemDataStructure);
    }

    private void actionOnIncomingAttachmentItemForGlobal(IDataStructure attachmentItemDataStructureInDB, IDataStructure incomingAttachmentItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingAttachmentItemForGlobal", attachmentItemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: {
                this.setAttachmentItemFieldsAndStatuses(attachmentItemDataStructureInDB, incomingAttachmentItemDataStructure);
                try {
                    this.dataManager.update(incomingAttachmentItemDataStructure);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnIncomingAttachmentItemForGlobal", incomingAttachmentItemDataStructure, true);
                }
            }
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Invalid case. Items in this status should have OBJECT_STATUS as ADD, MODIFY or DELETE.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnIncomingAttachmentItemForGlobal", attachmentItemDataStructureInDB, false);
            }
        }
    }

    private void setAttachmentItemFieldsAndStatuses(IDataStructure attachmentItemDataStructureInDB, IDataStructure incomingAttachmentItemDataStructure) {
        incomingAttachmentItemDataStructure.setLid(attachmentItemDataStructureInDB.getLid());
        incomingAttachmentItemDataStructure.setFid(this.currentIncomingHeader.getLid());
        incomingAttachmentItemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
        incomingAttachmentItemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
        AttachmentItem attachmentItem = (AttachmentItem)incomingAttachmentItemDataStructure;
        attachmentItem.setFileName(Attachment.setFileNameWithUid((AttachmentItem)attachmentItemDataStructureInDB));
        attachmentItem.setLocalPath(((AttachmentItem)attachmentItemDataStructureInDB).getLocalPath());
        attachmentItem.setAttachmentStatus(((AttachmentItem)attachmentItemDataStructureInDB).getAttachmentStatus());
    }

    private void actionOnIncomingAttachmentItemForAdd(IDataStructure attachmentItemDataStructureInDB, IDataStructure incomingAttachmentItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingAttachmentItemForAdd", attachmentItemDataStructureInDB, false);
        }
        if (this.syncMode) {
            this.setAttachmentItemFieldsAndStatuses(attachmentItemDataStructureInDB, incomingAttachmentItemDataStructure);
            try {
                this.dataManager.insertOrUpdateBasedOnGID(incomingAttachmentItemDataStructure);
            }
            catch (DBException e) {
                throw (DBException)this.getException(e.getMessage(), "actionOnIncomingAttachmentItemForAdd", incomingAttachmentItemDataStructure, true);
            }
            return;
        }
        switch (syncStatus) {
            case NONE: {
                if (Logger.getDefaultLogLevel() != 9) break;
                String errorMsg = "Do not touch. Item has been modified after synchronization before getting a response";
                String message = this.getLoggerMessage(errorMsg, attachmentItemDataStructureInDB);
                Logger.log(9, this.getClass().getName(), "actionOnIncomingAttachmentItemForAdd", message);
                break;
            }
            case SENT: {
                this.setAttachmentItemFieldsAndStatuses(attachmentItemDataStructureInDB, incomingAttachmentItemDataStructure);
                try {
                    this.dataManager.insertOrUpdateBasedOnGID(incomingAttachmentItemDataStructure);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnIncomingAttachmentItemForAdd", incomingAttachmentItemDataStructure, true);
                }
            }
            case QUEUED: 
            case ERROR: {
                String errorMsg = "Invalid case. Items in Object Status MODIFY can only be in Sync Status SENT.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnIncomingAttachmentItemForAdd", attachmentItemDataStructureInDB, false);
            }
        }
    }

    private void actionOnIncomingAttachmentItemForModify(IDataStructure attachmentItemDataStructureInDB, IDataStructure incomingAttachmentItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingAttachmentItemForModify", attachmentItemDataStructureInDB, false);
        }
        if (this.syncMode) {
            this.setAttachmentItemFieldsAndStatuses(attachmentItemDataStructureInDB, incomingAttachmentItemDataStructure);
            try {
                this.dataManager.update(incomingAttachmentItemDataStructure);
            }
            catch (DBException e) {
                throw (DBException)this.getException(e.getMessage(), "actionOnIncomingAttachmentItemForModify", incomingAttachmentItemDataStructure, true);
            }
            return;
        }
        switch (syncStatus) {
            case NONE: {
                if (Logger.getDefaultLogLevel() != 9) break;
                String errorMsg = "Do not touch. Added after the request has been sent to the server. Cannot relate to add objects.";
                String message = this.getLoggerMessage(errorMsg, attachmentItemDataStructureInDB);
                Logger.log(9, this.getClass().getName(), "actionOnIncomingAttachmentItemForModify", message);
                break;
            }
            case SENT: {
                this.setAttachmentItemFieldsAndStatuses(attachmentItemDataStructureInDB, incomingAttachmentItemDataStructure);
                try {
                    this.dataManager.update(incomingAttachmentItemDataStructure);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnIncomingAttachmentItemForModify", incomingAttachmentItemDataStructure, true);
                }
            }
            case QUEUED: 
            case ERROR: {
                String errorMsg = "Invalid case. Items in Object Status MODIFY can only be in Sync Status SENT.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnIncomingAttachmentItemForModify", attachmentItemDataStructureInDB, false);
            }
        }
    }

    private void actionOnIncomingAttachmentItemForDelete(IDataStructure attachmentItemDataStructureInDB, IDataStructure incomingAttachmentItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingAttachmentItemForDelete", attachmentItemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: {
                if (Logger.getDefaultLogLevel() != 9) break;
                String errorMsg = "Do not touch. Added after the request has been sent to the server. Cannot relate to add objects.";
                String message = this.getLoggerMessage(errorMsg, attachmentItemDataStructureInDB);
                Logger.log(9, this.getClass().getName(), "actionOnIncomingAttachmentItemForDelete", message);
                break;
            }
            case SENT: {
                this.setAttachmentItemFieldsAndStatuses(attachmentItemDataStructureInDB, incomingAttachmentItemDataStructure);
                try {
                    this.dataManager.update(incomingAttachmentItemDataStructure);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnIncomingAttachmentItemForDelete", incomingAttachmentItemDataStructure, true);
                }
            }
            case QUEUED: 
            case ERROR: {
                String errorMsg = "Invalid case. Items in Object Status MODIFY can only be in Sync Status SENT.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnIncomingAttachmentItemForDelete", attachmentItemDataStructureInDB, false);
            }
        }
    }

    private void addItemToCollection(IDataStructure itemDataStructure) {
        if (itemDataStructure == null) {
            return;
        }
        String itemName = itemDataStructure.getTableName();
        Vector<String> items = this.incomingItemsCollection.get(itemName);
        if (items == null) {
            items = new Vector();
            this.incomingItemsCollection.put(itemName, items);
        }
        items.addElement(itemDataStructure.getLid());
    }

    private void addAttachmentItemToCollection(IDataStructure itemDataStructure) {
        if (itemDataStructure == null) {
            return;
        }
        String attachmentItemName = itemDataStructure.getTableName();
        Vector<String> attachmentItems = this.incomingAttachmentItemsCollection.get(attachmentItemName);
        if (attachmentItems == null) {
            attachmentItems = new Vector();
            this.incomingAttachmentItemsCollection.put(attachmentItemName, attachmentItems);
        }
        attachmentItems.addElement(itemDataStructure.getLid());
    }

    private void actionOnItemsInDBWithoutIncomingItems(IDataStructure[] itemsInDBWithoutIncomingItems) throws DBException, ApplicationException {
        IDataStructure itemInDB = null;
        block6: for (int i = 0; i < itemsInDBWithoutIncomingItems.length; ++i) {
            itemInDB = itemsInDBWithoutIncomingItems[i];
            switch (itemInDB.getObjectStatus()) {
                case GLOBAL: {
                    this.actionOnDBItemWithoutIncomingItemForGlobal(itemInDB);
                    continue block6;
                }
                case ADD: {
                    this.actionOnDBItemWithoutIncomingItemForAdd(itemInDB);
                    continue block6;
                }
                case MODIFY: {
                    this.actionOnDBItemWithoutIncomingItemForModify(itemInDB);
                    continue block6;
                }
                case DELETE: {
                    this.actionOnDBItemWithoutIncomingItemForDelete(itemInDB);
                    continue block6;
                }
            }
        }
    }

    private void actionOnAttachmentItemsInDBWithoutIncomingItems(IDataStructure[] attachmentItemsInDBWithoutIncomingItems) throws DBException, ApplicationException {
        IDataStructure attachmentItemInDB = null;
        block6: for (int i = 0; i < attachmentItemsInDBWithoutIncomingItems.length; ++i) {
            attachmentItemInDB = attachmentItemsInDBWithoutIncomingItems[i];
            if (!(attachmentItemInDB instanceof AttachmentItem)) continue;
            switch (attachmentItemInDB.getObjectStatus()) {
                case GLOBAL: {
                    this.actionOnDBAttachmentItemWithoutIncomingItemForGlobal(attachmentItemInDB);
                    continue block6;
                }
                case ADD: {
                    this.actionOnDBAttachmentItemWithoutIncomingItemForAdd(attachmentItemInDB);
                    continue block6;
                }
                case MODIFY: {
                    this.actionOnDBAttachmentItemWithoutIncomingItemForModify(attachmentItemInDB);
                    continue block6;
                }
                case DELETE: {
                    this.actionOnDBAttachmentItemWithoutIncomingItemForDelete(attachmentItemInDB);
                    continue block6;
                }
            }
        }
    }

    private void actionOnDBAttachmentItemWithoutIncomingItemForGlobal(IDataStructure attachmentItemInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBAttachmentItemWithoutIncomingItemForGlobal", attachmentItemInDB, false);
        }
        switch (syncStatus) {
            case NONE: {
                try {
                    this.dataManager.delete(attachmentItemInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBAttachmentItemWithoutIncomingItemForGlobal", attachmentItemInDB, true);
                }
            }
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Invalid case. Items in this status should have OBJECT_STATUS as ADD, MODIFY or DELETE.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnDBAttachmentItemWithoutIncomingItemForGlobal", attachmentItemInDB, false);
            }
        }
    }

    private void actionOnDBAttachmentItemWithoutIncomingItemForAdd(IDataStructure attachmentItemInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBAttachmentItemWithoutIncomingItemForAdd", attachmentItemInDB, false);
        }
        switch (syncStatus) {
            case NONE: {
                if (Logger.getDefaultLogLevel() != 9) break;
                String errorMsg = "Do not touch. Added after the request has been sent to the server. Cannot relate to add objects.";
                String message = this.getLoggerMessage(errorMsg, attachmentItemInDB);
                Logger.log(9, this.getClass().getName(), "actionOnDBAttachmentItemWithoutIncomingItemForAdd", message);
                break;
            }
            case SENT: {
                try {
                    this.dataManager.delete(attachmentItemInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBAttachmentItemWithoutIncomingItemForAdd", attachmentItemInDB, true);
                }
            }
            case QUEUED: 
            case ERROR: {
                String errorMsg = "Invalid case. Items in Object Status MODIFY can only be in Sync Status SENT.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnDBAttachmentItemWithoutIncomingItemForAdd", attachmentItemInDB, false);
            }
        }
    }

    private void actionOnDBAttachmentItemWithoutIncomingItemForModify(IDataStructure attachmentItemInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBAttachmentItemWithoutIncomingItemForModify", attachmentItemInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                try {
                    this.dataManager.delete(attachmentItemInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBAttachmentItemWithoutIncomingItemForModify", attachmentItemInDB, true);
                }
            }
        }
    }

    private void actionOnDBAttachmentItemWithoutIncomingItemForDelete(IDataStructure attachmentItemInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = attachmentItemInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBAttachmentItemWithoutIncomingItemForDelete", attachmentItemInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                try {
                    this.dataManager.delete(attachmentItemInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBAttachmentItemWithoutIncomingItemForDelete", attachmentItemInDB, true);
                }
            }
        }
    }

    private void actionOnDBItemWithoutIncomingItemForGlobal(IDataStructure itemDataStructureInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBItemWithoutIncomingItemForGlobal", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case SENT: 
            case ERROR: {
                try {
                    this.dataManager.delete(itemDataStructureInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBItemWithoutIncomingItemForGlobal", itemDataStructureInDB, true);
                }
            }
        }
    }

    private void actionOnDBItemWithoutIncomingItemForAdd(IDataStructure itemDataStructureInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBItemWithoutIncomingItemForAdd", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case QUEUED: {
                String errorMsg = "Invalid case. Cannot queue the same object again if the BE is waiting for a response";
                throw (ApplicationException)this.getException(errorMsg, "actionOnDBItemWithoutIncomingItemForAdd", itemDataStructureInDB, false);
            }
            case NONE: 
            case SENT: 
            case ERROR: {
                try {
                    this.dataManager.delete(itemDataStructureInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBItemWithoutIncomingItemForAdd", itemDataStructureInDB, true);
                }
            }
        }
    }

    private void actionOnDBItemWithoutIncomingItemForModify(IDataStructure itemDataStructureInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBItemWithoutIncomingItemForModify", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case SENT: 
            case ERROR: {
                try {
                    this.dataManager.delete(itemDataStructureInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBItemWithoutIncomingItemForModify", itemDataStructureInDB, true);
                }
            }
            case QUEUED: {
                String errorMsg = "Invalid case. Cannot queue the same object again if the BE is waiting for a response";
                throw (ApplicationException)this.getException(errorMsg, "actionOnDBItemWithoutIncomingItemForModify", itemDataStructureInDB, false);
            }
        }
    }

    private void actionOnDBItemWithoutIncomingItemForDelete(IDataStructure itemDataStructureInDB) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnDBItemWithoutIncomingItemForDelete", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case SENT: 
            case ERROR: {
                try {
                    this.dataManager.delete(itemDataStructureInDB);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnDBItemWithoutIncomingItemForDelete", itemDataStructureInDB, true);
                }
            }
            case QUEUED: {
                String errorMsg = "Invalid case. Cannot queue the same object again if the BE is waiting for a response";
                throw (ApplicationException)this.getException(errorMsg, "actionOnDBItemWithoutIncomingItemForDelete", itemDataStructureInDB, false);
            }
        }
    }

    private void actionHeaderForGlobal() throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = this.currentDBHeader.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionHeaderForGlobal", this.currentDBHeader, false);
        }
        if (this.syncMode) {
            this.setHeaderFieldsAndStatuses();
            try {
                this.dataManager.update(this.currentIncomingHeader);
            }
            catch (DBException e) {
                throw (DBException)this.getException(e.getMessage(), "actionHeaderForModify", this.currentIncomingHeader, true);
            }
            return;
        }
        switch (syncStatus) {
            case NONE: {
                this.setHeaderFieldsAndStatuses();
                try {
                    this.dataManager.update(this.currentIncomingHeader);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionHeaderForGlobal", this.currentIncomingHeader, true);
                }
            }
            case QUEUED: 
            case SENT: 
            case ERROR: {
                String errorMsg = "Invalid case. Header in Object Status GLOBAL can only be in Sync Status NONE.";
                throw (ApplicationException)this.getException(errorMsg, "actionHeaderForGlobal", this.currentDBHeader, false);
            }
        }
    }

    private void setHeaderFieldsAndStatuses() {
        Logger.i("Request response reconciler. Updating the current incoming header's Lid, Object and Sync status: " + this.currentDBHeader.getLid() + " --- " + this.currentIncomingHeader.getLid() + " -- Sync Status: " + (Object)((Object)this.currentIncomingHeader.getSyncStatus()) + " -- Object Status: " + (Object)((Object)this.currentIncomingHeader.getObjectStatus()));
        this.currentIncomingHeader.setLid(this.currentDBHeader.getLid());
        this.currentIncomingHeader.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
        this.currentIncomingHeader.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
    }

    private void actionHeaderForAdd() throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = this.currentDBHeader.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionHeaderForAdd", this.currentDBHeader, false);
        }
        if (this.syncMode) {
            this.setHeaderFieldsAndStatuses();
            try {
                this.dataManager.insertOrUpdateBasedOnGID(this.currentIncomingHeader);
            }
            catch (DBException e) {
                throw (DBException)this.getException(e.getMessage(), "actionHeaderForAdd", this.currentIncomingHeader, true);
            }
            return;
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case ERROR: {
                String errorMsg = "Invalid case. Header in Object Status ADD can only be in Sync Status SENT.";
                throw (ApplicationException)this.getException(errorMsg, "actionHeaderForAdd", this.currentDBHeader, false);
            }
            case SENT: {
                this.setHeaderFieldsAndStatuses();
                try {
                    this.dataManager.insertOrUpdateBasedOnGID(this.currentIncomingHeader);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionHeaderForAdd", this.currentIncomingHeader, true);
                }
            }
        }
    }

    private void actionHeaderForModify() throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = this.currentDBHeader.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionHeaderForModify", this.currentDBHeader, false);
        }
        if (this.syncMode) {
            this.setHeaderFieldsAndStatuses();
            try {
                this.dataManager.update(this.currentIncomingHeader);
            }
            catch (DBException e) {
                throw (DBException)this.getException(e.getMessage(), "actionHeaderForModify", this.currentIncomingHeader, true);
            }
            return;
        }
        switch (syncStatus) {
            case NONE: {
                this.handleHeaderConflict();
                break;
            }
            case SENT: {
                this.setHeaderFieldsAndStatuses();
                try {
                    Logger.i("actionHeaderForModify: Request response reconciler. Updated current incoming header's Lid, Object and Sync status: " + this.currentDBHeader.getLid() + " --- " + this.currentIncomingHeader.getLid() + " -- Sync Status: " + (Object)((Object)this.currentIncomingHeader.getSyncStatus()) + " -- Object Status: " + (Object)((Object)this.currentIncomingHeader.getObjectStatus()));
                    this.dataManager.update(this.currentIncomingHeader);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionHeaderForModify", this.currentIncomingHeader, true);
                }
            }
            case QUEUED: 
            case ERROR: {
                String errorMsg = "Invalid case. Header in Object Status MODIFY can only be in Sync Status SENT.";
                throw (ApplicationException)this.getException(errorMsg, "actionHeaderForModify", this.currentDBHeader, false);
            }
        }
    }

    private void handleHeaderConflict() throws DBException {
        if (Strings.isNullOrEmpty((String)this.conflictRule)) {
            return;
        }
        switch (this.conflictRule) {
            case "SERVER_WINS": {
                this.setHeaderFieldsAndStatuses();
                try {
                    this.dataManager.update(this.currentIncomingHeader);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "handleHeaderConflict", this.currentIncomingHeader, true);
                }
            }
            case "APP_HANDLED": {
                if (this.conflictBE == null) {
                    this.conflictBE = new ConflictBE(this.currentDBHeader, this.currentIncomingHeader);
                }
                this.conflictBE.setHeaderInConflict();
                break;
            }
        }
    }

    private void handleItemConflict(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) throws DBException {
        if (Strings.isNullOrEmpty((String)this.conflictRule)) {
            return;
        }
        switch (this.conflictRule) {
            case "SERVER_WINS": {
                this.setItemFieldsAndStatuses(itemDataStructureInDB, incomingItemDataStructure);
                try {
                    this.dataManager.update(incomingItemDataStructure);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "handleItemConflict", this.currentIncomingHeader, true);
                }
            }
            case "APP_HANDLED": {
                if (this.conflictBE == null) {
                    this.conflictBE = new ConflictBE(this.currentDBHeader, this.currentIncomingHeader);
                }
                this.conflictBE.setItemInConflict(itemDataStructureInDB, incomingItemDataStructure);
                break;
            }
        }
    }

    private void actionHeaderForDelete() throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = this.currentDBHeader.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionHeaderForDelete", this.currentDBHeader, false);
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case ERROR: {
                String errorMsg = "Invalid case. Header in Object Status DELETE can only be in Sync Status SENT.";
                throw (ApplicationException)this.getException(errorMsg, "actionHeaderForDelete", this.currentDBHeader, false);
            }
            case SENT: {
                this.setHeaderFieldsAndStatuses();
                try {
                    this.dataManager.update(this.currentIncomingHeader);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionHeaderForDelete", this.currentIncomingHeader, true);
                }
            }
        }
    }

    private void actionOnIncomingItemForGlobal(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingItemForGlobal", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: 
            case ERROR: {
                this.setItemFieldsAndStatuses(itemDataStructureInDB, incomingItemDataStructure);
                try {
                    this.dataManager.update(incomingItemDataStructure);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnIncomingItemForGlobal", incomingItemDataStructure, true);
                }
            }
            case QUEUED: 
            case SENT: {
                String errorMsg = "Invalid case. Items in Object Status GLOBAL can only be in Sync Status NONE or ERROR.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnIncomingItemForGlobal", itemDataStructureInDB, false);
            }
        }
    }

    private void setItemFieldsAndStatuses(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) {
        incomingItemDataStructure.setLid(itemDataStructureInDB.getLid());
        incomingItemDataStructure.setFid(this.currentIncomingHeader.getLid());
        incomingItemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
        incomingItemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
    }

    private void actionOnIncomingItemForAdd(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingItemForAdd", itemDataStructureInDB, false);
        }
        if (this.syncMode) {
            this.setItemFieldsAndStatuses(itemDataStructureInDB, incomingItemDataStructure);
            try {
                this.dataManager.insertOrUpdateBasedOnGID(incomingItemDataStructure);
            }
            catch (DBException e) {
                throw (DBException)this.getException(e.getMessage(), "actionOnIncomingItemForAdd", incomingItemDataStructure, true);
            }
            return;
        }
        switch (syncStatus) {
            case NONE: 
            case QUEUED: 
            case ERROR: {
                try {
                    this.dataManager.delete(itemDataStructureInDB);
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnIncomingItemForAdd", incomingItemDataStructure, true);
                }
                String errorMsg = "Delete Item. Not possible to relate an ADD status to incoming item";
                throw (ApplicationException)this.getException(errorMsg, "actionOnIncomingItemForAdd", itemDataStructureInDB, false);
            }
            case SENT: {
                this.setItemFieldsAndStatuses(itemDataStructureInDB, incomingItemDataStructure);
                try {
                    this.dataManager.insertOrUpdateBasedOnGID(incomingItemDataStructure);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnIncomingItemForAdd", incomingItemDataStructure, true);
                }
            }
        }
    }

    private void actionOnIncomingItemForModify(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingItemForModify", itemDataStructureInDB, false);
        }
        if (this.syncMode) {
            this.setItemFieldsAndStatuses(itemDataStructureInDB, incomingItemDataStructure);
            try {
                this.dataManager.update(incomingItemDataStructure);
            }
            catch (DBException e) {
                throw (DBException)this.getException(e.getMessage(), "actionOnIncomingItemForModify", incomingItemDataStructure, true);
            }
            return;
        }
        switch (syncStatus) {
            case NONE: {
                this.handleItemConflict(itemDataStructureInDB, incomingItemDataStructure);
                break;
            }
            case SENT: {
                this.setItemFieldsAndStatuses(itemDataStructureInDB, incomingItemDataStructure);
                try {
                    this.dataManager.update(incomingItemDataStructure);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnIncomingItemForModify", incomingItemDataStructure, true);
                }
            }
            case QUEUED: 
            case ERROR: {
                String errorMsg = "Invalid case. Items in Object Status MODIFY can only be in Sync Status SENT.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnIncomingItemForModify", itemDataStructureInDB, false);
            }
        }
    }

    private void actionOnIncomingItemForDelete(IDataStructure itemDataStructureInDB, IDataStructure incomingItemDataStructure) throws DBException, ApplicationException {
        IDataStructure.SYNC_STATUS syncStatus = itemDataStructureInDB.getSyncStatus();
        if (syncStatus == null) {
            throw (ApplicationException)this.getException("Sync status is null.", "actionOnIncomingItemForDelete", itemDataStructureInDB, false);
        }
        switch (syncStatus) {
            case NONE: {
                if (Logger.getDefaultLogLevel() != 9) break;
                String errorMsg = "Do not touch. Item has been modified after synchronization before getting a response";
                String message = this.getLoggerMessage(errorMsg, itemDataStructureInDB);
                Logger.log(9, this.getClass().getName(), "actionOnIncomingItemForDelete", message);
                break;
            }
            case SENT: {
                this.setItemFieldsAndStatuses(itemDataStructureInDB, incomingItemDataStructure);
                try {
                    this.dataManager.update(incomingItemDataStructure);
                    break;
                }
                catch (DBException e) {
                    throw (DBException)this.getException(e.getMessage(), "actionOnIncomingItemForDelete", incomingItemDataStructure, true);
                }
            }
            case QUEUED: 
            case ERROR: {
                String errorMsg = "Invalid case. Items in Object Status DELETE can only be in Sync Status SENT.";
                throw (ApplicationException)this.getException(errorMsg, "actionOnIncomingItemForDelete", itemDataStructureInDB, false);
            }
        }
    }

    private Exception getException(String message, String methodName, IDataStructure dataStructure, boolean dbException) throws DBException {
        String beName = dataStructure.getBEName();
        String itemName = dataStructure.getTableName();
        String[] gidFieldNames = dataStructure.getGidFieldNames();
        Object[] gidFieldValues = dataStructure.getGids();
        String concatenatedGIDFieldNames = "";
        String concatenetedGIDFieldValues = "";
        for (int i = 0; i < gidFieldNames.length; ++i) {
            if (gidFieldNames.length > 1) {
                concatenatedGIDFieldNames = concatenatedGIDFieldNames + "-" + gidFieldNames[i];
                concatenetedGIDFieldValues = concatenetedGIDFieldValues + "-" + gidFieldValues[i];
                continue;
            }
            concatenatedGIDFieldNames = gidFieldNames[i];
            concatenetedGIDFieldValues = concatenetedGIDFieldValues + gidFieldValues[i];
        }
        message = message + ": " + "BE Name: " + beName + ", Item Name: " + itemName + ", GID Field Names: " + concatenatedGIDFieldNames + ", GID Field Values: " + concatenetedGIDFieldValues + ", Object Status: " + (Object)((Object)dataStructure.getObjectStatus()) + ", Sync Status: " + (Object)((Object)dataStructure.getSyncStatus());
        Exception exception = null;
        if (dbException) {
            Logger.log(8, this.getClass().getName(), methodName, message);
            exception = new DBException(this.getClass().getName(), methodName, message);
        } else {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), methodName, message);
            }
            exception = new ApplicationException(this.getClass().getName(), methodName, message);
        }
        return exception;
    }

    private String getLoggerMessage(String message, IDataStructure dataStructure) throws DBException {
        String beName = dataStructure.getBEName();
        String itemName = dataStructure.getTableName();
        String[] gidFieldNames = dataStructure.getGidFieldNames();
        Object[] gidFieldValues = dataStructure.getGids();
        String concatenatedGIDFieldNames = "";
        String concatenetedGIDFieldValues = "";
        for (int i = 0; i < gidFieldNames.length; ++i) {
            if (gidFieldNames.length > 1) {
                concatenatedGIDFieldNames = concatenatedGIDFieldNames + "-" + gidFieldNames[i];
                concatenetedGIDFieldValues = concatenetedGIDFieldValues + "-" + gidFieldValues[i];
                continue;
            }
            concatenatedGIDFieldNames = gidFieldNames[i];
            concatenetedGIDFieldValues = concatenetedGIDFieldValues + gidFieldValues[i];
        }
        message = message + ": " + "BE Name: " + beName + ", Item Name: " + itemName + ", GID Field Names: " + concatenatedGIDFieldNames + ", GID Field Values: " + concatenetedGIDFieldValues + ", Object Status: " + (Object)((Object)dataStructure.getObjectStatus()) + ", Sync Status: " + (Object)((Object)dataStructure.getSyncStatus());
        return message;
    }
}

