/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.in;

import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.login.DemoModeListener;
import com.unvired.login.LoginParameters;
import com.unvired.message.UNVDataHelper;
import com.unvired.model.AttachmentItem;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.InfoMessage;
import com.unvired.model.ReconcileObject;
import com.unvired.parser.UBJSONParser;
import com.unvired.parser.UBXMLParser;
import com.unvired.sync.SyncConstants;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.attachment.Attachment;
import com.unvired.sync.in.ConflictBE;
import com.unvired.sync.in.ConflictHandler;
import com.unvired.sync.in.PullPushQueryBEReconciler;
import com.unvired.sync.in.RequestResponseBEReconciler;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.sync.out.ISyncAppCallback;
import com.unvired.sync.out.ISyncFrameworkCallback;
import com.unvired.sync.response.AttachmentResponse;
import com.unvired.sync.response.HTTPResponse;
import com.unvired.sync.response.ISyncResponse;
import com.unvired.sync.response.SyncBEResponse;
import com.unvired.sync.response.SyncRawResponse;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.Utils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SyncDataHandler {
    private static final Vector<ConflictBE> conflictBEs = new Vector();
    private static String conflictRule;

    public static void sendDataInSyncMode(IDataStructure headerDataStructure, String processAgentFunctionName, boolean autoSave, ISyncAppCallback appCallback) throws ApplicationException, DBException {
        AttachmentResponse attachmentResponse;
        if (headerDataStructure == null) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "DataStructure cannot be null");
        }
        IDataStructure.SYNC_STATUS headerDataStructureStatus = headerDataStructure.getSyncStatus();
        if (IDataStructure.SYNC_STATUS.QUEUED == headerDataStructureStatus) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "DataStructure is in outbox. Cannot be submitted again.");
        }
        if (IDataStructure.SYNC_STATUS.SENT == headerDataStructureStatus) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "DataStructure is in sent items waiting for a response from the server. Cannot be submitted again.");
        }
        if (Strings.isNullOrEmpty((String)processAgentFunctionName)) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "Process agent function name is mandatory");
        }
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        if (applicationManager.isAttachmentSupported(headerDataStructure.getBEName()) && (attachmentResponse = SyncDataHandler.checkAndUploadAttachments(headerDataStructure)) != null && Strings.isNullOrEmpty((String)attachmentResponse.getGUID())) {
            if (appCallback != null) {
                appCallback.onResponse(new SyncBEResponse(0, "No GUID return for this Attachment in response."));
            }
            return;
        }
        String dataFormat = FrameworkSettingsManager.getInstance().getDataFormat();
        String dataString = "";
        dataString = "XML".equalsIgnoreCase(dataFormat) ? UNVDataHelper.generateMessageIBXML(headerDataStructure, UNVDataHelper.DATA_TYPE.CHANGED) : UNVDataHelper.generateMessageIBJSON(headerDataStructure, UNVDataHelper.DATA_TYPE.CHANGED);
        if (dataString == null || dataString.isEmpty()) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "Data cannot be retrieved for the datastructure: " + headerDataStructure.getBEName() + " LID: " + headerDataStructure.getLid());
        }
        String applicationName = ApplicationManager.getInstance().getApplicationName();
        RequestResponseSyncCallback requestResponseSyncCallback = new RequestResponseSyncCallback(headerDataStructure, appCallback, autoSave);
        if (SyncEngine.getInstance().getIsInDemoMode()) {
            DemoModeListener demoModeListener = LoginParameters.getDemoModeListener();
            if (demoModeListener == null) {
                return;
            }
            demoModeListener.handleSyncRequest(processAgentFunctionName, SyncConstants.MESSAGE_REQUEST_TYPE.RQST, dataString, requestResponseSyncCallback);
            return;
        }
        if (appCallback != null) {
            HTTPConnection.updateAppFrameworkCallbackMap(appCallback, requestResponseSyncCallback);
        }
        HTTPConnection.postDirect(processAgentFunctionName, String.valueOf(8000), String.valueOf(600), SyncConstants.MESSAGE_REQUEST_TYPE.RQST, dataString, applicationName, null, null, requestResponseSyncCallback);
    }

    public static void sendDataInSyncMode(String customData, String processAgentFunctionName, boolean autoSave, ISyncAppCallback appCallback) throws ApplicationException, DBException {
        if (customData == null) {
            customData = "";
        }
        if (Strings.isNullOrEmpty((String)processAgentFunctionName)) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "Process agent function name is mandatory");
        }
        String applicationName = ApplicationManager.getInstance().getApplicationName();
        RequestResponseSyncCallback requestResponseSyncCallback = new RequestResponseSyncCallback(null, appCallback, autoSave);
        if (SyncEngine.getInstance().getIsInDemoMode()) {
            DemoModeListener demoModeListener = LoginParameters.getDemoModeListener();
            if (demoModeListener == null) {
                return;
            }
            demoModeListener.handleSyncRequest(processAgentFunctionName, SyncConstants.MESSAGE_REQUEST_TYPE.RQST, customData, requestResponseSyncCallback);
            return;
        }
        if (appCallback != null) {
            HTTPConnection.updateAppFrameworkCallbackMap(appCallback, requestResponseSyncCallback);
        }
        HTTPConnection.postDirect(processAgentFunctionName, String.valueOf(8000), String.valueOf(600), SyncConstants.MESSAGE_REQUEST_TYPE.RQST, customData, applicationName, null, null, requestResponseSyncCallback);
    }

    @Deprecated
    public static void sendDataQueryInSyncMode(IDataStructure headerDataStructure, String processAgentFunctionName, final boolean autoSave, final ISyncAppCallback callback) throws ApplicationException, DBException {
        if (headerDataStructure == null) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "DataStructure cannot be null");
        }
        IDataStructure.SYNC_STATUS headerDataStructureStatus = headerDataStructure.getSyncStatus();
        if (IDataStructure.SYNC_STATUS.QUEUED == headerDataStructureStatus) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "DataStructure is in outbox. Cannot be submitted again.");
        }
        if (IDataStructure.SYNC_STATUS.SENT == headerDataStructureStatus) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "DataStructure is in sent items waiting for a response from the server. Cannot be submitted again.");
        }
        if (Strings.isNullOrEmpty((String)processAgentFunctionName)) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "Process agent function name is mandatory");
        }
        String dataFormat = FrameworkSettingsManager.getInstance().getDataFormat();
        String dataString = "";
        dataString = "XML".equalsIgnoreCase(dataFormat) ? UNVDataHelper.generateMessageIBXML(headerDataStructure, UNVDataHelper.DATA_TYPE.ALL) : UNVDataHelper.generateMessageIBJSON(headerDataStructure, UNVDataHelper.DATA_TYPE.ALL);
        String applicationName = ApplicationManager.getInstance().getApplicationName();
        HTTPConnection.postDirect(processAgentFunctionName, String.valueOf(8000), String.valueOf(600), SyncConstants.MESSAGE_REQUEST_TYPE.QUERY, dataString, applicationName, null, null, new ISyncFrameworkCallback(){

            @Override
            public void onResponse(ISyncResponse iSyncResponse) {
                ISyncResponse syncResponse = null;
                try {
                    syncResponse = SyncDataHandler.processDataQueryInSyncMode((HTTPResponse)iSyncResponse, autoSave);
                }
                catch (ApplicationException e) {
                    Logger.log(8, SyncDataHandler.class.getName(), "sendDataQueryInSyncMode", "ApplicationException caught while processing data in sync mode: " + e.getMessage());
                }
                catch (DBException e) {
                    Logger.log(8, SyncDataHandler.class.getName(), "sendDataQueryInSyncMode", "DBException caught while while processing data in sync mode: " + e.getMessage());
                }
                if (callback != null) {
                    callback.onResponse(syncResponse);
                }
            }
        });
    }

    @Deprecated
    public static void sendDataQueryInSyncMode(String customData, String processAgentFunctionName, final boolean autoSave, final ISyncAppCallback callback) throws ApplicationException, DBException {
        if (customData == null) {
            customData = "";
        }
        if (Strings.isNullOrEmpty((String)processAgentFunctionName)) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "Process agent function name is mandatory");
        }
        String applicationName = ApplicationManager.getInstance().getApplicationName();
        String messageSubType = String.valueOf(700);
        if (Strings.isNullOrEmpty((String)customData)) {
            messageSubType = String.valueOf(600);
        }
        HTTPConnection.postDirect(processAgentFunctionName, String.valueOf(8000), messageSubType, SyncConstants.MESSAGE_REQUEST_TYPE.QUERY, customData, applicationName, null, null, new ISyncFrameworkCallback(){

            @Override
            public void onResponse(ISyncResponse iSyncResponse) {
                ISyncResponse syncResponse = null;
                try {
                    syncResponse = SyncDataHandler.processDataQueryInSyncMode((HTTPResponse)iSyncResponse, autoSave);
                }
                catch (ApplicationException e) {
                    Logger.log(8, SyncDataHandler.class.getName(), "sendDataQueryInSyncMode", "ApplicationException caught while processing data in sync mode: " + e.getMessage());
                }
                catch (DBException e) {
                    Logger.log(8, SyncDataHandler.class.getName(), "sendDataQueryInSyncMode", "DBException caught while while processing data in sync mode: " + e.getMessage());
                }
                if (callback != null) {
                    callback.onResponse(syncResponse);
                }
            }
        });
    }

    public static void sendDataPullQueryInSyncMode(SyncConstants.MESSAGE_REQUEST_TYPE requestType, IDataStructure headerDataStructure, String processAgentFunctionName, boolean autoSave, ISyncAppCallback appCallback) throws ApplicationException, DBException {
        if (headerDataStructure == null) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "DataStructure cannot be null");
        }
        IDataStructure.SYNC_STATUS headerDataStructureStatus = headerDataStructure.getSyncStatus();
        if (IDataStructure.SYNC_STATUS.QUEUED == headerDataStructureStatus) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "DataStructure is in outbox. Cannot be submitted again.");
        }
        if (IDataStructure.SYNC_STATUS.SENT == headerDataStructureStatus) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "DataStructure is in sent items waiting for a response from the server. Cannot be submitted again.");
        }
        if (Strings.isNullOrEmpty((String)processAgentFunctionName)) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "Process agent function name is mandatory");
        }
        String dataFormat = FrameworkSettingsManager.getInstance().getDataFormat();
        String dataString = "";
        dataString = "XML".equalsIgnoreCase(dataFormat) ? UNVDataHelper.generateMessageIBXML(headerDataStructure, UNVDataHelper.DATA_TYPE.ALL) : UNVDataHelper.generateMessageIBJSON(headerDataStructure, UNVDataHelper.DATA_TYPE.ALL);
        if (dataString == null || dataString.isEmpty()) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataPullQueryInSyncMode", "Data cannot be retrieved for the DataStructure: " + headerDataStructure.getBEName() + " LID: " + headerDataStructure.getLid());
        }
        String applicationName = ApplicationManager.getInstance().getApplicationName();
        PullQuerySyncCallback pullQuerySyncCallback = new PullQuerySyncCallback(appCallback, autoSave);
        if (SyncEngine.getInstance().getIsInDemoMode()) {
            DemoModeListener demoModeListener = LoginParameters.getDemoModeListener();
            if (demoModeListener == null) {
                return;
            }
            demoModeListener.handleSyncRequest(processAgentFunctionName, requestType, dataString, pullQuerySyncCallback);
            return;
        }
        if (appCallback != null) {
            HTTPConnection.updateAppFrameworkCallbackMap(appCallback, pullQuerySyncCallback);
        }
        HTTPConnection.postDirect(processAgentFunctionName, String.valueOf(8000), String.valueOf(600), requestType, dataString, applicationName, null, null, pullQuerySyncCallback);
    }

    public static void sendDataPullQueryInSyncMode(SyncConstants.MESSAGE_REQUEST_TYPE requestType, String customData, String processAgentFunctionName, boolean autoSave, ISyncAppCallback appCallback) throws ApplicationException, DBException {
        if (customData == null) {
            customData = "";
        }
        if (Strings.isNullOrEmpty((String)processAgentFunctionName)) {
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "Process agent function name is mandatory");
        }
        String applicationName = ApplicationManager.getInstance().getApplicationName();
        PullQuerySyncCallback pullQuerySyncCallback = new PullQuerySyncCallback(appCallback, autoSave);
        if (SyncEngine.getInstance().getIsInDemoMode()) {
            DemoModeListener demoModeListener = LoginParameters.getDemoModeListener();
            if (demoModeListener == null) {
                return;
            }
            demoModeListener.handleSyncRequest(processAgentFunctionName, requestType, customData, pullQuerySyncCallback);
            return;
        }
        if (appCallback != null) {
            HTTPConnection.updateAppFrameworkCallbackMap(appCallback, pullQuerySyncCallback);
        }
        String messageSubType = String.valueOf(700);
        if (Strings.isNullOrEmpty((String)customData)) {
            messageSubType = String.valueOf(600);
        }
        HTTPConnection.postDirect(processAgentFunctionName, String.valueOf(8000), messageSubType, requestType, customData, applicationName, null, null, pullQuerySyncCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static ISyncResponse processDataInSyncMode(IDataStructure headerDataStructure, boolean isCustomData, HTTPResponse httpResponse, boolean autoSave) throws ApplicationException, DBException {
        if (httpResponse == null) {
            error = "Invalid response. HTTP Response is null.";
            Logger.log(8, SyncDataHandler.class.getName(), "sendDataInSyncModeWithAutoSave", error);
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "error");
        }
        responseCode = httpResponse.getResponseCode();
        if (responseCode != 200) {
            syncBEResponse = new SyncBEResponse(responseCode, httpResponse.getErrorMessage());
            infoMessage = new InfoMessage();
            infoMessage.setMessage(httpResponse.getErrorMessage());
            infoMessage.setCategory("FAILURE");
            vector = new Vector<InfoMessage>();
            vector.add(infoMessage);
            syncBEResponse.setInfoMessages(vector);
            return syncBEResponse;
        }
        serverHTTPHeaderFields = httpResponse.getServerFields();
        if (serverHTTPHeaderFields == null) {
            error = "Invalid response. No server fields found in HttpResponse server fields.";
            Logger.log(8, SyncDataHandler.class.getName(), "sendDataInSyncModeWithAutoSave", error);
            syncBEResponse = new SyncBEResponse(responseCode, error);
            infoMessage = new InfoMessage();
            infoMessage.setMessage(error);
            infoMessage.setCategory("FAILURE");
            vector = new Vector<InfoMessage>();
            vector.add(infoMessage);
            syncBEResponse.setInfoMessages(vector);
            return syncBEResponse;
        }
        messageTypeString = serverHTTPHeaderFields.get("X-UNVIRED-MESSAGE-TYPE");
        messageSubTypeString = serverHTTPHeaderFields.get("X-UNVIRED-MESSAGE-SUB-TYPE");
        requestType = serverHTTPHeaderFields.get("REQUEST_TYPE");
        messageType = 0;
        messageSubType = 0;
        if (messageTypeString != null && !messageTypeString.isEmpty()) {
            messageType = Integer.valueOf(messageTypeString);
        }
        if (messageSubTypeString != null && !messageSubTypeString.isEmpty()) {
            messageSubType = Integer.valueOf(messageSubTypeString);
        }
        if (messageType != 8000) {
            error = "Invalid response. Message type or sub message type is invalid. Messagge Type: " + messageType + " Sub Message Type: " + messageSubType;
            Logger.log(8, SyncDataHandler.class.getName(), "sendDataInSyncModeWithAutoSave", error);
            syncBEResponse = new SyncBEResponse(responseCode, error);
            return syncBEResponse;
        }
        if (messageSubType == 700 || messageSubType == 900) {
            syncRawResponse = new SyncRawResponse(responseCode, httpResponse.getResponseBytes());
            syncRawResponse.setMessageType(messageType);
            syncRawResponse.setMessageSubType(messageSubType);
            if (requestType != null && !requestType.isEmpty()) {
                syncRawResponse.setRequestType(SyncConstants.MESSAGE_REQUEST_TYPE.valueOf(requestType));
            }
            return syncRawResponse;
        }
        messageData = httpResponse.getResponseBytes();
        infoMessages = null;
        data = null;
        metaData = null;
        dataFormat = FrameworkSettingsManager.getInstance().getDataFormat();
        try {
            if ("XML".equalsIgnoreCase(dataFormat)) {
                ibxmlParser = new UBXMLParser(messageData, SyncConstants.MESSAGE_REQUEST_TYPE.valueOf(requestType));
                infoMessages = ibxmlParser.getInfoMessages();
                data = ibxmlParser.getData();
                metaData = ibxmlParser.getMetaData();
            } else {
                ubjsonParser = new UBJSONParser(messageData, SyncConstants.MESSAGE_REQUEST_TYPE.valueOf(requestType));
                infoMessages = ubjsonParser.getInfoMessages();
                data = ubjsonParser.getData();
                metaData = ubjsonParser.getMetaData();
            }
        }
        catch (Exception ex) {
            if (!autoSave) {
                syncBEResponse = new SyncBEResponse();
                syncBEResponse.setBeMetaData(metaData);
                syncBEResponse.setDataBEs(data);
                syncBEResponse.setResponseCode(responseCode);
                syncBEResponse.setResponseBytes(messageData);
                return syncBEResponse;
            }
            syncBEResponse = new SyncBEResponse(0, "Error while parsing response data." + ex.getMessage());
            return syncBEResponse;
        }
        if (!autoSave) {
            syncBEResponse = new SyncBEResponse();
            syncBEResponse.setBeMetaData(metaData);
            syncBEResponse.setDataBEs(data);
            syncBEResponse.setResponseCode(responseCode);
            syncBEResponse.setResponseBytes(messageData);
            syncBEResponse.setInfoMessages(infoMessages);
            return syncBEResponse;
        }
        frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        if (infoMessages != null && !infoMessages.isEmpty()) {
            FrameworkHelper.cleanUpInfoMessages();
            noOfInfoMessages = infoMessages.size();
            infoMessage = null;
            for (i = 0; i < noOfInfoMessages; ++i) {
                infoMessage = infoMessages.elementAt(i);
                infoMessage.setSyncStatus(IDataStructure.SYNC_STATUS.ERROR);
                if (headerDataStructure != null) {
                    infoMessage.setBeName(headerDataStructure.getBEName());
                    infoMessage.setBeLid(headerDataStructure.getLid());
                }
                frameworkDataManager.insertOrUpdateBasedOnGID(infoMessage);
            }
            SyncDataHandler.saveInfoMessages(headerDataStructure);
        }
        applicationDataManager = ApplicationManager.getInstance().getDataManager();
        savePoint = Utils.getSavePointName();
        applicationDataManager.createSavepoint(savePoint);
        beKeys = data.keys();
        if (LoginParameters.isMultiAccEnabled() && headerDataStructure != null && data.size() > 0 && !data.containsKey(headerDataStructure.getBEName())) {
            infoMessage = new InfoMessage();
            infoMessage.setSyncStatus(IDataStructure.SYNC_STATUS.ERROR);
            infoMessage.setBeName(headerDataStructure.getBEName());
            infoMessage.setBeLid(headerDataStructure.getLid());
            frameworkDataManager.insertOrUpdateBasedOnGID(infoMessage);
            if (infoMessages != null) {
                infoMessages.add(infoMessage);
            }
            SyncDataHandler.saveInfoMessages(headerDataStructure);
            syncBEResponse = new SyncBEResponse(responseCode, infoMessages, data, metaData, autoSave);
            return syncBEResponse;
        }
        if (beKeys.hasMoreElements() && (incomingHeaderKeys = (incomingBE = data.get(beName = beKeys.nextElement())).keys()).hasMoreElements() && (incomingHeaderDataStructure = incomingHeaderKeys.nextElement()) != null) {
            incomingItemDataStructures = incomingBE.get(incomingHeaderDataStructure);
            if (headerDataStructure != null) {
                savePointName = Utils.getSavePointName();
                applicationDataManager.createSavepoint(savePointName);
                try {
                    if (incomingHeaderDataStructure.getBEName().equals(headerDataStructure.getBEName())) {
                        if (incomingHeaderDataStructure.getHasConflict()) {
                            conflictHandler = new ConflictHandler();
                            conflictHandler.handleConflict(headerDataStructure, incomingHeaderDataStructure, incomingItemDataStructures);
                        }
                        requestResponseBEReconcile = new RequestResponseBEReconciler(SyncDataHandler.conflictRule);
                        conflictBE = requestResponseBEReconcile.reconcile(applicationDataManager, headerDataStructure, incomingHeaderDataStructure, incomingItemDataStructures, true);
                        if (conflictBE == null) ** GOTO lbl174
                        SyncDataHandler.conflictBEs.add(conflictBE);
                    }
                    pullPushQueryBEReconcile = new PullPushQueryBEReconciler(SyncDataHandler.conflictRule);
                    reconcileObject = new ReconcileObject();
                    reconcileObject.setLid(headerDataStructure.getLid());
                    reconcileObject.setObjectStatus(headerDataStructure.getObjectStatus());
                    reconcileObject.setSyncStatus(headerDataStructure.getSyncStatus());
                    conflictBE = pullPushQueryBEReconcile.reconcile(applicationDataManager, reconcileObject, incomingHeaderDataStructure, incomingItemDataStructures);
                    if (conflictBE == null) ** GOTO lbl174
                    SyncDataHandler.conflictBEs.add(conflictBE);
                }
                catch (Exception e) {
                    Logger.e("Exception caught while reconciling incoming data with data in database.", e);
                    applicationDataManager.rollbackToSavepoint(savePointName);
                }
                finally {
                    applicationDataManager.releaseSavepoint(savePointName);
                }
            } else {
                savePointName = Utils.getSavePointName();
                applicationDataManager.createSavepoint(savePointName);
                try {
                    incomingHeaderDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                    incomingHeaderDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                    applicationDataManager.insert(incomingHeaderDataStructure);
                    size = incomingItemDataStructures.size();
                    itemDataStructure = null;
                    for (i = 0; i < size; ++i) {
                        itemDataStructure = incomingItemDataStructures.elementAt(i);
                        itemDataStructure.setFid(incomingHeaderDataStructure.getLid());
                        itemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                        itemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                        applicationDataManager.insert(itemDataStructure);
                        if (!(itemDataStructure instanceof AttachmentItem)) continue;
                        Attachment.checkAttachmentAndQueueAutoDownload(itemDataStructure);
                    }
                }
                catch (Exception e) {
                    Logger.e("Exception caught while inserting incoming data in database.", e);
                    applicationDataManager.rollbackToSavepoint(savePointName);
                }
                finally {
                    applicationDataManager.releaseSavepoint(savePointName);
                }
            }
        }
        applicationDataManager.releaseSavepoint(savePoint);
        syncBEResponse = new SyncBEResponse(responseCode, infoMessages, data, metaData, autoSave);
        return syncBEResponse;
    }

    private static void saveInfoMessages(IDataStructure headerDataStructure) {
        if (headerDataStructure != null) {
            try {
                IDataManager applicationDataManager = ApplicationManager.getInstance().getDataManager();
                headerDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.ERROR);
                applicationDataManager.update(headerDataStructure);
            }
            catch (DBException e) {
                Logger.e("DBException while savingInfoMessages: ", e);
            }
        }
    }

    protected static void checkAttachmentAndQueueAutoDownload(IDataStructure itemDataStructure) {
        boolean autoDownload = false;
        if (itemDataStructure instanceof AttachmentItem) {
            ((AttachmentItem)itemDataStructure).setAttachmentStatus(AttachmentItem.ATTACHMENT_ITEM_STATUS.DEFAULT);
            AttachmentItem attachmentItem = (AttachmentItem)itemDataStructure;
            autoDownload = attachmentItem.isAutoDownloadRequired();
            if (autoDownload) {
                Attachment.queueForDownload((AttachmentItem)itemDataStructure, "2");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ISyncResponse processDataQueryInSyncMode(HTTPResponse httpResponse, boolean autoSave) throws ApplicationException, DBException {
        if (httpResponse == null) {
            String error = "Invalid response. HTTP Response is null.";
            Logger.log(8, SyncDataHandler.class.getName(), "sendDataInSyncModeWithAutoSave", error);
            throw new ApplicationException(SyncDataHandler.class.getName(), "sendDataInSyncMode", "error");
        }
        int responseCode = httpResponse.getResponseCode();
        if (responseCode != 200) {
            SyncBEResponse syncBEResponse = new SyncBEResponse(responseCode, httpResponse.getErrorMessage());
            InfoMessage infoMessage = new InfoMessage();
            infoMessage.setMessage(httpResponse.getErrorMessage());
            infoMessage.setCategory("FAILURE");
            Vector<InfoMessage> vector = new Vector<InfoMessage>();
            vector.add(infoMessage);
            syncBEResponse.setInfoMessages(vector);
            return syncBEResponse;
        }
        Hashtable<String, String> serverHTTPHeaderFields = httpResponse.getServerFields();
        String messageTypeString = serverHTTPHeaderFields.get("X-UNVIRED-MESSAGE-TYPE");
        String messageSubTypeString = serverHTTPHeaderFields.get("X-UNVIRED-MESSAGE-SUB-TYPE");
        String requestType = serverHTTPHeaderFields.get("REQUEST_TYPE");
        int messageType = 0;
        int messageSubType = 0;
        if (messageTypeString != null && !messageTypeString.isEmpty()) {
            messageType = Integer.valueOf(messageTypeString);
        }
        if (messageSubTypeString != null && !messageSubTypeString.isEmpty()) {
            messageSubType = Integer.valueOf(messageSubTypeString);
        }
        if (messageType != 8000) {
            String error = "Invalid response. Message type or sub message type is invalid. Messagge Type: " + messageType + " Sub Message Type: " + messageSubType;
            Logger.log(8, SyncDataHandler.class.getName(), "sendDataInSyncModeWithAutoSave", error);
            SyncBEResponse syncBEResponse = new SyncBEResponse(responseCode, error);
            return syncBEResponse;
        }
        if (messageSubType == 700 || messageSubType == 900) {
            SyncRawResponse syncRawResponse = new SyncRawResponse(responseCode, httpResponse.getResponseBytes());
            syncRawResponse.setMessageType(messageType);
            syncRawResponse.setMessageSubType(messageSubType);
            if (requestType != null && !requestType.isEmpty()) {
                syncRawResponse.setRequestType(SyncConstants.MESSAGE_REQUEST_TYPE.valueOf(requestType));
            }
            return syncRawResponse;
        }
        byte[] messageData = httpResponse.getResponseBytes();
        Vector<InfoMessage> infoMessages = null;
        Hashtable<String, Hashtable<IDataStructure, Vector<IDataStructure>>> data = null;
        Vector<String> metaData = null;
        String dataFormat = FrameworkSettingsManager.getInstance().getDataFormat();
        try {
            if ("XML".equalsIgnoreCase(dataFormat)) {
                UBXMLParser ibxmlParser = new UBXMLParser(messageData, SyncConstants.MESSAGE_REQUEST_TYPE.valueOf(requestType));
                infoMessages = ibxmlParser.getInfoMessages();
                data = ibxmlParser.getData();
                metaData = ibxmlParser.getMetaData();
            } else {
                UBJSONParser ubjsonParser = new UBJSONParser(messageData, SyncConstants.MESSAGE_REQUEST_TYPE.valueOf(requestType));
                infoMessages = ubjsonParser.getInfoMessages();
                data = ubjsonParser.getData();
                metaData = ubjsonParser.getMetaData();
            }
        }
        catch (Exception ex) {
            if (!autoSave) {
                SyncBEResponse syncBEResponse = new SyncBEResponse();
                syncBEResponse.setDataBEs(data);
                syncBEResponse.setBeMetaData(metaData);
                syncBEResponse.setResponseCode(responseCode);
                syncBEResponse.setResponseBytes(messageData);
                return syncBEResponse;
            }
            SyncBEResponse syncBEResponse = new SyncBEResponse(0, "Error while parsing response data." + ex.getMessage());
            return syncBEResponse;
        }
        if (!autoSave) {
            SyncBEResponse syncBEResponse = new SyncBEResponse();
            syncBEResponse.setDataBEs(data);
            syncBEResponse.setBeMetaData(metaData);
            syncBEResponse.setResponseCode(responseCode);
            syncBEResponse.setResponseBytes(messageData);
            syncBEResponse.setInfoMessages(infoMessages);
            return syncBEResponse;
        }
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        if (infoMessages != null) {
            FrameworkHelper.cleanUpInfoMessages();
            int noOfInfoMessages = infoMessages.size();
            InfoMessage infoMessage = null;
            for (int i = 0; i < noOfInfoMessages; ++i) {
                infoMessage = infoMessages.elementAt(i);
                infoMessage.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                frameworkDataManager.insert(infoMessage);
            }
        }
        IDataManager applicationDataManager = ApplicationManager.getInstance().getDataManager();
        String savePoint = Utils.getSavePointName();
        applicationDataManager.createSavepoint(savePoint);
        Enumeration<String> beKeys = data.keys();
        while (beKeys.hasMoreElements()) {
            String beName = beKeys.nextElement();
            Hashtable<IDataStructure, Vector<IDataStructure>> incomingBE = data.get(beName);
            Enumeration<IDataStructure> incomingHeaderKeys = incomingBE.keys();
            if (beName != null) {
                BusinessEntityMeta businessEntityMeta = ApplicationManager.getInstance().getBusinessEntityMeta(beName);
                if (businessEntityMeta == null) {
                    Logger.log(8, SyncDataHandler.class.getName(), "processDataQueryInSyncMode", "No BusinessEntityMeta found for BE :" + beName + ". Ignoring this BE.");
                    continue;
                }
                conflictRule = businessEntityMeta.getConflictRule();
            }
            while (incomingHeaderKeys.hasMoreElements()) {
                String savePointName;
                IDataStructure incomingHeaderDataStructure = incomingHeaderKeys.nextElement();
                Vector<IDataStructure> incomingItemDataStructures = incomingBE.get(incomingHeaderDataStructure);
                IDataStructure headerDataStructureInDB = applicationDataManager.getBasedOnGID(incomingHeaderDataStructure);
                if (headerDataStructureInDB != null) {
                    savePointName = Utils.getSavePointName();
                    applicationDataManager.createSavepoint(savePointName);
                    try {
                        PullPushQueryBEReconciler pullPushQueryBEReconcile = new PullPushQueryBEReconciler(conflictRule);
                        ReconcileObject reconcileObject = new ReconcileObject();
                        reconcileObject.setLid(headerDataStructureInDB.getLid());
                        reconcileObject.setObjectStatus(headerDataStructureInDB.getObjectStatus());
                        reconcileObject.setSyncStatus(headerDataStructureInDB.getSyncStatus());
                        ConflictBE conflictBE = pullPushQueryBEReconcile.reconcile(applicationDataManager, reconcileObject, incomingHeaderDataStructure, incomingItemDataStructures);
                        if (conflictBE != null) {
                            conflictBEs.add(conflictBE);
                        }
                    }
                    catch (Exception e) {
                        Logger.e("Exception caught while reconciling incoming data in Query mode.", e);
                        applicationDataManager.rollbackToSavepoint(savePointName);
                    }
                    finally {
                        applicationDataManager.releaseSavepoint(savePointName);
                    }
                    incomingHeaderDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                    continue;
                }
                savePointName = Utils.getSavePointName();
                applicationDataManager.createSavepoint(savePointName);
                try {
                    incomingHeaderDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                    incomingHeaderDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                    applicationDataManager.insert(incomingHeaderDataStructure);
                    int size = incomingItemDataStructures.size();
                    IDataStructure itemDataStructure = null;
                    for (int i = 0; i < size; ++i) {
                        itemDataStructure = incomingItemDataStructures.elementAt(i);
                        itemDataStructure.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                        itemDataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                        applicationDataManager.insert(itemDataStructure);
                        if (!(itemDataStructure instanceof AttachmentItem)) continue;
                        Attachment.checkAttachmentAndQueueAutoDownload(itemDataStructure);
                    }
                }
                catch (Exception e) {
                    Logger.e("Exception caught while inserting incoming data in Query mode.", e);
                    applicationDataManager.rollbackToSavepoint(savePointName);
                }
                finally {
                    applicationDataManager.releaseSavepoint(savePointName);
                }
            }
        }
        applicationDataManager.releaseSavepoint(savePoint);
        SyncBEResponse syncBEResponse = new SyncBEResponse(responseCode, infoMessages, data, metaData, true);
        return syncBEResponse;
    }

    private static AttachmentResponse checkAndUploadAttachments(IDataStructure header) throws DBException, ApplicationException {
        AttachmentResponse attachmentResponse = null;
        AttachmentItem[] items = SyncDataHandler.getAttachmentsMarkedForUpload(header);
        if (items != null && items.length > 0) {
            boolean copied = Attachment.copyAllFilesToLocalPath(items);
            if (!copied) {
                Logger.log(8, "DataSender", "checkAndUploadAttachments", "All File could not be copied to the destination folder, that is application's folder. so not queuing this attachment for upload");
            } else {
                Logger.log(7, "DataSender", "checkAndUploadAttachments", "All File copied to the destination folder, that is application's folder.");
            }
            try {
                attachmentResponse = SyncDataHandler.uploadItems(header, items);
            }
            catch (Exception e) {
                return new AttachmentResponse(attachmentResponse.getResponseCode(), attachmentResponse.getErrorMessage() + e.getMessage());
            }
        }
        return attachmentResponse;
    }

    private static AttachmentResponse uploadItems(IDataStructure header, AttachmentItem[] items) throws Exception {
        AttachmentResponse attachmentResponse = null;
        if (items != null && items.length > 0) {
            AttachmentItem item = null;
            for (int i = 0; i < items.length; ++i) {
                item = items[i];
                try {
                    attachmentResponse = HTTPConnection.uploadAttachment(item, false, true, "UPLOAD_ATTACHMENT");
                    if (!Strings.isNullOrEmpty((String)attachmentResponse.getGUID())) continue;
                    attachmentResponse.setErrorMessage("No GUID return for this Attachment in response.");
                    Logger.e("Attachment upload failed as not guid returned. Hence stopping upload. BE upload will be ignored. Item failed - BE:  " + item.getBEName() + " Lid:" + item.getLid() + " File:" + item.getFileName());
                    break;
                }
                catch (ApplicationException e) {
                    Logger.log(8, "DataSender", "uploadItems", "ApplicationException while uploadItems: " + e.getMessage());
                    return new AttachmentResponse(attachmentResponse.getResponseCode(), attachmentResponse.getErrorMessage() + e.getMessage());
                }
                catch (DBException e) {
                    Logger.log(8, "DataSender", "uploadItems", "DBException while uploadItems: " + e.getMessage());
                    return new AttachmentResponse(attachmentResponse.getResponseCode(), attachmentResponse.getErrorMessage() + e.getMessage());
                }
                catch (Exception e) {
                    Logger.log(8, "DataSender", "uploadItems", "Exception while uploadItems: " + e.getMessage());
                    return new AttachmentResponse(attachmentResponse.getResponseCode(), attachmentResponse.getErrorMessage() + e.getMessage());
                }
            }
        }
        return attachmentResponse;
    }

    private static AttachmentItem[] getAttachmentsMarkedForUpload(IDataStructure header) {
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        IDataStructure[] dataStructures = null;
        try {
            IDataManager applicationDataManager = applicationManager.getDataManager();
            String beName = header.getBEName();
            String whereClause = "ATTACHMENT_STATUS = '" + AttachmentItem.ATTACHMENT_ITEM_STATUS.SAVED_FOR_UPLOAD.ordinal() + "'";
            String attachmentStructName = beName + "_ATTACHMENT";
            dataStructures = applicationDataManager.getChildren(attachmentStructName, whereClause, null, header);
            if (dataStructures == null || dataStructures.length == 0) {
                whereClause = whereClause + " AND FID = '" + header.getLid() + "'";
                dataStructures = applicationDataManager.get(attachmentStructName, whereClause);
            }
        }
        catch (DBException e) {
            Logger.log(8, SyncDataHandler.class.getName(), "getAttachments", "DBException while getting attachment items of a business header: " + e.getMessage());
        }
        if (dataStructures == null || dataStructures.length == 0) {
            Logger.log(8, SyncDataHandler.class.getName(), "getAttachments", "dataStructures is null, while checking if the IdataStructure in question supports attachments and if it has one");
            return null;
        }
        AttachmentItem[] items = new AttachmentItem[dataStructures.length];
        System.arraycopy(dataStructures, 0, items, 0, dataStructures.length);
        return items;
    }

    private static class PullQuerySyncCallback
    implements ISyncFrameworkCallback {
        private ISyncAppCallback syncAppCallback;
        private boolean autoSave;

        public PullQuerySyncCallback(ISyncAppCallback appCallback, boolean autoSave) {
            this.syncAppCallback = appCallback;
            this.autoSave = autoSave;
        }

        @Override
        public void onResponse(ISyncResponse iSyncResponse) {
            ISyncResponse syncResponse = null;
            SyncBEResponse syncBEResponse = null;
            try {
                syncResponse = SyncDataHandler.processDataQueryInSyncMode((HTTPResponse)iSyncResponse, this.autoSave);
            }
            catch (ApplicationException e) {
                Logger.e("ApplicationException caught while processing data in sync mode: ", e);
                syncBEResponse = new SyncBEResponse(0, "Error while processing response data." + e.getMessage());
                if (this.syncAppCallback != null) {
                    this.syncAppCallback.onResponse(syncBEResponse);
                }
                return;
            }
            catch (DBException e) {
                Logger.e("DBException caught while while processing data in sync mode: ", e);
                syncBEResponse = new SyncBEResponse(0, "Error while processing response data." + e.getMessage());
                if (this.syncAppCallback != null) {
                    this.syncAppCallback.onResponse(syncBEResponse);
                }
                return;
            }
            if (this.syncAppCallback != null) {
                this.syncAppCallback.onResponse(syncResponse);
            }
        }
    }

    private static class RequestResponseSyncCallback
    implements ISyncFrameworkCallback {
        private IDataStructure headerDataStructure;
        private ISyncAppCallback syncAppCallback;
        private boolean autoSave;

        public RequestResponseSyncCallback(IDataStructure headerDataStructure, ISyncAppCallback appCallback, boolean autoSave) {
            this.headerDataStructure = headerDataStructure;
            this.syncAppCallback = appCallback;
            this.autoSave = autoSave;
        }

        @Override
        public void onResponse(ISyncResponse iSyncResponse) {
            ISyncResponse syncResponse = null;
            SyncBEResponse syncBEResponse = null;
            try {
                syncResponse = SyncDataHandler.processDataInSyncMode(this.headerDataStructure, false, (HTTPResponse)iSyncResponse, this.autoSave);
            }
            catch (ApplicationException e) {
                Logger.e("ApplicationException caught while processing data in sync mode: ", e);
                syncBEResponse = new SyncBEResponse(0, "Error while processing response data." + e.getMessage());
                if (this.syncAppCallback != null) {
                    this.syncAppCallback.onResponse(syncBEResponse);
                }
                return;
            }
            catch (DBException e) {
                Logger.e("DBException caught while while processing data in sync mode: ", e);
                syncBEResponse = new SyncBEResponse(0, "Error while processing response data." + e.getMessage());
                if (this.syncAppCallback != null) {
                    this.syncAppCallback.onResponse(syncBEResponse);
                }
                return;
            }
            if (this.syncAppCallback != null) {
                this.syncAppCallback.onResponse(syncResponse);
            }
        }
    }
}

