/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.in;

import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.core.SystemCredentialManager;
import com.unvired.database.DBException;
import com.unvired.database.DatabaseHelper;
import com.unvired.database.IDataManager;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.message.UNVDataHelper;
import com.unvired.model.InObject;
import com.unvired.model.InfoMessage;
import com.unvired.model.OutObject;
import com.unvired.model.SystemCredential;
import com.unvired.sync.SyncConstants;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.in.Inbox;
import com.unvired.sync.notifier.NotificationListener;
import com.unvired.utils.FileHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.QueryFunctionUtility;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SystemMessageHandler
extends DefaultHandler {
    private static String conversationId = null;
    private static String serverId = null;
    private static String applicationId = null;
    private static String applicationName = null;
    private int messageType;
    private int messageSubType;
    private String tempValue;
    private Hashtable<String, String> frameworkSettingsProperties;
    private InfoMessage currentInfoMessage;
    private Vector<InfoMessage> infoMessageNotifications;
    private ApplicationManager applicationManager;
    private FrameworkManager frameworkManager;
    private IDataManager frameworkDataManager = null;
    private NotificationListener notificationListener;
    private Vector<SystemCredential> systemCredentialsVector = new Vector();
    private SystemCredential systemCredential = null;
    private boolean isSystemCredential;
    private boolean isFrameworkSettingsDataTag;
    private Vector<String> queryFunctions;
    private String queryFunction = null;
    protected boolean infoMessageTagStarted = false;

    public SystemMessageHandler(InObject inObject) throws ApplicationException {
        this.applicationManager = ApplicationManager.getInstance();
        this.frameworkManager = FrameworkManager.getInstance();
        try {
            this.messageType = Integer.parseInt(inObject.getMessageType());
            this.messageSubType = Integer.parseInt(inObject.getMessageSubType());
            conversationId = inObject.getConversationId();
            serverId = inObject.getServerId();
            applicationId = inObject.getAppId();
            applicationName = inObject.getAppName();
            this.notificationListener = SyncEngine.getInstance().getNotificationListener();
            this.initialization();
            this.parseDocument();
        }
        catch (ApplicationException e) {
            Logger.e("Exception while handling system message. Exception: " + e.getMessage() + " Conversation Id: " + conversationId, e);
            this.deleteProcessedMessageFromInbox();
            throw e;
        }
        this.deleteProcessedMessageFromInbox();
    }

    private void parseDocument() throws ApplicationException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = null;
        try {
            saxParser = saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.log(8, this.getClass().getName(), "parseDocument", "ParserConfigurationException caught while creating SAXParser object, " + parserConfigurationException.getMessage());
            throw new ApplicationException(this.getClass().getName(), "parseDocument", "ParserConfigurationException caught while creating SAXParser object, " + parserConfigurationException.getMessage());
        }
        catch (SAXException saxException) {
            Logger.log(8, this.getClass().getName(), "parseDocument", "SAXException caught while creating SAXPArser object, " + saxException.getMessage());
            throw new ApplicationException(this.getClass().getName(), "parseDocument", "SAXException caught while creating SAXPArser object, " + saxException.getMessage());
        }
        File messageFile = null;
        try {
            messageFile = FrameworkHelper.readInboxFile(conversationId);
            if (messageFile == null || !messageFile.exists()) {
                Logger.log(8, this.getClass().getName(), "parseDocument", "File not found in Inbox directory for corresponding Conversation Id: " + conversationId);
                return;
            }
            saxParser.parse(messageFile, (DefaultHandler)this);
            messageFile.delete();
        }
        catch (Exception exception) {
            if (exception.getMessage() == null) {
                String fileContentWithStatus = FileHelper.getFileContentWithStatus(messageFile);
                Logger.log(8, this.getClass().getName(), "parseDocument", "Exception caught while parsing message file. File Status with Content" + fileContentWithStatus);
            }
            String exceptionMessage = FrameworkHelper.getExceptionMessage(exception);
            String errorText = " Conversation Id: " + conversationId + " Message Type: " + this.messageType;
            Logger.log(8, this.getClass().getName(), "parseDocument", "Exception while parsing incoming message: " + exceptionMessage + errorText);
            this.deleteProcessedMessageFromInbox();
        }
    }

    private void initialization() throws ApplicationException {
        String error = null;
        if (this.messageType != 9000) {
            error = "Invalid message type. Message Type: " + this.messageType;
        } else if (conversationId == null || conversationId.length() <= 0) {
            error = "Conversation Id from server found as empty.";
        } else if (serverId == null || serverId.length() <= 0) {
            error = "Server Id from server found as empty. Conversation Id: " + conversationId;
        }
        if (error != null) {
            Logger.log(7, this.getClass().getName(), "initialization", error);
            throw new ApplicationException(this.getClass().getName(), "initialization", error);
        }
        Logger.log(7, this.getClass().getName(), "initialization", "CONVERSATION-ID: " + conversationId + " SERVER-ID: " + serverId);
        this.frameworkDataManager = this.frameworkManager.getDataManager();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tempValue = "";
        if ("data".equalsIgnoreCase(localName)) {
            this.initializeDataNode(attributes);
        }
        if ("InfoMessage".equalsIgnoreCase(localName)) {
            this.currentInfoMessage = new InfoMessage();
            this.infoMessageTagStarted = true;
            if (this.infoMessageNotifications == null) {
                this.infoMessageNotifications = new Vector();
            }
        } else if (this.messageSubType == 800) {
            if ("SYSTEM".equalsIgnoreCase(localName)) {
                this.systemCredential = new SystemCredential();
                this.isSystemCredential = true;
            } else if ("SYSTEMS".equalsIgnoreCase(localName)) {
                this.isSystemCredential = true;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tempValue = new String(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.infoMessageTagStarted) {
            if (this.tempValue == null || this.tempValue.length() <= 0) {
                Logger.log(8, SystemMessageHandler.class.getName(), "endElement", "Ignoring InfoMessage fields as value is null or field is removed in UMP. Field :" + localName + " Value: " + this.tempValue);
                return;
            }
            if ("type".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setType(this.tempValue.toString());
            } else if ("subtype".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setSubType(this.tempValue.toString());
            } else if ("category".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setCategory(this.tempValue.toString());
            } else if ("message".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setMessage(this.tempValue.toString());
            } else if ("belid".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setBeLid(this.tempValue.toString());
            } else if ("bename".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setBeName(this.tempValue.toString());
            } else if ("messagedetails".equalsIgnoreCase(localName)) {
                this.currentInfoMessage.setMessageBlob(this.tempValue.toString().getBytes());
            }
        }
        if ("data".equalsIgnoreCase(localName)) {
            if (this.messageSubType == 800) {
                this.isFrameworkSettingsDataTag = false;
            }
            try {
                this.handleSystemMessage();
            }
            catch (Exception exception) {
                Logger.log(8, this.getClass().getName(), "endElement", "handleSystemMessage() has thrown a exception: " + exception.toString());
                this.deleteProcessedMessageFromInbox();
            }
            if (this.notificationListener != null) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (SystemMessageHandler.this.infoMessageNotifications != null && SystemMessageHandler.this.infoMessageNotifications.size() > 0) {
                            SystemMessageHandler.this.notificationListener.notifyServerMessages(SystemMessageHandler.this.infoMessageNotifications);
                        }
                    }
                });
                t.start();
            }
        } else if (this.messageSubType == 500 || this.messageSubType == 800) {
            if (this.isFrameworkSettingsDataTag) {
                this.frameworkSettingsProperties.put(localName, this.tempValue);
            } else if (this.isSystemCredential) {
                if ("SYSTEM".equalsIgnoreCase(localName)) {
                    this.systemCredentialsVector.addElement(this.systemCredential);
                } else if ("PORT_DESCR".equalsIgnoreCase(localName)) {
                    this.systemCredential.setPortDesc(this.tempValue);
                } else if ("PORT_NAME".equalsIgnoreCase(localName)) {
                    this.systemCredential.setPortName(this.tempValue);
                } else if ("PORT_TYPE".equalsIgnoreCase(localName)) {
                    this.systemCredential.setPortType(this.tempValue);
                } else if ("SYSTEM_DESCR".equalsIgnoreCase(localName)) {
                    this.systemCredential.setSystemDesc(this.tempValue);
                } else if ("SYSTEMS".equalsIgnoreCase(localName)) {
                    this.isSystemCredential = false;
                    SystemCredential[] systemCredentials = new SystemCredential[this.systemCredentialsVector.size()];
                    for (int i = 0; i < systemCredentials.length; ++i) {
                        systemCredentials[i] = this.systemCredentialsVector.get(i);
                    }
                    try {
                        SystemCredentialManager.saveOrUpdate(systemCredentials);
                    }
                    catch (DBException dbe) {
                        Logger.log(8, this.getClass().getName(), "endElement", "DBException caught while saving system credential in database, " + dbe.getMessage());
                    }
                }
            }
        } else if ("InfoMessage".equalsIgnoreCase(localName)) {
            this.infoMessageNotifications.addElement(this.currentInfoMessage);
            try {
                this.frameworkDataManager.insert(this.currentInfoMessage);
            }
            catch (DBException dbException) {
                String error = "DBException caught while executing transaction to insert only header structure, " + dbException.getMessage();
                Logger.log(8, this.getClass().getName(), "endElement", error);
                throw new SAXException(dbException);
            }
            this.currentInfoMessage = null;
        } else if ("Function".equalsIgnoreCase(localName)) {
            if (this.messageType == 9000 && (this.messageSubType == 450 || this.messageSubType == 440 || this.messageSubType == 400)) {
                this.queryFunction = this.tempValue;
                if (this.queryFunctions == null) {
                    this.queryFunctions = new Vector();
                }
                this.queryFunctions.addElement(this.queryFunction);
            }
        } else if ("FUNC_NAME".equalsIgnoreCase(localName) && this.messageType == 9000 && (this.messageSubType == 450 || this.messageSubType == 440 || this.messageSubType == 400)) {
            this.queryFunction = this.tempValue;
            if (this.queryFunctions == null) {
                this.queryFunctions = new Vector();
            }
            this.queryFunctions.addElement(this.queryFunction);
        }
    }

    private void initializeDataNode(Attributes attributes) {
        this.messageSubType = 0;
        String messageSubTypeString = null;
        if (attributes != null) {
            messageSubTypeString = attributes.getValue("subtype");
        }
        if (!Strings.isNullOrEmpty(messageSubTypeString)) {
            this.messageSubType = Integer.parseInt(messageSubTypeString);
        }
        switch (this.messageSubType) {
            case 500: {
                this.frameworkSettingsProperties = new Hashtable();
                break;
            }
            case 800: {
                this.frameworkSettingsProperties = new Hashtable();
                this.isFrameworkSettingsDataTag = true;
            }
        }
        this.infoMessageNotifications = new Vector();
    }

    private void handleSystemMessage() throws Exception {
        if (this.messageType == 9000) {
            switch (this.messageSubType) {
                case 100: {
                    this.handlePingMessage();
                    break;
                }
                case 200: {
                    this.handleLogRequest();
                    break;
                }
                case 210: {
                    this.handleLogResetRequest();
                    break;
                }
                case 230: {
                    this.handleLogSetDebugLevel();
                    break;
                }
                case 220: {
                    this.handleLogSetErrorLevel();
                    break;
                }
                case 300: {
                    this.handleDataDumpRequest();
                    break;
                }
                case 410: {
                    this.handleApplicationAssignment();
                    break;
                }
                case 430: {
                    this.handleApplicationUnassigned();
                    break;
                }
                case 700: {
                    Logger.log(8, this.getClass().getSimpleName(), "handleSystemMessage", "Server requested for reset data.Client ignored this message.Please use Wipe instead.");
                    break;
                }
                case 800: {
                    this.handleActivation();
                    break;
                }
                case 440: {
                    this.handleInitiatePull();
                    break;
                }
                case 400: {
                    this.handleInitialDataDownloadPull();
                    break;
                }
                case 450: {
                    this.handleInitialDataDownloadPullCompletion();
                    break;
                }
            }
        }
    }

    private void handlePingMessage() {
        Document document = FrameworkHelper.getSenderDocumentRoot(9000, conversationId, serverId, applicationId, applicationName);
        SystemMessageHandler.createDataElement(document, 100);
        this.addToOutbox(100, document);
    }

    private void handleLogRequest() throws ApplicationException {
        Logger.sendLogToServerInSync(null);
        Logger.log(7, this.getClass().getName(), "handleLogRequest", "Log sent to server: " + conversationId);
    }

    private void handleLogResetRequest() {
        Logger.deleteLogs();
        Logger.log(7, this.getClass().getName(), "handleLogResetRequest", "Log RESET request from server: " + conversationId);
    }

    private void handleLogSetErrorLevel() throws DBException {
        Logger.log(7, this.getClass().getName(), "handleLogSetErrorLevel", "Log set log level to error, request from server: " + conversationId);
        Logger.setLogLevel(8);
        FrameworkSettingsManager frameworkSettingsManager = this.frameworkManager.getFrameworkSettingsManager();
        frameworkSettingsManager.setLogLevel(8);
    }

    private void handleLogSetDebugLevel() throws DBException {
        Logger.log(7, this.getClass().getName(), "handleLogSetDebugLevel", "Log set log level to debug, request from server: " + conversationId);
        Logger.setLogLevel(9);
        FrameworkSettingsManager frameworkSettingsManager = this.frameworkManager.getFrameworkSettingsManager();
        frameworkSettingsManager.setLogLevel(9);
    }

    private void handleDataDumpRequest() throws ApplicationException {
        try {
            UNVDataHelper.exportApplicationData();
        }
        catch (DBException dbException) {
            Logger.log(8, this.getClass().getName(), "handleDataDumpRequest", "DBException caught while creating data dump request for server, " + dbException.getMessage());
            throw new ApplicationException(this.getClass().getName(), "handleDataDumpRequest", "DBException caught while creating data dump request for server, " + dbException.getMessage());
        }
    }

    private void handleApplicationAssignment() {
        try {
            this.applicationManager.activateApplication(applicationId);
        }
        catch (DBException dbException) {
            Logger.log(8, this.getClass().getName(), "handleApplicationAssignment", dbException.getMessage());
            return;
        }
        Document initialDataRequestDocument = FrameworkHelper.getSenderDocumentRoot(9000, null, serverId, applicationName, applicationId);
        Element root = initialDataRequestDocument.getDocumentElement();
        Element initialDataRequestDataElement = initialDataRequestDocument.createElement("data");
        initialDataRequestDataElement.setAttribute("subtype", String.valueOf(400));
        root.appendChild(initialDataRequestDataElement);
        this.addToOutbox(400, initialDataRequestDocument);
    }

    private void handleApplicationUnassigned() {
        Logger.log(7, this.getClass().getName(), "handleApplicationUnassigned", "Application Unassignment. Conversation Id: " + conversationId);
        try {
            FrameworkHelper.stopThreads();
            this.applicationManager.closeDB();
            this.frameworkManager.closeDB();
            this.applicationManager.dropDatabase();
            this.frameworkManager.dropDatabase();
            FrameworkHelper.shutdown();
        }
        catch (DBException dbException) {
            Logger.log(8, this.getClass().getName(), "handleApplicationUnassigned", dbException.getMessage());
            try {
                DatabaseHelper.deleteDatabases(true);
            }
            catch (Exception exception) {
                Logger.log(8, this.getClass().getName(), "handleApplicationUnassigned", exception.getMessage());
            }
        }
    }

    private void populateFrameworkSettings(FrameworkSettingsManager frameworkSettingsManager) throws DBException {
        Enumeration<String> keys = this.frameworkSettingsProperties.keys();
        while (keys.hasMoreElements()) {
            String propertyName = keys.nextElement();
            String propertyValue = this.frameworkSettingsProperties.get(propertyName);
            if (!"ONE_TIME_SECRET".equalsIgnoreCase(propertyName) && !"SEC_KEY".equalsIgnoreCase(propertyName)) {
                Logger.log(7, this.getClass().getName(), "populateFrameworkSettings", propertyName + ": " + propertyValue);
            }
            frameworkSettingsManager.setField(propertyName, propertyValue);
        }
        if (!this.frameworkSettingsProperties.contains("LOCAL_PASSWORD")) {
            frameworkSettingsManager.setLocalPassword("false");
        }
    }

    private void handleResetData() throws ApplicationException {
        NotificationListener notificationListener = SyncEngine.getInstance().getNotificationListener();
        FrameworkHelper.stopThreads();
        try {
            this.frameworkManager.resetSyncLayer();
        }
        catch (DBException dbException) {
            Logger.log(8, this.getClass().getName(), "handleResetData", "Exception while reseting the sync tables: " + dbException.getMessage());
            throw new ApplicationException(this.getClass().getName(), "handleResetData", "Exception while reseting the sync tables: " + dbException.getMessage());
        }
        try {
            this.applicationManager.reset();
        }
        catch (DBException dbException) {
            Logger.log(8, this.getClass().getName(), "handleResetData", "Exception while reseting the application tables: " + dbException.getMessage());
            throw new ApplicationException(this.getClass().getName(), "handleResetData", "Exception while reseting the application tables: " + dbException.getMessage());
        }
        this.deleteProcessedMessageFromInbox();
        FrameworkHelper.shutdown();
        Logger.d("Application Reset");
        if (notificationListener != null) {
            notificationListener.notifyApplicationReset();
        }
    }

    private void handleInitiatePull() {
        try {
            SyncEngine.getInstance().sendDataRequests(this.queryFunctions);
        }
        catch (DBException ae) {
            Logger.log(8, this.getClass().getName(), "handleInitiatePull", ae.getMessage());
        }
        catch (ApplicationException e) {
            Logger.log(8, this.getClass().getName(), "handleInitiatePull", e.getMessage());
        }
    }

    private void handleActivation() throws DBException {
        FrameworkSettingsManager frameworkSettingsManager = this.frameworkManager.getFrameworkSettingsManager();
        this.populateFrameworkSettings(frameworkSettingsManager);
        this.setSecurity(frameworkSettingsManager.getSecLevel(), frameworkSettingsManager.getSecKey(), frameworkSettingsManager.getCsrUrl());
        Document activationDocument = FrameworkHelper.getSenderDocumentRoot(9000, conversationId, serverId, applicationName, applicationId);
        SystemMessageHandler.createDataElement(activationDocument, 800);
        this.addToOutbox(800, activationDocument);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setSecurity(int securityLevel, String securityKey, String csrURL) {
        try {
            if (securityLevel != FrameworkSettingsManager.SECURITY_LEVEL_CLIENT_CERTIFICATE_WITH_HTTPS && securityLevel != FrameworkSettingsManager.SECURITY_LEVEL_SHARED_KEY_WITH_HTTPS && securityLevel != FrameworkSettingsManager.SECURITY_LEVEL_SHARED_KEY_WITH_HTTP && securityLevel != FrameworkSettingsManager.SECURITY_LEVEL_CLIENT_CERTIFICATE_WITH_HTTPS) return;
        }
        catch (Exception exception) {
            Logger.log(8, this.getClass().getName(), "setSecurity", "Exception in setting security: " + exception.getMessage());
            Logger.log(8, this.getClass().getName(), "setSecurity", "Exception in setting security. Security Level " + securityLevel);
        }
    }

    private void addToOutbox(int messageSubType, Document document) {
        byte[] xml = null;
        try {
            xml = FrameworkHelper.getBytes(document);
        }
        catch (ApplicationException e) {
            Logger.log(8, this.getClass().getName(), "addToOutbox", "Exception while getting bytes from xml document " + e.getMessage());
        }
        String nameSpace = null;
        try {
            nameSpace = FrameworkSettingsManager.getInstance().getNamespace();
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getName(), "addToOutbox", "DBException: " + e.getMessage());
        }
        OutObject outObject = new OutObject();
        outObject.setFunctionName("ADMIN_SERVICES");
        outObject.setMessageType(String.valueOf(9000));
        outObject.setMessageSubType(String.valueOf(messageSubType));
        outObject.setMessageXml(xml);
        outObject.setSyncType(SyncConstants.SYNC_MODE.SYNC.toString());
        outObject.setConversationId(conversationId);
        try {
            SyncEngine.getInstance().sendToServerAsync(outObject);
        }
        catch (Exception exception) {
            Logger.log(8, this.getClass().getName(), "addToOutbox", "Exception while adding object to outbox " + exception.getMessage());
        }
    }

    private static Element createDataElement(Document document, int messageSubtype) {
        Element root = document.getDocumentElement();
        Element dataElement = document.createElement("data");
        dataElement.setAttribute("subtype", String.valueOf(messageSubtype));
        root.appendChild(dataElement);
        return dataElement;
    }

    private void deleteProcessedMessageFromInbox() {
        try {
            Inbox.getInstance().remove(conversationId);
        }
        catch (DBException dbException) {
            Logger.log(8, this.getClass().getName(), "deleteProcessesMessageFromInbox", "DBException caught while deleting outobject from database, CONVERSATION-ID: " + conversationId + ", " + dbException.getMessage());
        }
    }

    private void handleInitialDataDownloadPull() {
        if (this.queryFunctions == null || this.queryFunctions.size() == 0) {
            Logger.log(8, this.getClass().getName(), "handleInitialDataDownloadPull", "No Functions specified in the Initial Download PULL Message.Cannot Add Any Functions to the QUERY_FUNCTION Table");
        }
        QueryFunctionUtility.addFunctions(this.queryFunctions);
    }

    private void handleInitialDataDownloadPullCompletion() {
        if (this.queryFunctions == null || this.queryFunctions.size() == 0) {
            Logger.log(8, this.getClass().getName(), "handleInitialDataDownloadPullCompletion", "NO Functions specified in the Initial Download PULL Message Completion.Cannot Delete Any Functions from the QUERY_FUNCTION Table");
        }
        QueryFunctionUtility.deleteFunctions(this.queryFunctions);
    }
}

