/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.out;

import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentOutObject;
import com.unvired.model.StructureMeta;
import com.unvired.sync.out.AttachmentSender;

public class AttachmentOutbox {
    private static AttachmentOutbox attachmentOutbox = null;
    private IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();

    private AttachmentOutbox() {
    }

    public static AttachmentOutbox getInstance() {
        if (attachmentOutbox == null) {
            attachmentOutbox = new AttachmentOutbox();
        }
        return attachmentOutbox;
    }

    public static void destroy() {
        if (attachmentOutbox != null) {
            attachmentOutbox = null;
            Logger.log(7, AttachmentOutbox.class.getName(), "destroy", "Destroyed");
        } else {
            Logger.log(7, AttachmentOutbox.class.getName(), "destroy", "Destroy not required. Already null.");
        }
    }

    public void add(AttachmentOutObject attachmentOutObject) throws DBException, ApplicationException {
        if (attachmentOutObject == null) {
            Logger.log(8, this.getClass().getName(), "add", "AttachmentOutObject cannot be null.");
            return;
        }
        String beName = attachmentOutObject.getBEName();
        String beLid = attachmentOutObject.getBEHeaderLid();
        if (beName == null) {
            throw new ApplicationException(this.getClass().getName(), "add", "BE cannot be null");
        }
        if (beLid == null) {
            throw new ApplicationException(this.getClass().getName(), "add", "BE LID cannot be null");
        }
        IDataStructure[] dataStructures = null;
        try {
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            IDataManager dataManager = applicationManager.getDataManager();
            StructureMeta structureMeta = applicationManager.getHeaderStructureMeta(beName);
            String structureName = structureMeta.getStructName();
            String whereClause = "LID='" + beLid + "'";
            dataStructures = dataManager.get(structureName, whereClause);
        }
        catch (DBException dbe) {
            Logger.log(8, this.getClass().getName(), "sendToServerAsync", "DBException caught while getting business entity from database, BE-NAME: " + beName + ", BE-LID: " + beLid + ", " + dbe.getMessage());
            throw dbe;
        }
        if (dataStructures == null || dataStructures.length <= 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "sendToServerAsync", "No Business Entity got from database, BE-NAME: " + beName + ", BE-LID: " + beLid);
            }
            return;
        }
        IDataStructure dataStructure = dataStructures[0];
        dataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.QUEUED);
        try {
            IDataManager applicationManager = ApplicationManager.getInstance().getDataManager();
            applicationManager.update(dataStructure);
        }
        catch (DBException dbe) {
            Logger.log(8, this.getClass().getName(), "sendToServerAsync", "DBException caught while updating data structure status to waiting to be sent, " + dbe.getMessage());
            throw dbe;
        }
        AttachmentOutObject attachmentOutObj = attachmentOutObject;
        if (this.frameworkDataManager == null) {
            this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        }
        this.frameworkDataManager.insertOrUpdateBasedOnGID(attachmentOutObj);
        AttachmentSender attachmentSender = AttachmentSender.getInstance();
        attachmentSender.start();
    }

    public void remove(AttachmentOutObject attachmentOutObject) throws DBException {
        if (attachmentOutObject == null) {
            Logger.log(8, this.getClass().getName(), "remove", "AttachmentOutObject cannot be null.");
            return;
        }
        String lid = attachmentOutObject.getLid();
        this.remove(lid);
    }

    public void removeBELid(String beLid) throws DBException {
        if (Strings.isNullOrEmpty((String)beLid)) {
            Logger.e("BE Lid cannot me null/empty");
            return;
        }
        String whereClause = AttachmentOutObject.BE_HEADER_LID + " = '" + beLid + "'";
        this.frameworkDataManager.delete(AttachmentOutObject.TABLE_NAME, whereClause);
    }

    public void remove(String lid) throws DBException {
        if (lid == null) {
            Logger.log(8, this.getClass().getName(), "remove", "LID cannot be null");
        }
        String whereClause = "LID = '" + lid + "'";
        this.frameworkDataManager.delete(AttachmentOutObject.TABLE_NAME, whereClause);
    }

    public void resetAll() throws DBException {
        this.frameworkDataManager.delete(AttachmentOutObject.TABLE_NAME);
    }

    public AttachmentOutObject getNext() throws DBException {
        String[] orderBy = new String[]{"TIME_STAMP"};
        String whereClause = AttachmentOutObject.FIELD_ATTACHMENT_OUT_OBJECT_STATUS + "='" + (Object)((Object)AttachmentOutObject.ATTACHMENT_OUT_OBJECT_STATUS.NONE) + "'";
        IDataStructure[] dataStructures = this.frameworkDataManager.get(AttachmentOutObject.TABLE_NAME, whereClause, orderBy, AttachmentOutObject.class);
        if (dataStructures == null || dataStructures.length == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "getNext", "No attachmentOutobjects in database");
            }
            return null;
        }
        AttachmentOutObject attachmentOutObject = (AttachmentOutObject)dataStructures[0];
        return attachmentOutObject;
    }

    public boolean isInQueue(String beLid) throws DBException {
        if (beLid == null) {
            return false;
        }
        String whereClause = AttachmentOutObject.BE_HEADER_LID + " = '" + beLid + "'";
        int presentOrNot = this.frameworkDataManager.count(AttachmentOutObject.TABLE_NAME, whereClause);
        if (presentOrNot == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "isInQueue", "No such attachmentOutobject present in database, BE LID: " + beLid);
            }
            return false;
        }
        return true;
    }

    public AttachmentOutObject getAttachmentOutObject(String beLid) throws DBException {
        String[] orderBy = new String[]{"TIME_STAMP"};
        String whereClause = AttachmentOutObject.BE_HEADER_LID + "='" + beLid + "' AND " + AttachmentOutObject.FIELD_ATTACHMENT_OUT_OBJECT_STATUS + "='" + (Object)((Object)AttachmentOutObject.ATTACHMENT_OUT_OBJECT_STATUS.NONE) + "'";
        IDataStructure[] dataStructures = this.frameworkDataManager.get(AttachmentOutObject.TABLE_NAME, whereClause, orderBy, AttachmentOutObject.class);
        if (dataStructures == null || dataStructures.length == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("No attachmentOutObjects in database for BeLid : " + beLid);
            }
            return null;
        }
        return (AttachmentOutObject)dataStructures[0];
    }

    public AttachmentOutObject[] getAttachmentOutObjects(String beLid) throws DBException {
        String[] orderBy = new String[]{"TIME_STAMP"};
        String whereClause = AttachmentOutObject.BE_HEADER_LID + "='" + beLid + "' AND " + AttachmentOutObject.FIELD_ATTACHMENT_OUT_OBJECT_STATUS + "='" + (Object)((Object)AttachmentOutObject.ATTACHMENT_OUT_OBJECT_STATUS.NONE) + "'";
        IDataStructure[] dataStructures = this.frameworkDataManager.get(AttachmentOutObject.TABLE_NAME, whereClause, orderBy, AttachmentOutObject.class);
        if (dataStructures == null || dataStructures.length == 0) {
            Logger.d("No attachmentOutObjects in database for BeLid : " + beLid);
            return null;
        }
        return this.attachmentOutObjectArrayCopy(dataStructures);
    }

    public AttachmentOutObject[] getAttachmentOutObjects() throws DBException {
        AttachmentOutObject[] attachmentOutObjects;
        IDataStructure[] dataStructures = null;
        if (this.frameworkDataManager != null) {
            dataStructures = this.frameworkDataManager.get(AttachmentOutObject.TABLE_NAME, AttachmentOutObject.class);
        }
        if ((attachmentOutObjects = this.attachmentOutObjectArrayCopy(dataStructures)) == null || attachmentOutObjects.length == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "getAllAttachmentOutObjects", "No such attachmentOutobject present in database.");
            }
            return null;
        }
        return attachmentOutObjects;
    }

    public boolean hasAnyAttachmentOutObject() throws DBException {
        IDataStructure[] dataStructures = this.frameworkDataManager.get(AttachmentOutObject.TABLE_NAME);
        AttachmentOutObject[] attachmentOutObjects = this.attachmentOutObjectArrayCopy(dataStructures);
        if (attachmentOutObjects == null) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "hasAnyAttachmentOutObject", "No attachmentOutobjects present in database.");
            }
            return false;
        }
        return true;
    }

    public int count() throws DBException {
        return this.frameworkDataManager.count(AttachmentOutObject.TABLE_NAME, "");
    }

    private AttachmentOutObject[] attachmentOutObjectArrayCopy(IDataStructure[] dataStructures) throws DBException {
        if (dataStructures == null || dataStructures.length == 0) {
            return null;
        }
        AttachmentOutObject[] attachmentOutObjects = new AttachmentOutObject[dataStructures.length];
        try {
            System.arraycopy(dataStructures, 0, attachmentOutObjects, 0, dataStructures.length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.log(8, this.getClass().getName(), "attachmentOutObjectArrayCopy", indexOutOfBoundsException.getMessage());
            throw new DBException(this.getClass().getName(), "attachmentOutObjectArrayCopy", indexOutOfBoundsException.getMessage());
        }
        catch (ArrayStoreException arrayStoreException) {
            Logger.log(8, this.getClass().getName(), "attachmentOutObjectArrayCopy", arrayStoreException.getMessage());
            throw new DBException(this.getClass().getName(), "attachmentOutObjectArrayCopy", arrayStoreException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            Logger.log(8, this.getClass().getName(), "attachmentOutObjectArrayCopy", nullPointerException.getMessage());
            throw new DBException(this.getClass().getName(), "attachmentOutObjectArrayCopy", nullPointerException.getMessage());
        }
        return attachmentOutObjects;
    }
}

