/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.out;

import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.AttachmentItem;
import com.unvired.model.AttachmentOutObject;
import com.unvired.model.InfoMessage;
import com.unvired.model.OutObject;
import com.unvired.model.StructureMeta;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.attachment.Attachment;
import com.unvired.sync.notifier.NotificationListener;
import com.unvired.sync.out.AttachmentOutbox;
import com.unvired.sync.out.DataSender;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.sync.out.Outbox;
import com.unvired.sync.response.AttachmentResponse;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.NetworkChangeReceiver;
import com.unvired.utils.NetworkStateListener;
import com.unvired.utils.NetworkUtil;

public class AttachmentSender {
    private static AttachmentSender attachmentSender = null;
    private boolean stop = false;
    private static boolean block = false;
    private static long dataSentOn = 0L;
    private AttachmentSenderThread attachmentSenderThread;
    private NotificationListener notificationListener;
    private IDataManager frameworkDataManager = null;
    private int attachmentConnectionType;
    private NetworkChangeReceiver networkChangeReceiver = SyncEngine.getInstance().getNetworkChangeReceiver();

    private AttachmentSender() {
        try {
            FrameworkSettingsManager frameworkSettingsManager = FrameworkManager.getInstance().getFrameworkSettingsManager();
            String attachmentConnectionTypeString = frameworkSettingsManager.getAttachmentConnection();
            this.attachmentConnectionType = "WIFI".equalsIgnoreCase(attachmentConnectionTypeString) ? 1 : 0;
        }
        catch (DBException e) {
            Logger.log(8, AttachmentSender.class.getName(), "AttachmentSender", "DBException:" + e.getMessage());
        }
    }

    public static AttachmentSender getInstance() {
        if (attachmentSender == null) {
            attachmentSender = new AttachmentSender();
        }
        return attachmentSender;
    }

    public void start() {
        if (this.attachmentSenderThread == null) {
            this.stop = false;
            this.attachmentSenderThread = new AttachmentSenderThread();
            this.attachmentSenderThread.setPriority(1);
            this.attachmentSenderThread.start();
        }
    }

    public void block() {
        block = true;
        Logger.log(9, AttachmentSender.class.getName(), "block", "Attachment Sender BLOCKED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock() {
        block = false;
        if (this.attachmentSenderThread != null) {
            AttachmentSenderThread attachmentSenderThread = this.attachmentSenderThread;
            synchronized (attachmentSenderThread) {
                this.attachmentSenderThread.notify();
            }
        }
        Logger.log(9, AttachmentSender.class.getName(), "unblock", "Attachment Sender UN-BLOCKED");
    }

    public boolean isAlive() {
        return this.attachmentSenderThread != null;
    }

    public void stop() {
        try {
            this.stop = true;
            if (NetworkUtil.isEmulator()) {
                Logger.log(7, this.getClass().getName(), "stop", "Attachment Sender STOP instruction");
            }
            if (this.attachmentSenderThread == null) {
                return;
            }
            this.attachmentSenderThread.interrupt();
            this.attachmentSenderThread.join();
        }
        catch (InterruptedException e) {
            Logger.log(8, this.getClass().getName(), "stop", "Attachment Sender Interrupted: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            Logger.log(8, this.getClass().getName(), "stop", "Attachment Sender Exception: " + e.getMessage());
        }
        catch (Throwable e) {
            Logger.log(8, this.getClass().getName(), "stop", "Attachment Sender Exception: " + e.getMessage());
        }
        finally {
            this.attachmentSenderThread = null;
            attachmentSender = null;
        }
    }

    public static long getDataSentTime() {
        return dataSentOn;
    }

    private AttachmentResponse checkAndUploadAttachments(AttachmentOutObject attachmentOutObject) throws DBException, ApplicationException {
        AttachmentResponse attachmentResponse = null;
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        String beName = attachmentOutObject.getBEName();
        if (beName == null || beName.length() <= 0 || !applicationManager.isAttachmentSupported(beName)) {
            return null;
        }
        StructureMeta structureMeta = applicationManager.getHeaderStructureMeta(beName);
        if (structureMeta == null) {
            Logger.log(8, this.getClass().getName(), "checkAndUploadAttachments", "Invalid BE. Cannot upload attachments. BE Name: " + beName);
            return null;
        }
        if (!applicationManager.isAttachmentSupported(attachmentOutObject.getBEName())) {
            return null;
        }
        IDataManager applicationDataManager = applicationManager.getDataManager();
        String lid = String.valueOf(attachmentOutObject.getBEHeaderLid());
        String whereClause = "LID = '" + lid + "'";
        IDataStructure[] headers = applicationDataManager.get(structureMeta.getStructName(), whereClause);
        if (headers == null || headers.length == 0) {
            Logger.log(8, this.getClass().getName(), "checkAndUploadAttachments", "Header not found. Cannot check for attachments.");
            return null;
        }
        IDataStructure header = headers[0];
        AttachmentItem[] items = this.getAttachments(header);
        try {
            attachmentResponse = this.uploadItems(items);
        }
        catch (Exception e) {
            return new AttachmentResponse(attachmentResponse.getResponseCode(), attachmentResponse.getErrorMessage() + e.getMessage());
        }
        return attachmentResponse;
    }

    private AttachmentResponse uploadItems(AttachmentItem[] items) throws Exception {
        AttachmentResponse attachmentResponse = null;
        boolean copied = Attachment.copyAllFilesToLocalPath(items);
        if (!copied) {
            Logger.log(8, AttachmentSender.class.getName(), "uploadItems", "All File could not be copied to the destination folder, that is application's folder. so not queuing this attachment for upload");
        } else {
            Logger.log(7, AttachmentSender.class.getName(), "uploadItems", "All File copied to the destination folder, that is application's folder.");
        }
        if (items != null && items.length > 0) {
            AttachmentItem item = null;
            for (int i = 0; i < items.length; ++i) {
                item = items[i];
                try {
                    attachmentResponse = HTTPConnection.uploadAttachment(item, true, true, "UPLOAD_ATTACHMENT");
                    if (!Strings.isNullOrEmpty((String)attachmentResponse.getGUID())) continue;
                    attachmentResponse.setErrorMessage("No GUID return for this Attachment in response.");
                    Logger.e("Attachment upload failed as not guid returned. Hence stopping upload. BE upload will be ignored. Item failed - BE:  " + item.getBEName() + " Lid:" + item.getLid() + " File:" + item.getFileName());
                    break;
                }
                catch (ApplicationException e) {
                    Logger.log(8, "AttachmentSender", "uploadItems", "ApplicationException while uploadItems: " + e.getMessage());
                    return new AttachmentResponse(attachmentResponse.getResponseCode(), attachmentResponse.getErrorMessage() + e.getMessage());
                }
                catch (DBException e) {
                    Logger.log(8, "AttachmentSender", "uploadItems", "DBException while uploadItems: " + e.getMessage());
                    return new AttachmentResponse(attachmentResponse.getResponseCode(), attachmentResponse.getErrorMessage() + e.getMessage());
                }
                catch (Exception e) {
                    Logger.log(8, "AttachmentSender", "uploadItems", "Exception while uploadItems: " + e.getMessage());
                    return new AttachmentResponse(attachmentResponse.getResponseCode(), attachmentResponse.getErrorMessage() + e.getMessage());
                }
            }
        }
        return attachmentResponse;
    }

    private AttachmentItem[] getAttachments(IDataStructure header) {
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        IDataStructure[] dataStructures = null;
        try {
            IDataManager applicationDataManager = applicationManager.getDataManager();
            String beName = header.getBEName();
            String whereClause = "ATTACHMENT_STATUS = '" + AttachmentItem.ATTACHMENT_ITEM_STATUS.SAVED_FOR_UPLOAD.ordinal() + "'";
            String attachmentStructName = beName + "_ATTACHMENT";
            dataStructures = applicationDataManager.getChildren(attachmentStructName, whereClause, null, header);
        }
        catch (DBException e) {
            Logger.log(8, this.getClass().getName(), "getAttachments", "DBException while getting attachment items of a business header: " + e.getMessage());
        }
        if (dataStructures == null || dataStructures.length == 0) {
            Logger.log(8, this.getClass().getName(), "getAttachments", "dataStructures is null, while checking if the IdataStructure in question supports attachments and if it has one");
            return null;
        }
        AttachmentItem[] items = new AttachmentItem[dataStructures.length];
        System.arraycopy(dataStructures, 0, items, 0, dataStructures.length);
        return items;
    }

    class AttachmentSenderThread
    extends Thread {
        private final int SLEEP_TIME_START_IN_SECONDS = 30000;
        private final int SLEEP_TIME_MAX_IN_SECONDS = 300000;
        private int sleepTimeInSeconds = 30000;

        AttachmentSenderThread() {
        }

        @Override
        public void run() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run2() {
            Logger.log(7, this.getClass().getName(), "run", "AttachmentSender Start - " + this.getName());
            AttachmentOutObject attachmentOutObject = null;
            try {
                while (true) {
                    AttachmentSenderThread dbException2;
                    try {
                        attachmentOutObject = AttachmentOutbox.getInstance().getNext();
                        this.sleepTimeInSeconds = 30000;
                    }
                    catch (DBException dbException2) {
                        Logger.log(8, this.getClass().getName(), "run", "DBException caught while getting next outobject from database, " + dbException2.getMessage());
                    }
                    if (AttachmentSender.this.stop || attachmentOutObject == null) {
                        if (AttachmentSender.this.stop) {
                            Logger.log(9, "Class: " + this.getClass().getName(), "Method: run", "Message: Attachment Sender STOPPED - " + this.getName());
                        } else {
                            Logger.log(9, "Class: " + this.getClass().getName(), "Method: run", "Message: Attachment Sender STOPPED as no attachment out objects " + this.getName());
                        }
                        AttachmentSender.this.attachmentSenderThread = null;
                        return;
                    }
                    while (block) {
                        dbException2 = AttachmentSender.this.attachmentSenderThread;
                        synchronized (dbException2) {
                            try {
                                AttachmentSender.this.attachmentSenderThread.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                Logger.log(8, this.getClass().getName(), "run", "InterruptedException caught while going to sleep because attachmentsender block request is received, " + interruptedException.getMessage());
                                break;
                            }
                        }
                    }
                    if (attachmentOutObject == null) continue;
                    if (!NetworkUtil.hasCoverage(true)) {
                        dbException2 = AttachmentSender.this.attachmentSenderThread;
                        synchronized (dbException2) {
                            try {
                                NetworkStateListener networkStateListener = new NetworkStateListener(AttachmentSender.this.attachmentConnectionType);
                                AttachmentSender.this.networkChangeReceiver.addNetworkStateListener(networkStateListener);
                                NetworkStateListener networkStateListener2 = networkStateListener;
                                synchronized (networkStateListener2) {
                                    networkStateListener.wait();
                                }
                                AttachmentSender.this.networkChangeReceiver.removeNetworkStateListener(networkStateListener);
                            }
                            catch (InterruptedException interruptedException) {
                                Logger.log(8, this.getClass().getName(), "run", "InterruptedException caught while going to wait condition because no connectivity is there, " + interruptedException.getMessage());
                                break;
                            }
                            if (!NetworkUtil.hasCoverage(true)) {
                                continue;
                            }
                        }
                    }
                    this.submitRequest(attachmentOutObject);
                }
            }
            catch (ApplicationException e) {
                Logger.log(8, this.getClass().getName(), "run", "ApplicationException caught while processing server request: " + e.getMessage());
                this.deleteAttachmentOutObjectAndCreateInfoMessage(attachmentOutObject, "Application exception. Cannot send object to server: " + e.getMessage());
                return;
            }
            catch (DBException e) {
                Logger.log(8, this.getClass().getName(), "run", "DBException caught while processing server request: " + e.getMessage());
                this.deleteAttachmentOutObjectAndCreateInfoMessage(attachmentOutObject, "Database exception. Cannot send object to server: " + e.getMessage());
                return;
            }
            catch (Exception e) {
                Logger.log(8, this.getClass().getName(), "run", "Exception caught while processing server request: " + e.getMessage());
                this.deleteAttachmentOutObjectAndCreateInfoMessage(attachmentOutObject, "Exception. Cannot send object to server: " + e.getMessage());
                return;
            }
        }

        private void deleteAttachmentOutObjectAndCreateInfoMessage(AttachmentOutObject attachmentOutObject, String message) {
            this.deleteOutObject(attachmentOutObject);
            this.deleteAttachmentOutObject(attachmentOutObject);
            final InfoMessage infoMessage = new InfoMessage();
            infoMessage.setBeLid(attachmentOutObject.getBEHeaderLid());
            infoMessage.setBeName(attachmentOutObject.getBEName());
            infoMessage.setCategory("FAILURE");
            infoMessage.setMessage("Function:" + attachmentOutObject.getFunctionName() + ". Message:" + message);
            try {
                FrameworkManager.getInstance().getDataManager().insert(infoMessage);
                ApplicationManager applicationManager = ApplicationManager.getInstance();
                IDataManager applicationDataManager = ApplicationManager.getInstance().getDataManager();
                StructureMeta structureMeta = applicationManager.getHeaderStructureMeta(attachmentOutObject.getBEName());
                String structureName = structureMeta.getStructName();
                String whereClause = "LID='" + attachmentOutObject.getBEHeaderLid() + "'";
                IDataStructure[] iDataStructure = applicationDataManager.get(structureName, whereClause);
                if (iDataStructure != null && iDataStructure.length > 0) {
                    IDataStructure be = iDataStructure[0];
                    be.setSyncStatus(IDataStructure.SYNC_STATUS.ERROR);
                    applicationDataManager.update(be);
                    String[] childrenTableNames = be.getChildrenTableNames();
                    if (childrenTableNames != null && childrenTableNames.length > 0) {
                        for (int i = 0; i < childrenTableNames.length; ++i) {
                            IDataStructure[] items = applicationDataManager.getChildren(childrenTableNames[i], be);
                            if (items == null || items.length <= 0) continue;
                            for (int j = 0; j < items.length; ++j) {
                                items[j].setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                                applicationDataManager.update(items[j]);
                            }
                        }
                    }
                }
                if (AttachmentSender.this.notificationListener == null) {
                    AttachmentSender.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                }
                Logger.d("Outbox item Discarded");
                if (AttachmentSender.this.notificationListener != null) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            AttachmentSender.this.notificationListener.notifyOutBoxItemDiscarded(infoMessage);
                        }
                    });
                    t.start();
                }
            }
            catch (DBException e) {
                Logger.log(8, this.getClass().getName(), "deleteOutObjectAndCreateInfoMessage", "DBException caught while inserting Info Message: " + e.getMessage());
            }
        }

        private void createInfoMessage(AttachmentOutObject attachmentOutObject, AttachmentResponse attachmentResponse) {
            InfoMessage infoMessage = new InfoMessage();
            infoMessage.setBeLid(attachmentOutObject.getBEHeaderLid());
            infoMessage.setBeName(attachmentOutObject.getBEName());
            infoMessage.setCategory("FAILURE");
            infoMessage.setMessage("Function:" + attachmentOutObject.getFunctionName() + ". Response Code: " + attachmentResponse.getResponseCode() + ". Message:" + attachmentResponse.getErrorMessage());
            try {
                FrameworkManager.getInstance().getDataManager().insert(infoMessage);
            }
            catch (DBException e) {
                Logger.log(8, this.getClass().getName(), "createInfoMessage", "DBException caught while inserting Info Message: " + e.getMessage());
            }
        }

        private boolean deleteOutObject(AttachmentOutObject attachmentOutObject) {
            if (attachmentOutObject != null) {
                try {
                    String function = " Function:" + attachmentOutObject.getFunctionName();
                    String beName = " BE: " + attachmentOutObject.getBEName();
                    String beLid = " BE LID: " + attachmentOutObject.getBEHeaderLid();
                    String message = "Deleting out object." + function + beName + beLid;
                    String whereClause = AttachmentOutObject.BE_HEADER_LID + " = '" + attachmentOutObject.getBEHeaderLid() + "'";
                    IDataStructure[] outObjects = AttachmentSender.this.frameworkDataManager.get(OutObject.TABLE_NAME, whereClause, OutObject.class);
                    if (outObjects != null && outObjects.length > 0) {
                        Outbox.getInstance().remove((OutObject)outObjects[0]);
                    }
                    Logger.log(9, this.getClass().getName(), "deleteOutObject", message);
                }
                catch (DBException e) {
                    Logger.log(8, this.getClass().getName(), "deleteOutObject", "DBException caught while deleting outobject: " + e.getMessage());
                    return false;
                }
            }
            return true;
        }

        private boolean deleteAttachmentOutObject(AttachmentOutObject attachmentOutObject) {
            if (attachmentOutObject != null) {
                try {
                    String function = " Function:" + attachmentOutObject.getFunctionName();
                    String beName = " BE: " + attachmentOutObject.getBEName();
                    String beLid = " BE LID: " + attachmentOutObject.getBEHeaderLid();
                    String message = "Deleting attachment out object." + function + beName + beLid;
                    Logger.log(9, this.getClass().getName(), "deleteAttachmentOutObject", message);
                    AttachmentOutbox.getInstance().remove(attachmentOutObject);
                }
                catch (DBException e) {
                    Logger.log(8, this.getClass().getName(), "deleteAttachmentOutObject", "DBException caught while deleting attachment outobject: " + e.getMessage());
                    return false;
                }
            }
            return true;
        }

        private synchronized void submitRequest(AttachmentOutObject attachmentOutObject) throws ApplicationException, DBException {
            if (attachmentOutObject.getAttachmentOutObjectStatus() == AttachmentOutObject.ATTACHMENT_OUT_OBJECT_STATUS.LOCKED_FOR_SENDING) {
                throw new ApplicationException(this.getClass().getName(), "submitRequest", "Cannot modify or re-submit again. Attachment OutObject is locked for sending");
            }
            attachmentOutObject.setAttachmentOutObjectStatus(AttachmentOutObject.ATTACHMENT_OUT_OBJECT_STATUS.LOCKED_FOR_SENDING);
            if (AttachmentSender.this.frameworkDataManager == null) {
                AttachmentSender.this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
            }
            AttachmentSender.this.frameworkDataManager.update(attachmentOutObject);
            AttachmentResponse attachmentResponse = AttachmentSender.this.checkAndUploadAttachments(attachmentOutObject);
            if (Strings.isNullOrEmpty((String)attachmentResponse.getGUID())) {
                String errMessage = attachmentResponse.getErrorMessage();
                this.deleteAttachmentOutObjectAndCreateInfoMessage(attachmentOutObject, errMessage);
                if (AttachmentSender.this.notificationListener == null) {
                    AttachmentSender.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                }
                Logger.d("Attachment Send Abort");
                if (AttachmentSender.this.notificationListener != null) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            AttachmentSender.this.notificationListener.notifyAttachmentSendAbort();
                        }
                    });
                    t.start();
                }
                return;
            }
            int responseCode = attachmentResponse.getResponseCode();
            switch (responseCode) {
                case 200: {
                    this.deleteAttachmentOutObject(attachmentOutObject);
                    if (DataSender.getInstance().isAlive()) break;
                    DataSender.getInstance().start();
                    break;
                }
                case 0: {
                    this.handleZeroResponse(attachmentResponse);
                    return;
                }
                default: {
                    this.createInfoMessage(attachmentOutObject, attachmentResponse);
                    Logger.log(7, FrameworkHelper.class.getName(), "submitRequest", "Stopping AttachmentSender");
                    AttachmentSender.getInstance().stop();
                    Logger.log(7, FrameworkHelper.class.getName(), "submitRequest", "Stopped AttachmentSender");
                    if (AttachmentSender.this.notificationListener == null) {
                        AttachmentSender.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                    }
                    Logger.d("Attachment Send Abort");
                    if (AttachmentSender.this.notificationListener == null) break;
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            AttachmentSender.this.notificationListener.notifyAttachmentSendAbort();
                        }
                    });
                    t.start();
                }
            }
        }

        private void handleZeroResponse(AttachmentResponse attachmentResponse) {
            int responseCode = attachmentResponse.getResponseCode();
            String errorMessage = attachmentResponse.getErrorMessage();
            Logger.log(8, this.getClass().getName(), "submitRequest", "HTTP response error. Response code: " + responseCode + " Response message: " + errorMessage);
            try {
                Thread.sleep(this.sleepTimeInSeconds);
                if (this.sleepTimeInSeconds < 300000) {
                    this.sleepTimeInSeconds *= 2;
                }
            }
            catch (InterruptedException e) {
                Logger.log(8, this.getClass().getName(), "submitRequest", "Data sender interrupted. Exception: " + e.getMessage());
                return;
            }
        }
    }
}

