/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.out;

import android.content.Context;
import android.widget.Toast;
import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.message.UNVDataHelper;
import com.unvired.model.AttachmentItem;
import com.unvired.model.AttachmentOutObject;
import com.unvired.model.InfoMessage;
import com.unvired.model.OutObject;
import com.unvired.model.SentItemObject;
import com.unvired.model.StructureMeta;
import com.unvired.parser.UBXMLParser;
import com.unvired.sync.SyncConstants;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.attachment.Attachment;
import com.unvired.sync.in.DataRetrieverService;
import com.unvired.sync.notifier.NotificationListener;
import com.unvired.sync.notifier.SynchronizationStateListener;
import com.unvired.sync.out.AttachmentOutbox;
import com.unvired.sync.out.AttachmentSender;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.sync.out.Outbox;
import com.unvired.sync.out.SentItems;
import com.unvired.sync.out.ServerErrors;
import com.unvired.sync.response.AttachmentResponse;
import com.unvired.sync.response.HTTPResponse;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.NetworkChangeReceiver;
import com.unvired.utils.NetworkStateListener;
import com.unvired.utils.NetworkUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class DataSender {
    private static DataSender dataSender = null;
    private boolean stop = false;
    private static boolean block = false;
    private static List<String> lockedBeLidList = null;
    private static long dataSentOn = 0L;
    private DataSenderThread dataSenderThread;
    private NotificationListener notificationListener;
    private Context context;
    private static final MessageHelper MESSAGE_HELPER = MessageHelper.getInstance();
    private IDataManager frameworkDataManager = null;
    private InfoMessage infoMessage = null;
    private NetworkChangeReceiver networkChangeReceiver = SyncEngine.getInstance().getNetworkChangeReceiver();
    private int attachmentConnectionType;

    private DataSender() {
        try {
            FrameworkSettingsManager frameworkSettingsManager = FrameworkManager.getInstance().getFrameworkSettingsManager();
            String attachmentConnectionTypeString = frameworkSettingsManager.getAttachmentConnection();
            this.attachmentConnectionType = "WIFI".equalsIgnoreCase(attachmentConnectionTypeString) ? 1 : 0;
        }
        catch (DBException e) {
            Logger.log(8, AttachmentSender.class.getName(), "AttachmentSender", "DBException:" + e.getMessage());
        }
    }

    public static DataSender getInstance() {
        if (dataSender == null) {
            dataSender = new DataSender();
        }
        return dataSender;
    }

    public void start() {
        if (this.dataSenderThread == null || !this.dataSenderThread.isAlive()) {
            this.stop = false;
            this.dataSenderThread = new DataSenderThread();
            this.dataSenderThread.setPriority(1);
            this.dataSenderThread.start();
        } else if (this.dataSenderThread.isAlive()) {
            Logger.log(7, this.getClass().getName(), "start", "DataSenderThread is alive");
        }
    }

    public OUTBOX_LOCK_RESULT lockDataSender(String beLid) {
        if (this.dataSenderThread != null && this.dataSenderThread.isBeingSent(beLid)) {
            return OUTBOX_LOCK_RESULT.DATA_BEING_SENT;
        }
        if (lockedBeLidList == null) {
            lockedBeLidList = new ArrayList<String>();
        }
        lockedBeLidList.add(beLid);
        Logger.i("Lock has been applied on BE : " + beLid);
        return OUTBOX_LOCK_RESULT.LOCK_APPLIED;
    }

    public void unlockDataSender() {
        lockedBeLidList = null;
        Logger.i("Lock removed on all BEs");
        this.start();
    }

    public void block() {
        block = true;
        if (Logger.getDefaultLogLevel() == 9) {
            Logger.d("Data Sender BLOCKED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock() {
        block = false;
        if (this.dataSenderThread != null) {
            DataSenderThread dataSenderThread = this.dataSenderThread;
            synchronized (dataSenderThread) {
                if (this.dataSenderThread == null) {
                    return;
                }
                try {
                    this.dataSenderThread.notify();
                }
                catch (IllegalMonitorStateException e) {
                    Logger.e("IllegalMonitorStateException caught while notify on DataSender to unblock.", e);
                }
            }
        }
        if (Logger.getDefaultLogLevel() == 9) {
            Logger.log(9, DataSender.class.getName(), "unblock", "Data Sender UN-BLOCKED");
        }
    }

    public boolean isBlocked() {
        return block;
    }

    public boolean isAlive() {
        return this.dataSenderThread != null && this.dataSenderThread.isAlive();
    }

    public void stop() {
        try {
            this.stop = true;
            if (NetworkUtil.isEmulator()) {
                Logger.log(7, this.getClass().getName(), "stop", "Data Sender STOP instruction");
            }
            if (this.dataSenderThread == null) {
                return;
            }
            this.dataSenderThread.interrupt();
        }
        catch (IllegalArgumentException e) {
            Logger.e("Data Sender IllegalArgumentException: ", e);
        }
        catch (Throwable e) {
            Logger.log(8, this.getClass().getName(), "stop", "Data Sender Exception: " + e.getMessage());
        }
        finally {
            this.dataSenderThread = null;
            dataSender = null;
        }
    }

    public static long getDataSentTime() {
        return dataSentOn;
    }

    class DataSenderThread
    extends Thread {
        private final int SLEEP_TIME_START_IN_SECONDS = 30000;
        private final int SLEEP_TIME_MAX_IN_SECONDS = 300000;
        private int sleepTimeInSeconds = 30000;
        private OutObject outObject = null;

        DataSenderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logger.log(7, this.getClass().getName(), "run", "DataSender Start - " + this.getName());
            try {
                while (true) {
                    block52: {
                        DataSenderThread e22;
                        SynchronizationStateListener synchronizationStateListener;
                        try {
                            this.outObject = Outbox.getInstance().getNext();
                        }
                        catch (DBException dbException) {
                            Logger.e("DBException caught while getting next outobject from database, ", dbException);
                            break;
                        }
                        if (DataSender.this.stop || this.outObject == null) {
                            if (DataSender.this.stop) {
                                if (Logger.getDefaultLogLevel() == 9) {
                                    Logger.log(9, "Class: " + this.getClass().getName(), "Method: run", "Message: Data Sender STOPPED - " + this.getName());
                                }
                            } else {
                                if (Logger.getDefaultLogLevel() == 9) {
                                    Logger.log(9, "Class: " + this.getClass().getName(), "Method: run", "Message: Data Sender STOPPED as no out objects " + this.getName());
                                }
                                if ((synchronizationStateListener = SyncEngine.getInstance().getSynchronizationStateListener()) != null) {
                                    synchronizationStateListener.idle();
                                }
                            }
                            DataSender.this.dataSenderThread = null;
                            Logger.i("Data Sender: No Out Objects to process. Starting Data Retriever.");
                            DataRetrieverService.getInstance().getMessagesInBackground();
                            return;
                        }
                        if (lockedBeLidList != null && lockedBeLidList.contains(this.outObject.getBELid())) {
                            Logger.i("Data Sender: Locked on request. BELid : " + this.outObject.getBELid());
                            DataSender.this.dataSenderThread = null;
                            return;
                        }
                        try {
                            Logger.i("Checking for Out object validity");
                            if (!Strings.isNullOrEmpty((String)this.outObject.getBEName()) && !"ADMIN_SERVICES".equals(this.outObject.getFunctionName()) && (SyncConstants.MESSAGE_REQUEST_TYPE.REQ.toString().equals(this.outObject.getRequestType()) || SyncConstants.MESSAGE_REQUEST_TYPE.RQST.toString().equals(this.outObject.getRequestType()))) {
                                IDataStructure[] structureMetas = FrameworkManager.getInstance().getDataManager().get(StructureMeta.TABLE_NAME, StructureMeta.BE_NAME + "='" + this.outObject.getBEName() + "' AND " + StructureMeta.IS_HEADER + "='true'", StructureMeta.class);
                                if (structureMetas == null || structureMetas.length <= 0) {
                                    Logger.i("No Header StructureMeta found for BE LID: " + this.outObject.getBELid() + ", BE Name: " + this.outObject.getBEName());
                                    return;
                                }
                                StructureMeta sm = (StructureMeta)structureMetas[0];
                                IDataStructure[] iDataStructureArray = ApplicationManager.getInstance().getDataManager().get(sm.getStructName(), "LID='" + this.outObject.getBELid() + "'");
                                if (iDataStructureArray == null || iDataStructureArray.length <= 0) {
                                    Logger.i("Header not found. BE LID: " + this.outObject.getBELid() + ", BE Name: " + this.outObject.getBEName() + ". Deleting Out Object and attachment out object");
                                    Outbox.getInstance().remove(this.outObject.getBELid());
                                    AttachmentOutbox.getInstance().removeBELid(this.outObject.getBELid());
                                    this.outObject = null;
                                    continue;
                                }
                            }
                        }
                        catch (Exception e22) {
                            Logger.e("Exception while clearing invalid Out object and Attachment objects");
                        }
                        while (block) {
                            e22 = DataSender.this.dataSenderThread;
                            synchronized (e22) {
                                try {
                                    DataSender.this.dataSenderThread.wait(30000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    Logger.e("InterruptedException caught while going to sleep because datasender block request is received, ", interruptedException);
                                    break;
                                }
                            }
                        }
                        if (this.outObject != null && !NetworkUtil.hasCoverage()) {
                            e22 = DataSender.this.dataSenderThread;
                            synchronized (e22) {
                                try {
                                    NetworkStateListener networkStateListener = new NetworkStateListener(0);
                                    DataSender.this.networkChangeReceiver.addNetworkStateListener(networkStateListener);
                                    NetworkStateListener networkStateListener2 = networkStateListener;
                                    synchronized (networkStateListener2) {
                                        networkStateListener.wait();
                                    }
                                    DataSender.this.networkChangeReceiver.removeNetworkStateListener(networkStateListener);
                                }
                                catch (InterruptedException interruptedException) {
                                    Logger.log(8, this.getClass().getName(), "run", "InterruptedException caught while going to wait condition because no connectivity is there, " + interruptedException.getMessage());
                                    break;
                                }
                                if (!NetworkUtil.hasCoverage()) {
                                    continue;
                                }
                            }
                        }
                        if ((synchronizationStateListener = SyncEngine.getInstance().getSynchronizationStateListener()) != null) {
                            synchronizationStateListener.sending(Outbox.getInstance().count());
                        }
                        try {
                            AttachmentOutObject[] attachmentOutObjects = AttachmentOutbox.getInstance().getAttachmentOutObjects(this.outObject.getBELid());
                            if (attachmentOutObjects == null || attachmentOutObjects.length <= 0) break block52;
                            for (AttachmentOutObject attachmentOutObject : attachmentOutObjects) {
                                this.sleepTimeInSeconds = 30000;
                                if (DataSender.this.stop) {
                                    if (Logger.getDefaultLogLevel() == 9) {
                                        Logger.d("Message: Data Sender STOPPED while sending attachment- " + this.getName());
                                    }
                                    DataSender.this.dataSenderThread = null;
                                    return;
                                }
                                if (attachmentOutObject == null) continue;
                                while (block) {
                                    DataSenderThread dataSenderThread = DataSender.this.dataSenderThread;
                                    synchronized (dataSenderThread) {
                                        try {
                                            DataSender.this.dataSenderThread.wait(30000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            Logger.log(8, this.getClass().getName(), "run", "InterruptedException caught while going to sleep because attachmentsender block request is received, " + interruptedException.getMessage());
                                            break;
                                        }
                                    }
                                }
                                this.submitRequest(attachmentOutObject);
                            }
                        }
                        catch (Exception exception) {
                            Logger.e("Exception caught while uploading attachments, " + exception.getMessage());
                            break;
                        }
                    }
                    if (DataSender.this.stop) {
                        if (Logger.getDefaultLogLevel() == 9) {
                            Logger.d("Message: Data Sender STOPPED while sending Header- " + this.getName());
                        }
                        DataSender.this.dataSenderThread = null;
                        DataRetrieverService.getInstance().getMessagesInBackground();
                        return;
                    }
                    if (!Outbox.getInstance().checkForPendingAttachments(this.outObject)) {
                        if (ApplicationManager.getInstance().isAttachmentSupported(this.outObject.getBEName())) {
                            this.storeMessageDataToFile(this.outObject);
                        }
                        this.submitRequest(this.outObject);
                    }
                    this.outObject = null;
                }
            }
            catch (ApplicationException e) {
                Logger.e("ApplicationException caught while processing server request: ", e);
                this.deleteOutObjectAndCreateInfoMessage(this.outObject, "Application exception. Cannot send object to server: " + e.getMessage());
                return;
            }
            catch (DBException e) {
                Logger.e("DBException caught while processing server request: ", e);
                this.deleteOutObjectAndCreateInfoMessage(this.outObject, "Database exception. Cannot send object to server: " + e.getMessage());
                return;
            }
            catch (Exception e) {
                Logger.e("Exception caught while processing server request: ", e);
                this.deleteOutObjectAndCreateInfoMessage(this.outObject, "Exception. Cannot send object to server: " + e.getMessage());
                return;
            }
        }

        private boolean isBeingSent(String beLid) {
            return this.outObject != null && !Strings.isNullOrEmpty((String)beLid) && beLid.equals(this.outObject.getBELid());
        }

        private void deleteOutObjectAndCreateInfoMessage(OutObject outObject, String message) {
            if (outObject != null) {
                this.deleteOutObject(outObject);
                final InfoMessage infoMessage = new InfoMessage();
                infoMessage.setBeLid(outObject.getBELid());
                infoMessage.setBeName(outObject.getBEName());
                infoMessage.setCategory("FAILURE");
                infoMessage.setType(String.valueOf(outObject.getMessageType()));
                infoMessage.setSubType(String.valueOf(outObject.getMessageSubType()));
                infoMessage.setMessage("Function:" + outObject.getFunctionName() + ". Message:" + message);
                try {
                    FrameworkManager.getInstance().getDataManager().insert(infoMessage);
                    ApplicationManager applicationManager = ApplicationManager.getInstance();
                    if (outObject.getBELid() != null && outObject.getMessageSubType() == 600) {
                        StructureMeta structureMeta = applicationManager.getHeaderStructureMeta(outObject.getBEName());
                        String structureName = structureMeta.getStructName();
                        String whereClause = "LID='" + outObject.getBELid() + "'";
                        IDataManager appDataManager = ApplicationManager.getInstance().getDataManager();
                        IDataStructure[] iDataStructure = appDataManager.get(structureName, whereClause);
                        if (iDataStructure != null && iDataStructure.length > 0) {
                            IDataStructure be = iDataStructure[0];
                            be.setSyncStatus(IDataStructure.SYNC_STATUS.ERROR);
                            appDataManager.update(be);
                            String[] childrenTableNames = be.getChildrenTableNames();
                            if (childrenTableNames != null && childrenTableNames.length > 0) {
                                for (int i = 0; i < childrenTableNames.length; ++i) {
                                    IDataStructure[] items = appDataManager.getChildren(childrenTableNames[i], be);
                                    if (items == null || items.length <= 0) continue;
                                    for (int j = 0; j < items.length; ++j) {
                                        if (items[j].getObjectStatus() == IDataStructure.OBJECT_STATUS.GLOBAL) continue;
                                        items[j].setSyncStatus(IDataStructure.SYNC_STATUS.ERROR);
                                        appDataManager.update(items[j]);
                                    }
                                }
                            }
                        }
                    }
                    if (DataSender.this.notificationListener == null) {
                        DataSender.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                    }
                    if (Logger.getDefaultLogLevel() == 9) {
                        Logger.d("Outbox item Discarded");
                    }
                    if (DataSender.this.notificationListener != null) {
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                DataSender.this.notificationListener.notifyOutBoxItemDiscarded(infoMessage);
                            }
                        });
                        t.start();
                    }
                }
                catch (DBException e) {
                    Logger.e("DBException caught while inserting Info Message: ", e);
                }
            }
        }

        private void updateOutObjectBEWithGlobalStatus(OutObject outObject) {
            try {
                ApplicationManager applicationManager = ApplicationManager.getInstance();
                StructureMeta structureMeta = applicationManager.getHeaderStructureMeta(outObject.getBEName());
                String structureName = structureMeta.getStructName();
                String whereClause = "LID='" + outObject.getBELid() + "'";
                IDataManager appDataManager = ApplicationManager.getInstance().getDataManager();
                IDataStructure[] iDataStructure = appDataManager.get(structureName, whereClause);
                if (iDataStructure != null && iDataStructure.length > 0) {
                    IDataStructure be = iDataStructure[0];
                    be.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                    appDataManager.update(be);
                    String[] childrenTableNames = be.getChildrenTableNames();
                    if (childrenTableNames != null && childrenTableNames.length > 0) {
                        for (int i = 0; i < childrenTableNames.length; ++i) {
                            IDataStructure[] items = appDataManager.getChildren(childrenTableNames[i], be);
                            if (items == null || items.length <= 0) continue;
                            for (int j = 0; j < items.length; ++j) {
                                if (items[j].getObjectStatus() == IDataStructure.OBJECT_STATUS.GLOBAL) continue;
                                items[j].setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                                appDataManager.update(items[j]);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.e("Error while update sync status to none for REQ request.", e);
            }
        }

        private InfoMessage createInfoMessage(OutObject outObject, String message) {
            InfoMessage infoMessage = new InfoMessage();
            infoMessage.setBeLid(outObject.getBELid());
            infoMessage.setBeName(outObject.getBEName());
            infoMessage.setCategory("FAILURE");
            infoMessage.setType(String.valueOf(outObject.getMessageType()));
            infoMessage.setSubType(String.valueOf(outObject.getMessageSubType()));
            infoMessage.setMessage("Function:" + outObject.getFunctionName() + ". Message:" + message);
            try {
                FrameworkManager.getInstance().getDataManager().insert(infoMessage);
            }
            catch (DBException e) {
                Logger.e("DBException caught while inserting Info Message: ", e);
            }
            return infoMessage;
        }

        private void storeMessageDataToFile(OutObject outObject) throws DBException {
            IDataStructure[] dataStructures = null;
            try {
                ApplicationManager applicationManager = ApplicationManager.getInstance();
                IDataManager dataManager = ApplicationManager.getInstance().getDataManager();
                StructureMeta structureMeta = applicationManager.getHeaderStructureMeta(outObject.getBEName());
                String structureName = structureMeta.getStructName();
                String whereClause = "LID='" + outObject.getBELid() + "'";
                dataStructures = dataManager.get(structureName, whereClause);
            }
            catch (DBException dbe) {
                Logger.e("DBException caught while getting business entity from database, BE-NAME: " + outObject.getBEName() + ", BE-LID: " + outObject.getBELid() + ", ", dbe);
                return;
            }
            if (dataStructures == null) {
                Logger.log(8, this.getClass().getName(), "storeMessageDataToFile", "Cannot get data structure to sent data. BE-NAME: " + outObject.getBEName() + ", BE-LID: " + outObject.getBELid());
                return;
            }
            String dataFormat = FrameworkSettingsManager.getInstance().getDataFormat();
            String beDataString = "";
            beDataString = "XML".equalsIgnoreCase(dataFormat) ? UNVDataHelper.generateMessageIBXML(dataStructures[0], UNVDataHelper.DATA_TYPE.QUEUED) : UNVDataHelper.generateMessageIBJSON(dataStructures[0], UNVDataHelper.DATA_TYPE.QUEUED);
            outObject.setMessageXml(beDataString.getBytes());
        }

        private boolean deleteOutObject(OutObject outObject) {
            if (outObject != null) {
                try {
                    String function = " Function:" + outObject.getFunctionName();
                    String beName = " BE: " + outObject.getBEName();
                    String beLid = " BE LID: " + outObject.getBELid();
                    String message = "Deleting out object." + function + beName + beLid;
                    if (Logger.getDefaultLogLevel() == 9) {
                        Logger.log(9, this.getClass().getName(), "deleteOutObject", message);
                    }
                    Outbox.getInstance().remove(outObject);
                }
                catch (DBException e) {
                    Logger.e("DBException caught while deleting outobject: ", e);
                    return false;
                }
            }
            return true;
        }

        private synchronized void submitRequest(OutObject outObject) throws ApplicationException, DBException {
            Logger.i("DataSender submitRequest OutObject: " + outObject.getLid() + " BE Name-BE Lid: " + outObject.getBEName() + "-" + outObject.getBELid());
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "submitRequest", "OutObject to send: " + outObject.getMessageXml());
            }
            if (outObject.getOutObjectStatus() == OutObject.OUT_OBJECT_STATUS.LOCKED_FOR_SENDING) {
                throw new ApplicationException(this.getClass().getName(), "submitRequest", "Cannot modify or re-submit again. OutObject is locked for sending");
            }
            outObject.setOutObjectStatus(OutObject.OUT_OBJECT_STATUS.LOCKED_FOR_SENDING);
            if (DataSender.this.frameworkDataManager == null) {
                DataSender.this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
            }
            DataSender.this.frameworkDataManager.update(outObject);
            HTTPResponse httpResponse = HTTPConnection.post(outObject);
            int responseCode = httpResponse.getResponseCode();
            Logger.i("DataSender submitRequest: " + responseCode);
            outObject.setOutObjectStatus(OutObject.OUT_OBJECT_STATUS.NONE);
            DataSender.this.frameworkDataManager.update(outObject);
            switch (responseCode) {
                case 200: {
                    this.sleepTimeInSeconds = 30000;
                    boolean serverHasReturnedError = this.checkForServerReturnedErrorsInHeaderParameters(httpResponse, outObject);
                    if (serverHasReturnedError) {
                        return;
                    }
                    this.handleSuccess(httpResponse, outObject);
                    break;
                }
                case 0: {
                    this.handleZeroResponse(httpResponse, outObject);
                    break;
                }
                case 526: {
                    Toast.makeText((Context)FrameworkHelper.getApplicationContext(), (CharSequence)MessageHelper.getInstance().getValue(MessageHelper.getInstance().SERVER_CERTIFICATE_UPDATED), (int)1).show();
                    this.handleServerError(httpResponse, outObject);
                    break;
                }
                default: {
                    this.handleServerError(httpResponse, outObject);
                }
            }
        }

        private boolean checkForServerReturnedErrorsInHeaderParameters(HTTPResponse httpResponse, OutObject outObject) {
            int errorCodeInt;
            Hashtable<String, String> serverHTTPFields = httpResponse.getServerFields();
            if (serverHTTPFields == null) {
                return false;
            }
            String errorCode = serverHTTPFields.get("X_UNVIRED_SYSTEM_ERROR");
            if (Strings.isNullOrEmpty((String)errorCode)) {
                return false;
            }
            DataSender.getInstance().stop();
            try {
                errorCodeInt = Integer.parseInt(errorCode);
            }
            catch (NumberFormatException e1) {
                Logger.log(8, ServerErrors.class.getName(), "checkForServerReturnedErrorsInHeaderParameters", "UNI Server Code not in number format. Code: " + errorCode);
                return false;
            }
            String message = null;
            switch (errorCodeInt) {
                case 8: {
                    Logger.log(8, ServerErrors.class.getName(), "checkForServerReturnedErrorsInHeaderParameters", "Empty sync id. Deleting outbox entry. " + errorCode);
                    message = MESSAGE_HELPER.getValue(MESSAGE_HELPER.UNI_ERROR_EMPTY_CLIENT_MSG_ID);
                    message = message + "Deleting outbox entry as there is no sync id for this message. This message cannot be processed. Contact your administrator";
                    this.deleteOutObjectAndCreateInfoMessage(outObject, message);
                    break;
                }
                case 9: {
                    String conversationId = httpResponse.getServerFields().get("CONVID");
                    Logger.log(8, ServerErrors.class.getName(), "checkForServerReturnedErrorsInHeaderParameters", "Duplicate sync id. Deleting outbox entry. " + errorCode + " Conversation Id: " + conversationId);
                    message = MESSAGE_HELPER.getValue(MESSAGE_HELPER.UNI_ERROR_DUPLICATE_CLIENT_MSG_ID);
                    message = message + "Deleting outbox entry as this is a duplicate conversation id. This message cannot be processed. Conversation id: " + conversationId + ". Contact your administrator";
                    this.deleteOutObjectAndCreateInfoMessage(outObject, message);
                    break;
                }
            }
            return true;
        }

        private void handleSuccess(HTTPResponse httpResponse, final OutObject outObject) {
            if (SyncConstants.SYNC_MODE.ASYNC.toString().equalsIgnoreCase(outObject.getSyncType())) {
                Hashtable<String, String> serverHTTPFields = httpResponse.getServerFields();
                String conversationId = serverHTTPFields.get("X-UNVIRED-CONVERSATION-ID");
                if (Strings.isNullOrEmpty((String)conversationId)) {
                    Logger.log(8, this.getClass().getName(), "submitRequest", "Conversation Id empty in http header fields");
                    this.deleteOutObjectAndCreateInfoMessage(outObject, "Conversation id not available in response. Deleting out object.");
                    return;
                }
                this.deleteOutObject(outObject);
                String requestTypeString = outObject.getRequestType();
                SyncConstants.MESSAGE_REQUEST_TYPE requestType = SyncConstants.MESSAGE_REQUEST_TYPE.valueOf(requestTypeString);
                if (SyncConstants.MESSAGE_REQUEST_TYPE.RQST == requestType) {
                    try {
                        SentItemObject sentItemObject = new SentItemObject();
                        sentItemObject.setConversationId(conversationId);
                        sentItemObject.setBeName(outObject.getBEName());
                        sentItemObject.setBeHeaderLid(outObject.getBELid());
                        if (ApplicationManager.getInstance().isAttachmentSupported(outObject.getBEName())) {
                            sentItemObject.setAttachmentFlag("X");
                        }
                        SentItems.getInstance().add(sentItemObject);
                    }
                    catch (Exception e) {
                        Logger.log(8, this.getClass().getName(), "submitRequest", "Exception caught while adding sent item object to database. Deleting out object. OutObject LID: " + outObject.getLid() + ", " + e.getMessage());
                        this.deleteOutObjectAndCreateInfoMessage(outObject, "Exception caught while adding sent item object to database. Deleting out object.");
                        return;
                    }
                } else if (SyncConstants.MESSAGE_REQUEST_TYPE.REQ == requestType) {
                    this.updateOutObjectBEWithGlobalStatus(outObject);
                }
            } else {
                if (9000 == outObject.getMessageType() && 610 == outObject.getMessageSubType()) {
                    try {
                        FrameworkManager.getInstance().getFrameworkSettingsManager().setPushToken(String.valueOf(outObject.getField(OutObject.COMPANY_NAMESPACE)));
                    }
                    catch (Exception e) {
                        Logger.e(e.getMessage());
                    }
                }
                this.deleteOutObject(outObject);
            }
            int messageType = outObject.getMessageType();
            if (messageType == 8000) {
                if (DataSender.this.notificationListener == null) {
                    DataSender.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                }
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.d("Data Send");
                }
                if (DataSender.this.notificationListener != null) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DataSender.this.notificationListener.notifyDataSend(outObject);
                        }
                    });
                    t.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleServerError(HTTPResponse httpResponse, OutObject outObject) {
            Logger.log(8, this.getClass().getName(), "handleServerError", "Server error. Stopping all threads and notifying application. Response code: " + httpResponse.getResponseCode());
            byte[] responseBytes = httpResponse.getResponseBytes();
            if (responseBytes != null && responseBytes.length > 0) {
                block14: {
                    try {
                        Logger.log(7, FrameworkHelper.class.getName(), "handleServerError", "Stopping DataSender");
                        DataSender.getInstance().stop();
                        Logger.log(7, FrameworkHelper.class.getName(), "handleServerError", "Stopped DataSender");
                        UBXMLParser ibxmlParser = new UBXMLParser(responseBytes, null);
                        Vector<InfoMessage> infoMessages = ibxmlParser.getInfoMessages();
                        if (infoMessages == null || infoMessages.size() <= 0) break block14;
                        DataSender.this.infoMessage = infoMessages.elementAt(0);
                        FrameworkManager.getInstance().getDataManager().insert(DataSender.this.infoMessage);
                    }
                    catch (Exception e) {
                        try {
                            Logger.e("Exception while processing server error. Response code: " + httpResponse.getResponseCode(), e);
                        }
                        catch (Throwable throwable) {
                            DataSender.this.stop = true;
                            String responseErrorMsg = DataSender.this.infoMessage != null && !Strings.isNullOrEmpty((String)DataSender.this.infoMessage.getMessage()) ? DataSender.this.infoMessage.getMessage() : MESSAGE_HELPER.getValue(MESSAGE_HELPER.UNI_RESPONSE_ERROR_500_503);
                            this.createInfoMessage(outObject, responseErrorMsg);
                            if (DataSender.this.notificationListener == null) {
                                DataSender.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                            }
                            if (Logger.getDefaultLogLevel() == 9) {
                                Logger.d("Data Send Abort");
                            }
                            if (DataSender.this.notificationListener != null) {
                                Thread t = new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        DataSender.this.notificationListener.notifyDataSendAbort();
                                    }
                                });
                                t.start();
                            }
                            throw throwable;
                        }
                        DataSender.this.stop = true;
                        String responseErrorMsg = DataSender.this.infoMessage != null && !Strings.isNullOrEmpty((String)DataSender.this.infoMessage.getMessage()) ? DataSender.this.infoMessage.getMessage() : MESSAGE_HELPER.getValue(MESSAGE_HELPER.UNI_RESPONSE_ERROR_500_503);
                        this.createInfoMessage(outObject, responseErrorMsg);
                        if (DataSender.this.notificationListener == null) {
                            DataSender.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                        }
                        if (Logger.getDefaultLogLevel() == 9) {
                            Logger.d("Data Send Abort");
                        }
                        if (DataSender.this.notificationListener != null) {
                            Thread t = new Thread(new /* invalid duplicate definition of identical inner class */);
                            t.start();
                        }
                    }
                }
                DataSender.this.stop = true;
                String responseErrorMsg = DataSender.this.infoMessage != null && !Strings.isNullOrEmpty((String)DataSender.this.infoMessage.getMessage()) ? DataSender.this.infoMessage.getMessage() : MESSAGE_HELPER.getValue(MESSAGE_HELPER.UNI_RESPONSE_ERROR_500_503);
                this.createInfoMessage(outObject, responseErrorMsg);
                if (DataSender.this.notificationListener == null) {
                    DataSender.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                }
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.d("Data Send Abort");
                }
                if (DataSender.this.notificationListener != null) {
                    Thread t = new Thread(new /* invalid duplicate definition of identical inner class */);
                    t.start();
                }
            }
        }

        private void handleZeroResponse(HTTPResponse httpResponse, OutObject outObject) {
            int responseCode = httpResponse.getResponseCode();
            String errorMessage = httpResponse.getErrorMessage();
            Logger.log(8, this.getClass().getName(), "handleZeroResponse", "HTTP response error. Response code: " + responseCode + " Response message: " + errorMessage);
            InfoMessage infoMessage = this.createInfoMessage(outObject, errorMessage);
            final Vector<InfoMessage> infoMessages = new Vector<InfoMessage>();
            infoMessages.add(infoMessage);
            if (DataSender.this.notificationListener == null) {
                DataSender.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
            }
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("Server messages");
            }
            if (DataSender.this.notificationListener != null) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DataSender.this.notificationListener.notifyServerMessages(infoMessages);
                    }
                });
                t.start();
            }
            if (DataSender.this.dataSenderThread != null && !DataSender.this.dataSenderThread.isInterrupted()) {
                if (this.sleepTimeInSeconds < 300000) {
                    this.sleepTimeInSeconds *= 2;
                    Logger.i("DataSender handleZeroResponse sleep: " + this.sleepTimeInSeconds);
                }
                try {
                    Thread.sleep(this.sleepTimeInSeconds);
                }
                catch (InterruptedException e) {
                    Logger.e("Data sender interrupted. Exception: ", e);
                }
            }
        }

        private void deleteAttachmentOutObjectAndCreateInfoMessage(AttachmentOutObject attachmentOutObject, String message) {
            this.deleteOutObject(attachmentOutObject);
            this.deleteAttachmentOutObject(attachmentOutObject);
            final InfoMessage infoMessage = new InfoMessage();
            infoMessage.setBeLid(attachmentOutObject.getBEHeaderLid());
            infoMessage.setBeName(attachmentOutObject.getBEName());
            infoMessage.setCategory("FAILURE");
            infoMessage.setMessage("Function:" + attachmentOutObject.getFunctionName() + ". Message:" + message);
            try {
                FrameworkManager.getInstance().getDataManager().insert(infoMessage);
                ApplicationManager applicationManager = ApplicationManager.getInstance();
                IDataManager applicationDataManager = ApplicationManager.getInstance().getDataManager();
                StructureMeta structureMeta = applicationManager.getHeaderStructureMeta(attachmentOutObject.getBEName());
                String structureName = structureMeta.getStructName();
                String whereClause = "LID='" + attachmentOutObject.getBEHeaderLid() + "'";
                IDataStructure[] iDataStructure = applicationDataManager.get(structureName, whereClause);
                if (iDataStructure != null && iDataStructure.length > 0) {
                    IDataStructure be = iDataStructure[0];
                    be.setSyncStatus(IDataStructure.SYNC_STATUS.ERROR);
                    applicationDataManager.update(be);
                    String[] childrenTableNames = be.getChildrenTableNames();
                    if (childrenTableNames != null && childrenTableNames.length > 0) {
                        for (String childrenTableName : childrenTableNames) {
                            IDataStructure[] items = applicationDataManager.getChildren(childrenTableName, be);
                            if (items == null || items.length <= 0) continue;
                            for (IDataStructure item : items) {
                                item.setSyncStatus(IDataStructure.SYNC_STATUS.NONE);
                                applicationDataManager.update(item);
                            }
                        }
                    }
                }
                if (DataSender.this.notificationListener == null) {
                    DataSender.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                }
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.d("Outbox item discarded");
                }
                if (DataSender.this.notificationListener != null) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DataSender.this.notificationListener.notifyOutBoxItemDiscarded(infoMessage);
                        }
                    });
                    t.start();
                }
            }
            catch (Exception e) {
                Logger.e("deleteOutObjectAndCreateInfoMessage : DBException caught while inserting Info Message: " + e.getMessage());
            }
        }

        private void createInfoMessage(AttachmentOutObject attachmentOutObject, AttachmentResponse attachmentResponse) {
            InfoMessage infoMessage = new InfoMessage();
            infoMessage.setBeLid(attachmentOutObject.getBEHeaderLid());
            infoMessage.setBeName(attachmentOutObject.getBEName());
            infoMessage.setCategory("FAILURE");
            infoMessage.setMessage("Function:" + attachmentOutObject.getFunctionName() + ". Response Code: " + attachmentResponse.getResponseCode() + ". Message:" + attachmentResponse.getErrorMessage());
            try {
                FrameworkManager.getInstance().getDataManager().insert(infoMessage);
            }
            catch (DBException e) {
                Logger.log(8, this.getClass().getName(), "createInfoMessage", "DBException caught while inserting Info Message: " + e.getMessage());
            }
        }

        private boolean deleteOutObject(AttachmentOutObject attachmentOutObject) {
            if (attachmentOutObject != null) {
                try {
                    String function = " Function:" + attachmentOutObject.getFunctionName();
                    String beName = " BE: " + attachmentOutObject.getBEName();
                    String beLid = " BE LID: " + attachmentOutObject.getBEHeaderLid();
                    String message = "Deleting out object." + function + beName + beLid;
                    String whereClause = OutObject.BE_HEADER_LID + " = '" + attachmentOutObject.getBEHeaderLid() + "'";
                    IDataStructure[] outObjects = DataSender.this.frameworkDataManager.get(OutObject.TABLE_NAME, whereClause, OutObject.class);
                    if (outObjects != null && outObjects.length > 0) {
                        Outbox.getInstance().remove((OutObject)outObjects[0]);
                    }
                    if (Logger.getDefaultLogLevel() == 9) {
                        Logger.log(9, this.getClass().getName(), "deleteOutObject", message);
                    }
                }
                catch (DBException e) {
                    Logger.log(8, this.getClass().getName(), "deleteOutObject", "DBException caught while deleting outobject: " + e.getMessage());
                    return false;
                }
            }
            return true;
        }

        private boolean deleteAttachmentOutObject(AttachmentOutObject attachmentOutObject) {
            if (attachmentOutObject != null) {
                try {
                    String function = " Function:" + attachmentOutObject.getFunctionName();
                    String beName = " BE: " + attachmentOutObject.getBEName();
                    String beLid = " BE LID: " + attachmentOutObject.getBEHeaderLid();
                    String message = "Deleting attachment out object." + function + beName + beLid;
                    if (Logger.getDefaultLogLevel() == 9) {
                        Logger.log(9, this.getClass().getName(), "deleteAttachmentOutObject", message);
                    }
                    AttachmentOutbox.getInstance().remove(attachmentOutObject);
                }
                catch (DBException e) {
                    Logger.log(8, this.getClass().getName(), "deleteAttachmentOutObject", "DBException caught while deleting attachment outobject: " + e.getMessage());
                    return false;
                }
            }
            return true;
        }

        private synchronized void submitRequest(AttachmentOutObject attachmentOutObject) throws ApplicationException, DBException {
            if (attachmentOutObject.getAttachmentOutObjectStatus() == AttachmentOutObject.ATTACHMENT_OUT_OBJECT_STATUS.LOCKED_FOR_SENDING) {
                throw new ApplicationException(this.getClass().getName(), "submitRequest", "Cannot modify or re-submit again. Attachment OutObject is locked for sending");
            }
            attachmentOutObject.setAttachmentOutObjectStatus(AttachmentOutObject.ATTACHMENT_OUT_OBJECT_STATUS.LOCKED_FOR_SENDING);
            if (DataSender.this.frameworkDataManager == null) {
                DataSender.this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
            }
            DataSender.this.frameworkDataManager.update(attachmentOutObject);
            AttachmentResponse attachmentResponse = this.checkAndUploadAttachments(attachmentOutObject);
            if (attachmentResponse == null) {
                Logger.e("Attachment response is null. Deleting the Attachment Out Object and proceed. BE Name: " + attachmentOutObject.getBEHeaderLid() + ", BE Header Lid: " + attachmentOutObject.getBEHeaderLid());
                AttachmentOutbox.getInstance().remove(attachmentOutObject);
                Logger.e("Attachment Out Object deleted");
                return;
            }
            if (Strings.isNullOrEmpty((String)attachmentResponse.getGUID())) {
                String errMessage = attachmentResponse.getErrorMessage();
                this.deleteAttachmentOutObjectAndCreateInfoMessage(attachmentOutObject, errMessage);
                if (DataSender.this.notificationListener == null) {
                    DataSender.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                }
                Logger.i("Stopping Data Sender");
                DataSender.getInstance().stop();
                Logger.i("Stopped Data Sender");
                if (DataSender.this.notificationListener != null) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DataSender.this.notificationListener.notifyAttachmentSendAbort();
                        }
                    });
                    t.start();
                }
                return;
            }
            int responseCode = attachmentResponse.getResponseCode();
            switch (responseCode) {
                case 200: 
                case 201: {
                    this.deleteAttachmentOutObject(attachmentOutObject);
                    if (DataSender.getInstance().isAlive()) break;
                    DataSender.getInstance().start();
                    break;
                }
                case 0: {
                    this.handleZeroResponse(attachmentResponse);
                    return;
                }
                default: {
                    this.createInfoMessage(attachmentOutObject, attachmentResponse);
                    Logger.i("Stopping Data Sender");
                    DataSender.getInstance().stop();
                    Logger.i("Stopped Data Sender");
                    if (DataSender.this.notificationListener == null) {
                        DataSender.this.notificationListener = SyncEngine.getInstance().getNotificationListener();
                    }
                    if (Logger.getDefaultLogLevel() == 9) {
                        Logger.d("Attachment Send Abort");
                    }
                    if (DataSender.this.notificationListener == null) break;
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DataSender.this.notificationListener.notifyAttachmentSendAbort();
                        }
                    });
                    t.start();
                }
            }
        }

        private void handleZeroResponse(AttachmentResponse attachmentResponse) {
            int responseCode = attachmentResponse.getResponseCode();
            String errorMessage = attachmentResponse.getErrorMessage();
            Logger.log(8, this.getClass().getName(), "submitRequest", "HTTP response error. Response code: " + responseCode + " Response message: " + errorMessage);
            try {
                Thread.sleep(this.sleepTimeInSeconds);
                if (this.sleepTimeInSeconds < 300000) {
                    this.sleepTimeInSeconds *= 2;
                }
            }
            catch (InterruptedException e) {
                Logger.log(8, this.getClass().getName(), "submitRequest", "Data sender interrupted. Exception: " + e.getMessage());
                return;
            }
        }

        private AttachmentResponse checkAndUploadAttachments(AttachmentOutObject attachmentOutObject) throws DBException, ApplicationException {
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            String beName = attachmentOutObject.getBEName();
            if (Strings.isNullOrEmpty((String)beName)) {
                Logger.i("BE Name is empty");
                return null;
            }
            if (!applicationManager.isAttachmentSupported(beName)) {
                Logger.i("Attachment not supported");
                return null;
            }
            StructureMeta structureMeta = applicationManager.getHeaderStructureMeta(beName);
            if (structureMeta == null) {
                Logger.e("Invalid BE. Cannot upload attachments. BE Name: " + beName);
                return null;
            }
            if (!applicationManager.isAttachmentSupported(attachmentOutObject.getBEName())) {
                return null;
            }
            IDataManager applicationDataManager = applicationManager.getDataManager();
            String beHeaderLid = String.valueOf(attachmentOutObject.getBEHeaderLid());
            String whereClause = "LID = '" + beHeaderLid + "'";
            IDataStructure[] headers = applicationDataManager.get(structureMeta.getStructName(), whereClause);
            if (headers == null || headers.length == 0) {
                Logger.e("Header not found. Cannot check for attachments. Structure Name: " + structureMeta.getStructName());
                return null;
            }
            IDataStructure header = headers[0];
            AttachmentItem[] items = this.getAttachments(header);
            if (items == null || items.length == 0) {
                Logger.e("Attachment items not found. BE Header Lid " + beHeaderLid);
                return null;
            }
            AttachmentResponse attachmentResponse = null;
            try {
                attachmentResponse = this.uploadItems(items);
            }
            catch (Exception e) {
                Logger.e(e.getMessage());
                if (attachmentResponse != null) {
                    Logger.e("AttachmentResponse Code: " + attachmentResponse.getResponseCode());
                    Logger.e("AttachmentResponse Error message: " + attachmentResponse.getResponseCode());
                }
                return new AttachmentResponse(0, "Failed to upload attachments");
            }
            return attachmentResponse;
        }

        private AttachmentResponse uploadItems(AttachmentItem[] items) {
            boolean copied = Attachment.copyAllFilesToLocalPath(items);
            if (!copied) {
                Logger.e("All File could not be copied to the destination folder, that is application's folder. so not queuing this attachment for upload");
            } else {
                Logger.i("All File copied to the destination folder, that is application's folder.");
            }
            AttachmentResponse attachmentResponse = null;
            for (AttachmentItem attachmentItem : items) {
                try {
                    attachmentResponse = HTTPConnection.uploadAttachment(attachmentItem, true, true, "UPLOAD_ATTACHMENT");
                    Logger.i("Attachment response. GUID:" + attachmentResponse.getGUID() + ". GUID Available? " + !Strings.isNullOrEmpty((String)attachmentResponse.getGUID()));
                    if (!Strings.isNullOrEmpty((String)attachmentResponse.getGUID())) continue;
                    attachmentResponse.setErrorMessage("Unable to upload attachments");
                    Logger.i("Attachment upload failed as not guid returned. Hence stopping upload. BE upload will be ignored. Item failed - BE:  " + attachmentItem.getBEName() + " Lid:" + attachmentItem.getLid() + " File:" + attachmentItem.getFileName());
                    break;
                }
                catch (Exception e) {
                    Logger.e("Exception while uploadItems: " + e.getMessage());
                    if (attachmentResponse != null) {
                        Logger.e("AttachmentResponse Code: " + attachmentResponse.getResponseCode());
                        Logger.e("AttachmentResponse Error message: " + attachmentResponse.getResponseCode());
                    }
                    return new AttachmentResponse(0, e.getMessage());
                }
            }
            return attachmentResponse;
        }

        private AttachmentItem[] getAttachments(IDataStructure header) {
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            IDataStructure[] dataStructures = null;
            try {
                IDataManager applicationDataManager = applicationManager.getDataManager();
                String beName = header.getBEName();
                String whereClause = "ATTACHMENT_STATUS = '" + AttachmentItem.ATTACHMENT_ITEM_STATUS.SAVED_FOR_UPLOAD.ordinal() + "'";
                String attachmentStructName = beName + "_ATTACHMENT";
                dataStructures = applicationDataManager.getChildren(attachmentStructName, whereClause, null, header);
            }
            catch (DBException e) {
                Logger.e("DBException while getting attachment items of a business header: " + e.getMessage());
            }
            if (dataStructures == null || dataStructures.length == 0) {
                Logger.e("dataStructures is null, while checking if the IDataStructure in question supports attachments and if it has one");
                return null;
            }
            AttachmentItem[] items = new AttachmentItem[dataStructures.length];
            System.arraycopy(dataStructures, 0, items, 0, dataStructures.length);
            return items;
        }
    }

    public static enum OUTBOX_LOCK_RESULT {
        LOCK_APPLIED,
        DATA_BEING_SENT;

    }
}

