/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.out;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.CountDownTimer;
import android.os.Looper;
import android.os.NetworkOnMainThreadException;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.core.FrameworkVersion;
import com.unvired.core.RuntimeEngine;
import com.unvired.core.SystemCredentialManager;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.login.AuthenticationService;
import com.unvired.login.LoginParameters;
import com.unvired.model.AttachmentItem;
import com.unvired.model.OutObject;
import com.unvired.model.SystemCredential;
import com.unvired.security.PasscodeGenerator;
import com.unvired.security.Security;
import com.unvired.sync.SyncConstants;
import com.unvired.sync.attachment.Attachment;
import com.unvired.sync.connection.ServiceConstants;
import com.unvired.sync.connection.URLService;
import com.unvired.sync.in.MD5Encryption;
import com.unvired.sync.out.DataSender;
import com.unvired.sync.out.ISyncAppCallback;
import com.unvired.sync.out.ISyncFrameworkCallback;
import com.unvired.sync.out.ServerErrors;
import com.unvired.sync.response.AttachmentResponse;
import com.unvired.sync.response.FileResponse;
import com.unvired.sync.response.HTTPResponse;
import com.unvired.sync.response.ISyncResponse;
import com.unvired.sync.ssl.ModifiedHostNameVerifier;
import com.unvired.sync.ssl.ModifiedX509TrustManager;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.NetworkUtil;
import com.unvired.utils.PathManager;
import com.unvired.utils.TokenHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.message.BasicNameValuePair;

public class HTTPConnection {
    private static long dataSentSize = 0L;
    public static Hashtable<ISyncAppCallback, ISyncFrameworkCallback> appFrameworkCallbackMap = new Hashtable();
    public static Hashtable<ISyncFrameworkCallback, Call> okHttpConnectionCallbackMap = new Hashtable();

    public static void destroy() {
        appFrameworkCallbackMap.clear();
        okHttpConnectionCallbackMap.clear();
    }

    public static final HTTPResponse register(Context context) {
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage()) {
            return new HTTPResponse(0, null, "No Coverage. Please try later.");
        }
        String url = LoginParameters.getUrl();
        if (url.contains("?local")) {
            String urlToBeReplaced = url.substring(url.lastIndexOf("?"));
            url = url.replace(urlToBeReplaced, "");
            AuthenticationService.containsLocalKeyword = true;
        }
        url = URLService.authenticationURL(url);
        String companyAlias = LoginParameters.getCompany();
        String applicationName = LoginParameters.getAppName();
        String deviceOrFEAdapterType = LoginParameters.getDeviceType().toString();
        String customDeviceId = LoginParameters.getDeviceId();
        String messageType = String.valueOf(4000);
        String messageSubType = String.valueOf(600);
        if (url == null || url.length() <= 0) {
            Logger.log(8, "HTTPConnection", "authenticateAndActivate", "Invalid URL: " + url);
            return new HTTPResponse(0, null, "Invalid URL: " + url);
        }
        String udid = FrameworkHelper.getDeviceUUID();
        String imei = FrameworkHelper.getDeviceIMEI();
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        LoginParameters.LOGIN_TYPE loginType = LoginParameters.getCurrentLoginType();
        String unviredUserId = LoginParameters.getUnviredUserId();
        String unviredPassword = LoginParameters.getUnviredPassword();
        try {
            String[] passCodeAndTime = PasscodeGenerator.computePin(null, null);
            unviredPassword = MD5Encryption.generateKey(unviredPassword);
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("ONE_TIME_TOKEN", ""));
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-MESSAGE-TIME", passCodeAndTime[0]));
        }
        catch (ApplicationException e) {
            Logger.log(8, HTTPConnection.class.getSimpleName(), "authenticateAndActivate", "Error while updating unvired password with message post time." + e.getMessage());
        }
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MUSID", unviredUserId));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("PWD", unviredPassword));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-REGISTER-FIRST-NAME", LoginParameters.getFirstName()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-REGISTER-LAST-NAME", LoginParameters.getLastName()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("EMAIL", LoginParameters.getEmail()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("LOGIN_TYPE", ServiceConstants.getLoginTypeParameterValue(loginType)));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MSG_TYPE", messageType));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MSG_SUB_TYPE", messageSubType));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("APPLICATION", applicationName));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("COMPANY_ALIAS", companyAlias));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("IMEI", imei));
        if (!Strings.isNullOrEmpty((String)customDeviceId)) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("UID", customDeviceId));
        } else {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("UID", udid));
        }
        if (Strings.isNullOrEmpty((String)deviceOrFEAdapterType)) {
            boolean tablet = FrameworkHelper.isTabletDevice(context);
            deviceOrFEAdapterType = tablet ? "ANDROID_TABLET" : "ANDROID_PHONE";
            boolean runningOnGlass = FrameworkHelper.isRunningOnGlass();
            if (runningOnGlass) {
                deviceOrFEAdapterType = "GOOGLE_GLASS";
            }
        }
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("DEVICE_TYPE", deviceOrFEAdapterType));
        Logger.log(7, HTTPConnection.class.getName(), "authenticateAndActivate", "Auth and activate Message call to server. URL: " + url);
        return HTTPConnection.postToServer(url, nameValuePairs);
    }

    public static final HTTPResponse authenticateAndActivate(Context context) {
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage()) {
            return new HTTPResponse(0, null, "No Coverage. Please try later.");
        }
        String url = LoginParameters.getUrl();
        if (url.contains("?local")) {
            String urlToBeReplaced = url.substring(url.lastIndexOf("?"));
            url = url.replace(urlToBeReplaced, "");
            AuthenticationService.containsLocalKeyword = true;
        }
        url = URLService.authenticationURL(url);
        String companyAlias = LoginParameters.getCompany();
        String applicationName = LoginParameters.getAppName();
        String deviceOrFEAdapterType = LoginParameters.getDeviceType().toString();
        String customDeviceId = LoginParameters.getDeviceId();
        String messageType = String.valueOf(4000);
        String messageSubType = String.valueOf(200);
        if (url == null || url.length() <= 0) {
            Logger.log(8, "HTTPConnection", "authenticateAndActivate", "Invalid URL: " + url);
            return new HTTPResponse(0, null, "Invalid URL: " + url);
        }
        String udid = FrameworkHelper.getDeviceUUID();
        String imei = FrameworkHelper.getDeviceIMEI();
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        LoginParameters.LOGIN_TYPE loginType = LoginParameters.getCurrentLoginType();
        switch (loginType) {
            case SAP: 
            case ADS: {
                String adsUserId = LoginParameters.getADSUserId();
                String adsPassword = LoginParameters.getADSPassword();
                String adsDomain = LoginParameters.getADSDomain();
                if (adsPassword != null && !adsPassword.isEmpty()) {
                    try {
                        adsPassword = Security.encryptUsingUnviredPublicKey(adsPassword);
                    }
                    catch (ApplicationException e) {
                        String error = "Exception while encrypting the ADS password: " + e.getMessage();
                        Logger.log(8, "HTTPConnection", "authenticateAndActivate", error);
                        return new HTTPResponse(0, null, error);
                    }
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("PWD", adsPassword));
                } else if (TokenHelper.isTokenInfoAvailable()) {
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-ONE-TIME-LOGIN-TOKEN", TokenHelper.getToken()));
                } else {
                    messageSubType = String.valueOf(700);
                }
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("MUSID", adsUserId));
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("DOMAIN", adsDomain));
                break;
            }
            case CUSTOM: {
                String customLoginString = LoginParameters.getCustomLoginInput();
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("MSG", customLoginString));
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("FEUSERID", LoginParameters.getFrontEndId()));
                break;
            }
            case SAML2: {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                String format = formatter.format(cal.getTime());
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-MESSAGE-TIME", format));
                break;
            }
            default: {
                String unviredUserId = LoginParameters.getUnviredUserId();
                String unviredPassword = LoginParameters.getUnviredPassword();
                String MD5Password = LoginParameters.getMD5Password();
                if (unviredPassword == null || unviredPassword.isEmpty()) {
                    unviredPassword = MD5Password;
                }
                if (unviredPassword != null && !unviredPassword.isEmpty()) {
                    try {
                        String[] passCodeAndTime = PasscodeGenerator.computePin(null, null);
                        if (!unviredPassword.equals(MD5Password)) {
                            unviredPassword = MD5Encryption.generateKey(unviredPassword);
                        }
                        unviredPassword = MD5Encryption.generateKey(unviredPassword + passCodeAndTime[0]);
                        nameValuePairs.add((NameValuePair)new BasicNameValuePair("ONE_TIME_TOKEN", ""));
                        nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-MESSAGE-TIME", passCodeAndTime[0]));
                    }
                    catch (ApplicationException e) {
                        Logger.log(8, HTTPConnection.class.getSimpleName(), "authenticateAndActivate", "Error while updating unvired password with message post time." + e.getMessage());
                    }
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("PWD", unviredPassword));
                } else if (TokenHelper.isTokenInfoAvailable()) {
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-ONE-TIME-LOGIN-TOKEN", TokenHelper.getToken()));
                } else {
                    messageSubType = String.valueOf(700);
                }
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("MUSID", unviredUserId));
            }
        }
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("LOGIN_TYPE", ServiceConstants.getLoginTypeParameterValue(loginType)));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MSG_TYPE", messageType));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MSG_SUB_TYPE", messageSubType));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("APPLICATION", applicationName));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("COMPANY_ALIAS", companyAlias));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("IMEI", imei));
        if (!Strings.isNullOrEmpty((String)customDeviceId)) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("UID", customDeviceId));
        } else {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("UID", udid));
        }
        if (Strings.isNullOrEmpty((String)deviceOrFEAdapterType)) {
            boolean tablet = FrameworkHelper.isTabletDevice(context);
            deviceOrFEAdapterType = tablet ? "ANDROID_TABLET" : "ANDROID_PHONE";
            boolean runningOnGlass = FrameworkHelper.isRunningOnGlass();
            if (runningOnGlass) {
                deviceOrFEAdapterType = "GOOGLE_GLASS";
            }
        }
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("DEVICE_TYPE", deviceOrFEAdapterType));
        Logger.log(7, HTTPConnection.class.getName(), "authenticateAndActivate", "Auth and activate Message call to server. URL: " + url);
        return HTTPConnection.postToServer(url, nameValuePairs);
    }

    public static final HTTPResponse authenticate(Context context) {
        String serverId;
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage()) {
            return new HTTPResponse(0, null, "No Coverage. Please try later.");
        }
        String url = null;
        try {
            url = URLService.authenticationURL();
        }
        catch (ApplicationException e) {
            String error = "Exception while getting the authenticate URL: " + e.getMessage();
            Logger.log(8, "HTTPConnection", "authenticate", error);
            return new HTTPResponse(0, null, error);
        }
        catch (DBException e) {
            String error = "Exception while getting the authenticate URL: " + e.getMessage();
            Logger.log(8, "HTTPConnection", "authenticate", error);
            return new HTTPResponse(0, null, error);
        }
        if (url == null || url.length() <= 0) {
            Logger.log(8, "HTTPConnection", "authenticate", "Invalid URL: " + url);
            return new HTTPResponse(0, null, "Invalid URL: " + url);
        }
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        String companyAlias = null;
        String applicationName = null;
        String customDeviceId = null;
        LoginParameters.LOGIN_TYPE loginType = null;
        try {
            UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
            loginType = userSettingsManager.getLoginType();
            switch (loginType) {
                case SAP: 
                case ADS: {
                    String adsDomain = userSettingsManager.getADSDomain();
                    String adsUserId = userSettingsManager.getADSUserId();
                    String adsPassword = LoginParameters.getADSPassword();
                    try {
                        if (adsPassword == null || adsPassword.isEmpty() && TokenHelper.isTokenInfoAvailable()) {
                            nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-ONE-TIME-LOGIN-TOKEN", TokenHelper.getToken()));
                        } else {
                            adsPassword = Security.encryptUsingUnviredPublicKey(adsPassword);
                            nameValuePairs.add((NameValuePair)new BasicNameValuePair("PWD", adsPassword));
                        }
                    }
                    catch (ApplicationException e) {
                        String error = "Exception while encrypting the ADS password: " + e.getMessage();
                        Logger.log(8, "HTTPConnection", "authenticate", error);
                        return new HTTPResponse(0, null, error);
                    }
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("MUSID", adsUserId));
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("DOMAIN", adsDomain));
                    break;
                }
                default: {
                    String unviredUserId = userSettingsManager.getUnviredUserId();
                    String unviredPassword = LoginParameters.getUnviredPassword();
                    try {
                        String[] passCodeAndTime = PasscodeGenerator.computePin(null, null);
                        unviredPassword = unviredPassword == null || unviredPassword.isEmpty() ? LoginParameters.getMD5Password() : MD5Encryption.generateKey(unviredPassword);
                        if (unviredPassword == null || unviredPassword.isEmpty() && TokenHelper.isTokenInfoAvailable()) {
                            nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-ONE-TIME-LOGIN-TOKEN", TokenHelper.getToken()));
                        } else {
                            unviredPassword = MD5Encryption.generateKey(unviredPassword + passCodeAndTime[0]);
                            nameValuePairs.add((NameValuePair)new BasicNameValuePair("ONE_TIME_TOKEN", ""));
                            nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-MESSAGE-TIME", passCodeAndTime[0]));
                            nameValuePairs.add((NameValuePair)new BasicNameValuePair("PWD", unviredPassword));
                        }
                    }
                    catch (ApplicationException e) {
                        Logger.log(8, HTTPConnection.class.getSimpleName(), "authenticateAndActivate", "Error while updating unvired password with message post time." + e.getMessage());
                    }
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("MUSID", unviredUserId));
                }
            }
            companyAlias = userSettingsManager.getCompanyAlias();
            applicationName = ApplicationManager.getInstance().getApplicationName();
            FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
            customDeviceId = frameworkSettingsManager.getFrontEndUserId();
            serverId = frameworkSettingsManager.getServerId();
        }
        catch (DBException e) {
            String error = "DB Exception: " + e.getMessage();
            Logger.log(8, "HTTPConnection", "authenticate", error);
            return new HTTPResponse(0, null, error);
        }
        String messageType = String.valueOf(4000);
        String messageSubType = String.valueOf(100);
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("LOGIN_TYPE", ServiceConstants.getLoginTypeParameterValue(loginType)));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MSG_TYPE", messageType));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MSG_SUB_TYPE", messageSubType));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("APPLICATION", applicationName));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("COMPANY_ALIAS", companyAlias));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("FEUSERID", customDeviceId));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("SERVER_ID", serverId));
        Logger.log(7, HTTPConnection.class.getName(), "authenticate", "Auth call to server. URL: " + url);
        return HTTPConnection.postToServer(url, nameValuePairs);
    }

    public static final HTTPResponse notifyApplicationActivation(byte[] activationXML, Hashtable<String, String> frameworkProperties, String password) throws ApplicationException, IOException {
        String url = frameworkProperties.get("URL");
        String connectionUrl = URLService.authenticationURL(url);
        String serverId = frameworkProperties.get("ServerId");
        String applicationName = LoginParameters.getAppName();
        String unviredUserId = frameworkProperties.get("UNVIREDID");
        String FEAdapterType = frameworkProperties.get("FID_TYPE");
        String unviredPassword = null;
        String feUserId = frameworkProperties.get("FEUSERID");
        String companyAlias = LoginParameters.getCompany();
        String companyNamespace = frameworkProperties.get("NAMESPACE");
        String oneTimeSecret = frameworkProperties.get("ONE_TIME_SECRET");
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage()) {
            return new HTTPResponse(0, null, "No Coverage. Please try later.");
        }
        String[] passCodeAndTime = PasscodeGenerator.computePin(oneTimeSecret, feUserId);
        LoginParameters.LOGIN_TYPE loginType = LoginParameters.getCurrentLoginType();
        switch (loginType) {
            case UNVIRED_ID: 
            case EMAIL: {
                unviredPassword = LoginParameters.getUnviredPassword();
                unviredPassword = unviredPassword == null || unviredPassword.isEmpty() ? LoginParameters.getMD5Password() : MD5Encryption.generateKey(unviredPassword);
                unviredPassword = MD5Encryption.generateKey(unviredPassword + passCodeAndTime[1]);
                break;
            }
            case SAP: 
            case ADS: {
                String aesSecurityKey = frameworkProperties.get("SEC_KEY");
                aesSecurityKey = aesSecurityKey.substring(aesSecurityKey.lastIndexOf(58) + 1, aesSecurityKey.length());
                unviredPassword = Security.decryptAES(aesSecurityKey.getBytes(), password.getBytes());
                unviredPassword = MD5Encryption.generateKey(unviredPassword + passCodeAndTime[1]);
            }
        }
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MUSID", unviredUserId));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("PWD", unviredPassword));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("APPLICATION", applicationName));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("FEUSERID", feUserId));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("SERVER_ID", serverId));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("COMPANY_ALIAS", companyAlias));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("ONE_TIME_TOKEN", passCodeAndTime[0]));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-MESSAGE-TIME", passCodeAndTime[1]));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("FNC_ID", "ADMIN_SERVICES"));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MSG_TYPE", String.valueOf(9000)));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MSG_SUB_TYPE", String.valueOf(800)));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MSG", new String(activationXML)));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("SYNC", SyncConstants.SYNC_MODE.SYNC.toString()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("COMPANY_NAMESPACE", companyNamespace));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("DEVICE_TYPE", FEAdapterType));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("LOGIN_TYPE", ServiceConstants.getLoginTypeParameterValue(loginType)));
        Logger.log(7, HTTPConnection.class.getName(), "notifyApplicationActivation", "Notify application activation call to server. URL: " + url);
        return HTTPConnection.postToServer(connectionUrl, nameValuePairs);
    }

    public static final HTTPResponse authenticateBackendCredentials(SystemCredential systemCredential) throws DBException, ApplicationException {
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage()) {
            return new HTTPResponse(0, null, "No Coverage. Please try later.");
        }
        if (systemCredential == null) {
            String error = "Invalid Backend System Credentials";
            Logger.log(8, "HTTPConnection", "authenticateBackendCredentials", error);
            return new HTTPResponse(0, null, error);
        }
        String connectionUrl = URLService.postMessageURL();
        FrameworkSettingsManager frameworkSettingsManager = null;
        List<NameValuePair> parameters = null;
        String companyNamespace = null;
        try {
            frameworkSettingsManager = FrameworkSettingsManager.getInstance();
            companyNamespace = frameworkSettingsManager.getNamespace();
            parameters = HTTPConnection.getCommonPostParameters();
        }
        catch (DBException dbException) {
            Logger.log(8, HTTPConnection.class.getName(), "postDirect", "DBException: " + dbException.getMessage());
            throw new ApplicationException(HTTPConnection.class.getName(), "postDirect", "DBException: " + dbException.getMessage());
        }
        parameters.add((NameValuePair)new BasicNameValuePair("COMPANY_NAMESPACE", companyNamespace));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG_TYPE", String.valueOf(4000)));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG_SUB_TYPE", String.valueOf(300)));
        parameters.add((NameValuePair)new BasicNameValuePair("SYNC", SyncConstants.SYNC_MODE.SYNC.toString()));
        SystemCredential[] systemCredentials = new SystemCredential[]{systemCredential};
        List<NameValuePair> nameValuePairs = HTTPConnection.mergePostParameters(parameters, systemCredentials);
        return HTTPConnection.postToServer(connectionUrl, nameValuePairs);
    }

    public static final HTTPResponse forgotPassword() throws DBException, ApplicationException {
        List<NameValuePair> parameters;
        String companyNamespace;
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage()) {
            return new HTTPResponse(0, null, "No Coverage. Please try later.");
        }
        String connectionUrl = URLService.postMessageURL();
        try {
            FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
            companyNamespace = frameworkSettingsManager.getNamespace();
            parameters = HTTPConnection.getCommonPostParameters();
        }
        catch (DBException dbException) {
            Logger.log(8, HTTPConnection.class.getName(), "postDirect", "DBException: " + dbException.getMessage());
            throw new ApplicationException(HTTPConnection.class.getName(), "postDirect", "DBException: " + dbException.getMessage());
        }
        LoginParameters.LOGIN_TYPE loginType = UserSettingsManager.getInstance().getLoginType();
        parameters.add((NameValuePair)new BasicNameValuePair("LOGIN_TYPE", ServiceConstants.getLoginTypeParameterValue(loginType)));
        parameters.add((NameValuePair)new BasicNameValuePair("COMPANY_NAMESPACE", companyNamespace));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG_TYPE", String.valueOf(4000)));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG_SUB_TYPE", String.valueOf(500)));
        parameters.add((NameValuePair)new BasicNameValuePair("SYNC", SyncConstants.SYNC_MODE.SYNC.toString()));
        return HTTPConnection.postToServer(connectionUrl, parameters);
    }

    public static final HTTPResponse resetPassword(String forgotToken, String newPassword) throws DBException, ApplicationException {
        List<NameValuePair> parameters;
        String companyNamespace;
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage()) {
            return new HTTPResponse(0, null, "No Coverage. Please try later.");
        }
        String connectionUrl = URLService.postMessageURL();
        try {
            FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
            companyNamespace = frameworkSettingsManager.getNamespace();
            parameters = HTTPConnection.getCommonPostParameters();
        }
        catch (DBException dbException) {
            Logger.log(8, HTTPConnection.class.getName(), "postDirect", "DBException: " + dbException.getMessage());
            throw new ApplicationException(HTTPConnection.class.getName(), "postDirect", "DBException: " + dbException.getMessage());
        }
        LoginParameters.LOGIN_TYPE loginType = UserSettingsManager.getInstance().getLoginType();
        parameters.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-NEW-PASSWORD", newPassword));
        parameters.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-FORGOT-TOKEN", forgotToken));
        parameters.add((NameValuePair)new BasicNameValuePair("LOGIN_TYPE", ServiceConstants.getLoginTypeParameterValue(loginType)));
        parameters.add((NameValuePair)new BasicNameValuePair("COMPANY_NAMESPACE", companyNamespace));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG_TYPE", String.valueOf(4000)));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG_SUB_TYPE", String.valueOf(400)));
        parameters.add((NameValuePair)new BasicNameValuePair("SYNC", SyncConstants.SYNC_MODE.SYNC.toString()));
        return HTTPConnection.postToServer(connectionUrl, parameters);
    }

    public static final HTTPResponse getMessage() {
        try {
            String url = URLService.getMessageURL();
            if (url == null || url.length() <= 0) {
                Logger.log(8, "HTTPConnection", "getMessage", "Invalid URL: " + url);
                return new HTTPResponse(0, null, "Invalid URL: " + url);
            }
            Logger.log(7, HTTPConnection.class.getName(), "getMessage", "Get Message call to server. URL: " + url);
            List<NameValuePair> nameValuePairs = HTTPConnection.getCommonPostParameters();
            HTTPResponse response = HTTPConnection.postToServer(url, nameValuePairs);
            Logger.i("HTTPConnection getMessage Response: " + response.getResponseCode() + ", " + response.getErrorMessage());
            return response;
        }
        catch (DBException dbException) {
            Logger.e("DBException caught in getMessage,", dbException);
            return new HTTPResponse(0, null, "Cannot get framework settings. Db Exception: " + dbException.getMessage());
        }
        catch (ApplicationException e) {
            Logger.e("Application Exception caught in getMessage ", e);
            return new HTTPResponse(0, null, "Application Exception: " + e.getMessage());
        }
        catch (Exception e) {
            Logger.e("Exception caught in getMessage ", e);
            return new HTTPResponse(0, null, "Exception: " + e.getMessage());
        }
    }

    public static final HTTPResponse notifyMessage(String conversationId) {
        Logger.i("HTTPConnection notifyMessage: " + conversationId);
        try {
            String url = URLService.notifyURL();
            if (url == null || url.length() <= 0) {
                Logger.log(8, "HTTPConnection", "notifyMessage", "Invalid URL: " + url);
                return new HTTPResponse(0, null, "Invalid URL: " + url);
            }
            List<NameValuePair> nameValuePairs = HTTPConnection.getCommonPostParameters();
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("CONVID", conversationId));
            HTTPResponse response = HTTPConnection.postToServer(url, nameValuePairs);
            Logger.i("HTTPConnection notifyMessage: " + conversationId + " Response: " + response.getResponseCode() + ", " + response.getErrorMessage());
            return response;
        }
        catch (DBException dbException) {
            Logger.log(8, HTTPConnection.class.getName(), "notifyMessage", "DBException caught: " + dbException.getMessage());
            return new HTTPResponse(0, null, "Cannot get framework settings. Db Exception: " + dbException.getMessage());
        }
        catch (ApplicationException e) {
            Logger.log(8, HTTPConnection.class.getName(), "notifyMessage", "Application Exception: " + e.getMessage());
            return new HTTPResponse(0, null, "Application Exception: " + e.getMessage());
        }
    }

    public static final HTTPResponse post(OutObject outObject) throws ApplicationException, DBException {
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage(false)) {
            return new HTTPResponse(0, null, "No Coverage. Please try later.");
        }
        String connectionUrl = URLService.postMessageURL();
        String function = outObject.getFunctionName();
        String messageType = String.valueOf(outObject.getMessageType());
        String messageSubType = String.valueOf(outObject.getMessageSubType());
        String requestType = outObject.getRequestType();
        String conversationId = outObject.getConversationId();
        String message = "";
        byte[] messageByte = FrameworkHelper.readOutboxFile(outObject.getLid().toString());
        message = new String(messageByte);
        String syncType = outObject.getSyncType();
        FrameworkSettingsManager frameworkSettingsManager = null;
        List<NameValuePair> parameters = null;
        String companyNamespace = null;
        try {
            frameworkSettingsManager = FrameworkSettingsManager.getInstance();
            companyNamespace = frameworkSettingsManager.getNamespace();
            parameters = HTTPConnection.getCommonPostParameters();
        }
        catch (DBException dbException) {
            Logger.log(8, HTTPConnection.class.getName(), "post", "DBException: " + dbException.getMessage());
            throw new ApplicationException(HTTPConnection.class.getName(), "post", "DBException: " + dbException.getMessage());
        }
        parameters.add((NameValuePair)new BasicNameValuePair("FNC_ID", function));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG_TYPE", messageType));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG_SUB_TYPE", messageSubType));
        parameters.add((NameValuePair)new BasicNameValuePair("REQUEST_TYPE", requestType));
        parameters.add((NameValuePair)new BasicNameValuePair("CONVID", conversationId));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG", message));
        parameters.add((NameValuePair)new BasicNameValuePair("SYNC", syncType));
        parameters.add((NameValuePair)new BasicNameValuePair("COMPANY_NAMESPACE", companyNamespace));
        String lid = outObject.getLid();
        parameters.add((NameValuePair)new BasicNameValuePair("CLIENT_MSG_ID", String.valueOf(lid)));
        SystemCredential[] systemCredentials = SystemCredentialManager.getClientCredentials();
        List<NameValuePair> nameValuePairs = HTTPConnection.mergePostParameters(parameters, systemCredentials);
        return HTTPConnection.postToServer(connectionUrl, nameValuePairs);
    }

    private static List<NameValuePair> mergePostParameters(List<NameValuePair> parameters, SystemCredential[] systemCredentials) throws DBException, ApplicationException {
        if (systemCredentials != null && systemCredentials.length > 0) {
            FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
            String aesKey = frameworkSettingsManager.getSecKey();
            aesKey = aesKey.substring(aesKey.lastIndexOf(":") + 1, aesKey.length());
            String name = null;
            String value = null;
            int count = 0;
            for (int i = 0; i < systemCredentials.length; ++i) {
                String systemCredentialUserName = systemCredentials[i].getUserId();
                String systemCredentialPassword = systemCredentials[i].getPassword();
                String systemCredentialPort = systemCredentials[i].getPortName();
                if (systemCredentialUserName == null || systemCredentialUserName.length() <= 0 || systemCredentialPassword == null || systemCredentialPassword.length() <= 0 || systemCredentialPort == null || systemCredentialPort.length() <= 0) continue;
                name = "BACKEND_LOGIN_LOGIN_" + (count + 1);
                value = systemCredentialPort + "~!~" + systemCredentialUserName + "~!~" + systemCredentialPassword;
                value = Security.encryptAES(aesKey.getBytes(), value.getBytes());
                parameters.add((NameValuePair)new BasicNameValuePair(name, value));
                ++count;
            }
            parameters.add((NameValuePair)new BasicNameValuePair("BACKEND_LOGIN_COUNT", String.valueOf(count)));
        }
        return parameters;
    }

    public static final void postDirect(String function, String messageType, String messageSubType, SyncConstants.MESSAGE_REQUEST_TYPE requestType, String message, String applicationName, String componentName, String componentKey, final ISyncFrameworkCallback frameworkCallback) throws ApplicationException, DBException {
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage()) {
            final HTTPResponse httpResponse = new HTTPResponse(0, null, "No Coverage. Please try later.");
            if (frameworkCallback != null) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        frameworkCallback.onResponse(httpResponse);
                    }
                });
                t.start();
                return;
            }
        }
        String connectionUrl = URLService.postMessageURL();
        FrameworkSettingsManager frameworkSettingsManager = null;
        List<NameValuePair> parameters = null;
        String companyNamespace = null;
        try {
            frameworkSettingsManager = FrameworkSettingsManager.getInstance();
            companyNamespace = frameworkSettingsManager.getNamespace();
            parameters = HTTPConnection.getCommonPostParameters();
        }
        catch (DBException dbException) {
            Logger.log(8, HTTPConnection.class.getName(), "postDirect", "DBException: " + dbException.getMessage());
            throw new ApplicationException(HTTPConnection.class.getName(), "postDirect", "DBException: " + dbException.getMessage());
        }
        parameters.add((NameValuePair)new BasicNameValuePair("FNC_ID", function));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG_TYPE", messageType));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG_SUB_TYPE", messageSubType));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG", message));
        parameters.add((NameValuePair)new BasicNameValuePair("SYNC", SyncConstants.SYNC_MODE.SYNC.toString()));
        parameters.add((NameValuePair)new BasicNameValuePair("BCLASS", componentName));
        parameters.add((NameValuePair)new BasicNameValuePair("BKEY", componentKey));
        parameters.add((NameValuePair)new BasicNameValuePair("COMPANY_NAMESPACE", companyNamespace));
        if (requestType != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("REQUEST_TYPE", requestType.toString()));
        }
        SystemCredential[] systemCredentials = null;
        systemCredentials = SystemCredentialManager.getClientCredentials();
        List<NameValuePair> nameValuePairs = HTTPConnection.mergePostParameters(parameters, systemCredentials);
        HTTPConnection.postToServer(connectionUrl, nameValuePairs, frameworkCallback);
    }

    public static final HTTPResponse postDirect(String function, String messageType, String messageSubType, SyncConstants.MESSAGE_REQUEST_TYPE requestType, String message, String applicationName, String componentName, String componentKey) throws ApplicationException, DBException {
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage()) {
            return new HTTPResponse(0, null, "No Coverage. Please try later.");
        }
        String connectionUrl = URLService.postMessageURL();
        FrameworkSettingsManager frameworkSettingsManager = null;
        List<NameValuePair> parameters = null;
        String companyNamespace = null;
        try {
            frameworkSettingsManager = FrameworkSettingsManager.getInstance();
            companyNamespace = frameworkSettingsManager.getNamespace();
            parameters = HTTPConnection.getCommonPostParameters();
        }
        catch (DBException dbException) {
            Logger.log(8, HTTPConnection.class.getName(), "postDirect", "DBException: " + dbException.getMessage());
            throw new ApplicationException(HTTPConnection.class.getName(), "postDirect", "DBException: " + dbException.getMessage());
        }
        parameters.add((NameValuePair)new BasicNameValuePair("FNC_ID", function));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG_TYPE", messageType));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG_SUB_TYPE", messageSubType));
        parameters.add((NameValuePair)new BasicNameValuePair("MSG", message));
        parameters.add((NameValuePair)new BasicNameValuePair("SYNC", SyncConstants.SYNC_MODE.SYNC.toString()));
        parameters.add((NameValuePair)new BasicNameValuePair("BCLASS", componentName));
        parameters.add((NameValuePair)new BasicNameValuePair("BKEY", componentKey));
        parameters.add((NameValuePair)new BasicNameValuePair("COMPANY_NAMESPACE", companyNamespace));
        if (requestType != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("REQUEST_TYPE", requestType.toString()));
        }
        SystemCredential[] systemCredentials = null;
        systemCredentials = SystemCredentialManager.getClientCredentials();
        List<NameValuePair> nameValuePairs = HTTPConnection.mergePostParameters(parameters, systemCredentials);
        return HTTPConnection.postToServer(connectionUrl, nameValuePairs);
    }

    private static final List<NameValuePair> getCommonPostParameters() throws DBException, ApplicationException {
        FrameworkSettingsManager frameworkSettingsManager = null;
        String unviredUserId = null;
        String unviredPassword = null;
        String applicationName = null;
        String feUserId = null;
        String serverId = null;
        String companyAlias = null;
        String[] passCodeAndTime = null;
        String FEAdapterType = null;
        UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
        frameworkSettingsManager = FrameworkSettingsManager.getInstance();
        unviredUserId = userSettingsManager.getUnviredUserId();
        unviredPassword = userSettingsManager.getUnviredPassword();
        applicationName = ApplicationManager.getInstance().getApplicationName();
        feUserId = frameworkSettingsManager.getFrontEndUserId();
        serverId = frameworkSettingsManager.getServerId();
        companyAlias = frameworkSettingsManager.getCompanyAlias();
        FEAdapterType = frameworkSettingsManager.getFEAdapterType();
        String oneTimeSecret = frameworkSettingsManager.getOneTimeSecret();
        passCodeAndTime = PasscodeGenerator.computePin(oneTimeSecret, feUserId);
        if (userSettingsManager.getLoginType() == LoginParameters.LOGIN_TYPE.UNVIRED_ID || userSettingsManager.getLoginType() == LoginParameters.LOGIN_TYPE.EMAIL) {
            unviredPassword = unviredPassword == null || unviredPassword.isEmpty() ? userSettingsManager.getMD5Password() : MD5Encryption.generateKey(unviredPassword);
        }
        unviredPassword = MD5Encryption.generateKey(unviredPassword + passCodeAndTime[1]);
        LoginParameters.LOGIN_TYPE loginType = userSettingsManager.getLoginType();
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MUSID", unviredUserId));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("PWD", unviredPassword));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("APPLICATION", applicationName));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("FEUSERID", feUserId));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("SERVER_ID", serverId));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("DEVICE_TYPE", FEAdapterType));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("COMPANY_ALIAS", companyAlias));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("ONE_TIME_TOKEN", passCodeAndTime[0]));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-MESSAGE-TIME", passCodeAndTime[1]));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("LOGIN_TYPE", ServiceConstants.getLoginTypeParameterValue(loginType)));
        return nameValuePairs;
    }

    private static final void postToServer(String connectionUrl, List<NameValuePair> nameValuePairs, final ISyncFrameworkCallback frameworkCallback) {
        Call call;
        block16: {
            Thread t;
            HTTPResponse httpResponse;
            if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage()) {
                httpResponse = new HTTPResponse(0, null, "No Coverage. Please try later.");
                if (frameworkCallback != null) {
                    t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            frameworkCallback.onResponse(httpResponse);
                        }
                    });
                    t.start();
                }
            }
            if (nameValuePairs != null) {
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-APP-VER", FrameworkVersion.getApplicationVersion()));
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-FWK-VER", FrameworkVersion.getFrameworkVersion()));
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-DEVICE-OS-VERSION", FrameworkVersion.getOSVersion()));
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-DEVICE-MODEL", FrameworkVersion.getDeviceModel()));
                try {
                    if (Strings.isNullOrEmpty((String)FrameworkSettingsManager.getInstance().getActId())) {
                        nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-DEVICE-STATE", FrameworkHelper.getDeviceState()));
                    }
                }
                catch (Exception e) {
                    Logger.e(e.getMessage());
                }
                if (LoginParameters.getCurrentLoginType() == LoginParameters.LOGIN_TYPE.SAML2) {
                    if (!Strings.isNullOrEmpty((String)LoginParameters.getJwtToken())) {
                        nameValuePairs.add((NameValuePair)new BasicNameValuePair("JWT_TOKEN", LoginParameters.getJwtToken()));
                    } else {
                        try {
                            nameValuePairs.add((NameValuePair)new BasicNameValuePair("JWT_TOKEN", UserSettingsManager.getInstance().getJwtToken()));
                        }
                        catch (Exception e) {
                            Logger.e(e.getMessage());
                        }
                    }
                }
            }
            if (Strings.isNullOrEmpty((String)connectionUrl)) {
                Logger.log(8, HTTPConnection.class.getCanonicalName(), "postToServer", "Invalid URL: " + connectionUrl);
                httpResponse = new HTTPResponse(0, null, "Invalid URL: " + connectionUrl);
                if (frameworkCallback != null) {
                    t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            frameworkCallback.onResponse(httpResponse);
                        }
                    });
                    t.start();
                }
            }
            RequestBody formBody = HTTPConnection.getRequestBodyFromParameters(nameValuePairs);
            Request request = new Request.Builder().url(connectionUrl).addHeader("Content-Type", "application/x-www-form-urlencoded").post(formBody).build();
            OkHttpClient client = HTTPConnection.getOkHttpClient();
            call = client.newCall(request);
            try {
                call.enqueue(new Callback(){

                    public void onResponse(Call call, Response response) throws IOException {
                        HTTPConnection.processHttpCallbackOnResponse(frameworkCallback, response);
                    }

                    public void onFailure(Call call, IOException ioEx) {
                        HTTPResponse httpResponse;
                        if (ioEx instanceof SSLHandshakeException) {
                            HTTPConnection.clearCertificate();
                            MessageHelper messageHelper = MessageHelper.getInstance();
                            Looper.prepare();
                            final Toast toast = Toast.makeText((Context)LoginParameters.getContext(), (CharSequence)messageHelper.getValue(messageHelper.SERVER_CERTIFICATE_UPDATED), (int)1);
                            TextView toastMessage = (TextView)toast.getView().findViewById(16908299);
                            View view = toast.getView();
                            if (view != null) {
                                view.setBackgroundColor(Color.argb((int)200, (int)139, (int)0, (int)0));
                            }
                            toastMessage.setTextColor(-1);
                            CountDownTimer toastCountDown = new CountDownTimer(10000L, 1000L){

                                public void onTick(long millisUntilFinished) {
                                    toast.show();
                                }

                                public void onFinish() {
                                    toast.cancel();
                                }
                            };
                            toast.show();
                            toastCountDown.start();
                            Looper.loop();
                            httpResponse = new HTTPResponse(0, null, "Server certificate has changed. Please restart the application to continue");
                        } else {
                            httpResponse = new HTTPResponse(0, null, "HttpConnection failed." + ioEx.getMessage());
                        }
                        if (frameworkCallback != null) {
                            frameworkCallback.onResponse(httpResponse);
                        }
                    }
                });
            }
            catch (Exception exception) {
                String error = "Exception caught while executing http post: " + exception.getMessage();
                Logger.e(error, exception);
                HTTPResponse httpResponse2 = new HTTPResponse(0, null, error);
                if (frameworkCallback == null) break block16;
                frameworkCallback.onResponse(httpResponse2);
            }
        }
        if (frameworkCallback != null) {
            HTTPConnection.updateOkHttpClientConnectionCallbackMap(frameworkCallback, call);
        }
    }

    private static void processHttpCallbackOnResponse(ISyncFrameworkCallback callback, Response response) {
        HTTPResponse httpResponse;
        byte[] responseBytes;
        Hashtable<String, String> serverHTTPFields;
        int responseCode;
        block17: {
            HTTPResponse httpResponse2;
            String error;
            boolean receivedError;
            String responseText;
            block16: {
                responseCode = response.code();
                responseText = responseCode + ": " + NetworkUtil.getResponseText(responseCode);
                Logger.log(7, HTTPConnection.class.getName(), "postToServer", "Posting response: " + responseText);
                switch (responseCode) {
                    case -1: 
                    case 0: {
                        HTTPResponse httpResponse3 = new HTTPResponse(responseCode, responseText);
                        if (callback == null) break;
                        callback.onResponse(httpResponse3);
                    }
                }
                serverHTTPFields = null;
                try {
                    serverHTTPFields = HTTPConnection.getHTTPServerFields(response);
                }
                catch (IOException e) {
                    String error2 = "IOException caught while getting http header fields: " + e.getMessage();
                    Logger.e(error2, e);
                    HTTPResponse httpResponse4 = new HTTPResponse(0, null, error2);
                    if (callback == null) break block16;
                    callback.onResponse(httpResponse4);
                }
            }
            if (serverHTTPFields != null && response != null && (receivedError = ServerErrors.handleUNIErrorCodesRelatedToSync(serverHTTPFields, response))) {
                String umpHaltError = response.header("X-UNVIRED-HALTED-MESSAGE", "");
                error = umpHaltError == null || umpHaltError.isEmpty() ? "UMP server error: " + response.header("X_UNVIRED_SYSTEM_ERROR", "") : umpHaltError;
                httpResponse2 = new HTTPResponse(0, serverHTTPFields, error);
                if (callback != null) {
                    callback.onResponse(httpResponse2);
                    return;
                }
            }
            responseBytes = null;
            try {
                responseBytes = HTTPConnection.getResponseBytesFromHttpResponse(response);
                if (responseBytes == null) {
                    httpResponse = new HTTPResponse(responseCode, serverHTTPFields, "No response from server. Please try later. Technical error - " + responseText);
                    if (callback != null) {
                        callback.onResponse(httpResponse);
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                error = "IllegalStateException caught while getting input stream from http response: " + illegalStateException.getMessage();
                Logger.e(error, illegalStateException);
                httpResponse2 = new HTTPResponse(0, null, error);
                if (callback != null) {
                    callback.onResponse(httpResponse2);
                }
            }
            catch (IOException ioException) {
                error = "IOException caught while getting input stream from http response: " + ioException.getMessage();
                Logger.e(error, ioException);
                httpResponse2 = new HTTPResponse(0, null, error);
                if (callback != null) {
                    callback.onResponse(httpResponse2);
                }
            }
            catch (ApplicationException e) {
                error = "ApplicationException while reading bytes from inputstream. Exception: " + e.getMessage() + " Response code: " + responseCode;
                Logger.e(error, e);
                httpResponse2 = new HTTPResponse(0, null, error);
                if (callback == null) break block17;
                callback.onResponse(httpResponse2);
            }
        }
        httpResponse = new HTTPResponse(responseCode, serverHTTPFields, responseBytes);
        if (callback != null) {
            callback.onResponse(httpResponse);
        }
    }

    private static final HTTPResponse postToServer(String connectionUrl, List<NameValuePair> nameValuePairs) {
        boolean receivedError;
        Request request;
        long request_length;
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage()) {
            return new HTTPResponse(0, null, "No Coverage. Please try later.");
        }
        if (nameValuePairs != null) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-APP-VER", FrameworkVersion.getApplicationVersion()));
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-FWK-VER", FrameworkVersion.getFrameworkVersion()));
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-DEVICE-OS-VERSION", FrameworkVersion.getOSVersion()));
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-DEVICE-MODEL", FrameworkVersion.getDeviceModel()));
            try {
                if (Strings.isNullOrEmpty((String)FrameworkSettingsManager.getInstance().getActId())) {
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-DEVICE-STATE", FrameworkHelper.getDeviceState()));
                }
            }
            catch (Exception e) {
                Logger.e(e.getMessage());
            }
            if (LoginParameters.getCurrentLoginType() == LoginParameters.LOGIN_TYPE.SAML2) {
                if (!Strings.isNullOrEmpty((String)LoginParameters.getJwtToken())) {
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("JWT_TOKEN", LoginParameters.getJwtToken()));
                } else {
                    try {
                        nameValuePairs.add((NameValuePair)new BasicNameValuePair("JWT_TOKEN", UserSettingsManager.getInstance().getJwtToken()));
                    }
                    catch (Exception e) {
                        Logger.e(e.getMessage());
                    }
                }
            }
        }
        if (Strings.isNullOrEmpty((String)connectionUrl)) {
            Logger.log(8, HTTPConnection.class.getCanonicalName(), "postToServer", "Invalid URL: " + connectionUrl);
            return new HTTPResponse(0, null, "Invalid URL: " + connectionUrl);
        }
        boolean isCompressed = false;
        try {
            if (PathManager.getInstance().getActiveAccount() != null) {
                isCompressed = FrameworkSettingsManager.getInstance().isCompressPostData();
            }
        }
        catch (Exception e) {
            Logger.log(8, HTTPConnection.class.getSimpleName(), "postToServer", "Error while checking for isCompressPostData." + e.getMessage());
        }
        if (isCompressed) {
            RequestBody formBody = HTTPConnection.gzip(HTTPConnection.getRequestBodyFromParameters(nameValuePairs));
            request_length = 0L;
            try {
                request_length = formBody.contentLength();
            }
            catch (IOException e) {
                Logger.e("HTTPConnection postToServer IOException on compressed request_length", e);
            }
            request = new Request.Builder().url(connectionUrl).addHeader("Content-Encoding", "gzip").addHeader("content-length", String.valueOf(request_length)).addHeader("Content-Type", "application/x-www-form-urlencoded").post(formBody).build();
        } else {
            RequestBody formBody = HTTPConnection.getRequestBodyFromParameters(nameValuePairs);
            request_length = 0L;
            try {
                request_length = formBody.contentLength();
            }
            catch (IOException e) {
                Logger.e("HTTPConnection postToServer IOException on uncompressed request_length", e);
            }
            request = new Request.Builder().url(connectionUrl).addHeader("content-length", String.valueOf(request_length)).addHeader("Content-Type", "application/x-www-form-urlencoded").post(formBody).build();
        }
        OkHttpClient client = HTTPConnection.getOkHttpClient();
        Call call = client.newCall(request);
        Response response = null;
        try {
            response = call.execute();
        }
        catch (SSLHandshakeException ex) {
            try {
                HTTPConnection.clearCertificate();
                DataSender.getInstance().stop();
            }
            catch (Exception e) {
                Logger.e("Exception caught while clearing SSL certificate on SSLHandshakeException." + e.getMessage(), e);
            }
            String error = "SSL handshake error while executing http post: " + ex.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "postToServer", error);
            return new HTTPResponse(526, null, error);
        }
        catch (NetworkOnMainThreadException exception) {
            String error = "NetworkOnMainThreadException caught while executing http post in main thread. " + exception.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "postToServer", error);
            return new HTTPResponse(0, null, error);
        }
        catch (Exception exception) {
            String error = "Exception caught while executing http post: " + exception.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "postToServer", error);
            return new HTTPResponse(0, null, error);
        }
        int responseCode = response.code();
        String responseText = responseCode + ": " + NetworkUtil.getResponseText(responseCode);
        Logger.log(7, HTTPConnection.class.getName(), "postToServer", "Posting response: " + responseText);
        switch (responseCode) {
            case -1: 
            case 0: {
                return new HTTPResponse(responseCode, responseText);
            }
        }
        Hashtable<String, String> serverHTTPFields = null;
        try {
            serverHTTPFields = HTTPConnection.getHTTPServerFields(response);
        }
        catch (IOException e) {
            String error = "IOException caught while getting http header fields: " + e.getMessage();
            Logger.e(error, e);
            return new HTTPResponse(0, null, error);
        }
        if (serverHTTPFields != null && response != null && (receivedError = ServerErrors.handleUNIErrorCodesRelatedToSync(serverHTTPFields, response))) {
            String umpHaltError = response.header("X-UNVIRED-HALTED-MESSAGE", "");
            String error = umpHaltError == null || umpHaltError.isEmpty() ? "UMP server error: " + response.header("X_UNVIRED_SYSTEM_ERROR", "") : umpHaltError;
            return new HTTPResponse(0, serverHTTPFields, error);
        }
        byte[] responseBytes = null;
        try {
            responseBytes = HTTPConnection.getResponseBytesFromHttpResponse(response);
            if (responseBytes == null) {
                return new HTTPResponse(responseCode, serverHTTPFields, "No response from server. Please try later. Technical error - " + responseText);
            }
        }
        catch (IllegalStateException illegalStateException) {
            String error = "IllegalStateException caught while getting input stream from http response: " + illegalStateException.getMessage();
            Logger.e(error, illegalStateException);
            return new HTTPResponse(0, null, error);
        }
        catch (IOException ioException) {
            String error = "IOException caught while getting input stream from http response: " + ioException.getMessage();
            Logger.e(error, ioException);
            return new HTTPResponse(0, null, error);
        }
        catch (ApplicationException e) {
            String error = "ApplicationException while reading bytes from inputstream. Exception: " + e.getMessage() + " Response code: " + responseCode;
            Logger.e(error, e);
            return new HTTPResponse(0, null, error);
        }
        return new HTTPResponse(responseCode, serverHTTPFields, responseBytes);
    }

    private static OkHttpClient getOkHttpClient() {
        OkHttpClient.Builder client = new OkHttpClient.Builder();
        try {
            UserSettingsManager userSettingsManager;
            int connectionTimeOut;
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            if (!Strings.isNullOrEmpty((String)LoginParameters.getSSLCert())) {
                ByteArrayInputStream certInputStream = new ByteArrayInputStream(LoginParameters.getSSLCert().getBytes());
                Certificate ca = CertificateFactory.getInstance("X.509").generateCertificate(certInputStream);
                trustStore.setCertificateEntry("ca", ca);
                String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
                tmf.init(trustStore);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, tmf.getTrustManagers(), null);
                client.sslSocketFactory(sslContext.getSocketFactory());
            }
            if ((connectionTimeOut = (userSettingsManager = UserSettingsManager.getInstance()).getConnectionTimeout()) > 0) {
                client.connectTimeout((long)connectionTimeOut, TimeUnit.SECONDS);
                client.readTimeout((long)connectionTimeOut, TimeUnit.SECONDS);
            }
        }
        catch (Exception exception) {
            Logger.e("Exception caught while creating http client, ", exception);
        }
        return client.build();
    }

    private static void updateOkHttpClientConnectionCallbackMap(ISyncFrameworkCallback callback, Call call) {
        try {
            boolean isContains = okHttpConnectionCallbackMap.containsKey(callback);
            if (!isContains) {
                okHttpConnectionCallbackMap.put(callback, call);
            }
        }
        catch (Exception ex) {
            String error = "Exception while adding Callback entry in OkHttpConnectionCallbackMap Hashtable. Exception: " + ex.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "updateOkHttpClientConnectionCallbackMap", error);
        }
    }

    public static void updateAppFrameworkCallbackMap(ISyncAppCallback appCallback, ISyncFrameworkCallback frameworkCallback) {
        try {
            boolean isContains = appFrameworkCallbackMap.containsKey(appCallback);
            if (!isContains) {
                appFrameworkCallbackMap.put(appCallback, frameworkCallback);
            }
        }
        catch (Exception ex) {
            String error = "Exception while adding Callback entry in appFrameworkCallbackMap Hashtable. Exception: " + ex.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "updateAppFrameworkCallbackMap", error);
        }
    }

    protected static RequestBody getRequestBodyFromParameters(List<NameValuePair> nameValuePairs) {
        FormBody.Builder formEncoding = new FormBody.Builder();
        if (nameValuePairs == null || nameValuePairs.isEmpty()) {
            return formEncoding.build();
        }
        for (NameValuePair pair : nameValuePairs) {
            try {
                String key = pair.getName() == null ? "" : pair.getName();
                String value = pair.getValue() == null ? "" : pair.getValue();
                formEncoding.add(key, value);
            }
            catch (Exception ex) {
                Logger.log(8, HTTPConnection.class.getName(), "getRequestBodyFromParameters", "Error while adding Post parameter. Skipping this parameter." + ex.getLocalizedMessage());
            }
        }
        return formEncoding.build();
    }

    public static void sendWipeConfirmation(String wipeUrl) {
        if (wipeUrl == null) {
            Logger.log(7, HTTPConnection.class.getName(), "sendWipeConfirmation", "Cannot inform server after wipe. URL null. ");
            return;
        }
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage()) {
            return;
        }
        Request request = new Request.Builder().url(wipeUrl).build();
        OkHttpClient client = HTTPConnection.getOkHttpClient();
        Call call = client.newCall(request);
        Response response = null;
        try {
            response = call.execute();
            int responseCode = response.code();
            String responseText = responseCode + ": " + NetworkUtil.getResponseText(responseCode);
            Logger.log(7, HTTPConnection.class.getName(), "sendWipeConfirmation", "Posting response: " + responseText);
            if (responseCode == 200) {
                Logger.log(7, HTTPConnection.class.getName(), "sendWipeConfirmation", "Informing server about wipe successful: " + responseCode);
            } else {
                Logger.log(7, HTTPConnection.class.getName(), "sendWipeConfirmation", "Informing server about wipe unsuccessful: " + responseCode);
            }
        }
        catch (ClientProtocolException clientProtocolException) {
            Logger.log(8, HTTPConnection.class.getName(), "sendWipeConfirmation", "ClientProtocolException caught while executing http post, " + clientProtocolException.getMessage());
        }
        catch (IOException ioException) {
            Logger.log(8, HTTPConnection.class.getName(), "sendWipeConfirmation", "IOException caught while executing http post, " + ioException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.log(8, HTTPConnection.class.getName(), "sendWipeConfirmation", "IllegalArgumentException caught while creating http post object, " + illegalArgumentException.getMessage());
        }
    }

    private static Hashtable<String, String> getHTTPServerFields(Response httpConnection) throws IOException {
        String conversationId = httpConnection.header("X-UNVIRED-CONVERSATION-ID", "");
        String serverId = httpConnection.header("X-UNVIRED-SERVER-ID", "");
        String feUserId = httpConnection.header("X-UNVIRED-FE-USER-ID", "");
        String applicationId = httpConnection.header("X-UNVIRED-APPLICATION-ID", "");
        String applicationName = httpConnection.header("X-UNVIRED-APPLICATION-NAME", "");
        String messageType = httpConnection.header("X-UNVIRED-MESSAGE-TYPE", "");
        String messageSubType = httpConnection.header("X-UNVIRED-MESSAGE-SUB-TYPE", "");
        String numberOfPendingMessages = httpConnection.header("X-UNVIRED-NUMBER-OF-PENDING-MESSAGES", "");
        String requestType = httpConnection.header("REQUEST_TYPE", "");
        String unviredPassword = httpConnection.header("X-UNVIRED-NEW-PASSWORD", "");
        String errorCode = httpConnection.header("X_UNVIRED_SYSTEM_ERROR", "");
        String umpHaltMessage = httpConnection.header("X-UNVIRED-HALTED-MESSAGE", "");
        Hashtable<String, String> serverFields = new Hashtable<String, String>();
        if (errorCode != null) {
            serverFields.put("X_UNVIRED_SYSTEM_ERROR", errorCode);
        }
        if (conversationId != null) {
            serverFields.put("X-UNVIRED-CONVERSATION-ID", conversationId);
        }
        if (serverId != null) {
            serverFields.put("X-UNVIRED-SERVER-ID", serverId);
        }
        if (feUserId != null) {
            serverFields.put("X-UNVIRED-FE-USER-ID", feUserId);
        }
        if (applicationId != null) {
            serverFields.put("X-UNVIRED-APPLICATION-ID", applicationId);
        }
        if (applicationName != null) {
            serverFields.put("X-UNVIRED-APPLICATION-NAME", applicationName);
        }
        if (messageType != null) {
            serverFields.put("X-UNVIRED-MESSAGE-TYPE", messageType);
        }
        if (messageSubType != null) {
            serverFields.put("X-UNVIRED-MESSAGE-SUB-TYPE", messageSubType);
        }
        if (numberOfPendingMessages != null) {
            serverFields.put("X-UNVIRED-NUMBER-OF-PENDING-MESSAGES", numberOfPendingMessages);
        }
        if (requestType != null) {
            serverFields.put("REQUEST_TYPE", requestType);
        }
        if (unviredPassword != null) {
            serverFields.put("X-UNVIRED-NEW-PASSWORD", unviredPassword);
        }
        if (umpHaltMessage != null) {
            serverFields.put("X-UNVIRED-HALTED-MESSAGE", umpHaltMessage);
        }
        Logger.i("HTTPConnection httpServerFields: " + serverFields);
        if (serverFields.size() > 0) {
            return serverFields;
        }
        return null;
    }

    public static long getSentDataSize() {
        return dataSentSize;
    }

    public static FileResponse downloadAttachment(AttachmentItem attachmentItem, String connectionUrl, String guid, boolean requiredUNIPostParameters) {
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage(true)) {
            return new FileResponse(0, "No Coverage. Please try later.");
        }
        if (Strings.isNullOrEmpty((String)connectionUrl)) {
            Logger.log(8, HTTPConnection.class.getCanonicalName(), "attachmentDownload", "Invalid URL: " + connectionUrl);
            return new FileResponse(0, "Invalid URL: " + connectionUrl);
        }
        List<NameValuePair> nameValuePairs = HTTPConnection.getAttachmentParameters();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("ACTION", "DOWNLOAD_ATTACHMENT"));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("GUID", guid));
        try {
            if (Strings.isNullOrEmpty((String)FrameworkSettingsManager.getInstance().getActId())) {
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-DEVICE-STATE", FrameworkHelper.getDeviceState()));
            }
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
        }
        RequestBody formBody = HTTPConnection.getRequestBodyFromParameters(nameValuePairs);
        Request request = new Request.Builder().url(connectionUrl).addHeader("Accept-Encoding", "gzip").post(formBody).build();
        OkHttpClient client = HTTPConnection.getOkHttpClient();
        Call call = client.newCall(request);
        Response response = null;
        try {
            response = call.execute();
        }
        catch (Exception exception) {
            String error = "Exception caught while executing http post: " + exception.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "postToServer", error);
            return new FileResponse(0, error);
        }
        int responseCode = response.code();
        String responseText = responseCode + ": " + NetworkUtil.getResponseText(responseCode);
        Logger.log(7, HTTPConnection.class.getName(), "attachmentDownload", "Posting response: " + responseText);
        if (responseCode != 200) {
            return new FileResponse(responseCode, "Cannot connect to server. Please try later. Technical error - " + responseText);
        }
        Hashtable<String, String> serverHTTPFields = null;
        String fileStatus = null;
        try {
            serverHTTPFields = HTTPConnection.getHTTPServerFields(response);
            fileStatus = response.header("X_ATTACHMENT_STATUS", "");
        }
        catch (IOException e) {
            String error = "IOException caught while getting http header fields: " + e.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "attachmentDownload", error);
            return new FileResponse(responseCode, error);
        }
        FileResponse fileResponse = null;
        try {
            if (FileResponse.FILE_RESPONSE_STATUS.SUCCESS.toString().equals(fileStatus)) {
                fileResponse = HTTPConnection.saveAttachmentResponseToFile(responseCode, response, attachmentItem);
            } else if (FileResponse.FILE_RESPONSE_STATUS.ERROR.toString().equals(fileStatus)) {
                fileResponse = new FileResponse(responseCode, responseText);
                fileResponse.setFileStatus(FileResponse.FILE_RESPONSE_STATUS.ERROR);
            } else {
                fileResponse = new FileResponse(responseCode, responseText);
                fileResponse.setFileStatus(FileResponse.FILE_RESPONSE_STATUS.WAIT);
            }
        }
        catch (IllegalStateException illegalStateException) {
            String error = "IllegalStateException caught while getting input stream from http response: " + illegalStateException.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "downloadAttachment", error);
            return new FileResponse(0, error);
        }
        catch (IOException ioException) {
            String error = "IOException caught while getting input stream from http response: " + ioException.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "downloadAttachment", error);
            return new FileResponse(0, error);
        }
        catch (ApplicationException e) {
            String error = "ApplicationException while reading bytes from inputstream. Exception: " + e.getMessage() + " Response code: " + responseCode;
            Logger.log(8, HTTPConnection.class.getName(), "downloadAttachment", error);
            return new FileResponse(0, error);
        }
        return fileResponse;
    }

    private static List<NameValuePair> getAttachmentParameters() {
        String unviredUserId = null;
        String unviredPassword = null;
        FrameworkSettingsManager frameworkSettingsManager = null;
        String feUserId = null;
        String serverId = null;
        String companyAlias = null;
        String oneTimeSecret = null;
        String[] passcodeAndTime = null;
        String companyNamespace = null;
        try {
            UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
            frameworkSettingsManager = FrameworkSettingsManager.getInstance();
            unviredUserId = userSettingsManager.getUnviredUserId();
            unviredPassword = userSettingsManager.getUnviredPassword();
            feUserId = frameworkSettingsManager.getFrontEndUserId();
            serverId = frameworkSettingsManager.getServerId();
            companyAlias = frameworkSettingsManager.getCompanyAlias();
            oneTimeSecret = frameworkSettingsManager.getOneTimeSecret();
            companyNamespace = frameworkSettingsManager.getNamespace();
            passcodeAndTime = PasscodeGenerator.computePin(oneTimeSecret, feUserId);
            if (userSettingsManager.getLoginType() == LoginParameters.LOGIN_TYPE.UNVIRED_ID || userSettingsManager.getLoginType() == LoginParameters.LOGIN_TYPE.EMAIL) {
                unviredPassword = unviredPassword == null || unviredPassword.isEmpty() ? userSettingsManager.getMD5Password() : MD5Encryption.generateKey(unviredPassword);
            }
            unviredPassword = MD5Encryption.generateKey(unviredPassword + passcodeAndTime[1]);
        }
        catch (DBException dbException) {
            Logger.log(8, HTTPConnection.class.getName(), "getAttachmentParameters", "DBException caught while getting framework settings from database, " + dbException.getMessage());
        }
        catch (ApplicationException e) {
            Logger.log(8, HTTPConnection.class.getName(), "getAttachmentParameters", "ApplicationException caught while getting framework settings from database, " + e.getMessage());
        }
        String applicationName = ApplicationManager.getInstance().getApplicationName();
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("MUSID", unviredUserId));
        parameters.add((NameValuePair)new BasicNameValuePair("PWD", unviredPassword));
        parameters.add((NameValuePair)new BasicNameValuePair("APPLICATION", applicationName));
        parameters.add((NameValuePair)new BasicNameValuePair("FEUSERID", feUserId));
        parameters.add((NameValuePair)new BasicNameValuePair("SERVER_ID", serverId));
        parameters.add((NameValuePair)new BasicNameValuePair("COMPANY_ALIAS", companyAlias));
        parameters.add((NameValuePair)new BasicNameValuePair("COMPANY_NAMESPACE", companyNamespace));
        parameters.add((NameValuePair)new BasicNameValuePair("ONE_TIME_TOKEN", passcodeAndTime[0]));
        parameters.add((NameValuePair)new BasicNameValuePair("X-UNVIRED-MESSAGE-TIME", passcodeAndTime[1]));
        return parameters;
    }

    public static AttachmentResponse uploadAttachment(AttachmentItem item, boolean isAsyncUpload, boolean isUpdateItemOnSuccess, String attachmentServiceAction) throws ApplicationException, DBException {
        AttachmentResponse attachmentResponse = HTTPConnection.uploadAttachmentFile(URLService.getAttachmentMessageURL(), item, attachmentServiceAction);
        if (!isUpdateItemOnSuccess) {
            return attachmentResponse;
        }
        Logger.i("*****Upload Attachment******* " + item.getFileName() + " STATUS:" + attachmentResponse.getStatus() + " GUID: " + attachmentResponse.getGUID());
        if ("SUCCESS".equalsIgnoreCase(attachmentResponse.getStatus())) {
            try {
                if (Strings.isNullOrEmpty((String)attachmentResponse.getGUID())) {
                    return attachmentResponse;
                }
                item.setAttachmentStatus(AttachmentItem.ATTACHMENT_ITEM_STATUS.UPLOADED);
                item.setUid(attachmentResponse.getGUID());
                if (isAsyncUpload) {
                    item.setSyncStatus(IDataStructure.SYNC_STATUS.QUEUED);
                }
                String fileNameWithUid = Attachment.renameFile(item.getFileName(), Attachment.setFileNameWithUid(item));
                item.setLocalPath(fileNameWithUid);
                ApplicationManager.getInstance().getDataManager().insertOrUpdateBasedOnGID(item);
                Logger.log(7, HTTPConnection.class.getName(), "uploadAttachment", "status is: " + attachmentResponse.getStatus());
                return attachmentResponse;
            }
            catch (Exception e) {
                Logger.log(8, HTTPConnection.class.getName(), " uploadAttachment ", "Failed while updating attachmentItem after upload");
                return new AttachmentResponse(attachmentResponse.getResponseCode(), "Failed while updating Attachment Item after upload" + e.getMessage());
            }
        }
        return new AttachmentResponse(attachmentResponse.getResponseCode(), "AttachmentStatus is null");
    }

    private static AttachmentResponse postAttachmentToServer(String connectionUrl, List<NameValuePair> nameValuePairs, RequestBody fileBody, String fileName) {
        try {
            if (Strings.isNullOrEmpty((String)FrameworkSettingsManager.getInstance().getActId())) {
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("X-DEVICE-STATE", FrameworkHelper.getDeviceState()));
            }
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
        }
        if (!NetworkUtil.isEmulator() && !NetworkUtil.hasCoverage(true)) {
            return new AttachmentResponse(0, null, "No Coverage. Please try later.");
        }
        if (Strings.isNullOrEmpty((String)connectionUrl)) {
            Logger.log(8, HTTPConnection.class.getCanonicalName(), "postToServer", "Invalid URL: " + connectionUrl);
            return new AttachmentResponse(0, null, "Invalid URL: " + connectionUrl);
        }
        MultipartBody.Builder multiPartBuilder = new MultipartBody.Builder();
        multiPartBuilder.setType(MultipartBody.FORM);
        try {
            for (int index = 0; index < nameValuePairs.size(); ++index) {
                if ("file".equalsIgnoreCase(nameValuePairs.get(index).getName())) {
                    multiPartBuilder = multiPartBuilder.addFormDataPart("file", fileName, fileBody);
                    continue;
                }
                String name = nameValuePairs.get(index).getName();
                String value = nameValuePairs.get(index).getValue();
                multiPartBuilder = multiPartBuilder.addFormDataPart(name, URLEncoder.encode(value, Charsets.UTF_8.toString()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.log(8, HTTPConnection.class.getName(), "postAttachmentToServer", "Exception: " + ex.getMessage());
        }
        MultipartBody formBody = multiPartBuilder.build();
        Request request = new Request.Builder().url(connectionUrl).post((RequestBody)formBody).build();
        OkHttpClient client = HTTPConnection.getOkHttpClient();
        Call call = client.newCall(request);
        Response response = null;
        try {
            response = call.execute();
        }
        catch (Exception exception) {
            String error = "Exception caught while executing http post: " + exception.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "postToServer", error);
            return new AttachmentResponse(0, null, error);
        }
        int responseCode = response.code();
        String responseText = responseCode + ": " + NetworkUtil.getResponseText(responseCode);
        Logger.log(7, HTTPConnection.class.getName(), "postAttachmentToServer", "Posting response: " + responseText);
        if (responseCode != 200) {
            return new AttachmentResponse(responseCode, null, "Cannot connect to server. Please try later. Technical error - " + responseText);
        }
        Hashtable<String, String> serverHTTPFields = null;
        try {
            serverHTTPFields = HTTPConnection.getHTTPServerFields(response);
            String status = response.header("X_ATTACHMENT_STATUS", "");
            String guid = response.header("X_ATTACHMENT_GUID", "");
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, HTTPConnection.class.getName(), "postAttachmentToServer", "Attachment Send Response Status: " + status);
                Logger.log(9, HTTPConnection.class.getName(), "postAttachmentToServer", "Attachment Send Response GUID: " + guid);
            }
            if (status != null) {
                if (serverHTTPFields == null) {
                    serverHTTPFields = new Hashtable();
                }
                serverHTTPFields.put("X_ATTACHMENT_STATUS", status);
            }
            if (guid != null) {
                if (serverHTTPFields == null) {
                    serverHTTPFields = new Hashtable();
                }
                serverHTTPFields.put("X_ATTACHMENT_GUID", guid);
            }
        }
        catch (IOException e) {
            String error = "IOException caught while getting http header fields: " + e.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "postAttachmentToServer", error);
            return new AttachmentResponse(0, null, error);
        }
        byte[] responseBytes = null;
        try {
            responseBytes = HTTPConnection.getResponseBytesFromHttpResponse(response);
            if (responseBytes == null) {
                return new AttachmentResponse(responseCode, serverHTTPFields, "No response from server. Please try later. Technical error - " + responseText);
            }
        }
        catch (IllegalStateException illegalStateException) {
            String error = "IllegalStateException caught while getting input stream from http response: " + illegalStateException.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "postAttachmentToServer", error);
            return new AttachmentResponse(0, null, error);
        }
        catch (IOException ioException) {
            String error = "IOException caught while getting input stream from http response: " + ioException.getMessage();
            Logger.log(8, HTTPConnection.class.getName(), "postAttachmentToServer", error);
            return new AttachmentResponse(0, null, error);
        }
        catch (ApplicationException e) {
            String error = "ApplicationException while reading bytes from inputstream. Exception: " + e.getMessage() + " Response code: " + responseCode;
            Logger.log(8, HTTPConnection.class.getName(), "postAttachmentToServer", error);
            return new AttachmentResponse(0, null, error);
        }
        return new AttachmentResponse(responseCode, serverHTTPFields, responseBytes);
    }

    private static AttachmentResponse uploadAttachmentFile(String connectionUrl, AttachmentItem item, String attachmentServiceAction) {
        String filePath = item.getLocalPath();
        String fileName = item.getFileName();
        MediaType MEDIA_TYPE_MARKDOWN = MediaType.parse((String)"text/x-markdown; charset=utf-8");
        File myFile = new File(filePath);
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE_MARKDOWN, (File)myFile);
        String mimeType = item.getMimeType();
        String lid = String.valueOf(item.getLid());
        List<NameValuePair> nameValuePairs = HTTPConnection.getAttachmentParameters();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("ACTION", attachmentServiceAction));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("X_ATTACHMENT_GUID", item.getUid().toString()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("URL", ""));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("EXTERNAL_REFERENCE", lid));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("MIME_TYPE", mimeType));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("file", ""));
        AttachmentResponse attachmentResponse = HTTPConnection.postAttachmentToServer(connectionUrl, nameValuePairs, requestBody, fileName);
        if (attachmentResponse.getResponseStatus() == ISyncResponse.RESPONSE_STATUS.SUCCESS) {
            Hashtable<String, String> serverFields = attachmentResponse.getServerFields();
            if (serverFields != null) {
                String status = serverFields.get("X_ATTACHMENT_STATUS");
                String guid = serverFields.get("X_ATTACHMENT_GUID");
                return new AttachmentResponse(attachmentResponse.getResponseCode(), attachmentResponse.getResponseBytes(), status, guid);
            }
            Logger.log(8, HTTPConnection.class.getName(), "uploadAttachmentFile", "Response server fields is null");
            return new AttachmentResponse(attachmentResponse.getResponseCode(), "Response server fields is null");
        }
        Logger.log(8, HTTPConnection.class.getName(), "uploadAttachmentFile", "ResponseStatus is null");
        return new AttachmentResponse(attachmentResponse.getResponseCode(), "ResponseStatus is null");
    }

    private static byte[] getResponseBytesFromHttpResponse(Response response) throws IllegalStateException, IOException, ApplicationException {
        InputStream inputStream = null;
        byte[] responseBytes = null;
        InputStream instream = null;
        ResponseBody responseBody = response.body();
        instream = responseBody.byteStream();
        String contentEncoding = response.header("Content-Encoding", "");
        if ("gzip".equalsIgnoreCase(contentEncoding)) {
            instream = new GZIPInputStream(instream);
        }
        if ((inputStream = instream) == null) {
            return null;
        }
        responseBytes = FrameworkHelper.getBytes(inputStream);
        try {
            responseBody.close();
        }
        catch (Exception e) {
            Logger.log(8, HTTPConnection.class.getSimpleName(), "getResponseBytesFromHttpResponse", "Error while closing Http Call." + e.getMessage());
        }
        return responseBytes;
    }

    private static FileResponse saveAttachmentResponseToFile(int responseCode, Response response, AttachmentItem attachmentItem) throws IllegalStateException, IOException, ApplicationException {
        String localPath;
        FileResponse fileResponse = null;
        InputStream inputStream = response.body().byteStream();
        if (inputStream == null) {
            return new FileResponse(responseCode, "Input stream is null. Cannot process further.");
        }
        String contentEncoding = response.header("Content-Encoding", "");
        if ("gzip".equalsIgnoreCase(contentEncoding)) {
            inputStream = new GZIPInputStream(inputStream);
        }
        if ((localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.ATTACHMENT_FOLDER)) == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "saveAttachmentResponseToFile", "Cannot get local path to save attachment files. BE Name :" + attachmentItem.getBEName() + " lid: " + attachmentItem.getLid());
            return new FileResponse(responseCode, "Cannot get local path to save attachment files.");
        }
        String uid = attachmentItem.getUid();
        String attachmentFileName = attachmentItem.getFileName();
        String fileName = null;
        String fileExtension = null;
        String fileNameToBeSavedAs = null;
        if (attachmentFileName == null) {
            Logger.log(8, "AttachmentDownloader", "saveFile", "File name is empty. Saving the file only with th e UID");
            fileName = uid;
            fileExtension = "";
        } else if (attachmentFileName.lastIndexOf(".") == -1) {
            fileName = attachmentFileName;
            fileExtension = "";
            Logger.log(8, "AttachmentDownloader", "saveFile", "File name has no extension in it's name. Saving the file without ext name");
        } else {
            fileName = attachmentFileName.substring(0, attachmentFileName.lastIndexOf("."));
            fileExtension = attachmentFileName.substring(attachmentFileName.lastIndexOf(".") + 1);
        }
        fileNameToBeSavedAs = !fileName.startsWith(uid) ? uid + "_" + fileName + "." + fileExtension : fileName + "." + fileExtension;
        attachmentItem.setFileName(fileNameToBeSavedAs);
        File file = new File(localPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if ((file = new File(localPath, fileNameToBeSavedAs)).exists()) {
            file.delete();
        }
        file.createNewFile();
        attachmentItem.setLocalPath(file.getPath());
        try {
            ApplicationManager.getInstance().getDataManager().update(attachmentItem);
        }
        catch (DBException e) {
            Logger.log(8, HTTPConnection.class.getName(), "saveAttachmentResponseToFile", "Error while updating Attachment item Local path." + e.getMessage());
        }
        fileResponse = new FileResponse(responseCode, file);
        FrameworkHelper.saveInputStreamToFile(inputStream, fileResponse);
        return fileResponse;
    }

    private static RequestBody gzip(final RequestBody body) {
        return new RequestBody(){

            public MediaType contentType() {
                return body.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));
                body.writeTo(gzipSink);
                gzipSink.close();
            }
        };
    }

    public static void trustOurHosts() throws Exception {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        ModifiedX509TrustManager.isAlreadyTrusted = true;
        OkHttpClient client = builder.build();
        if (Strings.isNullOrEmpty((String)LoginParameters.getUrl())) {
            LoginParameters.setUrl(URLService.getMessageURL());
        }
        Request request = new Request.Builder().url(LoginParameters.getUrl()).build();
        Call call = client.newCall(request);
        try {
            call.execute();
        }
        catch (Exception e) {
            ModifiedX509TrustManager.isAlreadyTrusted = false;
            ModifiedHostNameVerifier modifiedHostNameVerifier = new ModifiedHostNameVerifier(LoginParameters.getContext());
            ModifiedX509TrustManager mod509 = new ModifiedX509TrustManager();
            TrustManager[] trustOurCerts = new TrustManager[]{mod509};
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustOurCerts, new SecureRandom());
            builder.socketFactory((SocketFactory)sc.getSocketFactory());
            builder.hostnameVerifier((HostnameVerifier)modifiedHostNameVerifier);
            client = builder.build();
            request = new Request.Builder().url(LoginParameters.getUrl()).build();
            call = client.newCall(request);
            call.execute();
        }
    }

    protected static void clearCertificate() {
        if (!RuntimeEngine.isFrameworkInitialized()) {
            return;
        }
        try {
            SharedPreferences sharedPrefs = LoginParameters.getContext().getSharedPreferences("SSL_CERTIFICATE", 0);
            SharedPreferences.Editor editor = sharedPrefs.edit();
            editor.remove("SSL_CERTIFICATE");
            editor.commit();
            LoginParameters.setSSLCert(null);
        }
        catch (Exception e) {
            Logger.log(8, HTTPConnection.class.getName(), "clearCertificate", "Exception while clearing Certificate " + e.getMessage());
        }
    }

    public static HTTPResponse ping() {
        try {
            SharedPreferences sharedPrefs;
            String certificate;
            if (Strings.isNullOrEmpty((String)LoginParameters.getUrl())) {
                Logger.e("Invalid URL: " + LoginParameters.getUrl());
                return new HTTPResponse(0, null, "Invalid URL: " + LoginParameters.getUrl());
            }
            String url = LoginParameters.getUrl() + "/API/v2/ping";
            Logger.i("Ping call to server. URL: " + url);
            if (url.toLowerCase().contains("https") && !Strings.isNullOrEmpty((String)(certificate = (sharedPrefs = LoginParameters.getContext().getSharedPreferences("SSL_CERTIFICATE", 0)).getString("SSL_CERTIFICATE", "")))) {
                LoginParameters.setSSLCert(certificate);
            }
            HTTPResponse response = HTTPConnection.postToServer(url, null);
            Logger.i("HTTPConnection Ping Response: " + response.getResponseCode() + ", " + response.getErrorMessage());
            return response;
        }
        catch (Exception e) {
            Logger.e("Exception caught in getMessage ", e);
            return new HTTPResponse(0, null, "Exception: " + e.getMessage());
        }
    }

    public static class MySSLSocketFactory
    extends SSLSocketFactory {
        SSLContext sslContext = SSLContext.getInstance("TLS");

        public MySSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(truststore);
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            this.sslContext.init(null, new TrustManager[]{tm}, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }
}

