/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.out;

import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.OutObject;
import com.unvired.model.StructureMeta;
import com.unvired.sync.SyncConstants;
import com.unvired.sync.out.AttachmentOutbox;
import com.unvired.sync.out.DataSender;
import com.unvired.utils.FrameworkHelper;

public class Outbox {
    private static Outbox outbox = null;
    private IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();

    private Outbox() {
    }

    public static Outbox getInstance() {
        if (outbox == null) {
            outbox = new Outbox();
        }
        if (Outbox.outbox.frameworkDataManager == null) {
            Outbox.outbox.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        }
        return outbox;
    }

    public static void destroy() {
        if (outbox != null) {
            Outbox.outbox.frameworkDataManager = null;
            outbox = null;
            Logger.log(7, Outbox.class.getName(), "destroy", "Destroyed");
        } else {
            Logger.log(7, Outbox.class.getName(), "destroy", "Destroy not required. Already null.");
        }
    }

    public void add(OutObject outObject) throws DBException, ApplicationException {
        if (outObject == null) {
            Logger.log(8, this.getClass().getName(), "add", "OutObject cannot be null.");
            return;
        }
        int messageType = outObject.getMessageType();
        String requestType = outObject.getRequestType();
        String beName = outObject.getBEName();
        String beLid = outObject.getBELid();
        if (messageType == 8000 && SyncConstants.MESSAGE_REQUEST_TYPE.RQST.toString().equalsIgnoreCase(requestType)) {
            if (beName == null) {
                throw new ApplicationException(this.getClass().getName(), "add", "BE cannot be null");
            }
            if (beLid == null) {
                throw new ApplicationException(this.getClass().getName(), "add", "BE LID cannot be null");
            }
            IDataStructure[] dataStructures = null;
            try {
                ApplicationManager applicationManager = ApplicationManager.getInstance();
                IDataManager dataManager = applicationManager.getDataManager();
                StructureMeta structureMeta = applicationManager.getHeaderStructureMeta(beName);
                String structureName = structureMeta.getStructName();
                String whereClause = "LID='" + beLid + "'";
                dataStructures = dataManager.get(structureName, whereClause);
            }
            catch (DBException dbe) {
                Logger.e("DBException caught while getting business entity from database, BE-NAME: " + beName + ", BE-LID: " + beLid + ", " + dbe.getMessage(), dbe);
                throw dbe;
            }
            if (dataStructures == null || dataStructures.length <= 0) {
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.log(9, this.getClass().getName(), "sendToServerAsync", "No Business Entity got from database, BE-NAME: " + beName + ", BE-LID: " + beLid);
                }
                return;
            }
            IDataStructure dataStructure = dataStructures[0];
            dataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.QUEUED);
            try {
                IDataManager applicationManager = ApplicationManager.getInstance().getDataManager();
                applicationManager.update(dataStructure);
                String[] childrenTableNames = dataStructure.getChildrenTableNames();
                IDataStructure[] items = null;
                if (childrenTableNames != null && childrenTableNames.length > 0) {
                    for (String childrenTableName : childrenTableNames) {
                        if (outObject.isAttachmentByPassRequired()) {
                            if (!childrenTableName.contains("_ATTACHMENT")) {
                                items = applicationManager.getChildren(childrenTableName, dataStructure);
                            }
                        } else {
                            items = applicationManager.getChildren(childrenTableName, dataStructure);
                        }
                        if (items == null || items.length <= 0) continue;
                        for (IDataStructure item : items) {
                            if (item.getObjectStatus() == IDataStructure.OBJECT_STATUS.GLOBAL) continue;
                            item.setSyncStatus(IDataStructure.SYNC_STATUS.QUEUED);
                            applicationManager.update(item);
                        }
                    }
                }
            }
            catch (Exception dbe) {
                Logger.e("DBException caught while updating data structure status to waiting to be sent, " + dbe.getMessage(), dbe);
                throw dbe;
            }
        }
        if (this.frameworkDataManager == null) {
            this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        }
        this.frameworkDataManager.insertOrUpdateBasedOnGID(outObject);
        DataSender dataSender = DataSender.getInstance();
        if (dataSender != null) {
            dataSender.start();
        }
    }

    public void remove(OutObject outObject) throws DBException {
        if (outObject == null) {
            Logger.log(8, this.getClass().getName(), "remove", "OutObject cannot be null.");
            return;
        }
        if (this.frameworkDataManager != null) {
            this.frameworkDataManager.delete(outObject);
        }
    }

    public void remove(String beLid) throws DBException {
        Logger.i("Outbox remove: " + beLid);
        if (beLid == null) {
            Logger.log(8, this.getClass().getName(), "remove", "LID cannot be null");
        }
        String whereClause = OutObject.BE_HEADER_LID + " = '" + beLid + "'";
        if (this.frameworkDataManager != null) {
            this.frameworkDataManager.delete(OutObject.TABLE_NAME, whereClause);
        }
        FrameworkHelper.deleteOutBoxFile(beLid);
    }

    public void resetAll() throws DBException {
        if (this.frameworkDataManager != null) {
            this.frameworkDataManager.delete(OutObject.TABLE_NAME);
        }
    }

    public OutObject getNext() throws DBException {
        String[] orderBy = new String[]{"TIME_STAMP"};
        IDataStructure[] dataStructures = null;
        if (this.frameworkDataManager != null) {
            dataStructures = this.frameworkDataManager.get(OutObject.TABLE_NAME, orderBy, OutObject.class);
        }
        if (dataStructures == null || dataStructures.length == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "getNext", "No outobjects in database");
            }
            return null;
        }
        for (int i = 0; i < dataStructures.length; ++i) {
            OutObject outObject = (OutObject)dataStructures[i];
            if (outObject == null) continue;
            return outObject;
        }
        return null;
    }

    boolean checkForPendingAttachments(OutObject outObject) {
        boolean attachmentOutboxPresent = false;
        try {
            if (ApplicationManager.getInstance().isAttachmentSupported(outObject.getBEName())) {
                attachmentOutboxPresent = AttachmentOutbox.getInstance().isInQueue(outObject.getBELid());
                return attachmentOutboxPresent;
            }
        }
        catch (DBException e) {
            Logger.e("DBException while getting attachment items of a business header: " + e.getMessage());
        }
        catch (ApplicationException e) {
            Logger.e("ApplicationException while getting attachment items of a business header: " + e.getMessage());
        }
        return attachmentOutboxPresent;
    }

    public boolean isInQueue(String beLid) throws DBException {
        if (beLid == null) {
            return false;
        }
        String whereClause = OutObject.BE_HEADER_LID + " = '" + beLid + "'";
        int presentOrNot = 0;
        if (this.frameworkDataManager != null) {
            presentOrNot = this.frameworkDataManager.count(OutObject.TABLE_NAME, whereClause);
        }
        if (presentOrNot == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "isInQueue", "No such outobject present in database, BE LID: " + beLid);
            }
            return false;
        }
        return true;
    }

    public OutObject[] getOutObjects() throws DBException {
        OutObject[] outObjects;
        IDataStructure[] dataStructures = null;
        if (this.frameworkDataManager != null) {
            dataStructures = this.frameworkDataManager.get(OutObject.TABLE_NAME, OutObject.class);
        }
        if ((outObjects = this.outObjectArrayCopy(dataStructures)) == null || outObjects.length == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "getAllOutObjects", "No such outobject present in database.");
            }
            return null;
        }
        return outObjects;
    }

    public boolean hasAnyOutObject() throws DBException {
        IDataStructure[] dataStructures = null;
        OutObject[] outObjects = null;
        if (this.frameworkDataManager != null) {
            dataStructures = this.frameworkDataManager.get(OutObject.TABLE_NAME);
            outObjects = this.outObjectArrayCopy(dataStructures);
        }
        if (outObjects == null) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "hasAnyOutObject", "No outobjects present in database.");
            }
            return false;
        }
        return true;
    }

    public int count() throws DBException {
        if (this.frameworkDataManager != null) {
            return this.frameworkDataManager.count(OutObject.TABLE_NAME, "");
        }
        return 0;
    }

    private OutObject[] outObjectArrayCopy(IDataStructure[] dataStructures) throws DBException {
        if (dataStructures == null || dataStructures.length == 0) {
            return null;
        }
        OutObject[] outObjects = new OutObject[dataStructures.length];
        try {
            System.arraycopy(dataStructures, 0, outObjects, 0, dataStructures.length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.log(8, this.getClass().getName(), "outObjectArrayCopy", indexOutOfBoundsException.getMessage());
            throw new DBException(this.getClass().getName(), "outObjectArrayCopy", indexOutOfBoundsException.getMessage());
        }
        catch (ArrayStoreException arrayStoreException) {
            Logger.log(8, this.getClass().getName(), "outObjectArrayCopy", arrayStoreException.getMessage());
            throw new DBException(this.getClass().getName(), "outObjectArrayCopy", arrayStoreException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            Logger.log(8, this.getClass().getName(), "outObjectArrayCopy", nullPointerException.getMessage());
            throw new DBException(this.getClass().getName(), "outObjectArrayCopy", nullPointerException.getMessage());
        }
        return outObjects;
    }

    public void unlockAllOutObject() {
        if (this.frameworkDataManager != null) {
            try {
                this.frameworkDataManager.execute("UPDATE OUTBOX SET OUT_OBJECT_STATUS = 'NONE'");
                this.frameworkDataManager.execute("UPDATE ATTACHMENT_OUTBOX SET ATTACHMENT_OUT_OBJECT_STATUS = 'NONE'");
            }
            catch (DBException dbe) {
                Logger.log(8, this.getClass().getName(), "unlockAllOutObject", "DBException caught while updating status to NONE for OutObject and AttachmentOutObject" + dbe.getMessage());
            }
        }
    }
}

