/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.out;

import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.login.LoginParameters;
import com.unvired.model.SentItemObject;
import com.unvired.model.StructureMeta;
import com.unvired.sync.in.DataRetrieverService;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class SentItems {
    private static SentItems sentItems = null;
    private IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
    private Timer timer;

    private SentItems() {
    }

    public static SentItems getInstance() {
        if (sentItems == null) {
            sentItems = new SentItems();
        }
        if (SentItems.sentItems.frameworkDataManager == null) {
            SentItems.sentItems.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        }
        return sentItems;
    }

    public static void destroy() {
        if (sentItems != null) {
            SentItems.sentItems.frameworkDataManager = null;
            sentItems = null;
            Logger.log(7, SentItems.class.getName(), "destroy", "Destroyed");
        } else {
            Logger.log(7, SentItems.class.getName(), "destroy", "Destroy not required. Already null.");
        }
    }

    public void add(SentItemObject sentItemObject) throws DBException, ApplicationException {
        if (sentItemObject == null) {
            Logger.log(8, this.getClass().getName(), "add", "SentItemObject cannot be null.");
            return;
        }
        String conversationId = sentItemObject.getConversationId();
        Logger.i("SentItems: SentItemObject conversationId: " + conversationId);
        if (conversationId == null || conversationId.length() <= 0) {
            throw new ApplicationException(this.getClass().getName(), "add", "Conversation Id cannot be empty. Conv Id: " + conversationId);
        }
        String beLid = sentItemObject.getBeHeaderLid();
        String beName = sentItemObject.getBeName();
        if (beLid != null) {
            IDataStructure[] dataStructures = null;
            try {
                IDataManager dataManager = ApplicationManager.getInstance().getDataManager();
                String structureName = this.getHeaderTableNameBasedOnBEName(beName);
                String whereClause = "LID='" + beLid + "'";
                dataStructures = dataManager.get(structureName, whereClause);
            }
            catch (DBException dbe) {
                Logger.e("DBException caught while getting business entity from database, BE-NAME: " + beName + ", BE-LID: " + beLid + ", " + dbe.getMessage(), dbe);
                throw dbe;
            }
            if (dataStructures == null || dataStructures.length <= 0) {
                if (Logger.getDefaultLogLevel() == 9) {
                    Logger.log(9, this.getClass().getName(), "add", "No Business Entity got from database, BE-NAME: " + beName + ", BE-LID: " + beLid);
                }
                return;
            }
            IDataStructure dataStructure = dataStructures[0];
            dataStructure.setSyncStatus(IDataStructure.SYNC_STATUS.SENT);
            try {
                IDataManager applicationManager = ApplicationManager.getInstance().getDataManager();
                applicationManager.update(dataStructure);
                String[] childrenTableNames = dataStructure.getChildrenTableNames();
                if (childrenTableNames != null && childrenTableNames.length > 0) {
                    for (int i = 0; i < childrenTableNames.length; ++i) {
                        IDataStructure[] items = applicationManager.getChildren(childrenTableNames[i], dataStructure);
                        if (items == null || items.length <= 0) continue;
                        for (int j = 0; j < items.length; ++j) {
                            if (items[j].getObjectStatus() != IDataStructure.OBJECT_STATUS.ADD && items[j].getObjectStatus() != IDataStructure.OBJECT_STATUS.MODIFY && items[j].getObjectStatus() != IDataStructure.OBJECT_STATUS.DELETE) continue;
                            items[j].setSyncStatus(IDataStructure.SYNC_STATUS.SENT);
                            applicationManager.update(items[j]);
                        }
                    }
                }
            }
            catch (DBException dbe) {
                Logger.e("DBException caught while updating data structure status to waiting to be sent, " + dbe.getMessage(), dbe);
                throw dbe;
            }
        }
        int presentOrNot = 0;
        String whereClause = SentItemObject.CONVERSATION_ID + " = '" + conversationId + "'";
        if (this.frameworkDataManager != null) {
            presentOrNot = this.frameworkDataManager.count(SentItemObject.TABLE_NAME, whereClause);
        }
        if (presentOrNot != 0) {
            Logger.log(8, this.getClass().getName(), "add", "SentItemObject already present in database with this conversation id: " + conversationId);
        } else if (this.frameworkDataManager != null) {
            SentItemObject sentObj = sentItemObject;
            this.frameworkDataManager.insert(sentObj);
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "add", "SentItemObject inserted successfully in database, conversation id: " + conversationId);
            }
        }
        this.startAutoSyncTimerForGetMessage();
    }

    public void remove(String conversationId) throws DBException {
        Logger.i("SentItems remove: " + conversationId);
        if (conversationId == null || conversationId.length() <= 0) {
            Logger.log(8, this.getClass().getName(), "remove", "Conversation Id cannot be empty. Conversation Id: " + conversationId);
            return;
        }
        String whereClause = SentItemObject.CONVERSATION_ID + " = '" + conversationId + "'";
        if (this.frameworkDataManager != null) {
            this.frameworkDataManager.delete(SentItemObject.TABLE_NAME, whereClause);
            Logger.i("SentItemObject removed successfully from database, conversation id: " + conversationId);
        }
    }

    public void resetAll() throws DBException {
        Logger.i("SentItems: resetAll");
        if (this.frameworkDataManager != null) {
            this.frameworkDataManager.delete(SentItemObject.TABLE_NAME);
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "resetAll", "Deleted all sent items from database.");
            }
        }
    }

    public boolean containsConv(String conversationId) throws DBException {
        if (Strings.isNullOrEmpty((String)conversationId)) {
            return false;
        }
        String whereClause = SentItemObject.CONVERSATION_ID + " = '" + conversationId + "'";
        int count = 0;
        if (this.frameworkDataManager != null) {
            count = this.frameworkDataManager.count(SentItemObject.TABLE_NAME, whereClause);
        }
        if (count == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "contains", "No such sent item present in database, conversaiton id: " + conversationId);
            }
            return false;
        }
        return true;
    }

    public boolean contains(String conversationId, String lid) throws DBException {
        if (Strings.isNullOrEmpty((String)conversationId) || Strings.isNullOrEmpty((String)lid)) {
            return false;
        }
        String whereClause = SentItemObject.CONVERSATION_ID + " = '" + conversationId + "' AND " + SentItemObject.BE_HEADER_LID + " = '" + lid + "'";
        int count = 0;
        if (this.frameworkDataManager != null) {
            count = this.frameworkDataManager.count(SentItemObject.TABLE_NAME, whereClause);
        }
        if (count == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "contains", "No such sent item present in database, conversation id: " + conversationId + ", LID: " + lid);
            }
            return false;
        }
        return true;
    }

    public boolean containsBeLid(String beLid) throws DBException {
        if (Strings.isNullOrEmpty((String)beLid)) {
            return false;
        }
        String whereClause = SentItemObject.BE_HEADER_LID + " = '" + beLid + "'";
        int count = 0;
        if (this.frameworkDataManager != null) {
            count = this.frameworkDataManager.count(SentItemObject.TABLE_NAME, whereClause);
        }
        if (count == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "containsBeLid", "No such sent item present in database, BE_HEADER_LID: " + beLid);
            }
            return false;
        }
        return true;
    }

    public SentItemObject getByBeLid(String beLid) throws DBException {
        if (beLid == null) {
            return null;
        }
        String whereClause = SentItemObject.BE_HEADER_LID + " = '" + beLid + "'";
        IDataStructure[] dataStructures = null;
        SentItemObject[] sentItemObjects = null;
        if (this.frameworkDataManager != null) {
            dataStructures = this.frameworkDataManager.get(SentItemObject.TABLE_NAME, whereClause, SentItemObject.class);
            sentItemObjects = this.sentItemObjectArrayCopy(dataStructures);
        }
        if (sentItemObjects == null || sentItemObjects.length == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "get", "SentItemObject not present in database, LID: " + beLid);
            }
            return null;
        }
        return sentItemObjects[0];
    }

    public SentItemObject getByConvId(String conversationId) throws DBException {
        if (conversationId == null || conversationId.length() <= 0) {
            Logger.e("No SentItem record found as Conversation Id is null or empty." + conversationId);
            return null;
        }
        conversationId = conversationId.trim();
        String whereClause = SentItemObject.CONVERSATION_ID + " = '" + conversationId + "'";
        IDataStructure[] dataStructures = null;
        SentItemObject[] sentItemObjects = null;
        if (this.frameworkDataManager == null) {
            this.frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        }
        if ((dataStructures = this.frameworkDataManager.get(SentItemObject.TABLE_NAME, whereClause, SentItemObject.class)) == null || dataStructures.length == 0) {
            Logger.e("SentItemObject not present in database for Conversation Id: " + conversationId + " where clause: " + whereClause);
            return null;
        }
        try {
            sentItemObjects = this.sentItemObjectArrayCopy(dataStructures);
        }
        catch (Exception e) {
            Logger.e("Exception caught while copying DataStructure to SentItemObjects  array.", e);
        }
        if (sentItemObjects == null || sentItemObjects.length == 0) {
            Logger.e("SentItemObject not present in database for Conversation Id: " + conversationId);
            return null;
        }
        return sentItemObjects[0];
    }

    public String getLID(String conversationId) throws DBException {
        if (conversationId == null || conversationId.length() <= 0) {
            return null;
        }
        String whereClause = SentItemObject.CONVERSATION_ID + " = '" + conversationId + "'";
        IDataStructure[] dataStructures = null;
        SentItemObject[] sentItemObjects = null;
        if (this.frameworkDataManager != null) {
            dataStructures = this.frameworkDataManager.get(SentItemObject.TABLE_NAME, whereClause, SentItemObject.class);
            sentItemObjects = this.sentItemObjectArrayCopy(dataStructures);
        }
        if (sentItemObjects == null || sentItemObjects.length == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "getLID", "SentItemObject not present in database, Conversation Id: " + conversationId);
            }
            return null;
        }
        return sentItemObjects[0].getLid();
    }

    public SentItemObject[] getSentItemObjects() throws DBException {
        SentItemObject[] sentItemObjects;
        IDataStructure[] dataStructures = null;
        if (this.frameworkDataManager != null) {
            dataStructures = this.frameworkDataManager.get(SentItemObject.TABLE_NAME, SentItemObject.class);
        }
        if ((sentItemObjects = this.sentItemObjectArrayCopy(dataStructures)) == null || sentItemObjects.length == 0) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getName(), "getSentItemObjects", "SentItemObject not present in database.");
            }
            return null;
        }
        return sentItemObjects;
    }

    public int count() throws DBException {
        if (this.frameworkDataManager != null) {
            return this.frameworkDataManager.count(SentItemObject.TABLE_NAME, "");
        }
        return 0;
    }

    private SentItemObject[] sentItemObjectArrayCopy(IDataStructure[] dataStructures) throws DBException {
        if (dataStructures == null || dataStructures.length == 0) {
            return null;
        }
        SentItemObject[] sentItemObjects = new SentItemObject[dataStructures.length];
        try {
            System.arraycopy(dataStructures, 0, sentItemObjects, 0, dataStructures.length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.log(8, this.getClass().getName(), "sentItemObjectArrayCopy", indexOutOfBoundsException.getMessage());
            throw new DBException(this.getClass().getName(), "sentItemObjectArrayCopy", indexOutOfBoundsException.getMessage());
        }
        catch (ArrayStoreException arrayStoreException) {
            Logger.log(8, this.getClass().getName(), "sentItemObjectArrayCopy", arrayStoreException.getMessage());
            throw new DBException(this.getClass().getName(), "sentItemObjectArrayCopy", arrayStoreException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            Logger.log(8, this.getClass().getName(), "sentItemObjectArrayCopy", nullPointerException.getMessage());
            throw new DBException(this.getClass().getName(), "sentItemObjectArrayCopy", nullPointerException.getMessage());
        }
        return sentItemObjects;
    }

    private String getHeaderTableNameBasedOnBEName(String beName) throws DBException {
        StructureMeta[] stuctureMetas = null;
        try {
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            stuctureMetas = applicationManager.getStructureMetas(beName);
        }
        catch (DBException e) {
            String error = "Exception while getting structure meta from database. Table Name: " + beName + " Exception: " + e.getMessage();
            throw new DBException(this.getClass().getName(), "getHeaderTableNameBasedOnBEName", error);
        }
        if (stuctureMetas == null || stuctureMetas.length <= 0) {
            throw new DBException(this.getClass().getName(), "getBEName", "Structure meta not found for BE-NAME: " + beName);
        }
        for (int i = 0; i < stuctureMetas.length; ++i) {
            if (!stuctureMetas[i].getIsHeader()) continue;
            return stuctureMetas[i].getStructName();
        }
        return null;
    }

    public void startAutoSyncTimerForGetMessage() {
        try {
            if (LoginParameters.getAutoSyncTime() == 0 || this.count() <= 0) {
                return;
            }
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, this.getClass().getSimpleName(), "startAutoSyncTimerForGetMessage", "AutoSync Timer started at : " + new Date().toString());
            }
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    block6: {
                        try {
                            if (SentItems.this.count() > 0) {
                                if (Logger.getDefaultLogLevel() == 9) {
                                    Logger.log(9, this.getClass().getSimpleName(), "startAutoSyncTimerForGetMessage", "Get message called from Timer at: " + new Date().toString());
                                }
                                DataRetrieverService.getInstance().getMessagesInBackground();
                            } else if (SentItems.this.timer != null) {
                                SentItems.this.timer.cancel();
                                SentItems.this.timer = null;
                            }
                        }
                        catch (DBException e) {
                            Logger.e("Error while checking SenItems count to start AutoSync timer." + e.getMessage(), e);
                            if (SentItems.this.timer == null) break block6;
                            SentItems.this.timer.cancel();
                            SentItems.this.timer = null;
                        }
                    }
                }
            }, 1000L, (long)(LoginParameters.getAutoSyncTime() * 1000));
        }
        catch (Exception ex) {
            if (this.timer != null) {
                this.timer = null;
            }
            Logger.e("Error while running AutoSync timer." + ex.getMessage(), ex);
        }
    }
}

