/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.out;

import android.content.Context;
import android.content.Intent;
import com.google.common.base.Strings;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.core.UserSettingsManager;
import com.unvired.logger.Logger;
import com.unvired.login.LoginParameters;
import com.unvired.sync.out.DataSender;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.ui.ServerErrorMessageActivity;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.UIConstants;
import java.util.Hashtable;
import okhttp3.Response;

public class ServerErrors {
    private static boolean isPasswordChange = false;
    private static boolean isDisplayMessageOnly = false;
    private static boolean isWaitingEmailVerification = false;
    private static Context context;
    private static final MessageHelper MESSAGE_HELPER;

    public static boolean isWaitingEmailVerification() {
        return isWaitingEmailVerification;
    }

    public static void setIsWaitingEmailVerification(boolean isWaitingEmailVerification) {
        ServerErrors.isWaitingEmailVerification = isWaitingEmailVerification;
    }

    public static boolean handleUNIErrorCodesRelatedToSync(Hashtable serverHTTPFields, Response httpConnection) {
        if (serverHTTPFields == null) {
            return false;
        }
        String errorCode = httpConnection.header("X_UNVIRED_SYSTEM_ERROR", "");
        if (Strings.isNullOrEmpty((String)errorCode)) {
            if (isWaitingEmailVerification) {
                isWaitingEmailVerification = false;
            }
            return false;
        }
        DataSender.getInstance().stop();
        int errCode = Integer.parseInt(errorCode);
        Logger.log(7, HTTPConnection.class.getName(), "handleHTTPErrorCodes", "Error Code :" + errCode);
        context = LoginParameters.getContext();
        switch (errCode) {
            case 1: {
                Logger.log(8, ServerErrors.class.getName(), "handleUNIErrorCodes", "UNI Server Code Received. User not found. Code: " + errorCode);
                String message = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.UNI_ERROR_USER_NOT_FOUND);
                ServerErrors.handleApplicationReset(message);
                return true;
            }
            case 2: {
                Logger.log(8, ServerErrors.class.getName(), "handleUNIErrorCodes", "UNI Server Code Received. Device / frontend user not found. Code: " + errorCode);
                String message = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.UNI_ERROR_FE_USER_NOT_FOUND);
                ServerErrors.handleApplicationReset(message);
                return true;
            }
            case 3: {
                Logger.log(8, ServerErrors.class.getName(), "handleUNIErrorCodes", "UNI Server Code Received. User disabled. Code: " + errorCode);
                String message = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.UNI_ERROR_USER_DISABLED);
                ServerErrors.setDisplayMessageOnly(true);
                com.unvired.utils.Context.getInstance().add(UIConstants.MESSAGE_TO_DISPLAY, message);
                Intent intent = new Intent(context, ServerErrorMessageActivity.class);
                context.startActivity(intent);
                return true;
            }
            case 4: {
                if (LoginParameters.getHandlePasswordChanged() && LoginParameters.getPasswordChangeListener() != null) {
                    LoginParameters.getPasswordChangeListener().handlePasswordChange();
                    return true;
                }
                String passwordChangeMsg = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.UNI_ERROR_PASSWORD_RESET);
                ServerErrors.setPasswordChange(true);
                com.unvired.utils.Context.getInstance().add(UIConstants.MESSAGE_TO_DISPLAY, passwordChangeMsg);
                Intent intent = new Intent(context, ServerErrorMessageActivity.class);
                context.startActivity(intent);
                return true;
            }
            case 5: {
                Logger.log(8, ServerErrors.class.getName(), "handleUNIErrorCodes", "UNI Server Code Received. Application undeployed for user. Code: " + errorCode);
                String message = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.UNI_ERROR_APP_UNDEPLOYED);
                ServerErrors.handleApplicationReset(message);
                return true;
            }
            case 6: {
                Logger.log(8, ServerErrors.class.getName(), "handleUNIErrorCodes", "UNI Server Code Received. Application deleted or not found. Code: " + errorCode);
                String message = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.UNI_ERROR_APP_DELETED_OR_NOT_FOUND);
                ServerErrors.handleApplicationReset(message);
                return true;
            }
            case 7: {
                Logger.log(8, ServerErrors.class.getName(), "handleUNIErrorCodes", "UNI Server Code Received. Application not active for user. Code: " + errorCode);
                String message = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.UNI_ERROR_APP_NOT_ACTIVE_FOR_USER);
                ServerErrors.handleApplicationReset(message);
                return true;
            }
            case 10: {
                Logger.log(8, ServerErrors.class.getName(), "handleUNIErrorCodes", "UNI Server Code Received. Invalid Server. Code: " + errorCode);
                String message = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.UNI_ERROR_INCORRECT_SERVER_ID);
                ServerErrors.handleApplicationReset(message);
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                String mobileAppVersionError = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.MOBILE_APP_VERSION_ERROR);
                Logger.log(8, ServerErrors.class.getName(), "handleUNIErrorCodes", "UNI Server Code Received. App version mismatch. Code: " + errorCode);
                ServerErrors.handleApplicationReset(mobileAppVersionError);
                return true;
            }
            case 13: {
                Logger.log(8, ServerErrors.class.getName(), "handleUNIErrorCodes", "UNI Server Code Received. Invalid One Time Token. Code: " + errorCode);
                String message = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.UNI_ERROR_INCORRECT_ONE_TIME_TOKEN);
                ServerErrors.handleApplicationReset(message);
                return true;
            }
            case 14: {
                return true;
            }
            case 15: {
                if (LoginParameters.getHandlePasswordChanged() && LoginParameters.getPasswordChangeListener() != null) {
                    LoginParameters.getPasswordChangeListener().handlePasswordChange();
                    return true;
                }
                String forcedPasswordChangeMsg = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.UNI_ERROR_PASSWORD_RESET);
                ServerErrors.setPasswordChange(true);
                com.unvired.utils.Context.getInstance().add(UIConstants.MESSAGE_TO_DISPLAY, forcedPasswordChangeMsg);
                Intent intent = new Intent(context, ServerErrorMessageActivity.class);
                context.startActivity(intent);
                return true;
            }
            case 16: {
                if (LoginParameters.getHandlePasswordChanged() && LoginParameters.getPasswordChangeListener() != null) {
                    LoginParameters.getPasswordChangeListener().handlePasswordChange();
                    return true;
                }
                String passwordExpiredMsg = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.UNI_ERROR_PASSWORD_RESET);
                ServerErrors.setPasswordChange(true);
                com.unvired.utils.Context.getInstance().add(UIConstants.MESSAGE_TO_DISPLAY, passwordExpiredMsg);
                Intent intent = new Intent(context, ServerErrorMessageActivity.class);
                context.startActivity(intent);
                return true;
            }
            case 17: {
                String emailNotVerified = MESSAGE_HELPER.getValue(ServerErrors.MESSAGE_HELPER.EMAIL_NOT_VERIFIED);
                if (ServerErrorMessageActivity.activity != null) break;
                ServerErrors.setIsWaitingEmailVerification(true);
                com.unvired.utils.Context.getInstance().add(UIConstants.MESSAGE_TO_DISPLAY, emailNotVerified);
                Intent intent = new Intent(context, ServerErrorMessageActivity.class);
                context.startActivity(intent);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleApplicationReset(String message) {
        try {
            UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
            FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
            String userId = userSettingsManager.getUnviredUserId();
            String frontEndUserId = frameworkSettingsManager.getFrontEndUserId();
            if (userId != null && frontEndUserId != null) {
                message = userId + ", " + frontEndUserId + ": " + message;
            }
        }
        catch (Exception e) {
            Logger.log(8, ServerErrors.class.getName(), "handleApplicationReset", "Exception: " + e.getMessage());
        }
        finally {
            ServerErrors.invokeMessageAndResetApplication(message);
        }
    }

    private static void invokeMessageAndResetApplication(String message) {
        Intent intent = new Intent(context, ServerErrorMessageActivity.class);
        intent.setFlags(0x10008000);
        context.startActivity(intent);
        ServerErrors.setPasswordChange(false);
        com.unvired.utils.Context.getInstance().add(UIConstants.MESSAGE_TO_DISPLAY, message);
    }

    public static boolean isPasswordChange() {
        return isPasswordChange;
    }

    public static void setPasswordChange(boolean isPasswordChange) {
        ServerErrors.isPasswordChange = isPasswordChange;
    }

    public static boolean isDisplayMessageOnly() {
        return isDisplayMessageOnly;
    }

    public static void setDisplayMessageOnly(boolean isDisplayMessageOnly) {
        ServerErrors.isDisplayMessageOnly = isDisplayMessageOnly;
    }

    static {
        MESSAGE_HELPER = MessageHelper.getInstance();
    }
}

