/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.response;

import com.unvired.sync.response.ISyncResponse;
import java.util.Hashtable;

public class HTTPResponse
implements ISyncResponse {
    private int httpResponseCode;
    private byte[] responseBytes;
    private String errorMessage;
    private Hashtable<String, String> serverFields;

    public HTTPResponse(int httpResponseCode) {
        this.httpResponseCode = httpResponseCode;
    }

    public HTTPResponse(int httpResponseCode, byte[] responseBytes) {
        this.httpResponseCode = httpResponseCode;
        this.responseBytes = responseBytes;
    }

    public HTTPResponse(int httpResponseCode, String errorMessage) {
        this.httpResponseCode = httpResponseCode;
        this.errorMessage = errorMessage;
    }

    public HTTPResponse(int responseCode, Hashtable<String, String> serverFields, byte[] responseBytes) {
        this.httpResponseCode = responseCode;
        this.responseBytes = responseBytes;
        this.serverFields = serverFields;
    }

    public HTTPResponse(int responseCode, Hashtable<String, String> serverFields, String errorMessage) {
        this.httpResponseCode = responseCode;
        this.serverFields = serverFields;
        this.errorMessage = errorMessage;
    }

    @Override
    public ISyncResponse.RESPONSE_STATUS getResponseStatus() {
        switch (this.httpResponseCode) {
            case 200: {
                return ISyncResponse.RESPONSE_STATUS.SUCCESS;
            }
        }
        return ISyncResponse.RESPONSE_STATUS.FAILURE;
    }

    public int getResponseCode() {
        return this.httpResponseCode;
    }

    public void setResponseCode(int httpResponseCode) {
        this.httpResponseCode = httpResponseCode;
    }

    public byte[] getResponseBytes() {
        return this.responseBytes;
    }

    public void setInputStream(byte[] responseBytes) {
        this.responseBytes = responseBytes;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setServerFields(Hashtable<String, String> serverFields) {
        this.serverFields = serverFields;
    }

    public Hashtable<String, String> getServerFields() {
        return this.serverFields;
    }
}

