/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.sync.ssl;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.support.v7.app.AlertDialog;
import android.widget.Button;
import android.widget.Toast;
import com.unvired.core.RuntimeEngine;
import com.unvired.logger.Logger;
import com.unvired.login.LoginParameters;
import com.unvired.ui.LoginActivity;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.UITheme;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;

public class ModifiedX509TrustManager
implements X509TrustManager {
    private X509TrustManager defaultTrustMgr;
    private static boolean isAccepted = false;
    public static boolean isCertificateDialogOpen = false;
    public static boolean isAlreadyTrusted = true;

    public ModifiedX509TrustManager() {
        TrustManager[] managers = new TrustManager[]{null};
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(ks);
            managers = tmf.getTrustManagers();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < managers.length; ++i) {
            if (!(managers[i] instanceof X509TrustManager)) continue;
            this.defaultTrustMgr = (X509TrustManager)managers[i];
            return;
        }
    }

    public static boolean isCertificateAccepted() {
        return isAccepted;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.defaultTrustMgr.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509Certificate certificate = chain[0];
        try {
            this.defaultTrustMgr.checkServerTrusted(chain, authType);
        }
        catch (Exception ce) {
            if (RuntimeEngine.getInstance().isHTML5Framework()) {
                this.trustCertificate(certificate);
                isAccepted = true;
                this.saveCertificate(certificate);
                isCertificateDialogOpen = false;
            }
            if (LoginParameters.isAutoTrustCertificate()) {
                this.trustCertificate(certificate);
            }
            this.showTrustCertificateDialog(certificate);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustMgr.getAcceptedIssuers();
    }

    private String convertToPem(X509Certificate cert) throws CertificateEncodingException {
        Base64 encoder = new Base64();
        String cert_begin = "-----BEGIN CERTIFICATE-----\n";
        String end_cert = "\n-----END CERTIFICATE-----";
        byte[] derCert = cert.getEncoded();
        String pemCertPre = new String(encoder.encode(derCert));
        String pemCert = cert_begin + pemCertPre + end_cert;
        return pemCert;
    }

    private void trustCertificate(X509Certificate certificate) {
        isCertificateDialogOpen = true;
        Object context = LoginParameters.LOGIN_SCREEN_TYPE.CUSTOM.equals((Object)LoginParameters.getLoginScreenType()) ? LoginParameters.getContext() : LoginActivity.loginActivity;
        if (context != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            String issuedTo = "";
            String from = dateFormat.format(certificate.getNotBefore());
            String to = dateFormat.format(certificate.getNotAfter());
            String issuedBy = "";
            for (String field : certificate.getSubjectDN().toString().split(", ")) {
                if (!field.startsWith("CN=")) continue;
                issuedTo = "Issued to: " + field.substring(3);
                break;
            }
            for (String field : certificate.getIssuerDN().toString().split(", ")) {
                if (!field.startsWith("CN=")) continue;
                issuedBy = "Issued by: " + field.substring(3);
                break;
            }
            String certificateInfo = issuedTo + "\n" + issuedBy + "\n" + "Valid from " + from + " to " + to;
            Logger.i("Trusting Certificate: " + certificateInfo);
            isAccepted = true;
            this.saveCertificate(certificate);
            isCertificateDialogOpen = false;
            Toast.makeText((Context)context, (CharSequence)"We trust the certificate now. Please try again.", (int)1).show();
        } else {
            Toast.makeText((Context)FrameworkHelper.getApplicationContext(), (CharSequence)MessageHelper.getInstance().getValue(MessageHelper.getInstance().SERVER_CERTIFICATE_UPDATED), (int)1).show();
        }
    }

    private void showTrustCertificateDialog(X509Certificate certificate) {
        Object context = LoginParameters.LOGIN_SCREEN_TYPE.CUSTOM.equals((Object)LoginParameters.getLoginScreenType()) ? LoginParameters.getContext() : LoginActivity.loginActivity;
        if (context != null) {
            MessageHelper messageHelper = MessageHelper.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            String issuedTo = "";
            String from = dateFormat.format(certificate.getNotBefore());
            String to = dateFormat.format(certificate.getNotAfter());
            String issuedBy = "";
            for (String field : certificate.getSubjectDN().toString().split(", ")) {
                if (!field.startsWith("CN=")) continue;
                issuedTo = "Issued to: " + field.substring(3);
                break;
            }
            for (String field : certificate.getIssuerDN().toString().split(", ")) {
                if (!field.startsWith("CN=")) continue;
                issuedBy = "Issued by: " + field.substring(3);
                break;
            }
            String certificateInfo = issuedTo + "\n" + issuedBy + "\n" + "Valid from " + from + " to " + to;
            try {
                ((Activity)context).runOnUiThread(new Runnable((Context)context, messageHelper, certificateInfo, certificate){
                    final /* synthetic */ Context val$context;
                    final /* synthetic */ MessageHelper val$messageHelper;
                    final /* synthetic */ String val$certificateInfo;
                    final /* synthetic */ X509Certificate val$certificate;
                    {
                        this.val$context = context;
                        this.val$messageHelper = messageHelper;
                        this.val$certificateInfo = string;
                        this.val$certificate = x509Certificate;
                    }

                    @Override
                    public void run() {
                        Button buttonNegative;
                        AlertDialog.Builder builder = new AlertDialog.Builder(this.val$context);
                        builder.setTitle((CharSequence)this.val$messageHelper.getValue(this.val$messageHelper.CERTIFICATE_TRUST));
                        builder.setMessage((CharSequence)this.val$certificateInfo);
                        builder.setPositiveButton((CharSequence)this.val$messageHelper.getValue(this.val$messageHelper.CERTIFICATE_OK), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                isAccepted = true;
                                ModifiedX509TrustManager.this.saveCertificate(val$certificate);
                                isCertificateDialogOpen = false;
                                dialog.dismiss();
                            }
                        });
                        builder.setNegativeButton((CharSequence)this.val$messageHelper.getValue(this.val$messageHelper.CERTIFICATE_CANCEL), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                isAccepted = false;
                                dialog.dismiss();
                                isCertificateDialogOpen = false;
                            }
                        });
                        AlertDialog dialog = builder.create();
                        dialog.setCancelable(false);
                        dialog.setCanceledOnTouchOutside(false);
                        if (!((Activity)this.val$context).isFinishing()) {
                            dialog.show();
                        }
                        isCertificateDialogOpen = true;
                        Button buttonPositive = dialog.getButton(-1);
                        if (buttonPositive != null) {
                            buttonPositive.setTextColor(UITheme.getColorPrimary());
                        }
                        if ((buttonNegative = dialog.getButton(-2)) != null) {
                            buttonNegative.setTextColor(UITheme.getDividerColor());
                        }
                    }
                });
            }
            catch (Exception e) {
                Logger.log(8, this.getClass().getName(), "showTrustCertificateDialog", e.getMessage());
            }
        }
    }

    private void saveCertificate(X509Certificate certificate) {
        try {
            String certString = this.convertToPem(certificate);
            LoginParameters.setSSLCert(certString);
            SharedPreferences sharedPrefs = LoginParameters.getContext().getSharedPreferences("SSL_CERTIFICATE", 0);
            SharedPreferences.Editor editor = sharedPrefs.edit();
            editor.putString("SSL_CERTIFICATE", certString);
            editor.apply();
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
    }
}

